/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var gatewayUrl;
var apiBaseUrl = "/service";
const rangerLogo = `<svg width="130" height="40" viewBox="0 0 130 40" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M9.04429 30.8607C4.05788 25.6236 2.04114 16.8243 2.4999 10.2231C2.9403 9.24324 3.80565 9.37165 4.70707 8.95082C11.8747 5.60461 14.4645 3.50007 18.2324 3.5C22.0003 3.49993 27.1313 6.99404 32.1666 9.26836C33.1704 9.72178 33.4232 9.24324 33.8534 10.2231C34.7714 17.7162 31.268 26.7302 26.6114 31.0753L27.2073 30.0492C24.2391 33.3793 19.4199 36 18.2324 36C16.0925 36 11.5769 32.6428 8.7732 29.7787C8.75483 30.256 9.04429 29.906 9.04429 30.8607Z" fill="white"/>
        <path d="M15.8591 3.32436C13.9197 3.72736 11.6276 4.78523 8.00063 6.87579C6.41382 7.80773 4.47439 8.81522 3.69357 9.14269C1.93045 9.84792 1.8297 10.125 2.13195 13.7268C2.53495 18.5879 3.66839 23.1469 5.20482 26.2449C6.03601 27.857 7.32057 29.6453 7.67322 29.6453C7.79912 29.6453 8.70586 30.426 9.66302 31.4084C11.5521 33.2975 14.7761 35.5139 16.9674 36.4207L18.3023 37L19.6121 36.4459C21.7278 35.5139 24.9518 33.2723 26.8409 31.4084C27.798 30.426 28.7047 29.6453 28.8307 29.6453C29.1833 29.6453 30.4678 27.857 31.299 26.2449C32.8355 23.1469 33.9689 18.5879 34.3719 13.7268C34.6742 10.125 34.5734 9.84792 32.8103 9.14269C32.0295 8.81522 30.0901 7.80773 28.5032 6.87579C24.7755 4.73486 22.5842 3.75255 20.544 3.29917C18.5542 2.89617 17.8238 2.89617 15.8591 3.32436ZM20.5692 4.48299C22.3575 4.86079 24.0702 5.6416 27.6973 7.73217C29.3596 8.68932 31.1228 9.62124 31.6013 9.77238C33.1377 10.2761 33.3644 10.6539 33.3644 12.4926C33.3644 16.2203 31.9791 22.5928 30.5938 25.4389C29.7626 27.0761 28.2765 29.1667 27.8988 29.1667C27.798 29.1667 26.9416 29.8971 26.0349 30.7787C24.2466 32.4914 21.0478 34.6827 19.3098 35.3376C18.7987 35.5473 18.5126 35.684 18.2031 35.6719C17.9179 35.6607 17.6128 35.5178 17.0933 35.3124C15.4057 34.6576 11.804 32.1892 10.1919 30.552C9.43633 29.7712 8.73104 29.1415 8.57996 29.1415C7.87467 29.1415 5.78413 25.5649 4.92776 22.9202C3.59283 18.7139 2.68607 11.611 3.34095 10.5783C3.4417 10.4272 4.09657 10.0746 4.80182 9.82274C5.50707 9.54564 7.14426 8.68932 8.454 7.93367C14.499 4.38223 16.8918 3.70217 20.5692 4.48299Z" fill="#0E3A53"/>
        <path d="M15.3547 5.16294C13.642 5.69187 12.3071 6.34675 8.30224 8.61363C6.79102 9.49518 5.25458 10.276 4.90195 10.3767C3.81889 10.7042 3.64258 11.0064 3.64258 12.568C3.64258 16.1699 4.90195 21.9378 6.4132 25.2625C7.64737 28.008 12.6597 32.5417 16.5386 34.456C16.5386 34.456 17.8231 35.2872 18.2513 35.2872C18.5922 35.2872 19.687 34.5819 19.687 34.5819C20.493 34.2041 21.7524 33.4736 22.4828 32.9699C24.0696 31.9372 28.7041 27.6805 29.3842 26.6982C30.845 24.4817 32.5074 18.1093 32.7845 13.7267C32.9356 11.1576 32.7593 10.5027 31.8777 10.5027C31.651 10.5027 29.6613 9.49518 27.4447 8.23581C25.2282 7.00162 22.7347 5.74225 21.9035 5.46519C19.7626 4.70956 17.2186 4.60881 15.3547 5.16294ZM10.1913 9.49518C10.4432 9.62114 10.8965 10.1752 11.224 10.679C11.5262 11.2079 11.8285 11.6865 11.8789 11.7368C11.9292 11.8124 12.2063 11.6109 12.5338 11.3087C13.3398 10.5279 14.8258 9.97373 16.2363 9.92337C17.2942 9.87301 17.5712 9.97373 18.3017 10.6538C18.7551 11.082 19.4351 11.5102 19.8129 11.6109C20.4426 11.762 21.5005 12.8955 21.2486 13.1474C21.173 13.1977 20.2663 13.4244 19.2336 13.6511C16.7904 14.1549 14.2717 15.0113 12.2819 15.9935C10.7958 16.7492 10.7203 16.7744 10.5691 16.2958C10.4936 16.0187 10.6447 15.3638 10.947 14.7593C11.2996 14.1045 11.4003 13.6511 11.2492 13.5504C10.8714 13.3237 9.43572 10.2256 9.43572 9.67151C9.43572 9.16772 9.53644 9.14254 10.1913 9.49518ZM25.6816 14.0541C26.0846 14.6838 25.4801 15.5905 23.994 16.5477C23.1377 17.1018 22.3569 17.5551 22.2309 17.5551C22.105 17.5551 21.9035 17.2781 21.7776 16.9255C21.6516 16.5729 21.2486 16.1447 20.8708 15.9935C20.3167 15.7417 19.7878 15.8424 17.0171 16.7492C13.2894 17.9833 12.5589 18.5375 12.7856 19.9228C12.9116 20.7036 12.8612 20.7791 12.1559 20.9303C11.7277 21.0058 10.7455 21.0814 9.93945 21.0814C8.35266 21.0814 7.77333 20.7036 8.05038 19.822C8.52893 18.336 14.574 15.4646 19.8885 14.1801C21.6768 13.7519 25.4549 13.6511 25.6816 14.0541ZM23.1881 18.4619C23.6666 18.6886 24.2207 19.1924 24.4222 19.5954C25.2786 21.2073 24.523 23.6254 23.0369 24.1795C22.1806 24.5069 22.1554 24.7084 22.7347 26.6227C23.0873 27.7057 23.2888 28.0332 23.7674 28.0835C24.1452 28.1591 24.2963 28.285 24.1955 28.5621C24.12 28.7636 24.0445 29.1414 24.0445 29.4185C24.0445 29.8467 23.8429 29.897 22.4324 29.897H20.8205L20.4174 28.1843C19.4603 24.3306 19.5611 24.5573 18.6795 24.658C17.9491 24.7336 17.8483 24.8343 17.5712 25.993C17.143 27.8568 17.1683 28.1339 17.7475 28.1339C18.1757 28.1339 18.2261 28.2347 18.1002 28.814C17.9994 29.217 17.8735 29.5948 17.8231 29.6955C17.7727 29.8214 16.5386 29.897 15.0777 29.897H12.4582L12.6093 29.1918C12.8108 28.3606 12.9368 28.2095 13.5916 28.0835C13.9946 28.008 14.1961 27.4538 14.851 24.6077C15.2792 22.7438 15.7074 20.9051 15.8081 20.5273C15.9593 19.948 15.9089 19.8472 15.4051 19.7717C14.8762 19.6961 14.8258 19.6205 15.0273 18.8649L15.254 18.0589H18.7802C21.5509 18.0589 22.5332 18.1597 23.1881 18.4619Z" fill="url(#paint0_linear_1815_190)"/>
        <path d="M18.7816 20.9807C18.6053 21.6608 18.429 22.4165 18.3282 22.6935C18.2023 23.1217 18.303 23.1469 19.5372 23.0461C20.5195 22.9454 20.9981 22.769 21.3255 22.3409C22.2323 21.2074 21.6782 20.1244 20.1165 19.8977L19.0839 19.7717L18.7816 20.9807Z" fill="#0E3A53"/>
        <path d="M56.8119 17.7401C56.8119 18.5088 56.6461 19.2356 56.3144 19.9206C55.9827 20.6056 55.5121 21.1764 54.9026 21.633C54.2932 22.0821 53.5951 22.337 52.8082 22.3979L54.3009 27.6037H56.0251L55.3887 30.2979H50.9568L49.0359 22.6491H46.5943L45.4372 27.6037H47.0919L46.4323 30.2979H38.6562L39.2927 27.6037H41.0053L43.7709 15.7765H42.0698L42.6831 13.0938H51.2461C52.9972 13.0938 54.3626 13.4971 55.3424 14.3039C56.3221 15.103 56.8119 16.2484 56.8119 17.7401ZM52.2875 17.7173C52.2875 17.1084 52.0946 16.6328 51.7089 16.2903C51.3309 15.9478 50.8256 15.7765 50.193 15.7765H48.2027L47.0919 20.4343H48.9896C50.0619 20.4343 50.8796 20.2098 51.4428 19.7608C52.0059 19.3041 52.2875 18.623 52.2875 17.7173Z" fill="white"/>
        <path d="M69.7489 21.6673C69.7489 21.9946 69.6872 22.4398 69.5637 23.003L68.4297 27.7521H70.4663L69.7257 30.2979H64.1136L64.345 29.339C63.1493 30.0848 62.0538 30.4577 61.0587 30.4577C60.0173 30.4577 59.1455 30.1533 58.4435 29.5444C57.7492 28.928 57.4021 28.1288 57.4021 27.1471C57.4021 25.6629 57.9537 24.5556 59.0568 23.8249C60.1677 23.0867 61.6411 22.7176 63.4771 22.7176C64.0711 22.7176 64.588 22.7747 65.0277 22.8888C65.4751 22.9954 65.7374 23.0563 65.8146 23.0715C65.8454 22.9497 65.8917 22.7556 65.9534 22.4893C66.0229 22.2229 66.0576 21.9984 66.0576 21.8157C66.0576 21.3743 65.8532 21.0242 65.4443 20.7654C65.0431 20.499 64.534 20.3658 63.9169 20.3658C63.0991 20.3658 62.1541 20.636 61.0818 21.1764L59.2304 19.3841C60.9661 18.4632 62.7288 18.0027 64.5186 18.0027C66.0152 18.0027 67.261 18.3071 68.2562 18.916C69.2513 19.5172 69.7489 20.4343 69.7489 21.6673ZM62.2853 28.1517C63.0413 28.1517 63.9014 27.7978 64.8657 27.09L65.317 25.1264C64.6999 24.959 64.0866 24.8752 63.4771 24.8752C62.7597 24.8752 62.1426 25.0465 61.6257 25.389C61.1165 25.7314 60.862 26.1995 60.862 26.7932C60.862 27.1661 61.0008 27.4857 61.2785 27.7521C61.5563 28.0185 61.8918 28.1517 62.2853 28.1517Z" fill="white"/>
        <path d="M85.544 20.9709C85.544 21.2068 85.5209 21.4542 85.4746 21.713C85.4283 21.9641 85.3473 22.3256 85.2316 22.7975L84.0744 27.7521H85.7291L85.139 30.2979H79.7582L81.5403 22.7176C81.602 22.4055 81.6328 22.1886 81.6328 22.0669C81.6328 21.7548 81.5557 21.5075 81.4014 21.3248C81.2548 21.1345 81.0311 21.0394 80.7303 21.0394C80.1131 21.0394 79.1912 21.4846 77.9647 22.3751L76.7034 27.7521H78.2424L77.6522 30.2979H71.068L71.6582 27.7521H72.9889L74.5974 20.8796H72.7691L73.3592 18.2995H78.9135L78.5548 19.795C79.388 19.1786 80.1247 18.7524 80.765 18.5164C81.4053 18.2805 82.1458 18.1625 82.9867 18.1625C83.7581 18.1625 84.3753 18.4213 84.8381 18.9388C85.3087 19.4487 85.544 20.1261 85.544 20.9709Z" fill="white"/>
        <path d="M97.0692 20.2859L97.5437 18.2995H102.681L102.091 20.8796H100.749L98.6082 29.9212C97.6748 33.9321 95.1561 35.9375 91.052 35.9375C88.8689 35.9375 87.0136 35.5455 85.4861 34.7616L86.6202 32.1017C88.1244 32.7866 89.4513 33.1291 90.6007 33.1291C91.5805 33.1291 92.348 32.9921 92.9035 32.7181C93.4666 32.4442 93.9102 32.0141 94.2342 31.4281C94.5582 30.8497 94.8398 30.0353 95.0789 28.9851L95.0326 28.9166C93.9758 29.8983 92.8765 30.3892 91.7348 30.3892C90.3153 30.3892 89.2315 29.944 88.4832 29.0536C87.7426 28.1555 87.3723 26.9492 87.3723 25.4346C87.3723 24.1865 87.6423 23.0106 88.1823 21.907C88.7223 20.7959 89.4745 19.8978 90.4387 19.2128C91.403 18.5278 92.4908 18.1854 93.7019 18.1854C95.1445 18.1854 96.2669 18.8856 97.0692 20.2859ZM93.1812 27.5809C93.8601 27.5809 94.4309 27.3563 94.8938 26.9073C95.3644 26.4583 95.7154 25.9027 95.9468 25.2406C96.1782 24.5784 96.2939 23.9201 96.2939 23.2656C96.2939 22.611 96.1126 22.0783 95.7501 21.6673C95.3952 21.2487 94.9208 21.0394 94.3268 21.0394C93.6788 21.0394 93.1118 21.2791 92.6258 21.7586C92.1475 22.2305 91.781 22.8051 91.5265 23.4825C91.2719 24.1598 91.1446 24.8029 91.1446 25.4118C91.1446 26.0663 91.322 26.5915 91.6769 26.9872C92.0318 27.383 92.5332 27.5809 93.1812 27.5809Z" fill="white"/>
        <path d="M114.936 23.3797C114.936 23.9581 114.878 24.5175 114.762 25.0579H106.141C106.08 25.309 106.049 25.5678 106.049 25.8342C106.049 26.5496 106.253 27.1356 106.662 27.5923C107.071 28.0413 107.622 28.2658 108.317 28.2658C109.343 28.2658 110.172 27.7521 110.805 26.7247L113.559 27.9348C112.941 28.8557 112.166 29.5406 111.233 29.9897C110.299 30.4311 109.25 30.6518 108.085 30.6518C106.396 30.6518 105.05 30.1876 104.047 29.259C103.044 28.3305 102.543 27.0633 102.543 25.4575C102.543 24.1484 102.824 22.9231 103.387 21.7815C103.958 20.6322 104.776 19.7151 105.84 19.0302C106.913 18.3452 108.151 18.0027 109.555 18.0027C110.596 18.0027 111.522 18.2196 112.332 18.6534C113.15 19.0872 113.786 19.7151 114.241 20.5371C114.704 21.3514 114.936 22.299 114.936 23.3797ZM111.453 22.5349C111.453 21.8804 111.287 21.3629 110.955 20.9823C110.623 20.6018 110.149 20.4115 109.532 20.4115C108.105 20.4115 107.125 21.3058 106.593 23.0943H111.406C111.437 22.8584 111.453 22.6719 111.453 22.5349Z" fill="white"/>
        <path d="M127.375 18.2995L126.646 21.5075C126.237 21.4161 125.855 21.3705 125.5 21.3705C123.479 21.3705 122.187 22.6719 121.624 25.2748L121.045 27.7521H122.943L122.353 30.2979H115.271L115.861 27.7521H117.331L118.939 20.8796H117.285L117.875 18.2995H122.827L121.994 21.7929L122.041 21.8385C122.758 20.4762 123.437 19.5287 124.077 18.9959C124.717 18.4555 125.47 18.1854 126.334 18.1854C126.604 18.1854 126.951 18.2234 127.375 18.2995Z" fill="white"/>
        <defs>
        <linearGradient id="paint0_linear_1815_190" x1="18.2377" y1="4.81128" x2="18.2377" y2="35.2872" gradientUnits="userSpaceOnUse">
        <stop stop-color="#2C526D"/>
        <stop offset="1" stop-color="#0F3A53"/>
        </linearGradient>
        </defs>
    </svg>`;

window.onload = function() {
    const ui = SwaggerUIBundle({
        url: getSwaggerBaseUrl(window.location.pathname) + "/swagger.json",
        dom_id: '#swagger-ui',
        deepLinking: true,
        presets: [
            SwaggerUIBundle.presets.apis,
            SwaggerUIStandalonePreset
        ],
        plugins: [
            SwaggerUIBundle.plugins.DownloadUrl
        ],
        layout: "StandaloneLayout",
        requestInterceptor: function(request) {
              if (!request.url.includes("swagger.json")) {
                    request.url = getAPIUrl(request.url);
              }
              if (request.method != "GET") {
                request.headers['X-XSRF-HEADER'] = localStorage.csrfToken;
              }

              return request;
        },
        docExpansion: 'none'
    })
    window.ui = ui;
    // Poll the DOM until the Swagger UI logo is rendered, then set the custom logo
    const interval = setInterval(() => {
        const topbarWrapper = document.getElementById("swagger-ui").querySelector('div.topbar-wrapper > a.link'); // Find the logo element
        if (topbarWrapper) {
            topbarWrapper.innerHTML = '';
            topbarWrapper.innerHTML= rangerLogo;
            if(document.getElementById("swagger-ui").getElementsByClassName("float-right").length > 0) {
                document.getElementById("swagger-ui").getElementsByClassName("float-right")[0].querySelector("a").remove()
            }
            clearInterval(interval); // Stop polling once the logo is set
        }
    }, 100);// Check every 100ms
}

function getSwaggerBaseUrl(url) {
    var path = url.replace(/\/[\w-]+.(jsp|html)|\/+$/ig, '');
    splitPath = path.split("/");
    splitPath.pop();
    gatewayUrl = splitPath.join("/");

    return window.location.origin + path;
};

function getAPIUrl(url) {
    url = new URL(url);
    var path =  url.origin + apiBaseUrl + url.pathname + url.search;
    return path;
};
