/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.elasticsearch.common.inject.ConfigurationException;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.spi.Message;

public class MoreTypes {
    public static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    private static final Map<TypeLiteral<?>, TypeLiteral<?>> PRIMITIVE_TO_WRAPPER;

    private MoreTypes() {
    }

    public static <T> TypeLiteral<T> makeKeySafe(TypeLiteral<T> type) {
        if (!MoreTypes.isFullySpecified(type.getType())) {
            String message = type + " cannot be used as a key; It is not fully specified.";
            throw new ConfigurationException(Collections.singleton(new Message(message)));
        }
        TypeLiteral<?> wrappedPrimitives = PRIMITIVE_TO_WRAPPER.get(type);
        return wrappedPrimitives != null ? wrappedPrimitives : type;
    }

    private static boolean isFullySpecified(Type type) {
        if (type instanceof Class) {
            return true;
        }
        if (type instanceof CompositeType) {
            return ((CompositeType)((Object)type)).isFullySpecified();
        }
        if (type instanceof TypeVariable) {
            return false;
        }
        return ((CompositeType)((Object)MoreTypes.canonicalize(type))).isFullySpecified();
    }

    public static Type canonicalize(Type type) {
        if (type instanceof ParameterizedTypeImpl || type instanceof GenericArrayTypeImpl || type instanceof WildcardTypeImpl) {
            return type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            return new ParameterizedTypeImpl(p.getOwnerType(), p.getRawType(), p.getActualTypeArguments());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType g = (GenericArrayType)type;
            return new GenericArrayTypeImpl(g.getGenericComponentType());
        }
        if (type instanceof Class && ((Class)type).isArray()) {
            Class c = (Class)type;
            return new GenericArrayTypeImpl(c.getComponentType());
        }
        if (type instanceof WildcardType) {
            WildcardType w = (WildcardType)type;
            return new WildcardTypeImpl(w.getUpperBounds(), w.getLowerBounds());
        }
        return type;
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (!(rawType instanceof Class)) {
                throw new IllegalArgumentException("Expected a Class, but <" + type + "> is of type " + type.getClass().getName());
            }
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            return Object[].class;
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + type.getClass().getName());
    }

    public static boolean equals(Type a, Type b) {
        if (a == b) {
            return true;
        }
        if (a instanceof Class) {
            return a.equals(b);
        }
        if (a instanceof ParameterizedType) {
            if (!(b instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType pa = (ParameterizedType)a;
            ParameterizedType pb = (ParameterizedType)b;
            return Objects.equals(pa.getOwnerType(), pb.getOwnerType()) && pa.getRawType().equals(pb.getRawType()) && Arrays.equals(pa.getActualTypeArguments(), pb.getActualTypeArguments());
        }
        if (a instanceof GenericArrayType) {
            if (!(b instanceof GenericArrayType)) {
                return false;
            }
            GenericArrayType ga = (GenericArrayType)a;
            GenericArrayType gb = (GenericArrayType)b;
            return MoreTypes.equals(ga.getGenericComponentType(), gb.getGenericComponentType());
        }
        if (a instanceof WildcardType) {
            if (!(b instanceof WildcardType)) {
                return false;
            }
            WildcardType wa = (WildcardType)a;
            WildcardType wb = (WildcardType)b;
            return Arrays.equals(wa.getUpperBounds(), wb.getUpperBounds()) && Arrays.equals(wa.getLowerBounds(), wb.getLowerBounds());
        }
        if (a instanceof TypeVariable) {
            if (!(b instanceof TypeVariable)) {
                return false;
            }
            TypeVariable va = (TypeVariable)a;
            TypeVariable vb = (TypeVariable)b;
            return va.getGenericDeclaration() == vb.getGenericDeclaration() && va.getName().equals(vb.getName());
        }
        return false;
    }

    public static int hashCode(Type type) {
        if (type instanceof Class) {
            return type.hashCode();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            return Arrays.hashCode(p.getActualTypeArguments()) ^ p.getRawType().hashCode() ^ MoreTypes.hashCodeOrZero(p.getOwnerType());
        }
        if (type instanceof GenericArrayType) {
            return MoreTypes.hashCode(((GenericArrayType)type).getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            WildcardType w = (WildcardType)type;
            return Arrays.hashCode(w.getLowerBounds()) ^ Arrays.hashCode(w.getUpperBounds());
        }
        return MoreTypes.hashCodeOrZero(type);
    }

    private static int hashCodeOrZero(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public static String toString(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] arguments = parameterizedType.getActualTypeArguments();
            Type ownerType = parameterizedType.getOwnerType();
            StringBuilder stringBuilder = new StringBuilder();
            if (ownerType != null) {
                stringBuilder.append(MoreTypes.toString(ownerType)).append(".");
            }
            stringBuilder.append(MoreTypes.toString(parameterizedType.getRawType()));
            if (arguments.length > 0) {
                stringBuilder.append("<").append(MoreTypes.toString(arguments[0]));
                for (int i = 1; i < arguments.length; ++i) {
                    stringBuilder.append(", ").append(MoreTypes.toString(arguments[i]));
                }
            }
            return stringBuilder.append(">").toString();
        }
        if (type instanceof GenericArrayType) {
            return MoreTypes.toString(((GenericArrayType)type).getGenericComponentType()) + "[]";
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] lowerBounds = wildcardType.getLowerBounds();
            Type[] upperBounds = wildcardType.getUpperBounds();
            if (upperBounds.length != 1 || lowerBounds.length > 1) {
                throw new UnsupportedOperationException("Unsupported wildcard type " + type);
            }
            if (lowerBounds.length == 1) {
                if (upperBounds[0] != Object.class) {
                    throw new UnsupportedOperationException("Unsupported wildcard type " + type);
                }
                return "? super " + MoreTypes.toString(lowerBounds[0]);
            }
            if (upperBounds[0] == Object.class) {
                return "?";
            }
            return "? extends " + MoreTypes.toString(upperBounds[0]);
        }
        return type.toString();
    }

    public static Class<? extends Member> memberType(Member member) {
        Objects.requireNonNull(member, "member");
        if (member instanceof MemberImpl) {
            return ((MemberImpl)member).memberType;
        }
        if (member instanceof Field) {
            return Field.class;
        }
        if (member instanceof Method) {
            return Method.class;
        }
        if (member instanceof Constructor) {
            return Constructor.class;
        }
        throw new IllegalArgumentException("Unsupported implementation class for Member, " + member.getClass());
    }

    public static String toString(Member member) {
        Class<? extends Member> memberType = MoreTypes.memberType(member);
        if (memberType == Method.class) {
            return member.getDeclaringClass().getName() + "." + member.getName() + "()";
        }
        if (memberType == Field.class) {
            return member.getDeclaringClass().getName() + "." + member.getName();
        }
        if (memberType == Constructor.class) {
            return member.getDeclaringClass().getName() + ".<init>()";
        }
        throw new AssertionError();
    }

    public static String memberKey(Member member) {
        Objects.requireNonNull(member, "member");
        return "<NO_MEMBER_KEY>";
    }

    public static Type getGenericSupertype(Type type, Class<?> rawType, Class<?> toResolve) {
        if (toResolve == rawType) {
            return type;
        }
        if (toResolve.isInterface()) {
            Class<?>[] interfaces = rawType.getInterfaces();
            int length = interfaces.length;
            for (int i = 0; i < length; ++i) {
                if (interfaces[i] == toResolve) {
                    return rawType.getGenericInterfaces()[i];
                }
                if (!toResolve.isAssignableFrom(interfaces[i])) continue;
                return MoreTypes.getGenericSupertype(rawType.getGenericInterfaces()[i], interfaces[i], toResolve);
            }
        }
        if (!rawType.isInterface()) {
            while (rawType != Object.class) {
                Class<?> rawSupertype = rawType.getSuperclass();
                if (rawSupertype == toResolve) {
                    return rawType.getGenericSuperclass();
                }
                if (toResolve.isAssignableFrom(rawSupertype)) {
                    return MoreTypes.getGenericSupertype(rawType.getGenericSuperclass(), rawSupertype, toResolve);
                }
                rawType = rawSupertype;
            }
        }
        return toResolve;
    }

    public static Type resolveTypeVariable(Type type, Class<?> rawType, TypeVariable unknown) {
        Class<?> declaredByRaw = MoreTypes.declaringClassOf(unknown);
        if (declaredByRaw == null) {
            return unknown;
        }
        Type declaredBy = MoreTypes.getGenericSupertype(type, rawType, declaredByRaw);
        if (declaredBy instanceof ParameterizedType) {
            int index = MoreTypes.indexOf(declaredByRaw.getTypeParameters(), unknown);
            return ((ParameterizedType)declaredBy).getActualTypeArguments()[index];
        }
        return unknown;
    }

    private static int indexOf(Object[] array, Object toFind) {
        for (int i = 0; i < array.length; ++i) {
            if (!toFind.equals(array[i])) continue;
            return i;
        }
        throw new NoSuchElementException();
    }

    private static Class<?> declaringClassOf(TypeVariable typeVariable) {
        Object genericDeclaration = typeVariable.getGenericDeclaration();
        return genericDeclaration instanceof Class ? (Class)genericDeclaration : null;
    }

    private static void checkNotPrimitive(Type type, String use) {
        if (type instanceof Class && ((Class)type).isPrimitive()) {
            throw new IllegalArgumentException("Primitive types are not allowed in " + use + ": " + type);
        }
    }

    static {
        HashMap<TypeLiteral<Object>, TypeLiteral<Object>> primitiveToWrapper = new HashMap<TypeLiteral<Object>, TypeLiteral<Object>>();
        primitiveToWrapper.put(TypeLiteral.get(Boolean.TYPE), TypeLiteral.get(Boolean.class));
        primitiveToWrapper.put(TypeLiteral.get(Byte.TYPE), TypeLiteral.get(Byte.class));
        primitiveToWrapper.put(TypeLiteral.get(Short.TYPE), TypeLiteral.get(Short.class));
        primitiveToWrapper.put(TypeLiteral.get(Integer.TYPE), TypeLiteral.get(Integer.class));
        primitiveToWrapper.put(TypeLiteral.get(Long.TYPE), TypeLiteral.get(Long.class));
        primitiveToWrapper.put(TypeLiteral.get(Float.TYPE), TypeLiteral.get(Float.class));
        primitiveToWrapper.put(TypeLiteral.get(Double.TYPE), TypeLiteral.get(Double.class));
        primitiveToWrapper.put(TypeLiteral.get(Character.TYPE), TypeLiteral.get(Character.class));
        primitiveToWrapper.put(TypeLiteral.get(Void.TYPE), TypeLiteral.get(Void.class));
        PRIMITIVE_TO_WRAPPER = Collections.unmodifiableMap(primitiveToWrapper);
    }

    private static interface CompositeType {
        public boolean isFullySpecified();
    }

    public static class ParameterizedTypeImpl
    implements ParameterizedType,
    CompositeType {
        private final Type ownerType;
        private final Type rawType;
        private final Type[] typeArguments;

        public ParameterizedTypeImpl(Type ownerType, Type rawType, Type ... typeArguments) {
            if (rawType instanceof Class) {
                Class rawTypeAsClass = (Class)rawType;
                if (ownerType == null && rawTypeAsClass.getEnclosingClass() != null) {
                    throw new IllegalArgumentException("No owner type for enclosed " + rawType);
                }
                if (ownerType != null && rawTypeAsClass.getEnclosingClass() == null) {
                    throw new IllegalArgumentException("Owner type for unenclosed " + rawType);
                }
            }
            this.ownerType = ownerType == null ? null : MoreTypes.canonicalize(ownerType);
            this.rawType = MoreTypes.canonicalize(rawType);
            this.typeArguments = (Type[])typeArguments.clone();
            for (int t = 0; t < this.typeArguments.length; ++t) {
                Objects.requireNonNull(this.typeArguments[t], "type parameter");
                MoreTypes.checkNotPrimitive(this.typeArguments[t], "type parameters");
                this.typeArguments[t] = MoreTypes.canonicalize(this.typeArguments[t]);
            }
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public boolean isFullySpecified() {
            if (this.ownerType != null && !MoreTypes.isFullySpecified(this.ownerType)) {
                return false;
            }
            if (!MoreTypes.isFullySpecified(this.rawType)) {
                return false;
            }
            for (Type type : this.typeArguments) {
                if (MoreTypes.isFullySpecified(type)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object other) {
            return other instanceof ParameterizedType && MoreTypes.equals(this, (ParameterizedType)other);
        }

        public int hashCode() {
            return MoreTypes.hashCode(this);
        }

        public String toString() {
            return MoreTypes.toString(this);
        }
    }

    public static class GenericArrayTypeImpl
    implements GenericArrayType,
    CompositeType {
        private final Type componentType;

        public GenericArrayTypeImpl(Type componentType) {
            this.componentType = MoreTypes.canonicalize(componentType);
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        @Override
        public boolean isFullySpecified() {
            return MoreTypes.isFullySpecified(this.componentType);
        }

        public boolean equals(Object o) {
            return o instanceof GenericArrayType && MoreTypes.equals(this, (GenericArrayType)o);
        }

        public int hashCode() {
            return MoreTypes.hashCode(this);
        }

        public String toString() {
            return MoreTypes.toString(this);
        }
    }

    public static class WildcardTypeImpl
    implements WildcardType,
    CompositeType {
        private final Type upperBound;
        private final Type lowerBound;

        public WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
            if (lowerBounds.length > 1) {
                throw new IllegalArgumentException("Must have at most one lower bound.");
            }
            if (upperBounds.length != 1) {
                throw new IllegalArgumentException("Must have exactly one upper bound.");
            }
            if (lowerBounds.length == 1) {
                Objects.requireNonNull(lowerBounds[0], "lowerBound");
                MoreTypes.checkNotPrimitive(lowerBounds[0], "wildcard bounds");
                if (upperBounds[0] != Object.class) {
                    throw new IllegalArgumentException("bounded both ways");
                }
                this.lowerBound = MoreTypes.canonicalize(lowerBounds[0]);
                this.upperBound = Object.class;
            } else {
                Objects.requireNonNull(upperBounds[0], "upperBound");
                MoreTypes.checkNotPrimitive(upperBounds[0], "wildcard bounds");
                this.lowerBound = null;
                this.upperBound = MoreTypes.canonicalize(upperBounds[0]);
            }
        }

        @Override
        public Type[] getUpperBounds() {
            return new Type[]{this.upperBound};
        }

        @Override
        public Type[] getLowerBounds() {
            Type[] typeArray;
            if (this.lowerBound != null) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = this.lowerBound;
            } else {
                typeArray = EMPTY_TYPE_ARRAY;
            }
            return typeArray;
        }

        @Override
        public boolean isFullySpecified() {
            return MoreTypes.isFullySpecified(this.upperBound) && (this.lowerBound == null || MoreTypes.isFullySpecified(this.lowerBound));
        }

        public boolean equals(Object other) {
            return other instanceof WildcardType && MoreTypes.equals(this, (WildcardType)other);
        }

        public int hashCode() {
            return MoreTypes.hashCode(this);
        }

        public String toString() {
            return MoreTypes.toString(this);
        }
    }

    public static class MemberImpl
    implements Member {
        private final Class<?> declaringClass;
        private final String name;
        private final int modifiers;
        private final boolean synthetic;
        private final Class<? extends Member> memberType;

        private MemberImpl(Member member) {
            this.declaringClass = member.getDeclaringClass();
            this.name = member.getName();
            this.modifiers = member.getModifiers();
            this.synthetic = member.isSynthetic();
            this.memberType = MoreTypes.memberType(member);
        }

        public Class getDeclaringClass() {
            return this.declaringClass;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }

        @Override
        public boolean isSynthetic() {
            return this.synthetic;
        }

        public String toString() {
            return MoreTypes.toString(this);
        }
    }
}

