/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.elasticsearch.cluster.metadata.ClusterNameExpressionResolver;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.ProxyConnectionStrategy;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.RemoteConnectionStrategy;
import org.elasticsearch.transport.SniffConnectionStrategy;

public abstract class RemoteClusterAware {
    public static final char REMOTE_CLUSTER_INDEX_SEPARATOR = ':';
    public static final String LOCAL_CLUSTER_GROUP_KEY = "";
    protected final Settings settings;
    private final ClusterNameExpressionResolver clusterNameResolver;

    protected RemoteClusterAware(Settings settings) {
        this.settings = settings;
        this.clusterNameResolver = new ClusterNameExpressionResolver();
    }

    protected static Set<String> getEnabledRemoteClusters(Settings settings) {
        return RemoteConnectionStrategy.getRemoteClusters(settings);
    }

    protected Map<String, List<String>> groupClusterIndices(Set<String> remoteClusterNames, String[] requestIndices, Predicate<String> indexExists) {
        HashMap<String, List<String>> perClusterIndices = new HashMap<String, List<String>>();
        for (String index : requestIndices) {
            int i = index.indexOf(58);
            if (i >= 0) {
                String remoteClusterName = index.substring(0, i);
                List<String> clusters = this.clusterNameResolver.resolveClusterNames(remoteClusterNames, remoteClusterName);
                if (!clusters.isEmpty()) {
                    if (indexExists.test(index)) {
                        throw new IllegalArgumentException("Can not filter indices; index " + index + " exists but there is also a remote cluster named: " + remoteClusterName);
                    }
                    String indexName = index.substring(i + 1);
                    for (String clusterName : clusters) {
                        perClusterIndices.computeIfAbsent(clusterName, k -> new ArrayList()).add(indexName);
                    }
                    continue;
                }
                perClusterIndices.computeIfAbsent(LOCAL_CLUSTER_GROUP_KEY, k -> new ArrayList()).add(index);
                continue;
            }
            perClusterIndices.computeIfAbsent(LOCAL_CLUSTER_GROUP_KEY, k -> new ArrayList()).add(index);
        }
        return perClusterIndices;
    }

    void validateAndUpdateRemoteCluster(String clusterAlias, Settings settings) {
        if (LOCAL_CLUSTER_GROUP_KEY.equals(clusterAlias)) {
            throw new IllegalArgumentException("remote clusters must not have the empty string as its key");
        }
        this.updateRemoteCluster(clusterAlias, settings);
    }

    protected abstract void updateRemoteCluster(String var1, Settings var2);

    public void listenForUpdates(ClusterSettings clusterSettings) {
        List<Setting.AffixSetting<?>> remoteClusterSettings = Arrays.asList(RemoteClusterService.REMOTE_CLUSTER_COMPRESS, RemoteClusterService.REMOTE_CLUSTER_PING_SCHEDULE, RemoteConnectionStrategy.REMOTE_CONNECTION_MODE, SniffConnectionStrategy.SEARCH_REMOTE_CLUSTERS_SEEDS, SniffConnectionStrategy.SEARCH_REMOTE_CLUSTERS_PROXY, SniffConnectionStrategy.REMOTE_CLUSTERS_PROXY, SniffConnectionStrategy.REMOTE_CLUSTER_SEEDS, SniffConnectionStrategy.REMOTE_NODE_CONNECTIONS, ProxyConnectionStrategy.PROXY_ADDRESS, ProxyConnectionStrategy.REMOTE_SOCKET_CONNECTIONS, ProxyConnectionStrategy.SERVER_NAME);
        clusterSettings.addAffixGroupUpdateConsumer(remoteClusterSettings, this::validateAndUpdateRemoteCluster);
    }

    public static String buildRemoteIndexName(String clusterAlias, String indexName) {
        return clusterAlias == null || LOCAL_CLUSTER_GROUP_KEY.equals(clusterAlias) ? indexName : clusterAlias + ':' + indexName;
    }
}

