/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.tagsync.process;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecureClientLogin;
import org.apache.ranger.credentialapi.CredentialReader;
import org.apache.ranger.tagsync.ha.TagSyncHAInitializerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagSyncConfig
extends Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(TagSyncConfig.class);
    private static TagSyncConfig instance = null;
    private static final String CONFIG_FILE = "ranger-tagsync-site.xml";
    private static final String DEFAULT_CONFIG_FILE = "ranger-tagsync-default.xml";
    private static final String CORE_SITE_FILE = "core-site.xml";
    public static final String TAGSYNC_ENABLED_PROP = "ranger.tagsync.enabled";
    public static final String TAGSYNC_LOGDIR_PROP = "ranger.tagsync.logdir";
    private static final String TAGSYNC_TAGADMIN_REST_URL_PROP = "ranger.tagsync.dest.ranger.endpoint";
    private static final String TAGSYNC_TAGADMIN_REST_SSL_CONFIG_FILE_PROP = "ranger.tagsync.dest.ranger.ssl.config.filename";
    private static final String TAGSYNC_SINK_CLASS_PROP = "ranger.tagsync.dest.ranger.impl.class";
    private static final String TAGSYNC_DEST_RANGER_PASSWORD_ALIAS = "tagadmin.user.password";
    private static final String TAGSYNC_SOURCE_ATLASREST_PASSWORD_ALIAS = "atlas.user.password";
    private static final String TAGSYNC_TAGADMIN_USERNAME_PROP = "ranger.tagsync.dest.ranger.username";
    private static final String TAGSYNC_ATLASREST_USERNAME_PROP = "ranger.tagsync.source.atlasrest.username";
    private static final String TAGSYNC_TAGADMIN_PASSWORD_PROP = "ranger.tagsync.dest.ranger.password";
    private static final String TAGSYNC_ATLASREST_PASSWORD_PROP = "ranger.tagsync.source.atlasrest.password";
    private static final String TAGSYNC_TAGADMIN_CONNECTION_CHECK_INTERVAL_PROP = "ranger.tagsync.dest.ranger.connection.check.interval";
    private static final String TAGSYNC_SOURCE_ATLAS_CUSTOM_RESOURCE_MAPPERS_PROP = "ranger.tagsync.atlas.custom.resource.mappers";
    private static final String TAGSYNC_ATLASSOURCE_ENDPOINT_PROP = "ranger.tagsync.source.atlasrest.endpoint";
    private static final String TAGSYNC_ATLAS_REST_SOURCE_DOWNLOAD_INTERVAL_PROP = "ranger.tagsync.source.atlasrest.download.interval.millis";
    private static final String TAGSYNC_ATLAS_REST_SSL_CONFIG_FILE_PROP = "ranger.tagsync.source.atlasrest.ssl.config.filename";
    public static final String TAGSYNC_FILESOURCE_FILENAME_PROP = "ranger.tagsync.source.file.filename";
    private static final String TAGSYNC_FILESOURCE_MOD_TIME_CHECK_INTERVAL_PROP = "ranger.tagsync.source.file.check.interval.millis";
    private static final String TAGSYNC_KEYSTORE_TYPE_PROP = "ranger.keystore.file.type";
    private static final String TAGSYNC_TAGADMIN_KEYSTORE_PROP = "ranger.tagsync.keystore.filename";
    private static final String TAGSYNC_ATLASREST_KEYSTORE_PROP = "ranger.tagsync.source.atlasrest.keystore.filename";
    private static final String TAGSYNC_SOURCE_RETRY_INITIALIZATION_INTERVAL_PROP = "ranger.tagsync.source.retry.initialization.interval.millis";
    public static final String TAGSYNC_RANGER_COOKIE_ENABLED_PROP = "ranger.tagsync.cookie.enabled";
    public static final String TAGSYNC_TAGADMIN_COOKIE_NAME_PROP = "ranger.tagsync.dest.ranger.session.cookie.name";
    private static final String DEFAULT_TAGADMIN_USERNAME = "rangertagsync";
    private static final String DEFAULT_ATLASREST_USERNAME = "admin";
    private static final String DEFAULT_ATLASREST_PASSWORD = "admin";
    private static final int DEFAULT_TAGSYNC_TAGADMIN_CONNECTION_CHECK_INTERVAL = 15000;
    private static final long DEFAULT_TAGSYNC_ATLASREST_SOURCE_DOWNLOAD_INTERVAL = 900000L;
    public static final int DEFAULT_TAGSYNC_ATLASREST_SOURCE_ENTITIES_BATCH_SIZE = 10000;
    private static final long DEFAULT_TAGSYNC_FILESOURCE_MOD_TIME_CHECK_INTERVAL = 60000L;
    private static final long DEFAULT_TAGSYNC_SOURCE_RETRY_INITIALIZATION_INTERVAL = 10000L;
    private static final String AUTH_TYPE = "hadoop.security.authentication";
    private static final String NAME_RULES = "hadoop.security.auth_to_local";
    private static final String TAGSYNC_KERBEROS_PRICIPAL = "ranger.tagsync.kerberos.principal";
    private static final String TAGSYNC_KERBEROS_KEYTAB = "ranger.tagsync.kerberos.keytab";
    public static final String TAGSYNC_KERBEROS_IDENTITY = "tagsync.kerberos.identity";
    private static String LOCAL_HOSTNAME = "unknown";
    private static final String TAGSYNC_METRICS_FILEPATH = "ranger.tagsync.metrics.filepath";
    private static final String DEFAULT_TAGSYNC_METRICS_FILEPATH = "/tmp/";
    private static final String TAGSYNC_METRICS_FILENAME = "ranger.tagsync.metrics.filename";
    private static final String DEFAULT_TAGSYNC_METRICS_FILENAME = "ranger_tagsync_metric.json";
    private static final String TAGSYNC_METRICS_FREQUENCY_TIME_IN_MILLIS_PARAM = "ranger.tagsync.metrics.frequencytimeinmillis";
    private static final long DEFAULT_TAGSYNC_METRICS_FREQUENCY__TIME_IN_MILLIS = 10000L;
    private static final String TAGSYNC_METRICS_ENABLED_PROP = "ranger.tagsync.metrics.enabled";
    private static final int DEFAULT_TAGSYNC_SINK_MAX_BATCH_SIZE = 1;
    private static final String TAGSYNC_SINK_MAX_BATCH_SIZE_PROP = "ranger.tagsync.dest.ranger.max.batch.size";
    private static final String TAGSYNC_ATLASREST_SOURCE_ENTITIES_BATCH_SIZE = "ranger.tagsync.source.atlasrest.entities.batch.size";
    public static final String TAGSYNC_SERVER_HA_ENABLED_PARAM = "ranger-tagsync.server.ha.enabled";
    private Properties props;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TagSyncConfig getInstance() {
        if (instance != null) return instance;
        Class<TagSyncConfig> clazz = TagSyncConfig.class;
        synchronized (TagSyncConfig.class) {
            if (instance != null) return instance;
            instance = new TagSyncConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Properties getProperties() {
        return this.props;
    }

    public static InputStream getFileInputStream(String path) throws FileNotFoundException {
        InputStream ret = null;
        File f = new File(path);
        if (f.exists() && f.isFile() && f.canRead()) {
            ret = new FileInputStream(f);
        } else {
            ret = TagSyncConfig.class.getResourceAsStream(path);
            if (ret == null && !path.startsWith("/")) {
                ret = TagSyncConfig.class.getResourceAsStream("/" + path);
            }
            if (ret == null && (ret = ClassLoader.getSystemClassLoader().getResourceAsStream(path)) == null && !path.startsWith("/")) {
                ret = ClassLoader.getSystemResourceAsStream("/" + path);
            }
        }
        return ret;
    }

    public static String getResourceFileName(String path) {
        String ret = null;
        if (StringUtils.isNotBlank((String)path)) {
            File f = new File(path);
            if (f.exists() && f.isFile() && f.canRead()) {
                ret = path;
            } else {
                URL fileURL = TagSyncConfig.class.getResource(path);
                if (fileURL == null && !path.startsWith("/")) {
                    fileURL = TagSyncConfig.class.getResource("/" + path);
                }
                if (fileURL == null && (fileURL = ClassLoader.getSystemClassLoader().getResource(path)) == null && !path.startsWith("/")) {
                    fileURL = ClassLoader.getSystemClassLoader().getResource("/" + path);
                }
                if (fileURL != null) {
                    try {
                        ret = fileURL.getFile();
                    }
                    catch (Exception exception) {
                        LOG.error(path + " is not a file", (Throwable)exception);
                    }
                } else {
                    LOG.warn("URL not found for " + path + " or no privilege for reading file " + path);
                }
            }
        }
        return ret;
    }

    public static synchronized boolean isTagSyncServiceActive() {
        return TagSyncHAInitializerImpl.getInstance(TagSyncConfig.getInstance()).isActive();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DEFAULT_CONFIG_FILE=").append(DEFAULT_CONFIG_FILE).append(", ").append("CONFIG_FILE=").append(CONFIG_FILE).append("\n\n");
        return sb.toString() + super.toString();
    }

    public static String getTagsyncKeyStoreType(Properties prop) {
        return prop.getProperty(TAGSYNC_KEYSTORE_TYPE_PROP);
    }

    public static boolean isTagSyncRangerCookieEnabled(Properties prop) {
        String val = prop.getProperty(TAGSYNC_RANGER_COOKIE_ENABLED_PROP);
        return val == null || Boolean.valueOf(val.trim()) != false;
    }

    public static String getRangerAdminCookieName(Properties prop) {
        String ret = "RANGERADMINSESSIONID";
        String val = prop.getProperty(TAGSYNC_TAGADMIN_COOKIE_NAME_PROP);
        if (StringUtils.isNotBlank((String)val)) {
            ret = val;
        }
        return ret;
    }

    public static String getTagSyncLogdir(Properties prop) {
        return prop.getProperty(TAGSYNC_LOGDIR_PROP);
    }

    public static long getTagSourceFileModTimeCheckIntervalInMillis(Properties prop) {
        String val = prop.getProperty(TAGSYNC_FILESOURCE_MOD_TIME_CHECK_INTERVAL_PROP);
        long ret = 60000L;
        if (StringUtils.isNotBlank((String)val)) {
            try {
                ret = Long.valueOf(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ret;
    }

    public static long getTagSourceAtlasDownloadIntervalInMillis(Properties prop) {
        String val = prop.getProperty(TAGSYNC_ATLAS_REST_SOURCE_DOWNLOAD_INTERVAL_PROP);
        long ret = 900000L;
        if (StringUtils.isNotBlank((String)val)) {
            try {
                ret = Long.valueOf(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ret;
    }

    public static String getTagSinkClassName(Properties prop) {
        String val = prop.getProperty(TAGSYNC_SINK_CLASS_PROP);
        if (StringUtils.equalsIgnoreCase((String)val, (String)"ranger")) {
            return "org.apache.ranger.tagsync.sink.tagadmin.TagAdminRESTSink";
        }
        return val;
    }

    public static String getTagAdminRESTUrl(Properties prop) {
        return prop.getProperty(TAGSYNC_TAGADMIN_REST_URL_PROP);
    }

    public static boolean isTagSyncEnabled(Properties prop) {
        String val = prop.getProperty(TAGSYNC_ENABLED_PROP);
        return val == null || Boolean.valueOf(val.trim()) != false;
    }

    public static String getTagAdminPassword(Properties prop) {
        String path;
        String password = null;
        if (prop != null && prop.containsKey(TAGSYNC_TAGADMIN_PASSWORD_PROP) && (password = prop.getProperty(TAGSYNC_TAGADMIN_PASSWORD_PROP)) != null && !password.isEmpty()) {
            return password;
        }
        if (prop != null && prop.containsKey(TAGSYNC_TAGADMIN_KEYSTORE_PROP) && (path = prop.getProperty(TAGSYNC_TAGADMIN_KEYSTORE_PROP)) != null && !path.trim().isEmpty()) {
            try {
                password = CredentialReader.getDecryptedString((String)path.trim(), (String)TAGSYNC_DEST_RANGER_PASSWORD_ALIAS, (String)TagSyncConfig.getTagsyncKeyStoreType(prop));
            }
            catch (Exception ex) {
                password = null;
            }
            if (password != null && !password.trim().isEmpty() && !password.trim().equalsIgnoreCase("none")) {
                return password;
            }
        }
        return null;
    }

    public static String getTagAdminUserName(Properties prop) {
        String userName = null;
        if (prop != null && prop.containsKey(TAGSYNC_TAGADMIN_USERNAME_PROP)) {
            userName = prop.getProperty(TAGSYNC_TAGADMIN_USERNAME_PROP);
        }
        if (StringUtils.isBlank(userName)) {
            userName = DEFAULT_TAGADMIN_USERNAME;
        }
        return userName;
    }

    public static String getTagAdminRESTSslConfigFile(Properties prop) {
        return prop.getProperty(TAGSYNC_TAGADMIN_REST_SSL_CONFIG_FILE_PROP);
    }

    public static String getTagSourceFileName(Properties prop) {
        return prop.getProperty(TAGSYNC_FILESOURCE_FILENAME_PROP);
    }

    public static String getAtlasRESTEndpoint(Properties prop) {
        return prop.getProperty(TAGSYNC_ATLASSOURCE_ENDPOINT_PROP);
    }

    public static String getAtlasRESTPassword(Properties prop) {
        String path;
        String password = null;
        if (prop != null && prop.containsKey(TAGSYNC_ATLASREST_PASSWORD_PROP) && (password = prop.getProperty(TAGSYNC_ATLASREST_PASSWORD_PROP)) != null && !password.isEmpty()) {
            return password;
        }
        if (prop != null && prop.containsKey(TAGSYNC_ATLASREST_KEYSTORE_PROP) && (path = prop.getProperty(TAGSYNC_ATLASREST_KEYSTORE_PROP)) != null && !path.trim().isEmpty()) {
            try {
                password = CredentialReader.getDecryptedString((String)path.trim(), (String)TAGSYNC_SOURCE_ATLASREST_PASSWORD_ALIAS, (String)TagSyncConfig.getTagsyncKeyStoreType(prop));
            }
            catch (Exception ex) {
                password = null;
            }
            if (password != null && !password.trim().isEmpty() && !password.trim().equalsIgnoreCase("none")) {
                return password;
            }
        }
        if (StringUtils.isBlank(password)) {
            return "admin";
        }
        return null;
    }

    public static String getAtlasRESTUserName(Properties prop) {
        String userName = null;
        if (prop != null && prop.containsKey(TAGSYNC_ATLASREST_USERNAME_PROP)) {
            userName = prop.getProperty(TAGSYNC_ATLASREST_USERNAME_PROP);
        }
        if (StringUtils.isBlank(userName)) {
            userName = "admin";
        }
        return userName;
    }

    public static String getAtlasRESTSslConfigFile(Properties prop) {
        return prop.getProperty(TAGSYNC_ATLAS_REST_SSL_CONFIG_FILE_PROP);
    }

    public static String getCustomAtlasResourceMappers(Properties prop) {
        return prop.getProperty(TAGSYNC_SOURCE_ATLAS_CUSTOM_RESOURCE_MAPPERS_PROP);
    }

    public static String getAuthenticationType(Properties prop) {
        return prop.getProperty(AUTH_TYPE, "simple");
    }

    public static String getNameRules(Properties prop) {
        return prop.getProperty(NAME_RULES, "DEFAULT");
    }

    public static String getKerberosPrincipal(Properties prop) {
        String principal = null;
        try {
            principal = SecureClientLogin.getPrincipal((String)prop.getProperty(TAGSYNC_KERBEROS_PRICIPAL, ""), (String)LOCAL_HOSTNAME);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return principal;
    }

    public static String getKerberosKeytab(Properties prop) {
        return prop.getProperty(TAGSYNC_KERBEROS_KEYTAB, "");
    }

    public static long getTagAdminConnectionCheckInterval(Properties prop) {
        long ret = 15000L;
        String val = prop.getProperty(TAGSYNC_TAGADMIN_CONNECTION_CHECK_INTERVAL_PROP);
        if (StringUtils.isNotBlank((String)val)) {
            try {
                ret = Long.valueOf(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ret;
    }

    public static long getTagSourceRetryInitializationInterval(Properties prop) {
        long ret = 10000L;
        String val = prop.getProperty(TAGSYNC_SOURCE_RETRY_INITIALIZATION_INTERVAL_PROP);
        if (StringUtils.isNotBlank((String)val)) {
            try {
                ret = Long.valueOf(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ret;
    }

    public static String getTagsyncKerberosIdentity(Properties prop) {
        return prop.getProperty(TAGSYNC_KERBEROS_IDENTITY);
    }

    public static int getSinkMaxBatchSize(Properties prop) {
        int ret = 1;
        String maxBatchSizeStr = prop.getProperty(TAGSYNC_SINK_MAX_BATCH_SIZE_PROP);
        if (StringUtils.isNotEmpty((String)maxBatchSizeStr)) {
            try {
                ret = Integer.valueOf(maxBatchSizeStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    private TagSyncConfig() {
        super(false);
        this.init();
    }

    private void init() {
        this.readConfigFile(CORE_SITE_FILE);
        this.readConfigFile(DEFAULT_CONFIG_FILE);
        this.readConfigFile(CONFIG_FILE);
        this.props = this.getProps();
        Enumeration<?> propertyNames = this.props.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            String systemPropertyValue = System.getProperty(propertyName);
            if (systemPropertyValue == null) continue;
            this.props.setProperty(propertyName, systemPropertyValue);
        }
    }

    private void readConfigFile(String fileName) {
        if (StringUtils.isNotBlank((String)fileName)) {
            String fName = TagSyncConfig.getResourceFileName(fileName);
            if (StringUtils.isBlank((String)fName)) {
                LOG.warn("Cannot find configuration file " + fileName + " in the classpath");
            } else {
                LOG.info("Loading configuration from " + fName);
                this.addResource(fileName);
            }
        } else {
            LOG.error("Configuration fileName is null");
        }
    }

    public String getTagSyncMetricsFileName() {
        String fileName;
        String val = this.getProperties().getProperty(TAGSYNC_METRICS_FILEPATH);
        if (StringUtils.isBlank((String)val)) {
            val = StringUtils.isBlank((String)System.getProperty("logdir")) ? DEFAULT_TAGSYNC_METRICS_FILEPATH : System.getProperty("logdir");
        }
        if (Files.notExists(Paths.get(val, new String[0]), new LinkOption[0])) {
            return null;
        }
        StringBuilder pathAndFileName = new StringBuilder(val);
        if (!val.endsWith("/")) {
            pathAndFileName.append("/");
        }
        if (StringUtils.isBlank((String)(fileName = this.getProperties().getProperty(TAGSYNC_METRICS_FILENAME)))) {
            fileName = DEFAULT_TAGSYNC_METRICS_FILENAME;
        }
        pathAndFileName.append(fileName);
        return pathAndFileName.toString();
    }

    public long getTagSyncMetricsFrequency() {
        long ret = 10000L;
        String val = this.getProperties().getProperty(TAGSYNC_METRICS_FREQUENCY_TIME_IN_MILLIS_PARAM);
        if (StringUtils.isNotBlank((String)val)) {
            try {
                ret = Long.valueOf(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ret;
    }

    public static boolean isTagSyncMetricsEnabled(Properties prop) {
        String val = prop.getProperty(TAGSYNC_METRICS_ENABLED_PROP);
        return "true".equalsIgnoreCase(StringUtils.trimToEmpty((String)val));
    }

    public static int getAtlasRestSourceEntitiesBatchSize(Properties prop) {
        String val = prop.getProperty(TAGSYNC_ATLASREST_SOURCE_ENTITIES_BATCH_SIZE);
        int ret = 10000;
        if (StringUtils.isNotBlank((String)val)) {
            try {
                ret = Integer.valueOf(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ret;
    }

    static {
        try {
            LOCAL_HOSTNAME = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            LOCAL_HOSTNAME = "unknown";
        }
    }
}

