/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop;

import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RangerHdfsPlugin
extends RangerBasePlugin {
    private static final Logger LOG = LoggerFactory.getLogger(RangerHdfsPlugin.class);
    private static String fileNameExtensionSeparator = ".";
    private final boolean hadoopAuthEnabled;
    private final boolean optimizeSubAccessAuthEnabled;
    private final String randomizedWildcardPathName;
    private final String hadoopModuleName;
    private final Set<String> excludeUsers = new HashSet<String>();
    private final boolean useLegacySubAccessAuthorization;

    public RangerHdfsPlugin(Path addlConfigFile) {
        super("hdfs", "hdfs");
        RangerPluginConfig config = this.getConfig();
        if (addlConfigFile != null) {
            config.addResource(addlConfigFile);
        }
        String random = RangerHdfsPlugin.generateString("^&#@!%()-_+=@:;'<>`~abcdefghijklmnopqrstuvwxyz01234567890");
        fileNameExtensionSeparator = config.get("ranger.plugin.hdfs.filename.extension.separator", ".");
        this.hadoopAuthEnabled = config.getBoolean("xasecure.add-hadoop-authorization", false);
        config.setIsFallbackSupported(this.hadoopAuthEnabled);
        this.optimizeSubAccessAuthEnabled = config.getBoolean("ranger.optimize-subaccess-authorization", false);
        this.randomizedWildcardPathName = "*" + random + "*";
        this.hadoopModuleName = config.get("xasecure.auditlog.hadoopAcl.name", "hadoop-acl");
        String excludeUserList = config.get("xasecure.auditlog.hdfs.excludeusers", "");
        this.useLegacySubAccessAuthorization = config.getBoolean("ranger.plugin.hdfs.use.legacy.subaccess.authorization", true);
        if (excludeUserList != null && excludeUserList.trim().length() > 0) {
            for (String excludeUser : excludeUserList.trim().split(",")) {
                excludeUser = excludeUser.trim();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding exclude user [" + excludeUser + "]");
                }
                this.excludeUsers.add(excludeUser);
            }
        }
    }

    private static String generateString(String source) {
        SecureRandom rng = new SecureRandom();
        byte[] bytes = new byte[1];
        rng.nextBytes(bytes);
        int length = bytes[0];
        length = length < 56 ? 56 : length;
        length = length > 112 ? 112 : length;
        char[] text = new char[length];
        for (int i = 0; i < length; ++i) {
            text[i] = source.charAt(rng.nextInt(source.length()));
        }
        return new String(text);
    }

    public static String getFileNameExtensionSeparator() {
        return fileNameExtensionSeparator;
    }

    public boolean isHadoopAuthEnabled() {
        return this.hadoopAuthEnabled;
    }

    public boolean isOptimizeSubAccessAuthEnabled() {
        return this.optimizeSubAccessAuthEnabled;
    }

    public String getRandomizedWildcardPathName() {
        return this.randomizedWildcardPathName;
    }

    public String getHadoopModuleName() {
        return this.hadoopModuleName;
    }

    public Set<String> getExcludedUsers() {
        return this.excludeUsers;
    }

    public boolean isUseLegacySubAccessAuthorization() {
        return this.useLegacySubAccessAuthorization;
    }
}

