/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.transport;

import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractDescribedListTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.transport.End;
import org.apache.qpid.protonj2.types.transport.ErrorCondition;

public final class EndTypeDecoder
extends AbstractDescribedListTypeDecoder<End> {
    private static final int MIN_END_LIST_ENTRIES = 0;
    private static final int MAX_END_LIST_ENTRIES = 1;

    @Override
    public Class<End> getTypeClass() {
        return End.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return End.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return End.DESCRIPTOR_SYMBOL;
    }

    @Override
    public End readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readEnd(buffer, state, (ListTypeDecoder)EndTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public End[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        End[] result = new End[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readEnd(buffer, state, (ListTypeDecoder)EndTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private End readEnd(ProtonBuffer buffer, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        End end = new End();
        int size = listDecoder.readSize(buffer, state);
        int count = listDecoder.readCount(buffer, state);
        if (count < 0) {
            throw new DecodeException("Not enough entries in End list encoding: " + count);
        }
        if (count > 1) {
            throw new DecodeException("To many entries in End list encoding: " + count);
        }
        if (count == 1) {
            end.setError(state.getDecoder().readObject(buffer, state, ErrorCondition.class));
        }
        return end;
    }

    @Override
    public End readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readEnd(stream, state, (ListTypeDecoder)EndTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public End[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        End[] result = new End[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readEnd(stream, state, (ListTypeDecoder)EndTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private End readEnd(InputStream stream, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        End end = new End();
        int size = listDecoder.readSize(stream, state);
        int count = listDecoder.readCount(stream, state);
        if (count < 0) {
            throw new DecodeException("Not enough entries in End list encoding: " + count);
        }
        if (count > 1) {
            throw new DecodeException("To many entries in End list encoding: " + count);
        }
        if (count == 1) {
            end.setError(state.getDecoder().readObject(stream, state, ErrorCondition.class));
        }
        return end;
    }
}

