/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.messaging;

import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractDescribedListTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedInteger;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.Outcome;
import org.apache.qpid.protonj2.types.messaging.Source;
import org.apache.qpid.protonj2.types.messaging.TerminusDurability;
import org.apache.qpid.protonj2.types.messaging.TerminusExpiryPolicy;

public final class SourceTypeDecoder
extends AbstractDescribedListTypeDecoder<Source> {
    private static final int MIN_SOURCE_LIST_ENTRIES = 0;
    private static final int MAX_SOURCE_LIST_ENTRIES = 11;

    @Override
    public Class<Source> getTypeClass() {
        return Source.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Source.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Source.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Source readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readSource(buffer, state, (ListTypeDecoder)SourceTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Source[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        Source[] result = new Source[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readSource(buffer, state, (ListTypeDecoder)SourceTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private Source readSource(ProtonBuffer buffer, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Source source = new Source();
        int size = listDecoder.readSize(buffer, state);
        int count = listDecoder.readCount(buffer, state);
        if (count < 0) {
            throw new DecodeException("Not enough entries in Source list encoding: " + count);
        }
        if (count > 11) {
            throw new DecodeException("To many entries in Source list encoding: " + count);
        }
        block13: for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    source.setAddress(state.getDecoder().readString(buffer, state));
                    continue block13;
                }
                case 1: {
                    long durability = state.getDecoder().readUnsignedInteger(buffer, state, 0);
                    source.setDurable(TerminusDurability.valueOf(durability));
                    continue block13;
                }
                case 2: {
                    Symbol expiryPolicy = state.getDecoder().readSymbol(buffer, state);
                    source.setExpiryPolicy(expiryPolicy == null ? TerminusExpiryPolicy.SESSION_END : TerminusExpiryPolicy.valueOf(expiryPolicy));
                    continue block13;
                }
                case 3: {
                    UnsignedInteger timeout = state.getDecoder().readUnsignedInteger(buffer, state);
                    source.setTimeout(timeout == null ? UnsignedInteger.ZERO : timeout);
                    continue block13;
                }
                case 4: {
                    source.setDynamic(state.getDecoder().readBoolean(buffer, state, false));
                    continue block13;
                }
                case 5: {
                    source.setDynamicNodeProperties(state.getDecoder().readMap(buffer, state));
                    continue block13;
                }
                case 6: {
                    source.setDistributionMode(state.getDecoder().readSymbol(buffer, state));
                    continue block13;
                }
                case 7: {
                    source.setFilter(state.getDecoder().readMap(buffer, state));
                    continue block13;
                }
                case 8: {
                    source.setDefaultOutcome(state.getDecoder().readObject(buffer, state, Outcome.class));
                    continue block13;
                }
                case 9: {
                    source.setOutcomes(state.getDecoder().readMultiple(buffer, state, Symbol.class));
                    continue block13;
                }
                case 10: {
                    source.setCapabilities(state.getDecoder().readMultiple(buffer, state, Symbol.class));
                }
            }
        }
        return source;
    }

    @Override
    public Source readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readSource(stream, state, (ListTypeDecoder)SourceTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Source[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        Source[] result = new Source[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readSource(stream, state, (ListTypeDecoder)SourceTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private Source readSource(InputStream stream, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Source source = new Source();
        int size = listDecoder.readSize(stream, state);
        int count = listDecoder.readCount(stream, state);
        if (count < 0) {
            throw new DecodeException("Not enough entries in Source list encoding: " + count);
        }
        if (count > 11) {
            throw new DecodeException("To many entries in Source list encoding: " + count);
        }
        block13: for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    source.setAddress(state.getDecoder().readString(stream, state));
                    continue block13;
                }
                case 1: {
                    long durability = state.getDecoder().readUnsignedInteger(stream, state, 0);
                    source.setDurable(TerminusDurability.valueOf(durability));
                    continue block13;
                }
                case 2: {
                    Symbol expiryPolicy = state.getDecoder().readSymbol(stream, state);
                    source.setExpiryPolicy(expiryPolicy == null ? TerminusExpiryPolicy.SESSION_END : TerminusExpiryPolicy.valueOf(expiryPolicy));
                    continue block13;
                }
                case 3: {
                    UnsignedInteger timeout = state.getDecoder().readUnsignedInteger(stream, state);
                    source.setTimeout(timeout == null ? UnsignedInteger.ZERO : timeout);
                    continue block13;
                }
                case 4: {
                    source.setDynamic(state.getDecoder().readBoolean(stream, state, false));
                    continue block13;
                }
                case 5: {
                    source.setDynamicNodeProperties(state.getDecoder().readMap(stream, state));
                    continue block13;
                }
                case 6: {
                    source.setDistributionMode(state.getDecoder().readSymbol(stream, state));
                    continue block13;
                }
                case 7: {
                    source.setFilter(state.getDecoder().readMap(stream, state));
                    continue block13;
                }
                case 8: {
                    source.setDefaultOutcome(state.getDecoder().readObject(stream, state, Outcome.class));
                    continue block13;
                }
                case 9: {
                    source.setOutcomes(state.getDecoder().readMultiple(stream, state, Symbol.class));
                    continue block13;
                }
                case 10: {
                    source.setCapabilities(state.getDecoder().readMultiple(stream, state, Symbol.class));
                }
            }
        }
        return source;
    }
}

