/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.types.transport;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBufferAllocator;
import org.apache.qpid.protonj2.types.DeliveryTag;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.transport.DeliveryState;
import org.apache.qpid.protonj2.types.transport.Performative;
import org.apache.qpid.protonj2.types.transport.ReceiverSettleMode;

public final class Transfer
implements Performative {
    public static final UnsignedLong DESCRIPTOR_CODE = UnsignedLong.valueOf(20L);
    public static final Symbol DESCRIPTOR_SYMBOL = Symbol.valueOf("amqp:transfer:list");
    private static final long UINT_MAX = 0xFFFFFFFFL;
    private static final int HANDLE = 1;
    private static final int DELIVERY_ID = 2;
    private static final int DELIVERY_TAG = 4;
    private static final int MESSAGE_FORMAT = 8;
    private static final int SETTLED = 16;
    private static final int MORE = 32;
    private static final int RCV_SETTLE_MODE = 64;
    private static final int STATE = 128;
    private static final int RESUME = 256;
    private static final int ABORTED = 512;
    private static final int BATCHABLE = 1024;
    private int modified = 0;
    private long handle;
    private long deliveryId;
    private DeliveryTag deliveryTag;
    private long messageFormat;
    private boolean settled;
    private boolean more;
    private ReceiverSettleMode rcvSettleMode;
    private DeliveryState state;
    private boolean resume;
    private boolean aborted;
    private boolean batchable;

    public boolean isEmpty() {
        return this.modified == 0;
    }

    public int getElementCount() {
        return 32 - Integer.numberOfLeadingZeros(this.modified);
    }

    public boolean hasElement(int index) {
        int value = 1 << index;
        return (this.modified & value) == value;
    }

    public boolean hasHandle() {
        return (this.modified & 1) == 1;
    }

    public boolean hasDeliveryId() {
        return (this.modified & 2) == 2;
    }

    public boolean hasDeliveryTag() {
        return (this.modified & 4) == 4;
    }

    public boolean hasMessageFormat() {
        return (this.modified & 8) == 8;
    }

    public boolean hasSettled() {
        return (this.modified & 0x10) == 16;
    }

    public boolean hasMore() {
        return (this.modified & 0x20) == 32;
    }

    public boolean hasRcvSettleMode() {
        return (this.modified & 0x40) == 64;
    }

    public boolean hasState() {
        return (this.modified & 0x80) == 128;
    }

    public boolean hasResume() {
        return (this.modified & 0x100) == 256;
    }

    public boolean hasAborted() {
        return (this.modified & 0x200) == 512;
    }

    public boolean hasBatchable() {
        return (this.modified & 0x400) == 1024;
    }

    public long getHandle() {
        return this.handle;
    }

    public Transfer setHandle(int handle) {
        this.modified |= 1;
        this.handle = Integer.toUnsignedLong(handle);
        return this;
    }

    public Transfer setHandle(long handle) {
        if (handle < 0L || handle > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Handle value given is out of range: " + handle);
        }
        this.modified |= 1;
        this.handle = handle;
        return this;
    }

    public Transfer clearHandle() {
        this.modified &= 0xFFFFFFFE;
        this.handle = 0L;
        return this;
    }

    public long getDeliveryId() {
        return this.deliveryId;
    }

    public Transfer setDeliveryId(int deliveryId) {
        this.modified |= 2;
        this.deliveryId = Integer.toUnsignedLong(deliveryId);
        return this;
    }

    public Transfer setDeliveryId(long deliveryId) {
        if (deliveryId < 0L || deliveryId > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Delivery ID value given is out of range: " + deliveryId);
        }
        this.modified |= 2;
        this.deliveryId = deliveryId;
        return this;
    }

    public Transfer clearDeliveryId() {
        this.modified &= 0xFFFFFFFD;
        this.deliveryId = 0L;
        return this;
    }

    public DeliveryTag getDeliveryTag() {
        return this.deliveryTag;
    }

    public Transfer setDeliveryTag(byte[] tagBytes) {
        if (tagBytes != null) {
            return this.setDeliveryTag(new DeliveryTag.ProtonDeliveryTag(ProtonBufferAllocator.defaultAllocator().copy(tagBytes)));
        }
        return this.setDeliveryTag((DeliveryTag)null);
    }

    public Transfer setDeliveryTag(ProtonBuffer tagBytes) {
        if (tagBytes != null) {
            return this.setDeliveryTag(new DeliveryTag.ProtonDeliveryTag(tagBytes));
        }
        return this.setDeliveryTag((DeliveryTag)null);
    }

    public Transfer setDeliveryTag(DeliveryTag deliveryTag) {
        this.modified = deliveryTag != null ? (this.modified |= 4) : (this.modified &= 0xFFFFFFFB);
        this.deliveryTag = deliveryTag;
        return this;
    }

    public Transfer clearDeliveryTag() {
        this.modified &= 0xFFFFFFFB;
        this.deliveryTag = null;
        return this;
    }

    public long getMessageFormat() {
        return this.messageFormat;
    }

    public Transfer setMessageFormat(int messageFormat) {
        this.modified |= 8;
        this.messageFormat = Integer.toUnsignedLong(messageFormat);
        return this;
    }

    public Transfer setMessageFormat(long messageFormat) {
        if (messageFormat < 0L || messageFormat > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Message Format value given is out of range: " + messageFormat);
        }
        this.modified |= 8;
        this.messageFormat = messageFormat;
        return this;
    }

    public Transfer clearMessageFormat() {
        this.modified &= 0xFFFFFFF7;
        this.messageFormat = 0L;
        return this;
    }

    public boolean getSettled() {
        return this.settled;
    }

    public Transfer setSettled(boolean settled) {
        this.modified |= 0x10;
        this.settled = settled;
        return this;
    }

    public Transfer clearSettled() {
        this.modified &= 0xFFFFFFEF;
        this.settled = false;
        return this;
    }

    public boolean getMore() {
        return this.more;
    }

    public Transfer setMore(boolean more) {
        this.modified |= 0x20;
        this.more = more;
        return this;
    }

    public Transfer clearMore() {
        this.modified &= 0xFFFFFFDF;
        this.more = false;
        return this;
    }

    public ReceiverSettleMode getRcvSettleMode() {
        return this.rcvSettleMode;
    }

    public Transfer setRcvSettleMode(ReceiverSettleMode rcvSettleMode) {
        this.modified = rcvSettleMode != null ? (this.modified |= 0x40) : (this.modified &= 0xFFFFFFBF);
        this.rcvSettleMode = rcvSettleMode;
        return this;
    }

    public Transfer clearRcvSettleMode() {
        this.modified &= 0xFFFFFFBF;
        this.rcvSettleMode = null;
        return this;
    }

    public DeliveryState getState() {
        return this.state;
    }

    public Transfer setState(DeliveryState state) {
        this.modified = state != null ? (this.modified |= 0x80) : (this.modified &= 0xFFFFFF7F);
        this.state = state;
        return this;
    }

    public Transfer clearState() {
        this.modified &= 0xFFFFFF7F;
        this.state = null;
        return this;
    }

    public boolean getResume() {
        return this.resume;
    }

    public Transfer setResume(boolean resume) {
        this.modified |= 0x100;
        this.resume = resume;
        return this;
    }

    public Transfer clearResume() {
        this.modified &= 0xFFFFFEFF;
        this.resume = false;
        return this;
    }

    public boolean getAborted() {
        return this.aborted;
    }

    public Transfer setAborted(boolean aborted) {
        this.modified |= 0x200;
        this.aborted = aborted;
        return this;
    }

    public Transfer clearAborted() {
        this.modified &= 0xFFFFFDFF;
        this.aborted = false;
        return this;
    }

    public boolean getBatchable() {
        return this.batchable;
    }

    public Transfer setBatchable(boolean batchable) {
        this.modified |= 0x400;
        this.batchable = batchable;
        return this;
    }

    public Transfer clearBatchable() {
        this.modified &= 0xFFFFFBFF;
        this.batchable = false;
        return this;
    }

    public Transfer reset() {
        this.modified = 0;
        this.handle = 0L;
        this.deliveryId = 0L;
        this.deliveryTag = null;
        this.messageFormat = 0L;
        this.settled = false;
        this.more = false;
        this.rcvSettleMode = null;
        this.state = null;
        this.resume = false;
        this.aborted = false;
        this.batchable = false;
        return this;
    }

    @Override
    public Transfer copy() {
        Transfer copy = new Transfer();
        copy.handle = this.handle;
        copy.deliveryId = this.deliveryId;
        copy.deliveryTag = this.deliveryTag == null ? null : this.deliveryTag.copy();
        copy.messageFormat = this.messageFormat;
        copy.settled = this.settled;
        copy.more = this.more;
        copy.rcvSettleMode = this.rcvSettleMode;
        copy.state = this.state;
        copy.resume = this.resume;
        copy.aborted = this.aborted;
        copy.batchable = this.batchable;
        copy.modified = this.modified;
        return copy;
    }

    @Override
    public Performative.PerformativeType getPerformativeType() {
        return Performative.PerformativeType.TRANSFER;
    }

    @Override
    public <E> void invoke(Performative.PerformativeHandler<E> handler, ProtonBuffer payload, int channel, E context) {
        handler.handleTransfer(this, payload, channel, context);
    }

    public String toString() {
        return "Transfer{handle=" + String.valueOf(this.hasHandle() ? Long.valueOf(this.handle) : "null") + ", deliveryId=" + String.valueOf(this.hasDeliveryId() ? Long.valueOf(this.deliveryId) : "null") + ", deliveryTag=" + String.valueOf(this.hasDeliveryTag() ? this.deliveryTag : "null") + ", messageFormat=" + String.valueOf(this.hasMessageFormat() ? Long.valueOf(this.messageFormat) : "null") + ", settled=" + String.valueOf(this.hasSettled() ? Boolean.valueOf(this.settled) : "null") + ", more=" + String.valueOf(this.hasMore() ? Boolean.valueOf(this.more) : "null") + ", rcvSettleMode=" + String.valueOf(this.hasRcvSettleMode() ? this.rcvSettleMode : "null") + ", state=" + String.valueOf(this.hasState() ? this.state : "null") + ", resume=" + String.valueOf(this.hasResume() ? Boolean.valueOf(this.resume) : "null") + ", aborted=" + String.valueOf(this.hasAborted() ? Boolean.valueOf(this.aborted) : "null") + ", batchable=" + String.valueOf(this.hasBatchable() ? Boolean.valueOf(this.batchable) : "null") + "}";
    }
}

