/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.buffer.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBufferClosedException;
import org.apache.qpid.protonj2.buffer.ProtonBufferComponent;
import org.apache.qpid.protonj2.buffer.ProtonBufferComponentAccessor;
import org.apache.qpid.protonj2.buffer.ProtonBufferIterator;
import org.apache.qpid.protonj2.buffer.ProtonBufferReadOnlyException;
import org.apache.qpid.protonj2.buffer.ProtonBufferUtils;
import org.apache.qpid.protonj2.buffer.netty.Netty4ProtonBufferAllocator;
import org.apache.qpid.protonj2.resource.SharedResource;

public final class Netty4ToProtonBufferAdapter
extends SharedResource<ProtonBuffer>
implements ProtonBuffer,
ProtonBufferComponentAccessor,
ProtonBufferComponent {
    private final Netty4ProtonBufferAllocator allocator;
    private static final int CLOSED_MARKER = -1;
    private ByteBuf resource;
    private boolean closed;
    private boolean readOnly;
    private int readCapacity;
    private int writeCapacity;
    private int readOffset;
    private int writeOffset;
    private int implicitGrowthLimit = 0x7FFFFFF7;

    public Netty4ToProtonBufferAdapter(Netty4ProtonBufferAllocator allocator, ByteBuf resource) {
        this(allocator, resource, Objects.requireNonNull(resource, "The provided ByteBuf instance cannot be null").isReadOnly());
    }

    private Netty4ToProtonBufferAdapter(Netty4ProtonBufferAllocator allocator, ByteBuf resource, boolean readOnly) {
        this.allocator = allocator;
        this.resource = resource;
        this.readOnly = readOnly;
        this.readCapacity = resource.capacity();
        this.writeCapacity = readOnly ? -1 : this.readCapacity;
        this.readOffset = resource.readerIndex();
        this.writeOffset = resource.writerIndex();
    }

    public Netty4ProtonBufferAllocator allocator() {
        return this.allocator;
    }

    public ByteBuf unwrapAndRelease() {
        if (!this.closed) {
            try {
                ByteBuf byteBuf = this.resource.setIndex(this.readOffset, this.writeOffset);
                return byteBuf;
            }
            finally {
                this.resource = Unpooled.EMPTY_BUFFER;
            }
        }
        throw new ProtonBufferClosedException("The buffer has already been closed or transferred");
    }

    public ByteBuf unwrap() {
        ProtonBufferUtils.checkIsClosed(this);
        return this.resource.setIndex(this.readOffset, this.writeOffset);
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public int componentCount() {
        return 1;
    }

    @Override
    public int readableComponentCount() {
        return this.isReadable() ? 1 : 0;
    }

    @Override
    public int writableComponentCount() {
        return this.isWritable() ? 1 : 0;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public ProtonBuffer convertToReadOnly() {
        this.readOnly = true;
        this.writeCapacity = -1;
        return this;
    }

    @Override
    public int getReadOffset() {
        return this.readOffset;
    }

    @Override
    public ProtonBuffer setReadOffset(int value) {
        this.checkRead(value, 0);
        this.readOffset = value;
        return this;
    }

    @Override
    public int getReadableBytes() {
        return this.writeOffset - this.readOffset;
    }

    @Override
    public int getWriteOffset() {
        return this.writeOffset;
    }

    @Override
    public ProtonBuffer setWriteOffset(int value) {
        this.checkWrite(value, 0, false);
        this.writeOffset = value;
        return this;
    }

    @Override
    public int getWritableBytes() {
        return Math.max(0, this.writeCapacity - this.writeOffset);
    }

    @Override
    public int capacity() {
        return Math.max(0, this.readCapacity);
    }

    @Override
    public int implicitGrowthLimit() {
        return this.implicitGrowthLimit;
    }

    @Override
    public ProtonBuffer implicitGrowthLimit(int limit) {
        ProtonBufferUtils.checkImplicitGrowthLimit(limit, this.capacity());
        this.implicitGrowthLimit = limit;
        return this;
    }

    @Override
    public ProtonBuffer fill(byte value) {
        ProtonBufferUtils.checkIsClosed(this);
        ProtonBufferUtils.checkIsReadOnly(this);
        try {
            if (this.resource.hasArray()) {
                Arrays.fill(this.resource.array(), this.resource.arrayOffset(), this.resource.arrayOffset() + this.resource.capacity(), value);
            } else {
                for (int i = 0; i < this.resource.capacity(); ++i) {
                    this.resource.setByte(i, (int)value);
                }
            }
        }
        catch (RuntimeException e) {
            throw this.translateNettyToProtonException(e, true);
        }
        return this;
    }

    @Override
    public ProtonBuffer compact() {
        ProtonBufferUtils.checkIsClosed(this);
        if (this.isReadOnly()) {
            throw ProtonBufferUtils.genericBufferIsReadOnly(this);
        }
        this.resource.setIndex(this.readOffset, this.writeOffset).discardReadBytes();
        this.readOffset = this.resource.readerIndex();
        this.writeOffset = this.resource.writerIndex();
        return this;
    }

    @Override
    public void copyInto(int offset, byte[] destination, int destOffset, int length) {
        ProtonBufferUtils.checkIsClosed(this);
        this.resource.getBytes(offset, destination, destOffset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyInto(int offset, ByteBuffer destination, int destOffset, int length) {
        ProtonBufferUtils.checkIsClosed(this);
        if (destination.isReadOnly()) {
            throw new ProtonBufferReadOnlyException();
        }
        int oldPos = destination.position();
        int oldLimit = destination.limit();
        destination.position(destOffset).limit(destOffset + length);
        try {
            this.resource.getBytes(offset, destination);
        }
        finally {
            destination.position(oldPos).limit(oldLimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyInto(int offset, ProtonBuffer destination, int destOffset, int length) {
        ProtonBufferUtils.checkIsClosed(this);
        if (destination.isReadOnly()) {
            throw ProtonBufferUtils.genericBufferIsReadOnly(destination);
        }
        int oldRPos = destination.getReadOffset();
        int oldWPos = destination.getWriteOffset();
        destination.setReadOffset(0);
        destination.setWriteOffset(destOffset);
        try (ProtonBufferComponentAccessor accessor = destination.componentAccessor();){
            ProtonBufferComponent componenet = accessor.firstWritable();
            while (componenet != null && length > 0) {
                int toWrite = Math.min(componenet.getWritableBytes(), length);
                if (componenet.hasWritableArray()) {
                    this.resource.getBytes(offset, componenet.getWritableArray(), componenet.getWritableArrayOffset(), toWrite);
                } else {
                    this.resource.getBytes(offset, componenet.getWritableBuffer().limit(toWrite));
                }
                length -= toWrite;
                offset += toWrite;
                componenet = accessor.nextWritable();
            }
        }
        finally {
            destination.setWriteOffset(oldWPos);
            destination.setReadOffset(oldRPos);
        }
    }

    @Override
    public ProtonBuffer writeBytes(byte[] source, int offset, int length) {
        this.checkWrite(this.writeOffset, length, true);
        this.resource.setBytes(this.writeOffset, source, offset, length);
        this.writeOffset += length;
        return this;
    }

    @Override
    public ProtonBuffer writeBytes(ByteBuffer source) {
        int remaining = source.remaining();
        this.checkWrite(this.writeOffset, source.remaining(), true);
        this.resource.setBytes(this.writeOffset, source);
        this.writeOffset += remaining;
        return this;
    }

    @Override
    public ProtonBuffer writeBytes(ProtonBuffer source) {
        int size = source.getReadableBytes();
        this.checkWrite(this.writeOffset, size, true);
        source.copyInto(source.getReadOffset(), this, this.writeOffset, size);
        source.advanceReadOffset(size);
        this.writeOffset += size;
        return this;
    }

    @Override
    public ProtonBuffer readBytes(ByteBuffer destination) {
        int remaining = destination.remaining();
        this.checkRead(this.readOffset, remaining);
        this.resource.getBytes(this.readOffset, destination);
        this.readOffset += remaining;
        return this;
    }

    @Override
    public ProtonBuffer readBytes(byte[] destination, int offset, int length) {
        this.checkRead(this.readOffset, length);
        this.resource.getBytes(this.readOffset, destination, offset, length);
        this.readOffset += length;
        return this;
    }

    @Override
    public ProtonBuffer ensureWritable(int size, int minimumGrowth, boolean allowCompaction) throws IndexOutOfBoundsException, IllegalArgumentException {
        ProtonBufferUtils.checkIsClosed(this);
        if (this.isReadOnly()) {
            throw ProtonBufferUtils.genericBufferIsReadOnly(this);
        }
        ProtonBufferUtils.checkBufferCanGrowTo(this.writeCapacity, size);
        if (this.getWritableBytes() >= size) {
            return this;
        }
        if (allowCompaction && this.readOffset > 0) {
            this.compact();
            if (this.getWritableBytes() >= size) {
                return this;
            }
        }
        int growBy = Math.max(minimumGrowth, size - this.getWritableBytes());
        this.resource.setIndex(this.readOffset, this.writeOffset).ensureWritable(growBy, true);
        if (this.resource.writableBytes() < size) {
            int target = this.resource.capacity() + growBy;
            ProtonBufferUtils.checkBufferCanGrowTo(this.resource.capacity(), target);
            ByteBuf copy = this.allocator.allocator().buffer(target, target);
            ByteBuf dropped = this.resource;
            this.resource.getBytes(0, copy, 0, this.resource.capacity());
            int roff = this.getReadOffset();
            int woff = this.getWriteOffset();
            ReferenceCountUtil.safeRelease((Object)dropped);
            this.resource = copy;
            this.resource.writerIndex(woff);
            this.resource.readerIndex(roff);
        }
        this.writeCapacity = this.readCapacity = this.resource.capacity();
        return this;
    }

    @Override
    public ProtonBuffer copy(int index, int length, boolean readOnly) throws IllegalArgumentException {
        Netty4ToProtonBufferAdapter copy;
        ProtonBufferUtils.checkIsClosed(this);
        if (this.readOnly && readOnly) {
            copy = this.allocator.wrap(this.resource.retainedSlice(index, length));
            copy.setReadOffset(0);
            ((ByteBuf)copy.unwrap()).writerIndex(length);
            copy.convertToReadOnly();
        } else {
            copy = this.allocator.wrap(this.resource.copy(index, length));
            if (readOnly) {
                copy.convertToReadOnly();
            }
        }
        return copy;
    }

    @Override
    public ProtonBuffer split(int splitOffset) {
        ProtonBufferUtils.checkIsClosed(this);
        ProtonBufferUtils.checkIsNotNegative(splitOffset, "Split offset cannot be negative");
        if (splitOffset > this.capacity()) {
            throw new IllegalArgumentException("Split offset cannot exceed buffer capacity");
        }
        int woff = this.getWriteOffset();
        int roff = this.getReadOffset();
        Netty4ToProtonBufferAdapter splitBuffer = new Netty4ToProtonBufferAdapter(this.allocator, this.resource.retainedSlice(0, splitOffset));
        splitBuffer.setWriteOffset(Math.min(woff, splitOffset));
        splitBuffer.setReadOffset(Math.min(roff, splitOffset));
        if (this.readOnly) {
            splitBuffer.convertToReadOnly();
        }
        this.resource = this.resource.slice(splitOffset, this.capacity() - splitOffset);
        this.resource.writerIndex(Math.max(woff, splitOffset) - splitOffset);
        this.resource.readerIndex(Math.max(roff, splitOffset) - splitOffset);
        this.readCapacity = this.resource.capacity();
        this.writeCapacity = this.isReadOnly() ? -1 : this.readCapacity;
        this.readOffset = this.resource.readerIndex();
        this.writeOffset = this.resource.writerIndex();
        return splitBuffer;
    }

    @Override
    public String toString(Charset charset) {
        return this.resource.toString(charset);
    }

    public String toString() {
        return "Netty4ToProtonBufferAdapter{ read:" + this.readOffset + ", write: " + this.writeOffset + ", capacity: " + this.readCapacity + "}";
    }

    @Override
    public int compareTo(ProtonBuffer buffer) {
        return ProtonBufferUtils.compare(this, buffer);
    }

    public boolean equals(Object other) {
        if (other instanceof ProtonBuffer) {
            return ProtonBufferUtils.equals(this, (ProtonBuffer)other);
        }
        return false;
    }

    public int hashCode() {
        return ProtonBufferUtils.hashCode(this);
    }

    @Override
    public byte getByte(int index) {
        this.checkGet(index, 1);
        return this.resource.getByte(index);
    }

    @Override
    public int getUnsignedByte(int index) {
        this.checkGet(index, 1);
        return this.resource.getUnsignedByte(index);
    }

    @Override
    public char getChar(int index) {
        this.checkGet(index, 2);
        return this.resource.getChar(index);
    }

    @Override
    public short getShort(int index) {
        this.checkGet(index, 2);
        return this.resource.getShort(index);
    }

    @Override
    public int getInt(int index) {
        this.checkGet(index, 4);
        return this.resource.getInt(index);
    }

    @Override
    public long getLong(int index) {
        this.checkGet(index, 8);
        return this.resource.getLong(index);
    }

    @Override
    public ProtonBuffer setByte(int index, byte value) {
        try {
            this.checkSet(index, 1);
            this.resource.setByte(index, (int)value);
        }
        catch (RuntimeException e) {
            throw this.translateNettyToProtonException(e, true);
        }
        return this;
    }

    @Override
    public ProtonBuffer setChar(int index, char value) {
        try {
            this.checkSet(index, 2);
            this.resource.setChar(index, (int)value);
        }
        catch (RuntimeException e) {
            throw this.translateNettyToProtonException(e, true);
        }
        return this;
    }

    @Override
    public ProtonBuffer setShort(int index, short value) {
        try {
            this.checkSet(index, 2);
            this.resource.setShort(index, (int)value);
        }
        catch (RuntimeException e) {
            throw this.translateNettyToProtonException(e, true);
        }
        return this;
    }

    @Override
    public ProtonBuffer setInt(int index, int value) {
        try {
            this.checkSet(index, 4);
            this.resource.setInt(index, value);
        }
        catch (RuntimeException e) {
            throw this.translateNettyToProtonException(e, true);
        }
        return this;
    }

    @Override
    public ProtonBuffer setLong(int index, long value) {
        try {
            this.checkSet(index, 8);
            this.resource.setLong(index, value);
        }
        catch (RuntimeException e) {
            throw this.translateNettyToProtonException(e, true);
        }
        return this;
    }

    @Override
    public byte readByte() {
        this.checkRead(this.readOffset, 1);
        return this.resource.getByte(this.readOffset++);
    }

    @Override
    public char readChar() {
        this.checkRead(this.readOffset, 2);
        char result = this.resource.getChar(this.readOffset);
        this.readOffset += 2;
        return result;
    }

    @Override
    public short readShort() {
        this.checkRead(this.readOffset, 2);
        short result = this.resource.getShort(this.readOffset);
        this.readOffset += 2;
        return result;
    }

    @Override
    public int readInt() {
        this.checkRead(this.readOffset, 4);
        int result = this.resource.getInt(this.readOffset);
        this.readOffset += 4;
        return result;
    }

    @Override
    public long readLong() {
        this.checkRead(this.readOffset, 8);
        long result = this.resource.getLong(this.readOffset);
        this.readOffset += 8;
        return result;
    }

    @Override
    public ProtonBuffer writeByte(byte value) {
        this.checkWrite(this.writeOffset, 1, true);
        try {
            this.resource.setByte(this.writeOffset++, (int)value);
        }
        catch (RuntimeException e) {
            throw this.translateNettyToProtonException(e, true);
        }
        return this;
    }

    @Override
    public ProtonBuffer writeChar(char value) {
        this.checkWrite(this.writeOffset, 2, true);
        try {
            this.resource.setChar(this.writeOffset, (int)value);
            this.writeOffset += 2;
        }
        catch (RuntimeException e) {
            throw this.translateNettyToProtonException(e, true);
        }
        return this;
    }

    @Override
    public ProtonBuffer writeShort(short value) {
        this.checkWrite(this.writeOffset, 2, true);
        try {
            this.resource.setShort(this.writeOffset, (int)value);
            this.writeOffset += 2;
        }
        catch (RuntimeException e) {
            throw this.translateNettyToProtonException(e, true);
        }
        return this;
    }

    @Override
    public ProtonBuffer writeInt(int value) {
        this.checkWrite(this.writeOffset, 4, true);
        try {
            this.resource.setInt(this.writeOffset, value);
            this.writeOffset += 4;
        }
        catch (RuntimeException e) {
            throw this.translateNettyToProtonException(e, true);
        }
        return this;
    }

    @Override
    public ProtonBuffer writeLong(long value) {
        this.checkWrite(this.writeOffset, 8, true);
        try {
            this.resource.setLong(this.writeOffset, value);
            this.writeOffset += 8;
        }
        catch (RuntimeException e) {
            throw this.translateNettyToProtonException(e, true);
        }
        return this;
    }

    @Override
    public int transferTo(WritableByteChannel channel, int length) throws IOException {
        ProtonBufferUtils.checkIsClosed(this);
        ProtonBufferUtils.checkIsNotNegative(length, "transferTo length value cannot be negative: " + length);
        int writableBytes = Math.min(length, this.getReadableBytes());
        if (writableBytes == 0) {
            return 0;
        }
        ByteBuffer nioBuffer = this.resource.nioBuffer(this.readOffset, writableBytes);
        int written = channel.write(nioBuffer);
        this.readOffset += written;
        return written;
    }

    @Override
    public int transferFrom(ReadableByteChannel channel, int length) throws IOException {
        ProtonBufferUtils.checkIsClosed(this);
        ProtonBufferUtils.checkIsNotNegative(length, "transferTo length value cannot be negative: " + length);
        ProtonBufferUtils.checkIsReadOnly(this);
        int readableBytes = Math.min(length, this.getWritableBytes());
        if (readableBytes == 0) {
            return 0;
        }
        ByteBuffer nioBuffer = this.resource.nioBuffer(this.writeOffset, readableBytes);
        int bytesRead = channel.read(nioBuffer);
        this.writeOffset += bytesRead > 0 ? bytesRead : 0;
        return bytesRead;
    }

    @Override
    public int transferFrom(FileChannel channel, long position, int length) throws IOException {
        ProtonBufferUtils.checkIsClosed(this);
        ProtonBufferUtils.checkIsNotNegative(length, "transferTo length value cannot be negative: " + length);
        ProtonBufferUtils.checkIsReadOnly(this);
        int readableBytes = Math.min(length, this.getWritableBytes());
        if (readableBytes == 0) {
            return 0;
        }
        ByteBuffer nioBuffer = this.resource.nioBuffer(this.writeOffset, readableBytes);
        int bytesRead = channel.read(nioBuffer, position);
        this.writeOffset += bytesRead > 0 ? bytesRead : 0;
        return bytesRead;
    }

    @Override
    public ProtonBufferComponentAccessor componentAccessor() {
        if (this.isClosed()) {
            throw ProtonBufferUtils.genericBufferIsClosed(this);
        }
        return (ProtonBufferComponentAccessor)this.acquire();
    }

    @Override
    public ProtonBufferComponent first() {
        return this;
    }

    @Override
    public ProtonBufferComponent next() {
        return null;
    }

    @Override
    public boolean hasReadbleArray() {
        return this.resource.hasArray();
    }

    @Override
    public Netty4ToProtonBufferAdapter advanceReadOffset(int amount) {
        return (Netty4ToProtonBufferAdapter)ProtonBuffer.super.advanceReadOffset(amount);
    }

    @Override
    public byte[] getReadableArray() {
        return this.resource.array();
    }

    @Override
    public int getReadableArrayOffset() {
        return this.resource.arrayOffset() + this.getReadOffset();
    }

    @Override
    public int getReadableArrayLength() {
        return this.resource.capacity();
    }

    @Override
    public ByteBuffer getReadableBuffer() {
        return this.resource.nioBuffer(this.readOffset, this.getReadableBytes()).asReadOnlyBuffer();
    }

    @Override
    public Netty4ToProtonBufferAdapter advanceWriteOffset(int amount) {
        return (Netty4ToProtonBufferAdapter)ProtonBuffer.super.advanceWriteOffset(amount);
    }

    @Override
    public boolean hasWritableArray() {
        return this.resource.hasArray() && !this.isReadOnly();
    }

    @Override
    public byte[] getWritableArray() {
        return this.resource.array();
    }

    @Override
    public int getWritableArrayOffset() {
        return this.resource.arrayOffset() + this.getWriteOffset();
    }

    @Override
    public int getWritableArrayLength() {
        return this.getWritableBytes();
    }

    @Override
    public ByteBuffer getWritableBuffer() {
        if (this.hasWritableArray()) {
            return ByteBuffer.wrap(this.resource.array(), this.resource.arrayOffset() + this.writeOffset, this.getWritableBytes());
        }
        return this.resource.nioBuffer(this.writeOffset, this.getWritableBytes());
    }

    @Override
    public long getNativeAddress() {
        return 0L;
    }

    @Override
    public long getNativeReadAddress() {
        return 0L;
    }

    @Override
    public long getNativeWriteAddress() {
        return 0L;
    }

    @Override
    public ProtonBufferIterator bufferIterator(int offset, int length) {
        ProtonBufferUtils.checkIsClosed(this);
        ProtonBufferUtils.checkIsNotNegative(length, "length");
        ProtonBufferUtils.checkIsNotNegative(offset, "length");
        if (offset + length > this.resource.capacity()) {
            throw new IndexOutOfBoundsException("The iterator cannot read beyond the bounds of the buffer: offset=" + offset + ", length=" + length);
        }
        return new Netty4ToProtonBufferIterator(this.resource, offset, length);
    }

    @Override
    public ProtonBufferIterator bufferIterator() {
        return this.bufferIterator(this.getReadOffset(), this.getReadableBytes());
    }

    @Override
    public ProtonBufferIterator bufferReverseIterator(int offset, int length) {
        ProtonBufferUtils.checkIsClosed(this);
        ProtonBufferUtils.checkIsNotNegative(length, "length");
        ProtonBufferUtils.checkIsNotNegative(offset, "length");
        if (offset >= this.capacity()) {
            throw new IndexOutOfBoundsException("Read offset must be within the bounds of the buffer: offset = " + offset + ", capacity = " + this.capacity());
        }
        if (offset - length < -1) {
            throw new IndexOutOfBoundsException("Cannot read past start of buffer: offset = " + offset + ", length = " + length);
        }
        return new Netty4ToProtonBufferReverseIterator(this.resource, offset, length);
    }

    @Override
    public int indexOf(byte needle, int offset, int length) {
        ProtonBufferUtils.checkIsClosed(this);
        int count = this.resource.bytesBefore(offset, length, needle);
        return count >= 0 ? offset + count : -1;
    }

    @Override
    protected void releaseResourceOwnership() {
        this.closed = true;
        try {
            if (this.resource != Unpooled.EMPTY_BUFFER) {
                ReferenceCountUtil.safeRelease((Object)this.resource);
            }
        }
        finally {
            this.resource = Unpooled.EMPTY_BUFFER;
            this.readOnly = false;
            this.writeCapacity = -1;
            this.readCapacity = -1;
            this.readOffset = 0;
            this.writeOffset = 0;
        }
    }

    @Override
    protected ProtonBuffer transferTheResource() {
        try {
            Netty4ToProtonBufferAdapter netty4ToProtonBufferAdapter = new Netty4ToProtonBufferAdapter(this.allocator, this.resource.setIndex(this.readOffset, this.writeOffset), this.readOnly);
            return netty4ToProtonBufferAdapter;
        }
        finally {
            this.resource = Unpooled.EMPTY_BUFFER;
        }
    }

    @Override
    protected RuntimeException resourceIsClosedException() {
        return ProtonBufferUtils.genericBufferIsClosed(this);
    }

    private void checkRead(int index, int size) {
        if (index < 0 || this.writeOffset < index + size || this.closed) {
            if (this.closed) {
                throw ProtonBufferUtils.genericBufferIsClosed(this);
            }
            throw ProtonBufferUtils.genericOutOfBounds(this, index);
        }
    }

    private void checkGet(int index, int size) {
        if (index < 0 || this.readCapacity < index + size) {
            if (this.closed) {
                throw ProtonBufferUtils.genericBufferIsClosed(this);
            }
            throw ProtonBufferUtils.genericOutOfBounds(this, index);
        }
    }

    private void checkSet(int index, int size) {
        if (index < 0 || this.writeCapacity < index + size) {
            this.expandOrThrowError(index, size, false);
        }
    }

    private void checkWrite(int index, int size, boolean allowExpansion) {
        if (index < this.readOffset || this.writeCapacity < index + size) {
            this.expandOrThrowError(index, size, allowExpansion);
        }
    }

    private void expandOrThrowError(int index, int size, boolean mayExpand) {
        if (this.readCapacity == -1) {
            throw ProtonBufferUtils.genericBufferIsClosed(this);
        }
        if (this.readOnly) {
            throw ProtonBufferUtils.genericBufferIsReadOnly(this);
        }
        int capacity = this.capacity();
        if (mayExpand && index >= 0 && index <= capacity && this.writeOffset + size <= this.implicitGrowthLimit) {
            int minimumGrowth = Math.min(Math.max(capacity * 2, size), this.implicitGrowthLimit) - capacity;
            this.ensureWritable(size, minimumGrowth, false);
            this.checkSet(index, size);
            return;
        }
        throw ProtonBufferUtils.genericOutOfBounds(this, index);
    }

    private RuntimeException translateNettyToProtonException(RuntimeException caught, boolean write) {
        RuntimeException error = caught;
        if (caught instanceof IllegalReferenceCountException) {
            error = ProtonBufferUtils.genericBufferIsClosed(this);
            error.addSuppressed(caught);
        } else if (caught instanceof ReadOnlyBufferException) {
            error = ProtonBufferUtils.genericBufferIsReadOnly(this);
            error.addSuppressed(caught);
        } else if (this.resource.isReadOnly() && write && caught instanceof IndexOutOfBoundsException) {
            error = ProtonBufferUtils.genericBufferIsReadOnly(this);
            error.addSuppressed(caught);
        }
        return error;
    }

    private final class Netty4ToProtonBufferIterator
    implements ProtonBufferIterator {
        private final ByteBuf resource;
        private final int endIndex;
        private int current;

        public Netty4ToProtonBufferIterator(ByteBuf resource, int offset, int length) {
            this.resource = resource;
            this.current = offset;
            this.endIndex = offset + length;
        }

        @Override
        public boolean hasNext() {
            return this.current != this.endIndex;
        }

        @Override
        public byte next() {
            if (this.current == this.endIndex) {
                throw new NoSuchElementException("Cannot read outside the iterator bounds");
            }
            return this.resource.getByte(this.current++);
        }

        @Override
        public int remaining() {
            return this.endIndex - this.current;
        }

        @Override
        public int offset() {
            return this.current;
        }
    }

    private final class Netty4ToProtonBufferReverseIterator
    implements ProtonBufferIterator {
        private final ByteBuf resource;
        private final int endIndex;
        private int current;

        public Netty4ToProtonBufferReverseIterator(ByteBuf resource, int offset, int length) {
            this.resource = resource;
            this.current = offset;
            this.endIndex = offset - length;
        }

        @Override
        public boolean hasNext() {
            return this.current != this.endIndex;
        }

        @Override
        public byte next() {
            if (this.current == this.endIndex) {
                throw new NoSuchElementException("Cannot read outside the iterator bounds");
            }
            return this.resource.getByte(this.current--);
        }

        @Override
        public int remaining() {
            return Math.abs(this.endIndex - this.current);
        }

        @Override
        public int offset() {
            return this.current;
        }
    }
}

