/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.transport.netty5;

import io.netty5.channel.Channel;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.MultithreadEventLoopGroup;
import io.netty5.channel.epoll.Epoll;
import io.netty5.channel.epoll.EpollHandler;
import io.netty5.channel.epoll.EpollSocketChannel;
import java.util.concurrent.ThreadFactory;
import org.apache.qpid.protonj2.client.TransportOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EpollSupport {
    private static final Logger LOG = LoggerFactory.getLogger(EpollSupport.class);
    public static final String NAME = "EPOLL";

    public static boolean isAvailable(TransportOptions transportOptions) {
        try {
            return transportOptions.allowNativeIO() && Epoll.isAvailable();
        }
        catch (NoClassDefFoundError ncdfe) {
            LOG.debug("Unable to check for Epoll support due to missing class definition", (Throwable)ncdfe);
            return false;
        }
    }

    public static EventLoopGroup createGroup(int nThreads, ThreadFactory ioThreadFactory) {
        return new MultithreadEventLoopGroup(nThreads, ioThreadFactory, EpollHandler.newFactory());
    }

    public static Class<? extends Channel> getChannelClass() {
        return EpollSocketChannel.class;
    }
}

