/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.transport.netty4;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.protonj2.client.SslOptions;
import org.apache.qpid.protonj2.client.TransportOptions;
import org.apache.qpid.protonj2.client.transport.IOContext;
import org.apache.qpid.protonj2.client.transport.netty4.EpollSupport;
import org.apache.qpid.protonj2.client.transport.netty4.IOUringSupport;
import org.apache.qpid.protonj2.client.transport.netty4.KQueueSupport;
import org.apache.qpid.protonj2.client.transport.netty4.TcpTransport;
import org.apache.qpid.protonj2.client.transport.netty4.WebSocketTransport;
import org.apache.qpid.protonj2.client.util.TrackableThreadFactory;
import org.apache.qpid.protonj2.engine.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Netty4IOContext
implements IOContext {
    private static final Logger LOG = LoggerFactory.getLogger(Netty4IOContext.class);
    private static final int SHUTDOWN_TIMEOUT = 50;
    private static final int ASYNC_SHUTDOWN_TIMEOUT = 100;
    private static final int ASYNC_SHUTDOWN_QUIET_PERIOD = 10;
    private final EventLoopGroup group;
    private final NettyIOScheduler scheduler = new NettyIOScheduler();
    private final Class<? extends Channel> channelClass;
    private final TransportOptions options;
    private final SslOptions sslOptions;
    private final ThreadFactory threadFactory;

    public Netty4IOContext(TransportOptions options, SslOptions ssl, String ioThreadName) {
        Objects.requireNonNull(options, "Transport Options cannot be null");
        Objects.requireNonNull(ssl, "Transport SSL Options cannot be null");
        this.options = options;
        this.sslOptions = ssl;
        this.threadFactory = new TrackableThreadFactory(ioThreadName, true);
        String[] nativeIOPreference = options.nativeIOPreference();
        NioEventLoopGroup selectedGroup = null;
        Class<NioSocketChannel> selectedChannelClass = null;
        if (options.allowNativeIO()) {
            for (String nativeID : nativeIOPreference) {
                if ("EPOLL".equalsIgnoreCase(nativeID)) {
                    if (!EpollSupport.isAvailable(options)) continue;
                    LOG.trace("Netty Transports will be using Epoll mode");
                    selectedGroup = EpollSupport.createGroup(1, this.threadFactory);
                    selectedChannelClass = EpollSupport.getChannelClass();
                    break;
                }
                if ("IO_URING".equalsIgnoreCase(nativeID)) {
                    if (!IOUringSupport.isAvailable(options)) continue;
                    LOG.trace("Netty Transports will be using IO-Uring mode");
                    selectedGroup = IOUringSupport.createGroup(1, this.threadFactory);
                    selectedChannelClass = IOUringSupport.getChannelClass();
                    break;
                }
                if ("KQUEUE".equalsIgnoreCase(nativeID)) {
                    if (!KQueueSupport.isAvailable(options)) continue;
                    LOG.trace("Netty Transports will be using KQueue mode");
                    selectedGroup = KQueueSupport.createGroup(1, this.threadFactory);
                    selectedChannelClass = KQueueSupport.getChannelClass();
                    break;
                }
                throw new IllegalArgumentException(String.format("Provided preferred native transport type name: %s, is not supported.", nativeID));
            }
        }
        if (selectedGroup == null) {
            LOG.trace("Netty Transports will be using NIO mode");
            selectedGroup = new NioEventLoopGroup(1, this.threadFactory);
            selectedChannelClass = NioSocketChannel.class;
        }
        this.group = selectedGroup;
        this.channelClass = selectedChannelClass;
    }

    @Override
    public void shutdown() {
        if (!this.group.isShutdown()) {
            this.group.shutdownGracefully(0L, 50L, TimeUnit.MILLISECONDS);
            try {
                if (!this.group.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                    LOG.trace("Connection IO Event Loop shutdown failed to complete in allotted time");
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void shutdownAsync() {
        if (!this.group.isShutdown()) {
            this.group.shutdownGracefully(10L, 100L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public Scheduler ioScheduler() {
        return this.scheduler;
    }

    @Override
    public TcpTransport newTransport() {
        if (this.group.isShutdown() || this.group.isShuttingDown() || this.group.isTerminated()) {
            throw new IllegalStateException("Cannot create a Transport from a shutdown IO context");
        }
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().channel(this.channelClass)).group(this.group);
        TcpTransport transport = this.options.useWebSockets() ? new WebSocketTransport(bootstrap, this.options, this.sslOptions) : new TcpTransport(bootstrap, this.options, this.sslOptions);
        return transport;
    }

    public class NettyIOScheduler
    implements Scheduler,
    Executor {
        @Override
        public void execute(Runnable command) {
            Netty4IOContext.this.group.execute(command);
        }

        public Future<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return Netty4IOContext.this.group.schedule(command, delay, unit);
        }

        public <V> Future<V> schedule(Callable<V> task, long delay, TimeUnit unit) {
            return Netty4IOContext.this.group.schedule(task, delay, unit);
        }

        public Future<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return Netty4IOContext.this.group.scheduleAtFixedRate(command, initialDelay, period, unit);
        }

        public Future<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return Netty4IOContext.this.group.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }

        public boolean isShutdown() {
            return Netty4IOContext.this.group.isShutdown();
        }
    }
}

