/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.protonj2.client.Delivery;
import org.apache.qpid.protonj2.client.DeliveryState;
import org.apache.qpid.protonj2.client.Receiver;
import org.apache.qpid.protonj2.client.ReceiverOptions;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.exceptions.ClientIllegalStateException;
import org.apache.qpid.protonj2.client.exceptions.ClientOperationTimedOutException;
import org.apache.qpid.protonj2.client.futures.ClientFuture;
import org.apache.qpid.protonj2.client.impl.ClientDelivery;
import org.apache.qpid.protonj2.client.impl.ClientExceptionSupport;
import org.apache.qpid.protonj2.client.impl.ClientReceiverBuilder;
import org.apache.qpid.protonj2.client.impl.ClientReceiverLinkType;
import org.apache.qpid.protonj2.client.impl.ClientSession;
import org.apache.qpid.protonj2.client.util.FifoDeliveryQueue;
import org.apache.qpid.protonj2.engine.IncomingDelivery;
import org.apache.qpid.protonj2.types.messaging.Accepted;
import org.apache.qpid.protonj2.types.messaging.Released;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientReceiver
extends ClientReceiverLinkType<Receiver>
implements Receiver {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ReceiverOptions options;
    private final FifoDeliveryQueue deliveryQueue;

    ClientReceiver(ClientSession session, ReceiverOptions options, String receiverId, org.apache.qpid.protonj2.engine.Receiver receiver) {
        super(session, receiverId, options, receiver);
        this.options = options;
        if (options.creditWindow() > 0) {
            this.protonReceiver.addCredit(options.creditWindow());
        }
        this.deliveryQueue = new FifoDeliveryQueue(options.creditWindow());
        this.deliveryQueue.start();
    }

    @Override
    public Delivery receive() throws ClientException {
        return this.receive(-1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Delivery receive(long timeout, TimeUnit units) throws ClientException {
        this.checkClosedOrFailed();
        try {
            ClientDelivery delivery = this.deliveryQueue.dequeue(Math.max(-1L, units.toMillis(timeout)));
            if (delivery != null) {
                if (this.options.autoAccept()) {
                    this.disposition(delivery.protonDelivery(), (org.apache.qpid.protonj2.types.transport.DeliveryState)Accepted.getInstance(), this.options.autoSettle());
                } else if (this.options.creditWindow() > 0) {
                    this.executor.execute(() -> this.replenishCreditIfNeeded());
                }
                return delivery;
            }
            this.checkClosedOrFailed();
            return null;
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ClientException("Receive wait interrupted", e);
        }
    }

    @Override
    public Delivery tryReceive() throws ClientException {
        this.checkClosedOrFailed();
        ClientDelivery delivery = this.deliveryQueue.dequeueNoWait();
        if (delivery != null) {
            if (this.options.autoAccept()) {
                delivery.disposition(DeliveryState.accepted(), this.options.autoSettle());
            } else if (this.options.creditWindow() > 0) {
                this.executor.execute(() -> this.replenishCreditIfNeeded());
            }
        } else {
            this.checkClosedOrFailed();
        }
        return delivery;
    }

    @Override
    public long queuedDeliveries() {
        return this.deliveryQueue.size();
    }

    @Override
    public Receiver addCredit(int credits) throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture creditAdded = this.session.getFutureFactory().createFuture();
        this.executor.execute(() -> {
            if (this.notClosedOrFailed(creditAdded)) {
                if (this.options.creditWindow() != 0) {
                    creditAdded.failed(new ClientIllegalStateException("Cannot add credit when a credit window has been configured"));
                } else if (this.protonReceiver.isDraining()) {
                    creditAdded.failed(new ClientIllegalStateException("Cannot add credit while a drain is pending"));
                } else {
                    try {
                        this.protonReceiver.addCredit(credits);
                        creditAdded.complete(this);
                    }
                    catch (Exception ex) {
                        creditAdded.failed(ClientExceptionSupport.createNonFatalOrPassthrough(ex));
                    }
                }
            }
        });
        return (Receiver)this.session.request(this, creditAdded);
    }

    @Override
    public Future<Receiver> drain() throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture<Receiver> drainComplete = this.session.getFutureFactory().createFuture();
        this.executor.execute(() -> {
            if (this.notClosedOrFailed(drainComplete)) {
                if (this.protonReceiver.isDraining()) {
                    drainComplete.failed(new ClientIllegalStateException("Receiver is already draining"));
                    return;
                }
                try {
                    if (this.protonReceiver.drain()) {
                        this.drainingFuture = drainComplete;
                        this.drainingTimeout = this.session.scheduleRequestTimeout(this.drainingFuture, this.options.drainTimeout(), () -> new ClientOperationTimedOutException("Timed out waiting for remote to respond to drain request"));
                    } else {
                        drainComplete.complete(this);
                    }
                }
                catch (Exception ex) {
                    drainComplete.failed(ClientExceptionSupport.createNonFatalOrPassthrough(ex));
                }
            }
        });
        return drainComplete;
    }

    @Override
    protected Receiver self() {
        return this;
    }

    @Override
    protected void handleDeliveryRead(IncomingDelivery delivery) {
        LOG.trace("Delivery data was received: {}", (Object)delivery);
        if (delivery.getDefaultDeliveryState() == null) {
            delivery.setDefaultDeliveryState((org.apache.qpid.protonj2.types.transport.DeliveryState)Released.getInstance());
        }
        if (!delivery.isPartial()) {
            LOG.trace("{} has incoming Message(s).", (Object)this);
            this.deliveryQueue.enqueue(new ClientDelivery(this, delivery));
        } else {
            delivery.claimAvailableBytes();
        }
    }

    @Override
    protected void replenishCreditIfNeeded() {
        int potentialPrefetch;
        int currentCredit;
        int creditWindow = this.options.creditWindow();
        if (creditWindow > 0 && (double)(currentCredit = this.protonReceiver.getCredit()) <= (double)creditWindow * 0.5 && (double)(potentialPrefetch = currentCredit + this.deliveryQueue.size()) <= (double)creditWindow * 0.7) {
            int additionalCredit = creditWindow - potentialPrefetch;
            LOG.trace("Receiver {} granting additional credit: {}", (Object)this.linkId, (Object)additionalCredit);
            try {
                this.protonReceiver.addCredit(additionalCredit);
            }
            catch (Exception ex) {
                LOG.debug("Error caught during credit top-up", (Throwable)ex);
            }
        }
    }

    @Override
    protected void linkSpecificLocalCloseHandler() {
        this.deliveryQueue.stop();
        this.deliveryQueue.clear();
    }

    @Override
    protected void recreateLinkForReconnect() {
        int previousCredit = this.protonReceiver.getCredit() + this.deliveryQueue.size();
        this.deliveryQueue.clear();
        if (this.drainingFuture != null) {
            this.drainingFuture.complete(this);
            if (this.drainingTimeout != null) {
                this.drainingTimeout.cancel(false);
                this.drainingTimeout = null;
            }
        }
        this.protonReceiver.localCloseHandler(null);
        this.protonReceiver.localDetachHandler(null);
        this.protonReceiver.close();
        this.protonReceiver = ClientReceiverBuilder.recreateReceiver(this.session, this.protonReceiver, this.options);
        this.protonReceiver.setLinkedResource((Object)this);
        this.protonReceiver.addCredit(previousCredit);
    }
}

