/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import org.apache.qpid.client.AMQAnyDestination;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.AMQTopic;
import org.apache.qpid.client.message.AMQMessageDelegate;
import org.apache.qpid.client.message.ExchangeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAMQMessageDelegate
implements AMQMessageDelegate {
    private static final Logger _logger = LoggerFactory.getLogger(AMQMessageDelegate.class);
    private static Map<String, Integer> _exchangeTypeToDestinationType = new ConcurrentHashMap<String, Integer>();
    private static Map<String, ExchangeInfo> _exchangeMap = new ConcurrentHashMap<String, ExchangeInfo>();
    private AMQSession<?, ?> _session;
    private final long _deliveryTag;

    protected AbstractAMQMessageDelegate(long deliveryTag) {
        this._deliveryTag = deliveryTag;
    }

    @Override
    public long getDeliveryTag() {
        return this._deliveryTag;
    }

    protected AMQDestination generateDestination(String exchange, String routingKey) {
        ExchangeInfo exchangeInfo;
        if (exchange == null) {
            exchange = "";
        }
        if (routingKey == null) {
            routingKey = "";
        }
        if ((exchangeInfo = _exchangeMap.get(exchange)) == null) {
            exchangeInfo = new ExchangeInfo(exchange, "", 3);
        }
        AMQDestination dest = "topic".equals(exchangeInfo.getExchangeType()) ? new AMQTopic(exchange, routingKey, null) : ("direct".equals(exchangeInfo.getExchangeType()) ? new AMQQueue(exchange, routingKey, routingKey) : new AMQAnyDestination(exchange, exchangeInfo.getExchangeType(), routingKey, false, false, routingKey, false, new String[]{routingKey}));
        return dest;
    }

    protected static void updateExchangeType(String exchange, String newtype) {
        Integer type = _exchangeTypeToDestinationType.get(newtype);
        if (type == null) {
            type = 3;
        }
        _exchangeMap.put(exchange, new ExchangeInfo(exchange, newtype, type));
    }

    protected static boolean exchangeMapContains(String exchange) {
        return _exchangeMap.containsKey(exchange);
    }

    @Override
    public void acknowledgeThis() throws JMSException {
        if (this._session != null && this._session.getAcknowledgeMode() == 2) {
            if (this._session.getAMQConnection().isClosed()) {
                throw new IllegalStateException("Connection is already closed");
            }
            this._session.acknowledgeMessage(this.getDeliveryTag(), true);
        }
    }

    @Override
    public void acknowledge() throws JMSException {
        if (this._session != null && this._session.getAcknowledgeMode() == 2) {
            this._session.acknowledge();
        }
    }

    @Override
    public void setAMQSession(AMQSession<?, ?> s) {
        this._session = s;
    }

    @Override
    public AMQSession<?, ?> getAMQSession() {
        return this._session;
    }

    protected Destination convertToAddressBasedDestination(String exchange, String routingKey, String subject, boolean useNodeTypeForDestinationType, int type) {
        String addr;
        boolean isQueue = true;
        if ("".equals(exchange)) {
            subject = subject == null ? "" : "/" + subject;
            addr = routingKey + subject;
        } else {
            addr = exchange + "/" + routingKey;
            isQueue = false;
        }
        if (useNodeTypeForDestinationType) {
            if (type == 3 && "".equals(exchange)) {
                type = 1;
            }
            switch (type) {
                case 1: {
                    addr = addr + " ; { node: { type: queue } } ";
                    break;
                }
                case 2: {
                    addr = addr + " ; { node: { type: topic } } ";
                    break;
                }
            }
        }
        try {
            AMQDestination dest = (AMQDestination)AMQDestination.createDestination("ADDR:" + addr, useNodeTypeForDestinationType);
            if (isQueue) {
                dest.setQueueName(routingKey);
                dest.setRoutingKey(routingKey);
                dest.setExchangeName("");
            } else {
                dest.setRoutingKey(routingKey);
                dest.setExchangeName(exchange);
            }
            return dest;
        }
        catch (Exception e) {
            _logger.error("Exception when constructing an address string from the ReplyTo struct");
            return this.generateDestination(exchange, routingKey);
        }
    }

    abstract Object getProperty(String var1);

    abstract boolean hasProperty(String var1);

    static {
        _exchangeTypeToDestinationType.put("", 1);
        _exchangeTypeToDestinationType.put("direct", 1);
        _exchangeTypeToDestinationType.put("topic", 2);
        _exchangeTypeToDestinationType.put("fanout", 2);
        _exchangeTypeToDestinationType.put("headers", 1);
        _exchangeMap.put("", new ExchangeInfo("", "direct", 1));
        _exchangeMap.put("amq.direct", new ExchangeInfo("amq.direct", "direct", 1));
        _exchangeMap.put("amq.topic", new ExchangeInfo("amq.topic", "topic", 2));
        _exchangeMap.put("amq.fanout", new ExchangeInfo("amq.fanout", "fanout", 2));
        _exchangeMap.put("amq.match", new ExchangeInfo("amq.match", "headers", 1));
    }
}

