/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.QueueMessages;
import org.apache.qpid.server.model.OverflowPolicy;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.queue.OverflowPolicyHandler;
import org.apache.qpid.server.queue.OverflowPolicyMaximumQueueDepthChangeListener;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.txn.AsyncAutoCommitTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RingOverflowPolicyHandler
implements OverflowPolicyHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RingOverflowPolicyHandler.class);
    private final Handler _handler;

    RingOverflowPolicyHandler(Queue<?> queue, EventLogger eventLogger) {
        this._handler = new Handler(queue, eventLogger);
        queue.addChangeListener(this._handler);
    }

    @Override
    public void checkOverflow(QueueEntry newlyEnqueued) {
        this._handler.checkOverflow(newlyEnqueued);
    }

    private static class Handler
    extends OverflowPolicyMaximumQueueDepthChangeListener {
        private final Queue<?> _queue;
        private final EventLogger _eventLogger;
        private final ThreadLocal<Boolean> _recursionTracker = ThreadLocal.withInitial(() -> Boolean.FALSE);

        public Handler(Queue<?> queue, EventLogger eventLogger) {
            super(OverflowPolicy.RING);
            this._queue = queue;
            this._eventLogger = eventLogger;
        }

        @Override
        void onMaximumQueueDepthChange(Queue<?> queue) {
            this.checkOverflow(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkOverflow(QueueEntry newlyEnqueued) {
            if (!this._recursionTracker.get().booleanValue()) {
                this._recursionTracker.set(Boolean.TRUE);
                try {
                    long queueDepthBytes;
                    int queueDepthMessages;
                    boolean messagesOverflow;
                    boolean bytesOverflow;
                    long maximumQueueDepthMessages = this._queue.getMaximumQueueDepthMessages();
                    long maximumQueueDepthBytes = this._queue.getMaximumQueueDepthBytes();
                    boolean overflow = false;
                    int counter = 0;
                    QueueEntry lastSeenEntry = null;
                    do {
                        queueDepthMessages = this._queue.getQueueDepthMessages();
                        queueDepthBytes = this._queue.getQueueDepthBytes();
                        messagesOverflow = maximumQueueDepthMessages >= 0L && (long)queueDepthMessages > maximumQueueDepthMessages;
                        boolean bl = bytesOverflow = maximumQueueDepthBytes >= 0L && queueDepthBytes > maximumQueueDepthBytes;
                        if (!bytesOverflow && !messagesOverflow) continue;
                        if (!overflow) {
                            overflow = true;
                        }
                        QueueEntry queueEntry = lastSeenEntry = lastSeenEntry == null ? this._queue.getLeastSignificantOldestEntry() : lastSeenEntry.getNextValidEntry();
                        if (lastSeenEntry == null) continue;
                        if (newlyEnqueued != null && lastSeenEntry.compareTo(newlyEnqueued) >= 0) {
                            lastSeenEntry = null;
                            continue;
                        }
                        if (!lastSeenEntry.acquireOrSteal(null)) continue;
                        ++counter;
                        this.deleteAcquiredEntry(lastSeenEntry);
                    } while ((bytesOverflow || messagesOverflow) && lastSeenEntry != null);
                    if (overflow) {
                        this._eventLogger.message(this._queue.getLogSubject(), QueueMessages.DROPPED(counter, queueDepthBytes, queueDepthMessages, maximumQueueDepthBytes, maximumQueueDepthMessages));
                    }
                }
                finally {
                    this._recursionTracker.set(Boolean.FALSE);
                }
            }
        }

        private void deleteAcquiredEntry(final QueueEntry entry) {
            MessageStore messageStore = this._queue.getVirtualHost().getMessageStore();
            AsyncAutoCommitTransaction txn = new AsyncAutoCommitTransaction(messageStore, (future, action) -> action.postCommit());
            txn.dequeue(entry.getEnqueueRecord(), new ServerTransaction.Action(){

                @Override
                public void postCommit() {
                    entry.delete();
                }

                @Override
                public void onRollback() {
                }
            });
        }
    }
}

