/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#nullable disable
// <auto-generated>
//   This file was generated by a tool; you should avoid making direct changes.
//   Consider using 'partial classes' to extend these types
//   Input: PulsarApi.proto
//   Commit id: b0945d1 on Oct 20, 2022 from https://github.com/apache/pulsar/blob/master/pulsar-common/src/main/proto/PulsarApi.proto
// </auto-generated>

#region Designer generated code

#pragma warning disable CS0612, CS0618, CS1591, CS3021, IDE0079, IDE1006, RCS1036, RCS1057, RCS1085, RCS1192
namespace DotPulsar.Internal.PulsarApi;

[global::ProtoBuf.ProtoContract()]
public partial class Schema : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"name", IsRequired = true)]
    public string Name { get; set; }

    [global::ProtoBuf.ProtoMember(3, Name = @"schema_data", IsRequired = true)]
    public byte[] SchemaData { get; set; }

    [global::ProtoBuf.ProtoMember(4, IsRequired = true)]
    public SchemaType Type { get; set; }

    [global::ProtoBuf.ProtoMember(5, Name = @"properties")]
    public global::System.Collections.Generic.List<KeyValue> Properties { get; } = new global::System.Collections.Generic.List<KeyValue>();

    [global::ProtoBuf.ProtoContract()]
    public enum SchemaType
    {
        None = 0,
        String = 1,
        Json = 2,
        Protobuf = 3,
        Avro = 4,
        Bool = 5,
        Int8 = 6,
        Int16 = 7,
        Int32 = 8,
        Int64 = 9,
        Float = 10,
        Double = 11,
        Date = 12,
        Time = 13,
        Timestamp = 14,
        KeyValue = 15,
        Instant = 16,
        LocalDate = 17,
        LocalTime = 18,
        LocalDateTime = 19,
        ProtobufNative = 20,
    }
}

[global::ProtoBuf.ProtoContract()]
public partial class MessageIdData : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, IsRequired = true)]
    public ulong LedgerId { get; set; }

    [global::ProtoBuf.ProtoMember(2, IsRequired = true)]
    public ulong EntryId { get; set; }

    [global::ProtoBuf.ProtoMember(3, Name = @"partition")]
    [global::System.ComponentModel.DefaultValue(-1)]
    public int Partition
    {
        get => __pbn__Partition ?? -1;
        set => __pbn__Partition = value;
    }

    public bool ShouldSerializePartition() => __pbn__Partition != null;
    public void ResetPartition() => __pbn__Partition = null;
    private int? __pbn__Partition;

    [global::ProtoBuf.ProtoMember(4, Name = @"batch_index")]
    [global::System.ComponentModel.DefaultValue(-1)]
    public int BatchIndex
    {
        get => __pbn__BatchIndex ?? -1;
        set => __pbn__BatchIndex = value;
    }

    public bool ShouldSerializeBatchIndex() => __pbn__BatchIndex != null;
    public void ResetBatchIndex() => __pbn__BatchIndex = null;
    private int? __pbn__BatchIndex;

    [global::ProtoBuf.ProtoMember(5, Name = @"ack_set")]
    public long[] AckSets { get; set; }

    [global::ProtoBuf.ProtoMember(6, Name = @"batch_size")]
    public int BatchSize
    {
        get => __pbn__BatchSize.GetValueOrDefault();
        set => __pbn__BatchSize = value;
    }

    public bool ShouldSerializeBatchSize() => __pbn__BatchSize != null;
    public void ResetBatchSize() => __pbn__BatchSize = null;
    private int? __pbn__BatchSize;

    [global::ProtoBuf.ProtoMember(7, Name = @"first_chunk_message_id")]
    public MessageIdData FirstChunkMessageId { get; set; }
}

[global::ProtoBuf.ProtoContract()]
public partial class KeyValue : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"key", IsRequired = true)]
    public string Key { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"value", IsRequired = true)]
    public string Value { get; set; }
}

[global::ProtoBuf.ProtoContract()]
public partial class KeyLongValue : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"key", IsRequired = true)]
    public string Key { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"value", IsRequired = true)]
    public ulong Value { get; set; }
}

[global::ProtoBuf.ProtoContract()]
public partial class IntRange : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"start", IsRequired = true)]
    public int Start { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"end", IsRequired = true)]
    public int End { get; set; }
}

[global::ProtoBuf.ProtoContract()]
public partial class EncryptionKeys : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"key", IsRequired = true)]
    public string Key { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"value", IsRequired = true)]
    public byte[] Value { get; set; }

    [global::ProtoBuf.ProtoMember(3, Name = @"metadata")]
    public global::System.Collections.Generic.List<KeyValue> Metadatas { get; } = new global::System.Collections.Generic.List<KeyValue>();
}

[global::ProtoBuf.ProtoContract()]
public partial class MessageMetadata : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"producer_name", IsRequired = true)]
    public string ProducerName { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"sequence_id", IsRequired = true)]
    public ulong SequenceId { get; set; }

    [global::ProtoBuf.ProtoMember(3, Name = @"publish_time", IsRequired = true)]
    public ulong PublishTime { get; set; }

    [global::ProtoBuf.ProtoMember(4, Name = @"properties")]
    public global::System.Collections.Generic.List<KeyValue> Properties { get; } = new global::System.Collections.Generic.List<KeyValue>();

    [global::ProtoBuf.ProtoMember(5, Name = @"replicated_from")]
    [global::System.ComponentModel.DefaultValue("")]
    public string ReplicatedFrom
    {
        get => __pbn__ReplicatedFrom ?? "";
        set => __pbn__ReplicatedFrom = value;
    }

    public bool ShouldSerializeReplicatedFrom() => __pbn__ReplicatedFrom != null;
    public void ResetReplicatedFrom() => __pbn__ReplicatedFrom = null;
    private string __pbn__ReplicatedFrom;

    [global::ProtoBuf.ProtoMember(6, Name = @"partition_key")]
    [global::System.ComponentModel.DefaultValue("")]
    public string PartitionKey
    {
        get => __pbn__PartitionKey ?? "";
        set => __pbn__PartitionKey = value;
    }

    public bool ShouldSerializePartitionKey() => __pbn__PartitionKey != null;
    public void ResetPartitionKey() => __pbn__PartitionKey = null;
    private string __pbn__PartitionKey;

    [global::ProtoBuf.ProtoMember(7, Name = @"replicate_to")]
    public global::System.Collections.Generic.List<string> ReplicateToes { get; } = new global::System.Collections.Generic.List<string>();

    [global::ProtoBuf.ProtoMember(8, Name = @"compression")]
    [global::System.ComponentModel.DefaultValue(CompressionType.None)]
    public CompressionType Compression
    {
        get => __pbn__Compression ?? CompressionType.None;
        set => __pbn__Compression = value;
    }

    public bool ShouldSerializeCompression() => __pbn__Compression != null;
    public void ResetCompression() => __pbn__Compression = null;
    private CompressionType? __pbn__Compression;

    [global::ProtoBuf.ProtoMember(9, Name = @"uncompressed_size")]
    [global::System.ComponentModel.DefaultValue(0)]
    public uint UncompressedSize
    {
        get => __pbn__UncompressedSize ?? 0;
        set => __pbn__UncompressedSize = value;
    }

    public bool ShouldSerializeUncompressedSize() => __pbn__UncompressedSize != null;
    public void ResetUncompressedSize() => __pbn__UncompressedSize = null;
    private uint? __pbn__UncompressedSize;

    [global::ProtoBuf.ProtoMember(11, Name = @"num_messages_in_batch")]
    [global::System.ComponentModel.DefaultValue(1)]
    public int NumMessagesInBatch
    {
        get => __pbn__NumMessagesInBatch ?? 1;
        set => __pbn__NumMessagesInBatch = value;
    }

    public bool ShouldSerializeNumMessagesInBatch() => __pbn__NumMessagesInBatch != null;
    public void ResetNumMessagesInBatch() => __pbn__NumMessagesInBatch = null;
    private int? __pbn__NumMessagesInBatch;

    [global::ProtoBuf.ProtoMember(12, Name = @"event_time")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong EventTime
    {
        get => __pbn__EventTime ?? 0;
        set => __pbn__EventTime = value;
    }

    public bool ShouldSerializeEventTime() => __pbn__EventTime != null;
    public void ResetEventTime() => __pbn__EventTime = null;
    private ulong? __pbn__EventTime;

    [global::ProtoBuf.ProtoMember(13, Name = @"encryption_keys")]
    public global::System.Collections.Generic.List<EncryptionKeys> EncryptionKeys { get; } = new global::System.Collections.Generic.List<EncryptionKeys>();

    [global::ProtoBuf.ProtoMember(14, Name = @"encryption_algo")]
    [global::System.ComponentModel.DefaultValue("")]
    public string EncryptionAlgo
    {
        get => __pbn__EncryptionAlgo ?? "";
        set => __pbn__EncryptionAlgo = value;
    }

    public bool ShouldSerializeEncryptionAlgo() => __pbn__EncryptionAlgo != null;
    public void ResetEncryptionAlgo() => __pbn__EncryptionAlgo = null;
    private string __pbn__EncryptionAlgo;

    [global::ProtoBuf.ProtoMember(15, Name = @"encryption_param")]
    public byte[] EncryptionParam
    {
        get => __pbn__EncryptionParam;
        set => __pbn__EncryptionParam = value;
    }

    public bool ShouldSerializeEncryptionParam() => __pbn__EncryptionParam != null;
    public void ResetEncryptionParam() => __pbn__EncryptionParam = null;
    private byte[] __pbn__EncryptionParam;

    [global::ProtoBuf.ProtoMember(16, Name = @"schema_version")]
    public byte[] SchemaVersion
    {
        get => __pbn__SchemaVersion;
        set => __pbn__SchemaVersion = value;
    }

    public bool ShouldSerializeSchemaVersion() => __pbn__SchemaVersion != null;
    public void ResetSchemaVersion() => __pbn__SchemaVersion = null;
    private byte[] __pbn__SchemaVersion;

    [global::ProtoBuf.ProtoMember(17, Name = @"partition_key_b64_encoded")]
    [global::System.ComponentModel.DefaultValue(false)]
    public bool PartitionKeyB64Encoded
    {
        get => __pbn__PartitionKeyB64Encoded ?? false;
        set => __pbn__PartitionKeyB64Encoded = value;
    }

    public bool ShouldSerializePartitionKeyB64Encoded() => __pbn__PartitionKeyB64Encoded != null;
    public void ResetPartitionKeyB64Encoded() => __pbn__PartitionKeyB64Encoded = null;
    private bool? __pbn__PartitionKeyB64Encoded;

    [global::ProtoBuf.ProtoMember(18, Name = @"ordering_key")]
    public byte[] OrderingKey
    {
        get => __pbn__OrderingKey;
        set => __pbn__OrderingKey = value;
    }

    public bool ShouldSerializeOrderingKey() => __pbn__OrderingKey != null;
    public void ResetOrderingKey() => __pbn__OrderingKey = null;
    private byte[] __pbn__OrderingKey;

    [global::ProtoBuf.ProtoMember(19, Name = @"deliver_at_time")]
    public long DeliverAtTime
    {
        get => __pbn__DeliverAtTime.GetValueOrDefault();
        set => __pbn__DeliverAtTime = value;
    }

    public bool ShouldSerializeDeliverAtTime() => __pbn__DeliverAtTime != null;
    public void ResetDeliverAtTime() => __pbn__DeliverAtTime = null;
    private long? __pbn__DeliverAtTime;

    [global::ProtoBuf.ProtoMember(20, Name = @"marker_type")]
    public int MarkerType
    {
        get => __pbn__MarkerType.GetValueOrDefault();
        set => __pbn__MarkerType = value;
    }

    public bool ShouldSerializeMarkerType() => __pbn__MarkerType != null;
    public void ResetMarkerType() => __pbn__MarkerType = null;
    private int? __pbn__MarkerType;

    [global::ProtoBuf.ProtoMember(22, Name = @"txnid_least_bits")]
    public ulong TxnidLeastBits
    {
        get => __pbn__TxnidLeastBits.GetValueOrDefault();
        set => __pbn__TxnidLeastBits = value;
    }

    public bool ShouldSerializeTxnidLeastBits() => __pbn__TxnidLeastBits != null;
    public void ResetTxnidLeastBits() => __pbn__TxnidLeastBits = null;
    private ulong? __pbn__TxnidLeastBits;

    [global::ProtoBuf.ProtoMember(23, Name = @"txnid_most_bits")]
    public ulong TxnidMostBits
    {
        get => __pbn__TxnidMostBits.GetValueOrDefault();
        set => __pbn__TxnidMostBits = value;
    }

    public bool ShouldSerializeTxnidMostBits() => __pbn__TxnidMostBits != null;
    public void ResetTxnidMostBits() => __pbn__TxnidMostBits = null;
    private ulong? __pbn__TxnidMostBits;

    [global::ProtoBuf.ProtoMember(24, Name = @"highest_sequence_id")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong HighestSequenceId
    {
        get => __pbn__HighestSequenceId ?? 0;
        set => __pbn__HighestSequenceId = value;
    }

    public bool ShouldSerializeHighestSequenceId() => __pbn__HighestSequenceId != null;
    public void ResetHighestSequenceId() => __pbn__HighestSequenceId = null;
    private ulong? __pbn__HighestSequenceId;

    [global::ProtoBuf.ProtoMember(25, Name = @"null_value")]
    [global::System.ComponentModel.DefaultValue(false)]
    public bool NullValue
    {
        get => __pbn__NullValue ?? false;
        set => __pbn__NullValue = value;
    }

    public bool ShouldSerializeNullValue() => __pbn__NullValue != null;
    public void ResetNullValue() => __pbn__NullValue = null;
    private bool? __pbn__NullValue;

    [global::ProtoBuf.ProtoMember(26, Name = @"uuid")]
    [global::System.ComponentModel.DefaultValue("")]
    public string Uuid
    {
        get => __pbn__Uuid ?? "";
        set => __pbn__Uuid = value;
    }

    public bool ShouldSerializeUuid() => __pbn__Uuid != null;
    public void ResetUuid() => __pbn__Uuid = null;
    private string __pbn__Uuid;

    [global::ProtoBuf.ProtoMember(27, Name = @"num_chunks_from_msg")]
    public int NumChunksFromMsg
    {
        get => __pbn__NumChunksFromMsg.GetValueOrDefault();
        set => __pbn__NumChunksFromMsg = value;
    }

    public bool ShouldSerializeNumChunksFromMsg() => __pbn__NumChunksFromMsg != null;
    public void ResetNumChunksFromMsg() => __pbn__NumChunksFromMsg = null;
    private int? __pbn__NumChunksFromMsg;

    [global::ProtoBuf.ProtoMember(28, Name = @"total_chunk_msg_size")]
    public int TotalChunkMsgSize
    {
        get => __pbn__TotalChunkMsgSize.GetValueOrDefault();
        set => __pbn__TotalChunkMsgSize = value;
    }

    public bool ShouldSerializeTotalChunkMsgSize() => __pbn__TotalChunkMsgSize != null;
    public void ResetTotalChunkMsgSize() => __pbn__TotalChunkMsgSize = null;
    private int? __pbn__TotalChunkMsgSize;

    [global::ProtoBuf.ProtoMember(29, Name = @"chunk_id")]
    public int ChunkId
    {
        get => __pbn__ChunkId.GetValueOrDefault();
        set => __pbn__ChunkId = value;
    }

    public bool ShouldSerializeChunkId() => __pbn__ChunkId != null;
    public void ResetChunkId() => __pbn__ChunkId = null;
    private int? __pbn__ChunkId;

    [global::ProtoBuf.ProtoMember(30, Name = @"null_partition_key")]
    [global::System.ComponentModel.DefaultValue(false)]
    public bool NullPartitionKey
    {
        get => __pbn__NullPartitionKey ?? false;
        set => __pbn__NullPartitionKey = value;
    }

    public bool ShouldSerializeNullPartitionKey() => __pbn__NullPartitionKey != null;
    public void ResetNullPartitionKey() => __pbn__NullPartitionKey = null;
    private bool? __pbn__NullPartitionKey;
}

[global::ProtoBuf.ProtoContract()]
public partial class SingleMessageMetadata : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"properties")]
    public global::System.Collections.Generic.List<KeyValue> Properties { get; } = new global::System.Collections.Generic.List<KeyValue>();

    [global::ProtoBuf.ProtoMember(2, Name = @"partition_key")]
    [global::System.ComponentModel.DefaultValue("")]
    public string PartitionKey
    {
        get => __pbn__PartitionKey ?? "";
        set => __pbn__PartitionKey = value;
    }

    public bool ShouldSerializePartitionKey() => __pbn__PartitionKey != null;
    public void ResetPartitionKey() => __pbn__PartitionKey = null;
    private string __pbn__PartitionKey;

    [global::ProtoBuf.ProtoMember(3, Name = @"payload_size", IsRequired = true)]
    public int PayloadSize { get; set; }

    [global::ProtoBuf.ProtoMember(4, Name = @"compacted_out")]
    [global::System.ComponentModel.DefaultValue(false)]
    public bool CompactedOut
    {
        get => __pbn__CompactedOut ?? false;
        set => __pbn__CompactedOut = value;
    }

    public bool ShouldSerializeCompactedOut() => __pbn__CompactedOut != null;
    public void ResetCompactedOut() => __pbn__CompactedOut = null;
    private bool? __pbn__CompactedOut;

    [global::ProtoBuf.ProtoMember(5, Name = @"event_time")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong EventTime
    {
        get => __pbn__EventTime ?? 0;
        set => __pbn__EventTime = value;
    }

    public bool ShouldSerializeEventTime() => __pbn__EventTime != null;
    public void ResetEventTime() => __pbn__EventTime = null;
    private ulong? __pbn__EventTime;

    [global::ProtoBuf.ProtoMember(6, Name = @"partition_key_b64_encoded")]
    [global::System.ComponentModel.DefaultValue(false)]
    public bool PartitionKeyB64Encoded
    {
        get => __pbn__PartitionKeyB64Encoded ?? false;
        set => __pbn__PartitionKeyB64Encoded = value;
    }

    public bool ShouldSerializePartitionKeyB64Encoded() => __pbn__PartitionKeyB64Encoded != null;
    public void ResetPartitionKeyB64Encoded() => __pbn__PartitionKeyB64Encoded = null;
    private bool? __pbn__PartitionKeyB64Encoded;

    [global::ProtoBuf.ProtoMember(7, Name = @"ordering_key")]
    public byte[] OrderingKey
    {
        get => __pbn__OrderingKey;
        set => __pbn__OrderingKey = value;
    }

    public bool ShouldSerializeOrderingKey() => __pbn__OrderingKey != null;
    public void ResetOrderingKey() => __pbn__OrderingKey = null;
    private byte[] __pbn__OrderingKey;

    [global::ProtoBuf.ProtoMember(8, Name = @"sequence_id")]
    public ulong SequenceId
    {
        get => __pbn__SequenceId.GetValueOrDefault();
        set => __pbn__SequenceId = value;
    }

    public bool ShouldSerializeSequenceId() => __pbn__SequenceId != null;
    public void ResetSequenceId() => __pbn__SequenceId = null;
    private ulong? __pbn__SequenceId;

    [global::ProtoBuf.ProtoMember(9, Name = @"null_value")]
    [global::System.ComponentModel.DefaultValue(false)]
    public bool NullValue
    {
        get => __pbn__NullValue ?? false;
        set => __pbn__NullValue = value;
    }

    public bool ShouldSerializeNullValue() => __pbn__NullValue != null;
    public void ResetNullValue() => __pbn__NullValue = null;
    private bool? __pbn__NullValue;

    [global::ProtoBuf.ProtoMember(10, Name = @"null_partition_key")]
    [global::System.ComponentModel.DefaultValue(false)]
    public bool NullPartitionKey
    {
        get => __pbn__NullPartitionKey ?? false;
        set => __pbn__NullPartitionKey = value;
    }

    public bool ShouldSerializeNullPartitionKey() => __pbn__NullPartitionKey != null;
    public void ResetNullPartitionKey() => __pbn__NullPartitionKey = null;
    private bool? __pbn__NullPartitionKey;
}

[global::ProtoBuf.ProtoContract()]
public partial class BrokerEntryMetadata : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"broker_timestamp")]
    public ulong BrokerTimestamp
    {
        get => __pbn__BrokerTimestamp.GetValueOrDefault();
        set => __pbn__BrokerTimestamp = value;
    }

    public bool ShouldSerializeBrokerTimestamp() => __pbn__BrokerTimestamp != null;
    public void ResetBrokerTimestamp() => __pbn__BrokerTimestamp = null;
    private ulong? __pbn__BrokerTimestamp;

    [global::ProtoBuf.ProtoMember(2, Name = @"index")]
    public ulong Index
    {
        get => __pbn__Index.GetValueOrDefault();
        set => __pbn__Index = value;
    }

    public bool ShouldSerializeIndex() => __pbn__Index != null;
    public void ResetIndex() => __pbn__Index = null;
    private ulong? __pbn__Index;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandConnect : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"client_version", IsRequired = true)]
    public string ClientVersion { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"auth_method")]
    [global::System.ComponentModel.DefaultValue(AuthMethod.AuthMethodNone)]
    public AuthMethod AuthMethod
    {
        get => __pbn__AuthMethod ?? AuthMethod.AuthMethodNone;
        set => __pbn__AuthMethod = value;
    }

    public bool ShouldSerializeAuthMethod() => __pbn__AuthMethod != null;
    public void ResetAuthMethod() => __pbn__AuthMethod = null;
    private AuthMethod? __pbn__AuthMethod;

    [global::ProtoBuf.ProtoMember(5, Name = @"auth_method_name")]
    [global::System.ComponentModel.DefaultValue("")]
    public string AuthMethodName
    {
        get => __pbn__AuthMethodName ?? "";
        set => __pbn__AuthMethodName = value;
    }

    public bool ShouldSerializeAuthMethodName() => __pbn__AuthMethodName != null;
    public void ResetAuthMethodName() => __pbn__AuthMethodName = null;
    private string __pbn__AuthMethodName;

    [global::ProtoBuf.ProtoMember(3, Name = @"auth_data")]
    public byte[] AuthData
    {
        get => __pbn__AuthData;
        set => __pbn__AuthData = value;
    }

    public bool ShouldSerializeAuthData() => __pbn__AuthData != null;
    public void ResetAuthData() => __pbn__AuthData = null;
    private byte[] __pbn__AuthData;

    [global::ProtoBuf.ProtoMember(4, Name = @"protocol_version")]
    [global::System.ComponentModel.DefaultValue(0)]
    public int ProtocolVersion
    {
        get => __pbn__ProtocolVersion ?? 0;
        set => __pbn__ProtocolVersion = value;
    }

    public bool ShouldSerializeProtocolVersion() => __pbn__ProtocolVersion != null;
    public void ResetProtocolVersion() => __pbn__ProtocolVersion = null;
    private int? __pbn__ProtocolVersion;

    [global::ProtoBuf.ProtoMember(6, Name = @"proxy_to_broker_url")]
    [global::System.ComponentModel.DefaultValue("")]
    public string ProxyToBrokerUrl
    {
        get => __pbn__ProxyToBrokerUrl ?? "";
        set => __pbn__ProxyToBrokerUrl = value;
    }

    public bool ShouldSerializeProxyToBrokerUrl() => __pbn__ProxyToBrokerUrl != null;
    public void ResetProxyToBrokerUrl() => __pbn__ProxyToBrokerUrl = null;
    private string __pbn__ProxyToBrokerUrl;

    [global::ProtoBuf.ProtoMember(7, Name = @"original_principal")]
    [global::System.ComponentModel.DefaultValue("")]
    public string OriginalPrincipal
    {
        get => __pbn__OriginalPrincipal ?? "";
        set => __pbn__OriginalPrincipal = value;
    }

    public bool ShouldSerializeOriginalPrincipal() => __pbn__OriginalPrincipal != null;
    public void ResetOriginalPrincipal() => __pbn__OriginalPrincipal = null;
    private string __pbn__OriginalPrincipal;

    [global::ProtoBuf.ProtoMember(8, Name = @"original_auth_data")]
    [global::System.ComponentModel.DefaultValue("")]
    public string OriginalAuthData
    {
        get => __pbn__OriginalAuthData ?? "";
        set => __pbn__OriginalAuthData = value;
    }

    public bool ShouldSerializeOriginalAuthData() => __pbn__OriginalAuthData != null;
    public void ResetOriginalAuthData() => __pbn__OriginalAuthData = null;
    private string __pbn__OriginalAuthData;

    [global::ProtoBuf.ProtoMember(9, Name = @"original_auth_method")]
    [global::System.ComponentModel.DefaultValue("")]
    public string OriginalAuthMethod
    {
        get => __pbn__OriginalAuthMethod ?? "";
        set => __pbn__OriginalAuthMethod = value;
    }

    public bool ShouldSerializeOriginalAuthMethod() => __pbn__OriginalAuthMethod != null;
    public void ResetOriginalAuthMethod() => __pbn__OriginalAuthMethod = null;
    private string __pbn__OriginalAuthMethod;

    [global::ProtoBuf.ProtoMember(10, Name = @"feature_flags")]
    public FeatureFlags FeatureFlags { get; set; }
}

[global::ProtoBuf.ProtoContract()]
public partial class FeatureFlags : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"supports_auth_refresh")]
    [global::System.ComponentModel.DefaultValue(false)]
    public bool SupportsAuthRefresh
    {
        get => __pbn__SupportsAuthRefresh ?? false;
        set => __pbn__SupportsAuthRefresh = value;
    }

    public bool ShouldSerializeSupportsAuthRefresh() => __pbn__SupportsAuthRefresh != null;
    public void ResetSupportsAuthRefresh() => __pbn__SupportsAuthRefresh = null;
    private bool? __pbn__SupportsAuthRefresh;

    [global::ProtoBuf.ProtoMember(2, Name = @"supports_broker_entry_metadata")]
    [global::System.ComponentModel.DefaultValue(false)]
    public bool SupportsBrokerEntryMetadata
    {
        get => __pbn__SupportsBrokerEntryMetadata ?? false;
        set => __pbn__SupportsBrokerEntryMetadata = value;
    }

    public bool ShouldSerializeSupportsBrokerEntryMetadata() => __pbn__SupportsBrokerEntryMetadata != null;
    public void ResetSupportsBrokerEntryMetadata() => __pbn__SupportsBrokerEntryMetadata = null;
    private bool? __pbn__SupportsBrokerEntryMetadata;

    [global::ProtoBuf.ProtoMember(3, Name = @"supports_partial_producer")]
    [global::System.ComponentModel.DefaultValue(false)]
    public bool SupportsPartialProducer
    {
        get => __pbn__SupportsPartialProducer ?? false;
        set => __pbn__SupportsPartialProducer = value;
    }

    public bool ShouldSerializeSupportsPartialProducer() => __pbn__SupportsPartialProducer != null;
    public void ResetSupportsPartialProducer() => __pbn__SupportsPartialProducer = null;
    private bool? __pbn__SupportsPartialProducer;

    [global::ProtoBuf.ProtoMember(4, Name = @"supports_topic_watchers")]
    [global::System.ComponentModel.DefaultValue(false)]
    public bool SupportsTopicWatchers
    {
        get => __pbn__SupportsTopicWatchers ?? false;
        set => __pbn__SupportsTopicWatchers = value;
    }

    public bool ShouldSerializeSupportsTopicWatchers() => __pbn__SupportsTopicWatchers != null;
    public void ResetSupportsTopicWatchers() => __pbn__SupportsTopicWatchers = null;
    private bool? __pbn__SupportsTopicWatchers;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandConnected : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"server_version", IsRequired = true)]
    public string ServerVersion { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"protocol_version")]
    [global::System.ComponentModel.DefaultValue(0)]
    public int ProtocolVersion
    {
        get => __pbn__ProtocolVersion ?? 0;
        set => __pbn__ProtocolVersion = value;
    }

    public bool ShouldSerializeProtocolVersion() => __pbn__ProtocolVersion != null;
    public void ResetProtocolVersion() => __pbn__ProtocolVersion = null;
    private int? __pbn__ProtocolVersion;

    [global::ProtoBuf.ProtoMember(3, Name = @"max_message_size")]
    public int MaxMessageSize
    {
        get => __pbn__MaxMessageSize.GetValueOrDefault();
        set => __pbn__MaxMessageSize = value;
    }

    public bool ShouldSerializeMaxMessageSize() => __pbn__MaxMessageSize != null;
    public void ResetMaxMessageSize() => __pbn__MaxMessageSize = null;
    private int? __pbn__MaxMessageSize;

    [global::ProtoBuf.ProtoMember(4, Name = @"feature_flags")]
    public FeatureFlags FeatureFlags { get; set; }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandAuthResponse : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"client_version")]
    [global::System.ComponentModel.DefaultValue("")]
    public string ClientVersion
    {
        get => __pbn__ClientVersion ?? "";
        set => __pbn__ClientVersion = value;
    }

    public bool ShouldSerializeClientVersion() => __pbn__ClientVersion != null;
    public void ResetClientVersion() => __pbn__ClientVersion = null;
    private string __pbn__ClientVersion;

    [global::ProtoBuf.ProtoMember(2, Name = @"response")]
    public AuthData Response { get; set; }

    [global::ProtoBuf.ProtoMember(3, Name = @"protocol_version")]
    [global::System.ComponentModel.DefaultValue(0)]
    public int ProtocolVersion
    {
        get => __pbn__ProtocolVersion ?? 0;
        set => __pbn__ProtocolVersion = value;
    }

    public bool ShouldSerializeProtocolVersion() => __pbn__ProtocolVersion != null;
    public void ResetProtocolVersion() => __pbn__ProtocolVersion = null;
    private int? __pbn__ProtocolVersion;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandAuthChallenge : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"server_version")]
    [global::System.ComponentModel.DefaultValue("")]
    public string ServerVersion
    {
        get => __pbn__ServerVersion ?? "";
        set => __pbn__ServerVersion = value;
    }

    public bool ShouldSerializeServerVersion() => __pbn__ServerVersion != null;
    public void ResetServerVersion() => __pbn__ServerVersion = null;
    private string __pbn__ServerVersion;

    [global::ProtoBuf.ProtoMember(2, Name = @"challenge")]
    public AuthData Challenge { get; set; }

    [global::ProtoBuf.ProtoMember(3, Name = @"protocol_version")]
    [global::System.ComponentModel.DefaultValue(0)]
    public int ProtocolVersion
    {
        get => __pbn__ProtocolVersion ?? 0;
        set => __pbn__ProtocolVersion = value;
    }

    public bool ShouldSerializeProtocolVersion() => __pbn__ProtocolVersion != null;
    public void ResetProtocolVersion() => __pbn__ProtocolVersion = null;
    private int? __pbn__ProtocolVersion;
}

[global::ProtoBuf.ProtoContract()]
public partial class AuthData : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"auth_method_name")]
    [global::System.ComponentModel.DefaultValue("")]
    public string AuthMethodName
    {
        get => __pbn__AuthMethodName ?? "";
        set => __pbn__AuthMethodName = value;
    }

    public bool ShouldSerializeAuthMethodName() => __pbn__AuthMethodName != null;
    public void ResetAuthMethodName() => __pbn__AuthMethodName = null;
    private string __pbn__AuthMethodName;

    [global::ProtoBuf.ProtoMember(2)]
    public byte[] Data
    {
        get => __pbn__auth_data;
        set => __pbn__auth_data = value;
    }

    public bool ShouldSerializeauth_data() => __pbn__auth_data != null;
    public void Resetauth_data() => __pbn__auth_data = null;
    private byte[] __pbn__auth_data;
}

[global::ProtoBuf.ProtoContract()]
public partial class KeySharedMeta : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, IsRequired = true)]
    public KeySharedMode keySharedMode { get; set; }

    [global::ProtoBuf.ProtoMember(3)]
    public global::System.Collections.Generic.List<IntRange> hashRanges { get; } = new global::System.Collections.Generic.List<IntRange>();

    [global::ProtoBuf.ProtoMember(4)]
    [global::System.ComponentModel.DefaultValue(false)]
    public bool allowOutOfOrderDelivery
    {
        get => __pbn__allowOutOfOrderDelivery ?? false;
        set => __pbn__allowOutOfOrderDelivery = value;
    }

    public bool ShouldSerializeallowOutOfOrderDelivery() => __pbn__allowOutOfOrderDelivery != null;
    public void ResetallowOutOfOrderDelivery() => __pbn__allowOutOfOrderDelivery = null;
    private bool? __pbn__allowOutOfOrderDelivery;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandSubscribe : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"topic", IsRequired = true)]
    public string Topic { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"subscription", IsRequired = true)]
    public string Subscription { get; set; }

    [global::ProtoBuf.ProtoMember(3, IsRequired = true)]
    public SubType Type { get; set; }

    [global::ProtoBuf.ProtoMember(4, Name = @"consumer_id", IsRequired = true)]
    public ulong ConsumerId { get; set; }

    [global::ProtoBuf.ProtoMember(5, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(6, Name = @"consumer_name")]
    [global::System.ComponentModel.DefaultValue("")]
    public string ConsumerName
    {
        get => __pbn__ConsumerName ?? "";
        set => __pbn__ConsumerName = value;
    }

    public bool ShouldSerializeConsumerName() => __pbn__ConsumerName != null;
    public void ResetConsumerName() => __pbn__ConsumerName = null;
    private string __pbn__ConsumerName;

    [global::ProtoBuf.ProtoMember(7, Name = @"priority_level")]
    public int PriorityLevel
    {
        get => __pbn__PriorityLevel.GetValueOrDefault();
        set => __pbn__PriorityLevel = value;
    }

    public bool ShouldSerializePriorityLevel() => __pbn__PriorityLevel != null;
    public void ResetPriorityLevel() => __pbn__PriorityLevel = null;
    private int? __pbn__PriorityLevel;

    [global::ProtoBuf.ProtoMember(8, Name = @"durable")]
    [global::System.ComponentModel.DefaultValue(true)]
    public bool Durable
    {
        get => __pbn__Durable ?? true;
        set => __pbn__Durable = value;
    }

    public bool ShouldSerializeDurable() => __pbn__Durable != null;
    public void ResetDurable() => __pbn__Durable = null;
    private bool? __pbn__Durable;

    [global::ProtoBuf.ProtoMember(9, Name = @"start_message_id")]
    public MessageIdData StartMessageId { get; set; }

    [global::ProtoBuf.ProtoMember(10, Name = @"metadata")]
    public global::System.Collections.Generic.List<KeyValue> Metadatas { get; } = new global::System.Collections.Generic.List<KeyValue>();

    [global::ProtoBuf.ProtoMember(11, Name = @"read_compacted")]
    public bool ReadCompacted
    {
        get => __pbn__ReadCompacted.GetValueOrDefault();
        set => __pbn__ReadCompacted = value;
    }

    public bool ShouldSerializeReadCompacted() => __pbn__ReadCompacted != null;
    public void ResetReadCompacted() => __pbn__ReadCompacted = null;
    private bool? __pbn__ReadCompacted;

    [global::ProtoBuf.ProtoMember(12, Name = @"schema")]
    public Schema Schema { get; set; }

    [global::ProtoBuf.ProtoMember(13)]
    [global::System.ComponentModel.DefaultValue(InitialPositionType.Latest)]
    public InitialPositionType InitialPosition
    {
        get => __pbn__initialPosition ?? InitialPositionType.Latest;
        set => __pbn__initialPosition = value;
    }

    public bool ShouldSerializeinitialPosition() => __pbn__initialPosition != null;
    public void ResetinitialPosition() => __pbn__initialPosition = null;
    private InitialPositionType? __pbn__initialPosition;

    [global::ProtoBuf.ProtoMember(14, Name = @"replicate_subscription_state")]
    public bool ReplicateSubscriptionState
    {
        get => __pbn__ReplicateSubscriptionState.GetValueOrDefault();
        set => __pbn__ReplicateSubscriptionState = value;
    }

    public bool ShouldSerializeReplicateSubscriptionState() => __pbn__ReplicateSubscriptionState != null;
    public void ResetReplicateSubscriptionState() => __pbn__ReplicateSubscriptionState = null;
    private bool? __pbn__ReplicateSubscriptionState;

    [global::ProtoBuf.ProtoMember(15, Name = @"force_topic_creation")]
    [global::System.ComponentModel.DefaultValue(true)]
    public bool ForceTopicCreation
    {
        get => __pbn__ForceTopicCreation ?? true;
        set => __pbn__ForceTopicCreation = value;
    }

    public bool ShouldSerializeForceTopicCreation() => __pbn__ForceTopicCreation != null;
    public void ResetForceTopicCreation() => __pbn__ForceTopicCreation = null;
    private bool? __pbn__ForceTopicCreation;

    [global::ProtoBuf.ProtoMember(16, Name = @"start_message_rollback_duration_sec")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong StartMessageRollbackDurationSec
    {
        get => __pbn__StartMessageRollbackDurationSec ?? 0;
        set => __pbn__StartMessageRollbackDurationSec = value;
    }

    public bool ShouldSerializeStartMessageRollbackDurationSec() => __pbn__StartMessageRollbackDurationSec != null;
    public void ResetStartMessageRollbackDurationSec() => __pbn__StartMessageRollbackDurationSec = null;
    private ulong? __pbn__StartMessageRollbackDurationSec;

    [global::ProtoBuf.ProtoMember(17)]
    public KeySharedMeta keySharedMeta { get; set; }

    [global::ProtoBuf.ProtoMember(18, Name = @"subscription_properties")]
    public global::System.Collections.Generic.List<KeyValue> SubscriptionProperties { get; } = new global::System.Collections.Generic.List<KeyValue>();

    [global::ProtoBuf.ProtoMember(19, Name = @"consumer_epoch")]
    public ulong ConsumerEpoch
    {
        get => __pbn__ConsumerEpoch.GetValueOrDefault();
        set => __pbn__ConsumerEpoch = value;
    }

    public bool ShouldSerializeConsumerEpoch() => __pbn__ConsumerEpoch != null;
    public void ResetConsumerEpoch() => __pbn__ConsumerEpoch = null;
    private ulong? __pbn__ConsumerEpoch;

    [global::ProtoBuf.ProtoContract()]
    public enum SubType
    {
        Exclusive = 0,
        Shared = 1,
        Failover = 2,

        [global::ProtoBuf.ProtoEnum(Name = @"Key_Shared")]
        KeyShared = 3,
    }

    [global::ProtoBuf.ProtoContract()]
    public enum InitialPositionType
    {
        Latest = 0,
        Earliest = 1,
    }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandPartitionedTopicMetadata : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"topic", IsRequired = true)]
    public string Topic { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(3, Name = @"original_principal")]
    [global::System.ComponentModel.DefaultValue("")]
    public string OriginalPrincipal
    {
        get => __pbn__OriginalPrincipal ?? "";
        set => __pbn__OriginalPrincipal = value;
    }

    public bool ShouldSerializeOriginalPrincipal() => __pbn__OriginalPrincipal != null;
    public void ResetOriginalPrincipal() => __pbn__OriginalPrincipal = null;
    private string __pbn__OriginalPrincipal;

    [global::ProtoBuf.ProtoMember(4, Name = @"original_auth_data")]
    [global::System.ComponentModel.DefaultValue("")]
    public string OriginalAuthData
    {
        get => __pbn__OriginalAuthData ?? "";
        set => __pbn__OriginalAuthData = value;
    }

    public bool ShouldSerializeOriginalAuthData() => __pbn__OriginalAuthData != null;
    public void ResetOriginalAuthData() => __pbn__OriginalAuthData = null;
    private string __pbn__OriginalAuthData;

    [global::ProtoBuf.ProtoMember(5, Name = @"original_auth_method")]
    [global::System.ComponentModel.DefaultValue("")]
    public string OriginalAuthMethod
    {
        get => __pbn__OriginalAuthMethod ?? "";
        set => __pbn__OriginalAuthMethod = value;
    }

    public bool ShouldSerializeOriginalAuthMethod() => __pbn__OriginalAuthMethod != null;
    public void ResetOriginalAuthMethod() => __pbn__OriginalAuthMethod = null;
    private string __pbn__OriginalAuthMethod;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandPartitionedTopicMetadataResponse : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"partitions")]
    public uint Partitions
    {
        get => __pbn__Partitions.GetValueOrDefault();
        set => __pbn__Partitions = value;
    }

    public bool ShouldSerializePartitions() => __pbn__Partitions != null;
    public void ResetPartitions() => __pbn__Partitions = null;
    private uint? __pbn__Partitions;

    [global::ProtoBuf.ProtoMember(2, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(3, Name = @"response")]
    [global::System.ComponentModel.DefaultValue(LookupType.Success)]
    public LookupType Response
    {
        get => __pbn__Response ?? LookupType.Success;
        set => __pbn__Response = value;
    }

    public bool ShouldSerializeResponse() => __pbn__Response != null;
    public void ResetResponse() => __pbn__Response = null;
    private LookupType? __pbn__Response;

    [global::ProtoBuf.ProtoMember(4, Name = @"error")]
    [global::System.ComponentModel.DefaultValue(ServerError.UnknownError)]
    public ServerError Error
    {
        get => __pbn__Error ?? ServerError.UnknownError;
        set => __pbn__Error = value;
    }

    public bool ShouldSerializeError() => __pbn__Error != null;
    public void ResetError() => __pbn__Error = null;
    private ServerError? __pbn__Error;

    [global::ProtoBuf.ProtoMember(5, Name = @"message")]
    [global::System.ComponentModel.DefaultValue("")]
    public string Message
    {
        get => __pbn__Message ?? "";
        set => __pbn__Message = value;
    }

    public bool ShouldSerializeMessage() => __pbn__Message != null;
    public void ResetMessage() => __pbn__Message = null;
    private string __pbn__Message;

    [global::ProtoBuf.ProtoContract()]
    public enum LookupType
    {
        Success = 0,
        Failed = 1,
    }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandLookupTopic : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"topic", IsRequired = true)]
    public string Topic { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(3, Name = @"authoritative")]
    [global::System.ComponentModel.DefaultValue(false)]
    public bool Authoritative
    {
        get => __pbn__Authoritative ?? false;
        set => __pbn__Authoritative = value;
    }

    public bool ShouldSerializeAuthoritative() => __pbn__Authoritative != null;
    public void ResetAuthoritative() => __pbn__Authoritative = null;
    private bool? __pbn__Authoritative;

    [global::ProtoBuf.ProtoMember(4, Name = @"original_principal")]
    [global::System.ComponentModel.DefaultValue("")]
    public string OriginalPrincipal
    {
        get => __pbn__OriginalPrincipal ?? "";
        set => __pbn__OriginalPrincipal = value;
    }

    public bool ShouldSerializeOriginalPrincipal() => __pbn__OriginalPrincipal != null;
    public void ResetOriginalPrincipal() => __pbn__OriginalPrincipal = null;
    private string __pbn__OriginalPrincipal;

    [global::ProtoBuf.ProtoMember(5, Name = @"original_auth_data")]
    [global::System.ComponentModel.DefaultValue("")]
    public string OriginalAuthData
    {
        get => __pbn__OriginalAuthData ?? "";
        set => __pbn__OriginalAuthData = value;
    }

    public bool ShouldSerializeOriginalAuthData() => __pbn__OriginalAuthData != null;
    public void ResetOriginalAuthData() => __pbn__OriginalAuthData = null;
    private string __pbn__OriginalAuthData;

    [global::ProtoBuf.ProtoMember(6, Name = @"original_auth_method")]
    [global::System.ComponentModel.DefaultValue("")]
    public string OriginalAuthMethod
    {
        get => __pbn__OriginalAuthMethod ?? "";
        set => __pbn__OriginalAuthMethod = value;
    }

    public bool ShouldSerializeOriginalAuthMethod() => __pbn__OriginalAuthMethod != null;
    public void ResetOriginalAuthMethod() => __pbn__OriginalAuthMethod = null;
    private string __pbn__OriginalAuthMethod;

    [global::ProtoBuf.ProtoMember(7, Name = @"advertised_listener_name")]
    [global::System.ComponentModel.DefaultValue("")]
    public string AdvertisedListenerName
    {
        get => __pbn__AdvertisedListenerName ?? "";
        set => __pbn__AdvertisedListenerName = value;
    }

    public bool ShouldSerializeAdvertisedListenerName() => __pbn__AdvertisedListenerName != null;
    public void ResetAdvertisedListenerName() => __pbn__AdvertisedListenerName = null;
    private string __pbn__AdvertisedListenerName;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandLookupTopicResponse : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1)]
    [global::System.ComponentModel.DefaultValue("")]
    public string BrokerServiceUrl
    {
        get => __pbn__brokerServiceUrl ?? "";
        set => __pbn__brokerServiceUrl = value;
    }

    public bool ShouldSerializebrokerServiceUrl() => __pbn__brokerServiceUrl != null;
    public void ResetbrokerServiceUrl() => __pbn__brokerServiceUrl = null;
    private string __pbn__brokerServiceUrl;

    [global::ProtoBuf.ProtoMember(2)]
    [global::System.ComponentModel.DefaultValue("")]
    public string BrokerServiceUrlTls
    {
        get => __pbn__brokerServiceUrlTls ?? "";
        set => __pbn__brokerServiceUrlTls = value;
    }

    public bool ShouldSerializebrokerServiceUrlTls() => __pbn__brokerServiceUrlTls != null;
    public void ResetbrokerServiceUrlTls() => __pbn__brokerServiceUrlTls = null;
    private string __pbn__brokerServiceUrlTls;

    [global::ProtoBuf.ProtoMember(3, Name = @"response")]
    [global::System.ComponentModel.DefaultValue(LookupType.Redirect)]
    public LookupType Response
    {
        get => __pbn__Response ?? LookupType.Redirect;
        set => __pbn__Response = value;
    }

    public bool ShouldSerializeResponse() => __pbn__Response != null;
    public void ResetResponse() => __pbn__Response = null;
    private LookupType? __pbn__Response;

    [global::ProtoBuf.ProtoMember(4, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(5, Name = @"authoritative")]
    [global::System.ComponentModel.DefaultValue(false)]
    public bool Authoritative
    {
        get => __pbn__Authoritative ?? false;
        set => __pbn__Authoritative = value;
    }

    public bool ShouldSerializeAuthoritative() => __pbn__Authoritative != null;
    public void ResetAuthoritative() => __pbn__Authoritative = null;
    private bool? __pbn__Authoritative;

    [global::ProtoBuf.ProtoMember(6, Name = @"error")]
    [global::System.ComponentModel.DefaultValue(ServerError.UnknownError)]
    public ServerError Error
    {
        get => __pbn__Error ?? ServerError.UnknownError;
        set => __pbn__Error = value;
    }

    public bool ShouldSerializeError() => __pbn__Error != null;
    public void ResetError() => __pbn__Error = null;
    private ServerError? __pbn__Error;

    [global::ProtoBuf.ProtoMember(7, Name = @"message")]
    [global::System.ComponentModel.DefaultValue("")]
    public string Message
    {
        get => __pbn__Message ?? "";
        set => __pbn__Message = value;
    }

    public bool ShouldSerializeMessage() => __pbn__Message != null;
    public void ResetMessage() => __pbn__Message = null;
    private string __pbn__Message;

    [global::ProtoBuf.ProtoMember(8, Name = @"proxy_through_service_url")]
    [global::System.ComponentModel.DefaultValue(false)]
    public bool ProxyThroughServiceUrl
    {
        get => __pbn__ProxyThroughServiceUrl ?? false;
        set => __pbn__ProxyThroughServiceUrl = value;
    }

    public bool ShouldSerializeProxyThroughServiceUrl() => __pbn__ProxyThroughServiceUrl != null;
    public void ResetProxyThroughServiceUrl() => __pbn__ProxyThroughServiceUrl = null;
    private bool? __pbn__ProxyThroughServiceUrl;

    [global::ProtoBuf.ProtoContract()]
    public enum LookupType
    {
        Redirect = 0,
        Connect = 1,
        Failed = 2,
    }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandProducer : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"topic", IsRequired = true)]
    public string Topic { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"producer_id", IsRequired = true)]
    public ulong ProducerId { get; set; }

    [global::ProtoBuf.ProtoMember(3, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(4, Name = @"producer_name")]
    [global::System.ComponentModel.DefaultValue("")]
    public string ProducerName
    {
        get => __pbn__ProducerName ?? "";
        set => __pbn__ProducerName = value;
    }

    public bool ShouldSerializeProducerName() => __pbn__ProducerName != null;
    public void ResetProducerName() => __pbn__ProducerName = null;
    private string __pbn__ProducerName;

    [global::ProtoBuf.ProtoMember(5, Name = @"encrypted")]
    [global::System.ComponentModel.DefaultValue(false)]
    public bool Encrypted
    {
        get => __pbn__Encrypted ?? false;
        set => __pbn__Encrypted = value;
    }

    public bool ShouldSerializeEncrypted() => __pbn__Encrypted != null;
    public void ResetEncrypted() => __pbn__Encrypted = null;
    private bool? __pbn__Encrypted;

    [global::ProtoBuf.ProtoMember(6, Name = @"metadata")]
    public global::System.Collections.Generic.List<KeyValue> Metadatas { get; } = new global::System.Collections.Generic.List<KeyValue>();

    [global::ProtoBuf.ProtoMember(7, Name = @"schema")]
    public Schema Schema { get; set; }

    [global::ProtoBuf.ProtoMember(8, Name = @"epoch")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong Epoch
    {
        get => __pbn__Epoch ?? 0;
        set => __pbn__Epoch = value;
    }

    public bool ShouldSerializeEpoch() => __pbn__Epoch != null;
    public void ResetEpoch() => __pbn__Epoch = null;
    private ulong? __pbn__Epoch;

    [global::ProtoBuf.ProtoMember(9, Name = @"user_provided_producer_name")]
    [global::System.ComponentModel.DefaultValue(true)]
    public bool UserProvidedProducerName
    {
        get => __pbn__UserProvidedProducerName ?? true;
        set => __pbn__UserProvidedProducerName = value;
    }

    public bool ShouldSerializeUserProvidedProducerName() => __pbn__UserProvidedProducerName != null;
    public void ResetUserProvidedProducerName() => __pbn__UserProvidedProducerName = null;
    private bool? __pbn__UserProvidedProducerName;

    [global::ProtoBuf.ProtoMember(10, Name = @"producer_access_mode")]
    [global::System.ComponentModel.DefaultValue(ProducerAccessMode.Shared)]
    public ProducerAccessMode ProducerAccessMode
    {
        get => __pbn__ProducerAccessMode ?? ProducerAccessMode.Shared;
        set => __pbn__ProducerAccessMode = value;
    }

    public bool ShouldSerializeProducerAccessMode() => __pbn__ProducerAccessMode != null;
    public void ResetProducerAccessMode() => __pbn__ProducerAccessMode = null;
    private ProducerAccessMode? __pbn__ProducerAccessMode;

    [global::ProtoBuf.ProtoMember(11, Name = @"topic_epoch")]
    public ulong TopicEpoch
    {
        get => __pbn__TopicEpoch.GetValueOrDefault();
        set => __pbn__TopicEpoch = value;
    }

    public bool ShouldSerializeTopicEpoch() => __pbn__TopicEpoch != null;
    public void ResetTopicEpoch() => __pbn__TopicEpoch = null;
    private ulong? __pbn__TopicEpoch;

    [global::ProtoBuf.ProtoMember(12, Name = @"txn_enabled")]
    [global::System.ComponentModel.DefaultValue(false)]
    public bool TxnEnabled
    {
        get => __pbn__TxnEnabled ?? false;
        set => __pbn__TxnEnabled = value;
    }

    public bool ShouldSerializeTxnEnabled() => __pbn__TxnEnabled != null;
    public void ResetTxnEnabled() => __pbn__TxnEnabled = null;
    private bool? __pbn__TxnEnabled;

    [global::ProtoBuf.ProtoMember(13, Name = @"initial_subscription_name")]
    [global::System.ComponentModel.DefaultValue("")]
    public string InitialSubscriptionName
    {
        get => __pbn__InitialSubscriptionName ?? "";
        set => __pbn__InitialSubscriptionName = value;
    }

    public bool ShouldSerializeInitialSubscriptionName() => __pbn__InitialSubscriptionName != null;
    public void ResetInitialSubscriptionName() => __pbn__InitialSubscriptionName = null;
    private string __pbn__InitialSubscriptionName;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandSend : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"producer_id", IsRequired = true)]
    public ulong ProducerId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"sequence_id", IsRequired = true)]
    public ulong SequenceId { get; set; }

    [global::ProtoBuf.ProtoMember(3, Name = @"num_messages")]
    [global::System.ComponentModel.DefaultValue(1)]
    public int NumMessages
    {
        get => __pbn__NumMessages ?? 1;
        set => __pbn__NumMessages = value;
    }

    public bool ShouldSerializeNumMessages() => __pbn__NumMessages != null;
    public void ResetNumMessages() => __pbn__NumMessages = null;
    private int? __pbn__NumMessages;

    [global::ProtoBuf.ProtoMember(4, Name = @"txnid_least_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidLeastBits
    {
        get => __pbn__TxnidLeastBits ?? 0;
        set => __pbn__TxnidLeastBits = value;
    }

    public bool ShouldSerializeTxnidLeastBits() => __pbn__TxnidLeastBits != null;
    public void ResetTxnidLeastBits() => __pbn__TxnidLeastBits = null;
    private ulong? __pbn__TxnidLeastBits;

    [global::ProtoBuf.ProtoMember(5, Name = @"txnid_most_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidMostBits
    {
        get => __pbn__TxnidMostBits ?? 0;
        set => __pbn__TxnidMostBits = value;
    }

    public bool ShouldSerializeTxnidMostBits() => __pbn__TxnidMostBits != null;
    public void ResetTxnidMostBits() => __pbn__TxnidMostBits = null;
    private ulong? __pbn__TxnidMostBits;

    [global::ProtoBuf.ProtoMember(6, Name = @"highest_sequence_id")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong HighestSequenceId
    {
        get => __pbn__HighestSequenceId ?? 0;
        set => __pbn__HighestSequenceId = value;
    }

    public bool ShouldSerializeHighestSequenceId() => __pbn__HighestSequenceId != null;
    public void ResetHighestSequenceId() => __pbn__HighestSequenceId = null;
    private ulong? __pbn__HighestSequenceId;

    [global::ProtoBuf.ProtoMember(7, Name = @"is_chunk")]
    [global::System.ComponentModel.DefaultValue(false)]
    public bool IsChunk
    {
        get => __pbn__IsChunk ?? false;
        set => __pbn__IsChunk = value;
    }

    public bool ShouldSerializeIsChunk() => __pbn__IsChunk != null;
    public void ResetIsChunk() => __pbn__IsChunk = null;
    private bool? __pbn__IsChunk;

    [global::ProtoBuf.ProtoMember(8, Name = @"marker")]
    [global::System.ComponentModel.DefaultValue(false)]
    public bool Marker
    {
        get => __pbn__Marker ?? false;
        set => __pbn__Marker = value;
    }

    public bool ShouldSerializeMarker() => __pbn__Marker != null;
    public void ResetMarker() => __pbn__Marker = null;
    private bool? __pbn__Marker;

    [global::ProtoBuf.ProtoMember(9, Name = @"message_id")]
    public MessageIdData MessageId { get; set; }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandSendReceipt : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"producer_id", IsRequired = true)]
    public ulong ProducerId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"sequence_id", IsRequired = true)]
    public ulong SequenceId { get; set; }

    [global::ProtoBuf.ProtoMember(3, Name = @"message_id")]
    public MessageIdData MessageId { get; set; }

    [global::ProtoBuf.ProtoMember(4, Name = @"highest_sequence_id")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong HighestSequenceId
    {
        get => __pbn__HighestSequenceId ?? 0;
        set => __pbn__HighestSequenceId = value;
    }

    public bool ShouldSerializeHighestSequenceId() => __pbn__HighestSequenceId != null;
    public void ResetHighestSequenceId() => __pbn__HighestSequenceId = null;
    private ulong? __pbn__HighestSequenceId;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandSendError : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"producer_id", IsRequired = true)]
    public ulong ProducerId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"sequence_id", IsRequired = true)]
    public ulong SequenceId { get; set; }

    [global::ProtoBuf.ProtoMember(3, Name = @"error", IsRequired = true)]
    public ServerError Error { get; set; }

    [global::ProtoBuf.ProtoMember(4, Name = @"message", IsRequired = true)]
    public string Message { get; set; }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandMessage : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"consumer_id", IsRequired = true)]
    public ulong ConsumerId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"message_id", IsRequired = true)]
    public MessageIdData MessageId { get; set; }

    [global::ProtoBuf.ProtoMember(3, Name = @"redelivery_count")]
    [global::System.ComponentModel.DefaultValue(0)]
    public uint RedeliveryCount
    {
        get => __pbn__RedeliveryCount ?? 0;
        set => __pbn__RedeliveryCount = value;
    }

    public bool ShouldSerializeRedeliveryCount() => __pbn__RedeliveryCount != null;
    public void ResetRedeliveryCount() => __pbn__RedeliveryCount = null;
    private uint? __pbn__RedeliveryCount;

    [global::ProtoBuf.ProtoMember(4, Name = @"ack_set")]
    public long[] AckSets { get; set; }

    [global::ProtoBuf.ProtoMember(5, Name = @"consumer_epoch")]
    public ulong ConsumerEpoch
    {
        get => __pbn__ConsumerEpoch.GetValueOrDefault();
        set => __pbn__ConsumerEpoch = value;
    }

    public bool ShouldSerializeConsumerEpoch() => __pbn__ConsumerEpoch != null;
    public void ResetConsumerEpoch() => __pbn__ConsumerEpoch = null;
    private ulong? __pbn__ConsumerEpoch;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandAck : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"consumer_id", IsRequired = true)]
    public ulong ConsumerId { get; set; }

    [global::ProtoBuf.ProtoMember(2, IsRequired = true)]
    public AckType Type { get; set; }

    [global::ProtoBuf.ProtoMember(3, Name = @"message_id")]
    public global::System.Collections.Generic.List<MessageIdData> MessageIds { get; } = new global::System.Collections.Generic.List<MessageIdData>();

    [global::ProtoBuf.ProtoMember(4)]
    [global::System.ComponentModel.DefaultValue(ValidationErrorType.UncompressedSizeCorruption)]
    public ValidationErrorType ValidationError
    {
        get => __pbn__validation_error ?? ValidationErrorType.UncompressedSizeCorruption;
        set => __pbn__validation_error = value;
    }

    public bool ShouldSerializevalidation_error() => __pbn__validation_error != null;
    public void Resetvalidation_error() => __pbn__validation_error = null;
    private ValidationErrorType? __pbn__validation_error;

    [global::ProtoBuf.ProtoMember(5, Name = @"properties")]
    public global::System.Collections.Generic.List<KeyLongValue> Properties { get; } = new global::System.Collections.Generic.List<KeyLongValue>();

    [global::ProtoBuf.ProtoMember(6, Name = @"txnid_least_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidLeastBits
    {
        get => __pbn__TxnidLeastBits ?? 0;
        set => __pbn__TxnidLeastBits = value;
    }

    public bool ShouldSerializeTxnidLeastBits() => __pbn__TxnidLeastBits != null;
    public void ResetTxnidLeastBits() => __pbn__TxnidLeastBits = null;
    private ulong? __pbn__TxnidLeastBits;

    [global::ProtoBuf.ProtoMember(7, Name = @"txnid_most_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidMostBits
    {
        get => __pbn__TxnidMostBits ?? 0;
        set => __pbn__TxnidMostBits = value;
    }

    public bool ShouldSerializeTxnidMostBits() => __pbn__TxnidMostBits != null;
    public void ResetTxnidMostBits() => __pbn__TxnidMostBits = null;
    private ulong? __pbn__TxnidMostBits;

    [global::ProtoBuf.ProtoMember(8, Name = @"request_id")]
    public ulong RequestId
    {
        get => __pbn__RequestId.GetValueOrDefault();
        set => __pbn__RequestId = value;
    }

    public bool ShouldSerializeRequestId() => __pbn__RequestId != null;
    public void ResetRequestId() => __pbn__RequestId = null;
    private ulong? __pbn__RequestId;

    [global::ProtoBuf.ProtoContract()]
    public enum AckType
    {
        Individual = 0,
        Cumulative = 1,
    }

    [global::ProtoBuf.ProtoContract()]
    public enum ValidationErrorType
    {
        UncompressedSizeCorruption = 0,
        DecompressionError = 1,
        ChecksumMismatch = 2,
        BatchDeSerializeError = 3,
        DecryptionError = 4,
    }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandAckResponse : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"consumer_id", IsRequired = true)]
    public ulong ConsumerId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"txnid_least_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidLeastBits
    {
        get => __pbn__TxnidLeastBits ?? 0;
        set => __pbn__TxnidLeastBits = value;
    }

    public bool ShouldSerializeTxnidLeastBits() => __pbn__TxnidLeastBits != null;
    public void ResetTxnidLeastBits() => __pbn__TxnidLeastBits = null;
    private ulong? __pbn__TxnidLeastBits;

    [global::ProtoBuf.ProtoMember(3, Name = @"txnid_most_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidMostBits
    {
        get => __pbn__TxnidMostBits ?? 0;
        set => __pbn__TxnidMostBits = value;
    }

    public bool ShouldSerializeTxnidMostBits() => __pbn__TxnidMostBits != null;
    public void ResetTxnidMostBits() => __pbn__TxnidMostBits = null;
    private ulong? __pbn__TxnidMostBits;

    [global::ProtoBuf.ProtoMember(4, Name = @"error")]
    [global::System.ComponentModel.DefaultValue(ServerError.UnknownError)]
    public ServerError Error
    {
        get => __pbn__Error ?? ServerError.UnknownError;
        set => __pbn__Error = value;
    }

    public bool ShouldSerializeError() => __pbn__Error != null;
    public void ResetError() => __pbn__Error = null;
    private ServerError? __pbn__Error;

    [global::ProtoBuf.ProtoMember(5, Name = @"message")]
    [global::System.ComponentModel.DefaultValue("")]
    public string Message
    {
        get => __pbn__Message ?? "";
        set => __pbn__Message = value;
    }

    public bool ShouldSerializeMessage() => __pbn__Message != null;
    public void ResetMessage() => __pbn__Message = null;
    private string __pbn__Message;

    [global::ProtoBuf.ProtoMember(6, Name = @"request_id")]
    public ulong RequestId
    {
        get => __pbn__RequestId.GetValueOrDefault();
        set => __pbn__RequestId = value;
    }

    public bool ShouldSerializeRequestId() => __pbn__RequestId != null;
    public void ResetRequestId() => __pbn__RequestId = null;
    private ulong? __pbn__RequestId;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandActiveConsumerChange : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"consumer_id", IsRequired = true)]
    public ulong ConsumerId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"is_active")]
    [global::System.ComponentModel.DefaultValue(false)]
    public bool IsActive
    {
        get => __pbn__IsActive ?? false;
        set => __pbn__IsActive = value;
    }

    public bool ShouldSerializeIsActive() => __pbn__IsActive != null;
    public void ResetIsActive() => __pbn__IsActive = null;
    private bool? __pbn__IsActive;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandFlow : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"consumer_id", IsRequired = true)]
    public ulong ConsumerId { get; set; }

    [global::ProtoBuf.ProtoMember(2, IsRequired = true)]
    public uint MessagePermits { get; set; }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandUnsubscribe : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"consumer_id", IsRequired = true)]
    public ulong ConsumerId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandSeek : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"consumer_id", IsRequired = true)]
    public ulong ConsumerId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(3, Name = @"message_id")]
    public MessageIdData MessageId { get; set; }

    [global::ProtoBuf.ProtoMember(4, Name = @"message_publish_time")]
    public ulong MessagePublishTime
    {
        get => __pbn__MessagePublishTime.GetValueOrDefault();
        set => __pbn__MessagePublishTime = value;
    }

    public bool ShouldSerializeMessagePublishTime() => __pbn__MessagePublishTime != null;
    public void ResetMessagePublishTime() => __pbn__MessagePublishTime = null;
    private ulong? __pbn__MessagePublishTime;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandReachedEndOfTopic : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"consumer_id", IsRequired = true)]
    public ulong ConsumerId { get; set; }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandTopicMigrated : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"resource_id", IsRequired = true)]
    public ulong ResourceId { get; set; }

    [global::ProtoBuf.ProtoMember(2, IsRequired = true)]
    public ResourceType resource_type { get; set; }

    [global::ProtoBuf.ProtoMember(3)]
    [global::System.ComponentModel.DefaultValue("")]
    public string brokerServiceUrl
    {
        get => __pbn__brokerServiceUrl ?? "";
        set => __pbn__brokerServiceUrl = value;
    }

    public bool ShouldSerializebrokerServiceUrl() => __pbn__brokerServiceUrl != null;
    public void ResetbrokerServiceUrl() => __pbn__brokerServiceUrl = null;
    private string __pbn__brokerServiceUrl;

    [global::ProtoBuf.ProtoMember(4)]
    [global::System.ComponentModel.DefaultValue("")]
    public string brokerServiceUrlTls
    {
        get => __pbn__brokerServiceUrlTls ?? "";
        set => __pbn__brokerServiceUrlTls = value;
    }

    public bool ShouldSerializebrokerServiceUrlTls() => __pbn__brokerServiceUrlTls != null;
    public void ResetbrokerServiceUrlTls() => __pbn__brokerServiceUrlTls = null;
    private string __pbn__brokerServiceUrlTls;

    [global::ProtoBuf.ProtoContract()]
    public enum ResourceType
    {
        Producer = 0,
        Consumer = 1,
    }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandCloseProducer : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"producer_id", IsRequired = true)]
    public ulong ProducerId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandCloseConsumer : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"consumer_id", IsRequired = true)]
    public ulong ConsumerId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandRedeliverUnacknowledgedMessages : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"consumer_id", IsRequired = true)]
    public ulong ConsumerId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"message_ids")]
    public global::System.Collections.Generic.List<MessageIdData> MessageIds { get; } = new global::System.Collections.Generic.List<MessageIdData>();

    [global::ProtoBuf.ProtoMember(3, Name = @"consumer_epoch")]
    public ulong ConsumerEpoch
    {
        get => __pbn__ConsumerEpoch.GetValueOrDefault();
        set => __pbn__ConsumerEpoch = value;
    }

    public bool ShouldSerializeConsumerEpoch() => __pbn__ConsumerEpoch != null;
    public void ResetConsumerEpoch() => __pbn__ConsumerEpoch = null;
    private ulong? __pbn__ConsumerEpoch;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandSuccess : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"schema")]
    public Schema Schema { get; set; }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandProducerSuccess : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"producer_name", IsRequired = true)]
    public string ProducerName { get; set; }

    [global::ProtoBuf.ProtoMember(3, Name = @"last_sequence_id")]
    [global::System.ComponentModel.DefaultValue(-1)]
    public long LastSequenceId
    {
        get => __pbn__LastSequenceId ?? -1;
        set => __pbn__LastSequenceId = value;
    }

    public bool ShouldSerializeLastSequenceId() => __pbn__LastSequenceId != null;
    public void ResetLastSequenceId() => __pbn__LastSequenceId = null;
    private long? __pbn__LastSequenceId;

    [global::ProtoBuf.ProtoMember(4, Name = @"schema_version")]
    public byte[] SchemaVersion
    {
        get => __pbn__SchemaVersion;
        set => __pbn__SchemaVersion = value;
    }

    public bool ShouldSerializeSchemaVersion() => __pbn__SchemaVersion != null;
    public void ResetSchemaVersion() => __pbn__SchemaVersion = null;
    private byte[] __pbn__SchemaVersion;

    [global::ProtoBuf.ProtoMember(5, Name = @"topic_epoch")]
    public ulong TopicEpoch
    {
        get => __pbn__TopicEpoch.GetValueOrDefault();
        set => __pbn__TopicEpoch = value;
    }

    public bool ShouldSerializeTopicEpoch() => __pbn__TopicEpoch != null;
    public void ResetTopicEpoch() => __pbn__TopicEpoch = null;
    private ulong? __pbn__TopicEpoch;

    [global::ProtoBuf.ProtoMember(6, Name = @"producer_ready")]
    [global::System.ComponentModel.DefaultValue(true)]
    public bool ProducerReady
    {
        get => __pbn__ProducerReady ?? true;
        set => __pbn__ProducerReady = value;
    }

    public bool ShouldSerializeProducerReady() => __pbn__ProducerReady != null;
    public void ResetProducerReady() => __pbn__ProducerReady = null;
    private bool? __pbn__ProducerReady;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandError : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"error", IsRequired = true)]
    public ServerError Error { get; set; }

    [global::ProtoBuf.ProtoMember(3, Name = @"message", IsRequired = true)]
    public string Message { get; set; }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandPing : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandPong : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandConsumerStats : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(4, Name = @"consumer_id", IsRequired = true)]
    public ulong ConsumerId { get; set; }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandConsumerStatsResponse : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"error_code")]
    [global::System.ComponentModel.DefaultValue(ServerError.UnknownError)]
    public ServerError ErrorCode
    {
        get => __pbn__ErrorCode ?? ServerError.UnknownError;
        set => __pbn__ErrorCode = value;
    }

    public bool ShouldSerializeErrorCode() => __pbn__ErrorCode != null;
    public void ResetErrorCode() => __pbn__ErrorCode = null;
    private ServerError? __pbn__ErrorCode;

    [global::ProtoBuf.ProtoMember(3, Name = @"error_message")]
    [global::System.ComponentModel.DefaultValue("")]
    public string ErrorMessage
    {
        get => __pbn__ErrorMessage ?? "";
        set => __pbn__ErrorMessage = value;
    }

    public bool ShouldSerializeErrorMessage() => __pbn__ErrorMessage != null;
    public void ResetErrorMessage() => __pbn__ErrorMessage = null;
    private string __pbn__ErrorMessage;

    [global::ProtoBuf.ProtoMember(4)]
    public double msgRateOut
    {
        get => __pbn__msgRateOut.GetValueOrDefault();
        set => __pbn__msgRateOut = value;
    }

    public bool ShouldSerializemsgRateOut() => __pbn__msgRateOut != null;
    public void ResetmsgRateOut() => __pbn__msgRateOut = null;
    private double? __pbn__msgRateOut;

    [global::ProtoBuf.ProtoMember(5)]
    public double msgThroughputOut
    {
        get => __pbn__msgThroughputOut.GetValueOrDefault();
        set => __pbn__msgThroughputOut = value;
    }

    public bool ShouldSerializemsgThroughputOut() => __pbn__msgThroughputOut != null;
    public void ResetmsgThroughputOut() => __pbn__msgThroughputOut = null;
    private double? __pbn__msgThroughputOut;

    [global::ProtoBuf.ProtoMember(6)]
    public double msgRateRedeliver
    {
        get => __pbn__msgRateRedeliver.GetValueOrDefault();
        set => __pbn__msgRateRedeliver = value;
    }

    public bool ShouldSerializemsgRateRedeliver() => __pbn__msgRateRedeliver != null;
    public void ResetmsgRateRedeliver() => __pbn__msgRateRedeliver = null;
    private double? __pbn__msgRateRedeliver;

    [global::ProtoBuf.ProtoMember(7)]
    [global::System.ComponentModel.DefaultValue("")]
    public string consumerName
    {
        get => __pbn__consumerName ?? "";
        set => __pbn__consumerName = value;
    }

    public bool ShouldSerializeconsumerName() => __pbn__consumerName != null;
    public void ResetconsumerName() => __pbn__consumerName = null;
    private string __pbn__consumerName;

    [global::ProtoBuf.ProtoMember(8)]
    public ulong availablePermits
    {
        get => __pbn__availablePermits.GetValueOrDefault();
        set => __pbn__availablePermits = value;
    }

    public bool ShouldSerializeavailablePermits() => __pbn__availablePermits != null;
    public void ResetavailablePermits() => __pbn__availablePermits = null;
    private ulong? __pbn__availablePermits;

    [global::ProtoBuf.ProtoMember(9)]
    public ulong unackedMessages
    {
        get => __pbn__unackedMessages.GetValueOrDefault();
        set => __pbn__unackedMessages = value;
    }

    public bool ShouldSerializeunackedMessages() => __pbn__unackedMessages != null;
    public void ResetunackedMessages() => __pbn__unackedMessages = null;
    private ulong? __pbn__unackedMessages;

    [global::ProtoBuf.ProtoMember(10)]
    public bool blockedConsumerOnUnackedMsgs
    {
        get => __pbn__blockedConsumerOnUnackedMsgs.GetValueOrDefault();
        set => __pbn__blockedConsumerOnUnackedMsgs = value;
    }

    public bool ShouldSerializeblockedConsumerOnUnackedMsgs() => __pbn__blockedConsumerOnUnackedMsgs != null;
    public void ResetblockedConsumerOnUnackedMsgs() => __pbn__blockedConsumerOnUnackedMsgs = null;
    private bool? __pbn__blockedConsumerOnUnackedMsgs;

    [global::ProtoBuf.ProtoMember(11, Name = @"address")]
    [global::System.ComponentModel.DefaultValue("")]
    public string Address
    {
        get => __pbn__Address ?? "";
        set => __pbn__Address = value;
    }

    public bool ShouldSerializeAddress() => __pbn__Address != null;
    public void ResetAddress() => __pbn__Address = null;
    private string __pbn__Address;

    [global::ProtoBuf.ProtoMember(12)]
    [global::System.ComponentModel.DefaultValue("")]
    public string connectedSince
    {
        get => __pbn__connectedSince ?? "";
        set => __pbn__connectedSince = value;
    }

    public bool ShouldSerializeconnectedSince() => __pbn__connectedSince != null;
    public void ResetconnectedSince() => __pbn__connectedSince = null;
    private string __pbn__connectedSince;

    [global::ProtoBuf.ProtoMember(13, Name = @"type")]
    [global::System.ComponentModel.DefaultValue("")]
    public string Type
    {
        get => __pbn__Type ?? "";
        set => __pbn__Type = value;
    }

    public bool ShouldSerializeType() => __pbn__Type != null;
    public void ResetType() => __pbn__Type = null;
    private string __pbn__Type;

    [global::ProtoBuf.ProtoMember(14)]
    public double msgRateExpired
    {
        get => __pbn__msgRateExpired.GetValueOrDefault();
        set => __pbn__msgRateExpired = value;
    }

    public bool ShouldSerializemsgRateExpired() => __pbn__msgRateExpired != null;
    public void ResetmsgRateExpired() => __pbn__msgRateExpired = null;
    private double? __pbn__msgRateExpired;

    [global::ProtoBuf.ProtoMember(15)]
    public ulong msgBacklog
    {
        get => __pbn__msgBacklog.GetValueOrDefault();
        set => __pbn__msgBacklog = value;
    }

    public bool ShouldSerializemsgBacklog() => __pbn__msgBacklog != null;
    public void ResetmsgBacklog() => __pbn__msgBacklog = null;
    private ulong? __pbn__msgBacklog;

    [global::ProtoBuf.ProtoMember(16)]
    public double messageAckRate
    {
        get => __pbn__messageAckRate.GetValueOrDefault();
        set => __pbn__messageAckRate = value;
    }

    public bool ShouldSerializemessageAckRate() => __pbn__messageAckRate != null;
    public void ResetmessageAckRate() => __pbn__messageAckRate = null;
    private double? __pbn__messageAckRate;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandGetLastMessageId : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"consumer_id", IsRequired = true)]
    public ulong ConsumerId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandGetLastMessageIdResponse : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"last_message_id", IsRequired = true)]
    public MessageIdData LastMessageId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(3, Name = @"consumer_mark_delete_position")]
    public MessageIdData ConsumerMarkDeletePosition { get; set; }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandGetTopicsOfNamespace : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"namespace", IsRequired = true)]
    public string Namespace { get; set; }

    [global::ProtoBuf.ProtoMember(3)]
    [global::System.ComponentModel.DefaultValue(Mode.Persistent)]
    public Mode mode
    {
        get => __pbn__mode ?? Mode.Persistent;
        set => __pbn__mode = value;
    }

    public bool ShouldSerializemode() => __pbn__mode != null;
    public void Resetmode() => __pbn__mode = null;
    private Mode? __pbn__mode;

    [global::ProtoBuf.ProtoMember(4, Name = @"topics_pattern")]
    [global::System.ComponentModel.DefaultValue("")]
    public string TopicsPattern
    {
        get => __pbn__TopicsPattern ?? "";
        set => __pbn__TopicsPattern = value;
    }

    public bool ShouldSerializeTopicsPattern() => __pbn__TopicsPattern != null;
    public void ResetTopicsPattern() => __pbn__TopicsPattern = null;
    private string __pbn__TopicsPattern;

    [global::ProtoBuf.ProtoMember(5, Name = @"topics_hash")]
    [global::System.ComponentModel.DefaultValue("")]
    public string TopicsHash
    {
        get => __pbn__TopicsHash ?? "";
        set => __pbn__TopicsHash = value;
    }

    public bool ShouldSerializeTopicsHash() => __pbn__TopicsHash != null;
    public void ResetTopicsHash() => __pbn__TopicsHash = null;
    private string __pbn__TopicsHash;

    [global::ProtoBuf.ProtoContract()]
    public enum Mode
    {
        [global::ProtoBuf.ProtoEnum(Name = @"PERSISTENT")]
        Persistent = 0,

        [global::ProtoBuf.ProtoEnum(Name = @"NON_PERSISTENT")]
        NonPersistent = 1,

        [global::ProtoBuf.ProtoEnum(Name = @"ALL")]
        All = 2,
    }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandGetTopicsOfNamespaceResponse : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"topics")]
    public global::System.Collections.Generic.List<string> Topics { get; } = new global::System.Collections.Generic.List<string>();

    [global::ProtoBuf.ProtoMember(3, Name = @"filtered")]
    [global::System.ComponentModel.DefaultValue(false)]
    public bool Filtered
    {
        get => __pbn__Filtered ?? false;
        set => __pbn__Filtered = value;
    }

    public bool ShouldSerializeFiltered() => __pbn__Filtered != null;
    public void ResetFiltered() => __pbn__Filtered = null;
    private bool? __pbn__Filtered;

    [global::ProtoBuf.ProtoMember(4, Name = @"topics_hash")]
    [global::System.ComponentModel.DefaultValue("")]
    public string TopicsHash
    {
        get => __pbn__TopicsHash ?? "";
        set => __pbn__TopicsHash = value;
    }

    public bool ShouldSerializeTopicsHash() => __pbn__TopicsHash != null;
    public void ResetTopicsHash() => __pbn__TopicsHash = null;
    private string __pbn__TopicsHash;

    [global::ProtoBuf.ProtoMember(5, Name = @"changed")]
    [global::System.ComponentModel.DefaultValue(true)]
    public bool Changed
    {
        get => __pbn__Changed ?? true;
        set => __pbn__Changed = value;
    }

    public bool ShouldSerializeChanged() => __pbn__Changed != null;
    public void ResetChanged() => __pbn__Changed = null;
    private bool? __pbn__Changed;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandWatchTopicList : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"watcher_id", IsRequired = true)]
    public ulong WatcherId { get; set; }

    [global::ProtoBuf.ProtoMember(3, Name = @"namespace", IsRequired = true)]
    public string Namespace { get; set; }

    [global::ProtoBuf.ProtoMember(4, Name = @"topics_pattern", IsRequired = true)]
    public string TopicsPattern { get; set; }

    [global::ProtoBuf.ProtoMember(5, Name = @"topics_hash")]
    [global::System.ComponentModel.DefaultValue("")]
    public string TopicsHash
    {
        get => __pbn__TopicsHash ?? "";
        set => __pbn__TopicsHash = value;
    }

    public bool ShouldSerializeTopicsHash() => __pbn__TopicsHash != null;
    public void ResetTopicsHash() => __pbn__TopicsHash = null;
    private string __pbn__TopicsHash;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandWatchTopicListSuccess : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"watcher_id", IsRequired = true)]
    public ulong WatcherId { get; set; }

    [global::ProtoBuf.ProtoMember(3, Name = @"topic")]
    public global::System.Collections.Generic.List<string> Topics { get; } = new global::System.Collections.Generic.List<string>();

    [global::ProtoBuf.ProtoMember(4, Name = @"topics_hash", IsRequired = true)]
    public string TopicsHash { get; set; }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandWatchTopicUpdate : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"watcher_id", IsRequired = true)]
    public ulong WatcherId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"new_topics")]
    public global::System.Collections.Generic.List<string> NewTopics { get; } = new global::System.Collections.Generic.List<string>();

    [global::ProtoBuf.ProtoMember(3, Name = @"deleted_topics")]
    public global::System.Collections.Generic.List<string> DeletedTopics { get; } = new global::System.Collections.Generic.List<string>();

    [global::ProtoBuf.ProtoMember(4, Name = @"topics_hash", IsRequired = true)]
    public string TopicsHash { get; set; }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandWatchTopicListClose : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"watcher_id", IsRequired = true)]
    public ulong WatcherId { get; set; }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandGetSchema : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"topic", IsRequired = true)]
    public string Topic { get; set; }

    [global::ProtoBuf.ProtoMember(3, Name = @"schema_version")]
    public byte[] SchemaVersion
    {
        get => __pbn__SchemaVersion;
        set => __pbn__SchemaVersion = value;
    }

    public bool ShouldSerializeSchemaVersion() => __pbn__SchemaVersion != null;
    public void ResetSchemaVersion() => __pbn__SchemaVersion = null;
    private byte[] __pbn__SchemaVersion;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandGetSchemaResponse : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"error_code")]
    [global::System.ComponentModel.DefaultValue(ServerError.UnknownError)]
    public ServerError ErrorCode
    {
        get => __pbn__ErrorCode ?? ServerError.UnknownError;
        set => __pbn__ErrorCode = value;
    }

    public bool ShouldSerializeErrorCode() => __pbn__ErrorCode != null;
    public void ResetErrorCode() => __pbn__ErrorCode = null;
    private ServerError? __pbn__ErrorCode;

    [global::ProtoBuf.ProtoMember(3, Name = @"error_message")]
    [global::System.ComponentModel.DefaultValue("")]
    public string ErrorMessage
    {
        get => __pbn__ErrorMessage ?? "";
        set => __pbn__ErrorMessage = value;
    }

    public bool ShouldSerializeErrorMessage() => __pbn__ErrorMessage != null;
    public void ResetErrorMessage() => __pbn__ErrorMessage = null;
    private string __pbn__ErrorMessage;

    [global::ProtoBuf.ProtoMember(4, Name = @"schema")]
    public Schema Schema { get; set; }

    [global::ProtoBuf.ProtoMember(5, Name = @"schema_version")]
    public byte[] SchemaVersion
    {
        get => __pbn__SchemaVersion;
        set => __pbn__SchemaVersion = value;
    }

    public bool ShouldSerializeSchemaVersion() => __pbn__SchemaVersion != null;
    public void ResetSchemaVersion() => __pbn__SchemaVersion = null;
    private byte[] __pbn__SchemaVersion;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandGetOrCreateSchema : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"topic", IsRequired = true)]
    public string Topic { get; set; }

    [global::ProtoBuf.ProtoMember(3, Name = @"schema", IsRequired = true)]
    public Schema Schema { get; set; }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandGetOrCreateSchemaResponse : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"error_code")]
    [global::System.ComponentModel.DefaultValue(ServerError.UnknownError)]
    public ServerError ErrorCode
    {
        get => __pbn__ErrorCode ?? ServerError.UnknownError;
        set => __pbn__ErrorCode = value;
    }

    public bool ShouldSerializeErrorCode() => __pbn__ErrorCode != null;
    public void ResetErrorCode() => __pbn__ErrorCode = null;
    private ServerError? __pbn__ErrorCode;

    [global::ProtoBuf.ProtoMember(3, Name = @"error_message")]
    [global::System.ComponentModel.DefaultValue("")]
    public string ErrorMessage
    {
        get => __pbn__ErrorMessage ?? "";
        set => __pbn__ErrorMessage = value;
    }

    public bool ShouldSerializeErrorMessage() => __pbn__ErrorMessage != null;
    public void ResetErrorMessage() => __pbn__ErrorMessage = null;
    private string __pbn__ErrorMessage;

    [global::ProtoBuf.ProtoMember(4, Name = @"schema_version")]
    public byte[] SchemaVersion
    {
        get => __pbn__SchemaVersion;
        set => __pbn__SchemaVersion = value;
    }

    public bool ShouldSerializeSchemaVersion() => __pbn__SchemaVersion != null;
    public void ResetSchemaVersion() => __pbn__SchemaVersion = null;
    private byte[] __pbn__SchemaVersion;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandTcClientConnectRequest : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"tc_id", IsRequired = true)]
    public ulong TcId { get; set; }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandTcClientConnectResponse : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"error")]
    [global::System.ComponentModel.DefaultValue(ServerError.UnknownError)]
    public ServerError Error
    {
        get => __pbn__Error ?? ServerError.UnknownError;
        set => __pbn__Error = value;
    }

    public bool ShouldSerializeError() => __pbn__Error != null;
    public void ResetError() => __pbn__Error = null;
    private ServerError? __pbn__Error;

    [global::ProtoBuf.ProtoMember(3, Name = @"message")]
    [global::System.ComponentModel.DefaultValue("")]
    public string Message
    {
        get => __pbn__Message ?? "";
        set => __pbn__Message = value;
    }

    public bool ShouldSerializeMessage() => __pbn__Message != null;
    public void ResetMessage() => __pbn__Message = null;
    private string __pbn__Message;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandNewTxn : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"txn_ttl_seconds")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnTtlSeconds
    {
        get => __pbn__TxnTtlSeconds ?? 0;
        set => __pbn__TxnTtlSeconds = value;
    }

    public bool ShouldSerializeTxnTtlSeconds() => __pbn__TxnTtlSeconds != null;
    public void ResetTxnTtlSeconds() => __pbn__TxnTtlSeconds = null;
    private ulong? __pbn__TxnTtlSeconds;

    [global::ProtoBuf.ProtoMember(3, Name = @"tc_id")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TcId
    {
        get => __pbn__TcId ?? 0;
        set => __pbn__TcId = value;
    }

    public bool ShouldSerializeTcId() => __pbn__TcId != null;
    public void ResetTcId() => __pbn__TcId = null;
    private ulong? __pbn__TcId;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandNewTxnResponse : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"txnid_least_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidLeastBits
    {
        get => __pbn__TxnidLeastBits ?? 0;
        set => __pbn__TxnidLeastBits = value;
    }

    public bool ShouldSerializeTxnidLeastBits() => __pbn__TxnidLeastBits != null;
    public void ResetTxnidLeastBits() => __pbn__TxnidLeastBits = null;
    private ulong? __pbn__TxnidLeastBits;

    [global::ProtoBuf.ProtoMember(3, Name = @"txnid_most_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidMostBits
    {
        get => __pbn__TxnidMostBits ?? 0;
        set => __pbn__TxnidMostBits = value;
    }

    public bool ShouldSerializeTxnidMostBits() => __pbn__TxnidMostBits != null;
    public void ResetTxnidMostBits() => __pbn__TxnidMostBits = null;
    private ulong? __pbn__TxnidMostBits;

    [global::ProtoBuf.ProtoMember(4, Name = @"error")]
    [global::System.ComponentModel.DefaultValue(ServerError.UnknownError)]
    public ServerError Error
    {
        get => __pbn__Error ?? ServerError.UnknownError;
        set => __pbn__Error = value;
    }

    public bool ShouldSerializeError() => __pbn__Error != null;
    public void ResetError() => __pbn__Error = null;
    private ServerError? __pbn__Error;

    [global::ProtoBuf.ProtoMember(5, Name = @"message")]
    [global::System.ComponentModel.DefaultValue("")]
    public string Message
    {
        get => __pbn__Message ?? "";
        set => __pbn__Message = value;
    }

    public bool ShouldSerializeMessage() => __pbn__Message != null;
    public void ResetMessage() => __pbn__Message = null;
    private string __pbn__Message;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandAddPartitionToTxn : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"txnid_least_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidLeastBits
    {
        get => __pbn__TxnidLeastBits ?? 0;
        set => __pbn__TxnidLeastBits = value;
    }

    public bool ShouldSerializeTxnidLeastBits() => __pbn__TxnidLeastBits != null;
    public void ResetTxnidLeastBits() => __pbn__TxnidLeastBits = null;
    private ulong? __pbn__TxnidLeastBits;

    [global::ProtoBuf.ProtoMember(3, Name = @"txnid_most_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidMostBits
    {
        get => __pbn__TxnidMostBits ?? 0;
        set => __pbn__TxnidMostBits = value;
    }

    public bool ShouldSerializeTxnidMostBits() => __pbn__TxnidMostBits != null;
    public void ResetTxnidMostBits() => __pbn__TxnidMostBits = null;
    private ulong? __pbn__TxnidMostBits;

    [global::ProtoBuf.ProtoMember(4, Name = @"partitions")]
    public global::System.Collections.Generic.List<string> Partitions { get; } = new global::System.Collections.Generic.List<string>();
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandAddPartitionToTxnResponse : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"txnid_least_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidLeastBits
    {
        get => __pbn__TxnidLeastBits ?? 0;
        set => __pbn__TxnidLeastBits = value;
    }

    public bool ShouldSerializeTxnidLeastBits() => __pbn__TxnidLeastBits != null;
    public void ResetTxnidLeastBits() => __pbn__TxnidLeastBits = null;
    private ulong? __pbn__TxnidLeastBits;

    [global::ProtoBuf.ProtoMember(3, Name = @"txnid_most_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidMostBits
    {
        get => __pbn__TxnidMostBits ?? 0;
        set => __pbn__TxnidMostBits = value;
    }

    public bool ShouldSerializeTxnidMostBits() => __pbn__TxnidMostBits != null;
    public void ResetTxnidMostBits() => __pbn__TxnidMostBits = null;
    private ulong? __pbn__TxnidMostBits;

    [global::ProtoBuf.ProtoMember(4, Name = @"error")]
    [global::System.ComponentModel.DefaultValue(ServerError.UnknownError)]
    public ServerError Error
    {
        get => __pbn__Error ?? ServerError.UnknownError;
        set => __pbn__Error = value;
    }

    public bool ShouldSerializeError() => __pbn__Error != null;
    public void ResetError() => __pbn__Error = null;
    private ServerError? __pbn__Error;

    [global::ProtoBuf.ProtoMember(5, Name = @"message")]
    [global::System.ComponentModel.DefaultValue("")]
    public string Message
    {
        get => __pbn__Message ?? "";
        set => __pbn__Message = value;
    }

    public bool ShouldSerializeMessage() => __pbn__Message != null;
    public void ResetMessage() => __pbn__Message = null;
    private string __pbn__Message;
}

[global::ProtoBuf.ProtoContract()]
public partial class Subscription : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"topic", IsRequired = true)]
    public string Topic { get; set; }

    [global::ProtoBuf.ProtoMember(2, IsRequired = true)]
    public string subscription { get; set; }
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandAddSubscriptionToTxn : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"txnid_least_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidLeastBits
    {
        get => __pbn__TxnidLeastBits ?? 0;
        set => __pbn__TxnidLeastBits = value;
    }

    public bool ShouldSerializeTxnidLeastBits() => __pbn__TxnidLeastBits != null;
    public void ResetTxnidLeastBits() => __pbn__TxnidLeastBits = null;
    private ulong? __pbn__TxnidLeastBits;

    [global::ProtoBuf.ProtoMember(3, Name = @"txnid_most_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidMostBits
    {
        get => __pbn__TxnidMostBits ?? 0;
        set => __pbn__TxnidMostBits = value;
    }

    public bool ShouldSerializeTxnidMostBits() => __pbn__TxnidMostBits != null;
    public void ResetTxnidMostBits() => __pbn__TxnidMostBits = null;
    private ulong? __pbn__TxnidMostBits;

    [global::ProtoBuf.ProtoMember(4, Name = @"subscription")]
    public global::System.Collections.Generic.List<Subscription> Subscriptions { get; } = new global::System.Collections.Generic.List<Subscription>();
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandAddSubscriptionToTxnResponse : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"txnid_least_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidLeastBits
    {
        get => __pbn__TxnidLeastBits ?? 0;
        set => __pbn__TxnidLeastBits = value;
    }

    public bool ShouldSerializeTxnidLeastBits() => __pbn__TxnidLeastBits != null;
    public void ResetTxnidLeastBits() => __pbn__TxnidLeastBits = null;
    private ulong? __pbn__TxnidLeastBits;

    [global::ProtoBuf.ProtoMember(3, Name = @"txnid_most_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidMostBits
    {
        get => __pbn__TxnidMostBits ?? 0;
        set => __pbn__TxnidMostBits = value;
    }

    public bool ShouldSerializeTxnidMostBits() => __pbn__TxnidMostBits != null;
    public void ResetTxnidMostBits() => __pbn__TxnidMostBits = null;
    private ulong? __pbn__TxnidMostBits;

    [global::ProtoBuf.ProtoMember(4, Name = @"error")]
    [global::System.ComponentModel.DefaultValue(ServerError.UnknownError)]
    public ServerError Error
    {
        get => __pbn__Error ?? ServerError.UnknownError;
        set => __pbn__Error = value;
    }

    public bool ShouldSerializeError() => __pbn__Error != null;
    public void ResetError() => __pbn__Error = null;
    private ServerError? __pbn__Error;

    [global::ProtoBuf.ProtoMember(5, Name = @"message")]
    [global::System.ComponentModel.DefaultValue("")]
    public string Message
    {
        get => __pbn__Message ?? "";
        set => __pbn__Message = value;
    }

    public bool ShouldSerializeMessage() => __pbn__Message != null;
    public void ResetMessage() => __pbn__Message = null;
    private string __pbn__Message;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandEndTxn : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"txnid_least_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidLeastBits
    {
        get => __pbn__TxnidLeastBits ?? 0;
        set => __pbn__TxnidLeastBits = value;
    }

    public bool ShouldSerializeTxnidLeastBits() => __pbn__TxnidLeastBits != null;
    public void ResetTxnidLeastBits() => __pbn__TxnidLeastBits = null;
    private ulong? __pbn__TxnidLeastBits;

    [global::ProtoBuf.ProtoMember(3, Name = @"txnid_most_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidMostBits
    {
        get => __pbn__TxnidMostBits ?? 0;
        set => __pbn__TxnidMostBits = value;
    }

    public bool ShouldSerializeTxnidMostBits() => __pbn__TxnidMostBits != null;
    public void ResetTxnidMostBits() => __pbn__TxnidMostBits = null;
    private ulong? __pbn__TxnidMostBits;

    [global::ProtoBuf.ProtoMember(4, Name = @"txn_action")]
    [global::System.ComponentModel.DefaultValue(TxnAction.Commit)]
    public TxnAction TxnAction
    {
        get => __pbn__TxnAction ?? TxnAction.Commit;
        set => __pbn__TxnAction = value;
    }

    public bool ShouldSerializeTxnAction() => __pbn__TxnAction != null;
    public void ResetTxnAction() => __pbn__TxnAction = null;
    private TxnAction? __pbn__TxnAction;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandEndTxnResponse : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"txnid_least_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidLeastBits
    {
        get => __pbn__TxnidLeastBits ?? 0;
        set => __pbn__TxnidLeastBits = value;
    }

    public bool ShouldSerializeTxnidLeastBits() => __pbn__TxnidLeastBits != null;
    public void ResetTxnidLeastBits() => __pbn__TxnidLeastBits = null;
    private ulong? __pbn__TxnidLeastBits;

    [global::ProtoBuf.ProtoMember(3, Name = @"txnid_most_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidMostBits
    {
        get => __pbn__TxnidMostBits ?? 0;
        set => __pbn__TxnidMostBits = value;
    }

    public bool ShouldSerializeTxnidMostBits() => __pbn__TxnidMostBits != null;
    public void ResetTxnidMostBits() => __pbn__TxnidMostBits = null;
    private ulong? __pbn__TxnidMostBits;

    [global::ProtoBuf.ProtoMember(4, Name = @"error")]
    [global::System.ComponentModel.DefaultValue(ServerError.UnknownError)]
    public ServerError Error
    {
        get => __pbn__Error ?? ServerError.UnknownError;
        set => __pbn__Error = value;
    }

    public bool ShouldSerializeError() => __pbn__Error != null;
    public void ResetError() => __pbn__Error = null;
    private ServerError? __pbn__Error;

    [global::ProtoBuf.ProtoMember(5, Name = @"message")]
    [global::System.ComponentModel.DefaultValue("")]
    public string Message
    {
        get => __pbn__Message ?? "";
        set => __pbn__Message = value;
    }

    public bool ShouldSerializeMessage() => __pbn__Message != null;
    public void ResetMessage() => __pbn__Message = null;
    private string __pbn__Message;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandEndTxnOnPartition : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"txnid_least_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidLeastBits
    {
        get => __pbn__TxnidLeastBits ?? 0;
        set => __pbn__TxnidLeastBits = value;
    }

    public bool ShouldSerializeTxnidLeastBits() => __pbn__TxnidLeastBits != null;
    public void ResetTxnidLeastBits() => __pbn__TxnidLeastBits = null;
    private ulong? __pbn__TxnidLeastBits;

    [global::ProtoBuf.ProtoMember(3, Name = @"txnid_most_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidMostBits
    {
        get => __pbn__TxnidMostBits ?? 0;
        set => __pbn__TxnidMostBits = value;
    }

    public bool ShouldSerializeTxnidMostBits() => __pbn__TxnidMostBits != null;
    public void ResetTxnidMostBits() => __pbn__TxnidMostBits = null;
    private ulong? __pbn__TxnidMostBits;

    [global::ProtoBuf.ProtoMember(4, Name = @"topic")]
    [global::System.ComponentModel.DefaultValue("")]
    public string Topic
    {
        get => __pbn__Topic ?? "";
        set => __pbn__Topic = value;
    }

    public bool ShouldSerializeTopic() => __pbn__Topic != null;
    public void ResetTopic() => __pbn__Topic = null;
    private string __pbn__Topic;

    [global::ProtoBuf.ProtoMember(5, Name = @"txn_action")]
    [global::System.ComponentModel.DefaultValue(TxnAction.Commit)]
    public TxnAction TxnAction
    {
        get => __pbn__TxnAction ?? TxnAction.Commit;
        set => __pbn__TxnAction = value;
    }

    public bool ShouldSerializeTxnAction() => __pbn__TxnAction != null;
    public void ResetTxnAction() => __pbn__TxnAction = null;
    private TxnAction? __pbn__TxnAction;

    [global::ProtoBuf.ProtoMember(6, Name = @"txnid_least_bits_of_low_watermark")]
    public ulong TxnidLeastBitsOfLowWatermark
    {
        get => __pbn__TxnidLeastBitsOfLowWatermark.GetValueOrDefault();
        set => __pbn__TxnidLeastBitsOfLowWatermark = value;
    }

    public bool ShouldSerializeTxnidLeastBitsOfLowWatermark() => __pbn__TxnidLeastBitsOfLowWatermark != null;
    public void ResetTxnidLeastBitsOfLowWatermark() => __pbn__TxnidLeastBitsOfLowWatermark = null;
    private ulong? __pbn__TxnidLeastBitsOfLowWatermark;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandEndTxnOnPartitionResponse : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"txnid_least_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidLeastBits
    {
        get => __pbn__TxnidLeastBits ?? 0;
        set => __pbn__TxnidLeastBits = value;
    }

    public bool ShouldSerializeTxnidLeastBits() => __pbn__TxnidLeastBits != null;
    public void ResetTxnidLeastBits() => __pbn__TxnidLeastBits = null;
    private ulong? __pbn__TxnidLeastBits;

    [global::ProtoBuf.ProtoMember(3, Name = @"txnid_most_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidMostBits
    {
        get => __pbn__TxnidMostBits ?? 0;
        set => __pbn__TxnidMostBits = value;
    }

    public bool ShouldSerializeTxnidMostBits() => __pbn__TxnidMostBits != null;
    public void ResetTxnidMostBits() => __pbn__TxnidMostBits = null;
    private ulong? __pbn__TxnidMostBits;

    [global::ProtoBuf.ProtoMember(4, Name = @"error")]
    [global::System.ComponentModel.DefaultValue(ServerError.UnknownError)]
    public ServerError Error
    {
        get => __pbn__Error ?? ServerError.UnknownError;
        set => __pbn__Error = value;
    }

    public bool ShouldSerializeError() => __pbn__Error != null;
    public void ResetError() => __pbn__Error = null;
    private ServerError? __pbn__Error;

    [global::ProtoBuf.ProtoMember(5, Name = @"message")]
    [global::System.ComponentModel.DefaultValue("")]
    public string Message
    {
        get => __pbn__Message ?? "";
        set => __pbn__Message = value;
    }

    public bool ShouldSerializeMessage() => __pbn__Message != null;
    public void ResetMessage() => __pbn__Message = null;
    private string __pbn__Message;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandEndTxnOnSubscription : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"txnid_least_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidLeastBits
    {
        get => __pbn__TxnidLeastBits ?? 0;
        set => __pbn__TxnidLeastBits = value;
    }

    public bool ShouldSerializeTxnidLeastBits() => __pbn__TxnidLeastBits != null;
    public void ResetTxnidLeastBits() => __pbn__TxnidLeastBits = null;
    private ulong? __pbn__TxnidLeastBits;

    [global::ProtoBuf.ProtoMember(3, Name = @"txnid_most_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidMostBits
    {
        get => __pbn__TxnidMostBits ?? 0;
        set => __pbn__TxnidMostBits = value;
    }

    public bool ShouldSerializeTxnidMostBits() => __pbn__TxnidMostBits != null;
    public void ResetTxnidMostBits() => __pbn__TxnidMostBits = null;
    private ulong? __pbn__TxnidMostBits;

    [global::ProtoBuf.ProtoMember(4, Name = @"subscription")]
    public Subscription Subscription { get; set; }

    [global::ProtoBuf.ProtoMember(5, Name = @"txn_action")]
    [global::System.ComponentModel.DefaultValue(TxnAction.Commit)]
    public TxnAction TxnAction
    {
        get => __pbn__TxnAction ?? TxnAction.Commit;
        set => __pbn__TxnAction = value;
    }

    public bool ShouldSerializeTxnAction() => __pbn__TxnAction != null;
    public void ResetTxnAction() => __pbn__TxnAction = null;
    private TxnAction? __pbn__TxnAction;

    [global::ProtoBuf.ProtoMember(6, Name = @"txnid_least_bits_of_low_watermark")]
    public ulong TxnidLeastBitsOfLowWatermark
    {
        get => __pbn__TxnidLeastBitsOfLowWatermark.GetValueOrDefault();
        set => __pbn__TxnidLeastBitsOfLowWatermark = value;
    }

    public bool ShouldSerializeTxnidLeastBitsOfLowWatermark() => __pbn__TxnidLeastBitsOfLowWatermark != null;
    public void ResetTxnidLeastBitsOfLowWatermark() => __pbn__TxnidLeastBitsOfLowWatermark = null;
    private ulong? __pbn__TxnidLeastBitsOfLowWatermark;
}

[global::ProtoBuf.ProtoContract()]
public partial class CommandEndTxnOnSubscriptionResponse : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, Name = @"request_id", IsRequired = true)]
    public ulong RequestId { get; set; }

    [global::ProtoBuf.ProtoMember(2, Name = @"txnid_least_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidLeastBits
    {
        get => __pbn__TxnidLeastBits ?? 0;
        set => __pbn__TxnidLeastBits = value;
    }

    public bool ShouldSerializeTxnidLeastBits() => __pbn__TxnidLeastBits != null;
    public void ResetTxnidLeastBits() => __pbn__TxnidLeastBits = null;
    private ulong? __pbn__TxnidLeastBits;

    [global::ProtoBuf.ProtoMember(3, Name = @"txnid_most_bits")]
    [global::System.ComponentModel.DefaultValue(typeof(ulong), "0")]
    public ulong TxnidMostBits
    {
        get => __pbn__TxnidMostBits ?? 0;
        set => __pbn__TxnidMostBits = value;
    }

    public bool ShouldSerializeTxnidMostBits() => __pbn__TxnidMostBits != null;
    public void ResetTxnidMostBits() => __pbn__TxnidMostBits = null;
    private ulong? __pbn__TxnidMostBits;

    [global::ProtoBuf.ProtoMember(4, Name = @"error")]
    [global::System.ComponentModel.DefaultValue(ServerError.UnknownError)]
    public ServerError Error
    {
        get => __pbn__Error ?? ServerError.UnknownError;
        set => __pbn__Error = value;
    }

    public bool ShouldSerializeError() => __pbn__Error != null;
    public void ResetError() => __pbn__Error = null;
    private ServerError? __pbn__Error;

    [global::ProtoBuf.ProtoMember(5, Name = @"message")]
    [global::System.ComponentModel.DefaultValue("")]
    public string Message
    {
        get => __pbn__Message ?? "";
        set => __pbn__Message = value;
    }

    public bool ShouldSerializeMessage() => __pbn__Message != null;
    public void ResetMessage() => __pbn__Message = null;
    private string __pbn__Message;
}

[global::ProtoBuf.ProtoContract()]
public partial class BaseCommand : global::ProtoBuf.IExtensible
{
    private global::ProtoBuf.IExtension __pbn__extensionData;
    global::ProtoBuf.IExtension global::ProtoBuf.IExtensible.GetExtensionObject(bool createIfMissing)
        => global::ProtoBuf.Extensible.GetExtensionObject(ref __pbn__extensionData, createIfMissing);

    [global::ProtoBuf.ProtoMember(1, IsRequired = true)]
    public Type CommandType { get; set; } = Type.Connect;

    [global::ProtoBuf.ProtoMember(2, Name = @"connect")]
    public CommandConnect Connect { get; set; }

    [global::ProtoBuf.ProtoMember(3, Name = @"connected")]
    public CommandConnected Connected { get; set; }

    [global::ProtoBuf.ProtoMember(4, Name = @"subscribe")]
    public CommandSubscribe Subscribe { get; set; }

    [global::ProtoBuf.ProtoMember(5, Name = @"producer")]
    public CommandProducer Producer { get; set; }

    [global::ProtoBuf.ProtoMember(6, Name = @"send")]
    public CommandSend Send { get; set; }

    [global::ProtoBuf.ProtoMember(7, Name = @"send_receipt")]
    public CommandSendReceipt SendReceipt { get; set; }

    [global::ProtoBuf.ProtoMember(8, Name = @"send_error")]
    public CommandSendError SendError { get; set; }

    [global::ProtoBuf.ProtoMember(9, Name = @"message")]
    public CommandMessage Message { get; set; }

    [global::ProtoBuf.ProtoMember(10, Name = @"ack")]
    public CommandAck Ack { get; set; }

    [global::ProtoBuf.ProtoMember(11, Name = @"flow")]
    public CommandFlow Flow { get; set; }

    [global::ProtoBuf.ProtoMember(12, Name = @"unsubscribe")]
    public CommandUnsubscribe Unsubscribe { get; set; }

    [global::ProtoBuf.ProtoMember(13, Name = @"success")]
    public CommandSuccess Success { get; set; }

    [global::ProtoBuf.ProtoMember(14, Name = @"error")]
    public CommandError Error { get; set; }

    [global::ProtoBuf.ProtoMember(15, Name = @"close_producer")]
    public CommandCloseProducer CloseProducer { get; set; }

    [global::ProtoBuf.ProtoMember(16, Name = @"close_consumer")]
    public CommandCloseConsumer CloseConsumer { get; set; }

    [global::ProtoBuf.ProtoMember(17, Name = @"producer_success")]
    public CommandProducerSuccess ProducerSuccess { get; set; }

    [global::ProtoBuf.ProtoMember(18, Name = @"ping")]
    public CommandPing Ping { get; set; }

    [global::ProtoBuf.ProtoMember(19, Name = @"pong")]
    public CommandPong Pong { get; set; }

    [global::ProtoBuf.ProtoMember(20)]
    public CommandRedeliverUnacknowledgedMessages RedeliverUnacknowledgedMessages { get; set; }

    [global::ProtoBuf.ProtoMember(21)]
    public CommandPartitionedTopicMetadata PartitionMetadata { get; set; }

    [global::ProtoBuf.ProtoMember(22)]
    public CommandPartitionedTopicMetadataResponse PartitionMetadataResponse { get; set; }

    [global::ProtoBuf.ProtoMember(23)]
    public CommandLookupTopic LookupTopic { get; set; }

    [global::ProtoBuf.ProtoMember(24)]
    public CommandLookupTopicResponse LookupTopicResponse { get; set; }

    [global::ProtoBuf.ProtoMember(25)]
    public CommandConsumerStats consumerStats { get; set; }

    [global::ProtoBuf.ProtoMember(26)]
    public CommandConsumerStatsResponse consumerStatsResponse { get; set; }

    [global::ProtoBuf.ProtoMember(27)]
    public CommandReachedEndOfTopic ReachedEndOfTopic { get; set; }

    [global::ProtoBuf.ProtoMember(28, Name = @"seek")]
    public CommandSeek Seek { get; set; }

    [global::ProtoBuf.ProtoMember(29)]
    public CommandGetLastMessageId GetLastMessageId { get; set; }

    [global::ProtoBuf.ProtoMember(30)]
    public CommandGetLastMessageIdResponse GetLastMessageIdResponse { get; set; }

    [global::ProtoBuf.ProtoMember(31, Name = @"active_consumer_change")]
    public CommandActiveConsumerChange ActiveConsumerChange { get; set; }

    [global::ProtoBuf.ProtoMember(32)]
    public CommandGetTopicsOfNamespace getTopicsOfNamespace { get; set; }

    [global::ProtoBuf.ProtoMember(33)]
    public CommandGetTopicsOfNamespaceResponse getTopicsOfNamespaceResponse { get; set; }

    [global::ProtoBuf.ProtoMember(34)]
    public CommandGetSchema getSchema { get; set; }

    [global::ProtoBuf.ProtoMember(35)]
    public CommandGetSchemaResponse getSchemaResponse { get; set; }

    [global::ProtoBuf.ProtoMember(36)]
    public CommandAuthChallenge authChallenge { get; set; }

    [global::ProtoBuf.ProtoMember(37)]
    public CommandAuthResponse AuthResponse { get; set; }

    [global::ProtoBuf.ProtoMember(38)]
    public CommandAckResponse ackResponse { get; set; }

    [global::ProtoBuf.ProtoMember(39)]
    public CommandGetOrCreateSchema GetOrCreateSchema { get; set; }

    [global::ProtoBuf.ProtoMember(40)]
    public CommandGetOrCreateSchemaResponse GetOrCreateSchemaResponse { get; set; }

    [global::ProtoBuf.ProtoMember(50)]
    public CommandNewTxn newTxn { get; set; }

    [global::ProtoBuf.ProtoMember(51)]
    public CommandNewTxnResponse newTxnResponse { get; set; }

    [global::ProtoBuf.ProtoMember(52)]
    public CommandAddPartitionToTxn addPartitionToTxn { get; set; }

    [global::ProtoBuf.ProtoMember(53)]
    public CommandAddPartitionToTxnResponse addPartitionToTxnResponse { get; set; }

    [global::ProtoBuf.ProtoMember(54)]
    public CommandAddSubscriptionToTxn addSubscriptionToTxn { get; set; }

    [global::ProtoBuf.ProtoMember(55)]
    public CommandAddSubscriptionToTxnResponse addSubscriptionToTxnResponse { get; set; }

    [global::ProtoBuf.ProtoMember(56)]
    public CommandEndTxn endTxn { get; set; }

    [global::ProtoBuf.ProtoMember(57)]
    public CommandEndTxnResponse endTxnResponse { get; set; }

    [global::ProtoBuf.ProtoMember(58)]
    public CommandEndTxnOnPartition endTxnOnPartition { get; set; }

    [global::ProtoBuf.ProtoMember(59)]
    public CommandEndTxnOnPartitionResponse endTxnOnPartitionResponse { get; set; }

    [global::ProtoBuf.ProtoMember(60)]
    public CommandEndTxnOnSubscription endTxnOnSubscription { get; set; }

    [global::ProtoBuf.ProtoMember(61)]
    public CommandEndTxnOnSubscriptionResponse endTxnOnSubscriptionResponse { get; set; }

    [global::ProtoBuf.ProtoMember(62)]
    public CommandTcClientConnectRequest tcClientConnectRequest { get; set; }

    [global::ProtoBuf.ProtoMember(63)]
    public CommandTcClientConnectResponse tcClientConnectResponse { get; set; }

    [global::ProtoBuf.ProtoMember(64)]
    public CommandWatchTopicList watchTopicList { get; set; }

    [global::ProtoBuf.ProtoMember(65)]
    public CommandWatchTopicListSuccess watchTopicListSuccess { get; set; }

    [global::ProtoBuf.ProtoMember(66)]
    public CommandWatchTopicUpdate watchTopicUpdate { get; set; }

    [global::ProtoBuf.ProtoMember(67)]
    public CommandWatchTopicListClose watchTopicListClose { get; set; }

    [global::ProtoBuf.ProtoMember(68)]
    public CommandTopicMigrated topicMigrated { get; set; }

    [global::ProtoBuf.ProtoContract()]
    public enum Type
    {
        [global::ProtoBuf.ProtoEnum(Name = @"CONNECT")]
        Connect = 2,

        [global::ProtoBuf.ProtoEnum(Name = @"CONNECTED")]
        Connected = 3,

        [global::ProtoBuf.ProtoEnum(Name = @"SUBSCRIBE")]
        Subscribe = 4,

        [global::ProtoBuf.ProtoEnum(Name = @"PRODUCER")]
        Producer = 5,

        [global::ProtoBuf.ProtoEnum(Name = @"SEND")]
        Send = 6,

        [global::ProtoBuf.ProtoEnum(Name = @"SEND_RECEIPT")]
        SendReceipt = 7,

        [global::ProtoBuf.ProtoEnum(Name = @"SEND_ERROR")]
        SendError = 8,

        [global::ProtoBuf.ProtoEnum(Name = @"MESSAGE")]
        Message = 9,

        [global::ProtoBuf.ProtoEnum(Name = @"ACK")]
        Ack = 10,

        [global::ProtoBuf.ProtoEnum(Name = @"FLOW")]
        Flow = 11,

        [global::ProtoBuf.ProtoEnum(Name = @"UNSUBSCRIBE")]
        Unsubscribe = 12,

        [global::ProtoBuf.ProtoEnum(Name = @"SUCCESS")]
        Success = 13,

        [global::ProtoBuf.ProtoEnum(Name = @"ERROR")]
        Error = 14,

        [global::ProtoBuf.ProtoEnum(Name = @"CLOSE_PRODUCER")]
        CloseProducer = 15,

        [global::ProtoBuf.ProtoEnum(Name = @"CLOSE_CONSUMER")]
        CloseConsumer = 16,

        [global::ProtoBuf.ProtoEnum(Name = @"PRODUCER_SUCCESS")]
        ProducerSuccess = 17,

        [global::ProtoBuf.ProtoEnum(Name = @"PING")]
        Ping = 18,

        [global::ProtoBuf.ProtoEnum(Name = @"PONG")]
        Pong = 19,

        [global::ProtoBuf.ProtoEnum(Name = @"REDELIVER_UNACKNOWLEDGED_MESSAGES")]
        RedeliverUnacknowledgedMessages = 20,

        [global::ProtoBuf.ProtoEnum(Name = @"PARTITIONED_METADATA")]
        PartitionedMetadata = 21,

        [global::ProtoBuf.ProtoEnum(Name = @"PARTITIONED_METADATA_RESPONSE")]
        PartitionedMetadataResponse = 22,

        [global::ProtoBuf.ProtoEnum(Name = @"LOOKUP")]
        Lookup = 23,

        [global::ProtoBuf.ProtoEnum(Name = @"LOOKUP_RESPONSE")]
        LookupResponse = 24,

        [global::ProtoBuf.ProtoEnum(Name = @"CONSUMER_STATS")]
        ConsumerStats = 25,

        [global::ProtoBuf.ProtoEnum(Name = @"CONSUMER_STATS_RESPONSE")]
        ConsumerStatsResponse = 26,

        [global::ProtoBuf.ProtoEnum(Name = @"REACHED_END_OF_TOPIC")]
        ReachedEndOfTopic = 27,

        [global::ProtoBuf.ProtoEnum(Name = @"SEEK")]
        Seek = 28,

        [global::ProtoBuf.ProtoEnum(Name = @"GET_LAST_MESSAGE_ID")]
        GetLastMessageId = 29,

        [global::ProtoBuf.ProtoEnum(Name = @"GET_LAST_MESSAGE_ID_RESPONSE")]
        GetLastMessageIdResponse = 30,

        [global::ProtoBuf.ProtoEnum(Name = @"ACTIVE_CONSUMER_CHANGE")]
        ActiveConsumerChange = 31,

        [global::ProtoBuf.ProtoEnum(Name = @"GET_TOPICS_OF_NAMESPACE")]
        GetTopicsOfNamespace = 32,

        [global::ProtoBuf.ProtoEnum(Name = @"GET_TOPICS_OF_NAMESPACE_RESPONSE")]
        GetTopicsOfNamespaceResponse = 33,

        [global::ProtoBuf.ProtoEnum(Name = @"GET_SCHEMA")]
        GetSchema = 34,

        [global::ProtoBuf.ProtoEnum(Name = @"GET_SCHEMA_RESPONSE")]
        GetSchemaResponse = 35,

        [global::ProtoBuf.ProtoEnum(Name = @"AUTH_CHALLENGE")]
        AuthChallenge = 36,

        [global::ProtoBuf.ProtoEnum(Name = @"AUTH_RESPONSE")]
        AuthResponse = 37,

        [global::ProtoBuf.ProtoEnum(Name = @"ACK_RESPONSE")]
        AckResponse = 38,

        [global::ProtoBuf.ProtoEnum(Name = @"GET_OR_CREATE_SCHEMA")]
        GetOrCreateSchema = 39,

        [global::ProtoBuf.ProtoEnum(Name = @"GET_OR_CREATE_SCHEMA_RESPONSE")]
        GetOrCreateSchemaResponse = 40,

        [global::ProtoBuf.ProtoEnum(Name = @"NEW_TXN")]
        NewTxn = 50,

        [global::ProtoBuf.ProtoEnum(Name = @"NEW_TXN_RESPONSE")]
        NewTxnResponse = 51,

        [global::ProtoBuf.ProtoEnum(Name = @"ADD_PARTITION_TO_TXN")]
        AddPartitionToTxn = 52,

        [global::ProtoBuf.ProtoEnum(Name = @"ADD_PARTITION_TO_TXN_RESPONSE")]
        AddPartitionToTxnResponse = 53,

        [global::ProtoBuf.ProtoEnum(Name = @"ADD_SUBSCRIPTION_TO_TXN")]
        AddSubscriptionToTxn = 54,

        [global::ProtoBuf.ProtoEnum(Name = @"ADD_SUBSCRIPTION_TO_TXN_RESPONSE")]
        AddSubscriptionToTxnResponse = 55,

        [global::ProtoBuf.ProtoEnum(Name = @"END_TXN")]
        EndTxn = 56,

        [global::ProtoBuf.ProtoEnum(Name = @"END_TXN_RESPONSE")]
        EndTxnResponse = 57,

        [global::ProtoBuf.ProtoEnum(Name = @"END_TXN_ON_PARTITION")]
        EndTxnOnPartition = 58,

        [global::ProtoBuf.ProtoEnum(Name = @"END_TXN_ON_PARTITION_RESPONSE")]
        EndTxnOnPartitionResponse = 59,

        [global::ProtoBuf.ProtoEnum(Name = @"END_TXN_ON_SUBSCRIPTION")]
        EndTxnOnSubscription = 60,

        [global::ProtoBuf.ProtoEnum(Name = @"END_TXN_ON_SUBSCRIPTION_RESPONSE")]
        EndTxnOnSubscriptionResponse = 61,

        [global::ProtoBuf.ProtoEnum(Name = @"TC_CLIENT_CONNECT_REQUEST")]
        TcClientConnectRequest = 62,

        [global::ProtoBuf.ProtoEnum(Name = @"TC_CLIENT_CONNECT_RESPONSE")]
        TcClientConnectResponse = 63,

        [global::ProtoBuf.ProtoEnum(Name = @"WATCH_TOPIC_LIST")]
        WatchTopicList = 64,

        [global::ProtoBuf.ProtoEnum(Name = @"WATCH_TOPIC_LIST_SUCCESS")]
        WatchTopicListSuccess = 65,

        [global::ProtoBuf.ProtoEnum(Name = @"WATCH_TOPIC_UPDATE")]
        WatchTopicUpdate = 66,

        [global::ProtoBuf.ProtoEnum(Name = @"WATCH_TOPIC_LIST_CLOSE")]
        WatchTopicListClose = 67,

        [global::ProtoBuf.ProtoEnum(Name = @"TOPIC_MIGRATED")]
        TopicMigrated = 68,
    }
}

[global::ProtoBuf.ProtoContract()]
public enum CompressionType
{
    [global::ProtoBuf.ProtoEnum(Name = @"NONE")]
    None = 0,

    [global::ProtoBuf.ProtoEnum(Name = @"LZ4")]
    Lz4 = 1,

    [global::ProtoBuf.ProtoEnum(Name = @"ZLIB")]
    Zlib = 2,

    [global::ProtoBuf.ProtoEnum(Name = @"ZSTD")]
    Zstd = 3,

    [global::ProtoBuf.ProtoEnum(Name = @"SNAPPY")]
    Snappy = 4,
}

[global::ProtoBuf.ProtoContract()]
public enum ProducerAccessMode
{
    Shared = 0,
    Exclusive = 1,
    WaitForExclusive = 2,
    ExclusiveWithFencing = 3,
}

[global::ProtoBuf.ProtoContract()]
public enum ServerError
{
    UnknownError = 0,
    MetadataError = 1,
    PersistenceError = 2,
    AuthenticationError = 3,
    AuthorizationError = 4,
    ConsumerBusy = 5,
    ServiceNotReady = 6,
    ProducerBlockedQuotaExceededError = 7,
    ProducerBlockedQuotaExceededException = 8,
    ChecksumError = 9,
    UnsupportedVersionError = 10,
    TopicNotFound = 11,
    SubscriptionNotFound = 12,
    ConsumerNotFound = 13,
    TooManyRequests = 14,
    TopicTerminatedError = 15,
    ProducerBusy = 16,
    InvalidTopicName = 17,
    IncompatibleSchema = 18,
    ConsumerAssignError = 19,
    TransactionCoordinatorNotFound = 20,
    InvalidTxnStatus = 21,
    NotAllowedError = 22,
    TransactionConflict = 23,
    TransactionNotFound = 24,
    ProducerFenced = 25,
}

[global::ProtoBuf.ProtoContract()]
public enum AuthMethod
{
    AuthMethodNone = 0,
    AuthMethodYcaV1 = 1,
    AuthMethodAthens = 2,
}

[global::ProtoBuf.ProtoContract()]
public enum ProtocolVersion
{
    [global::ProtoBuf.ProtoEnum(Name = @"v0")]
    V0 = 0,

    [global::ProtoBuf.ProtoEnum(Name = @"v1")]
    V1 = 1,

    [global::ProtoBuf.ProtoEnum(Name = @"v2")]
    V2 = 2,

    [global::ProtoBuf.ProtoEnum(Name = @"v3")]
    V3 = 3,

    [global::ProtoBuf.ProtoEnum(Name = @"v4")]
    V4 = 4,

    [global::ProtoBuf.ProtoEnum(Name = @"v5")]
    V5 = 5,

    [global::ProtoBuf.ProtoEnum(Name = @"v6")]
    V6 = 6,

    [global::ProtoBuf.ProtoEnum(Name = @"v7")]
    V7 = 7,

    [global::ProtoBuf.ProtoEnum(Name = @"v8")]
    V8 = 8,

    [global::ProtoBuf.ProtoEnum(Name = @"v9")]
    V9 = 9,

    [global::ProtoBuf.ProtoEnum(Name = @"v10")]
    V10 = 10,

    [global::ProtoBuf.ProtoEnum(Name = @"v11")]
    V11 = 11,

    [global::ProtoBuf.ProtoEnum(Name = @"v12")]
    V12 = 12,

    [global::ProtoBuf.ProtoEnum(Name = @"v13")]
    V13 = 13,

    [global::ProtoBuf.ProtoEnum(Name = @"v14")]
    V14 = 14,

    [global::ProtoBuf.ProtoEnum(Name = @"v15")]
    V15 = 15,

    [global::ProtoBuf.ProtoEnum(Name = @"v16")]
    V16 = 16,

    [global::ProtoBuf.ProtoEnum(Name = @"v17")]
    V17 = 17,

    [global::ProtoBuf.ProtoEnum(Name = @"v18")]
    V18 = 18,

    [global::ProtoBuf.ProtoEnum(Name = @"v19")]
    V19 = 19,

    [global::ProtoBuf.ProtoEnum(Name = @"v20")]
    V20 = 20,
}

[global::ProtoBuf.ProtoContract()]
public enum KeySharedMode
{
    [global::ProtoBuf.ProtoEnum(Name = @"AUTO_SPLIT")]
    AutoSplit = 0,

    [global::ProtoBuf.ProtoEnum(Name = @"STICKY")]
    Sticky = 1,
}

[global::ProtoBuf.ProtoContract()]
public enum TxnAction
{
    [global::ProtoBuf.ProtoEnum(Name = @"COMMIT")]
    Commit = 0,

    [global::ProtoBuf.ProtoEnum(Name = @"ABORT")]
    Abort = 1,
}

#pragma warning restore CS0612, CS0618, CS1591, CS3021, IDE0079, IDE1006, RCS1036, RCS1057, RCS1085, RCS1192

#endregion

#nullable restore
