# PIP-161: Exclusive Producer: new mode ExclusiveWithFencing

In [PIP-68](pip-68.md) we introduced two access modes for the Producer:
- Exclusive: The producer is the only one who can publish to the topic. Fail if there is another Exclusive Producer connected to the topic while creating the new Producer.
- WaitForExclusive: Like Exclusive, but instead of Failing we are going to wait for the current Exclusive Producer to disconnect.

Those two modes are very powerful and allow you to perform some kind of `Locking` on a topic.

We are missing a third more, in which the Producer always succeeds to acquire the Exclusive lock on the topic by fencing out any other Producer that is connected, even the current Exclusive Producer and the other Producers waiting in  WaitForExclusive mode.



## Goal

The modes that are available with PIP-68 require a writer to acquire the lock and release it as soon as possible in order to allow other clients to write to the topic.

With the new mode it will be possible to implement locking in another way: the Producer holds the lock until someone else steals it. This way when you have very low contention you can achieve better latency for writes because you don't have to acquire the lock every time you want to write,.

## API and Wire protocol Changes

Changes:
- a new constant on the Wire Protocol for AccessMode
- a new constant in the Java Client API AccessMode#ExclusiveWithFencing

## Implementation

The new mode will behave mostly like AccessMode#Exclusive but instead of failing in case of the presence of other Producers it will force all of the current connected Producers to be removed and invalidated (they will see ProducerFencedException).

## Reject Alternatives

None
