/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import com.google.common.base.Joiner;
import io.netty.channel.Channel;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.common.util.MathUtils;
import org.apache.bookkeeper.common.util.MdcUtils;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.PerChannelBookieClient;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

abstract class CompletionValue {
    private final String operationName;
    protected Object ctx;
    protected long ledgerId;
    protected long entryId;
    protected long startTime;
    protected OpStatsLogger opLogger;
    protected OpStatsLogger timeoutOpLogger;
    protected Map<String, String> mdcContextMap;
    protected PerChannelBookieClient perChannelBookieClient;
    static final Logger LOG = LoggerFactory.getLogger(CompletionValue.class);

    public CompletionValue(String operationName, Object ctx, long ledgerId, long entryId, PerChannelBookieClient perChannelBookieClient) {
        this.operationName = operationName;
        this.ctx = ctx;
        this.ledgerId = ledgerId;
        this.entryId = entryId;
        this.startTime = MathUtils.nowInNano();
        this.perChannelBookieClient = perChannelBookieClient;
        if (perChannelBookieClient != null) {
            this.mdcContextMap = perChannelBookieClient.preserveMdcForTaskExecution ? MDC.getCopyOfContextMap() : null;
        }
    }

    private long latency() {
        return MathUtils.elapsedNanos((long)this.startTime);
    }

    void logOpResult(int rc) {
        if (rc != 0) {
            this.opLogger.registerFailedEvent(this.latency(), TimeUnit.NANOSECONDS);
        } else {
            this.opLogger.registerSuccessfulEvent(this.latency(), TimeUnit.NANOSECONDS);
        }
        if (rc != 0 && !PerChannelBookieClient.EXPECTED_BK_OPERATION_ERRORS.contains(rc)) {
            this.perChannelBookieClient.recordError();
        }
    }

    boolean maybeTimeout() {
        if (MathUtils.elapsedNanos((long)this.startTime) >= this.perChannelBookieClient.readEntryTimeoutNanos) {
            this.timeout();
            return true;
        }
        return false;
    }

    void timeout() {
        this.timeoutOpLogger.registerSuccessfulEvent(this.latency(), TimeUnit.NANOSECONDS);
        this.errorOut(-23);
    }

    protected void logResponse(BookkeeperProtocol.StatusCode status, Object ... extraInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got {} response from bookie:{} rc:{}, {}", new Object[]{this.operationName, this.perChannelBookieClient.bookieId, status, Joiner.on((String)":").join(extraInfo)});
        }
    }

    protected int convertStatus(BookkeeperProtocol.StatusCode status, int defaultStatus) {
        int rcToRet = this.statusCodeToExceptionCode(status);
        if (rcToRet == 1) {
            LOG.error("{} for failed on bookie {} code {}", new Object[]{this.operationName, this.perChannelBookieClient.bookieId, status});
            return defaultStatus;
        }
        return rcToRet;
    }

    private int statusCodeToExceptionCode(BookkeeperProtocol.StatusCode status) {
        switch (status) {
            case EOK: {
                return 0;
            }
            case ENOENTRY: {
                return -13;
            }
            case ENOLEDGER: {
                return -7;
            }
            case EBADVERSION: {
                return -16;
            }
            case EUA: {
                return -102;
            }
            case EFENCED: {
                return -101;
            }
            case EREADONLY: {
                return -104;
            }
            case ETOOMANYREQUESTS: {
                return -105;
            }
            case EUNKNOWNLEDGERSTATE: {
                return -108;
            }
        }
        return 1;
    }

    public void restoreMdcContext() {
        MdcUtils.restoreContext(this.mdcContextMap);
    }

    public abstract void errorOut();

    public abstract void errorOut(int var1);

    public void setOutstanding() {
    }

    protected void errorOutAndRunCallback(Runnable callback) {
        this.perChannelBookieClient.executor.executeOrdered(this.ledgerId, () -> {
            String bAddress = "null";
            Channel c = this.perChannelBookieClient.channel;
            if (c != null && c.remoteAddress() != null) {
                bAddress = c.remoteAddress().toString();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not write {} request to bookie {} for ledger {}, entry {}", new Object[]{this.operationName, bAddress, this.ledgerId, this.entryId});
            }
            callback.run();
        });
    }

    public void handleV2Response(long ledgerId, long entryId, BookkeeperProtocol.StatusCode status, BookieProtocol.Response response) {
        LOG.warn("Unhandled V2 response {}", (Object)response);
    }

    public abstract void handleV3Response(BookkeeperProtocol.Response var1);

    public void release() {
    }
}

