
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
 
 // Code generated by code-generation. DO NOT EDIT.

[type ErrorClassTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   ErrorClass
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, ErrorClass.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == ErrorClass.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type ErrorCodeTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   ErrorCode
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, ErrorCode.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == ErrorCode.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetAccessAuthenticationFactorDisableTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetAccessAuthenticationFactorDisable
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetAccessAuthenticationFactorDisable.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetAccessAuthenticationFactorDisable.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetAccessCredentialDisableTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetAccessCredentialDisable
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetAccessCredentialDisable.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetAccessCredentialDisable.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetAccessCredentialDisableReasonTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetAccessCredentialDisableReason
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetAccessCredentialDisableReason.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetAccessCredentialDisableReason.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetAccessEventTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetAccessEvent
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetAccessEvent.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetAccessEvent.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetAccessUserTypeTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetAccessUserType
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetAccessUserType.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetAccessUserType.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetAccessZoneOccupancyStateTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetAccessZoneOccupancyState
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetAccessZoneOccupancyState.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetAccessZoneOccupancyState.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetAuthorizationExemptionTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetAuthorizationExemption
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetAuthorizationExemption.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetAuthorizationExemption.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetAuthorizationModeTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetAuthorizationMode
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetAuthorizationMode.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetAuthorizationMode.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetBinaryLightingPVTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetBinaryLightingPV
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetBinaryLightingPV.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetBinaryLightingPV.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetDeviceStatusTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetDeviceStatus
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetDeviceStatus.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetDeviceStatus.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetDoorAlarmStateTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetDoorAlarmState
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetDoorAlarmState.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetDoorAlarmState.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetDoorStatusTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetDoorStatus
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetDoorStatus.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetDoorStatus.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetEngineeringUnitsTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetEngineeringUnits
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetEngineeringUnits.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetEngineeringUnits.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetEscalatorFaultTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetEscalatorFault
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetEscalatorFault.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetEscalatorFault.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetEscalatorModeTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetEscalatorMode
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetEscalatorMode.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetEscalatorMode.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetEscalatorOperationDirectionTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetEscalatorOperationDirection
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetEscalatorOperationDirection.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetEscalatorOperationDirection.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetEventStateTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetEventState
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetEventState.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetEventState.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetEventTypeTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetEventType
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetEventType.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetEventType.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetLifeSafetyModeTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetLifeSafetyMode
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetLifeSafetyMode.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetLifeSafetyMode.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetLifeSafetyOperationTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetLifeSafetyOperation
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetLifeSafetyOperation.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetLifeSafetyOperation.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetLifeSafetyStateTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetLifeSafetyState
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetLifeSafetyState.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetLifeSafetyState.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetLiftCarDirectionTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetLiftCarDirection
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetLiftCarDirection.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetLiftCarDirection.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetLiftCarDriveStatusTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetLiftCarDriveStatus
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetLiftCarDriveStatus.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetLiftCarDriveStatus.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetLiftCarModeTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetLiftCarMode
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetLiftCarMode.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetLiftCarMode.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetLiftFaultTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetLiftFault
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetLiftFault.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetLiftFault.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetLightingOperationTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetLightingOperation
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetLightingOperation.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetLightingOperation.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetLightingTransitionTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetLightingTransition
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetLightingTransition.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetLightingTransition.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetLoggingTypeTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetLoggingType
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetLoggingType.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetLoggingType.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetMaintenanceTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetMaintenance
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetMaintenance.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetMaintenance.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetNetworkPortCommandTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetNetworkPortCommand
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetNetworkPortCommand.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetNetworkPortCommand.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetNetworkTypeTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetNetworkType
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetNetworkType.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetNetworkType.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetObjectTypeTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetObjectType
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetObjectType.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetObjectType.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetProgramErrorTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetProgramError
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetProgramError.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetProgramError.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetPropertyIdentifierTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetPropertyIdentifier
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetPropertyIdentifier.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetPropertyIdentifier.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetRelationshipTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetRelationship
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetRelationship.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetRelationship.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetReliabilityTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetReliability
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetReliability.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetReliability.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetRestartReasonTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetRestartReason
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetRestartReason.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetRestartReason.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetSilencedStateTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetSilencedState
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetSilencedState.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetSilencedState.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

[type BACnetVTClassTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                               ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false               ]
    [manual   BACnetVTClass
                    value
                        'STATIC_CALL("readEnumGeneric", readBuffer, header.actualLength, BACnetVTClass.VENDOR_PROPRIETARY_VALUE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        '_value.isProprietary?0:(header.actualLength * 8)'                                   ]
    [virtual  bit   isProprietary
                        'value == BACnetVTClass.VENDOR_PROPRIETARY_VALUE'                                 ]
    [manual   uint 32
                    proprietaryValue
                        'STATIC_CALL("readProprietaryEnumGeneric", readBuffer, header.actualLength, isProprietary)'
                        'STATIC_CALL("writeProprietaryEnumGeneric", writeBuffer, proprietaryValue, isProprietary)'
                        '_value.isProprietary?(header.actualLength * 8):0'                                   ]
]

