/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class NetworkAddressUrlDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 15512;
  }

  // Properties.
  protected final PascalString networkInterface;
  protected final PascalString url;

  public NetworkAddressUrlDataType(PascalString networkInterface, PascalString url) {
    super();
    this.networkInterface = networkInterface;
    this.url = url;
  }

  public PascalString getNetworkInterface() {
    return networkInterface;
  }

  public PascalString getUrl() {
    return url;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("NetworkAddressUrlDataType");

    // Simple Field (networkInterface)
    writeSimpleField("networkInterface", networkInterface, writeComplex(writeBuffer));

    // Simple Field (url)
    writeSimpleField("url", url, writeComplex(writeBuffer));

    writeBuffer.popContext("NetworkAddressUrlDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    NetworkAddressUrlDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (networkInterface)
    lengthInBits += networkInterface.getLengthInBits();

    // Simple field (url)
    lengthInBits += url.getLengthInBits();

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("NetworkAddressUrlDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString networkInterface =
        readSimpleField(
            "networkInterface",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString url =
        readSimpleField("url", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("NetworkAddressUrlDataType");
    // Create the instance
    return new NetworkAddressUrlDataTypeBuilderImpl(networkInterface, url);
  }

  public static class NetworkAddressUrlDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString networkInterface;
    private final PascalString url;

    public NetworkAddressUrlDataTypeBuilderImpl(PascalString networkInterface, PascalString url) {
      this.networkInterface = networkInterface;
      this.url = url;
    }

    public NetworkAddressUrlDataType build() {
      NetworkAddressUrlDataType networkAddressUrlDataType =
          new NetworkAddressUrlDataType(networkInterface, url);
      return networkAddressUrlDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof NetworkAddressUrlDataType)) {
      return false;
    }
    NetworkAddressUrlDataType that = (NetworkAddressUrlDataType) o;
    return (getNetworkInterface() == that.getNetworkInterface())
        && (getUrl() == that.getUrl())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getNetworkInterface(), getUrl());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
