/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class KnxNetIpMessage implements Message {

  // Abstract accessors for discriminator values.
  public abstract Integer getMsgType();

  // Constant values.
  public static final Short PROTOCOLVERSION = 0x10;

  public KnxNetIpMessage() {
    super();
  }

  public short getProtocolVersion() {
    return PROTOCOLVERSION;
  }

  protected abstract void serializeKnxNetIpMessageChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("KnxNetIpMessage");

    // Implicit Field (headerLength) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    short headerLength = (short) (6);
    writeImplicitField(
        "headerLength",
        headerLength,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Const Field (protocolVersion)
    writeConstField(
        "protocolVersion",
        PROTOCOLVERSION,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Discriminator Field (msgType) (Used as input to a switch field)
    writeDiscriminatorField(
        "msgType",
        getMsgType(),
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Implicit Field (totalLength) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int totalLength = (int) (getLengthInBytes());
    writeImplicitField(
        "totalLength",
        totalLength,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Switch field (Serialize the sub-type)
    serializeKnxNetIpMessageChild(writeBuffer);

    writeBuffer.popContext("KnxNetIpMessage");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    KnxNetIpMessage _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Implicit Field (headerLength)
    lengthInBits += 8;

    // Const Field (protocolVersion)
    lengthInBits += 8;

    // Discriminator Field (msgType)
    lengthInBits += 16;

    // Implicit Field (totalLength)
    lengthInBits += 16;

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static KnxNetIpMessage staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("KnxNetIpMessage");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short headerLength =
        readImplicitField(
            "headerLength",
            readUnsignedShort(readBuffer, 8),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    short protocolVersion =
        readConstField(
            "protocolVersion",
            readUnsignedShort(readBuffer, 8),
            KnxNetIpMessage.PROTOCOLVERSION,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int msgType =
        readDiscriminatorField(
            "msgType",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int totalLength =
        readImplicitField(
            "totalLength",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    KnxNetIpMessageBuilder builder = null;
    if (EvaluationHelper.equals(msgType, (int) 0x0201)) {
      builder = SearchRequest.staticParseKnxNetIpMessageBuilder(readBuffer);
    } else if (EvaluationHelper.equals(msgType, (int) 0x0202)) {
      builder = SearchResponse.staticParseKnxNetIpMessageBuilder(readBuffer);
    } else if (EvaluationHelper.equals(msgType, (int) 0x0203)) {
      builder = DescriptionRequest.staticParseKnxNetIpMessageBuilder(readBuffer);
    } else if (EvaluationHelper.equals(msgType, (int) 0x0204)) {
      builder = DescriptionResponse.staticParseKnxNetIpMessageBuilder(readBuffer);
    } else if (EvaluationHelper.equals(msgType, (int) 0x0205)) {
      builder = ConnectionRequest.staticParseKnxNetIpMessageBuilder(readBuffer);
    } else if (EvaluationHelper.equals(msgType, (int) 0x0206)) {
      builder = ConnectionResponse.staticParseKnxNetIpMessageBuilder(readBuffer);
    } else if (EvaluationHelper.equals(msgType, (int) 0x0207)) {
      builder = ConnectionStateRequest.staticParseKnxNetIpMessageBuilder(readBuffer);
    } else if (EvaluationHelper.equals(msgType, (int) 0x0208)) {
      builder = ConnectionStateResponse.staticParseKnxNetIpMessageBuilder(readBuffer);
    } else if (EvaluationHelper.equals(msgType, (int) 0x0209)) {
      builder = DisconnectRequest.staticParseKnxNetIpMessageBuilder(readBuffer);
    } else if (EvaluationHelper.equals(msgType, (int) 0x020A)) {
      builder = DisconnectResponse.staticParseKnxNetIpMessageBuilder(readBuffer);
    } else if (EvaluationHelper.equals(msgType, (int) 0x020B)) {
      builder = UnknownMessage.staticParseKnxNetIpMessageBuilder(readBuffer, totalLength);
    } else if (EvaluationHelper.equals(msgType, (int) 0x0310)) {
      builder =
          DeviceConfigurationRequest.staticParseKnxNetIpMessageBuilder(readBuffer, totalLength);
    } else if (EvaluationHelper.equals(msgType, (int) 0x0311)) {
      builder = DeviceConfigurationAck.staticParseKnxNetIpMessageBuilder(readBuffer);
    } else if (EvaluationHelper.equals(msgType, (int) 0x0420)) {
      builder = TunnelingRequest.staticParseKnxNetIpMessageBuilder(readBuffer, totalLength);
    } else if (EvaluationHelper.equals(msgType, (int) 0x0421)) {
      builder = TunnelingResponse.staticParseKnxNetIpMessageBuilder(readBuffer);
    } else if (EvaluationHelper.equals(msgType, (int) 0x0530)) {
      builder = RoutingIndication.staticParseKnxNetIpMessageBuilder(readBuffer);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type" + " parameters [" + "msgType=" + msgType + "]");
    }

    readBuffer.closeContext("KnxNetIpMessage");
    // Create the instance
    KnxNetIpMessage _knxNetIpMessage = builder.build();
    return _knxNetIpMessage;
  }

  public interface KnxNetIpMessageBuilder {
    KnxNetIpMessage build();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof KnxNetIpMessage)) {
      return false;
    }
    KnxNetIpMessage that = (KnxNetIpMessage) o;
    return true;
  }

  @Override
  public int hashCode() {
    return Objects.hash();
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
