/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.plc4x.java.api.types.PlcValueType;

// Code generated by code-generation. DO NOT EDIT.

public enum KnxDatapointType {
  DPT_UNKNOWN(
      (long) 0L,
      (int) 0,
      PlcValueType.Struct,
      (String) "Unknown Datapoint Subtype",
      (String) "",
      KnxDatapointMainType.DPT_UNKNOWN),
  BOOL(
      (long) 1L,
      (int) 0,
      PlcValueType.BOOL,
      (String) "BOOL",
      (String) "",
      KnxDatapointMainType.DPT_1_BIT),
  BYTE(
      (long) 2L,
      (int) 0,
      PlcValueType.BYTE,
      (String) "BYTE",
      (String) "",
      KnxDatapointMainType.DPT_8_BIT_SET),
  WORD(
      (long) 3L,
      (int) 0,
      PlcValueType.WORD,
      (String) "WORD",
      (String) "",
      KnxDatapointMainType.DPT_16_BIT_SET),
  DWORD(
      (long) 4L,
      (int) 0,
      PlcValueType.DWORD,
      (String) "DWORD",
      (String) "",
      KnxDatapointMainType.DPT_32_BIT_SET),
  LWORD(
      (long) 5L,
      (int) 0,
      PlcValueType.LWORD,
      (String) "LWORD",
      (String) "",
      KnxDatapointMainType.DPT_64_BIT_SET),
  USINT(
      (long) 6L,
      (int) 0,
      PlcValueType.USINT,
      (String) "USINT",
      (String) "",
      KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE),
  SINT(
      (long) 7L,
      (int) 0,
      PlcValueType.SINT,
      (String) "SINT",
      (String) "",
      KnxDatapointMainType.DPT_8_BIT_SIGNED_VALUE),
  UINT(
      (long) 8L,
      (int) 0,
      PlcValueType.UINT,
      (String) "UINT",
      (String) "",
      KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  INT(
      (long) 9L,
      (int) 0,
      PlcValueType.INT,
      (String) "INT",
      (String) "",
      KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
  UDINT(
      (long) 10L,
      (int) 0,
      PlcValueType.UDINT,
      (String) "UDINT",
      (String) "",
      KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
  DINT(
      (long) 11L,
      (int) 0,
      PlcValueType.DINT,
      (String) "DINT",
      (String) "",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  ULINT(
      (long) 12L,
      (int) 0,
      PlcValueType.ULINT,
      (String) "ULINT",
      (String) "",
      KnxDatapointMainType.DPT_8_BYTE_UNSIGNED_VALUE),
  LINT(
      (long) 13L,
      (int) 0,
      PlcValueType.LINT,
      (String) "LINT",
      (String) "",
      KnxDatapointMainType.DPT_8_BYTE_SIGNED_VALUE),
  REAL(
      (long) 14L,
      (int) 0,
      PlcValueType.REAL,
      (String) "REAL",
      (String) "",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  LREAL(
      (long) 15L,
      (int) 0,
      PlcValueType.LREAL,
      (String) "LREAL",
      (String) "",
      KnxDatapointMainType.DPT_8_BYTE_FLOAT_VALUE),
  CHAR(
      (long) 16L,
      (int) 0,
      PlcValueType.CHAR,
      (String) "CHAR",
      (String) "",
      KnxDatapointMainType.DPT_CHARACTER),
  WCHAR(
      (long) 17L,
      (int) 0,
      PlcValueType.WCHAR,
      (String) "WCHAR",
      (String) "",
      KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  STRING(
      (long) 18L,
      (int) 0,
      PlcValueType.STRING,
      (String) "STRING",
      (String) "",
      KnxDatapointMainType.DPT_UNKNOWN),
  WSTRING(
      (long) 19L,
      (int) 0,
      PlcValueType.WSTRING,
      (String) "WSTRING",
      (String) "",
      KnxDatapointMainType.DPT_UNKNOWN),
  TIME(
      (long) 20L,
      (int) 0,
      PlcValueType.TIME,
      (String) "TIME",
      (String) "",
      KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
  LTIME(
      (long) 21L,
      (int) 0,
      PlcValueType.LTIME,
      (String) "LTIME",
      (String) "",
      KnxDatapointMainType.DPT_8_BYTE_UNSIGNED_VALUE),
  DATE(
      (long) 22L,
      (int) 0,
      PlcValueType.DATE,
      (String) "DATE",
      (String) "",
      KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  TIME_OF_DAY(
      (long) 23L,
      (int) 0,
      PlcValueType.TIME_OF_DAY,
      (String) "TIME_OF_DAY",
      (String) "",
      KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
  TOD(
      (long) 24L,
      (int) 0,
      PlcValueType.TIME_OF_DAY,
      (String) "TOD",
      (String) "",
      KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
  DATE_AND_TIME(
      (long) 25L,
      (int) 0,
      PlcValueType.DATE_AND_TIME,
      (String) "DATE_AND_TIME",
      (String) "",
      KnxDatapointMainType.DPT_12_BYTE_SIGNED_VALUE),
  DT(
      (long) 26L,
      (int) 0,
      PlcValueType.DATE_AND_TIME,
      (String) "DT",
      (String) "",
      KnxDatapointMainType.DPT_12_BYTE_SIGNED_VALUE),
  DPT_Switch(
      (long) 27L,
      (int) 1,
      PlcValueType.BOOL,
      (String) "switch",
      (String) "DPST-1-1",
      KnxDatapointMainType.DPT_1_BIT),
  DPT_Bool(
      (long) 28L,
      (int) 2,
      PlcValueType.BOOL,
      (String) "boolean",
      (String) "DPST-1-2",
      KnxDatapointMainType.DPT_1_BIT),
  DPT_Enable(
      (long) 29L,
      (int) 3,
      PlcValueType.BOOL,
      (String) "enable",
      (String) "DPST-1-3",
      KnxDatapointMainType.DPT_1_BIT),
  DPT_Ramp(
      (long) 30L,
      (int) 4,
      PlcValueType.BOOL,
      (String) "ramp",
      (String) "DPST-1-4",
      KnxDatapointMainType.DPT_1_BIT),
  DPT_Alarm(
      (long) 31L,
      (int) 5,
      PlcValueType.BOOL,
      (String) "alarm",
      (String) "DPST-1-5",
      KnxDatapointMainType.DPT_1_BIT),
  DPT_BinaryValue(
      (long) 32L,
      (int) 6,
      PlcValueType.BOOL,
      (String) "binary value",
      (String) "DPST-1-6",
      KnxDatapointMainType.DPT_1_BIT),
  DPT_Step(
      (long) 33L,
      (int) 7,
      PlcValueType.BOOL,
      (String) "step",
      (String) "DPST-1-7",
      KnxDatapointMainType.DPT_1_BIT),
  DPT_UpDown(
      (long) 34L,
      (int) 8,
      PlcValueType.BOOL,
      (String) "up/down",
      (String) "DPST-1-8",
      KnxDatapointMainType.DPT_1_BIT),
  DPT_OpenClose(
      (long) 35L,
      (int) 9,
      PlcValueType.BOOL,
      (String) "open/close",
      (String) "DPST-1-9",
      KnxDatapointMainType.DPT_1_BIT),
  DPT_Start(
      (long) 36L,
      (int) 10,
      PlcValueType.BOOL,
      (String) "start/stop",
      (String) "DPST-1-10",
      KnxDatapointMainType.DPT_1_BIT),
  DPT_State(
      (long) 37L,
      (int) 11,
      PlcValueType.BOOL,
      (String) "state",
      (String) "DPST-1-11",
      KnxDatapointMainType.DPT_1_BIT),
  DPT_Invert(
      (long) 38L,
      (int) 12,
      PlcValueType.BOOL,
      (String) "invert",
      (String) "DPST-1-12",
      KnxDatapointMainType.DPT_1_BIT),
  DPT_DimSendStyle(
      (long) 39L,
      (int) 13,
      PlcValueType.BOOL,
      (String) "dim send style",
      (String) "DPST-1-13",
      KnxDatapointMainType.DPT_1_BIT),
  DPT_InputSource(
      (long) 40L,
      (int) 14,
      PlcValueType.BOOL,
      (String) "input source",
      (String) "DPST-1-14",
      KnxDatapointMainType.DPT_1_BIT),
  DPT_Reset(
      (long) 41L,
      (int) 15,
      PlcValueType.BOOL,
      (String) "reset",
      (String) "DPST-1-15",
      KnxDatapointMainType.DPT_1_BIT),
  DPT_Ack(
      (long) 42L,
      (int) 16,
      PlcValueType.BOOL,
      (String) "acknowledge",
      (String) "DPST-1-16",
      KnxDatapointMainType.DPT_1_BIT),
  DPT_Trigger(
      (long) 43L,
      (int) 17,
      PlcValueType.BOOL,
      (String) "trigger",
      (String) "DPST-1-17",
      KnxDatapointMainType.DPT_1_BIT),
  DPT_Occupancy(
      (long) 44L,
      (int) 18,
      PlcValueType.BOOL,
      (String) "occupancy",
      (String) "DPST-1-18",
      KnxDatapointMainType.DPT_1_BIT),
  DPT_Window_Door(
      (long) 45L,
      (int) 19,
      PlcValueType.BOOL,
      (String) "window/door",
      (String) "DPST-1-19",
      KnxDatapointMainType.DPT_1_BIT),
  DPT_LogicalFunction(
      (long) 46L,
      (int) 21,
      PlcValueType.BOOL,
      (String) "logical function",
      (String) "DPST-1-21",
      KnxDatapointMainType.DPT_1_BIT),
  DPT_Scene_AB(
      (long) 47L,
      (int) 22,
      PlcValueType.BOOL,
      (String) "scene",
      (String) "DPST-1-22",
      KnxDatapointMainType.DPT_1_BIT),
  DPT_ShutterBlinds_Mode(
      (long) 48L,
      (int) 23,
      PlcValueType.BOOL,
      (String) "shutter/blinds mode",
      (String) "DPST-1-23",
      KnxDatapointMainType.DPT_1_BIT),
  DPT_DayNight(
      (long) 49L,
      (int) 24,
      PlcValueType.BOOL,
      (String) "day/night",
      (String) "DPST-1-24",
      KnxDatapointMainType.DPT_1_BIT),
  DPT_Heat_Cool(
      (long) 50L,
      (int) 100,
      PlcValueType.BOOL,
      (String) "cooling/heating",
      (String) "DPST-1-100",
      KnxDatapointMainType.DPT_1_BIT),
  DPT_Switch_Control(
      (long) 51L,
      (int) 1,
      PlcValueType.Struct,
      (String) "switch control",
      (String) "DPST-2-1",
      KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
  DPT_Bool_Control(
      (long) 52L,
      (int) 2,
      PlcValueType.Struct,
      (String) "boolean control",
      (String) "DPST-2-2",
      KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
  DPT_Enable_Control(
      (long) 53L,
      (int) 3,
      PlcValueType.Struct,
      (String) "enable control",
      (String) "DPST-2-3",
      KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
  DPT_Ramp_Control(
      (long) 54L,
      (int) 4,
      PlcValueType.Struct,
      (String) "ramp control",
      (String) "DPST-2-4",
      KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
  DPT_Alarm_Control(
      (long) 55L,
      (int) 5,
      PlcValueType.Struct,
      (String) "alarm control",
      (String) "DPST-2-5",
      KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
  DPT_BinaryValue_Control(
      (long) 56L,
      (int) 6,
      PlcValueType.Struct,
      (String) "binary value control",
      (String) "DPST-2-6",
      KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
  DPT_Step_Control(
      (long) 57L,
      (int) 7,
      PlcValueType.Struct,
      (String) "step control",
      (String) "DPST-2-7",
      KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
  DPT_Direction1_Control(
      (long) 58L,
      (int) 8,
      PlcValueType.Struct,
      (String) "direction control 1",
      (String) "DPST-2-8",
      KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
  DPT_Direction2_Control(
      (long) 59L,
      (int) 9,
      PlcValueType.Struct,
      (String) "direction control 2",
      (String) "DPST-2-9",
      KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
  DPT_Start_Control(
      (long) 60L,
      (int) 10,
      PlcValueType.Struct,
      (String) "start control",
      (String) "DPST-2-10",
      KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
  DPT_State_Control(
      (long) 61L,
      (int) 11,
      PlcValueType.Struct,
      (String) "state control",
      (String) "DPST-2-11",
      KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
  DPT_Invert_Control(
      (long) 62L,
      (int) 12,
      PlcValueType.Struct,
      (String) "invert control",
      (String) "DPST-2-12",
      KnxDatapointMainType.DPT_1_BIT_CONTROLLED),
  DPT_Control_Dimming(
      (long) 63L,
      (int) 7,
      PlcValueType.Struct,
      (String) "dimming control",
      (String) "DPST-3-7",
      KnxDatapointMainType.DPT_3_BIT_CONTROLLED),
  DPT_Control_Blinds(
      (long) 64L,
      (int) 8,
      PlcValueType.Struct,
      (String) "blind control",
      (String) "DPST-3-8",
      KnxDatapointMainType.DPT_3_BIT_CONTROLLED),
  DPT_Char_ASCII(
      (long) 65L,
      (int) 1,
      PlcValueType.STRING,
      (String) "character (ASCII)",
      (String) "DPST-4-1",
      KnxDatapointMainType.DPT_CHARACTER),
  DPT_Char_8859_1(
      (long) 66L,
      (int) 2,
      PlcValueType.STRING,
      (String) "character (ISO 8859-1)",
      (String) "DPST-4-2",
      KnxDatapointMainType.DPT_CHARACTER),
  DPT_Scaling(
      (long) 67L,
      (int) 1,
      PlcValueType.USINT,
      (String) "percentage (0..100%)",
      (String) "DPST-5-1",
      KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE),
  DPT_Angle(
      (long) 68L,
      (int) 3,
      PlcValueType.USINT,
      (String) "angle (degrees)",
      (String) "DPST-5-3",
      KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE),
  DPT_Percent_U8(
      (long) 69L,
      (int) 4,
      PlcValueType.USINT,
      (String) "percentage (0..255%)",
      (String) "DPST-5-4",
      KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE),
  DPT_DecimalFactor(
      (long) 70L,
      (int) 5,
      PlcValueType.USINT,
      (String) "ratio (0..255)",
      (String) "DPST-5-5",
      KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE),
  DPT_Tariff(
      (long) 71L,
      (int) 6,
      PlcValueType.USINT,
      (String) "tariff (0..255)",
      (String) "DPST-5-6",
      KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE),
  DPT_Value_1_Ucount(
      (long) 72L,
      (int) 10,
      PlcValueType.USINT,
      (String) "counter pulses (0..255)",
      (String) "DPST-5-10",
      KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE),
  DPT_FanStage(
      (long) 73L,
      (int) 100,
      PlcValueType.USINT,
      (String) "fan stage (0..255)",
      (String) "DPST-5-100",
      KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE),
  DPT_Percent_V8(
      (long) 74L,
      (int) 1,
      PlcValueType.SINT,
      (String) "percentage (-128..127%)",
      (String) "DPST-6-1",
      KnxDatapointMainType.DPT_8_BIT_SIGNED_VALUE),
  DPT_Value_1_Count(
      (long) 75L,
      (int) 10,
      PlcValueType.SINT,
      (String) "counter pulses (-128..127)",
      (String) "DPST-6-10",
      KnxDatapointMainType.DPT_8_BIT_SIGNED_VALUE),
  DPT_Status_Mode3(
      (long) 76L,
      (int) 20,
      PlcValueType.Struct,
      (String) "status with mode",
      (String) "DPST-6-20",
      KnxDatapointMainType.DPT_8_BIT_SIGNED_VALUE),
  DPT_Value_2_Ucount(
      (long) 77L,
      (int) 1,
      PlcValueType.UINT,
      (String) "pulses",
      (String) "DPST-7-1",
      KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  DPT_TimePeriodMsec(
      (long) 78L,
      (int) 2,
      PlcValueType.UINT,
      (String) "time (ms)",
      (String) "DPST-7-2",
      KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  DPT_TimePeriod10Msec(
      (long) 79L,
      (int) 3,
      PlcValueType.UINT,
      (String) "time (10 ms)",
      (String) "DPST-7-3",
      KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  DPT_TimePeriod100Msec(
      (long) 80L,
      (int) 4,
      PlcValueType.UINT,
      (String) "time (100 ms)",
      (String) "DPST-7-4",
      KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  DPT_TimePeriodSec(
      (long) 81L,
      (int) 5,
      PlcValueType.UINT,
      (String) "time (s)",
      (String) "DPST-7-5",
      KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  DPT_TimePeriodMin(
      (long) 82L,
      (int) 6,
      PlcValueType.UINT,
      (String) "time (min)",
      (String) "DPST-7-6",
      KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  DPT_TimePeriodHrs(
      (long) 83L,
      (int) 7,
      PlcValueType.UINT,
      (String) "time (h)",
      (String) "DPST-7-7",
      KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  DPT_PropDataType(
      (long) 84L,
      (int) 10,
      PlcValueType.UINT,
      (String) "property data type",
      (String) "DPST-7-10",
      KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  DPT_Length_mm(
      (long) 85L,
      (int) 11,
      PlcValueType.UINT,
      (String) "length (mm)",
      (String) "DPST-7-11",
      KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  DPT_UElCurrentmA(
      (long) 86L,
      (int) 12,
      PlcValueType.UINT,
      (String) "current (mA)",
      (String) "DPST-7-12",
      KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  DPT_Brightness(
      (long) 87L,
      (int) 13,
      PlcValueType.UINT,
      (String) "brightness (lux)",
      (String) "DPST-7-13",
      KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  DPT_Absolute_Colour_Temperature(
      (long) 88L,
      (int) 600,
      PlcValueType.UINT,
      (String) "absolute colour temperature (K)",
      (String) "DPST-7-600",
      KnxDatapointMainType.DPT_2_BYTE_UNSIGNED_VALUE),
  DPT_Value_2_Count(
      (long) 89L,
      (int) 1,
      PlcValueType.INT,
      (String) "pulses difference",
      (String) "DPST-8-1",
      KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
  DPT_DeltaTimeMsec(
      (long) 90L,
      (int) 2,
      PlcValueType.INT,
      (String) "time lag (ms)",
      (String) "DPST-8-2",
      KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
  DPT_DeltaTime10Msec(
      (long) 91L,
      (int) 3,
      PlcValueType.INT,
      (String) "time lag(10 ms)",
      (String) "DPST-8-3",
      KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
  DPT_DeltaTime100Msec(
      (long) 92L,
      (int) 4,
      PlcValueType.INT,
      (String) "time lag (100 ms)",
      (String) "DPST-8-4",
      KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
  DPT_DeltaTimeSec(
      (long) 93L,
      (int) 5,
      PlcValueType.INT,
      (String) "time lag (s)",
      (String) "DPST-8-5",
      KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
  DPT_DeltaTimeMin(
      (long) 94L,
      (int) 6,
      PlcValueType.INT,
      (String) "time lag (min)",
      (String) "DPST-8-6",
      KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
  DPT_DeltaTimeHrs(
      (long) 95L,
      (int) 7,
      PlcValueType.INT,
      (String) "time lag (h)",
      (String) "DPST-8-7",
      KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
  DPT_Percent_V16(
      (long) 96L,
      (int) 10,
      PlcValueType.INT,
      (String) "percentage difference (%)",
      (String) "DPST-8-10",
      KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
  DPT_Rotation_Angle(
      (long) 97L,
      (int) 11,
      PlcValueType.INT,
      (String) "rotation angle (°)",
      (String) "DPST-8-11",
      KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
  DPT_Length_m(
      (long) 98L,
      (int) 12,
      PlcValueType.INT,
      (String) "length (m)",
      (String) "DPST-8-12",
      KnxDatapointMainType.DPT_2_BYTE_SIGNED_VALUE),
  DPT_Value_Temp(
      (long) 99L,
      (int) 1,
      PlcValueType.REAL,
      (String) "temperature (°C)",
      (String) "DPST-9-1",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Tempd(
      (long) 100L,
      (int) 2,
      PlcValueType.REAL,
      (String) "temperature difference (K)",
      (String) "DPST-9-2",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Tempa(
      (long) 101L,
      (int) 3,
      PlcValueType.REAL,
      (String) "kelvin/hour (K/h)",
      (String) "DPST-9-3",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Lux(
      (long) 102L,
      (int) 4,
      PlcValueType.REAL,
      (String) "lux (Lux)",
      (String) "DPST-9-4",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Wsp(
      (long) 103L,
      (int) 5,
      PlcValueType.REAL,
      (String) "speed (m/s)",
      (String) "DPST-9-5",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Pres(
      (long) 104L,
      (int) 6,
      PlcValueType.REAL,
      (String) "pressure (Pa)",
      (String) "DPST-9-6",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Humidity(
      (long) 105L,
      (int) 7,
      PlcValueType.REAL,
      (String) "humidity (%)",
      (String) "DPST-9-7",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_AirQuality(
      (long) 106L,
      (int) 8,
      PlcValueType.REAL,
      (String) "parts/million (ppm)",
      (String) "DPST-9-8",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_AirFlow(
      (long) 107L,
      (int) 9,
      PlcValueType.REAL,
      (String) "air flow (m³/h)",
      (String) "DPST-9-9",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Time1(
      (long) 108L,
      (int) 10,
      PlcValueType.REAL,
      (String) "time (s)",
      (String) "DPST-9-10",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Time2(
      (long) 109L,
      (int) 11,
      PlcValueType.REAL,
      (String) "time (ms)",
      (String) "DPST-9-11",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Volt(
      (long) 110L,
      (int) 20,
      PlcValueType.REAL,
      (String) "voltage (mV)",
      (String) "DPST-9-20",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Curr(
      (long) 111L,
      (int) 21,
      PlcValueType.REAL,
      (String) "current (mA)",
      (String) "DPST-9-21",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_PowerDensity(
      (long) 112L,
      (int) 22,
      PlcValueType.REAL,
      (String) "power density (W/m²)",
      (String) "DPST-9-22",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_KelvinPerPercent(
      (long) 113L,
      (int) 23,
      PlcValueType.REAL,
      (String) "kelvin/percent (K/%)",
      (String) "DPST-9-23",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Power(
      (long) 114L,
      (int) 24,
      PlcValueType.REAL,
      (String) "power (kW)",
      (String) "DPST-9-24",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Volume_Flow(
      (long) 115L,
      (int) 25,
      PlcValueType.REAL,
      (String) "volume flow (l/h)",
      (String) "DPST-9-25",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Rain_Amount(
      (long) 116L,
      (int) 26,
      PlcValueType.REAL,
      (String) "rain amount (l/m²)",
      (String) "DPST-9-26",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Temp_F(
      (long) 117L,
      (int) 27,
      PlcValueType.REAL,
      (String) "temperature (°F)",
      (String) "DPST-9-27",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Wsp_kmh(
      (long) 118L,
      (int) 28,
      PlcValueType.REAL,
      (String) "wind speed (km/h)",
      (String) "DPST-9-28",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Value_Absolute_Humidity(
      (long) 119L,
      (int) 29,
      PlcValueType.REAL,
      (String) "absolute humidity (g/m³)",
      (String) "DPST-9-29",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Concentration_ygm3(
      (long) 120L,
      (int) 30,
      PlcValueType.REAL,
      (String) "concentration (µg/m³)",
      (String) "DPST-9-30",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_Coefficient(
      (long) 121L,
      (int) 31,
      PlcValueType.REAL,
      (String) "coefficient",
      (String) "DPST-9-31",
      KnxDatapointMainType.DPT_2_BYTE_FLOAT_VALUE),
  DPT_TimeOfDay(
      (long) 122L,
      (int) 1,
      PlcValueType.Struct,
      (String) "time of day",
      (String) "DPST-10-1",
      KnxDatapointMainType.DPT_TIME),
  DPT_Date(
      (long) 123L,
      (int) 1,
      PlcValueType.Struct,
      (String) "date",
      (String) "DPST-11-1",
      KnxDatapointMainType.DPT_DATE),
  DPT_Value_4_Ucount(
      (long) 124L,
      (int) 1,
      PlcValueType.UDINT,
      (String) "counter pulses (unsigned)",
      (String) "DPST-12-1",
      KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
  DPT_LongTimePeriod_Sec(
      (long) 125L,
      (int) 100,
      PlcValueType.UDINT,
      (String) "counter timesec (s)",
      (String) "DPST-12-100",
      KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
  DPT_LongTimePeriod_Min(
      (long) 126L,
      (int) 101,
      PlcValueType.UDINT,
      (String) "counter timemin (min)",
      (String) "DPST-12-101",
      KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
  DPT_LongTimePeriod_Hrs(
      (long) 127L,
      (int) 102,
      PlcValueType.UDINT,
      (String) "counter timehrs (h)",
      (String) "DPST-12-102",
      KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
  DPT_VolumeLiquid_Litre(
      (long) 128L,
      (int) 1200,
      PlcValueType.UDINT,
      (String) "volume liquid (l)",
      (String) "DPST-12-1200",
      KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
  DPT_Volume_m_3(
      (long) 129L,
      (int) 1201,
      PlcValueType.UDINT,
      (String) "volume (m³)",
      (String) "DPST-12-1201",
      KnxDatapointMainType.DPT_4_BYTE_UNSIGNED_VALUE),
  DPT_Value_4_Count(
      (long) 130L,
      (int) 1,
      PlcValueType.DINT,
      (String) "counter pulses (signed)",
      (String) "DPST-13-1",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  DPT_FlowRate_m3h(
      (long) 131L,
      (int) 2,
      PlcValueType.DINT,
      (String) "flow rate (m³/h)",
      (String) "DPST-13-2",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  DPT_ActiveEnergy(
      (long) 132L,
      (int) 10,
      PlcValueType.DINT,
      (String) "active energy (Wh)",
      (String) "DPST-13-10",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  DPT_ApparentEnergy(
      (long) 133L,
      (int) 11,
      PlcValueType.DINT,
      (String) "apparent energy (VAh)",
      (String) "DPST-13-11",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  DPT_ReactiveEnergy(
      (long) 134L,
      (int) 12,
      PlcValueType.DINT,
      (String) "reactive energy (VARh)",
      (String) "DPST-13-12",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  DPT_ActiveEnergy_kWh(
      (long) 135L,
      (int) 13,
      PlcValueType.DINT,
      (String) "active energy (kWh)",
      (String) "DPST-13-13",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  DPT_ApparentEnergy_kVAh(
      (long) 136L,
      (int) 14,
      PlcValueType.DINT,
      (String) "apparent energy (kVAh)",
      (String) "DPST-13-14",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  DPT_ReactiveEnergy_kVARh(
      (long) 137L,
      (int) 15,
      PlcValueType.DINT,
      (String) "reactive energy (kVARh)",
      (String) "DPST-13-15",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  DPT_ActiveEnergy_MWh(
      (long) 138L,
      (int) 16,
      PlcValueType.DINT,
      (String) "active energy (MWh)",
      (String) "DPST-13-16",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  DPT_LongDeltaTimeSec(
      (long) 139L,
      (int) 100,
      PlcValueType.DINT,
      (String) "time lag (s)",
      (String) "DPST-13-100",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  DPT_DeltaVolumeLiquid_Litre(
      (long) 140L,
      (int) 1200,
      PlcValueType.DINT,
      (String) "delta volume liquid (l)",
      (String) "DPST-13-1200",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  DPT_DeltaVolume_m_3(
      (long) 141L,
      (int) 1201,
      PlcValueType.DINT,
      (String) "delta volume (m³)",
      (String) "DPST-13-1201",
      KnxDatapointMainType.DPT_4_BYTE_SIGNED_VALUE),
  DPT_Value_Acceleration(
      (long) 142L,
      (int) 0,
      PlcValueType.REAL,
      (String) "acceleration (m/s²)",
      (String) "DPST-14-0",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Acceleration_Angular(
      (long) 143L,
      (int) 1,
      PlcValueType.REAL,
      (String) "angular acceleration (rad/s²)",
      (String) "DPST-14-1",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Activation_Energy(
      (long) 144L,
      (int) 2,
      PlcValueType.REAL,
      (String) "activation energy (J/mol)",
      (String) "DPST-14-2",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Activity(
      (long) 145L,
      (int) 3,
      PlcValueType.REAL,
      (String) "radioactive activity (1/s)",
      (String) "DPST-14-3",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Mol(
      (long) 146L,
      (int) 4,
      PlcValueType.REAL,
      (String) "amount of substance (mol)",
      (String) "DPST-14-4",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Amplitude(
      (long) 147L,
      (int) 5,
      PlcValueType.REAL,
      (String) "amplitude",
      (String) "DPST-14-5",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_AngleRad(
      (long) 148L,
      (int) 6,
      PlcValueType.REAL,
      (String) "angle (radiant)",
      (String) "DPST-14-6",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_AngleDeg(
      (long) 149L,
      (int) 7,
      PlcValueType.REAL,
      (String) "angle (degree)",
      (String) "DPST-14-7",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Angular_Momentum(
      (long) 150L,
      (int) 8,
      PlcValueType.REAL,
      (String) "angular momentum (Js)",
      (String) "DPST-14-8",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Angular_Velocity(
      (long) 151L,
      (int) 9,
      PlcValueType.REAL,
      (String) "angular velocity (rad/s)",
      (String) "DPST-14-9",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Area(
      (long) 152L,
      (int) 10,
      PlcValueType.REAL,
      (String) "area (m*m)",
      (String) "DPST-14-10",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Capacitance(
      (long) 153L,
      (int) 11,
      PlcValueType.REAL,
      (String) "capacitance (F)",
      (String) "DPST-14-11",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Charge_DensitySurface(
      (long) 154L,
      (int) 12,
      PlcValueType.REAL,
      (String) "flux density (C/m²)",
      (String) "DPST-14-12",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Charge_DensityVolume(
      (long) 155L,
      (int) 13,
      PlcValueType.REAL,
      (String) "charge density (C/m³)",
      (String) "DPST-14-13",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Compressibility(
      (long) 156L,
      (int) 14,
      PlcValueType.REAL,
      (String) "compressibility (m²/N)",
      (String) "DPST-14-14",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Conductance(
      (long) 157L,
      (int) 15,
      PlcValueType.REAL,
      (String) "conductance (S)",
      (String) "DPST-14-15",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electrical_Conductivity(
      (long) 158L,
      (int) 16,
      PlcValueType.REAL,
      (String) "conductivity (S/m)",
      (String) "DPST-14-16",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Density(
      (long) 159L,
      (int) 17,
      PlcValueType.REAL,
      (String) "density (kg/m³)",
      (String) "DPST-14-17",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electric_Charge(
      (long) 160L,
      (int) 18,
      PlcValueType.REAL,
      (String) "electric charge (C)",
      (String) "DPST-14-18",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electric_Current(
      (long) 161L,
      (int) 19,
      PlcValueType.REAL,
      (String) "electric current (A)",
      (String) "DPST-14-19",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electric_CurrentDensity(
      (long) 162L,
      (int) 20,
      PlcValueType.REAL,
      (String) "electric current density (A/m²)",
      (String) "DPST-14-20",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electric_DipoleMoment(
      (long) 163L,
      (int) 21,
      PlcValueType.REAL,
      (String) "electric dipole moment (Cm)",
      (String) "DPST-14-21",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electric_Displacement(
      (long) 164L,
      (int) 22,
      PlcValueType.REAL,
      (String) "electric displacement (C/m²)",
      (String) "DPST-14-22",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electric_FieldStrength(
      (long) 165L,
      (int) 23,
      PlcValueType.REAL,
      (String) "electric field strength (V/m)",
      (String) "DPST-14-23",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electric_Flux(
      (long) 166L,
      (int) 24,
      PlcValueType.REAL,
      (String) "electric flux (C)",
      (String) "DPST-14-24",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electric_FluxDensity(
      (long) 167L,
      (int) 25,
      PlcValueType.REAL,
      (String) "electric flux density (C/m²)",
      (String) "DPST-14-25",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electric_Polarization(
      (long) 168L,
      (int) 26,
      PlcValueType.REAL,
      (String) "electric polarization (C/m²)",
      (String) "DPST-14-26",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electric_Potential(
      (long) 169L,
      (int) 27,
      PlcValueType.REAL,
      (String) "electric potential (V)",
      (String) "DPST-14-27",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electric_PotentialDifference(
      (long) 170L,
      (int) 28,
      PlcValueType.REAL,
      (String) "electric potential difference (V)",
      (String) "DPST-14-28",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_ElectromagneticMoment(
      (long) 171L,
      (int) 29,
      PlcValueType.REAL,
      (String) "electromagnetic moment (Am²)",
      (String) "DPST-14-29",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Electromotive_Force(
      (long) 172L,
      (int) 30,
      PlcValueType.REAL,
      (String) "electromotive force (V)",
      (String) "DPST-14-30",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Energy(
      (long) 173L,
      (int) 31,
      PlcValueType.REAL,
      (String) "energy (J)",
      (String) "DPST-14-31",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Force(
      (long) 174L,
      (int) 32,
      PlcValueType.REAL,
      (String) "force (N)",
      (String) "DPST-14-32",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Frequency(
      (long) 175L,
      (int) 33,
      PlcValueType.REAL,
      (String) "frequency (Hz)",
      (String) "DPST-14-33",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Angular_Frequency(
      (long) 176L,
      (int) 34,
      PlcValueType.REAL,
      (String) "angular frequency (rad/s)",
      (String) "DPST-14-34",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Heat_Capacity(
      (long) 177L,
      (int) 35,
      PlcValueType.REAL,
      (String) "heat capacity (J/K)",
      (String) "DPST-14-35",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Heat_FlowRate(
      (long) 178L,
      (int) 36,
      PlcValueType.REAL,
      (String) "heat flow rate (W)",
      (String) "DPST-14-36",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Heat_Quantity(
      (long) 179L,
      (int) 37,
      PlcValueType.REAL,
      (String) "heat quantity",
      (String) "DPST-14-37",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Impedance(
      (long) 180L,
      (int) 38,
      PlcValueType.REAL,
      (String) "impedance (Ω)",
      (String) "DPST-14-38",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Length(
      (long) 181L,
      (int) 39,
      PlcValueType.REAL,
      (String) "length (m)",
      (String) "DPST-14-39",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Light_Quantity(
      (long) 182L,
      (int) 40,
      PlcValueType.REAL,
      (String) "light quantity (J)",
      (String) "DPST-14-40",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Luminance(
      (long) 183L,
      (int) 41,
      PlcValueType.REAL,
      (String) "luminance (cd/m²)",
      (String) "DPST-14-41",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Luminous_Flux(
      (long) 184L,
      (int) 42,
      PlcValueType.REAL,
      (String) "luminous flux (lm)",
      (String) "DPST-14-42",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Luminous_Intensity(
      (long) 185L,
      (int) 43,
      PlcValueType.REAL,
      (String) "luminous intensity (cd)",
      (String) "DPST-14-43",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Magnetic_FieldStrength(
      (long) 186L,
      (int) 44,
      PlcValueType.REAL,
      (String) "magnetic field strength (A/m)",
      (String) "DPST-14-44",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Magnetic_Flux(
      (long) 187L,
      (int) 45,
      PlcValueType.REAL,
      (String) "magnetic flux (Wb)",
      (String) "DPST-14-45",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Magnetic_FluxDensity(
      (long) 188L,
      (int) 46,
      PlcValueType.REAL,
      (String) "magnetic flux density (T)",
      (String) "DPST-14-46",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Magnetic_Moment(
      (long) 189L,
      (int) 47,
      PlcValueType.REAL,
      (String) "magnetic moment (Am²)",
      (String) "DPST-14-47",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Magnetic_Polarization(
      (long) 190L,
      (int) 48,
      PlcValueType.REAL,
      (String) "magnetic polarization (T)",
      (String) "DPST-14-48",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Magnetization(
      (long) 191L,
      (int) 49,
      PlcValueType.REAL,
      (String) "magnetization (A/m)",
      (String) "DPST-14-49",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_MagnetomotiveForce(
      (long) 192L,
      (int) 50,
      PlcValueType.REAL,
      (String) "magnetomotive force (A)",
      (String) "DPST-14-50",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Mass(
      (long) 193L,
      (int) 51,
      PlcValueType.REAL,
      (String) "mass (kg)",
      (String) "DPST-14-51",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_MassFlux(
      (long) 194L,
      (int) 52,
      PlcValueType.REAL,
      (String) "mass flux (kg/s)",
      (String) "DPST-14-52",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Momentum(
      (long) 195L,
      (int) 53,
      PlcValueType.REAL,
      (String) "momentum (N/s)",
      (String) "DPST-14-53",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Phase_AngleRad(
      (long) 196L,
      (int) 54,
      PlcValueType.REAL,
      (String) "phase angle (rad)",
      (String) "DPST-14-54",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Phase_AngleDeg(
      (long) 197L,
      (int) 55,
      PlcValueType.REAL,
      (String) "phase angle (°)",
      (String) "DPST-14-55",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Power(
      (long) 198L,
      (int) 56,
      PlcValueType.REAL,
      (String) "power (W)",
      (String) "DPST-14-56",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Power_Factor(
      (long) 199L,
      (int) 57,
      PlcValueType.REAL,
      (String) "power factor (cos Φ)",
      (String) "DPST-14-57",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Pressure(
      (long) 200L,
      (int) 58,
      PlcValueType.REAL,
      (String) "pressure (Pa)",
      (String) "DPST-14-58",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Reactance(
      (long) 201L,
      (int) 59,
      PlcValueType.REAL,
      (String) "reactance (Ω)",
      (String) "DPST-14-59",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Resistance(
      (long) 202L,
      (int) 60,
      PlcValueType.REAL,
      (String) "resistance (Ω)",
      (String) "DPST-14-60",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Resistivity(
      (long) 203L,
      (int) 61,
      PlcValueType.REAL,
      (String) "resistivity (Ωm)",
      (String) "DPST-14-61",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_SelfInductance(
      (long) 204L,
      (int) 62,
      PlcValueType.REAL,
      (String) "self inductance (H)",
      (String) "DPST-14-62",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_SolidAngle(
      (long) 205L,
      (int) 63,
      PlcValueType.REAL,
      (String) "solid angle (sr)",
      (String) "DPST-14-63",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Sound_Intensity(
      (long) 206L,
      (int) 64,
      PlcValueType.REAL,
      (String) "sound intensity (W/m²)",
      (String) "DPST-14-64",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Speed(
      (long) 207L,
      (int) 65,
      PlcValueType.REAL,
      (String) "speed (m/s)",
      (String) "DPST-14-65",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Stress(
      (long) 208L,
      (int) 66,
      PlcValueType.REAL,
      (String) "stress (Pa)",
      (String) "DPST-14-66",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Surface_Tension(
      (long) 209L,
      (int) 67,
      PlcValueType.REAL,
      (String) "surface tension (N/m)",
      (String) "DPST-14-67",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Common_Temperature(
      (long) 210L,
      (int) 68,
      PlcValueType.REAL,
      (String) "temperature (°C)",
      (String) "DPST-14-68",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Absolute_Temperature(
      (long) 211L,
      (int) 69,
      PlcValueType.REAL,
      (String) "temperature absolute (K)",
      (String) "DPST-14-69",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_TemperatureDifference(
      (long) 212L,
      (int) 70,
      PlcValueType.REAL,
      (String) "temperature difference (K)",
      (String) "DPST-14-70",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Thermal_Capacity(
      (long) 213L,
      (int) 71,
      PlcValueType.REAL,
      (String) "thermal capacity (J/K)",
      (String) "DPST-14-71",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Thermal_Conductivity(
      (long) 214L,
      (int) 72,
      PlcValueType.REAL,
      (String) "thermal conductivity (W/mK)",
      (String) "DPST-14-72",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_ThermoelectricPower(
      (long) 215L,
      (int) 73,
      PlcValueType.REAL,
      (String) "thermoelectric power (V/K)",
      (String) "DPST-14-73",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Time(
      (long) 216L,
      (int) 74,
      PlcValueType.REAL,
      (String) "time (s)",
      (String) "DPST-14-74",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Torque(
      (long) 217L,
      (int) 75,
      PlcValueType.REAL,
      (String) "torque (Nm)",
      (String) "DPST-14-75",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Volume(
      (long) 218L,
      (int) 76,
      PlcValueType.REAL,
      (String) "volume (m³)",
      (String) "DPST-14-76",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Volume_Flux(
      (long) 219L,
      (int) 77,
      PlcValueType.REAL,
      (String) "volume flux (m³/s)",
      (String) "DPST-14-77",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Weight(
      (long) 220L,
      (int) 78,
      PlcValueType.REAL,
      (String) "weight (N)",
      (String) "DPST-14-78",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_Work(
      (long) 221L,
      (int) 79,
      PlcValueType.REAL,
      (String) "work (J)",
      (String) "DPST-14-79",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Value_ApparentPower(
      (long) 222L,
      (int) 80,
      PlcValueType.REAL,
      (String) "apparent power (VA)",
      (String) "DPST-14-80",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Volume_Flux_Meter(
      (long) 223L,
      (int) 1200,
      PlcValueType.REAL,
      (String) "volume flux for meters (m³/h)",
      (String) "DPST-14-1200",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Volume_Flux_ls(
      (long) 224L,
      (int) 1201,
      PlcValueType.REAL,
      (String) "volume flux for meters (1/ls)",
      (String) "DPST-14-1201",
      KnxDatapointMainType.DPT_4_BYTE_FLOAT_VALUE),
  DPT_Access_Data(
      (long) 225L,
      (int) 0,
      PlcValueType.Struct,
      (String) "entrance access",
      (String) "DPST-15-0",
      KnxDatapointMainType.DPT_ENTRANCE_ACCESS),
  DPT_String_ASCII(
      (long) 226L,
      (int) 0,
      PlcValueType.STRING,
      (String) "Character String (ASCII)",
      (String) "DPST-16-0",
      KnxDatapointMainType.DPT_CHARACTER_STRING),
  DPT_String_8859_1(
      (long) 227L,
      (int) 1,
      PlcValueType.STRING,
      (String) "Character String (ISO 8859-1)",
      (String) "DPST-16-1",
      KnxDatapointMainType.DPT_CHARACTER_STRING),
  DPT_SceneNumber(
      (long) 228L,
      (int) 1,
      PlcValueType.USINT,
      (String) "scene number",
      (String) "DPST-17-1",
      KnxDatapointMainType.DPT_SCENE_NUMBER),
  DPT_SceneControl(
      (long) 229L,
      (int) 1,
      PlcValueType.Struct,
      (String) "scene control",
      (String) "DPST-18-1",
      KnxDatapointMainType.DPT_SCENE_CONTROL),
  DPT_DateTime(
      (long) 230L,
      (int) 1,
      PlcValueType.Struct,
      (String) "date time",
      (String) "DPST-19-1",
      KnxDatapointMainType.DPT_DATE_TIME),
  DPT_SCLOMode(
      (long) 231L,
      (int) 1,
      PlcValueType.USINT,
      (String) "SCLO mode",
      (String) "DPST-20-1",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_BuildingMode(
      (long) 232L,
      (int) 2,
      PlcValueType.USINT,
      (String) "building mode",
      (String) "DPST-20-2",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_OccMode(
      (long) 233L,
      (int) 3,
      PlcValueType.USINT,
      (String) "occupied",
      (String) "DPST-20-3",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_Priority(
      (long) 234L,
      (int) 4,
      PlcValueType.USINT,
      (String) "priority",
      (String) "DPST-20-4",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_LightApplicationMode(
      (long) 235L,
      (int) 5,
      PlcValueType.USINT,
      (String) "light application mode",
      (String) "DPST-20-5",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_ApplicationArea(
      (long) 236L,
      (int) 6,
      PlcValueType.USINT,
      (String) "light application area",
      (String) "DPST-20-6",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_AlarmClassType(
      (long) 237L,
      (int) 7,
      PlcValueType.USINT,
      (String) "alarm class",
      (String) "DPST-20-7",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_PSUMode(
      (long) 238L,
      (int) 8,
      PlcValueType.USINT,
      (String) "PSU mode",
      (String) "DPST-20-8",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_ErrorClass_System(
      (long) 239L,
      (int) 11,
      PlcValueType.USINT,
      (String) "system error class",
      (String) "DPST-20-11",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_ErrorClass_HVAC(
      (long) 240L,
      (int) 12,
      PlcValueType.USINT,
      (String) "HVAC error class",
      (String) "DPST-20-12",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_Time_Delay(
      (long) 241L,
      (int) 13,
      PlcValueType.USINT,
      (String) "time delay",
      (String) "DPST-20-13",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_Beaufort_Wind_Force_Scale(
      (long) 242L,
      (int) 14,
      PlcValueType.USINT,
      (String) "wind force scale (0..12)",
      (String) "DPST-20-14",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_SensorSelect(
      (long) 243L,
      (int) 17,
      PlcValueType.USINT,
      (String) "sensor mode",
      (String) "DPST-20-17",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_ActuatorConnectType(
      (long) 244L,
      (int) 20,
      PlcValueType.USINT,
      (String) "actuator connect type",
      (String) "DPST-20-20",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_Cloud_Cover(
      (long) 245L,
      (int) 21,
      PlcValueType.USINT,
      (String) "cloud cover",
      (String) "DPST-20-21",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_PowerReturnMode(
      (long) 246L,
      (int) 22,
      PlcValueType.USINT,
      (String) "power return mode",
      (String) "DPST-20-22",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_FuelType(
      (long) 247L,
      (int) 100,
      PlcValueType.USINT,
      (String) "fuel type",
      (String) "DPST-20-100",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_BurnerType(
      (long) 248L,
      (int) 101,
      PlcValueType.USINT,
      (String) "burner type",
      (String) "DPST-20-101",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_HVACMode(
      (long) 249L,
      (int) 102,
      PlcValueType.USINT,
      (String) "HVAC mode",
      (String) "DPST-20-102",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_DHWMode(
      (long) 250L,
      (int) 103,
      PlcValueType.USINT,
      (String) "DHW mode",
      (String) "DPST-20-103",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_LoadPriority(
      (long) 251L,
      (int) 104,
      PlcValueType.USINT,
      (String) "load priority",
      (String) "DPST-20-104",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_HVACContrMode(
      (long) 252L,
      (int) 105,
      PlcValueType.USINT,
      (String) "HVAC control mode",
      (String) "DPST-20-105",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_HVACEmergMode(
      (long) 253L,
      (int) 106,
      PlcValueType.USINT,
      (String) "HVAC emergency mode",
      (String) "DPST-20-106",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_ChangeoverMode(
      (long) 254L,
      (int) 107,
      PlcValueType.USINT,
      (String) "changeover mode",
      (String) "DPST-20-107",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_ValveMode(
      (long) 255L,
      (int) 108,
      PlcValueType.USINT,
      (String) "valve mode",
      (String) "DPST-20-108",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_DamperMode(
      (long) 256L,
      (int) 109,
      PlcValueType.USINT,
      (String) "damper mode",
      (String) "DPST-20-109",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_HeaterMode(
      (long) 257L,
      (int) 110,
      PlcValueType.USINT,
      (String) "heater mode",
      (String) "DPST-20-110",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_FanMode(
      (long) 258L,
      (int) 111,
      PlcValueType.USINT,
      (String) "fan mode",
      (String) "DPST-20-111",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_MasterSlaveMode(
      (long) 259L,
      (int) 112,
      PlcValueType.USINT,
      (String) "master/slave mode",
      (String) "DPST-20-112",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_StatusRoomSetp(
      (long) 260L,
      (int) 113,
      PlcValueType.USINT,
      (String) "status room setpoint",
      (String) "DPST-20-113",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_Metering_DeviceType(
      (long) 261L,
      (int) 114,
      PlcValueType.USINT,
      (String) "metering device type",
      (String) "DPST-20-114",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_HumDehumMode(
      (long) 262L,
      (int) 115,
      PlcValueType.USINT,
      (String) "hum dehum mode",
      (String) "DPST-20-115",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_EnableHCStage(
      (long) 263L,
      (int) 116,
      PlcValueType.USINT,
      (String) "enable H/C stage",
      (String) "DPST-20-116",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_ADAType(
      (long) 264L,
      (int) 120,
      PlcValueType.USINT,
      (String) "ADA type",
      (String) "DPST-20-120",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_BackupMode(
      (long) 265L,
      (int) 121,
      PlcValueType.USINT,
      (String) "backup mode",
      (String) "DPST-20-121",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_StartSynchronization(
      (long) 266L,
      (int) 122,
      PlcValueType.USINT,
      (String) "start syncronization type",
      (String) "DPST-20-122",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_Behaviour_Lock_Unlock(
      (long) 267L,
      (int) 600,
      PlcValueType.USINT,
      (String) "behavior lock/unlock",
      (String) "DPST-20-600",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_Behaviour_Bus_Power_Up_Down(
      (long) 268L,
      (int) 601,
      PlcValueType.USINT,
      (String) "behavior bus power up/down",
      (String) "DPST-20-601",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_DALI_Fade_Time(
      (long) 269L,
      (int) 602,
      PlcValueType.USINT,
      (String) "dali fade time",
      (String) "DPST-20-602",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_BlinkingMode(
      (long) 270L,
      (int) 603,
      PlcValueType.USINT,
      (String) "blink mode",
      (String) "DPST-20-603",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_LightControlMode(
      (long) 271L,
      (int) 604,
      PlcValueType.USINT,
      (String) "light control mode",
      (String) "DPST-20-604",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_SwitchPBModel(
      (long) 272L,
      (int) 605,
      PlcValueType.USINT,
      (String) "PB switch mode",
      (String) "DPST-20-605",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_PBAction(
      (long) 273L,
      (int) 606,
      PlcValueType.USINT,
      (String) "PB action mode",
      (String) "DPST-20-606",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_DimmPBModel(
      (long) 274L,
      (int) 607,
      PlcValueType.USINT,
      (String) "PB dimm mode",
      (String) "DPST-20-607",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_SwitchOnMode(
      (long) 275L,
      (int) 608,
      PlcValueType.USINT,
      (String) "switch on mode",
      (String) "DPST-20-608",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_LoadTypeSet(
      (long) 276L,
      (int) 609,
      PlcValueType.USINT,
      (String) "load type",
      (String) "DPST-20-609",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_LoadTypeDetected(
      (long) 277L,
      (int) 610,
      PlcValueType.USINT,
      (String) "load type detection",
      (String) "DPST-20-610",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_Converter_Test_Control(
      (long) 278L,
      (int) 611,
      PlcValueType.USINT,
      (String) "converter test control",
      (String) "DPST-20-611",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_Converter_Control(
      (long) 279L,
      (int) 612,
      PlcValueType.USINT,
      (String) "converter control",
      (String) "DPST-20-612",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_SABExcept_Behaviour(
      (long) 280L,
      (int) 801,
      PlcValueType.USINT,
      (String) "SAB except behavior",
      (String) "DPST-20-801",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_SABBehaviour_Lock_Unlock(
      (long) 281L,
      (int) 802,
      PlcValueType.USINT,
      (String) "SAB behavior on lock/unlock",
      (String) "DPST-20-802",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_SSSBMode(
      (long) 282L,
      (int) 803,
      PlcValueType.USINT,
      (String) "SSSB mode",
      (String) "DPST-20-803",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_BlindsControlMode(
      (long) 283L,
      (int) 804,
      PlcValueType.USINT,
      (String) "blinds control mode",
      (String) "DPST-20-804",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_CommMode(
      (long) 284L,
      (int) 1000,
      PlcValueType.USINT,
      (String) "communication mode",
      (String) "DPST-20-1000",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_AddInfoTypes(
      (long) 285L,
      (int) 1001,
      PlcValueType.USINT,
      (String) "additional information type",
      (String) "DPST-20-1001",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_RF_ModeSelect(
      (long) 286L,
      (int) 1002,
      PlcValueType.USINT,
      (String) "RF mode selection",
      (String) "DPST-20-1002",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_RF_FilterSelect(
      (long) 287L,
      (int) 1003,
      PlcValueType.USINT,
      (String) "RF filter mode selection",
      (String) "DPST-20-1003",
      KnxDatapointMainType.DPT_1_BYTE),
  DPT_StatusGen(
      (long) 288L,
      (int) 1,
      PlcValueType.Struct,
      (String) "general status",
      (String) "DPST-21-1",
      KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_Device_Control(
      (long) 289L,
      (int) 2,
      PlcValueType.Struct,
      (String) "device control",
      (String) "DPST-21-2",
      KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_ForceSign(
      (long) 290L,
      (int) 100,
      PlcValueType.Struct,
      (String) "forcing signal",
      (String) "DPST-21-100",
      KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_ForceSignCool(
      (long) 291L,
      (int) 101,
      PlcValueType.BOOL,
      (String) "forcing signal cool",
      (String) "DPST-21-101",
      KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_StatusRHC(
      (long) 292L,
      (int) 102,
      PlcValueType.Struct,
      (String) "room heating controller status",
      (String) "DPST-21-102",
      KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_StatusSDHWC(
      (long) 293L,
      (int) 103,
      PlcValueType.Struct,
      (String) "solar DHW controller status",
      (String) "DPST-21-103",
      KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_FuelTypeSet(
      (long) 294L,
      (int) 104,
      PlcValueType.Struct,
      (String) "fuel type set",
      (String) "DPST-21-104",
      KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_StatusRCC(
      (long) 295L,
      (int) 105,
      PlcValueType.BOOL,
      (String) "room cooling controller status",
      (String) "DPST-21-105",
      KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_StatusAHU(
      (long) 296L,
      (int) 106,
      PlcValueType.Struct,
      (String) "ventilation controller status",
      (String) "DPST-21-106",
      KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_CombinedStatus_RTSM(
      (long) 297L,
      (int) 107,
      PlcValueType.Struct,
      (String) "combined status RTSM",
      (String) "DPST-21-107",
      KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_LightActuatorErrorInfo(
      (long) 298L,
      (int) 601,
      PlcValueType.Struct,
      (String) "lighting actuator error information",
      (String) "DPST-21-601",
      KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_RF_ModeInfo(
      (long) 299L,
      (int) 1000,
      PlcValueType.Struct,
      (String) "RF communication mode info",
      (String) "DPST-21-1000",
      KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_RF_FilterInfo(
      (long) 300L,
      (int) 1001,
      PlcValueType.Struct,
      (String) "cEMI server supported RF filtering modes",
      (String) "DPST-21-1001",
      KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_Channel_Activation_8(
      (long) 301L,
      (int) 1010,
      PlcValueType.Struct,
      (String) "channel activation for 8 channels",
      (String) "DPST-21-1010",
      KnxDatapointMainType.DPT_8_BIT_SET),
  DPT_StatusDHWC(
      (long) 302L,
      (int) 100,
      PlcValueType.Struct,
      (String) "DHW controller status",
      (String) "DPST-22-100",
      KnxDatapointMainType.DPT_16_BIT_SET),
  DPT_StatusRHCC(
      (long) 303L,
      (int) 101,
      PlcValueType.Struct,
      (String) "RHCC status",
      (String) "DPST-22-101",
      KnxDatapointMainType.DPT_16_BIT_SET),
  DPT_CombinedStatus_HVA(
      (long) 304L,
      (int) 102,
      PlcValueType.Struct,
      (String) "combined status HVA",
      (String) "DPST-22-102",
      KnxDatapointMainType.DPT_16_BIT_SET),
  DPT_CombinedStatus_RTC(
      (long) 305L,
      (int) 103,
      PlcValueType.Struct,
      (String) "combined status RTC",
      (String) "DPST-22-103",
      KnxDatapointMainType.DPT_16_BIT_SET),
  DPT_Media(
      (long) 306L,
      (int) 1000,
      PlcValueType.Struct,
      (String) "media",
      (String) "DPST-22-1000",
      KnxDatapointMainType.DPT_16_BIT_SET),
  DPT_Channel_Activation_16(
      (long) 307L,
      (int) 1010,
      PlcValueType.Struct,
      (String) "channel activation for 16 channels",
      (String) "DPST-22-1010",
      KnxDatapointMainType.DPT_16_BIT_SET),
  DPT_OnOffAction(
      (long) 308L,
      (int) 1,
      PlcValueType.USINT,
      (String) "on/off action",
      (String) "DPST-23-1",
      KnxDatapointMainType.DPT_2_BIT_SET),
  DPT_Alarm_Reaction(
      (long) 309L,
      (int) 2,
      PlcValueType.USINT,
      (String) "alarm reaction",
      (String) "DPST-23-2",
      KnxDatapointMainType.DPT_2_BIT_SET),
  DPT_UpDown_Action(
      (long) 310L,
      (int) 3,
      PlcValueType.USINT,
      (String) "up/down action",
      (String) "DPST-23-3",
      KnxDatapointMainType.DPT_2_BIT_SET),
  DPT_HVAC_PB_Action(
      (long) 311L,
      (int) 102,
      PlcValueType.USINT,
      (String) "HVAC push button action",
      (String) "DPST-23-102",
      KnxDatapointMainType.DPT_2_BIT_SET),
  DPT_DoubleNibble(
      (long) 312L,
      (int) 1000,
      PlcValueType.Struct,
      (String) "busy/nak repetitions",
      (String) "DPST-25-1000",
      KnxDatapointMainType.DPT_2_NIBBLE_SET),
  DPT_SceneInfo(
      (long) 313L,
      (int) 1,
      PlcValueType.Struct,
      (String) "scene information",
      (String) "DPST-26-1",
      KnxDatapointMainType.DPT_8_BIT_SET_2),
  DPT_CombinedInfoOnOff(
      (long) 314L,
      (int) 1,
      PlcValueType.Struct,
      (String) "bit-combined info on/off",
      (String) "DPST-27-1",
      KnxDatapointMainType.DPT_32_BIT_SET),
  DPT_ActiveEnergy_V64(
      (long) 315L,
      (int) 10,
      PlcValueType.LINT,
      (String) "active energy (Wh)",
      (String) "DPST-29-10",
      KnxDatapointMainType.DPT_ELECTRICAL_ENERGY),
  DPT_ApparentEnergy_V64(
      (long) 316L,
      (int) 11,
      PlcValueType.LINT,
      (String) "apparent energy (VAh)",
      (String) "DPST-29-11",
      KnxDatapointMainType.DPT_ELECTRICAL_ENERGY),
  DPT_ReactiveEnergy_V64(
      (long) 317L,
      (int) 12,
      PlcValueType.LINT,
      (String) "reactive energy (VARh)",
      (String) "DPST-29-12",
      KnxDatapointMainType.DPT_ELECTRICAL_ENERGY),
  DPT_Channel_Activation_24(
      (long) 318L,
      (int) 1010,
      PlcValueType.Struct,
      (String) "activation state 0..23",
      (String) "DPST-30-1010",
      KnxDatapointMainType.DPT_24_TIMES_CHANNEL_ACTIVATION),
  DPT_HVACModeNext(
      (long) 319L,
      (int) 100,
      PlcValueType.Struct,
      (String) "time delay & HVAC mode",
      (String) "DPST-206-100",
      KnxDatapointMainType.DPT_16_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM),
  DPT_DHWModeNext(
      (long) 320L,
      (int) 102,
      PlcValueType.Struct,
      (String) "time delay & DHW mode",
      (String) "DPST-206-102",
      KnxDatapointMainType.DPT_16_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM),
  DPT_OccModeNext(
      (long) 321L,
      (int) 104,
      PlcValueType.Struct,
      (String) "time delay & occupancy mode",
      (String) "DPST-206-104",
      KnxDatapointMainType.DPT_16_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM),
  DPT_BuildingModeNext(
      (long) 322L,
      (int) 105,
      PlcValueType.Struct,
      (String) "time delay & building mode",
      (String) "DPST-206-105",
      KnxDatapointMainType.DPT_16_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM),
  DPT_StatusLightingActuator(
      (long) 323L,
      (int) 600,
      PlcValueType.Struct,
      (String) "Status Lighting Actuator",
      (String) "DPST-207-600",
      KnxDatapointMainType.DPT_8_BIT_UNSIGNED_VALUE_AND_8_BIT_ENUM),
  DPT_Version(
      (long) 324L,
      (int) 1,
      PlcValueType.Struct,
      (String) "DPT version",
      (String) "DPST-217-1",
      KnxDatapointMainType.DPT_DATAPOINT_TYPE_VERSION),
  DPT_AlarmInfo(
      (long) 325L,
      (int) 1,
      PlcValueType.Struct,
      (String) "alarm info",
      (String) "DPST-219-1",
      KnxDatapointMainType.DPT_ALARM_INFO),
  DPT_TempRoomSetpSetF16_3(
      (long) 326L,
      (int) 100,
      PlcValueType.Struct,
      (String) "room temperature setpoint",
      (String) "DPST-222-100",
      KnxDatapointMainType.DPT_3X_2_BYTE_FLOAT_VALUE),
  DPT_TempRoomSetpSetShiftF16_3(
      (long) 327L,
      (int) 101,
      PlcValueType.Struct,
      (String) "room temperature setpoint shift",
      (String) "DPST-222-101",
      KnxDatapointMainType.DPT_3X_2_BYTE_FLOAT_VALUE),
  DPT_Scaling_Speed(
      (long) 328L,
      (int) 1,
      PlcValueType.Struct,
      (String) "scaling speed",
      (String) "DPST-225-1",
      KnxDatapointMainType.DPT_SCALING_SPEED),
  DPT_Scaling_Step_Time(
      (long) 329L,
      (int) 2,
      PlcValueType.Struct,
      (String) "scaling step time",
      (String) "DPST-225-2",
      KnxDatapointMainType.DPT_SCALING_SPEED),
  DPT_MeteringValue(
      (long) 330L,
      (int) 1,
      PlcValueType.Struct,
      (String) "metering value (value,encoding,cmd)",
      (String) "DPST-229-1",
      KnxDatapointMainType.DPT_4_1_1_BYTE_COMBINED_INFORMATION),
  DPT_MBus_Address(
      (long) 331L,
      (int) 1000,
      PlcValueType.Struct,
      (String) "MBus address",
      (String) "DPST-230-1000",
      KnxDatapointMainType.DPT_MBUS_ADDRESS),
  DPT_Colour_RGB(
      (long) 332L,
      (int) 600,
      PlcValueType.Struct,
      (String) "RGB value 3x(0..255)",
      (String) "DPST-232-600",
      KnxDatapointMainType.DPT_3_BYTE_COLOUR_RGB),
  DPT_LanguageCodeAlpha2_ASCII(
      (long) 333L,
      (int) 1,
      PlcValueType.STRING,
      (String) "language code (ASCII)",
      (String) "DPST-234-1",
      KnxDatapointMainType.DPT_LANGUAGE_CODE_ISO_639_1),
  DPT_Tariff_ActiveEnergy(
      (long) 334L,
      (int) 1,
      PlcValueType.Struct,
      (String) "electrical energy with tariff",
      (String) "DPST-235-1",
      KnxDatapointMainType.DPT_SIGNED_VALUE_WITH_CLASSIFICATION_AND_VALIDITY),
  DPT_Prioritised_Mode_Control(
      (long) 335L,
      (int) 1,
      PlcValueType.Struct,
      (String) "priority control",
      (String) "DPST-236-1",
      KnxDatapointMainType.DPT_PRIORITISED_MODE_CONTROL),
  DPT_DALI_Control_Gear_Diagnostic(
      (long) 336L,
      (int) 600,
      PlcValueType.Struct,
      (String) "diagnostic value",
      (String) "DPST-237-600",
      KnxDatapointMainType.DPT_CONFIGURATION_DIAGNOSTICS_16_BIT),
  DPT_DALI_Diagnostics(
      (long) 337L,
      (int) 600,
      PlcValueType.Struct,
      (String) "diagnostic value",
      (String) "DPST-238-600",
      KnxDatapointMainType.DPT_CONFIGURATION_DIAGNOSTICS_8_BIT),
  DPT_CombinedPosition(
      (long) 338L,
      (int) 800,
      PlcValueType.Struct,
      (String) "combined position",
      (String) "DPST-240-800",
      KnxDatapointMainType.DPT_POSITIONS),
  DPT_StatusSAB(
      (long) 339L,
      (int) 800,
      PlcValueType.Struct,
      (String) "status sunblind & shutter actuator",
      (String) "DPST-241-800",
      KnxDatapointMainType.DPT_STATUS_32_BIT),
  DPT_Colour_xyY(
      (long) 340L,
      (int) 600,
      PlcValueType.Struct,
      (String) "colour xyY",
      (String) "DPST-242-600",
      KnxDatapointMainType.DPT_STATUS_48_BIT),
  DPT_Converter_Status(
      (long) 341L,
      (int) 600,
      PlcValueType.Struct,
      (String) "DALI converter status",
      (String) "DPST-244-600",
      KnxDatapointMainType.DPT_CONVERTER_STATUS),
  DPT_Converter_Test_Result(
      (long) 342L,
      (int) 600,
      PlcValueType.Struct,
      (String) "DALI converter test result",
      (String) "DPST-245-600",
      KnxDatapointMainType.DPT_CONVERTER_TEST_RESULT),
  DPT_Battery_Info(
      (long) 343L,
      (int) 600,
      PlcValueType.Struct,
      (String) "Battery Information",
      (String) "DPST-246-600",
      KnxDatapointMainType.DPT_BATTERY_INFORMATION),
  DPT_Brightness_Colour_Temperature_Transition(
      (long) 344L,
      (int) 600,
      PlcValueType.Struct,
      (String) "brightness colour temperature transition",
      (String) "DPST-249-600",
      KnxDatapointMainType.DPT_BRIGHTNESS_COLOUR_TEMPERATURE_TRANSITION),
  DPT_Brightness_Colour_Temperature_Control(
      (long) 345L,
      (int) 600,
      PlcValueType.Struct,
      (String) "brightness colour temperature control",
      (String) "DPST-250-600",
      KnxDatapointMainType.DPT_STATUS_24_BIT),
  DPT_Colour_RGBW(
      (long) 346L,
      (int) 600,
      PlcValueType.Struct,
      (String) "RGBW value 4x(0..100%)",
      (String) "DPST-251-600",
      KnxDatapointMainType.DPT_COLOUR_RGBW),
  DPT_Relative_Control_RGBW(
      (long) 347L,
      (int) 600,
      PlcValueType.Struct,
      (String) "RGBW relative control",
      (String) "DPST-252-600",
      KnxDatapointMainType.DPT_RELATIVE_CONTROL_RGBW),
  DPT_Relative_Control_RGB(
      (long) 348L,
      (int) 600,
      PlcValueType.Struct,
      (String) "RGB relative control",
      (String) "DPST-254-600",
      KnxDatapointMainType.DPT_RELATIVE_CONTROL_RGB),
  DPT_GeographicalLocation(
      (long) 349L,
      (int) 1,
      PlcValueType.Struct,
      (String) "geographical location (longitude and latitude) expressed in degrees",
      (String) "DPST-255-1",
      KnxDatapointMainType.DPT_F32F32),
  DPT_TempRoomSetpSetF16_4(
      (long) 350L,
      (int) 100,
      PlcValueType.Struct,
      (String) "Temperature setpoint setting for 4 HVAC Modes",
      (String) "DPST-275-100",
      KnxDatapointMainType.DPT_F16F16F16F16),
  DPT_TempRoomSetpSetShiftF16_4(
      (long) 351L,
      (int) 101,
      PlcValueType.Struct,
      (String) "Temperature setpoint shift setting for 4 HVAC Modes",
      (String) "DPST-275-101",
      KnxDatapointMainType.DPT_F16F16F16F16);
  private static final Map<Long, KnxDatapointType> map;

  static {
    map = new HashMap<>();
    for (KnxDatapointType value : KnxDatapointType.values()) {
      map.put((long) value.getValue(), value);
    }
  }

  private final long value;
  private final int number;
  private final PlcValueType plcValueTpe;
  private final String name;
  private final String id;
  private final KnxDatapointMainType datapointMainType;

  KnxDatapointType(
      long value,
      int number,
      PlcValueType plcValueTpe,
      String name,
      String id,
      KnxDatapointMainType datapointMainType) {
    this.value = value;
    this.number = number;
    this.plcValueTpe = plcValueTpe;
    this.name = name;
    this.id = id;
    this.datapointMainType = datapointMainType;
  }

  public long getValue() {
    return value;
  }

  public int getNumber() {
    return number;
  }

  public static KnxDatapointType firstEnumForFieldNumber(int fieldValue) {
    for (KnxDatapointType _val : KnxDatapointType.values()) {
      if (_val.getNumber() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<KnxDatapointType> enumsForFieldNumber(int fieldValue) {
    List<KnxDatapointType> _values = new ArrayList<>();
    for (KnxDatapointType _val : KnxDatapointType.values()) {
      if (_val.getNumber() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public PlcValueType getPlcValueTpe() {
    return plcValueTpe;
  }

  public static KnxDatapointType firstEnumForFieldPlcValueTpe(PlcValueType fieldValue) {
    for (KnxDatapointType _val : KnxDatapointType.values()) {
      if (_val.getPlcValueTpe() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<KnxDatapointType> enumsForFieldPlcValueTpe(PlcValueType fieldValue) {
    List<KnxDatapointType> _values = new ArrayList<>();
    for (KnxDatapointType _val : KnxDatapointType.values()) {
      if (_val.getPlcValueTpe() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public String getName() {
    return name;
  }

  public static KnxDatapointType firstEnumForFieldName(String fieldValue) {
    for (KnxDatapointType _val : KnxDatapointType.values()) {
      if (_val.getName().equals(fieldValue)) {
        return _val;
      }
    }
    return null;
  }

  public static List<KnxDatapointType> enumsForFieldName(String fieldValue) {
    List<KnxDatapointType> _values = new ArrayList<>();
    for (KnxDatapointType _val : KnxDatapointType.values()) {
      if (_val.getName().equals(fieldValue)) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public String getId() {
    return id;
  }

  public static KnxDatapointType firstEnumForFieldId(String fieldValue) {
    for (KnxDatapointType _val : KnxDatapointType.values()) {
      if (_val.getId().equals(fieldValue)) {
        return _val;
      }
    }
    return null;
  }

  public static List<KnxDatapointType> enumsForFieldId(String fieldValue) {
    List<KnxDatapointType> _values = new ArrayList<>();
    for (KnxDatapointType _val : KnxDatapointType.values()) {
      if (_val.getId().equals(fieldValue)) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public KnxDatapointMainType getDatapointMainType() {
    return datapointMainType;
  }

  public static KnxDatapointType firstEnumForFieldDatapointMainType(
      KnxDatapointMainType fieldValue) {
    for (KnxDatapointType _val : KnxDatapointType.values()) {
      if (_val.getDatapointMainType() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<KnxDatapointType> enumsForFieldDatapointMainType(
      KnxDatapointMainType fieldValue) {
    List<KnxDatapointType> _values = new ArrayList<>();
    for (KnxDatapointType _val : KnxDatapointType.values()) {
      if (_val.getDatapointMainType() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static KnxDatapointType enumForValue(long value) {
    return map.get(value);
  }

  public static Boolean isDefined(long value) {
    return map.containsKey(value);
  }
}
