/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class TriggerControlData implements Message {

  // Abstract accessors for discriminator values.

  // Properties.
  protected final TriggerControlCommandTypeContainer commandTypeContainer;
  protected final byte triggerGroup;

  public TriggerControlData(
      TriggerControlCommandTypeContainer commandTypeContainer, byte triggerGroup) {
    super();
    this.commandTypeContainer = commandTypeContainer;
    this.triggerGroup = triggerGroup;
  }

  public TriggerControlCommandTypeContainer getCommandTypeContainer() {
    return commandTypeContainer;
  }

  public byte getTriggerGroup() {
    return triggerGroup;
  }

  public TriggerControlCommandType getCommandType() {
    return (TriggerControlCommandType) (getCommandTypeContainer().getCommandType());
  }

  public boolean getIsUnused() {
    return (boolean) ((getTriggerGroup()) > (0xFE));
  }

  protected abstract void serializeTriggerControlDataChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("TriggerControlData");

    // Simple Field (commandTypeContainer)
    writeSimpleEnumField(
        "commandTypeContainer",
        "TriggerControlCommandTypeContainer",
        commandTypeContainer,
        writeEnum(
            TriggerControlCommandTypeContainer::getValue,
            TriggerControlCommandTypeContainer::name,
            writeUnsignedShort(writeBuffer, 8)));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    TriggerControlCommandType commandType = getCommandType();
    writeBuffer.writeVirtual("commandType", commandType);

    // Simple Field (triggerGroup)
    writeSimpleField("triggerGroup", triggerGroup, writeByte(writeBuffer, 8));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isUnused = getIsUnused();
    writeBuffer.writeVirtual("isUnused", isUnused);

    // Switch field (Serialize the sub-type)
    serializeTriggerControlDataChild(writeBuffer);

    writeBuffer.popContext("TriggerControlData");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    TriggerControlData _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (commandTypeContainer)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    // Simple field (triggerGroup)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static TriggerControlData staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("TriggerControlData");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    // Validation
    if (!(org.apache.plc4x.java.cbus.readwrite.utils.StaticHelper
        .knowsTriggerControlCommandTypeContainer(readBuffer))) {
      throw new ParseAssertException("no command type could be found");
    }

    TriggerControlCommandTypeContainer commandTypeContainer =
        readEnumField(
            "commandTypeContainer",
            "TriggerControlCommandTypeContainer",
            readEnum(
                TriggerControlCommandTypeContainer::enumForValue,
                readUnsignedShort(readBuffer, 8)));
    TriggerControlCommandType commandType =
        readVirtualField(
            "commandType", TriggerControlCommandType.class, commandTypeContainer.getCommandType());

    byte triggerGroup = readSimpleField("triggerGroup", readByte(readBuffer, 8));
    boolean isUnused = readVirtualField("isUnused", boolean.class, (triggerGroup) > (0xFE));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    TriggerControlDataBuilder builder = null;
    if (EvaluationHelper.equals(commandType, TriggerControlCommandType.TRIGGER_EVENT)) {
      builder = TriggerControlDataTriggerEvent.staticParseTriggerControlDataBuilder(readBuffer);
    } else if (EvaluationHelper.equals(commandType, TriggerControlCommandType.TRIGGER_MIN)) {
      builder = TriggerControlDataTriggerMin.staticParseTriggerControlDataBuilder(readBuffer);
    } else if (EvaluationHelper.equals(commandType, TriggerControlCommandType.TRIGGER_MAX)) {
      builder = TriggerControlDataTriggerMax.staticParseTriggerControlDataBuilder(readBuffer);
    } else if (EvaluationHelper.equals(commandType, TriggerControlCommandType.INDICATOR_KILL)) {
      builder = TriggerControlDataIndicatorKill.staticParseTriggerControlDataBuilder(readBuffer);
    } else if (EvaluationHelper.equals(commandType, TriggerControlCommandType.LABEL)) {
      builder =
          TriggerControlDataLabel.staticParseTriggerControlDataBuilder(
              readBuffer, commandTypeContainer);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "commandType="
              + commandType
              + "]");
    }

    readBuffer.closeContext("TriggerControlData");
    // Create the instance
    TriggerControlData _triggerControlData = builder.build(commandTypeContainer, triggerGroup);
    return _triggerControlData;
  }

  public interface TriggerControlDataBuilder {
    TriggerControlData build(
        TriggerControlCommandTypeContainer commandTypeContainer, byte triggerGroup);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof TriggerControlData)) {
      return false;
    }
    TriggerControlData that = (TriggerControlData) o;
    return (getCommandTypeContainer() == that.getCommandTypeContainer())
        && (getTriggerGroup() == that.getTriggerGroup())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getCommandTypeContainer(), getTriggerGroup());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
