/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class RequestReset extends Request implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final RequestType tildePeek;
  protected final RequestType secondTilde;
  protected final RequestType tildePeek2;
  protected final RequestType thirdTilde;

  // Arguments.
  protected final CBusOptions cBusOptions;

  public RequestReset(
      RequestType peekedByte,
      RequestType startingCR,
      RequestType resetMode,
      RequestType secondPeek,
      RequestTermination termination,
      RequestType tildePeek,
      RequestType secondTilde,
      RequestType tildePeek2,
      RequestType thirdTilde,
      CBusOptions cBusOptions) {
    super(peekedByte, startingCR, resetMode, secondPeek, termination, cBusOptions);
    this.tildePeek = tildePeek;
    this.secondTilde = secondTilde;
    this.tildePeek2 = tildePeek2;
    this.thirdTilde = thirdTilde;
    this.cBusOptions = cBusOptions;
  }

  public RequestType getTildePeek() {
    return tildePeek;
  }

  public RequestType getSecondTilde() {
    return secondTilde;
  }

  public RequestType getTildePeek2() {
    return tildePeek2;
  }

  public RequestType getThirdTilde() {
    return thirdTilde;
  }

  @Override
  protected void serializeRequestChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("RequestReset");

    // Optional Field (secondTilde) (Can be skipped, if the value is null)
    writeOptionalEnumField(
        "secondTilde",
        "RequestType",
        secondTilde,
        writeEnum(RequestType::getValue, RequestType::name, writeUnsignedShort(writeBuffer, 8)),
        (getTildePeek()) == (RequestType.RESET));

    // Optional Field (thirdTilde) (Can be skipped, if the value is null)
    writeOptionalEnumField(
        "thirdTilde",
        "RequestType",
        thirdTilde,
        writeEnum(RequestType::getValue, RequestType::name, writeUnsignedShort(writeBuffer, 8)),
        (getTildePeek2()) == (RequestType.RESET));

    writeBuffer.popContext("RequestReset");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    RequestReset _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Optional Field (secondTilde)
    if (secondTilde != null) {
      lengthInBits += 8;
    }

    // Optional Field (thirdTilde)
    if (thirdTilde != null) {
      lengthInBits += 8;
    }

    return lengthInBits;
  }

  public static RequestBuilder staticParseRequestBuilder(
      ReadBuffer readBuffer, CBusOptions cBusOptions) throws ParseException {
    readBuffer.pullContext("RequestReset");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    RequestType tildePeek =
        readPeekField(
            "tildePeek", readEnum(RequestType::enumForValue, readUnsignedShort(readBuffer, 8)));

    RequestType secondTilde =
        readOptionalField(
            "secondTilde",
            readEnum(RequestType::enumForValue, readUnsignedShort(readBuffer, 8)),
            (tildePeek) == (RequestType.RESET));

    RequestType tildePeek2 =
        readPeekField(
            "tildePeek2", readEnum(RequestType::enumForValue, readUnsignedShort(readBuffer, 8)));

    RequestType thirdTilde =
        readOptionalField(
            "thirdTilde",
            readEnum(RequestType::enumForValue, readUnsignedShort(readBuffer, 8)),
            (tildePeek2) == (RequestType.RESET));

    readBuffer.closeContext("RequestReset");
    // Create the instance
    return new RequestResetBuilderImpl(tildePeek, secondTilde, tildePeek2, thirdTilde, cBusOptions);
  }

  public static class RequestResetBuilderImpl implements Request.RequestBuilder {
    private final RequestType tildePeek;
    private final RequestType secondTilde;
    private final RequestType tildePeek2;
    private final RequestType thirdTilde;
    private final CBusOptions cBusOptions;

    public RequestResetBuilderImpl(
        RequestType tildePeek,
        RequestType secondTilde,
        RequestType tildePeek2,
        RequestType thirdTilde,
        CBusOptions cBusOptions) {
      this.tildePeek = tildePeek;
      this.secondTilde = secondTilde;
      this.tildePeek2 = tildePeek2;
      this.thirdTilde = thirdTilde;
      this.cBusOptions = cBusOptions;
    }

    public RequestReset build(
        RequestType peekedByte,
        RequestType startingCR,
        RequestType resetMode,
        RequestType secondPeek,
        RequestTermination termination,
        CBusOptions cBusOptions) {
      RequestReset requestReset =
          new RequestReset(
              peekedByte,
              startingCR,
              resetMode,
              secondPeek,
              termination,
              tildePeek,
              secondTilde,
              tildePeek2,
              thirdTilde,
              cBusOptions);
      return requestReset;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof RequestReset)) {
      return false;
    }
    RequestReset that = (RequestReset) o;
    return (getTildePeek() == that.getTildePeek())
        && (getSecondTilde() == that.getSecondTilde())
        && (getTildePeek2() == that.getTildePeek2())
        && (getThirdTilde() == that.getThirdTilde())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getTildePeek(), getSecondTilde(), getTildePeek2(), getThirdTilde());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
