/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class Confirmation implements Message {

  // Properties.
  protected final Alpha alpha;
  protected final Alpha secondAlpha;
  protected final ConfirmationType confirmationType;

  public Confirmation(Alpha alpha, Alpha secondAlpha, ConfirmationType confirmationType) {
    super();
    this.alpha = alpha;
    this.secondAlpha = secondAlpha;
    this.confirmationType = confirmationType;
  }

  public Alpha getAlpha() {
    return alpha;
  }

  public Alpha getSecondAlpha() {
    return secondAlpha;
  }

  public ConfirmationType getConfirmationType() {
    return confirmationType;
  }

  public boolean getIsSuccess() {
    return (boolean) ((getConfirmationType()) == (ConfirmationType.CONFIRMATION_SUCCESSFUL));
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("Confirmation");

    // Simple Field (alpha)
    writeSimpleField("alpha", alpha, writeComplex(writeBuffer));

    // Optional Field (secondAlpha) (Can be skipped, if the value is null)
    writeOptionalField("secondAlpha", secondAlpha, writeComplex(writeBuffer));

    // Simple Field (confirmationType)
    writeSimpleEnumField(
        "confirmationType",
        "ConfirmationType",
        confirmationType,
        writeEnum(ConfirmationType::getValue, ConfirmationType::name, writeByte(writeBuffer, 8)));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isSuccess = getIsSuccess();
    writeBuffer.writeVirtual("isSuccess", isSuccess);

    writeBuffer.popContext("Confirmation");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    Confirmation _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (alpha)
    lengthInBits += alpha.getLengthInBits();

    // Optional Field (secondAlpha)
    if (secondAlpha != null) {
      lengthInBits += secondAlpha.getLengthInBits();
    }

    // Simple field (confirmationType)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    return lengthInBits;
  }

  public static Confirmation staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("Confirmation");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    Alpha alpha =
        readSimpleField("alpha", readComplex(() -> Alpha.staticParse(readBuffer), readBuffer));

    Alpha secondAlpha =
        readOptionalField(
            "secondAlpha", readComplex(() -> Alpha.staticParse(readBuffer), readBuffer));

    ConfirmationType confirmationType =
        readEnumField(
            "confirmationType",
            "ConfirmationType",
            readEnum(ConfirmationType::enumForValue, readByte(readBuffer, 8)));
    boolean isSuccess =
        readVirtualField(
            "isSuccess",
            boolean.class,
            (confirmationType) == (ConfirmationType.CONFIRMATION_SUCCESSFUL));

    readBuffer.closeContext("Confirmation");
    // Create the instance
    Confirmation _confirmation;
    _confirmation = new Confirmation(alpha, secondAlpha, confirmationType);
    return _confirmation;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof Confirmation)) {
      return false;
    }
    Confirmation that = (Confirmation) o;
    return (getAlpha() == that.getAlpha())
        && (getSecondAlpha() == that.getSecondAlpha())
        && (getConfirmationType() == that.getConfirmationType())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getAlpha(), getSecondAlpha(), getConfirmationType());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
