/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class AccessControlData implements Message {

  // Abstract accessors for discriminator values.

  // Properties.
  protected final AccessControlCommandTypeContainer commandTypeContainer;
  protected final byte networkId;
  protected final byte accessPointId;

  public AccessControlData(
      AccessControlCommandTypeContainer commandTypeContainer, byte networkId, byte accessPointId) {
    super();
    this.commandTypeContainer = commandTypeContainer;
    this.networkId = networkId;
    this.accessPointId = accessPointId;
  }

  public AccessControlCommandTypeContainer getCommandTypeContainer() {
    return commandTypeContainer;
  }

  public byte getNetworkId() {
    return networkId;
  }

  public byte getAccessPointId() {
    return accessPointId;
  }

  public AccessControlCommandType getCommandType() {
    return (AccessControlCommandType) (getCommandTypeContainer().getCommandType());
  }

  protected abstract void serializeAccessControlDataChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("AccessControlData");

    // Simple Field (commandTypeContainer)
    writeSimpleEnumField(
        "commandTypeContainer",
        "AccessControlCommandTypeContainer",
        commandTypeContainer,
        writeEnum(
            AccessControlCommandTypeContainer::getValue,
            AccessControlCommandTypeContainer::name,
            writeUnsignedShort(writeBuffer, 8)));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    AccessControlCommandType commandType = getCommandType();
    writeBuffer.writeVirtual("commandType", commandType);

    // Simple Field (networkId)
    writeSimpleField("networkId", networkId, writeByte(writeBuffer, 8));

    // Simple Field (accessPointId)
    writeSimpleField("accessPointId", accessPointId, writeByte(writeBuffer, 8));

    // Switch field (Serialize the sub-type)
    serializeAccessControlDataChild(writeBuffer);

    writeBuffer.popContext("AccessControlData");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    AccessControlData _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (commandTypeContainer)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    // Simple field (networkId)
    lengthInBits += 8;

    // Simple field (accessPointId)
    lengthInBits += 8;

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static AccessControlData staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("AccessControlData");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    // Validation
    if (!(org.apache.plc4x.java.cbus.readwrite.utils.StaticHelper
        .knowsAccessControlCommandTypeContainer(readBuffer))) {
      throw new ParseAssertException("no command type could be found");
    }

    AccessControlCommandTypeContainer commandTypeContainer =
        readEnumField(
            "commandTypeContainer",
            "AccessControlCommandTypeContainer",
            readEnum(
                AccessControlCommandTypeContainer::enumForValue, readUnsignedShort(readBuffer, 8)));
    AccessControlCommandType commandType =
        readVirtualField(
            "commandType", AccessControlCommandType.class, commandTypeContainer.getCommandType());

    byte networkId = readSimpleField("networkId", readByte(readBuffer, 8));

    byte accessPointId = readSimpleField("accessPointId", readByte(readBuffer, 8));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    AccessControlDataBuilder builder = null;
    if (EvaluationHelper.equals(commandType, AccessControlCommandType.VALID_ACCESS)) {
      builder =
          AccessControlDataValidAccessRequest.staticParseAccessControlDataBuilder(
              readBuffer, commandTypeContainer);
    } else if (EvaluationHelper.equals(commandType, AccessControlCommandType.INVALID_ACCESS)) {
      builder =
          AccessControlDataInvalidAccessRequest.staticParseAccessControlDataBuilder(
              readBuffer, commandTypeContainer);
    } else if (EvaluationHelper.equals(
        commandType, AccessControlCommandType.ACCESS_POINT_LEFT_OPEN)) {
      builder =
          AccessControlDataAccessPointLeftOpen.staticParseAccessControlDataBuilder(readBuffer);
    } else if (EvaluationHelper.equals(
        commandType, AccessControlCommandType.ACCESS_POINT_FORCED_OPEN)) {
      builder =
          AccessControlDataAccessPointForcedOpen.staticParseAccessControlDataBuilder(readBuffer);
    } else if (EvaluationHelper.equals(commandType, AccessControlCommandType.ACCESS_POINT_CLOSED)) {
      builder = AccessControlDataAccessPointClosed.staticParseAccessControlDataBuilder(readBuffer);
    } else if (EvaluationHelper.equals(commandType, AccessControlCommandType.REQUEST_TO_EXIT)) {
      builder = AccessControlDataRequestToExit.staticParseAccessControlDataBuilder(readBuffer);
    } else if (EvaluationHelper.equals(commandType, AccessControlCommandType.CLOSE_ACCESS_POINT)) {
      builder = AccessControlDataCloseAccessPoint.staticParseAccessControlDataBuilder(readBuffer);
    } else if (EvaluationHelper.equals(commandType, AccessControlCommandType.LOCK_ACCESS_POINT)) {
      builder = AccessControlDataLockAccessPoint.staticParseAccessControlDataBuilder(readBuffer);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "commandType="
              + commandType
              + "]");
    }

    readBuffer.closeContext("AccessControlData");
    // Create the instance
    AccessControlData _accessControlData =
        builder.build(commandTypeContainer, networkId, accessPointId);
    return _accessControlData;
  }

  public interface AccessControlDataBuilder {
    AccessControlData build(
        AccessControlCommandTypeContainer commandTypeContainer, byte networkId, byte accessPointId);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AccessControlData)) {
      return false;
    }
    AccessControlData that = (AccessControlData) o;
    return (getCommandTypeContainer() == that.getCommandTypeContainer())
        && (getNetworkId() == that.getNetworkId())
        && (getAccessPointId() == that.getAccessPointId())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getCommandTypeContainer(), getNetworkId(), getAccessPointId());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
