/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.abeth.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class DF1RequestProtectedTypedLogicalRead extends DF1RequestCommand implements Message {

  // Accessors for discriminator values.
  public Short getFunctionCode() {
    return (short) 0xA2;
  }

  // Properties.
  protected final short byteSize;
  protected final short fileNumber;
  protected final short fileType;
  protected final short elementNumber;
  protected final short subElementNumber;

  public DF1RequestProtectedTypedLogicalRead(
      short byteSize,
      short fileNumber,
      short fileType,
      short elementNumber,
      short subElementNumber) {
    super();
    this.byteSize = byteSize;
    this.fileNumber = fileNumber;
    this.fileType = fileType;
    this.elementNumber = elementNumber;
    this.subElementNumber = subElementNumber;
  }

  public short getByteSize() {
    return byteSize;
  }

  public short getFileNumber() {
    return fileNumber;
  }

  public short getFileType() {
    return fileType;
  }

  public short getElementNumber() {
    return elementNumber;
  }

  public short getSubElementNumber() {
    return subElementNumber;
  }

  @Override
  protected void serializeDF1RequestCommandChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("DF1RequestProtectedTypedLogicalRead");

    // Simple Field (byteSize)
    writeSimpleField("byteSize", byteSize, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (fileNumber)
    writeSimpleField("fileNumber", fileNumber, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (fileType)
    writeSimpleField("fileType", fileType, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (elementNumber)
    writeSimpleField("elementNumber", elementNumber, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (subElementNumber)
    writeSimpleField("subElementNumber", subElementNumber, writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("DF1RequestProtectedTypedLogicalRead");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    DF1RequestProtectedTypedLogicalRead _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (byteSize)
    lengthInBits += 8;

    // Simple field (fileNumber)
    lengthInBits += 8;

    // Simple field (fileType)
    lengthInBits += 8;

    // Simple field (elementNumber)
    lengthInBits += 8;

    // Simple field (subElementNumber)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static DF1RequestCommandBuilder staticParseDF1RequestCommandBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("DF1RequestProtectedTypedLogicalRead");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short byteSize = readSimpleField("byteSize", readUnsignedShort(readBuffer, 8));

    short fileNumber = readSimpleField("fileNumber", readUnsignedShort(readBuffer, 8));

    short fileType = readSimpleField("fileType", readUnsignedShort(readBuffer, 8));

    short elementNumber = readSimpleField("elementNumber", readUnsignedShort(readBuffer, 8));

    short subElementNumber = readSimpleField("subElementNumber", readUnsignedShort(readBuffer, 8));

    readBuffer.closeContext("DF1RequestProtectedTypedLogicalRead");
    // Create the instance
    return new DF1RequestProtectedTypedLogicalReadBuilderImpl(
        byteSize, fileNumber, fileType, elementNumber, subElementNumber);
  }

  public static class DF1RequestProtectedTypedLogicalReadBuilderImpl
      implements DF1RequestCommand.DF1RequestCommandBuilder {
    private final short byteSize;
    private final short fileNumber;
    private final short fileType;
    private final short elementNumber;
    private final short subElementNumber;

    public DF1RequestProtectedTypedLogicalReadBuilderImpl(
        short byteSize,
        short fileNumber,
        short fileType,
        short elementNumber,
        short subElementNumber) {
      this.byteSize = byteSize;
      this.fileNumber = fileNumber;
      this.fileType = fileType;
      this.elementNumber = elementNumber;
      this.subElementNumber = subElementNumber;
    }

    public DF1RequestProtectedTypedLogicalRead build() {
      DF1RequestProtectedTypedLogicalRead dF1RequestProtectedTypedLogicalRead =
          new DF1RequestProtectedTypedLogicalRead(
              byteSize, fileNumber, fileType, elementNumber, subElementNumber);
      return dF1RequestProtectedTypedLogicalRead;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof DF1RequestProtectedTypedLogicalRead)) {
      return false;
    }
    DF1RequestProtectedTypedLogicalRead that = (DF1RequestProtectedTypedLogicalRead) o;
    return (getByteSize() == that.getByteSize())
        && (getFileNumber() == that.getFileNumber())
        && (getFileType() == that.getFileType())
        && (getElementNumber() == that.getElementNumber())
        && (getSubElementNumber() == that.getSubElementNumber())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getByteSize(),
        getFileNumber(),
        getFileType(),
        getElementNumber(),
        getSubElementNumber());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
