/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// InterfaceOperStatus is an enum
type InterfaceOperStatus uint32

type IInterfaceOperStatus interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	InterfaceOperStatus_interfaceOperStatusUp             InterfaceOperStatus = 0
	InterfaceOperStatus_interfaceOperStatusDown           InterfaceOperStatus = 1
	InterfaceOperStatus_interfaceOperStatusTesting        InterfaceOperStatus = 2
	InterfaceOperStatus_interfaceOperStatusUnknown        InterfaceOperStatus = 3
	InterfaceOperStatus_interfaceOperStatusDormant        InterfaceOperStatus = 4
	InterfaceOperStatus_interfaceOperStatusNotPresent     InterfaceOperStatus = 5
	InterfaceOperStatus_interfaceOperStatusLowerLayerDown InterfaceOperStatus = 6
)

var InterfaceOperStatusValues []InterfaceOperStatus

func init() {
	_ = errors.New
	InterfaceOperStatusValues = []InterfaceOperStatus{
		InterfaceOperStatus_interfaceOperStatusUp,
		InterfaceOperStatus_interfaceOperStatusDown,
		InterfaceOperStatus_interfaceOperStatusTesting,
		InterfaceOperStatus_interfaceOperStatusUnknown,
		InterfaceOperStatus_interfaceOperStatusDormant,
		InterfaceOperStatus_interfaceOperStatusNotPresent,
		InterfaceOperStatus_interfaceOperStatusLowerLayerDown,
	}
}

func InterfaceOperStatusByValue(value uint32) (enum InterfaceOperStatus, ok bool) {
	switch value {
	case 0:
		return InterfaceOperStatus_interfaceOperStatusUp, true
	case 1:
		return InterfaceOperStatus_interfaceOperStatusDown, true
	case 2:
		return InterfaceOperStatus_interfaceOperStatusTesting, true
	case 3:
		return InterfaceOperStatus_interfaceOperStatusUnknown, true
	case 4:
		return InterfaceOperStatus_interfaceOperStatusDormant, true
	case 5:
		return InterfaceOperStatus_interfaceOperStatusNotPresent, true
	case 6:
		return InterfaceOperStatus_interfaceOperStatusLowerLayerDown, true
	}
	return 0, false
}

func InterfaceOperStatusByName(value string) (enum InterfaceOperStatus, ok bool) {
	switch value {
	case "interfaceOperStatusUp":
		return InterfaceOperStatus_interfaceOperStatusUp, true
	case "interfaceOperStatusDown":
		return InterfaceOperStatus_interfaceOperStatusDown, true
	case "interfaceOperStatusTesting":
		return InterfaceOperStatus_interfaceOperStatusTesting, true
	case "interfaceOperStatusUnknown":
		return InterfaceOperStatus_interfaceOperStatusUnknown, true
	case "interfaceOperStatusDormant":
		return InterfaceOperStatus_interfaceOperStatusDormant, true
	case "interfaceOperStatusNotPresent":
		return InterfaceOperStatus_interfaceOperStatusNotPresent, true
	case "interfaceOperStatusLowerLayerDown":
		return InterfaceOperStatus_interfaceOperStatusLowerLayerDown, true
	}
	return 0, false
}

func InterfaceOperStatusKnows(value uint32) bool {
	for _, typeValue := range InterfaceOperStatusValues {
		if uint32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastInterfaceOperStatus(structType any) InterfaceOperStatus {
	castFunc := func(typ any) InterfaceOperStatus {
		if sInterfaceOperStatus, ok := typ.(InterfaceOperStatus); ok {
			return sInterfaceOperStatus
		}
		return 0
	}
	return castFunc(structType)
}

func (m InterfaceOperStatus) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m InterfaceOperStatus) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func InterfaceOperStatusParse(ctx context.Context, theBytes []byte) (InterfaceOperStatus, error) {
	return InterfaceOperStatusParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func InterfaceOperStatusParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (InterfaceOperStatus, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("InterfaceOperStatus", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading InterfaceOperStatus")
	}
	if enum, ok := InterfaceOperStatusByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for InterfaceOperStatus")
		return InterfaceOperStatus(val), nil
	} else {
		return enum, nil
	}
}

func (e InterfaceOperStatus) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e InterfaceOperStatus) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteUint32("InterfaceOperStatus", 32, uint32(uint32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e InterfaceOperStatus) GetValue() uint32 {
	return uint32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e InterfaceOperStatus) PLC4XEnumName() string {
	switch e {
	case InterfaceOperStatus_interfaceOperStatusUp:
		return "interfaceOperStatusUp"
	case InterfaceOperStatus_interfaceOperStatusDown:
		return "interfaceOperStatusDown"
	case InterfaceOperStatus_interfaceOperStatusTesting:
		return "interfaceOperStatusTesting"
	case InterfaceOperStatus_interfaceOperStatusUnknown:
		return "interfaceOperStatusUnknown"
	case InterfaceOperStatus_interfaceOperStatusDormant:
		return "interfaceOperStatusDormant"
	case InterfaceOperStatus_interfaceOperStatusNotPresent:
		return "interfaceOperStatusNotPresent"
	case InterfaceOperStatus_interfaceOperStatusLowerLayerDown:
		return "interfaceOperStatusLowerLayerDown"
	}
	return fmt.Sprintf("Unknown(%v)", uint32(e))
}

func (e InterfaceOperStatus) String() string {
	return e.PLC4XEnumName()
}
