/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ParameterValueInterfaceOptions1 is the corresponding interface of ParameterValueInterfaceOptions1
type ParameterValueInterfaceOptions1 interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ParameterValue
	// GetValue returns Value (property field)
	GetValue() InterfaceOptions1
	// GetData returns Data (property field)
	GetData() []byte
	// IsParameterValueInterfaceOptions1 is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsParameterValueInterfaceOptions1()
	// CreateBuilder creates a ParameterValueInterfaceOptions1Builder
	CreateParameterValueInterfaceOptions1Builder() ParameterValueInterfaceOptions1Builder
}

// _ParameterValueInterfaceOptions1 is the data-structure of this message
type _ParameterValueInterfaceOptions1 struct {
	ParameterValueContract
	Value InterfaceOptions1
	Data  []byte
}

var _ ParameterValueInterfaceOptions1 = (*_ParameterValueInterfaceOptions1)(nil)
var _ ParameterValueRequirements = (*_ParameterValueInterfaceOptions1)(nil)

// NewParameterValueInterfaceOptions1 factory function for _ParameterValueInterfaceOptions1
func NewParameterValueInterfaceOptions1(value InterfaceOptions1, data []byte, numBytes uint8) *_ParameterValueInterfaceOptions1 {
	if value == nil {
		panic("value of type InterfaceOptions1 for ParameterValueInterfaceOptions1 must not be nil")
	}
	_result := &_ParameterValueInterfaceOptions1{
		ParameterValueContract: NewParameterValue(numBytes),
		Value:                  value,
		Data:                   data,
	}
	_result.ParameterValueContract.(*_ParameterValue)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ParameterValueInterfaceOptions1Builder is a builder for ParameterValueInterfaceOptions1
type ParameterValueInterfaceOptions1Builder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(value InterfaceOptions1, data []byte) ParameterValueInterfaceOptions1Builder
	// WithValue adds Value (property field)
	WithValue(InterfaceOptions1) ParameterValueInterfaceOptions1Builder
	// WithValueBuilder adds Value (property field) which is build by the builder
	WithValueBuilder(func(InterfaceOptions1Builder) InterfaceOptions1Builder) ParameterValueInterfaceOptions1Builder
	// WithData adds Data (property field)
	WithData(...byte) ParameterValueInterfaceOptions1Builder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ParameterValueBuilder
	// Build builds the ParameterValueInterfaceOptions1 or returns an error if something is wrong
	Build() (ParameterValueInterfaceOptions1, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ParameterValueInterfaceOptions1
}

// NewParameterValueInterfaceOptions1Builder() creates a ParameterValueInterfaceOptions1Builder
func NewParameterValueInterfaceOptions1Builder() ParameterValueInterfaceOptions1Builder {
	return &_ParameterValueInterfaceOptions1Builder{_ParameterValueInterfaceOptions1: new(_ParameterValueInterfaceOptions1)}
}

type _ParameterValueInterfaceOptions1Builder struct {
	*_ParameterValueInterfaceOptions1

	parentBuilder *_ParameterValueBuilder

	collectedErr []error
}

var _ (ParameterValueInterfaceOptions1Builder) = (*_ParameterValueInterfaceOptions1Builder)(nil)

func (b *_ParameterValueInterfaceOptions1Builder) setParent(contract ParameterValueContract) {
	b.ParameterValueContract = contract
	contract.(*_ParameterValue)._SubType = b._ParameterValueInterfaceOptions1
}

func (b *_ParameterValueInterfaceOptions1Builder) WithMandatoryFields(value InterfaceOptions1, data []byte) ParameterValueInterfaceOptions1Builder {
	return b.WithValue(value).WithData(data...)
}

func (b *_ParameterValueInterfaceOptions1Builder) WithValue(value InterfaceOptions1) ParameterValueInterfaceOptions1Builder {
	b.Value = value
	return b
}

func (b *_ParameterValueInterfaceOptions1Builder) WithValueBuilder(builderSupplier func(InterfaceOptions1Builder) InterfaceOptions1Builder) ParameterValueInterfaceOptions1Builder {
	builder := builderSupplier(b.Value.CreateInterfaceOptions1Builder())
	var err error
	b.Value, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "InterfaceOptions1Builder failed"))
	}
	return b
}

func (b *_ParameterValueInterfaceOptions1Builder) WithData(data ...byte) ParameterValueInterfaceOptions1Builder {
	b.Data = data
	return b
}

func (b *_ParameterValueInterfaceOptions1Builder) Build() (ParameterValueInterfaceOptions1, error) {
	if b.Value == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'value' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ParameterValueInterfaceOptions1.deepCopy(), nil
}

func (b *_ParameterValueInterfaceOptions1Builder) MustBuild() ParameterValueInterfaceOptions1 {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ParameterValueInterfaceOptions1Builder) Done() ParameterValueBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewParameterValueBuilder().(*_ParameterValueBuilder)
	}
	return b.parentBuilder
}

func (b *_ParameterValueInterfaceOptions1Builder) buildForParameterValue() (ParameterValue, error) {
	return b.Build()
}

func (b *_ParameterValueInterfaceOptions1Builder) DeepCopy() any {
	_copy := b.CreateParameterValueInterfaceOptions1Builder().(*_ParameterValueInterfaceOptions1Builder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateParameterValueInterfaceOptions1Builder creates a ParameterValueInterfaceOptions1Builder
func (b *_ParameterValueInterfaceOptions1) CreateParameterValueInterfaceOptions1Builder() ParameterValueInterfaceOptions1Builder {
	if b == nil {
		return NewParameterValueInterfaceOptions1Builder()
	}
	return &_ParameterValueInterfaceOptions1Builder{_ParameterValueInterfaceOptions1: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ParameterValueInterfaceOptions1) GetParameterType() ParameterType {
	return ParameterType_INTERFACE_OPTIONS_1
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ParameterValueInterfaceOptions1) GetParent() ParameterValueContract {
	return m.ParameterValueContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ParameterValueInterfaceOptions1) GetValue() InterfaceOptions1 {
	return m.Value
}

func (m *_ParameterValueInterfaceOptions1) GetData() []byte {
	return m.Data
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastParameterValueInterfaceOptions1(structType any) ParameterValueInterfaceOptions1 {
	if casted, ok := structType.(ParameterValueInterfaceOptions1); ok {
		return casted
	}
	if casted, ok := structType.(*ParameterValueInterfaceOptions1); ok {
		return *casted
	}
	return nil
}

func (m *_ParameterValueInterfaceOptions1) GetTypeName() string {
	return "ParameterValueInterfaceOptions1"
}

func (m *_ParameterValueInterfaceOptions1) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ParameterValueContract.(*_ParameterValue).getLengthInBits(ctx))

	// Simple field (value)
	lengthInBits += m.Value.GetLengthInBits(ctx)

	// Array field
	if len(m.Data) > 0 {
		lengthInBits += 8 * uint16(len(m.Data))
	}

	return lengthInBits
}

func (m *_ParameterValueInterfaceOptions1) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ParameterValueInterfaceOptions1) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ParameterValue, parameterType ParameterType, numBytes uint8) (__parameterValueInterfaceOptions1 ParameterValueInterfaceOptions1, err error) {
	m.ParameterValueContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ParameterValueInterfaceOptions1"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ParameterValueInterfaceOptions1")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Validation
	if !(bool((numBytes) >= (1))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "InterfaceOptions1 has exactly one byte"})
	}

	value, err := ReadSimpleField[InterfaceOptions1](ctx, "value", ReadComplex[InterfaceOptions1](InterfaceOptions1ParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	data, err := readBuffer.ReadByteArray("data", int(int32(numBytes)-int32(int32(1))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'data' field"))
	}
	m.Data = data

	if closeErr := readBuffer.CloseContext("ParameterValueInterfaceOptions1"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ParameterValueInterfaceOptions1")
	}

	return m, nil
}

func (m *_ParameterValueInterfaceOptions1) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ParameterValueInterfaceOptions1) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ParameterValueInterfaceOptions1"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ParameterValueInterfaceOptions1")
		}

		if err := WriteSimpleField[InterfaceOptions1](ctx, "value", m.GetValue(), WriteComplex[InterfaceOptions1](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'value' field")
		}

		if err := WriteByteArrayField(ctx, "data", m.GetData(), WriteByteArray(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'data' field")
		}

		if popErr := writeBuffer.PopContext("ParameterValueInterfaceOptions1"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ParameterValueInterfaceOptions1")
		}
		return nil
	}
	return m.ParameterValueContract.(*_ParameterValue).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ParameterValueInterfaceOptions1) IsParameterValueInterfaceOptions1() {}

func (m *_ParameterValueInterfaceOptions1) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ParameterValueInterfaceOptions1) deepCopy() *_ParameterValueInterfaceOptions1 {
	if m == nil {
		return nil
	}
	_ParameterValueInterfaceOptions1Copy := &_ParameterValueInterfaceOptions1{
		m.ParameterValueContract.(*_ParameterValue).deepCopy(),
		utils.DeepCopy[InterfaceOptions1](m.Value),
		utils.DeepCopySlice[byte, byte](m.Data),
	}
	_ParameterValueInterfaceOptions1Copy.ParameterValueContract.(*_ParameterValue)._SubType = m
	return _ParameterValueInterfaceOptions1Copy
}

func (m *_ParameterValueInterfaceOptions1) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
