/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// CBusPointToPointToMultiPointCommand is the corresponding interface of CBusPointToPointToMultiPointCommand
type CBusPointToPointToMultiPointCommand interface {
	CBusPointToPointToMultiPointCommandContract
	CBusPointToPointToMultiPointCommandRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsCBusPointToPointToMultiPointCommand is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsCBusPointToPointToMultiPointCommand()
	// CreateBuilder creates a CBusPointToPointToMultiPointCommandBuilder
	CreateCBusPointToPointToMultiPointCommandBuilder() CBusPointToPointToMultiPointCommandBuilder
}

// CBusPointToPointToMultiPointCommandContract provides a set of functions which can be overwritten by a sub struct
type CBusPointToPointToMultiPointCommandContract interface {
	// GetBridgeAddress returns BridgeAddress (property field)
	GetBridgeAddress() BridgeAddress
	// GetNetworkRoute returns NetworkRoute (property field)
	GetNetworkRoute() NetworkRoute
	// GetPeekedApplication returns PeekedApplication (property field)
	GetPeekedApplication() byte
	// GetCBusOptions() returns a parser argument
	GetCBusOptions() CBusOptions
	// IsCBusPointToPointToMultiPointCommand is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsCBusPointToPointToMultiPointCommand()
	// CreateBuilder creates a CBusPointToPointToMultiPointCommandBuilder
	CreateCBusPointToPointToMultiPointCommandBuilder() CBusPointToPointToMultiPointCommandBuilder
}

// CBusPointToPointToMultiPointCommandRequirements provides a set of functions which need to be implemented by a sub struct
type CBusPointToPointToMultiPointCommandRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetPeekedApplication returns PeekedApplication (discriminator field)
	GetPeekedApplication() byte
}

// _CBusPointToPointToMultiPointCommand is the data-structure of this message
type _CBusPointToPointToMultiPointCommand struct {
	_SubType interface {
		CBusPointToPointToMultiPointCommandContract
		CBusPointToPointToMultiPointCommandRequirements
	}
	BridgeAddress     BridgeAddress
	NetworkRoute      NetworkRoute
	PeekedApplication byte

	// Arguments.
	CBusOptions CBusOptions
}

var _ CBusPointToPointToMultiPointCommandContract = (*_CBusPointToPointToMultiPointCommand)(nil)

// NewCBusPointToPointToMultiPointCommand factory function for _CBusPointToPointToMultiPointCommand
func NewCBusPointToPointToMultiPointCommand(bridgeAddress BridgeAddress, networkRoute NetworkRoute, peekedApplication byte, cBusOptions CBusOptions) *_CBusPointToPointToMultiPointCommand {
	if bridgeAddress == nil {
		panic("bridgeAddress of type BridgeAddress for CBusPointToPointToMultiPointCommand must not be nil")
	}
	if networkRoute == nil {
		panic("networkRoute of type NetworkRoute for CBusPointToPointToMultiPointCommand must not be nil")
	}
	return &_CBusPointToPointToMultiPointCommand{BridgeAddress: bridgeAddress, NetworkRoute: networkRoute, PeekedApplication: peekedApplication, CBusOptions: cBusOptions}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// CBusPointToPointToMultiPointCommandBuilder is a builder for CBusPointToPointToMultiPointCommand
type CBusPointToPointToMultiPointCommandBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(bridgeAddress BridgeAddress, networkRoute NetworkRoute, peekedApplication byte) CBusPointToPointToMultiPointCommandBuilder
	// WithBridgeAddress adds BridgeAddress (property field)
	WithBridgeAddress(BridgeAddress) CBusPointToPointToMultiPointCommandBuilder
	// WithBridgeAddressBuilder adds BridgeAddress (property field) which is build by the builder
	WithBridgeAddressBuilder(func(BridgeAddressBuilder) BridgeAddressBuilder) CBusPointToPointToMultiPointCommandBuilder
	// WithNetworkRoute adds NetworkRoute (property field)
	WithNetworkRoute(NetworkRoute) CBusPointToPointToMultiPointCommandBuilder
	// WithNetworkRouteBuilder adds NetworkRoute (property field) which is build by the builder
	WithNetworkRouteBuilder(func(NetworkRouteBuilder) NetworkRouteBuilder) CBusPointToPointToMultiPointCommandBuilder
	// WithPeekedApplication adds PeekedApplication (property field)
	WithPeekedApplication(byte) CBusPointToPointToMultiPointCommandBuilder
	// WithArgCBusOptions sets a parser argument
	WithArgCBusOptions(CBusOptions) CBusPointToPointToMultiPointCommandBuilder
	// AsCBusPointToPointToMultiPointCommandStatus converts this build to a subType of CBusPointToPointToMultiPointCommand. It is always possible to return to current builder using Done()
	AsCBusPointToPointToMultiPointCommandStatus() CBusPointToPointToMultiPointCommandStatusBuilder
	// AsCBusPointToPointToMultiPointCommandNormal converts this build to a subType of CBusPointToPointToMultiPointCommand. It is always possible to return to current builder using Done()
	AsCBusPointToPointToMultiPointCommandNormal() CBusPointToPointToMultiPointCommandNormalBuilder
	// Build builds the CBusPointToPointToMultiPointCommand or returns an error if something is wrong
	PartialBuild() (CBusPointToPointToMultiPointCommandContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() CBusPointToPointToMultiPointCommandContract
	// Build builds the CBusPointToPointToMultiPointCommand or returns an error if something is wrong
	Build() (CBusPointToPointToMultiPointCommand, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() CBusPointToPointToMultiPointCommand
}

// NewCBusPointToPointToMultiPointCommandBuilder() creates a CBusPointToPointToMultiPointCommandBuilder
func NewCBusPointToPointToMultiPointCommandBuilder() CBusPointToPointToMultiPointCommandBuilder {
	return &_CBusPointToPointToMultiPointCommandBuilder{_CBusPointToPointToMultiPointCommand: new(_CBusPointToPointToMultiPointCommand)}
}

type _CBusPointToPointToMultiPointCommandChildBuilder interface {
	utils.Copyable
	setParent(CBusPointToPointToMultiPointCommandContract)
	buildForCBusPointToPointToMultiPointCommand() (CBusPointToPointToMultiPointCommand, error)
}

type _CBusPointToPointToMultiPointCommandBuilder struct {
	*_CBusPointToPointToMultiPointCommand

	childBuilder _CBusPointToPointToMultiPointCommandChildBuilder

	collectedErr []error
}

var _ (CBusPointToPointToMultiPointCommandBuilder) = (*_CBusPointToPointToMultiPointCommandBuilder)(nil)

func (b *_CBusPointToPointToMultiPointCommandBuilder) WithMandatoryFields(bridgeAddress BridgeAddress, networkRoute NetworkRoute, peekedApplication byte) CBusPointToPointToMultiPointCommandBuilder {
	return b.WithBridgeAddress(bridgeAddress).WithNetworkRoute(networkRoute).WithPeekedApplication(peekedApplication)
}

func (b *_CBusPointToPointToMultiPointCommandBuilder) WithBridgeAddress(bridgeAddress BridgeAddress) CBusPointToPointToMultiPointCommandBuilder {
	b.BridgeAddress = bridgeAddress
	return b
}

func (b *_CBusPointToPointToMultiPointCommandBuilder) WithBridgeAddressBuilder(builderSupplier func(BridgeAddressBuilder) BridgeAddressBuilder) CBusPointToPointToMultiPointCommandBuilder {
	builder := builderSupplier(b.BridgeAddress.CreateBridgeAddressBuilder())
	var err error
	b.BridgeAddress, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BridgeAddressBuilder failed"))
	}
	return b
}

func (b *_CBusPointToPointToMultiPointCommandBuilder) WithNetworkRoute(networkRoute NetworkRoute) CBusPointToPointToMultiPointCommandBuilder {
	b.NetworkRoute = networkRoute
	return b
}

func (b *_CBusPointToPointToMultiPointCommandBuilder) WithNetworkRouteBuilder(builderSupplier func(NetworkRouteBuilder) NetworkRouteBuilder) CBusPointToPointToMultiPointCommandBuilder {
	builder := builderSupplier(b.NetworkRoute.CreateNetworkRouteBuilder())
	var err error
	b.NetworkRoute, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "NetworkRouteBuilder failed"))
	}
	return b
}

func (b *_CBusPointToPointToMultiPointCommandBuilder) WithPeekedApplication(peekedApplication byte) CBusPointToPointToMultiPointCommandBuilder {
	b.PeekedApplication = peekedApplication
	return b
}

func (b *_CBusPointToPointToMultiPointCommandBuilder) WithArgCBusOptions(cBusOptions CBusOptions) CBusPointToPointToMultiPointCommandBuilder {
	b.CBusOptions = cBusOptions
	return b
}

func (b *_CBusPointToPointToMultiPointCommandBuilder) PartialBuild() (CBusPointToPointToMultiPointCommandContract, error) {
	if b.BridgeAddress == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'bridgeAddress' not set"))
	}
	if b.NetworkRoute == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'networkRoute' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._CBusPointToPointToMultiPointCommand.deepCopy(), nil
}

func (b *_CBusPointToPointToMultiPointCommandBuilder) PartialMustBuild() CBusPointToPointToMultiPointCommandContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_CBusPointToPointToMultiPointCommandBuilder) AsCBusPointToPointToMultiPointCommandStatus() CBusPointToPointToMultiPointCommandStatusBuilder {
	if cb, ok := b.childBuilder.(CBusPointToPointToMultiPointCommandStatusBuilder); ok {
		return cb
	}
	cb := NewCBusPointToPointToMultiPointCommandStatusBuilder().(*_CBusPointToPointToMultiPointCommandStatusBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_CBusPointToPointToMultiPointCommandBuilder) AsCBusPointToPointToMultiPointCommandNormal() CBusPointToPointToMultiPointCommandNormalBuilder {
	if cb, ok := b.childBuilder.(CBusPointToPointToMultiPointCommandNormalBuilder); ok {
		return cb
	}
	cb := NewCBusPointToPointToMultiPointCommandNormalBuilder().(*_CBusPointToPointToMultiPointCommandNormalBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_CBusPointToPointToMultiPointCommandBuilder) Build() (CBusPointToPointToMultiPointCommand, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForCBusPointToPointToMultiPointCommand()
}

func (b *_CBusPointToPointToMultiPointCommandBuilder) MustBuild() CBusPointToPointToMultiPointCommand {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_CBusPointToPointToMultiPointCommandBuilder) DeepCopy() any {
	_copy := b.CreateCBusPointToPointToMultiPointCommandBuilder().(*_CBusPointToPointToMultiPointCommandBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_CBusPointToPointToMultiPointCommandChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateCBusPointToPointToMultiPointCommandBuilder creates a CBusPointToPointToMultiPointCommandBuilder
func (b *_CBusPointToPointToMultiPointCommand) CreateCBusPointToPointToMultiPointCommandBuilder() CBusPointToPointToMultiPointCommandBuilder {
	if b == nil {
		return NewCBusPointToPointToMultiPointCommandBuilder()
	}
	return &_CBusPointToPointToMultiPointCommandBuilder{_CBusPointToPointToMultiPointCommand: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_CBusPointToPointToMultiPointCommand) GetBridgeAddress() BridgeAddress {
	return m.BridgeAddress
}

func (m *_CBusPointToPointToMultiPointCommand) GetNetworkRoute() NetworkRoute {
	return m.NetworkRoute
}

func (m *_CBusPointToPointToMultiPointCommand) GetPeekedApplication() byte {
	return m.PeekedApplication
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastCBusPointToPointToMultiPointCommand(structType any) CBusPointToPointToMultiPointCommand {
	if casted, ok := structType.(CBusPointToPointToMultiPointCommand); ok {
		return casted
	}
	if casted, ok := structType.(*CBusPointToPointToMultiPointCommand); ok {
		return *casted
	}
	return nil
}

func (m *_CBusPointToPointToMultiPointCommand) GetTypeName() string {
	return "CBusPointToPointToMultiPointCommand"
}

func (m *_CBusPointToPointToMultiPointCommand) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (bridgeAddress)
	lengthInBits += m.BridgeAddress.GetLengthInBits(ctx)

	// Simple field (networkRoute)
	lengthInBits += m.NetworkRoute.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_CBusPointToPointToMultiPointCommand) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_CBusPointToPointToMultiPointCommand) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func CBusPointToPointToMultiPointCommandParse[T CBusPointToPointToMultiPointCommand](ctx context.Context, theBytes []byte, cBusOptions CBusOptions) (T, error) {
	return CBusPointToPointToMultiPointCommandParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes), cBusOptions)
}

func CBusPointToPointToMultiPointCommandParseWithBufferProducer[T CBusPointToPointToMultiPointCommand](cBusOptions CBusOptions) func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := CBusPointToPointToMultiPointCommandParseWithBuffer[T](ctx, readBuffer, cBusOptions)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func CBusPointToPointToMultiPointCommandParseWithBuffer[T CBusPointToPointToMultiPointCommand](ctx context.Context, readBuffer utils.ReadBuffer, cBusOptions CBusOptions) (T, error) {
	v, err := (&_CBusPointToPointToMultiPointCommand{CBusOptions: cBusOptions}).parse(ctx, readBuffer, cBusOptions)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_CBusPointToPointToMultiPointCommand) parse(ctx context.Context, readBuffer utils.ReadBuffer, cBusOptions CBusOptions) (__cBusPointToPointToMultiPointCommand CBusPointToPointToMultiPointCommand, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("CBusPointToPointToMultiPointCommand"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for CBusPointToPointToMultiPointCommand")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	bridgeAddress, err := ReadSimpleField[BridgeAddress](ctx, "bridgeAddress", ReadComplex[BridgeAddress](BridgeAddressParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'bridgeAddress' field"))
	}
	m.BridgeAddress = bridgeAddress

	networkRoute, err := ReadSimpleField[NetworkRoute](ctx, "networkRoute", ReadComplex[NetworkRoute](NetworkRouteParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'networkRoute' field"))
	}
	m.NetworkRoute = networkRoute

	peekedApplication, err := ReadPeekField[byte](ctx, "peekedApplication", ReadByte(readBuffer, 8), 0)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedApplication' field"))
	}
	m.PeekedApplication = peekedApplication

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child CBusPointToPointToMultiPointCommand
	switch {
	case peekedApplication == 0xFF: // CBusPointToPointToMultiPointCommandStatus
		if _child, err = new(_CBusPointToPointToMultiPointCommandStatus).parse(ctx, readBuffer, m, cBusOptions); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type CBusPointToPointToMultiPointCommandStatus for type-switch of CBusPointToPointToMultiPointCommand")
		}
	case 0 == 0: // CBusPointToPointToMultiPointCommandNormal
		if _child, err = new(_CBusPointToPointToMultiPointCommandNormal).parse(ctx, readBuffer, m, cBusOptions); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type CBusPointToPointToMultiPointCommandNormal for type-switch of CBusPointToPointToMultiPointCommand")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [peekedApplication=%v]", peekedApplication)
	}

	if closeErr := readBuffer.CloseContext("CBusPointToPointToMultiPointCommand"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for CBusPointToPointToMultiPointCommand")
	}

	return _child, nil
}

func (pm *_CBusPointToPointToMultiPointCommand) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child CBusPointToPointToMultiPointCommand, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("CBusPointToPointToMultiPointCommand"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for CBusPointToPointToMultiPointCommand")
	}

	if err := WriteSimpleField[BridgeAddress](ctx, "bridgeAddress", m.GetBridgeAddress(), WriteComplex[BridgeAddress](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'bridgeAddress' field")
	}

	if err := WriteSimpleField[NetworkRoute](ctx, "networkRoute", m.GetNetworkRoute(), WriteComplex[NetworkRoute](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'networkRoute' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("CBusPointToPointToMultiPointCommand"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for CBusPointToPointToMultiPointCommand")
	}
	return nil
}

////
// Arguments Getter

func (m *_CBusPointToPointToMultiPointCommand) GetCBusOptions() CBusOptions {
	return m.CBusOptions
}

//
////

func (m *_CBusPointToPointToMultiPointCommand) IsCBusPointToPointToMultiPointCommand() {}

func (m *_CBusPointToPointToMultiPointCommand) DeepCopy() any {
	return m.deepCopy()
}

func (m *_CBusPointToPointToMultiPointCommand) deepCopy() *_CBusPointToPointToMultiPointCommand {
	if m == nil {
		return nil
	}
	_CBusPointToPointToMultiPointCommandCopy := &_CBusPointToPointToMultiPointCommand{
		nil, // will be set by child
		utils.DeepCopy[BridgeAddress](m.BridgeAddress),
		utils.DeepCopy[NetworkRoute](m.NetworkRoute),
		m.PeekedApplication,
		m.CBusOptions,
	}
	return _CBusPointToPointToMultiPointCommandCopy
}
