/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetVendorId is an enum
type BACnetVendorId uint16

type IBACnetVendorId interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	VendorId() uint16
	VendorName() string
}

const (
	BACnetVendorId_ASHRAE                                                                       BACnetVendorId = 0
	BACnetVendorId_NIST                                                                         BACnetVendorId = 1
	BACnetVendorId_THE_TRANE_COMPANY                                                            BACnetVendorId = 2
	BACnetVendorId_DAIKIN_APPLIED_AMERICAS                                                      BACnetVendorId = 3
	BACnetVendorId_POLAR_SOFT                                                                   BACnetVendorId = 4
	BACnetVendorId_JOHNSON_CONTROLS_INC                                                         BACnetVendorId = 5
	BACnetVendorId_ABB_FORMERLY_AMERICAN_AUTO_MATRIX                                            BACnetVendorId = 6
	BACnetVendorId_SIEMENS_SCHWEIZAG                                                            BACnetVendorId = 7
	BACnetVendorId_DELTA_CONTROLS                                                               BACnetVendorId = 8
	BACnetVendorId_SIEMENS_SCHWEIZAG1                                                           BACnetVendorId = 9
	BACnetVendorId_SCHNEIDER_ELECTRIC                                                           BACnetVendorId = 10
	BACnetVendorId_TAC                                                                          BACnetVendorId = 11
	BACnetVendorId_ORION_ANALYSIS_CORPORATION                                                   BACnetVendorId = 12
	BACnetVendorId_TELETROL_SYSTEMS_INC                                                         BACnetVendorId = 13
	BACnetVendorId_CIMETRICS_TECHNOLOGY                                                         BACnetVendorId = 14
	BACnetVendorId_CORNELL_UNIVERSITY                                                           BACnetVendorId = 15
	BACnetVendorId_UNITED_TECHNOLOGIES_CARRIER                                                  BACnetVendorId = 16
	BACnetVendorId_HONEYWELL_INC                                                                BACnetVendorId = 17
	BACnetVendorId_ALERTON_HONEYWELL                                                            BACnetVendorId = 18
	BACnetVendorId_TACAB                                                                        BACnetVendorId = 19
	BACnetVendorId_HEWLETT_PACKARD_COMPANY                                                      BACnetVendorId = 20
	BACnetVendorId_DORSETTES_INC                                                                BACnetVendorId = 21
	BACnetVendorId_SIEMENS_SCHWEIZAG2                                                           BACnetVendorId = 22
	BACnetVendorId_YORK_CONTROLS_GROUP                                                          BACnetVendorId = 23
	BACnetVendorId_AUTOMATED_LOGIC_CORPORATION                                                  BACnetVendorId = 24
	BACnetVendorId_CSI_CONTROL_SYSTEMS_INTERNATIONAL                                            BACnetVendorId = 25
	BACnetVendorId_PHOENIX_CONTROLS_CORPORATION                                                 BACnetVendorId = 26
	BACnetVendorId_INNOVEX_TECHNOLOGIES_INC                                                     BACnetVendorId = 27
	BACnetVendorId_KMC_CONTROLS_INC                                                             BACnetVendorId = 28
	BACnetVendorId_XN_TECHNOLOGIES_INC                                                          BACnetVendorId = 29
	BACnetVendorId_HYUNDAI_INFORMATION_TECHNOLOGY_CO_LTD                                        BACnetVendorId = 30
	BACnetVendorId_TOKIMEC_INC                                                                  BACnetVendorId = 31
	BACnetVendorId_SIMPLEX                                                                      BACnetVendorId = 32
	BACnetVendorId_NORTH_BUILDING_TECHNOLOGIES_LIMITED                                          BACnetVendorId = 33
	BACnetVendorId_NOTIFIER                                                                     BACnetVendorId = 34
	BACnetVendorId_RELIABLE_CONTROLS_CORPORATION                                                BACnetVendorId = 35
	BACnetVendorId_TRIDIUM_INC                                                                  BACnetVendorId = 36
	BACnetVendorId_MSA_SAFETY                                                                   BACnetVendorId = 37
	BACnetVendorId_SILICON_ENERGY                                                               BACnetVendorId = 38
	BACnetVendorId_KIEBACK_PETER_GMBH_COKG                                                      BACnetVendorId = 39
	BACnetVendorId_ANACON_SYSTEMS_INC                                                           BACnetVendorId = 40
	BACnetVendorId_SYSTEMS_CONTROLS_INSTRUMENTSLLC                                              BACnetVendorId = 41
	BACnetVendorId_ACUITY_BRANDS_LIGHTING_INC                                                   BACnetVendorId = 42
	BACnetVendorId_MICROPOWER_MANUFACTURING                                                     BACnetVendorId = 43
	BACnetVendorId_MATRIX_CONTROLS                                                              BACnetVendorId = 44
	BACnetVendorId_METALAIRE                                                                    BACnetVendorId = 45
	BACnetVendorId_ESS_ENGINEERING                                                              BACnetVendorId = 46
	BACnetVendorId_SPHERE_SYSTEMS_PTY_LTD                                                       BACnetVendorId = 47
	BACnetVendorId_WALKER_TECHNOLOGIES_CORPORATION                                              BACnetVendorId = 48
	BACnetVendorId_HI_SOLUTIONS_INC                                                             BACnetVendorId = 49
	BACnetVendorId_MBS_GMBH                                                                     BACnetVendorId = 50
	BACnetVendorId_SAMSONAG                                                                     BACnetVendorId = 51
	BACnetVendorId_BADGER_METER_INC                                                             BACnetVendorId = 52
	BACnetVendorId_DAIKIN_INDUSTRIES_LTD                                                        BACnetVendorId = 53
	BACnetVendorId_NARA_CONTROLS_INC                                                            BACnetVendorId = 54
	BACnetVendorId_MAMMOTH_INC                                                                  BACnetVendorId = 55
	BACnetVendorId_LIEBERT_CORPORATION                                                          BACnetVendorId = 56
	BACnetVendorId_SEMCO_INCORPORATED                                                           BACnetVendorId = 57
	BACnetVendorId_AIR_MONITOR_CORPORATION                                                      BACnetVendorId = 58
	BACnetVendorId_TRIATEKLLC                                                                   BACnetVendorId = 59
	BACnetVendorId_NEX_LIGHT                                                                    BACnetVendorId = 60
	BACnetVendorId_MULTISTACK                                                                   BACnetVendorId = 61
	BACnetVendorId_TSI_INCORPORATED                                                             BACnetVendorId = 62
	BACnetVendorId_WEATHER_RITE_INC                                                             BACnetVendorId = 63
	BACnetVendorId_DUNHAM_BUSH                                                                  BACnetVendorId = 64
	BACnetVendorId_RELIANCE_ELECTRIC                                                            BACnetVendorId = 65
	BACnetVendorId_LCS_INC                                                                      BACnetVendorId = 66
	BACnetVendorId_REGULATOR_AUSTRALIAPTY_LTD                                                   BACnetVendorId = 67
	BACnetVendorId_TOUCH_PLATE_LIGHTING_CONTROLS                                                BACnetVendorId = 68
	BACnetVendorId_AMANN_GMBH                                                                   BACnetVendorId = 69
	BACnetVendorId_RLE_TECHNOLOGIES                                                             BACnetVendorId = 70
	BACnetVendorId_CARDKEY_SYSTEMS                                                              BACnetVendorId = 71
	BACnetVendorId_SECOM_CO_LTD                                                                 BACnetVendorId = 72
	BACnetVendorId_ABB_GEBUDETECHNIKAG_BEREICH_NET_SERV                                         BACnetVendorId = 73
	BACnetVendorId_KNX_ASSOCIATIONCVBA                                                          BACnetVendorId = 74
	BACnetVendorId_INSTITUTEOF_ELECTRICAL_INSTALLATION_ENGINEERSOF_JAPANIEIEJ                   BACnetVendorId = 75
	BACnetVendorId_NOHMI_BOSAI_LTD                                                              BACnetVendorId = 76
	BACnetVendorId_CAREL_INDUSTRIES_SPA                                                         BACnetVendorId = 77
	BACnetVendorId_UTC_FIRE_SECURITY_ESPAASL                                                    BACnetVendorId = 78
	BACnetVendorId_HOCHIKI_CORPORATION                                                          BACnetVendorId = 79
	BACnetVendorId_FR_SAUTERAG                                                                  BACnetVendorId = 80
	BACnetVendorId_MATSUSHITA_ELECTRIC_WORKS_LTD                                                BACnetVendorId = 81
	BACnetVendorId_MITSUBISHI_ELECTRIC_CORPORATION_INAZAWA_WORKS                                BACnetVendorId = 82
	BACnetVendorId_MITSUBISHI_HEAVY_INDUSTRIES_LTD                                              BACnetVendorId = 83
	BACnetVendorId_XYLEM_INC                                                                    BACnetVendorId = 84
	BACnetVendorId_YAMATAKE_BUILDING_SYSTEMS_CO_LTD                                             BACnetVendorId = 85
	BACnetVendorId_THE_WATT_STOPPER_INC                                                         BACnetVendorId = 86
	BACnetVendorId_AICHI_TOKEI_DENKI_CO_LTD                                                     BACnetVendorId = 87
	BACnetVendorId_ACTIVATION_TECHNOLOGIESLLC                                                   BACnetVendorId = 88
	BACnetVendorId_SAIA_BURGESS_CONTROLS_LTD                                                    BACnetVendorId = 89
	BACnetVendorId_HITACHI_LTD                                                                  BACnetVendorId = 90
	BACnetVendorId_NOVAR_CORP_TREND_CONTROL_SYSTEMS_LTD                                         BACnetVendorId = 91
	BACnetVendorId_MITSUBISHI_ELECTRIC_LIGHTING_CORPORATION                                     BACnetVendorId = 92
	BACnetVendorId_ARGUS_CONTROL_SYSTEMS_LTD                                                    BACnetVendorId = 93
	BACnetVendorId_KYUKI_CORPORATION                                                            BACnetVendorId = 94
	BACnetVendorId_RICHARDS_ZETA_BUILDING_INTELLIGENCE_INC                                      BACnetVendorId = 95
	BACnetVendorId_SCIENTECHRD_INC                                                              BACnetVendorId = 96
	BACnetVendorId_VCI_CONTROLS_INC                                                             BACnetVendorId = 97
	BACnetVendorId_TOSHIBA_CORPORATION                                                          BACnetVendorId = 98
	BACnetVendorId_MITSUBISHI_ELECTRIC_CORPORATION_AIR_CONDITIONING_REFRIGERATION_SYSTEMS_WORKS BACnetVendorId = 99
	BACnetVendorId_CUSTOM_MECHANICAL_EQUIPMENTLLC                                               BACnetVendorId = 100
	BACnetVendorId_CLIMATE_MASTER                                                               BACnetVendorId = 101
	BACnetVendorId_ICP_PANEL_TEC_INC                                                            BACnetVendorId = 102
	BACnetVendorId_D_TEK_CONTROLS                                                               BACnetVendorId = 103
	BACnetVendorId_NEC_ENGINEERING_LTD                                                          BACnetVendorId = 104
	BACnetVendorId_PRIVABV                                                                      BACnetVendorId = 105
	BACnetVendorId_MEIDENSHA_CORPORATION                                                        BACnetVendorId = 106
	BACnetVendorId_JCI_SYSTEMS_INTEGRATION_SERVICES                                             BACnetVendorId = 107
	BACnetVendorId_FREEDOM_CORPORATION                                                          BACnetVendorId = 108
	BACnetVendorId_NEUBERGER_GEBUDEAUTOMATION_GMBH                                              BACnetVendorId = 109
	BACnetVendorId_E_ZI_CONTROLS                                                                BACnetVendorId = 110
	BACnetVendorId_LEVITON_MANUFACTURING                                                        BACnetVendorId = 111
	BACnetVendorId_FUJITSU_LIMITED                                                              BACnetVendorId = 112
	BACnetVendorId_VERTIV_FORMERLY_EMERSON_NETWORK_POWER                                        BACnetVendorId = 113
	BACnetVendorId_SA_ARMSTRONG_LTD                                                             BACnetVendorId = 114
	BACnetVendorId_VISONETAG                                                                    BACnetVendorId = 115
	BACnetVendorId_MM_SYSTEMS_INC                                                               BACnetVendorId = 116
	BACnetVendorId_CUSTOM_SOFTWARE_ENGINEERING                                                  BACnetVendorId = 117
	BACnetVendorId_NITTAN_COMPANY_LIMITED                                                       BACnetVendorId = 118
	BACnetVendorId_ELUTIONS_INC_WIZCON_SYSTEMSSAS                                               BACnetVendorId = 119
	BACnetVendorId_PACOM_SYSTEMS_PTY_LTD                                                        BACnetVendorId = 120
	BACnetVendorId_UNICO_INC                                                                    BACnetVendorId = 121
	BACnetVendorId_EBTRON_INC                                                                   BACnetVendorId = 122
	BACnetVendorId_SCADA_ENGINE                                                                 BACnetVendorId = 123
	BACnetVendorId_LENZE_AMERICAS_FORMERLYAC_TECHNOLOGY_CORPORATION                             BACnetVendorId = 124
	BACnetVendorId_EAGLE_TECHNOLOGY                                                             BACnetVendorId = 125
	BACnetVendorId_DATA_AIRE_INC                                                                BACnetVendorId = 126
	BACnetVendorId_ABB_INC                                                                      BACnetVendorId = 127
	BACnetVendorId_TRANSBIT_SPZOO                                                               BACnetVendorId = 128
	BACnetVendorId_CARRIER_JAPAN_CORPORATION                                                    BACnetVendorId = 129
	BACnetVendorId_SHENZHEN_JUNZHI_HI_TECH_CO_LTD                                               BACnetVendorId = 130
	BACnetVendorId_TOKAI_SOFT                                                                   BACnetVendorId = 131
	BACnetVendorId_BLUE_RIDGE_TECHNOLOGIES                                                      BACnetVendorId = 132
	BACnetVendorId_VERIS_INDUSTRIES                                                             BACnetVendorId = 133
	BACnetVendorId_CENTAURUS_PRIME                                                              BACnetVendorId = 134
	BACnetVendorId_SAND_NETWORK_SYSTEMS                                                         BACnetVendorId = 135
	BACnetVendorId_REGULVAR_INC                                                                 BACnetVendorId = 136
	BACnetVendorId_AF_DTEK_DIVISIONOF_FASTEK_INTERNATIONAL_INC                                  BACnetVendorId = 137
	BACnetVendorId_POWER_COLD_COMFORT_AIR_SOLUTIONS_INC                                         BACnetVendorId = 138
	BACnetVendorId_I_CONTROLS                                                                   BACnetVendorId = 139
	BACnetVendorId_VICONICS_ELECTRONICS_INC                                                     BACnetVendorId = 140
	BACnetVendorId_YASKAWA_AMERICA_INC                                                          BACnetVendorId = 141
	BACnetVendorId_DEO_SCONTROLSYSTEMS_GMBH                                                     BACnetVendorId = 142
	BACnetVendorId_DIGITALE_MESSUND_STEUERSYSTEMEAG                                             BACnetVendorId = 143
	BACnetVendorId_FUJITSU_GENERAL_LIMITED                                                      BACnetVendorId = 144
	BACnetVendorId_PROJECT_ENGINEERING_SRL                                                      BACnetVendorId = 145
	BACnetVendorId_SANYO_ELECTRIC_CO_LTD                                                        BACnetVendorId = 146
	BACnetVendorId_INTEGRATED_INFORMATION_SYSTEMS_INC                                           BACnetVendorId = 147
	BACnetVendorId_TEMCO_CONTROLS_LTD                                                           BACnetVendorId = 148
	BACnetVendorId_AIRTEK_INTERNATIONAL_INC                                                     BACnetVendorId = 149
	BACnetVendorId_ADVANTECH_CORPORATION                                                        BACnetVendorId = 150
	BACnetVendorId_TITAN_PRODUCTS_LTD                                                           BACnetVendorId = 151
	BACnetVendorId_REGEL_PARTNERS                                                               BACnetVendorId = 152
	BACnetVendorId_NATIONAL_ENVIRONMENTAL_PRODUCT                                               BACnetVendorId = 153
	BACnetVendorId_UNITEC_CORPORATION                                                           BACnetVendorId = 154
	BACnetVendorId_KANDEN_ENGINEERING_COMPANY                                                   BACnetVendorId = 155
	BACnetVendorId_MESSNER_GEBUDETECHNIK_GMBH                                                   BACnetVendorId = 156
	BACnetVendorId_INTEGRATEDCH                                                                 BACnetVendorId = 157
	BACnetVendorId_PRICE_INDUSTRIES                                                             BACnetVendorId = 158
	BACnetVendorId_SE_ELEKTRONIC_GMBH                                                           BACnetVendorId = 159
	BACnetVendorId_ROCKWELL_AUTOMATION                                                          BACnetVendorId = 160
	BACnetVendorId_ENFLEX_CORP                                                                  BACnetVendorId = 161
	BACnetVendorId_ASI_CONTROLS                                                                 BACnetVendorId = 162
	BACnetVendorId_SYS_MIK_GMBH_DRESDEN                                                         BACnetVendorId = 163
	BACnetVendorId_HSC_REGELUNGSTECHNIK_GMBH                                                    BACnetVendorId = 164
	BACnetVendorId_SMART_TEMP_AUSTRALIA_PTY_LTD                                                 BACnetVendorId = 165
	BACnetVendorId_COOPER_CONTROLS                                                              BACnetVendorId = 166
	BACnetVendorId_DUKSAN_MECASYS_CO_LTD                                                        BACnetVendorId = 167
	BACnetVendorId_FUJIIT_CO_LTD                                                                BACnetVendorId = 168
	BACnetVendorId_VACON_PLC                                                                    BACnetVendorId = 169
	BACnetVendorId_LEADER_CONTROLS                                                              BACnetVendorId = 170
	BACnetVendorId_ABB_FORMERLY_CYLON_CONTROLS_LTD                                              BACnetVendorId = 171
	BACnetVendorId_COMPAS                                                                       BACnetVendorId = 172
	BACnetVendorId_MITSUBISHI_ELECTRIC_BUILDING_TECHNO_SERVICE_CO_LTD                           BACnetVendorId = 173
	BACnetVendorId_BUILDING_CONTROL_INTEGRATORS                                                 BACnetVendorId = 174
	BACnetVendorId_ITG_WORLDWIDEM_SDN_BHD                                                       BACnetVendorId = 175
	BACnetVendorId_LUTRON_ELECTRONICS_CO_INC                                                    BACnetVendorId = 176
	BACnetVendorId_COOPER_ATKINS_CORPORATION                                                    BACnetVendorId = 177
	BACnetVendorId_LOYTEC_ELECTRONICS_GMBH                                                      BACnetVendorId = 178
	BACnetVendorId_PRO_LON                                                                      BACnetVendorId = 179
	BACnetVendorId_MEGA_CONTROLS_LIMITED                                                        BACnetVendorId = 180
	BACnetVendorId_MICRO_CONTROL_SYSTEMS_INC                                                    BACnetVendorId = 181
	BACnetVendorId_KIYON_INC                                                                    BACnetVendorId = 182
	BACnetVendorId_DUST_NETWORKS                                                                BACnetVendorId = 183
	BACnetVendorId_ADVANCED_BUILDING_AUTOMATION_SYSTEMS                                         BACnetVendorId = 184
	BACnetVendorId_HERMOSAG                                                                     BACnetVendorId = 185
	BACnetVendorId_CEZIM                                                                        BACnetVendorId = 186
	BACnetVendorId_SOFTING                                                                      BACnetVendorId = 187
	BACnetVendorId_LYNXSPRING_INC                                                               BACnetVendorId = 188
	BACnetVendorId_SCHNEIDER_TOSHIBA_INVERTER_EUROPE                                            BACnetVendorId = 189
	BACnetVendorId_DANFOSS_DRIVESAS                                                             BACnetVendorId = 190
	BACnetVendorId_EATON_CORPORATION                                                            BACnetVendorId = 191
	BACnetVendorId_MATYCASA                                                                     BACnetVendorId = 192
	BACnetVendorId_BOTECHAB                                                                     BACnetVendorId = 193
	BACnetVendorId_NOVEO_INC                                                                    BACnetVendorId = 194
	BACnetVendorId_AMEV                                                                         BACnetVendorId = 195
	BACnetVendorId_YOKOGAWA_ELECTRIC_CORPORATION                                                BACnetVendorId = 196
	BACnetVendorId_BOSCH_BUILDING_AUTOMATION_GMBH                                               BACnetVendorId = 197
	BACnetVendorId_EXACT_LOGIC                                                                  BACnetVendorId = 198
	BACnetVendorId_MASS_ELECTRONICS_PTY_LTDDBA_INNOTECH_CONTROL_SYSTEMS_AUSTRALIA               BACnetVendorId = 199
	BACnetVendorId_KANDENKO_CO_LTD                                                              BACnetVendorId = 200
	BACnetVendorId_DTF_DATEN_TECHNIK_FRIES                                                      BACnetVendorId = 201
	BACnetVendorId_KLIMASOFT_LTD                                                                BACnetVendorId = 202
	BACnetVendorId_TOSHIBA_SCHNEIDER_INVERTER_CORPORATION                                       BACnetVendorId = 203
	BACnetVendorId_CONTROL_APPLICATIONS_LTD                                                     BACnetVendorId = 204
	BACnetVendorId_CIMONCO_LTD                                                                  BACnetVendorId = 205
	BACnetVendorId_ONICON_INCORPORATED                                                          BACnetVendorId = 206
	BACnetVendorId_AUTOMATION_DISPLAYS_INC                                                      BACnetVendorId = 207
	BACnetVendorId_CONTROL_SOLUTIONS_INC                                                        BACnetVendorId = 208
	BACnetVendorId_REMSDAQ_LIMITED                                                              BACnetVendorId = 209
	BACnetVendorId_NTT_FACILITIES_INC                                                           BACnetVendorId = 210
	BACnetVendorId_VIPA_GMBH                                                                    BACnetVendorId = 211
	BACnetVendorId_TSC1_ASSOCIATIONOF_JAPAN                                                     BACnetVendorId = 212
	BACnetVendorId_STRATO_AUTOMATION                                                            BACnetVendorId = 213
	BACnetVendorId_HRW_LIMITED                                                                  BACnetVendorId = 214
	BACnetVendorId_LIGHTING_CONTROL_DESIGN_INC                                                  BACnetVendorId = 215
	BACnetVendorId_MERCY_ELECTRONICAND_ELECTRICAL_INDUSTRIES                                    BACnetVendorId = 216
	BACnetVendorId_SAMSUNGSDS_CO_LTD                                                            BACnetVendorId = 217
	BACnetVendorId_IMPACT_FACILITY_SOLUTIONS_INC                                                BACnetVendorId = 218
	BACnetVendorId_AIRCUITY                                                                     BACnetVendorId = 219
	BACnetVendorId_CONTROL_TECHNIQUES_LTD                                                       BACnetVendorId = 220
	BACnetVendorId_OPEN_GENERAL_PTY_LTD                                                         BACnetVendorId = 221
	BACnetVendorId_WAGO_KONTAKTTECHNIK_GMBH_COKG                                                BACnetVendorId = 222
	BACnetVendorId_FRANKLIN_ELECTRIC                                                            BACnetVendorId = 223
	BACnetVendorId_CHLORIDE_POWER_PROTECTION_COMPANY                                            BACnetVendorId = 224
	BACnetVendorId_COMPUTROLS_INC                                                               BACnetVendorId = 225
	BACnetVendorId_PHOENIX_CONTACT_GMBH_COKG                                                    BACnetVendorId = 226
	BACnetVendorId_GRUNDFOS_MANAGEMENTAS                                                        BACnetVendorId = 227
	BACnetVendorId_RIDDER_DRIVE_SYSTEMS                                                         BACnetVendorId = 228
	BACnetVendorId_SOFT_DEVICESDNBHD                                                            BACnetVendorId = 229
	BACnetVendorId_INTEGRATED_CONTROL_TECHNOLOGY_LIMITED                                        BACnetVendorId = 230
	BACnetVendorId_AI_RXPERT_SYSTEMS_INC                                                        BACnetVendorId = 231
	BACnetVendorId_MICROTROL_LIMITED                                                            BACnetVendorId = 232
	BACnetVendorId_RED_LION_CONTROLS                                                            BACnetVendorId = 233
	BACnetVendorId_DIGITAL_ELECTRONICS_CORPORATION                                              BACnetVendorId = 234
	BACnetVendorId_ENNOVATIS_GMBH                                                               BACnetVendorId = 235
	BACnetVendorId_SEROTONIN_SOFTWARE_TECHNOLOGIES_INC                                          BACnetVendorId = 236
	BACnetVendorId_LS_INDUSTRIAL_SYSTEMS_CO_LTD                                                 BACnetVendorId = 237
	BACnetVendorId_SQUARED_COMPANY                                                              BACnetVendorId = 238
	BACnetVendorId_S_SQUARED_INNOVATIONS_INC                                                    BACnetVendorId = 239
	BACnetVendorId_ARICENT_LTD                                                                  BACnetVendorId = 240
	BACnetVendorId_ETHER_METRICSLLC                                                             BACnetVendorId = 241
	BACnetVendorId_INDUSTRIAL_CONTROL_COMMUNICATIONS_INC                                        BACnetVendorId = 242
	BACnetVendorId_PARAGON_CONTROLS_INC                                                         BACnetVendorId = 243
	BACnetVendorId_AO_SMITH_CORPORATION                                                         BACnetVendorId = 244
	BACnetVendorId_CONTEMPORARY_CONTROL_SYSTEMS_INC                                             BACnetVendorId = 245
	BACnetVendorId_HMS_INDUSTRIAL_NETWORKSSLU                                                   BACnetVendorId = 246
	BACnetVendorId_INGENIEURGESELLSCHAFTN_HARTLEBMBH                                            BACnetVendorId = 247
	BACnetVendorId_HEAT_TIMER_CORPORATION                                                       BACnetVendorId = 248
	BACnetVendorId_INGRASYS_TECHNOLOGY_INC                                                      BACnetVendorId = 249
	BACnetVendorId_COSTERM_BUILDING_AUTOMATION                                                  BACnetVendorId = 250
	BACnetVendorId_WILOSE                                                                       BACnetVendorId = 251
	BACnetVendorId_EMBEDIA_TECHNOLOGIES_CORP                                                    BACnetVendorId = 252
	BACnetVendorId_TECHNILOG                                                                    BACnetVendorId = 253
	BACnetVendorId_HR_CONTROLS_LTD_COKG                                                         BACnetVendorId = 254
	BACnetVendorId_LENNOX_INTERNATIONAL_INC                                                     BACnetVendorId = 255
	BACnetVendorId_RK_TEC_RAUCHKLAPPEN_STEUERUNGSSYSTEME_GMBH_COKG                              BACnetVendorId = 256
	BACnetVendorId_THERMOMAX_LTD                                                                BACnetVendorId = 257
	BACnetVendorId_ELCON_ELECTRONIC_CONTROL_LTD                                                 BACnetVendorId = 258
	BACnetVendorId_LARMIA_CONTROLAB                                                             BACnetVendorId = 259
	BACnetVendorId_BA_CNET_STACKAT_SOURCE_FORGE                                                 BACnetVendorId = 260
	BACnetVendorId_GS_SECURITY_SERVICESAS                                                       BACnetVendorId = 261
	BACnetVendorId_EXOR_INTERNATIONAL_SPA                                                       BACnetVendorId = 262
	BACnetVendorId_CRISTAL_CONTROLES                                                            BACnetVendorId = 263
	BACnetVendorId_REGINAB                                                                      BACnetVendorId = 264
	BACnetVendorId_DIMENSION_SOFTWARE_INC                                                       BACnetVendorId = 265
	BACnetVendorId_SYNAP_SENSE_CORPORATION                                                      BACnetVendorId = 266
	BACnetVendorId_BEIJING_NANTREE_ELECTRONIC_CO_LTD                                            BACnetVendorId = 267
	BACnetVendorId_CAMUS_HYDRONICS_LTD                                                          BACnetVendorId = 268
	BACnetVendorId_KAWASAKI_HEAVY_INDUSTRIES_LTD                                                BACnetVendorId = 269
	BACnetVendorId_CRITICAL_ENVIRONMENT_TECHNOLOGIES                                            BACnetVendorId = 270
	BACnetVendorId_ILSHINIBS_CO_LTD                                                             BACnetVendorId = 271
	BACnetVendorId_ELESTA_ENERGY_CONTROLAG                                                      BACnetVendorId = 272
	BACnetVendorId_KROPMAN_INSTALLATIETECHNIEK                                                  BACnetVendorId = 273
	BACnetVendorId_BALDOR_ELECTRIC_COMPANY                                                      BACnetVendorId = 274
	BACnetVendorId_ING_AMBH                                                                     BACnetVendorId = 275
	BACnetVendorId_GE_CONSUMER_INDUSTRIAL                                                       BACnetVendorId = 276
	BACnetVendorId_FUNCTIONAL_DEVICES_INC                                                       BACnetVendorId = 277
	BACnetVendorId_STUDIOSC                                                                     BACnetVendorId = 278
	BACnetVendorId_MGCOLTD                                                                      BACnetVendorId = 279
	BACnetVendorId_YOKOTA_CO_LTD                                                                BACnetVendorId = 280
	BACnetVendorId_HITRANSE_TECHNOLOGY_COLTD                                                    BACnetVendorId = 281
	BACnetVendorId_VIGILENT_CORPORATION                                                         BACnetVendorId = 282
	BACnetVendorId_KELE_INC                                                                     BACnetVendorId = 283
	BACnetVendorId_BELIMO_AUTOMATIONAG                                                          BACnetVendorId = 284
	BACnetVendorId_GENTEC                                                                       BACnetVendorId = 285
	BACnetVendorId_EMBEDDED_SCIENCE_LABSLLC                                                     BACnetVendorId = 286
	BACnetVendorId_PARKER_HANNIFIN_CORPORATION                                                  BACnetVendorId = 287
	BACnetVendorId_MA_CAPS_INTERNATIONAL_LIMITED                                                BACnetVendorId = 288
	BACnetVendorId_LINK_CORPORATION                                                             BACnetVendorId = 289
	BACnetVendorId_ROMUTEC_STEUERU_REGELSYSTEME_GMBH                                            BACnetVendorId = 290
	BACnetVendorId_PRIBUSIN_INC                                                                 BACnetVendorId = 291
	BACnetVendorId_ADVANTAGE_CONTROLS                                                           BACnetVendorId = 292
	BACnetVendorId_CRITICAL_ROOM_CONTROL                                                        BACnetVendorId = 293
	BACnetVendorId_LEGRAND                                                                      BACnetVendorId = 294
	BACnetVendorId_TONGDY_CONTROL_TECHNOLOGY_CO_LTD                                             BACnetVendorId = 295
	BACnetVendorId_ISSARO_INTEGRIERTE_SYSTEMTECHNIK                                             BACnetVendorId = 296
	BACnetVendorId_PRO_DEV_INDUSTRIES                                                           BACnetVendorId = 297
	BACnetVendorId_DRISTEEM                                                                     BACnetVendorId = 298
	BACnetVendorId_CREATIVE_ELECTRONIC_GMBH                                                     BACnetVendorId = 299
	BACnetVendorId_SWEGONAB                                                                     BACnetVendorId = 300
	BACnetVendorId_FIRVEN_ASRO                                                                  BACnetVendorId = 301
	BACnetVendorId_HITACHI_APPLIANCES_INC                                                       BACnetVendorId = 302
	BACnetVendorId_REAL_TIME_AUTOMATION_INC                                                     BACnetVendorId = 303
	BACnetVendorId_ITEC_HANKYU_HANSHIN_CO                                                       BACnetVendorId = 304
	BACnetVendorId_CYRUSEM_ENGINEERING_CO_LTD                                                   BACnetVendorId = 305
	BACnetVendorId_BADGER_METER                                                                 BACnetVendorId = 306
	BACnetVendorId_CIRRASCALE_CORPORATION                                                       BACnetVendorId = 307
	BACnetVendorId_ELESTA_GMBH_BUILDING_AUTOMATION                                              BACnetVendorId = 308
	BACnetVendorId_SECURITON                                                                    BACnetVendorId = 309
	BACnetVendorId_O_SLSOFT_INC                                                                 BACnetVendorId = 310
	BACnetVendorId_HANAZEDER_ELECTRONIC_GMBH                                                    BACnetVendorId = 311
	BACnetVendorId_HONEYWELL_SECURITY_DEUTSCHLAND_NOVAR_GMBH                                    BACnetVendorId = 312
	BACnetVendorId_SIEMENS_INDUSTRY_INC                                                         BACnetVendorId = 313
	BACnetVendorId_ETM_PROFESSIONAL_CONTROL_GMBH                                                BACnetVendorId = 314
	BACnetVendorId_MEITAVTEC_LTD                                                                BACnetVendorId = 315
	BACnetVendorId_JANITZA_ELECTRONICS_GMBH                                                     BACnetVendorId = 316
	BACnetVendorId_MKS_NORDHAUSEN                                                               BACnetVendorId = 317
	BACnetVendorId_DE_GIER_DRIVE_SYSTEMSBV                                                      BACnetVendorId = 318
	BACnetVendorId_CYPRESS_ENVIROSYSTEMS                                                        BACnetVendorId = 319
	BACnetVendorId_SMAR_TRONSRO                                                                 BACnetVendorId = 320
	BACnetVendorId_VERARI_SYSTEMS_INC                                                           BACnetVendorId = 321
	BACnetVendorId_KW_ELECTRONIC_SERVICE_INC                                                    BACnetVendorId = 322
	BACnetVendorId_ALFASMART_ENERGY_MANAGEMENT                                                  BACnetVendorId = 323
	BACnetVendorId_TELKONET_INC                                                                 BACnetVendorId = 324
	BACnetVendorId_SECURITON_GMBH                                                               BACnetVendorId = 325
	BACnetVendorId_CEMTREX_INC                                                                  BACnetVendorId = 326
	BACnetVendorId_PERFORMANCE_TECHNOLOGIES_INC                                                 BACnetVendorId = 327
	BACnetVendorId_XTRALIS_AUST_PTY_LTD                                                         BACnetVendorId = 328
	BACnetVendorId_TROX_GMBH                                                                    BACnetVendorId = 329
	BACnetVendorId_BEIJING_HYSINE_TECHNOLOGY_CO_LTD                                             BACnetVendorId = 330
	BACnetVendorId_RCK_CONTROLS_INC                                                             BACnetVendorId = 331
	BACnetVendorId_DISTECH_CONTROLSSAS                                                          BACnetVendorId = 332
	BACnetVendorId_NOVAR_HONEYWELL                                                              BACnetVendorId = 333
	BACnetVendorId_S_INTEGRATION_SOLUTIONS                                                      BACnetVendorId = 334
	BACnetVendorId_SCHNEIDER_ELECTRIC1                                                          BACnetVendorId = 335
	BACnetVendorId_LHA_SYSTEMS                                                                  BACnetVendorId = 336
	BACnetVendorId_GH_MENGINEERING_GROUP_INC                                                    BACnetVendorId = 337
	BACnetVendorId_CLLIMALUXSA                                                                  BACnetVendorId = 338
	BACnetVendorId_VAISALA_OYJ                                                                  BACnetVendorId = 339
	BACnetVendorId_COMPLEX_BEIJING_TECHNOLOGY_COLTD                                             BACnetVendorId = 340
	BACnetVendorId_SCAD_AMETRICS                                                                BACnetVendorId = 341
	BACnetVendorId_POWERPEGNSI_LIMITED                                                          BACnetVendorId = 342
	BACnetVendorId_BA_CNET_INTEROPERABILITY_TESTING_SERVICES_INC                                BACnetVendorId = 343
	BACnetVendorId_TECOAS                                                                       BACnetVendorId = 344
	BACnetVendorId_PLEXUS_TECHNOLOGY_INC                                                        BACnetVendorId = 345
	BACnetVendorId_ENERGY_FOCUS_INC                                                             BACnetVendorId = 346
	BACnetVendorId_POWERSMITHS_INTERNATIONAL_CORP                                               BACnetVendorId = 347
	BACnetVendorId_NICHIBEI_CO_LTD                                                              BACnetVendorId = 348
	BACnetVendorId_HKC_TECHNOLOGY_LTD                                                           BACnetVendorId = 349
	BACnetVendorId_OVATION_NETWORKS_INC                                                         BACnetVendorId = 350
	BACnetVendorId_SETRA_SYSTEMS                                                                BACnetVendorId = 351
	BACnetVendorId_AVG_AUTOMATION                                                               BACnetVendorId = 352
	BACnetVendorId_ZXC_LTD                                                                      BACnetVendorId = 353
	BACnetVendorId_BYTE_SPHERE                                                                  BACnetVendorId = 354
	BACnetVendorId_GENERITON_CO_LTD                                                             BACnetVendorId = 355
	BACnetVendorId_HOLTER_REGELARMATUREN_GMBH_COKG                                              BACnetVendorId = 356
	BACnetVendorId_BEDFORD_INSTRUMENTSLLC                                                       BACnetVendorId = 357
	BACnetVendorId_STANDAIR_INC                                                                 BACnetVendorId = 358
	BACnetVendorId_WEG_AUTOMATIONRD                                                             BACnetVendorId = 359
	BACnetVendorId_PROLON_CONTROL_SYSTEMS_APS                                                   BACnetVendorId = 360
	BACnetVendorId_INNEASOFT                                                                    BACnetVendorId = 361
	BACnetVendorId_CONNEX_SOFT_GMBH                                                             BACnetVendorId = 362
	BACnetVendorId_CEAG_NOTLICHTSYSTEME_GMBH                                                    BACnetVendorId = 363
	BACnetVendorId_DISTECH_CONTROLS_INC                                                         BACnetVendorId = 364
	BACnetVendorId_INDUSTRIAL_TECHNOLOGY_RESEARCH_INSTITUTE                                     BACnetVendorId = 365
	BACnetVendorId_MITSUBISHI_ELECTRIC_ICONICS_DIGITAL_SOLUTIONS                                BACnetVendorId = 366
	BACnetVendorId_IQ_CONTROLSSC                                                                BACnetVendorId = 367
	BACnetVendorId_OJ_ELECTRONICSAS                                                             BACnetVendorId = 368
	BACnetVendorId_ROLBIT_LTD                                                                   BACnetVendorId = 369
	BACnetVendorId_SYNAPSYS_SOLUTIONS_LTD                                                       BACnetVendorId = 370
	BACnetVendorId_ACME_ENGINEERING_PROD_LTD                                                    BACnetVendorId = 371
	BACnetVendorId_ZENER_ELECTRIC_PTY_LTD                                                       BACnetVendorId = 372
	BACnetVendorId_SELECTRONIX_INC                                                              BACnetVendorId = 373
	BACnetVendorId_GORBET_BANERJEELLC                                                           BACnetVendorId = 374
	BACnetVendorId_IME                                                                          BACnetVendorId = 375
	BACnetVendorId_STEPHENH_DAWSON_COMPUTER_SERVICE                                             BACnetVendorId = 376
	BACnetVendorId_ACCUTROLLLC                                                                  BACnetVendorId = 377
	BACnetVendorId_SCHNEIDER_ELEKTRONIK_GMBH                                                    BACnetVendorId = 378
	BACnetVendorId_ALPHA_INNO_TEC_GMBH                                                          BACnetVendorId = 379
	BACnetVendorId_ADM_MICRO_INC                                                                BACnetVendorId = 380
	BACnetVendorId_GREYSTONE_ENERGY_SYSTEMS_INC                                                 BACnetVendorId = 381
	BACnetVendorId_CAP_TECHNOLOGIE                                                              BACnetVendorId = 382
	BACnetVendorId_KE_RO_SYSTEMS                                                                BACnetVendorId = 383
	BACnetVendorId_DOMAT_CONTROL_SYSTEMSRO                                                      BACnetVendorId = 384
	BACnetVendorId_EFEKTRONICS_PTY_LTD                                                          BACnetVendorId = 385
	BACnetVendorId_HEKATRON_VERTRIEBS_GMBH                                                      BACnetVendorId = 386
	BACnetVendorId_SECURITONAG                                                                  BACnetVendorId = 387
	BACnetVendorId_CARLO_GAVAZZI_CONTROLS_SPA                                                   BACnetVendorId = 388
	BACnetVendorId_CHIPKIN_AUTOMATION_SYSTEMS                                                   BACnetVendorId = 389
	BACnetVendorId_SAVANT_SYSTEMSLLC                                                            BACnetVendorId = 390
	BACnetVendorId_SIMMTRONIC_LIGHTING_CONTROLS                                                 BACnetVendorId = 391
	BACnetVendorId_ABELKO_INNOVATIONAB                                                          BACnetVendorId = 392
	BACnetVendorId_SERESCO_TECHNOLOGIES_INC                                                     BACnetVendorId = 393
	BACnetVendorId_IT_WATCHDOGS                                                                 BACnetVendorId = 394
	BACnetVendorId_AUTOMATION_ASSIST_JAPAN_CORP                                                 BACnetVendorId = 395
	BACnetVendorId_THERMOKON_SENSORTECHNIK_GMBH                                                 BACnetVendorId = 396
	BACnetVendorId_E_GAUGE_SYSTEMSLLC                                                           BACnetVendorId = 397
	BACnetVendorId_QUANTUM_AUTOMATIONASIAPTE_LTD                                                BACnetVendorId = 398
	BACnetVendorId_TOSHIBA_LIGHTING_TECHNOLOGY_CORP                                             BACnetVendorId = 399
	BACnetVendorId_SPIN_ENGENHARIADE_AUTOMAO_LTDA                                               BACnetVendorId = 400
	BACnetVendorId_LOGISTICS_SYSTEMS_SOFTWARE_SERVICES_INDIAPVT_LTD                             BACnetVendorId = 401
	BACnetVendorId_DELTA_CONTROLS_INTEGRATION_PRODUCTS                                          BACnetVendorId = 402
	BACnetVendorId_FOCUS_MEDIA                                                                  BACnetVendorId = 403
	BACnetVendorId_LUM_ENERGI_INC                                                               BACnetVendorId = 404
	BACnetVendorId_KARA_SYSTEMS                                                                 BACnetVendorId = 405
	BACnetVendorId_RF_CODE_INC                                                                  BACnetVendorId = 406
	BACnetVendorId_FATEK_AUTOMATION_CORP                                                        BACnetVendorId = 407
	BACnetVendorId_JANDA_SOFTWARE_COMPANYLLC                                                    BACnetVendorId = 408
	BACnetVendorId_OPEN_SYSTEM_SOLUTIONS_LIMITED                                                BACnetVendorId = 409
	BACnetVendorId_INTELEC_SYSTEMSPTY_LTD                                                       BACnetVendorId = 410
	BACnetVendorId_ECOLODGIXLLC                                                                 BACnetVendorId = 411
	BACnetVendorId_DOUGLAS_LIGHTING_CONTROLS                                                    BACnetVendorId = 412
	BACnetVendorId_IS_ATECH_GMBH                                                                BACnetVendorId = 413
	BACnetVendorId_AREAL                                                                        BACnetVendorId = 414
	BACnetVendorId_BECKHOFF_AUTOMATION                                                          BACnetVendorId = 415
	BACnetVendorId_IPAS_GMBH                                                                    BACnetVendorId = 416
	BACnetVendorId_KE_THERM_SOLUTIONS                                                           BACnetVendorId = 417
	BACnetVendorId_BASE_PRODUCTS                                                                BACnetVendorId = 418
	BACnetVendorId_DTL_CONTROLSLLC                                                              BACnetVendorId = 419
	BACnetVendorId_INNCOM_INTERNATIONAL_INC                                                     BACnetVendorId = 420
	BACnetVendorId_METZCONNECT_GMBH                                                             BACnetVendorId = 421
	BACnetVendorId_GREENTROL_AUTOMATION_INC                                                     BACnetVendorId = 422
	BACnetVendorId_BELIMO_AUTOMATIONAG1                                                         BACnetVendorId = 423
	BACnetVendorId_SAMSUNG_HEAVY_INDUSTRIES_CO_LTD                                              BACnetVendorId = 424
	BACnetVendorId_TRIACTA_POWER_TECHNOLOGIES_INC                                               BACnetVendorId = 425
	BACnetVendorId_GLOBESTAR_SYSTEMS                                                            BACnetVendorId = 426
	BACnetVendorId_MLB_ADVANCED_MEDIALP                                                         BACnetVendorId = 427
	BACnetVendorId_SWG_STUCKMANN_WIRTSCHAFTLICHE_GEBUDESYSTEME_GMBH                             BACnetVendorId = 428
	BACnetVendorId_SENSOR_SWITCH                                                                BACnetVendorId = 429
	BACnetVendorId_MULTITEK_POWER_LIMITED                                                       BACnetVendorId = 430
	BACnetVendorId_INTEGRA_METERINGAG                                                           BACnetVendorId = 431
	BACnetVendorId_LG_ELECTRONICS_INC                                                           BACnetVendorId = 432
	BACnetVendorId_ELECTRONIC_THEATRE_CONTROLS_INC                                              BACnetVendorId = 433
	BACnetVendorId_MITSUBISHI_ELECTRIC_CORPORATION_NAGOYA_WORKS                                 BACnetVendorId = 434
	BACnetVendorId_DELTA_ELECTRONICS_INC                                                        BACnetVendorId = 435
	BACnetVendorId_ELMA_KURTALJ_LTD                                                             BACnetVendorId = 436
	BACnetVendorId_TYCO_FIRE_SECURITY_GMBH                                                      BACnetVendorId = 437
	BACnetVendorId_NEDAP_SECURITY_MANAGEMENT                                                    BACnetVendorId = 438
	BACnetVendorId_ESC_AUTOMATION_INC                                                           BACnetVendorId = 439
	BACnetVendorId_DSPYOU_LTD                                                                   BACnetVendorId = 440
	BACnetVendorId_GE_SENSINGAND_INSPECTION_TECHNOLOGIES                                        BACnetVendorId = 441
	BACnetVendorId_EMBEDDED_SYSTEMSSIA                                                          BACnetVendorId = 442
	BACnetVendorId_BEFEGA_GMBH                                                                  BACnetVendorId = 443
	BACnetVendorId_BASELINE_INC                                                                 BACnetVendorId = 444
	BACnetVendorId_KEY_ACT                                                                      BACnetVendorId = 445
	BACnetVendorId_OEM_CTRL                                                                     BACnetVendorId = 446
	BACnetVendorId_CLARKSON_CONTROLS_LIMITED                                                    BACnetVendorId = 447
	BACnetVendorId_ROGERWELL_CONTROL_SYSTEM_LIMITED                                             BACnetVendorId = 448
	BACnetVendorId_SCL_ELEMENTS                                                                 BACnetVendorId = 449
	BACnetVendorId_HITACHI_LTD1                                                                 BACnetVendorId = 450
	BACnetVendorId_NEWRON_SYSTEMSA                                                              BACnetVendorId = 451
	BACnetVendorId_BEVECO_GEBOUWAUTOMATISERINGBV                                                BACnetVendorId = 452
	BACnetVendorId_STREAMSIDE_SOLUTIONS                                                         BACnetVendorId = 453
	BACnetVendorId_YELLOWSTONE_SOFT                                                             BACnetVendorId = 454
	BACnetVendorId_OZTECH_INTELLIGENT_SYSTEMS_PTY_LTD                                           BACnetVendorId = 455
	BACnetVendorId_NOVELAN_GMBH                                                                 BACnetVendorId = 456
	BACnetVendorId_FLEXIM_AMERICAS_CORPORATION                                                  BACnetVendorId = 457
	BACnetVendorId_ICPDAS_CO_LTD                                                                BACnetVendorId = 458
	BACnetVendorId_CARMA_INDUSTRIES_INC                                                         BACnetVendorId = 459
	BACnetVendorId_LOG_ONE_LTD                                                                  BACnetVendorId = 460
	BACnetVendorId_TECO_ELECTRIC_MACHINERY_CO_LTD                                               BACnetVendorId = 461
	BACnetVendorId_CONNECT_EX_INC                                                               BACnetVendorId = 462
	BACnetVendorId_TURBODDC_SDWEST                                                              BACnetVendorId = 463
	BACnetVendorId_QUATROSENSE_ENVIRONMENTAL_LTD                                                BACnetVendorId = 464
	BACnetVendorId_FIFTH_LIGHT_TECHNOLOGY_LTD                                                   BACnetVendorId = 465
	BACnetVendorId_SCIENTIFIC_SOLUTIONS_LTD                                                     BACnetVendorId = 466
	BACnetVendorId_CONTROLLER_AREA_NETWORK_SOLUTIONSM_SDN_BHD                                   BACnetVendorId = 467
	BACnetVendorId_RESOL_ELEKTRONISCHE_REGELUNGEN_GMBH                                          BACnetVendorId = 468
	BACnetVendorId_RPBUSLLC                                                                     BACnetVendorId = 469
	BACnetVendorId_BRS_SISTEMAS_ELETRONICOS                                                     BACnetVendorId = 470
	BACnetVendorId_WINDOW_MASTERAS                                                              BACnetVendorId = 471
	BACnetVendorId_SUNLUX_TECHNOLOGIES_LTD                                                      BACnetVendorId = 472
	BACnetVendorId_MEASURLOGIC                                                                  BACnetVendorId = 473
	BACnetVendorId_FRIMAT_GMBH                                                                  BACnetVendorId = 474
	BACnetVendorId_SPIRAX_SARCO                                                                 BACnetVendorId = 475
	BACnetVendorId_LUXTRON                                                                      BACnetVendorId = 476
	BACnetVendorId_RAYPAK_INC                                                                   BACnetVendorId = 477
	BACnetVendorId_AIR_MONITOR_CORPORATION1                                                     BACnetVendorId = 478
	BACnetVendorId_REGLER_OCH_WEBBTEKNIK_SVERIGEROWS                                            BACnetVendorId = 479
	BACnetVendorId_INTELLIGENT_LIGHTING_CONTROLS_INC                                            BACnetVendorId = 480
	BACnetVendorId_SANYO_ELECTRIC_INDUSTRY_CO_LTD                                               BACnetVendorId = 481
	BACnetVendorId_E_MON_ENERGY_MONITORING_PRODUCTS                                             BACnetVendorId = 482
	BACnetVendorId_DIGITAL_CONTROL_SYSTEMS                                                      BACnetVendorId = 483
	BACnetVendorId_ATI_AIRTEST_TECHNOLOGIES_INC                                                 BACnetVendorId = 484
	BACnetVendorId_SCSSA                                                                        BACnetVendorId = 485
	BACnetVendorId_HMS_INDUSTRIAL_NETWORKSAB                                                    BACnetVendorId = 486
	BACnetVendorId_SHENZHEN_UNIVERSAL_INTELLISYS_CO_LTD                                         BACnetVendorId = 487
	BACnetVendorId_EK_INTELLISYS_SDN_BHD                                                        BACnetVendorId = 488
	BACnetVendorId_SYS_COM                                                                      BACnetVendorId = 489
	BACnetVendorId_FIRECOM_INC                                                                  BACnetVendorId = 490
	BACnetVendorId_ESA_ELEKTROSCHALTANLAGEN_GRIMMA_GMBH                                         BACnetVendorId = 491
	BACnetVendorId_KUMAHIRA_CO_LTD                                                              BACnetVendorId = 492
	BACnetVendorId_HOTRACO                                                                      BACnetVendorId = 493
	BACnetVendorId_SABO_ELEKTRONIK_GMBH                                                         BACnetVendorId = 494
	BACnetVendorId_EQUIP_TRANS                                                                  BACnetVendorId = 495
	BACnetVendorId_TEMPERATURE_CONTROL_SPECIALITIES_CO_INCTCS                                   BACnetVendorId = 496
	BACnetVendorId_FLOW_CON_INTERNATIONALAS                                                     BACnetVendorId = 497
	BACnetVendorId_THYSSEN_KRUPP_ELEVATOR_AMERICAS                                              BACnetVendorId = 498
	BACnetVendorId_ABATEMENT_TECHNOLOGIES                                                       BACnetVendorId = 499
	BACnetVendorId_CONTINENTAL_CONTROL_SYSTEMSLLC                                               BACnetVendorId = 500
	BACnetVendorId_WISAG_AUTOMATISIERUNGSTECHNIK_GMBH_COKG                                      BACnetVendorId = 501
	BACnetVendorId_EASYIO                                                                       BACnetVendorId = 502
	BACnetVendorId_EAP_ELECTRIC_GMBH                                                            BACnetVendorId = 503
	BACnetVendorId_HARDMEIER                                                                    BACnetVendorId = 504
	BACnetVendorId_MIRCOM_GROUPOF_COMPANIES                                                     BACnetVendorId = 505
	BACnetVendorId_QUEST_CONTROLS                                                               BACnetVendorId = 506
	BACnetVendorId_MESTEK_INC                                                                   BACnetVendorId = 507
	BACnetVendorId_PULSE_ENERGY                                                                 BACnetVendorId = 508
	BACnetVendorId_TACHIKAWA_CORPORATION                                                        BACnetVendorId = 509
	BACnetVendorId_UNIVERSITYOF_NEBRASKA_LINCOLN                                                BACnetVendorId = 510
	BACnetVendorId_REDWOOD_SYSTEMS                                                              BACnetVendorId = 511
	BACnetVendorId_PAS_STEC_INDUSTRIE_ELEKTRONIK_GMBH                                           BACnetVendorId = 512
	BACnetVendorId_NGEK_INC                                                                     BACnetVendorId = 513
	BACnetVendorId_TMAC_TECHNOLOGIES                                                            BACnetVendorId = 514
	BACnetVendorId_JIREH_ENERGY_TECH_CO_LTD                                                     BACnetVendorId = 515
	BACnetVendorId_ENLIGHTED_INC                                                                BACnetVendorId = 516
	BACnetVendorId_EL_PIAST_SP_ZOO                                                              BACnetVendorId = 517
	BACnetVendorId_NETX_AUTOMATION_SOFTWARE_GMBH                                                BACnetVendorId = 518
	BACnetVendorId_INVERTEK_DRIVES                                                              BACnetVendorId = 519
	BACnetVendorId_DEUTSCHMANN_AUTOMATION_GMBH_COKG                                             BACnetVendorId = 520
	BACnetVendorId_EMU_ELECTRONICAG                                                             BACnetVendorId = 521
	BACnetVendorId_PHAEDRUS_LIMITED                                                             BACnetVendorId = 522
	BACnetVendorId_SIGMATEK_GMBH_COKG                                                           BACnetVendorId = 523
	BACnetVendorId_MARLIN_CONTROLS                                                              BACnetVendorId = 524
	BACnetVendorId_CIRCUTORSA                                                                   BACnetVendorId = 525
	BACnetVendorId_UTC_FIRE_SECURITY                                                            BACnetVendorId = 526
	BACnetVendorId_DENT_INSTRUMENTS_INC                                                         BACnetVendorId = 527
	BACnetVendorId_FHP_MANUFACTURING_COMPANY_BOSCH_GROUP                                        BACnetVendorId = 528
	BACnetVendorId_GE_INTELLIGENT_PLATFORMS                                                     BACnetVendorId = 529
	BACnetVendorId_INNER_RANGE_PTY_LTD                                                          BACnetVendorId = 530
	BACnetVendorId_GLAS_ENERGY_TECHNOLOGY                                                       BACnetVendorId = 531
	BACnetVendorId_MSR_ELECTRONIC_GMBH                                                          BACnetVendorId = 532
	BACnetVendorId_ENERGY_CONTROL_SYSTEMS_INC                                                   BACnetVendorId = 533
	BACnetVendorId_EMT_CONTROLS                                                                 BACnetVendorId = 534
	BACnetVendorId_DAINTREE                                                                     BACnetVendorId = 535
	BACnetVendorId_EUROIC_CDOO                                                                  BACnetVendorId = 536
	BACnetVendorId_TE_CONNECTIVITY_ENERGY                                                       BACnetVendorId = 537
	BACnetVendorId_GEZE_GMBH                                                                    BACnetVendorId = 538
	BACnetVendorId_NEC_CORPORATION                                                              BACnetVendorId = 539
	BACnetVendorId_HO_CHEUNG_INTERNATIONAL_COMPANY_LIMITED                                      BACnetVendorId = 540
	BACnetVendorId_SHARP_MANUFACTURING_SYSTEMS_CORPORATION                                      BACnetVendorId = 541
	BACnetVendorId_DOTCONTROL_SAS                                                               BACnetVendorId = 542
	BACnetVendorId_BEACON_MEDS                                                                  BACnetVendorId = 543
	BACnetVendorId_MIDEA_COMMERCIAL_AIRCON                                                      BACnetVendorId = 544
	BACnetVendorId_AAON                                                                         BACnetVendorId = 545
	BACnetVendorId_KAMSTRUPAS                                                                   BACnetVendorId = 546
	BACnetVendorId_CA_COMPUTER_AUTOMATION_GMBH                                                  BACnetVendorId = 547
	BACnetVendorId_LAARS_HEATING_SYSTEMS_COMPANY                                                BACnetVendorId = 548
	BACnetVendorId_HITACHI_SYSTEMS_LTD                                                          BACnetVendorId = 549
	BACnetVendorId_FUSHANAKE_ELECTRONIC_ENGINEERING_CO_LTD                                      BACnetVendorId = 550
	BACnetVendorId_TOSHIBA_INTERNATIONAL_CORPORATION                                            BACnetVendorId = 551
	BACnetVendorId_STARMAN_SYSTEMSLLC                                                           BACnetVendorId = 552
	BACnetVendorId_SAMSUNG_TECHWIN_CO_LTD                                                       BACnetVendorId = 553
	BACnetVendorId_ISAS_INTEGRATED_SWITCHGEARAND_SYSTEMSPL                                      BACnetVendorId = 554
	BACnetVendorId_OBVIUS                                                                       BACnetVendorId = 556
	BACnetVendorId_MAREK_GUZIK                                                                  BACnetVendorId = 557
	BACnetVendorId_VORTEK_INSTRUMENTSLLC                                                        BACnetVendorId = 558
	BACnetVendorId_UNIVERSAL_LIGHTING_TECHNOLOGIES                                              BACnetVendorId = 559
	BACnetVendorId_MYERS_POWER_PRODUCTS_INC                                                     BACnetVendorId = 560
	BACnetVendorId_VECTOR_CONTROLS_GMBH                                                         BACnetVendorId = 561
	BACnetVendorId_CRESTRON_ELECTRONICS_INC                                                     BACnetVendorId = 562
	BACnetVendorId_AE_CONTROLS_LIMITED                                                          BACnetVendorId = 563
	BACnetVendorId_PROJEKTOMONTAZAAD                                                            BACnetVendorId = 564
	BACnetVendorId_FREEAIRE_REFRIGERATION                                                       BACnetVendorId = 565
	BACnetVendorId_AQUA_COOLER_PTY_LIMITED                                                      BACnetVendorId = 566
	BACnetVendorId_BASIC_CONTROLS                                                               BACnetVendorId = 567
	BACnetVendorId_GE_MEASUREMENTAND_CONTROL_SOLUTIONS_ADVANCED_SENSORS                         BACnetVendorId = 568
	BACnetVendorId_EQUAL_NETWORKS                                                               BACnetVendorId = 569
	BACnetVendorId_MILLENNIAL_NET                                                               BACnetVendorId = 570
	BACnetVendorId_APLI_LTD                                                                     BACnetVendorId = 571
	BACnetVendorId_ELECTRO_INDUSTRIES_GAUGE_TECH                                                BACnetVendorId = 572
	BACnetVendorId_SANG_MYUNG_UNIVERSITY                                                        BACnetVendorId = 573
	BACnetVendorId_COPPERTREE_ANALYTICS_INC                                                     BACnetVendorId = 574
	BACnetVendorId_CORE_NETIX_GMBH                                                              BACnetVendorId = 575
	BACnetVendorId_ACUTHERM                                                                     BACnetVendorId = 576
	BACnetVendorId_DR_RIEDEL_AUTOMATISIERUNGSTECHNIK_GMBH                                       BACnetVendorId = 577
	BACnetVendorId_SHINA_SYSTEM_CO_LTD                                                          BACnetVendorId = 578
	BACnetVendorId_IQAPERTUS                                                                    BACnetVendorId = 579
	BACnetVendorId_PSE_TECHNOLOGY                                                               BACnetVendorId = 580
	BACnetVendorId_BA_SYSTEMS                                                                   BACnetVendorId = 581
	BACnetVendorId_BTICINO                                                                      BACnetVendorId = 582
	BACnetVendorId_MONICO_INC                                                                   BACnetVendorId = 583
	BACnetVendorId_I_CUE                                                                        BACnetVendorId = 584
	BACnetVendorId_TEKMAR_CONTROL_SYSTEMS_LTD                                                   BACnetVendorId = 585
	BACnetVendorId_CONTROL_TECHNOLOGY_CORPORATION                                               BACnetVendorId = 586
	BACnetVendorId_GFAE_GMBH                                                                    BACnetVendorId = 587
	BACnetVendorId_BE_KA_SOFTWARE_GMBH                                                          BACnetVendorId = 588
	BACnetVendorId_ISOIL_INDUSTRIA_SPA                                                          BACnetVendorId = 589
	BACnetVendorId_HOME_SYSTEMS_CONSULTING_SPA                                                  BACnetVendorId = 590
	BACnetVendorId_SOCOMEC                                                                      BACnetVendorId = 591
	BACnetVendorId_EVEREX_COMMUNICATIONS_INC                                                    BACnetVendorId = 592
	BACnetVendorId_CET_ELECTRIC_TECHNOLOGY_INC                                                  BACnetVendorId = 593
	BACnetVendorId_ATRILA_GMBH                                                                  BACnetVendorId = 594
	BACnetVendorId_WING_TECHS                                                                   BACnetVendorId = 595
	BACnetVendorId_SHENZHEN_MEK_INTELLISYS_PTE_LTD                                              BACnetVendorId = 596
	BACnetVendorId_NESTFIELD_CO_LTD                                                             BACnetVendorId = 597
	BACnetVendorId_SWISSPHONE_TELECOMAG                                                         BACnetVendorId = 598
	BACnetVendorId_PNTECHJSC                                                                    BACnetVendorId = 599
	BACnetVendorId_HORNERAPGLLC                                                                 BACnetVendorId = 600
	BACnetVendorId_PVI_INDUSTRIESLLC                                                            BACnetVendorId = 601
	BACnetVendorId_ELACOMPIL                                                                    BACnetVendorId = 602
	BACnetVendorId_PEGASUS_AUTOMATION_INTERNATIONALLLC                                          BACnetVendorId = 603
	BACnetVendorId_WIGHT_ELECTRONIC_SERVICES_LTD                                                BACnetVendorId = 604
	BACnetVendorId_MARCOM                                                                       BACnetVendorId = 605
	BACnetVendorId_EXHAUSTOAS                                                                   BACnetVendorId = 606
	BACnetVendorId_DWYER_INSTRUMENTS_INC                                                        BACnetVendorId = 607
	BACnetVendorId_LINK_GMBH                                                                    BACnetVendorId = 608
	BACnetVendorId_OPPERMANN_REGELGERATE_GMBH                                                   BACnetVendorId = 609
	BACnetVendorId_NU_AIRE_INC                                                                  BACnetVendorId = 610
	BACnetVendorId_NORTEC_HUMIDITY_INC                                                          BACnetVendorId = 611
	BACnetVendorId_BIGWOOD_SYSTEMS_INC                                                          BACnetVendorId = 612
	BACnetVendorId_ENBALA_POWER_NETWORKS                                                        BACnetVendorId = 613
	BACnetVendorId_INTER_ENERGY_CO_LTD                                                          BACnetVendorId = 614
	BACnetVendorId_ETC                                                                          BACnetVendorId = 615
	BACnetVendorId_COMELECSARL                                                                  BACnetVendorId = 616
	BACnetVendorId_PYTHIA_TECHNOLOGIES                                                          BACnetVendorId = 617
	BACnetVendorId_TREND_POINT_SYSTEMS_INC                                                      BACnetVendorId = 618
	BACnetVendorId_AWEX                                                                         BACnetVendorId = 619
	BACnetVendorId_EUREVIA                                                                      BACnetVendorId = 620
	BACnetVendorId_KONGSBERGELONAS                                                              BACnetVendorId = 621
	BACnetVendorId_FLAKT_WOODS                                                                  BACnetVendorId = 622
	BACnetVendorId_EE_ELEKTRONIKGESMBH                                                          BACnetVendorId = 623
	BACnetVendorId_ARC_INFORMATIQUE                                                             BACnetVendorId = 624
	BACnetVendorId_SKIDATAAG                                                                    BACnetVendorId = 625
	BACnetVendorId_WSW_SOLUTIONS                                                                BACnetVendorId = 626
	BACnetVendorId_TREFON_ELECTRONIC_GMBH                                                       BACnetVendorId = 627
	BACnetVendorId_DONGSEO_SYSTEM                                                               BACnetVendorId = 628
	BACnetVendorId_KANONTEC_INTELLIGENCE_TECHNOLOGY_CO_LTD                                      BACnetVendorId = 629
	BACnetVendorId_EVCO_SPA                                                                     BACnetVendorId = 630
	BACnetVendorId_ACCUENERGY_CANADA_INC                                                        BACnetVendorId = 631
	BACnetVendorId_SOFTDEL                                                                      BACnetVendorId = 632
	BACnetVendorId_ORION_ENERGY_SYSTEMS_INC                                                     BACnetVendorId = 633
	BACnetVendorId_ROBOTICSWARE                                                                 BACnetVendorId = 634
	BACnetVendorId_DOMIQ_SPZOO                                                                  BACnetVendorId = 635
	BACnetVendorId_SOLIDYNE                                                                     BACnetVendorId = 636
	BACnetVendorId_ELECSYS_CORPORATION                                                          BACnetVendorId = 637
	BACnetVendorId_CONDITIONAIRE_INTERNATIONAL_PTY_LIMITED                                      BACnetVendorId = 638
	BACnetVendorId_QUEBEC_INC                                                                   BACnetVendorId = 639
	BACnetVendorId_HOMERUN_HOLDINGS                                                             BACnetVendorId = 640
	BACnetVendorId_MURATA_AMERICAS                                                              BACnetVendorId = 641
	BACnetVendorId_COMPTEK                                                                      BACnetVendorId = 642
	BACnetVendorId_WESTCO_SYSTEMS_INC                                                           BACnetVendorId = 643
	BACnetVendorId_ADVANCIS_SOFTWARE_SERVICES_GMBH                                              BACnetVendorId = 644
	BACnetVendorId_INTERGRIDLLC                                                                 BACnetVendorId = 645
	BACnetVendorId_MARKERR_CONTROLS_INC                                                         BACnetVendorId = 646
	BACnetVendorId_TOSHIBA_ELEVATORAND_BUILDING_SYSTEMS_CORPORATION                             BACnetVendorId = 647
	BACnetVendorId_SPECTRUM_CONTROLS_INC                                                        BACnetVendorId = 648
	BACnetVendorId_MKSERVICE                                                                    BACnetVendorId = 649
	BACnetVendorId_FOX_THERMAL_INSTRUMENTS                                                      BACnetVendorId = 650
	BACnetVendorId_SYXTH_SENSE_LTD                                                              BACnetVendorId = 651
	BACnetVendorId_DUHA_SYSTEMSRO                                                               BACnetVendorId = 652
	BACnetVendorId_NIBE                                                                         BACnetVendorId = 653
	BACnetVendorId_MELINK_CORPORATION                                                           BACnetVendorId = 654
	BACnetVendorId_FRITZ_HABER_INSTITUT                                                         BACnetVendorId = 655
	BACnetVendorId_MTU_ONSITE_ENERGY_GMBH_GAS_POWER_SYSTEMS                                     BACnetVendorId = 656
	BACnetVendorId_OMEGA_ENGINEERING_INC                                                        BACnetVendorId = 657
	BACnetVendorId_AVELON                                                                       BACnetVendorId = 658
	BACnetVendorId_YWIRE_TECHNOLOGIES_INC                                                       BACnetVendorId = 659
	BACnetVendorId_MR_ENGINEERING_CO_LTD                                                        BACnetVendorId = 660
	BACnetVendorId_LOCHINVARLLC                                                                 BACnetVendorId = 661
	BACnetVendorId_SONTAY_LIMITED                                                               BACnetVendorId = 662
	BACnetVendorId_GRUPA_SLAWOMIR_CHELMINSKI                                                    BACnetVendorId = 663
	BACnetVendorId_ARCH_METER_CORPORATION                                                       BACnetVendorId = 664
	BACnetVendorId_SENVA_INC                                                                    BACnetVendorId = 665
	BACnetVendorId_FM_TEC                                                                       BACnetVendorId = 667
	BACnetVendorId_SYSTEMS_SPECIALISTS_INC                                                      BACnetVendorId = 668
	BACnetVendorId_SENSE_AIR                                                                    BACnetVendorId = 669
	BACnetVendorId_AB_INDUSTRIE_TECHNIK_SRL                                                     BACnetVendorId = 670
	BACnetVendorId_CORTLAND_RESEARCHLLC                                                         BACnetVendorId = 671
	BACnetVendorId_MEDIA_VIEW                                                                   BACnetVendorId = 672
	BACnetVendorId_VDA_ELETTRONICA                                                              BACnetVendorId = 673
	BACnetVendorId_CSS_INC                                                                      BACnetVendorId = 674
	BACnetVendorId_TEK_AIR_SYSTEMS_INC                                                          BACnetVendorId = 675
	BACnetVendorId_ICDT                                                                         BACnetVendorId = 676
	BACnetVendorId_THE_ARMSTRONG_MONITORING_CORPORATION                                         BACnetVendorId = 677
	BACnetVendorId_DIXELL_SRL                                                                   BACnetVendorId = 678
	BACnetVendorId_LEAD_SYSTEM_INC                                                              BACnetVendorId = 679
	BACnetVendorId_ISM_EURO_CENTERSA                                                            BACnetVendorId = 680
	BACnetVendorId_TDIS                                                                         BACnetVendorId = 681
	BACnetVendorId_TRADEFIDES                                                                   BACnetVendorId = 682
	BACnetVendorId_KNRR_GMBH_EMERSON_NETWORK_POWER                                              BACnetVendorId = 683
	BACnetVendorId_RESOURCE_DATA_MANAGEMENT                                                     BACnetVendorId = 684
	BACnetVendorId_ABIES_TECHNOLOGY_INC                                                         BACnetVendorId = 685
	BACnetVendorId_UAB_KOMFOVENT                                                                BACnetVendorId = 686
	BACnetVendorId_MIRAE_ELECTRICAL_MFG_CO_LTD                                                  BACnetVendorId = 687
	BACnetVendorId_HUNTER_DOUGLAS_ARCHITECTURAL_PROJECTS_SCANDINAVIA_APS                        BACnetVendorId = 688
	BACnetVendorId_RUNPAQ_GROUP_CO_LTD                                                          BACnetVendorId = 689
	BACnetVendorId_UNICARDSA                                                                    BACnetVendorId = 690
	BACnetVendorId_IE_TECHNOLOGIES                                                              BACnetVendorId = 691
	BACnetVendorId_RUSKIN_MANUFACTURING                                                         BACnetVendorId = 692
	BACnetVendorId_CALON_ASSOCIATES_LIMITED                                                     BACnetVendorId = 693
	BACnetVendorId_CONTEC_CO_LTD                                                                BACnetVendorId = 694
	BACnetVendorId_IT_GMBH                                                                      BACnetVendorId = 695
	BACnetVendorId_AUTANI_CORPORATION                                                           BACnetVendorId = 696
	BACnetVendorId_CHRISTIAN_FORTIN                                                             BACnetVendorId = 697
	BACnetVendorId_HDL                                                                          BACnetVendorId = 698
	BACnetVendorId_IPID_SPZOO_LIMITED                                                           BACnetVendorId = 699
	BACnetVendorId_FUJI_ELECTRIC_CO_LTD                                                         BACnetVendorId = 700
	BACnetVendorId_VIEW_INC                                                                     BACnetVendorId = 701
	BACnetVendorId_SAMSUNGS1_CORPORATION                                                        BACnetVendorId = 702
	BACnetVendorId_NEW_LIFT                                                                     BACnetVendorId = 703
	BACnetVendorId_VRT_SYSTEMS                                                                  BACnetVendorId = 704
	BACnetVendorId_MOTION_CONTROL_ENGINEERING_INC                                               BACnetVendorId = 705
	BACnetVendorId_WEISS_KLIMATECHNIK_GMBH                                                      BACnetVendorId = 706
	BACnetVendorId_ELKON                                                                        BACnetVendorId = 707
	BACnetVendorId_ELIWELL_CONTROLS_SRL                                                         BACnetVendorId = 708
	BACnetVendorId_JAPAN_COMPUTER_TECHNOS_CORP                                                  BACnetVendorId = 709
	BACnetVendorId_RATIONAL_NETWORKEHF                                                          BACnetVendorId = 710
	BACnetVendorId_MAGNUM_ENERGY_SOLUTIONSLLC                                                   BACnetVendorId = 711
	BACnetVendorId_MEL_ROK                                                                      BACnetVendorId = 712
	BACnetVendorId_VAE_GROUP                                                                    BACnetVendorId = 713
	BACnetVendorId_LGCNS                                                                        BACnetVendorId = 714
	BACnetVendorId_BERGHOF_AUTOMATIONSTECHNIK_GMBH                                              BACnetVendorId = 715
	BACnetVendorId_QUARK_COMMUNICATIONS_INC                                                     BACnetVendorId = 716
	BACnetVendorId_SONTEX                                                                       BACnetVendorId = 717
	BACnetVendorId_MIVUNEAG                                                                     BACnetVendorId = 718
	BACnetVendorId_PANDUIT                                                                      BACnetVendorId = 719
	BACnetVendorId_SMART_CONTROLSLLC                                                            BACnetVendorId = 720
	BACnetVendorId_COMPU_AIRE_INC                                                               BACnetVendorId = 721
	BACnetVendorId_SIERRA                                                                       BACnetVendorId = 722
	BACnetVendorId_PROTO_SENSE_TECHNOLOGIES                                                     BACnetVendorId = 723
	BACnetVendorId_ELTRAC_TECHNOLOGIES_PVT_LTD                                                  BACnetVendorId = 724
	BACnetVendorId_BEKTAS_INVISIBLE_CONTROLS_GMBH                                               BACnetVendorId = 725
	BACnetVendorId_ENTELEC                                                                      BACnetVendorId = 726
	BACnetVendorId_INNEXIV                                                                      BACnetVendorId = 727
	BACnetVendorId_COVENANT                                                                     BACnetVendorId = 728
	BACnetVendorId_DAVITORAB                                                                    BACnetVendorId = 729
	BACnetVendorId_TONG_FANG_TECHNOVATOR                                                        BACnetVendorId = 730
	BACnetVendorId_BUILDING_ROBOTICS_INC                                                        BACnetVendorId = 731
	BACnetVendorId_HSSMSRUG                                                                     BACnetVendorId = 732
	BACnetVendorId_FRAM_TACKLLC                                                                 BACnetVendorId = 733
	BACnetVendorId_BL_ACOUSTICS_LTD                                                             BACnetVendorId = 734
	BACnetVendorId_TRAXXON_ROCK_DRILLS_LTD                                                      BACnetVendorId = 735
	BACnetVendorId_FRANKE                                                                       BACnetVendorId = 736
	BACnetVendorId_WURM_GMBH_CO                                                                 BACnetVendorId = 737
	BACnetVendorId_ADDENERGIE                                                                   BACnetVendorId = 738
	BACnetVendorId_MIRLE_AUTOMATION_CORPORATION                                                 BACnetVendorId = 739
	BACnetVendorId_IBIS_NETWORKS                                                                BACnetVendorId = 740
	BACnetVendorId_IDKART_ASRO                                                                  BACnetVendorId = 741
	BACnetVendorId_ANAREN_INC                                                                   BACnetVendorId = 742
	BACnetVendorId_SPAN_INCORPORATED                                                            BACnetVendorId = 743
	BACnetVendorId_BOSCH_THERMOTECHNOLOGY_CORP                                                  BACnetVendorId = 744
	BACnetVendorId_DRC_TECHNOLOGYSA                                                             BACnetVendorId = 745
	BACnetVendorId_SHANGHAI_ENERGY_BUILDING_TECHNOLOGY_CO_LTD                                   BACnetVendorId = 746
	BACnetVendorId_FRAPORTAG                                                                    BACnetVendorId = 747
	BACnetVendorId_FLOWGROUP                                                                    BACnetVendorId = 748
	BACnetVendorId_SKYTRON_ENERGY_GMBH                                                          BACnetVendorId = 749
	BACnetVendorId_ALTEL_WICHA_GOLDA_SPJ                                                        BACnetVendorId = 750
	BACnetVendorId_DRUPAL                                                                       BACnetVendorId = 751
	BACnetVendorId_AXIOMATIC_TECHNOLOGY_LTD                                                     BACnetVendorId = 752
	BACnetVendorId_BOHNKE_PARTNER                                                               BACnetVendorId = 753
	BACnetVendorId_FUNCTION1                                                                    BACnetVendorId = 754
	BACnetVendorId_OPTERGY_PTY_LTD                                                              BACnetVendorId = 755
	BACnetVendorId_LSI_VIRTICUS                                                                 BACnetVendorId = 756
	BACnetVendorId_KONZEPTPARK_GMBH                                                             BACnetVendorId = 757
	BACnetVendorId_NX_LIGHTING_CONTROLS                                                         BACnetVendorId = 758
	BACnetVendorId_E_CURV_INC                                                                   BACnetVendorId = 759
	BACnetVendorId_AGNOSYS_GMBH                                                                 BACnetVendorId = 760
	BACnetVendorId_SHANGHAI_SUNFULL_AUTOMATION_COLTD                                            BACnetVendorId = 761
	BACnetVendorId_KURZ_INSTRUMENTS_INC                                                         BACnetVendorId = 762
	BACnetVendorId_CIAS_ELETTRONICA_SRL                                                         BACnetVendorId = 763
	BACnetVendorId_MULTIAQUA_INC                                                                BACnetVendorId = 764
	BACnetVendorId_BLUE_BOX                                                                     BACnetVendorId = 765
	BACnetVendorId_SENSIDYNE                                                                    BACnetVendorId = 766
	BACnetVendorId_VIESSMANN_ELEKTRONIK_GMBH                                                    BACnetVendorId = 767
	BACnetVendorId_AD_FWEBCOMSRL                                                                BACnetVendorId = 768
	BACnetVendorId_GAYLORD_INDUSTRIES                                                           BACnetVendorId = 769
	BACnetVendorId_MAJUR_LTD                                                                    BACnetVendorId = 770
	BACnetVendorId_SHANGHAI_HUILIN_TECHNOLOGY_CO_LTD                                            BACnetVendorId = 771
	BACnetVendorId_EXOTRONIC                                                                    BACnetVendorId = 772
	BACnetVendorId_SAFECONTRO_LSRO                                                              BACnetVendorId = 773
	BACnetVendorId_AMATIS                                                                       BACnetVendorId = 774
	BACnetVendorId_UNIVERSAL_ELECTRIC_CORPORATION                                               BACnetVendorId = 775
	BACnetVendorId_IBA_CNET                                                                     BACnetVendorId = 776
	BACnetVendorId_SMARTRISE_ENGINEERING_INC                                                    BACnetVendorId = 778
	BACnetVendorId_MIRATRON_INC                                                                 BACnetVendorId = 779
	BACnetVendorId_SMART_EDGE                                                                   BACnetVendorId = 780
	BACnetVendorId_MITSUBISHI_ELECTRIC_AUSTRALIA_PTY_LTD                                        BACnetVendorId = 781
	BACnetVendorId_TRIANGLE_RESEARCH_INTERNATIONAL_PTD_LTD                                      BACnetVendorId = 782
	BACnetVendorId_PRODUAL_OY                                                                   BACnetVendorId = 783
	BACnetVendorId_MILESTONE_SYSTEMSAS                                                          BACnetVendorId = 784
	BACnetVendorId_TRUSTBRIDGE                                                                  BACnetVendorId = 785
	BACnetVendorId_FEEDBACK_SOLUTIONS                                                           BACnetVendorId = 786
	BACnetVendorId_IES                                                                          BACnetVendorId = 787
	BACnetVendorId_ABB_POWER_PROTECTIONSA                                                       BACnetVendorId = 788
	BACnetVendorId_RIPTIDEIO                                                                    BACnetVendorId = 789
	BACnetVendorId_MESSERSCHMITT_SYSTEMSAG                                                      BACnetVendorId = 790
	BACnetVendorId_DEZEM_ENERGY_CONTROLLING                                                     BACnetVendorId = 791
	BACnetVendorId_MECHO_SYSTEMS                                                                BACnetVendorId = 792
	BACnetVendorId_EVON_GMBH                                                                    BACnetVendorId = 793
	BACnetVendorId_CS_LAB_GMBH                                                                  BACnetVendorId = 794
	BACnetVendorId_N_0_ENTERPRISES_INC                                                          BACnetVendorId = 795
	BACnetVendorId_TOUCHE_CONTROLS                                                              BACnetVendorId = 796
	BACnetVendorId_ONTROL_TEKNIK_MALZEME_SANVE_TICAS                                            BACnetVendorId = 797
	BACnetVendorId_UNI_CONTROL_SYSTEM_SP_ZOO                                                    BACnetVendorId = 798
	BACnetVendorId_WEIHAI_PLOUMETER_CO_LTD                                                      BACnetVendorId = 799
	BACnetVendorId_ELCOM_INTERNATIONAL_PVT_LTD                                                  BACnetVendorId = 800
	BACnetVendorId_SIGNIFY                                                                      BACnetVendorId = 801
	BACnetVendorId_AUTOMATION_DIRECT                                                            BACnetVendorId = 802
	BACnetVendorId_PARAGON_ROBOTICS                                                             BACnetVendorId = 803
	BACnetVendorId_SMT_SYSTEM_MODULES_TECHNOLOGYAG                                              BACnetVendorId = 804
	BACnetVendorId_RADIX_IOTLLC                                                                 BACnetVendorId = 805
	BACnetVendorId_CMR_CONTROLS_LTD                                                             BACnetVendorId = 806
	BACnetVendorId_INNOVARI_INC                                                                 BACnetVendorId = 807
	BACnetVendorId_ABB_CONTROL_PRODUCTS                                                         BACnetVendorId = 808
	BACnetVendorId_GESELLSCHAFTFUR_GEBUDEAUTOMATIONMBH                                          BACnetVendorId = 809
	BACnetVendorId_RODI_SYSTEMS_CORP                                                            BACnetVendorId = 810
	BACnetVendorId_NEXTEK_POWER_SYSTEMS                                                         BACnetVendorId = 811
	BACnetVendorId_CREATIVE_LIGHTING                                                            BACnetVendorId = 812
	BACnetVendorId_WATER_FURNACE_INTERNATIONAL                                                  BACnetVendorId = 813
	BACnetVendorId_MERCURY_SECURITY                                                             BACnetVendorId = 814
	BACnetVendorId_HISENSE_SHANDONG_AIR_CONDITIONING_CO_LTD                                     BACnetVendorId = 815
	BACnetVendorId_LAYERED_SOLUTIONS_INC                                                        BACnetVendorId = 816
	BACnetVendorId_LEEGOOD_AUTOMATIC_SYSTEM_INC                                                 BACnetVendorId = 817
	BACnetVendorId_SHANGHAI_RESTAR_TECHNOLOGY_CO_LTD                                            BACnetVendorId = 818
	BACnetVendorId_REIMANN_INGENIEURBRO                                                         BACnetVendorId = 819
	BACnetVendorId_LYN_TEC                                                                      BACnetVendorId = 820
	BACnetVendorId_HTP                                                                          BACnetVendorId = 821
	BACnetVendorId_ELKOR_TECHNOLOGIES_INC                                                       BACnetVendorId = 822
	BACnetVendorId_BENTROL_PTY_LTD                                                              BACnetVendorId = 823
	BACnetVendorId_TEAM_CONTROL_OY                                                              BACnetVendorId = 824
	BACnetVendorId_NEXT_DEVICELLC                                                               BACnetVendorId = 825
	BACnetVendorId_ISMACONTROLLI_SPA                                                            BACnetVendorId = 826
	BACnetVendorId_KINGI_ELECTRONICS_CO_LTD                                                     BACnetVendorId = 827
	BACnetVendorId_SAMDAV                                                                       BACnetVendorId = 828
	BACnetVendorId_NEXT_GEN_INDUSTRIES_PVT_LTD                                                  BACnetVendorId = 829
	BACnetVendorId_ENTICLLC                                                                     BACnetVendorId = 830
	BACnetVendorId_ETAP                                                                         BACnetVendorId = 831
	BACnetVendorId_MORALLE_ELECTRONICS_LIMITED                                                  BACnetVendorId = 832
	BACnetVendorId_LEICOMAG                                                                     BACnetVendorId = 833
	BACnetVendorId_WATTS_REGULATOR_COMPANY                                                      BACnetVendorId = 834
	BACnetVendorId_SC_ORBTRONICSSRL                                                             BACnetVendorId = 835
	BACnetVendorId_GAUSSAN_TECHNOLOGIES                                                         BACnetVendorId = 836
	BACnetVendorId_WE_BFACTORY_GMBH                                                             BACnetVendorId = 837
	BACnetVendorId_OCEAN_CONTROLS                                                               BACnetVendorId = 838
	BACnetVendorId_MESSANA_AIR_RAY_CONDITIONINGSRL                                              BACnetVendorId = 839
	BACnetVendorId_HANGZHOUBATOWN_TECHNOLOGY_CO_LTD                                             BACnetVendorId = 840
	BACnetVendorId_REASONABLE_CONTROLS                                                          BACnetVendorId = 841
	BACnetVendorId_SERVISYS_INC                                                                 BACnetVendorId = 842
	BACnetVendorId_HALSTRUPWALCHER_GMBH                                                         BACnetVendorId = 843
	BACnetVendorId_SWG_AUTOMATION_FUZHOU_LIMITED                                                BACnetVendorId = 844
	BACnetVendorId_KSB_AKTIENGESELLSCHAFT                                                       BACnetVendorId = 845
	BACnetVendorId_HYBRYD_SPZOO                                                                 BACnetVendorId = 846
	BACnetVendorId_HELVATRONAG                                                                  BACnetVendorId = 847
	BACnetVendorId_ODERON_SPZOO                                                                 BACnetVendorId = 848
	BACnetVendorId_MIKOLAB                                                                      BACnetVendorId = 849
	BACnetVendorId_EXODRAFT                                                                     BACnetVendorId = 850
	BACnetVendorId_HOCHHUTH_GMBH                                                                BACnetVendorId = 851
	BACnetVendorId_INTEGRATED_SYSTEM_TECHNOLOGIES_LTD                                           BACnetVendorId = 852
	BACnetVendorId_SHANGHAI_CELLCONS_CONTROLS_CO_LTD                                            BACnetVendorId = 853
	BACnetVendorId_EMME_CONTROLSLLC                                                             BACnetVendorId = 854
	BACnetVendorId_FIELD_DIAGNOSTIC_SERVICES_INC                                                BACnetVendorId = 855
	BACnetVendorId_GES_TEKNIKAS                                                                 BACnetVendorId = 856
	BACnetVendorId_GLOBAL_POWER_PRODUCTS_INC                                                    BACnetVendorId = 857
	BACnetVendorId_OPTIONNV                                                                     BACnetVendorId = 858
	BACnetVendorId_BV_CONTROLAG                                                                 BACnetVendorId = 859
	BACnetVendorId_SIGREN_ENGINEERINGAG                                                         BACnetVendorId = 860
	BACnetVendorId_SHANGHAI_JALTONE_TECHNOLOGY_CO_LTD                                           BACnetVendorId = 861
	BACnetVendorId_MAX_LINE_SOLUTIONS_LTD                                                       BACnetVendorId = 862
	BACnetVendorId_KRON_INSTRUMENTOS_ELTRICOS_LTDA                                              BACnetVendorId = 863
	BACnetVendorId_THERMO_MATRIX                                                                BACnetVendorId = 864
	BACnetVendorId_INFINITE_AUTOMATION_SYSTEMS_INC                                              BACnetVendorId = 865
	BACnetVendorId_VANTAGE                                                                      BACnetVendorId = 866
	BACnetVendorId_ELECON_MEASUREMENTS_PVT_LTD                                                  BACnetVendorId = 867
	BACnetVendorId_TBA                                                                          BACnetVendorId = 868
	BACnetVendorId_CARNES_COMPANY                                                               BACnetVendorId = 869
	BACnetVendorId_HARMAN_PROFESSIONAL                                                          BACnetVendorId = 870
	BACnetVendorId_NENUTEC_ASIA_PACIFIC_PTE_LTD                                                 BACnetVendorId = 871
	BACnetVendorId_GIANV                                                                        BACnetVendorId = 872
	BACnetVendorId_KEPWARE_TEHNOLOGIES                                                          BACnetVendorId = 873
	BACnetVendorId_TEMPERATURE_ELECTRONICS_LTD                                                  BACnetVendorId = 874
	BACnetVendorId_PACKET_POWER                                                                 BACnetVendorId = 875
	BACnetVendorId_PROJECT_HAYSTACK_CORPORATION                                                 BACnetVendorId = 876
	BACnetVendorId_DEOS_CONTROLS_AMERICAS_INC                                                   BACnetVendorId = 877
	BACnetVendorId_SENSEWARE_INC                                                                BACnetVendorId = 878
	BACnetVendorId_MST_SYSTEMTECHNIKAG                                                          BACnetVendorId = 879
	BACnetVendorId_LONIX_LTD                                                                    BACnetVendorId = 880
	BACnetVendorId_GOSSEN_METRAWATT_GMBH                                                        BACnetVendorId = 881
	BACnetVendorId_AVIOSYS_INTERNATIONAL_INC                                                    BACnetVendorId = 882
	BACnetVendorId_EFFICIENT_BUILDING_AUTOMATION_CORP                                           BACnetVendorId = 883
	BACnetVendorId_ACCUTRON_INSTRUMENTS_INC                                                     BACnetVendorId = 884
	BACnetVendorId_VERMONT_ENERGY_CONTROL_SYSTEMSLLC                                            BACnetVendorId = 885
	BACnetVendorId_DCC_DYNAMICS                                                                 BACnetVendorId = 886
	BACnetVendorId_BEG_BRCK_ELECTRONIC_GMBH                                                     BACnetVendorId = 887
	BACnetVendorId_NGBS_HUNGARY_LTD                                                             BACnetVendorId = 889
	BACnetVendorId_ILLUM_TECHNOLOGYLLC                                                          BACnetVendorId = 890
	BACnetVendorId_DELTA_CONTROLS_GERMANY_LIMITED                                               BACnetVendorId = 891
	BACnetVendorId_ST_SERVICE_TECHNIQUESA                                                       BACnetVendorId = 892
	BACnetVendorId_SIMPLE_SOFT                                                                  BACnetVendorId = 893
	BACnetVendorId_ALTAIR_ENGINEERING                                                           BACnetVendorId = 894
	BACnetVendorId_EZEN_SOLUTION_INC                                                            BACnetVendorId = 895
	BACnetVendorId_FUJITEC_CO_LTD                                                               BACnetVendorId = 896
	BACnetVendorId_TERRALUX                                                                     BACnetVendorId = 897
	BACnetVendorId_ANNICOM                                                                      BACnetVendorId = 898
	BACnetVendorId_BIHL_WIEDEMANN_GMBH                                                          BACnetVendorId = 899
	BACnetVendorId_DRAPER_INC                                                                   BACnetVendorId = 900
	BACnetVendorId_SCHCO_INTERNATIONALKG                                                        BACnetVendorId = 901
	BACnetVendorId_OTIS_ELEVATOR_COMPANY                                                        BACnetVendorId = 902
	BACnetVendorId_FIDELIX_OY                                                                   BACnetVendorId = 903
	BACnetVendorId_RAM_GMBH_MESSUND_REGELTECHNIK                                                BACnetVendorId = 904
	BACnetVendorId_WEMS                                                                         BACnetVendorId = 905
	BACnetVendorId_RAVEL_ELECTRONICS_PVT_LTD                                                    BACnetVendorId = 906
	BACnetVendorId_OMNI_MAGNI                                                                   BACnetVendorId = 907
	BACnetVendorId_ECHELON                                                                      BACnetVendorId = 908
	BACnetVendorId_INTELLIMETER_CANADA_INC                                                      BACnetVendorId = 909
	BACnetVendorId_BITHOUSE_OY                                                                  BACnetVendorId = 910
	BACnetVendorId_BUILD_PULSE                                                                  BACnetVendorId = 912
	BACnetVendorId_SHENZHEN1000_BUILDING_AUTOMATION_CO_LTD                                      BACnetVendorId = 913
	BACnetVendorId_AED_ENGINEERING_GMBH                                                         BACnetVendorId = 914
	BACnetVendorId_GNTNER_GMBH_COKG                                                             BACnetVendorId = 915
	BACnetVendorId_KN_XLOGIC                                                                    BACnetVendorId = 916
	BACnetVendorId_CIM_ENVIRONMENTAL_GROUP                                                      BACnetVendorId = 917
	BACnetVendorId_FLOW_CONTROL                                                                 BACnetVendorId = 918
	BACnetVendorId_LUMEN_CACHE_INC                                                              BACnetVendorId = 919
	BACnetVendorId_ECOSYSTEM                                                                    BACnetVendorId = 920
	BACnetVendorId_POTTER_ELECTRIC_SIGNAL_COMPANYLLC                                            BACnetVendorId = 921
	BACnetVendorId_TYCO_FIRE_SECURITY_SPA                                                       BACnetVendorId = 922
	BACnetVendorId_WATANABE_ELECTRIC_INDUSTRY_CO_LTD                                            BACnetVendorId = 923
	BACnetVendorId_CAUSAM_ENERGY                                                                BACnetVendorId = 924
	BACnetVendorId_WTECAG                                                                       BACnetVendorId = 925
	BACnetVendorId_IMI_HYDRONIC_ENGINEERING_INTERNATIONALSA                                     BACnetVendorId = 926
	BACnetVendorId_ARIGO_SOFTWARE                                                               BACnetVendorId = 927
	BACnetVendorId_MSA_SAFETY1                                                                  BACnetVendorId = 928
	BACnetVendorId_SMART_SOLUCOES_LTDAMERCATO                                                   BACnetVendorId = 929
	BACnetVendorId_PIATRA_ENGINEERING                                                           BACnetVendorId = 930
	BACnetVendorId_ODIN_AUTOMATION_SYSTEMSLLC                                                   BACnetVendorId = 931
	BACnetVendorId_BELPARTSNV                                                                   BACnetVendorId = 932
	BACnetVendorId_UABSALDA                                                                     BACnetVendorId = 933
	BACnetVendorId_ALREIT_REGELTECHNIK_GMBH                                                     BACnetVendorId = 934
	BACnetVendorId_INGENIEURBROH_LERTES_GMBH_COKG                                               BACnetVendorId = 935
	BACnetVendorId_BREATHING_BUILDINGS                                                          BACnetVendorId = 936
	BACnetVendorId_EWONSA                                                                       BACnetVendorId = 937
	BACnetVendorId_CAV_UFF_GIACOMO_CIMBERIO_SPA                                                 BACnetVendorId = 938
	BACnetVendorId_PKE_ELECTRONICSAG                                                            BACnetVendorId = 939
	BACnetVendorId_ALLEN                                                                        BACnetVendorId = 940
	BACnetVendorId_KASTLE_SYSTEMS                                                               BACnetVendorId = 941
	BACnetVendorId_LOGICAL_ELECTRO_MECHANICALEM_SYSTEMS_INC                                     BACnetVendorId = 942
	BACnetVendorId_PP_KINETICS_INSTRUMENTSLLC                                                   BACnetVendorId = 943
	BACnetVendorId_CATHEXIS_TECHNOLOGIES                                                        BACnetVendorId = 944
	BACnetVendorId_SYLOPSP_ZOOSPK                                                               BACnetVendorId = 945
	BACnetVendorId_BRAUNS_CONTROL_GMBH                                                          BACnetVendorId = 946
	BACnetVendorId_OMRONSOCIALSOLUTIONSCOLTD                                                    BACnetVendorId = 947
	BACnetVendorId_WILDEBOER_BAUTEILE_GMBH                                                      BACnetVendorId = 948
	BACnetVendorId_SHANGHAI_BIENS_TECHNOLOGIES_LTD                                              BACnetVendorId = 949
	BACnetVendorId_BEIJINGHZHY_TECHNOLOGY_CO_LTD                                                BACnetVendorId = 950
	BACnetVendorId_BUILDING_CLOUDS                                                              BACnetVendorId = 951
	BACnetVendorId_THE_UNIVERSITYOF_SHEFFIELD_DEPARTMENTOF_ELECTRONICAND_ELECTRICAL_ENGINEERING BACnetVendorId = 952
	BACnetVendorId_FABTRONICS_AUSTRALIA_PTY_LTD                                                 BACnetVendorId = 953
	BACnetVendorId_SLAT                                                                         BACnetVendorId = 954
	BACnetVendorId_SOFTWARE_MOTOR_CORPORATION                                                   BACnetVendorId = 955
	BACnetVendorId_ARMSTRONG_INTERNATIONAL_INC                                                  BACnetVendorId = 956
	BACnetVendorId_STERIL_AIRE_INC                                                              BACnetVendorId = 957
	BACnetVendorId_INFINIQUE                                                                    BACnetVendorId = 958
	BACnetVendorId_ARCOM                                                                        BACnetVendorId = 959
	BACnetVendorId_ARGO_PERFORMANCE_LTD                                                         BACnetVendorId = 960
	BACnetVendorId_DIALIGHT                                                                     BACnetVendorId = 961
	BACnetVendorId_IDEAL_TECHNICAL_SOLUTIONS                                                    BACnetVendorId = 962
	BACnetVendorId_NEUROBATAG                                                                   BACnetVendorId = 963
	BACnetVendorId_NEYER_SOFTWARE_CONSULTINGLLC                                                 BACnetVendorId = 964
	BACnetVendorId_SCADA_TECHNOLOGY_DEVELOPMENT_CO_LTD                                          BACnetVendorId = 965
	BACnetVendorId_DEMAND_LOGIC_LIMITED                                                         BACnetVendorId = 966
	BACnetVendorId_GWA_GROUP_LIMITED                                                            BACnetVendorId = 967
	BACnetVendorId_OCCITALINE                                                                   BACnetVendorId = 968
	BACnetVendorId_NAO_DIGITAL_CO_LTD                                                           BACnetVendorId = 969
	BACnetVendorId_SHENZHEN_CHANSLINK_NETWORK_TECHNOLOGY_CO_LTD                                 BACnetVendorId = 970
	BACnetVendorId_SAMSUNG_ELECTRONICS_CO_LTD                                                   BACnetVendorId = 971
	BACnetVendorId_MESA_LABORATORIES_INC                                                        BACnetVendorId = 972
	BACnetVendorId_FISCHER                                                                      BACnetVendorId = 973
	BACnetVendorId_OP_SYS_SOLUTIONS_LTD                                                         BACnetVendorId = 974
	BACnetVendorId_ADVANCED_DEVICES_LIMITED                                                     BACnetVendorId = 975
	BACnetVendorId_CONDAIR                                                                      BACnetVendorId = 976
	BACnetVendorId_INELCOM_INGENIERIA_ELECTRONICA_COMERCIALSA                                   BACnetVendorId = 977
	BACnetVendorId_GRID_POINT_INC                                                               BACnetVendorId = 978
	BACnetVendorId_ADF_TECHNOLOGIES_SDN_BHD                                                     BACnetVendorId = 979
	BACnetVendorId_EPM_INC                                                                      BACnetVendorId = 980
	BACnetVendorId_LIGHTING_CONTROLS_LTD                                                        BACnetVendorId = 981
	BACnetVendorId_PERIX_CONTROLS_LTD                                                           BACnetVendorId = 982
	BACnetVendorId_AERCO_INTERNATIONAL_INC                                                      BACnetVendorId = 983
	BACnetVendorId_KONE_INC                                                                     BACnetVendorId = 984
	BACnetVendorId_ZIEHL_ABEGGSE                                                                BACnetVendorId = 985
	BACnetVendorId_ROBOTSA                                                                      BACnetVendorId = 986
	BACnetVendorId_OPTIGO_NETWORKS_INC                                                          BACnetVendorId = 987
	BACnetVendorId_OPENMOTICSBVBA                                                               BACnetVendorId = 988
	BACnetVendorId_METROPOLITAN_INDUSTRIES_INC                                                  BACnetVendorId = 989
	BACnetVendorId_HUAWEI_TECHNOLOGIES_CO_LTD                                                   BACnetVendorId = 990
	BACnetVendorId_DIGITAL_LUMENS_INC                                                           BACnetVendorId = 991
	BACnetVendorId_VANTI                                                                        BACnetVendorId = 992
	BACnetVendorId_CREE_LIGHTING                                                                BACnetVendorId = 993
	BACnetVendorId_RICHMOND_HEIGHTSSDNBHD                                                       BACnetVendorId = 994
	BACnetVendorId_PAYNE_SPARKMAN_LIGHTING_MANGEMENT                                            BACnetVendorId = 995
	BACnetVendorId_ASHCROFT                                                                     BACnetVendorId = 996
	BACnetVendorId_JET_CONTROLS_CORP                                                            BACnetVendorId = 997
	BACnetVendorId_ZUMTOBEL_LIGHTING_GMBH                                                       BACnetVendorId = 998
	BACnetVendorId_EKON_GMBH                                                                    BACnetVendorId = 1000
	BACnetVendorId_MOLEX                                                                        BACnetVendorId = 1001
	BACnetVendorId_MACO_LIGHTING_PTY_LTD                                                        BACnetVendorId = 1002
	BACnetVendorId_AXECON_CORP                                                                  BACnetVendorId = 1003
	BACnetVendorId_TENSORPLC                                                                    BACnetVendorId = 1004
	BACnetVendorId_KASEMAN_ENVIRONMENTAL_CONTROL_EQUIPMENT_SHANGHAI_LIMITED                     BACnetVendorId = 1005
	BACnetVendorId_AB_AXIS_INDUSTRIES                                                           BACnetVendorId = 1006
	BACnetVendorId_NETIX_CONTROLS                                                               BACnetVendorId = 1007
	BACnetVendorId_ELDRIDGE_PRODUCTS_INC                                                        BACnetVendorId = 1008
	BACnetVendorId_MICRONICS                                                                    BACnetVendorId = 1009
	BACnetVendorId_FORTECHO_SOLUTIONS_LTD                                                       BACnetVendorId = 1010
	BACnetVendorId_SELLERS_MANUFACTURING_COMPANY                                                BACnetVendorId = 1011
	BACnetVendorId_RITE_HITE_DOORS_INC                                                          BACnetVendorId = 1012
	BACnetVendorId_VIOLET_DEFENSELLC                                                            BACnetVendorId = 1013
	BACnetVendorId_SIMNA                                                                        BACnetVendorId = 1014
	BACnetVendorId_MULTINERGIE_BEST_INC                                                         BACnetVendorId = 1015
	BACnetVendorId_MEGA_SYSTEM_TECHNOLOGIES_INC                                                 BACnetVendorId = 1016
	BACnetVendorId_RHEEM                                                                        BACnetVendorId = 1017
	BACnetVendorId_ING_PUNZENBERGERCOPADATA_GMBH                                                BACnetVendorId = 1018
	BACnetVendorId_MEC_ELECTRONICS_GMBH                                                         BACnetVendorId = 1019
	BACnetVendorId_TACO_COMFORT_SOLUTIONS                                                       BACnetVendorId = 1020
	BACnetVendorId_ALEXANDER_MAIER_GMBH                                                         BACnetVendorId = 1021
	BACnetVendorId_ECORITHM_INC                                                                 BACnetVendorId = 1022
	BACnetVendorId_ACCURRO_LTD                                                                  BACnetVendorId = 1023
	BACnetVendorId_ROMTECK_AUSTRALIA_PTY_LTD                                                    BACnetVendorId = 1024
	BACnetVendorId_SPLASH_MONITORING_LIMITED                                                    BACnetVendorId = 1025
	BACnetVendorId_LIGHT_APPLICATION                                                            BACnetVendorId = 1026
	BACnetVendorId_LOGICAL_BUILDING_AUTOMATION                                                  BACnetVendorId = 1027
	BACnetVendorId_EXILIGHT_OY                                                                  BACnetVendorId = 1028
	BACnetVendorId_HAGER_ELECTROSAS                                                             BACnetVendorId = 1029
	BACnetVendorId_KLIF_COLTD                                                                   BACnetVendorId = 1030
	BACnetVendorId_HYGRO_MATIK                                                                  BACnetVendorId = 1031
	BACnetVendorId_DANIEL_MOUSSEAU_PROGRAMMATION_ELECTRONIQUE                                   BACnetVendorId = 1032
	BACnetVendorId_AERIONICS_INC                                                                BACnetVendorId = 1033
	BACnetVendorId_MS_ELECTRONIQUE_LTEE                                                         BACnetVendorId = 1034
	BACnetVendorId_AUTOMATION_COMPONENTS_INC                                                    BACnetVendorId = 1035
	BACnetVendorId_NIOBRARA_RESEARCH_DEVELOPMENT_CORPORATION                                    BACnetVendorId = 1036
	BACnetVendorId_NETCOM_SICHERHEITSTECHNIK_GMBH                                               BACnetVendorId = 1037
	BACnetVendorId_LUMELSA                                                                      BACnetVendorId = 1038
	BACnetVendorId_GREAT_PLAINS_INDUSTRIES_INC                                                  BACnetVendorId = 1039
	BACnetVendorId_DOMOTICA_LABSSRL                                                             BACnetVendorId = 1040
	BACnetVendorId_ENERGY_CLOUD_INC                                                             BACnetVendorId = 1041
	BACnetVendorId_VOMATEC                                                                      BACnetVendorId = 1042
	BACnetVendorId_DEMMA_COMPANIES                                                              BACnetVendorId = 1043
	BACnetVendorId_VALSENA                                                                      BACnetVendorId = 1044
	BACnetVendorId_COMSYS_BRTSCHAG                                                              BACnetVendorId = 1045
	BACnetVendorId_B_GRID                                                                       BACnetVendorId = 1046
	BACnetVendorId_MDJ_SOFTWARE_PTY_LTD                                                         BACnetVendorId = 1047
	BACnetVendorId_DIMONOFF_INC                                                                 BACnetVendorId = 1048
	BACnetVendorId_EDOMO_SYSTEMS_GMBH                                                           BACnetVendorId = 1049
	BACnetVendorId_EFFEKTIVLLC                                                                  BACnetVendorId = 1050
	BACnetVendorId_STEAMO_VAP                                                                   BACnetVendorId = 1051
	BACnetVendorId_GRANDCENTRIX_GMBH                                                            BACnetVendorId = 1052
	BACnetVendorId_WEINTEK_LABS_INC                                                             BACnetVendorId = 1053
	BACnetVendorId_INTEFOX_GMBH                                                                 BACnetVendorId = 1054
	BACnetVendorId_RADIUS_AUTOMATION_COMPANY                                                    BACnetVendorId = 1055
	BACnetVendorId_RINGDALE_INC                                                                 BACnetVendorId = 1056
	BACnetVendorId_IWAKI_AMERICA                                                                BACnetVendorId = 1057
	BACnetVendorId_BRACTLET                                                                     BACnetVendorId = 1058
	BACnetVendorId_STULZ_AIR_TECHNOLOGY_SYSTEMS_INC                                             BACnetVendorId = 1059
	BACnetVendorId_CLIMATE_READY_ENGINEERING_PTY_LTD                                            BACnetVendorId = 1060
	BACnetVendorId_GENEA_ENERGY_PARTNERS                                                        BACnetVendorId = 1061
	BACnetVendorId_IO_TALL_CHILE                                                                BACnetVendorId = 1062
	BACnetVendorId_IKS_CO_LTD                                                                   BACnetVendorId = 1063
	BACnetVendorId_YODIWOAB                                                                     BACnetVendorId = 1064
	BACnetVendorId_TITA_NELECTRONIC_GMBH                                                        BACnetVendorId = 1065
	BACnetVendorId_IDEC_CORPORATION                                                             BACnetVendorId = 1066
	BACnetVendorId_SIFRISL                                                                      BACnetVendorId = 1067
	BACnetVendorId_THERMAL_GAS_SYSTEMS_INC                                                      BACnetVendorId = 1068
	BACnetVendorId_BUILDING_AUTOMATION_PRODUCTS_INC                                             BACnetVendorId = 1069
	BACnetVendorId_ASSET_MAPPING                                                                BACnetVendorId = 1070
	BACnetVendorId_SMARTEH_COMPANY                                                              BACnetVendorId = 1071
	BACnetVendorId_DATAPOD_AUSTRALIA_PTY_LTD                                                    BACnetVendorId = 1072
	BACnetVendorId_BUILDINGS_ALIVE_PTY_LTD                                                      BACnetVendorId = 1073
	BACnetVendorId_DIGITAL_ELEKTRONIK                                                           BACnetVendorId = 1074
	BACnetVendorId_TALENT_AUTOMAOE_TECNOLOGIA_LTDA                                              BACnetVendorId = 1075
	BACnetVendorId_NORPOSH_LIMITED                                                              BACnetVendorId = 1076
	BACnetVendorId_MERKUR_FUNKSYSTEMEAG                                                         BACnetVendorId = 1077
	BACnetVendorId_FASTERC_ZSPOL_SRO                                                            BACnetVendorId = 1078
	BACnetVendorId_ECO_ADAPT                                                                    BACnetVendorId = 1079
	BACnetVendorId_ENERGOCENTRUM_PLUSSRO                                                        BACnetVendorId = 1080
	BACnetVendorId_AMBXUK_LTD                                                                   BACnetVendorId = 1081
	BACnetVendorId_WESTERN_RESERVE_CONTROLS_INC                                                 BACnetVendorId = 1082
	BACnetVendorId_LAYER_ZERO_POWER_SYSTEMS_INC                                                 BACnetVendorId = 1083
	BACnetVendorId_CIC_JAN_HEBECSRO                                                             BACnetVendorId = 1084
	BACnetVendorId_SIGROVBV                                                                     BACnetVendorId = 1085
	BACnetVendorId_ISYS_INTELLIGENT_SYSTEMS                                                     BACnetVendorId = 1086
	BACnetVendorId_GAS_DETECTION_AUSTRALIA_PTY_LTD                                              BACnetVendorId = 1087
	BACnetVendorId_KINCO_AUTOMATION_SHANGHAI_LTD                                                BACnetVendorId = 1088
	BACnetVendorId_LARS_ENERGYLLC                                                               BACnetVendorId = 1089
	BACnetVendorId_FLAMEFASTUK_LTD                                                              BACnetVendorId = 1090
	BACnetVendorId_ROYAL_SERVICE_AIR_CONDITIONING                                               BACnetVendorId = 1091
	BACnetVendorId_AMPIO_SP_ZOO                                                                 BACnetVendorId = 1092
	BACnetVendorId_INOVONICS_WIRELESS_CORPORATION                                               BACnetVendorId = 1093
	BACnetVendorId_NVENT_THERMAL_MANAGEMENT                                                     BACnetVendorId = 1094
	BACnetVendorId_SINOWELL_CONTROL_SYSTEM_LTD                                                  BACnetVendorId = 1095
	BACnetVendorId_MOXA_INC                                                                     BACnetVendorId = 1096
	BACnetVendorId_MATRIXI_CONTROLSDNBHD                                                        BACnetVendorId = 1097
	BACnetVendorId_PURPLE_SWIFT                                                                 BACnetVendorId = 1098
	BACnetVendorId_OTIM_TECHNOLOGIES                                                            BACnetVendorId = 1099
	BACnetVendorId_FLOW_MATE_LIMITED                                                            BACnetVendorId = 1100
	BACnetVendorId_DEGREE_CONTROLS_INC                                                          BACnetVendorId = 1101
	BACnetVendorId_FEI_XING_SHANGHAI_SOFTWARE_TECHNOLOGIES_CO_LTD                               BACnetVendorId = 1102
	BACnetVendorId_BERG_GMBH                                                                    BACnetVendorId = 1103
	BACnetVendorId_ARENZIT                                                                      BACnetVendorId = 1104
	BACnetVendorId_EDELSTROM_ELECTRONIC_DEVICES_DESIGNINGLLC                                    BACnetVendorId = 1105
	BACnetVendorId_DRIVE_CONNECTLLC                                                             BACnetVendorId = 1106
	BACnetVendorId_DEVELOP_NOW                                                                  BACnetVendorId = 1107
	BACnetVendorId_POORT                                                                        BACnetVendorId = 1108
	BACnetVendorId_VMEIL_INFORMATION_SHANGHAI_LTD                                               BACnetVendorId = 1109
	BACnetVendorId_RAYLEIGH_INSTRUMENTS                                                         BACnetVendorId = 1110
	BACnetVendorId_CODESYS_DEVELOPMENT                                                          BACnetVendorId = 1112
	BACnetVendorId_SMARTWARE_TECHNOLOGIES_GROUPLLC                                              BACnetVendorId = 1113
	BACnetVendorId_POLAR_BEAR_SOLUTIONS                                                         BACnetVendorId = 1114
	BACnetVendorId_CODRA                                                                        BACnetVendorId = 1115
	BACnetVendorId_PHAROS_ARCHITECTURAL_CONTROLS_LTD                                            BACnetVendorId = 1116
	BACnetVendorId_ENGI_NEAR_LTD                                                                BACnetVendorId = 1117
	BACnetVendorId_AD_HOC_ELECTRONICS                                                           BACnetVendorId = 1118
	BACnetVendorId_UNIFIED_MICROSYSTEMS                                                         BACnetVendorId = 1119
	BACnetVendorId_INDUSTRIEELEKTRONIK_BRANDENBURG_GMBH                                         BACnetVendorId = 1120
	BACnetVendorId_HARTMANN_GMBH                                                                BACnetVendorId = 1121
	BACnetVendorId_PISCADA                                                                      BACnetVendorId = 1122
	BACnetVendorId_KM_BSYSTEMSSRO                                                               BACnetVendorId = 1123
	BACnetVendorId_POWER_TECH_ENGINEERINGAS                                                     BACnetVendorId = 1124
	BACnetVendorId_TELEFONBAU_ARTHUR_SCHWABE_GMBH_COKG                                          BACnetVendorId = 1125
	BACnetVendorId_WUXI_FISTWELOVE_TECHNOLOGY_CO_LTD                                            BACnetVendorId = 1126
	BACnetVendorId_PRYSM                                                                        BACnetVendorId = 1127
	BACnetVendorId_STEINEL_GMBH                                                                 BACnetVendorId = 1128
	BACnetVendorId_GEORG_FISCHERJRGAG                                                           BACnetVendorId = 1129
	BACnetVendorId_MAKE_DEVELOPSL                                                               BACnetVendorId = 1130
	BACnetVendorId_MONNIT_CORPORATION                                                           BACnetVendorId = 1131
	BACnetVendorId_MIRROR_LIFE_CORPORATION                                                      BACnetVendorId = 1132
	BACnetVendorId_SECURE_METERS_LIMITED                                                        BACnetVendorId = 1133
	BACnetVendorId_PECO                                                                         BACnetVendorId = 1134
	BACnetVendorId_CCTECH_INC                                                                   BACnetVendorId = 1135
	BACnetVendorId_LIGHT_FI_LIMITED                                                             BACnetVendorId = 1136
	BACnetVendorId_NICE_SPA                                                                     BACnetVendorId = 1137
	BACnetVendorId_FIBER_SEN_SYS_INC                                                            BACnetVendorId = 1138
	BACnetVendorId_BD_BUCHTAUND_DEGEORGI                                                        BACnetVendorId = 1139
	BACnetVendorId_VENTACITY_SYSTEMS_INC                                                        BACnetVendorId = 1140
	BACnetVendorId_HITACHI_JOHNSON_CONTROLS_AIR_CONDITIONING_INC                                BACnetVendorId = 1141
	BACnetVendorId_SAGE_METERING_INC                                                            BACnetVendorId = 1142
	BACnetVendorId_ANDEL_LIMITED                                                                BACnetVendorId = 1143
	BACnetVendorId_ECO_SMART_TECHNOLOGIES                                                       BACnetVendorId = 1144
	BACnetVendorId_SET                                                                          BACnetVendorId = 1145
	BACnetVendorId_PROTEC_FIRE_DETECTION_SPAINSL                                                BACnetVendorId = 1146
	BACnetVendorId_AGRAMERUG                                                                    BACnetVendorId = 1147
	BACnetVendorId_ANYLINK_ELECTRONIC_GMBH                                                      BACnetVendorId = 1148
	BACnetVendorId_SCHINDLER_LTD                                                                BACnetVendorId = 1149
	BACnetVendorId_JIBREEL_ABDEEN_EST                                                           BACnetVendorId = 1150
	BACnetVendorId_FLUIDYNE_CONTROL_SYSTEMS_PVT_LTD                                             BACnetVendorId = 1151
	BACnetVendorId_PRISM_SYSTEMS_INC                                                            BACnetVendorId = 1152
	BACnetVendorId_ENERTIV                                                                      BACnetVendorId = 1153
	BACnetVendorId_MIRASOFT_GMBH_COKG                                                           BACnetVendorId = 1154
	BACnetVendorId_DUALTECHIT                                                                   BACnetVendorId = 1155
	BACnetVendorId_COUNTLOGICLLC                                                                BACnetVendorId = 1156
	BACnetVendorId_KOHLER                                                                       BACnetVendorId = 1157
	BACnetVendorId_CHEN_SEN_CONTROLS_CO_LTD                                                     BACnetVendorId = 1158
	BACnetVendorId_GREENHECK                                                                    BACnetVendorId = 1159
	BACnetVendorId_INTWINE_CONNECTLLC                                                           BACnetVendorId = 1160
	BACnetVendorId_KARLBORGS_ELKONTROLL                                                         BACnetVendorId = 1161
	BACnetVendorId_DATAKOM                                                                      BACnetVendorId = 1162
	BACnetVendorId_HOGA_CONTROLAS                                                               BACnetVendorId = 1163
	BACnetVendorId_COOL_AUTOMATION                                                              BACnetVendorId = 1164
	BACnetVendorId_INTER_SEARCH_CO_LTD                                                          BACnetVendorId = 1165
	BACnetVendorId_DABBEL_AUTOMATION_INTELLIGENCE_GMBH                                          BACnetVendorId = 1166
	BACnetVendorId_GADGEON_ENGINEERING_SMARTNESS                                                BACnetVendorId = 1167
	BACnetVendorId_COSTER_GROUP_SRL                                                             BACnetVendorId = 1168
	BACnetVendorId_WALTER_MLLERAG                                                               BACnetVendorId = 1169
	BACnetVendorId_FLUKE                                                                        BACnetVendorId = 1170
	BACnetVendorId_QUINTEX_SYSTEMS_LTD                                                          BACnetVendorId = 1171
	BACnetVendorId_SENFFICIENTSDNBHD                                                            BACnetVendorId = 1172
	BACnetVendorId_NUBEIO_OPERATIONS_PTY_LTD                                                    BACnetVendorId = 1173
	BACnetVendorId_DAS_INTEGRATOR_PTE_LTD                                                       BACnetVendorId = 1174
	BACnetVendorId_CREVIS_CO_LTD                                                                BACnetVendorId = 1175
	BACnetVendorId_I_SQUAREDSOFTWAREINC                                                         BACnetVendorId = 1176
	BACnetVendorId_KTG_GMBH                                                                     BACnetVendorId = 1177
	BACnetVendorId_POK_GROUP_OY                                                                 BACnetVendorId = 1178
	BACnetVendorId_ADISCOM                                                                      BACnetVendorId = 1179
	BACnetVendorId_INCUSENSE                                                                    BACnetVendorId = 1180
	BACnetVendorId_F                                                                            BACnetVendorId = 1181
	BACnetVendorId_ANORD_MARDIX_INC                                                             BACnetVendorId = 1182
	BACnetVendorId_HOSCH_GEBUDEAUTOMATION_NEUE_PRODUKTE_GMBH                                    BACnetVendorId = 1183
	BACnetVendorId_BOSCHIO_GMBH                                                                 BACnetVendorId = 1184
	BACnetVendorId_ROYAL_BOON_EDAM_INTERNATIONALBV                                              BACnetVendorId = 1185
	BACnetVendorId_CLACK_CORPORATION                                                            BACnetVendorId = 1186
	BACnetVendorId_UNITEX_CONTROLSLLC                                                           BACnetVendorId = 1187
	BACnetVendorId_KTC_GTEBORGAB                                                                BACnetVendorId = 1188
	BACnetVendorId_INTERZONAB                                                                   BACnetVendorId = 1189
	BACnetVendorId_ISDEINGSL                                                                    BACnetVendorId = 1190
	BACnetVendorId_AB_MAUTOMATIONBUILDINGMESSAGING_GMBH                                         BACnetVendorId = 1191
	BACnetVendorId_KENTEC_ELECTRONICS_LTD                                                       BACnetVendorId = 1192
	BACnetVendorId_COPELANDLP                                                                   BACnetVendorId = 1193
	BACnetVendorId_POWERSIDE                                                                    BACnetVendorId = 1194
	BACnetVendorId_SMC_GROUP                                                                    BACnetVendorId = 1195
	BACnetVendorId_EOS_WEATHER_INSTRUMENTS                                                      BACnetVendorId = 1196
	BACnetVendorId_ZONEX_SYSTEMS                                                                BACnetVendorId = 1197
	BACnetVendorId_GENEREX_SYSTEMS_COMPUTERVERTRIEBSGESELLSCHAFTMBH                             BACnetVendorId = 1198
	BACnetVendorId_ENERGY_WALLLLC                                                               BACnetVendorId = 1199
	BACnetVendorId_THERMOFIN                                                                    BACnetVendorId = 1200
	BACnetVendorId_SDATAWAYSA                                                                   BACnetVendorId = 1201
	BACnetVendorId_BIDDLE_AIR_SYSTEMS_LIMITED                                                   BACnetVendorId = 1202
	BACnetVendorId_KESSLER_ELLIS_PRODUCTS                                                       BACnetVendorId = 1203
	BACnetVendorId_THERMOSCREENS                                                                BACnetVendorId = 1204
	BACnetVendorId_MODIO                                                                        BACnetVendorId = 1205
	BACnetVendorId_NEWRON_SOLUTIONS                                                             BACnetVendorId = 1206
	BACnetVendorId_UNITRONICS                                                                   BACnetVendorId = 1207
	BACnetVendorId_TRILUX_GMBH_COKG                                                             BACnetVendorId = 1208
	BACnetVendorId_KOLLMORGEN_STEUERUNGSTECHNIK_GMBH                                            BACnetVendorId = 1209
	BACnetVendorId_BOSCH_REXROTHAG                                                              BACnetVendorId = 1210
	BACnetVendorId_ALARKO_CARRIER                                                               BACnetVendorId = 1211
	BACnetVendorId_VERDIGRIS_TECHNOLOGIES                                                       BACnetVendorId = 1212
	BACnetVendorId_SHANGHAISIIC_LONGCHUANG_SMARTECH_SO_LTD                                      BACnetVendorId = 1213
	BACnetVendorId_QUINDA_CO                                                                    BACnetVendorId = 1214
	BACnetVendorId_GRUNERAG                                                                     BACnetVendorId = 1215
	BACnetVendorId_BACMOVE                                                                      BACnetVendorId = 1216
	BACnetVendorId_PSIDACAB                                                                     BACnetVendorId = 1217
	BACnetVendorId_ISICON_CONTROL_AUTOMATION                                                    BACnetVendorId = 1218
	BACnetVendorId_BIG_ASS_FANS                                                                 BACnetVendorId = 1219
	BACnetVendorId_DIN_DIETMAR_NOCKER_FACILITY_MANAGEMENT_GMBH                                  BACnetVendorId = 1220
	BACnetVendorId_TELDIO                                                                       BACnetVendorId = 1221
	BACnetVendorId_MIKROKLIM_ASRO                                                               BACnetVendorId = 1222
	BACnetVendorId_DENSITY                                                                      BACnetVendorId = 1223
	BACnetVendorId_ICONAG_LEITTECHNIK_GMBH                                                      BACnetVendorId = 1224
	BACnetVendorId_AWAIR                                                                        BACnetVendorId = 1225
	BACnetVendorId_TD_ENGINEERING_LTD                                                           BACnetVendorId = 1226
	BACnetVendorId_SISTEMAS_DIGITALES                                                           BACnetVendorId = 1227
	BACnetVendorId_LOXONE_ELECTRONICS_GMBH                                                      BACnetVendorId = 1228
	BACnetVendorId_ACTRON_AIR                                                                   BACnetVendorId = 1229
	BACnetVendorId_INDUCTIVE_AUTOMATION                                                         BACnetVendorId = 1230
	BACnetVendorId_THOR_ENGINEERING_GMBH                                                        BACnetVendorId = 1231
	BACnetVendorId_BERNER_INTERNATIONALLLC                                                      BACnetVendorId = 1232
	BACnetVendorId_POTSDAM_SENSORSLLC                                                           BACnetVendorId = 1233
	BACnetVendorId_KOHLER_MIRA_LTD                                                              BACnetVendorId = 1234
	BACnetVendorId_TECOMON_GMBH                                                                 BACnetVendorId = 1235
	BACnetVendorId_TWO_DIMENSIONAL_INSTRUMENTSLLC                                               BACnetVendorId = 1236
	BACnetVendorId_LEFA_TECHNOLOGIES_PTE_LTD                                                    BACnetVendorId = 1237
	BACnetVendorId_EATONCEAG_NOTLICHTSYSTEME_GMBH                                               BACnetVendorId = 1238
	BACnetVendorId_COMMBOX_TECNOLOGIA                                                           BACnetVendorId = 1239
	BACnetVendorId_IP_VIDEO_CORPORATION                                                         BACnetVendorId = 1240
	BACnetVendorId_BENDER_GMBH_COKG                                                             BACnetVendorId = 1241
	BACnetVendorId_RHYMEBUS_CORPORATION                                                         BACnetVendorId = 1242
	BACnetVendorId_AXON_SYSTEMS_LTD                                                             BACnetVendorId = 1243
	BACnetVendorId_ENGINEERED_AIR                                                               BACnetVendorId = 1244
	BACnetVendorId_ELIPSE_SOFTWARE_LTDA                                                         BACnetVendorId = 1245
	BACnetVendorId_SIMATIX_BUILDING_TECHNOLOGIES_PVT_LTD                                        BACnetVendorId = 1246
	BACnetVendorId_WA_BENJAMIN_ELECTRIC_CO                                                      BACnetVendorId = 1247
	BACnetVendorId_TROX_AIR_CONDITIONING_COMPONENTS_SUZHOU_CO_LTD                               BACnetVendorId = 1248
	BACnetVendorId_SC_MEDICAL_PTY_LTD                                                           BACnetVendorId = 1249
	BACnetVendorId_ELCANICAS                                                                    BACnetVendorId = 1250
	BACnetVendorId_OBEOAS                                                                       BACnetVendorId = 1251
	BACnetVendorId_TAPA_INC                                                                     BACnetVendorId = 1252
	BACnetVendorId_ASE_SMART_ENERGY_INC                                                         BACnetVendorId = 1253
	BACnetVendorId_PERFORMANCE_SERVICES_INC                                                     BACnetVendorId = 1254
	BACnetVendorId_VERIDIFY_SECURITY                                                            BACnetVendorId = 1255
	BACnetVendorId_CD_INNOVATIONLTD                                                             BACnetVendorId = 1256
	BACnetVendorId_BEN_PEOPLES_INDUSTRIESLLC                                                    BACnetVendorId = 1257
	BACnetVendorId_UNICOMM_SPZOO                                                                BACnetVendorId = 1258
	BACnetVendorId_THING_TECHNOLOGIES_GMBH                                                      BACnetVendorId = 1259
	BACnetVendorId_BEIJING_HAILIN_CONTROL_TECHNOLOGY_INC                                        BACnetVendorId = 1260
	BACnetVendorId_DIGITAL_REALTY                                                               BACnetVendorId = 1261
	BACnetVendorId_AGROWTEK_INC                                                                 BACnetVendorId = 1262
	BACnetVendorId_DSP_INNOVATIONBV                                                             BACnetVendorId = 1263
	BACnetVendorId_STV_ELECTRONIC_GMBH                                                          BACnetVendorId = 1264
	BACnetVendorId_ELMEASURE_INDIA_PVT_LTD                                                      BACnetVendorId = 1265
	BACnetVendorId_PINESHORE_ENERGYLLC                                                          BACnetVendorId = 1266
	BACnetVendorId_BRASCH_ENVIRONMENTAL_TECHNOLOGIESLLC                                         BACnetVendorId = 1267
	BACnetVendorId_SHEN_ZHEN_ZHI_XING_BUILDING_TECH_CO_LTD                                      BACnetVendorId = 1268
	BACnetVendorId_SINUX                                                                        BACnetVendorId = 1269
	BACnetVendorId_AVNET_INC                                                                    BACnetVendorId = 1270
	BACnetVendorId_SOMFY_ACTIVITESSA                                                            BACnetVendorId = 1271
	BACnetVendorId_AMICO                                                                        BACnetVendorId = 1272
	BACnetVendorId_SAGE_GLASS                                                                   BACnetVendorId = 1273
	BACnetVendorId_AU_VERTE                                                                     BACnetVendorId = 1274
	BACnetVendorId_AGILE_CONNECTS_PVT_LTD                                                       BACnetVendorId = 1275
	BACnetVendorId_LOCIMATION_PTY_LTD                                                           BACnetVendorId = 1276
	BACnetVendorId_ENVIO_SYSTEMS_GMBH                                                           BACnetVendorId = 1277
	BACnetVendorId_VOYTECH_SYSTEMS_LIMITED                                                      BACnetVendorId = 1278
	BACnetVendorId_DAVIDSMEYERUND_PAUL_GMBH                                                     BACnetVendorId = 1279
	BACnetVendorId_LUSHER_ENGINEERING_SERVICES                                                  BACnetVendorId = 1280
	BACnetVendorId_CHNT_NANJING_TECHSEL_INTELLIGENT_COMPANYLTD                                  BACnetVendorId = 1281
	BACnetVendorId_THREETRONICS_PTY_LTD                                                         BACnetVendorId = 1282
	BACnetVendorId_SKY_FOUNDRYLLC                                                               BACnetVendorId = 1283
	BACnetVendorId_HANIL_PRO_TECH                                                               BACnetVendorId = 1284
	BACnetVendorId_SENSORSCALL                                                                  BACnetVendorId = 1285
	BACnetVendorId_SHANGHAI_JINGPU_INFORMATION_TECHNOLOGY_CO_LTD                                BACnetVendorId = 1286
	BACnetVendorId_LICHTMANUFAKTUR_BERLIN_GMBH                                                  BACnetVendorId = 1287
	BACnetVendorId_ECO_PARKING_TECHNOLOGIES                                                     BACnetVendorId = 1288
	BACnetVendorId_ENVISION_DIGITAL_INTERNATIONAL_PTE_LTD                                       BACnetVendorId = 1289
	BACnetVendorId_ANTONY_DEVELOPPEMENT_ELECTRONIQUE                                            BACnetVendorId = 1290
	BACnetVendorId_ISYSTEMS                                                                     BACnetVendorId = 1291
	BACnetVendorId_THUREON_INTERNATIONAL_LIMITED                                                BACnetVendorId = 1292
	BACnetVendorId_PULSAFEEDER                                                                  BACnetVendorId = 1293
	BACnetVendorId_MEGA_CHIPS_CORPORATION                                                       BACnetVendorId = 1294
	BACnetVendorId_TES_CONTROLS                                                                 BACnetVendorId = 1295
	BACnetVendorId_CERMATE                                                                      BACnetVendorId = 1296
	BACnetVendorId_GRAND_VALLEY_STATE_UNIVERSITY                                                BACnetVendorId = 1297
	BACnetVendorId_SYMCON_GMBH                                                                  BACnetVendorId = 1298
	BACnetVendorId_THE_CHICAGO_FAUCET_COMPANY                                                   BACnetVendorId = 1299
	BACnetVendorId_GEBERITAG                                                                    BACnetVendorId = 1300
	BACnetVendorId_REX_CONTROLS                                                                 BACnetVendorId = 1301
	BACnetVendorId_IVMS_GMBH                                                                    BACnetVendorId = 1302
	BACnetVendorId_MNPP_SATURN_LTD                                                              BACnetVendorId = 1303
	BACnetVendorId_REGAL_BELOIT                                                                 BACnetVendorId = 1304
	BACnetVendorId_ACS_AIR_CONDITIONING_SOLUTIONS                                               BACnetVendorId = 1305
	BACnetVendorId_GBX_TECHNOLOGYLLC                                                            BACnetVendorId = 1306
	BACnetVendorId_KAITERRA                                                                     BACnetVendorId = 1307
	BACnetVendorId_THIN_KUANLOT_TECHNOLOGY_SHANGHAI_CO_LTD                                      BACnetVendorId = 1308
	BACnetVendorId_HO_CO_STOBV                                                                  BACnetVendorId = 1309
	BACnetVendorId_SHENZHENASAI_TECHNOLOGY_CO_LTD                                               BACnetVendorId = 1310
	BACnetVendorId_RPS_SPA                                                                      BACnetVendorId = 1311
	BACnetVendorId_ESMSOLUTIONS                                                                 BACnetVendorId = 1312
	BACnetVendorId_IO_TECH_SYSTEMS_LIMITED                                                      BACnetVendorId = 1313
	BACnetVendorId_I_AUTO_LOGIC_CO_LTD                                                          BACnetVendorId = 1314
	BACnetVendorId_NEW_AGE_MICROLLC                                                             BACnetVendorId = 1315
	BACnetVendorId_GUARDIAN_GLASS                                                               BACnetVendorId = 1316
	BACnetVendorId_GUANGZHOU_ZHAOYU_INFORMATION_TECHNOLOGY                                      BACnetVendorId = 1317
	BACnetVendorId_ACE_IOT_SOLUTIONSLLC                                                         BACnetVendorId = 1318
	BACnetVendorId_PORIS_ELECTRONICS_CO_LTD                                                     BACnetVendorId = 1319
	BACnetVendorId_TERMINUS_TECHNOLOGIES_GROUP                                                  BACnetVendorId = 1320
	BACnetVendorId_INTECH1_INC                                                                  BACnetVendorId = 1321
	BACnetVendorId_ACCURATE_ELECTRONICS                                                         BACnetVendorId = 1322
	BACnetVendorId_FLUENCE_BIOENGINEERING                                                       BACnetVendorId = 1323
	BACnetVendorId_MUN_HEAN_SINGAPORE_PTE_LTD                                                   BACnetVendorId = 1324
	BACnetVendorId_KATRONICAG_COKG                                                              BACnetVendorId = 1325
	BACnetVendorId_SUZHOU_XIN_AO_INFORMATION_TECHNOLOGY_CO_LTD                                  BACnetVendorId = 1326
	BACnetVendorId_LINKTEKK_TECHNOLOGYJSC                                                       BACnetVendorId = 1327
	BACnetVendorId_STIRLING_ULTRACOLD                                                           BACnetVendorId = 1328
	BACnetVendorId_UV_PARTNERS_INC                                                              BACnetVendorId = 1329
	BACnetVendorId_PRO_MINENT_GMBH                                                              BACnetVendorId = 1330
	BACnetVendorId_MULTI_TECH_SYSTEMS_INC                                                       BACnetVendorId = 1331
	BACnetVendorId_JUMO_GMBH_COKG                                                               BACnetVendorId = 1332
	BACnetVendorId_QINGDAO_HUARUI_TECHNOLOGY_CO_LTD                                             BACnetVendorId = 1333
	BACnetVendorId_CAIRN_SYSTEMES                                                               BACnetVendorId = 1334
	BACnetVendorId_NEURO_LOGIC_RESEARCH_CORP                                                    BACnetVendorId = 1335
	BACnetVendorId_TRANSITION_TECHNOLOGIES_ADVANCED_SOLUTIONS_SPZOO                             BACnetVendorId = 1336
	BACnetVendorId_XXTERBV                                                                      BACnetVendorId = 1337
	BACnetVendorId_PASSIVE_LOGIC                                                                BACnetVendorId = 1338
	BACnetVendorId_EN_SMART_CONTROLS                                                            BACnetVendorId = 1339
	BACnetVendorId_WATTS_HEATINGAND_HOT_WATER_SOLUTIONSDBA_LYNC                                 BACnetVendorId = 1340
	BACnetVendorId_TROPOSPHAIRA_TECHNOLOGIESLLP                                                 BACnetVendorId = 1341
	BACnetVendorId_NETWORK_THERMOSTAT                                                           BACnetVendorId = 1342
	BACnetVendorId_TITANIUM_INTELLIGENT_SOLUTIONSLLC                                            BACnetVendorId = 1343
	BACnetVendorId_NUMA_PRODUCTSLLC                                                             BACnetVendorId = 1344
	BACnetVendorId_WAREMA_RENKHOFFSE                                                            BACnetVendorId = 1345
	BACnetVendorId_FRESEAS                                                                      BACnetVendorId = 1346
	BACnetVendorId_MAPPED                                                                       BACnetVendorId = 1347
	BACnetVendorId_ELEKTRODESIG_NVENTILATORYSRO                                                 BACnetVendorId = 1348
	BACnetVendorId_AIR_CARE_AUTOMATION_INC                                                      BACnetVendorId = 1349
	BACnetVendorId_ANTRUM                                                                       BACnetVendorId = 1350
	BACnetVendorId_BAO_LINH_CONNECT_TECHNOLOGY                                                  BACnetVendorId = 1351
	BACnetVendorId_VIRGINIA_CONTROLSLLC                                                         BACnetVendorId = 1352
	BACnetVendorId_DUOSYSSDNBHD                                                                 BACnetVendorId = 1353
	BACnetVendorId_ONSENSAS                                                                     BACnetVendorId = 1354
	BACnetVendorId_VAUGHN_THERMAL_CORPORATION                                                   BACnetVendorId = 1355
	BACnetVendorId_THERMOPLASTIC_ENGINEERING_LTDTPE                                             BACnetVendorId = 1356
	BACnetVendorId_WIRTH_RESEARCH_LTD                                                           BACnetVendorId = 1357
	BACnetVendorId_SST_AUTOMATION                                                               BACnetVendorId = 1358
	BACnetVendorId_SHANGHAI_BENCOL_ELECTRONIC_TECHNOLOGY_CO_LTD                                 BACnetVendorId = 1359
	BACnetVendorId_AIWAA_SYSTEMS_PRIVATE_LIMITED                                                BACnetVendorId = 1360
	BACnetVendorId_ENLESS_WIRELESS                                                              BACnetVendorId = 1361
	BACnetVendorId_OZUNO_ENGINEERING_PTY_LTD                                                    BACnetVendorId = 1362
	BACnetVendorId_HUBBELL_THE_ELECTRIC_HEATER_COMPANY                                          BACnetVendorId = 1363
	BACnetVendorId_INDUSTRIAL_TURNAROUND_CORPORATIONITAC                                        BACnetVendorId = 1364
	BACnetVendorId_WADSWORTH_CONTROL_SYSTEMS                                                    BACnetVendorId = 1365
	BACnetVendorId_SERVICES_HILO_INC                                                            BACnetVendorId = 1366
	BACnetVendorId_IDM_ENERGIESYSTEME_GMBH                                                      BACnetVendorId = 1367
	BACnetVendorId_BE_NEXTBV                                                                    BACnetVendorId = 1368
	BACnetVendorId_CLEAN_AIRAI_CORPORATION                                                      BACnetVendorId = 1369
	BACnetVendorId_REVOLUTION_MICROELECTRONICS_AMERICA_INC                                      BACnetVendorId = 1370
	BACnetVendorId_REAL_TIME_SYSTEMS_GMBH                                                       BACnetVendorId = 1371
	BACnetVendorId_ZED_BEE_TECHNOLOGIES_PVT_LTD                                                 BACnetVendorId = 1372
	BACnetVendorId_WIMATE_TECHNOLOGY_SOLUTIONS_PVT_LTD                                          BACnetVendorId = 1373
	BACnetVendorId_SENTICON_LTD                                                                 BACnetVendorId = 1374
	BACnetVendorId_ROSSAKERAB                                                                   BACnetVendorId = 1375
	BACnetVendorId_OPIT_SOLUTIONS_LTD                                                           BACnetVendorId = 1376
	BACnetVendorId_HOTOWELL_INTERNATIONAL_CO_LIMITED                                            BACnetVendorId = 1377
	BACnetVendorId_INIM_ELECTRONICSSRL_UNIPERSONALE                                             BACnetVendorId = 1378
	BACnetVendorId_AIRTHINGSASA                                                                 BACnetVendorId = 1379
	BACnetVendorId_ANALOG_DEVICES_INC                                                           BACnetVendorId = 1380
	BACnetVendorId_AI_DIRECTIONSDMCC                                                            BACnetVendorId = 1381
	BACnetVendorId_PRIMA_ELECTRO_SPA                                                            BACnetVendorId = 1382
	BACnetVendorId_KLT_CONTROL_SYSTEM_LTD                                                       BACnetVendorId = 1383
	BACnetVendorId_EVOLUTION_CONTROLS_INC                                                       BACnetVendorId = 1384
	BACnetVendorId_BEVER_INNOVATIONS                                                            BACnetVendorId = 1385
	BACnetVendorId_PELICAN_WIRELESS_SYSTEMS                                                     BACnetVendorId = 1386
	BACnetVendorId_CONTROL_CONCEPTS_INC                                                         BACnetVendorId = 1387
	BACnetVendorId_AUGMATIC_TECHNOLOGIES_PVT_LTD                                                BACnetVendorId = 1388
	BACnetVendorId_XIAMEN_MILESIGHTLOT_CO_LTD                                                   BACnetVendorId = 1389
	BACnetVendorId_TIANJIN_ANJIELOT_SCHIENCEAND_TECHNOLOGY_CO_LTD                               BACnetVendorId = 1390
	BACnetVendorId_GUANGZHOUS_ENERGY_ELECTRONICS_TECHNOLOGY_CO_LTD                              BACnetVendorId = 1391
	BACnetVendorId_AKVO_ATMOSPHERIC_WATER_SYSTEMS_PVT_LTD                                       BACnetVendorId = 1392
	BACnetVendorId_EM_FIRST_CO_LTD                                                              BACnetVendorId = 1393
	BACnetVendorId_IION_SYSTEMS_APS                                                             BACnetVendorId = 1394
	BACnetVendorId_SAF_TEHNIKAJSC                                                               BACnetVendorId = 1396
	BACnetVendorId_KOMFORTIQ_INC                                                                BACnetVendorId = 1397
	BACnetVendorId_COOL_TERA_LIMITED                                                            BACnetVendorId = 1398
	BACnetVendorId_HADRON_SOLUTIONS_SRLS                                                        BACnetVendorId = 1399
	BACnetVendorId_BITPOOL                                                                      BACnetVendorId = 1401
	BACnetVendorId_SONICULLC                                                                    BACnetVendorId = 1402
	BACnetVendorId_RISHABH_INSTRUMENTS_LIMITED                                                  BACnetVendorId = 1403
	BACnetVendorId_THING_WAREHOUSELLC                                                           BACnetVendorId = 1404
	BACnetVendorId_INNOFRIENDS_GMBH                                                             BACnetVendorId = 1405
	BACnetVendorId_METRONICAKP_SPJ                                                              BACnetVendorId = 1406
	BACnetVendorId_TECHKNAVE                                                                    BACnetVendorId = 1407
	BACnetVendorId_ELSNER_ELEKTRONIK                                                            BACnetVendorId = 1408
	BACnetVendorId_LEFOO_INDUSTRIAL_HANGZHOU_CO_LTD                                             BACnetVendorId = 1409
	BACnetVendorId_CALIBRATION_TECHNOLOGIES_INC                                                 BACnetVendorId = 1410
	BACnetVendorId_ALLORADO                                                                     BACnetVendorId = 1411
	BACnetVendorId_VERKADA                                                                      BACnetVendorId = 1412
	BACnetVendorId_WATTSENSE                                                                    BACnetVendorId = 1413
	BACnetVendorId_EMERSON_AUTOMATION_SOLUTIONS                                                 BACnetVendorId = 1414
	BACnetVendorId_GROWLINK                                                                     BACnetVendorId = 1415
	BACnetVendorId_OLYMPIA_ELECTRONICS                                                          BACnetVendorId = 1416
	BACnetVendorId_NORMAL_SOFTWARE_INC                                                          BACnetVendorId = 1417
	BACnetVendorId_ST_ENGINEERING_SOLUTIONJSC                                                   BACnetVendorId = 1418
	BACnetVendorId_INDUSTRIAL_FLOW_SOLUTIONS                                                    BACnetVendorId = 1419
	BACnetVendorId_UBIQISENSE_APS                                                               BACnetVendorId = 1420
	BACnetVendorId_TIGER_SOFT                                                                   BACnetVendorId = 1421
	BACnetVendorId_ECODOM_SRL                                                                   BACnetVendorId = 1422
	BACnetVendorId_BILGIPRO_IOT_SYSTEMS                                                         BACnetVendorId = 1423
	BACnetVendorId_PLANSPURNETDESIGN_GMBH                                                       BACnetVendorId = 1424
	BACnetVendorId_DOLPHIN_SOLUTIONS_LTD                                                        BACnetVendorId = 1425
	BACnetVendorId_MITSUBISHI_ELECTRIC_CORPORATION_KOBE_WORKS                                   BACnetVendorId = 1426
	BACnetVendorId_ECOVENA                                                                      BACnetVendorId = 1427
	BACnetVendorId_GREE_ELECTRIC_APPLIANCES_INCOF_ZHUHAI                                        BACnetVendorId = 1428
	BACnetVendorId_CONSPEC_CONTROLS                                                             BACnetVendorId = 1429
	BACnetVendorId_HANGZHOU_HIKVISION_DIGITAL_TECHNOLOGY_CO_LTD                                 BACnetVendorId = 1430
	BACnetVendorId_CRYSTAL_PEAK_SECURITY                                                        BACnetVendorId = 1431
	BACnetVendorId_PERM_ALERT                                                                   BACnetVendorId = 1432
	BACnetVendorId_ZHEJIANG_MISILIN_TECHNOLOGY_CO_LTD                                           BACnetVendorId = 1433
	BACnetVendorId_DEKKER_VACUUM_TECHNOLOGIES                                                   BACnetVendorId = 1434
	BACnetVendorId_EDWARDS_LIMITED                                                              BACnetVendorId = 1435
	BACnetVendorId_LEYBOLD_GMBH                                                                 BACnetVendorId = 1436
	BACnetVendorId_INTERNATIONAL_GAS_DETECTORS                                                  BACnetVendorId = 1437
	BACnetVendorId_ATLAS_COPCO_AIRPOWERNV                                                       BACnetVendorId = 1438
	BACnetVendorId_AIR_SENTRY_LIMITED                                                           BACnetVendorId = 1439
	BACnetVendorId_AELSYS                                                                       BACnetVendorId = 1440
	BACnetVendorId_GRANBY_CONSULTINGLLC                                                         BACnetVendorId = 1441
	BACnetVendorId_CLEVER_RELAY                                                                 BACnetVendorId = 1442
	BACnetVendorId_MONICO_MONITORING_INC                                                        BACnetVendorId = 1443
	BACnetVendorId_OQDO                                                                         BACnetVendorId = 1444
	BACnetVendorId_MATRIX_COMSEC_PRIVATE_LIMITED                                                BACnetVendorId = 1445
	BACnetVendorId_RESOURCE_SOLUTIONS                                                           BACnetVendorId = 1446
	BACnetVendorId_AMERICAN_GAS_SAFETYLLC                                                       BACnetVendorId = 1447
	BACnetVendorId_SS_NORTHERN_LTD                                                              BACnetVendorId = 1448
	BACnetVendorId_ULBIOS_TECHSENS                                                              BACnetVendorId = 1449
	BACnetVendorId_BOWERY_FARMING_INC                                                           BACnetVendorId = 1450
	BACnetVendorId_RYOBI_LIMITED                                                                BACnetVendorId = 1451
	BACnetVendorId_EKKO_SENSE_LTD                                                               BACnetVendorId = 1452
	BACnetVendorId_CLIMA_COOL                                                                   BACnetVendorId = 1453
	BACnetVendorId_GRID_CONNECT_INC                                                             BACnetVendorId = 1454
	BACnetVendorId_ZIEGLER_INSTRUMENTATIONUK_LTD                                                BACnetVendorId = 1455
	BACnetVendorId_CONTROL_TECLLC                                                               BACnetVendorId = 1456
	BACnetVendorId_AETERLINK_CORPORATION                                                        BACnetVendorId = 1457
	BACnetVendorId_ALPHA_EPSILON_AUTOMATION                                                     BACnetVendorId = 1458
	BACnetVendorId_ASTRALITE_INC                                                                BACnetVendorId = 1459
	BACnetVendorId_DELTA_FIRE_LTDA                                                              BACnetVendorId = 1460
	BACnetVendorId_BOCK_WATER_HEATERS_INC                                                       BACnetVendorId = 1461
	BACnetVendorId_CLEAVER_BROOKS                                                               BACnetVendorId = 1462
	BACnetVendorId_SCANALYTICS_INC                                                              BACnetVendorId = 1463
	BACnetVendorId_WILABS                                                                       BACnetVendorId = 1464
	BACnetVendorId_ACT_SYSTEM_CO_LTD                                                            BACnetVendorId = 1465
	BACnetVendorId_VERGE_SENSE                                                                  BACnetVendorId = 1466
	BACnetVendorId_SYSTEMAIR_MFG_INC                                                            BACnetVendorId = 1467
	BACnetVendorId_SEELEY_INTERNATIONAL                                                         BACnetVendorId = 1468
	BACnetVendorId_CRANE_BUILDING_SERVICES_UTILITIES                                            BACnetVendorId = 1469
	BACnetVendorId_BRADY_CORPORATION                                                            BACnetVendorId = 1470
	BACnetVendorId_QINGDAO_HISENSE_HITACHI_AIR_CONDITIONING_SYSTEMS_CO_LTD                      BACnetVendorId = 1471
	BACnetVendorId_GOLDEN_QUALITY_CO_LTD                                                        BACnetVendorId = 1472
	BACnetVendorId_ELVACOAB                                                                     BACnetVendorId = 1473
	BACnetVendorId_STRONG_TECHNOLOGYLLC                                                         BACnetVendorId = 1474
	BACnetVendorId_REC_ENVIRONMENTAL_TECHNOLOGY_GUANGZHOU_COMPANY_LIMITED                       BACnetVendorId = 1475
	BACnetVendorId_DISRUPTIVE_TECHNOLOGIES_RESEARCHAS                                           BACnetVendorId = 1476
	BACnetVendorId_NICO_CONSULTANCY_LIMITED                                                     BACnetVendorId = 1477
	BACnetVendorId_HORTENLOT_JIANGSU_CO_LTD                                                     BACnetVendorId = 1478
	BACnetVendorId_PAXTON_CONTROLS_CORP                                                         BACnetVendorId = 1479
	BACnetVendorId_FELL_TECHNOLOGYAS                                                            BACnetVendorId = 1480
	BACnetVendorId_SHLOK_INFORMATION_SYSTEMS_INDIA_PRIVATE_LIMITED                              BACnetVendorId = 1481
	BACnetVendorId_MICROGROPLC_LTD                                                              BACnetVendorId = 1482
	BACnetVendorId_CLOUDER_OY                                                                   BACnetVendorId = 1483
	BACnetVendorId_GEBUDE_AUTOMATISIERUNG_GMBH                                                  BACnetVendorId = 1484
	BACnetVendorId_SOLVIMUS_GMBH                                                                BACnetVendorId = 1485
	BACnetVendorId_GUANG_ZHOU_WANGKONG_LTD                                                      BACnetVendorId = 1486
	BACnetVendorId_SAFE_SQUARE_GMBH                                                             BACnetVendorId = 1487
	BACnetVendorId_HEKLATECHAB                                                                  BACnetVendorId = 1488
	BACnetVendorId_SILVAIR                                                                      BACnetVendorId = 1489
	BACnetVendorId_ADVECO                                                                       BACnetVendorId = 1490
	BACnetVendorId_EURA_DRIVES_ELECTRIC_CO_LTD                                                  BACnetVendorId = 1491
	BACnetVendorId_CALEB_CONTROLS                                                               BACnetVendorId = 1492
	BACnetVendorId_IN_BIOT_MONITORINGSL                                                         BACnetVendorId = 1493
	BACnetVendorId_QINGDAO_HAIER_AIR_CONDITIONER_ELECTRIC_CO_LTD                                BACnetVendorId = 1494
	BACnetVendorId_HANGZHOU_WEIYL_TECHNOLOGY_CO_LTD                                             BACnetVendorId = 1495
	BACnetVendorId_YORDSRL                                                                      BACnetVendorId = 1496
	BACnetVendorId_INFINITUM_ELECTRIC                                                           BACnetVendorId = 1497
	BACnetVendorId_RED_BEAN_SYSTEMS_LIMITED                                                     BACnetVendorId = 1498
	BACnetVendorId_BLUE_TIME_CONCEPTSA                                                          BACnetVendorId = 1499
	BACnetVendorId_SHENZHENINVT_ELECTRIC_CO_LTD                                                 BACnetVendorId = 1500
	BACnetVendorId_MESSUNG_SYSTEMS_PVT_LTD                                                      BACnetVendorId = 1501
	BACnetVendorId_ABB_ELECTRIFICATION_CANADA_INC                                               BACnetVendorId = 1502
	BACnetVendorId_CORE_CONTROLS                                                                BACnetVendorId = 1503
	BACnetVendorId_NOORD_TECHDOO                                                                BACnetVendorId = 1504
	BACnetVendorId_VARIBITSAS                                                                   BACnetVendorId = 1505
	BACnetVendorId_ROGER_SPZOOSPK                                                               BACnetVendorId = 1506
	BACnetVendorId_VIEGA_GMBH_COKG                                                              BACnetVendorId = 1507
	BACnetVendorId_ASTERSOFT                                                                    BACnetVendorId = 1508
	BACnetVendorId_BIGEU                                                                        BACnetVendorId = 1509
	BACnetVendorId_INFERRIX_LIMITED                                                             BACnetVendorId = 1510
	BACnetVendorId_RICHARDS_ELECTRIC_MOTOR_CO                                                   BACnetVendorId = 1511
	BACnetVendorId_DAPP_CONTROLS                                                                BACnetVendorId = 1512
	BACnetVendorId_ENTOUCH_CONTROLS                                                             BACnetVendorId = 1513
	BACnetVendorId_MAVILI_ELEKTRONIK_TICARETVE_SANAYI_ANONIM_SIRKETI                            BACnetVendorId = 1514
	BACnetVendorId_BUBBLY_NET                                                                   BACnetVendorId = 1515
	BACnetVendorId_AL_MAYSSAN_TECHNICAL_SERVICES_CO_LTD                                         BACnetVendorId = 1516
	BACnetVendorId_VIRIDI_PARENTE_INC                                                           BACnetVendorId = 1517
	BACnetVendorId_NOVEL_APPS_CORP                                                              BACnetVendorId = 1518
	BACnetVendorId_OVENTROP_CHINAHVAC_SYSTEM_TECHNOLOGY_CO_LTD                                  BACnetVendorId = 1519
	BACnetVendorId_LACROIX_SOFREL                                                               BACnetVendorId = 1521
	BACnetVendorId_MACHINE_SENSLOT_TRADING_COLLC                                                BACnetVendorId = 1522
	BACnetVendorId_ELMEC_INC                                                                    BACnetVendorId = 1523
	BACnetVendorId_BEIJING_HAISHI_SOFTWARE_CO_LTD                                               BACnetVendorId = 1524
	BACnetVendorId_RADIX_ELECTROSYSTEMS_PVT_LTD                                                 BACnetVendorId = 1525
	BACnetVendorId_VRMEBARONENAB                                                                BACnetVendorId = 1526
	BACnetVendorId_TREAU_INCDBA_GRADIENT                                                        BACnetVendorId = 1527
	BACnetVendorId_WEST_SOLUTIONAG                                                              BACnetVendorId = 1528
	BACnetVendorId_TRUEWAY_CONTROLS_HONGKONG_LIMITED                                            BACnetVendorId = 1529
	BACnetVendorId_BUILDING_LOGIX                                                               BACnetVendorId = 1530
	BACnetVendorId_IFESCA_GMBH                                                                  BACnetVendorId = 1531
	BACnetVendorId_FELLOWES_INC                                                                 BACnetVendorId = 1532
	BACnetVendorId_CALEFFI_SPA                                                                  BACnetVendorId = 1533
	BACnetVendorId_JDRF_ELECTROMAG                                                              BACnetVendorId = 1534
	BACnetVendorId_REDWIRE_LABS                                                                 BACnetVendorId = 1535
	BACnetVendorId_WECON_TECHNOLOGY_CO_LTD                                                      BACnetVendorId = 1536
	BACnetVendorId_ACACIA_GREEN_TECHNOLOGIES_LTD                                                BACnetVendorId = 1537
	BACnetVendorId_DEGREE_ANALYTICS                                                             BACnetVendorId = 1538
	BACnetVendorId_ROLTEK_TEKNOLOJIAS                                                           BACnetVendorId = 1539
	BACnetVendorId_DIGITAL_CONTROL_TECHNOLOGY_LIMITED                                           BACnetVendorId = 1540
	BACnetVendorId_KENTIMAAB                                                                    BACnetVendorId = 1541
	BACnetVendorId_PERGAMON_PERCEPTIVE_TECHNOLOGIES                                             BACnetVendorId = 1542
	BACnetVendorId_PREFECT_CONTROLS_LTD                                                         BACnetVendorId = 1543
	BACnetVendorId_SEN_TECH_CORPORATION                                                         BACnetVendorId = 1544
	BACnetVendorId_SS_REGELTECHNIK_GMBH                                                         BACnetVendorId = 1545
	BACnetVendorId_AIR_BOX_INC                                                                  BACnetVendorId = 1546
	BACnetVendorId_RVE                                                                          BACnetVendorId = 1547
	BACnetVendorId_MOTOROLA_SOLUTIONS                                                           BACnetVendorId = 1548
	BACnetVendorId_BACSYS_INNOVATIONS_PRIVATE_LIMITED                                           BACnetVendorId = 1549
	BACnetVendorId_EWATTCH                                                                      BACnetVendorId = 1550
	BACnetVendorId_BUILTLAYERLLC                                                                BACnetVendorId = 1551
	BACnetVendorId_AG_DOMOTIXSRL                                                                BACnetVendorId = 1552
	BACnetVendorId_HYTRONIK_INDUSTRIAL_LIMITED                                                  BACnetVendorId = 1553
	BACnetVendorId_WHO_REINRAUMTECHNIK                                                          BACnetVendorId = 1554
	BACnetVendorId_TRICO_LIMITED                                                                BACnetVendorId = 1555
	BACnetVendorId_SLK_AUTOMATIONSRL                                                            BACnetVendorId = 1556
	BACnetVendorId_ZAPHIREAS                                                                    BACnetVendorId = 1557
	BACnetVendorId_AJ_MANUFACTURING                                                             BACnetVendorId = 1558
	BACnetVendorId_FUTURE_MOTORS_LTD                                                            BACnetVendorId = 1559
	BACnetVendorId_HIMEL_HONG_KONG_LIMITED                                                      BACnetVendorId = 1560
	BACnetVendorId_SHENZHEN_SUNRICHER_TECHNOLOGY_CO_LTD                                         BACnetVendorId = 1561
	BACnetVendorId_ACTILITYSA                                                                   BACnetVendorId = 1562
	BACnetVendorId_OY_HALTON_GROUP_LTD                                                          BACnetVendorId = 1563
	BACnetVendorId_AVTECH_SOFTWARE_INC                                                          BACnetVendorId = 1564
	BACnetVendorId_IN_CONTROL_ENGINEERINGLLC                                                    BACnetVendorId = 1565
	BACnetVendorId_SOUND_WATER_TECHNOLOGIESLLC                                                  BACnetVendorId = 1566
	BACnetVendorId_UNKNOWN_VENDOR                                                               BACnetVendorId = 0xFFFF
)

var BACnetVendorIdValues []BACnetVendorId

func init() {
	_ = errors.New
	BACnetVendorIdValues = []BACnetVendorId{
		BACnetVendorId_ASHRAE,
		BACnetVendorId_NIST,
		BACnetVendorId_THE_TRANE_COMPANY,
		BACnetVendorId_DAIKIN_APPLIED_AMERICAS,
		BACnetVendorId_POLAR_SOFT,
		BACnetVendorId_JOHNSON_CONTROLS_INC,
		BACnetVendorId_ABB_FORMERLY_AMERICAN_AUTO_MATRIX,
		BACnetVendorId_SIEMENS_SCHWEIZAG,
		BACnetVendorId_DELTA_CONTROLS,
		BACnetVendorId_SIEMENS_SCHWEIZAG1,
		BACnetVendorId_SCHNEIDER_ELECTRIC,
		BACnetVendorId_TAC,
		BACnetVendorId_ORION_ANALYSIS_CORPORATION,
		BACnetVendorId_TELETROL_SYSTEMS_INC,
		BACnetVendorId_CIMETRICS_TECHNOLOGY,
		BACnetVendorId_CORNELL_UNIVERSITY,
		BACnetVendorId_UNITED_TECHNOLOGIES_CARRIER,
		BACnetVendorId_HONEYWELL_INC,
		BACnetVendorId_ALERTON_HONEYWELL,
		BACnetVendorId_TACAB,
		BACnetVendorId_HEWLETT_PACKARD_COMPANY,
		BACnetVendorId_DORSETTES_INC,
		BACnetVendorId_SIEMENS_SCHWEIZAG2,
		BACnetVendorId_YORK_CONTROLS_GROUP,
		BACnetVendorId_AUTOMATED_LOGIC_CORPORATION,
		BACnetVendorId_CSI_CONTROL_SYSTEMS_INTERNATIONAL,
		BACnetVendorId_PHOENIX_CONTROLS_CORPORATION,
		BACnetVendorId_INNOVEX_TECHNOLOGIES_INC,
		BACnetVendorId_KMC_CONTROLS_INC,
		BACnetVendorId_XN_TECHNOLOGIES_INC,
		BACnetVendorId_HYUNDAI_INFORMATION_TECHNOLOGY_CO_LTD,
		BACnetVendorId_TOKIMEC_INC,
		BACnetVendorId_SIMPLEX,
		BACnetVendorId_NORTH_BUILDING_TECHNOLOGIES_LIMITED,
		BACnetVendorId_NOTIFIER,
		BACnetVendorId_RELIABLE_CONTROLS_CORPORATION,
		BACnetVendorId_TRIDIUM_INC,
		BACnetVendorId_MSA_SAFETY,
		BACnetVendorId_SILICON_ENERGY,
		BACnetVendorId_KIEBACK_PETER_GMBH_COKG,
		BACnetVendorId_ANACON_SYSTEMS_INC,
		BACnetVendorId_SYSTEMS_CONTROLS_INSTRUMENTSLLC,
		BACnetVendorId_ACUITY_BRANDS_LIGHTING_INC,
		BACnetVendorId_MICROPOWER_MANUFACTURING,
		BACnetVendorId_MATRIX_CONTROLS,
		BACnetVendorId_METALAIRE,
		BACnetVendorId_ESS_ENGINEERING,
		BACnetVendorId_SPHERE_SYSTEMS_PTY_LTD,
		BACnetVendorId_WALKER_TECHNOLOGIES_CORPORATION,
		BACnetVendorId_HI_SOLUTIONS_INC,
		BACnetVendorId_MBS_GMBH,
		BACnetVendorId_SAMSONAG,
		BACnetVendorId_BADGER_METER_INC,
		BACnetVendorId_DAIKIN_INDUSTRIES_LTD,
		BACnetVendorId_NARA_CONTROLS_INC,
		BACnetVendorId_MAMMOTH_INC,
		BACnetVendorId_LIEBERT_CORPORATION,
		BACnetVendorId_SEMCO_INCORPORATED,
		BACnetVendorId_AIR_MONITOR_CORPORATION,
		BACnetVendorId_TRIATEKLLC,
		BACnetVendorId_NEX_LIGHT,
		BACnetVendorId_MULTISTACK,
		BACnetVendorId_TSI_INCORPORATED,
		BACnetVendorId_WEATHER_RITE_INC,
		BACnetVendorId_DUNHAM_BUSH,
		BACnetVendorId_RELIANCE_ELECTRIC,
		BACnetVendorId_LCS_INC,
		BACnetVendorId_REGULATOR_AUSTRALIAPTY_LTD,
		BACnetVendorId_TOUCH_PLATE_LIGHTING_CONTROLS,
		BACnetVendorId_AMANN_GMBH,
		BACnetVendorId_RLE_TECHNOLOGIES,
		BACnetVendorId_CARDKEY_SYSTEMS,
		BACnetVendorId_SECOM_CO_LTD,
		BACnetVendorId_ABB_GEBUDETECHNIKAG_BEREICH_NET_SERV,
		BACnetVendorId_KNX_ASSOCIATIONCVBA,
		BACnetVendorId_INSTITUTEOF_ELECTRICAL_INSTALLATION_ENGINEERSOF_JAPANIEIEJ,
		BACnetVendorId_NOHMI_BOSAI_LTD,
		BACnetVendorId_CAREL_INDUSTRIES_SPA,
		BACnetVendorId_UTC_FIRE_SECURITY_ESPAASL,
		BACnetVendorId_HOCHIKI_CORPORATION,
		BACnetVendorId_FR_SAUTERAG,
		BACnetVendorId_MATSUSHITA_ELECTRIC_WORKS_LTD,
		BACnetVendorId_MITSUBISHI_ELECTRIC_CORPORATION_INAZAWA_WORKS,
		BACnetVendorId_MITSUBISHI_HEAVY_INDUSTRIES_LTD,
		BACnetVendorId_XYLEM_INC,
		BACnetVendorId_YAMATAKE_BUILDING_SYSTEMS_CO_LTD,
		BACnetVendorId_THE_WATT_STOPPER_INC,
		BACnetVendorId_AICHI_TOKEI_DENKI_CO_LTD,
		BACnetVendorId_ACTIVATION_TECHNOLOGIESLLC,
		BACnetVendorId_SAIA_BURGESS_CONTROLS_LTD,
		BACnetVendorId_HITACHI_LTD,
		BACnetVendorId_NOVAR_CORP_TREND_CONTROL_SYSTEMS_LTD,
		BACnetVendorId_MITSUBISHI_ELECTRIC_LIGHTING_CORPORATION,
		BACnetVendorId_ARGUS_CONTROL_SYSTEMS_LTD,
		BACnetVendorId_KYUKI_CORPORATION,
		BACnetVendorId_RICHARDS_ZETA_BUILDING_INTELLIGENCE_INC,
		BACnetVendorId_SCIENTECHRD_INC,
		BACnetVendorId_VCI_CONTROLS_INC,
		BACnetVendorId_TOSHIBA_CORPORATION,
		BACnetVendorId_MITSUBISHI_ELECTRIC_CORPORATION_AIR_CONDITIONING_REFRIGERATION_SYSTEMS_WORKS,
		BACnetVendorId_CUSTOM_MECHANICAL_EQUIPMENTLLC,
		BACnetVendorId_CLIMATE_MASTER,
		BACnetVendorId_ICP_PANEL_TEC_INC,
		BACnetVendorId_D_TEK_CONTROLS,
		BACnetVendorId_NEC_ENGINEERING_LTD,
		BACnetVendorId_PRIVABV,
		BACnetVendorId_MEIDENSHA_CORPORATION,
		BACnetVendorId_JCI_SYSTEMS_INTEGRATION_SERVICES,
		BACnetVendorId_FREEDOM_CORPORATION,
		BACnetVendorId_NEUBERGER_GEBUDEAUTOMATION_GMBH,
		BACnetVendorId_E_ZI_CONTROLS,
		BACnetVendorId_LEVITON_MANUFACTURING,
		BACnetVendorId_FUJITSU_LIMITED,
		BACnetVendorId_VERTIV_FORMERLY_EMERSON_NETWORK_POWER,
		BACnetVendorId_SA_ARMSTRONG_LTD,
		BACnetVendorId_VISONETAG,
		BACnetVendorId_MM_SYSTEMS_INC,
		BACnetVendorId_CUSTOM_SOFTWARE_ENGINEERING,
		BACnetVendorId_NITTAN_COMPANY_LIMITED,
		BACnetVendorId_ELUTIONS_INC_WIZCON_SYSTEMSSAS,
		BACnetVendorId_PACOM_SYSTEMS_PTY_LTD,
		BACnetVendorId_UNICO_INC,
		BACnetVendorId_EBTRON_INC,
		BACnetVendorId_SCADA_ENGINE,
		BACnetVendorId_LENZE_AMERICAS_FORMERLYAC_TECHNOLOGY_CORPORATION,
		BACnetVendorId_EAGLE_TECHNOLOGY,
		BACnetVendorId_DATA_AIRE_INC,
		BACnetVendorId_ABB_INC,
		BACnetVendorId_TRANSBIT_SPZOO,
		BACnetVendorId_CARRIER_JAPAN_CORPORATION,
		BACnetVendorId_SHENZHEN_JUNZHI_HI_TECH_CO_LTD,
		BACnetVendorId_TOKAI_SOFT,
		BACnetVendorId_BLUE_RIDGE_TECHNOLOGIES,
		BACnetVendorId_VERIS_INDUSTRIES,
		BACnetVendorId_CENTAURUS_PRIME,
		BACnetVendorId_SAND_NETWORK_SYSTEMS,
		BACnetVendorId_REGULVAR_INC,
		BACnetVendorId_AF_DTEK_DIVISIONOF_FASTEK_INTERNATIONAL_INC,
		BACnetVendorId_POWER_COLD_COMFORT_AIR_SOLUTIONS_INC,
		BACnetVendorId_I_CONTROLS,
		BACnetVendorId_VICONICS_ELECTRONICS_INC,
		BACnetVendorId_YASKAWA_AMERICA_INC,
		BACnetVendorId_DEO_SCONTROLSYSTEMS_GMBH,
		BACnetVendorId_DIGITALE_MESSUND_STEUERSYSTEMEAG,
		BACnetVendorId_FUJITSU_GENERAL_LIMITED,
		BACnetVendorId_PROJECT_ENGINEERING_SRL,
		BACnetVendorId_SANYO_ELECTRIC_CO_LTD,
		BACnetVendorId_INTEGRATED_INFORMATION_SYSTEMS_INC,
		BACnetVendorId_TEMCO_CONTROLS_LTD,
		BACnetVendorId_AIRTEK_INTERNATIONAL_INC,
		BACnetVendorId_ADVANTECH_CORPORATION,
		BACnetVendorId_TITAN_PRODUCTS_LTD,
		BACnetVendorId_REGEL_PARTNERS,
		BACnetVendorId_NATIONAL_ENVIRONMENTAL_PRODUCT,
		BACnetVendorId_UNITEC_CORPORATION,
		BACnetVendorId_KANDEN_ENGINEERING_COMPANY,
		BACnetVendorId_MESSNER_GEBUDETECHNIK_GMBH,
		BACnetVendorId_INTEGRATEDCH,
		BACnetVendorId_PRICE_INDUSTRIES,
		BACnetVendorId_SE_ELEKTRONIC_GMBH,
		BACnetVendorId_ROCKWELL_AUTOMATION,
		BACnetVendorId_ENFLEX_CORP,
		BACnetVendorId_ASI_CONTROLS,
		BACnetVendorId_SYS_MIK_GMBH_DRESDEN,
		BACnetVendorId_HSC_REGELUNGSTECHNIK_GMBH,
		BACnetVendorId_SMART_TEMP_AUSTRALIA_PTY_LTD,
		BACnetVendorId_COOPER_CONTROLS,
		BACnetVendorId_DUKSAN_MECASYS_CO_LTD,
		BACnetVendorId_FUJIIT_CO_LTD,
		BACnetVendorId_VACON_PLC,
		BACnetVendorId_LEADER_CONTROLS,
		BACnetVendorId_ABB_FORMERLY_CYLON_CONTROLS_LTD,
		BACnetVendorId_COMPAS,
		BACnetVendorId_MITSUBISHI_ELECTRIC_BUILDING_TECHNO_SERVICE_CO_LTD,
		BACnetVendorId_BUILDING_CONTROL_INTEGRATORS,
		BACnetVendorId_ITG_WORLDWIDEM_SDN_BHD,
		BACnetVendorId_LUTRON_ELECTRONICS_CO_INC,
		BACnetVendorId_COOPER_ATKINS_CORPORATION,
		BACnetVendorId_LOYTEC_ELECTRONICS_GMBH,
		BACnetVendorId_PRO_LON,
		BACnetVendorId_MEGA_CONTROLS_LIMITED,
		BACnetVendorId_MICRO_CONTROL_SYSTEMS_INC,
		BACnetVendorId_KIYON_INC,
		BACnetVendorId_DUST_NETWORKS,
		BACnetVendorId_ADVANCED_BUILDING_AUTOMATION_SYSTEMS,
		BACnetVendorId_HERMOSAG,
		BACnetVendorId_CEZIM,
		BACnetVendorId_SOFTING,
		BACnetVendorId_LYNXSPRING_INC,
		BACnetVendorId_SCHNEIDER_TOSHIBA_INVERTER_EUROPE,
		BACnetVendorId_DANFOSS_DRIVESAS,
		BACnetVendorId_EATON_CORPORATION,
		BACnetVendorId_MATYCASA,
		BACnetVendorId_BOTECHAB,
		BACnetVendorId_NOVEO_INC,
		BACnetVendorId_AMEV,
		BACnetVendorId_YOKOGAWA_ELECTRIC_CORPORATION,
		BACnetVendorId_BOSCH_BUILDING_AUTOMATION_GMBH,
		BACnetVendorId_EXACT_LOGIC,
		BACnetVendorId_MASS_ELECTRONICS_PTY_LTDDBA_INNOTECH_CONTROL_SYSTEMS_AUSTRALIA,
		BACnetVendorId_KANDENKO_CO_LTD,
		BACnetVendorId_DTF_DATEN_TECHNIK_FRIES,
		BACnetVendorId_KLIMASOFT_LTD,
		BACnetVendorId_TOSHIBA_SCHNEIDER_INVERTER_CORPORATION,
		BACnetVendorId_CONTROL_APPLICATIONS_LTD,
		BACnetVendorId_CIMONCO_LTD,
		BACnetVendorId_ONICON_INCORPORATED,
		BACnetVendorId_AUTOMATION_DISPLAYS_INC,
		BACnetVendorId_CONTROL_SOLUTIONS_INC,
		BACnetVendorId_REMSDAQ_LIMITED,
		BACnetVendorId_NTT_FACILITIES_INC,
		BACnetVendorId_VIPA_GMBH,
		BACnetVendorId_TSC1_ASSOCIATIONOF_JAPAN,
		BACnetVendorId_STRATO_AUTOMATION,
		BACnetVendorId_HRW_LIMITED,
		BACnetVendorId_LIGHTING_CONTROL_DESIGN_INC,
		BACnetVendorId_MERCY_ELECTRONICAND_ELECTRICAL_INDUSTRIES,
		BACnetVendorId_SAMSUNGSDS_CO_LTD,
		BACnetVendorId_IMPACT_FACILITY_SOLUTIONS_INC,
		BACnetVendorId_AIRCUITY,
		BACnetVendorId_CONTROL_TECHNIQUES_LTD,
		BACnetVendorId_OPEN_GENERAL_PTY_LTD,
		BACnetVendorId_WAGO_KONTAKTTECHNIK_GMBH_COKG,
		BACnetVendorId_FRANKLIN_ELECTRIC,
		BACnetVendorId_CHLORIDE_POWER_PROTECTION_COMPANY,
		BACnetVendorId_COMPUTROLS_INC,
		BACnetVendorId_PHOENIX_CONTACT_GMBH_COKG,
		BACnetVendorId_GRUNDFOS_MANAGEMENTAS,
		BACnetVendorId_RIDDER_DRIVE_SYSTEMS,
		BACnetVendorId_SOFT_DEVICESDNBHD,
		BACnetVendorId_INTEGRATED_CONTROL_TECHNOLOGY_LIMITED,
		BACnetVendorId_AI_RXPERT_SYSTEMS_INC,
		BACnetVendorId_MICROTROL_LIMITED,
		BACnetVendorId_RED_LION_CONTROLS,
		BACnetVendorId_DIGITAL_ELECTRONICS_CORPORATION,
		BACnetVendorId_ENNOVATIS_GMBH,
		BACnetVendorId_SEROTONIN_SOFTWARE_TECHNOLOGIES_INC,
		BACnetVendorId_LS_INDUSTRIAL_SYSTEMS_CO_LTD,
		BACnetVendorId_SQUARED_COMPANY,
		BACnetVendorId_S_SQUARED_INNOVATIONS_INC,
		BACnetVendorId_ARICENT_LTD,
		BACnetVendorId_ETHER_METRICSLLC,
		BACnetVendorId_INDUSTRIAL_CONTROL_COMMUNICATIONS_INC,
		BACnetVendorId_PARAGON_CONTROLS_INC,
		BACnetVendorId_AO_SMITH_CORPORATION,
		BACnetVendorId_CONTEMPORARY_CONTROL_SYSTEMS_INC,
		BACnetVendorId_HMS_INDUSTRIAL_NETWORKSSLU,
		BACnetVendorId_INGENIEURGESELLSCHAFTN_HARTLEBMBH,
		BACnetVendorId_HEAT_TIMER_CORPORATION,
		BACnetVendorId_INGRASYS_TECHNOLOGY_INC,
		BACnetVendorId_COSTERM_BUILDING_AUTOMATION,
		BACnetVendorId_WILOSE,
		BACnetVendorId_EMBEDIA_TECHNOLOGIES_CORP,
		BACnetVendorId_TECHNILOG,
		BACnetVendorId_HR_CONTROLS_LTD_COKG,
		BACnetVendorId_LENNOX_INTERNATIONAL_INC,
		BACnetVendorId_RK_TEC_RAUCHKLAPPEN_STEUERUNGSSYSTEME_GMBH_COKG,
		BACnetVendorId_THERMOMAX_LTD,
		BACnetVendorId_ELCON_ELECTRONIC_CONTROL_LTD,
		BACnetVendorId_LARMIA_CONTROLAB,
		BACnetVendorId_BA_CNET_STACKAT_SOURCE_FORGE,
		BACnetVendorId_GS_SECURITY_SERVICESAS,
		BACnetVendorId_EXOR_INTERNATIONAL_SPA,
		BACnetVendorId_CRISTAL_CONTROLES,
		BACnetVendorId_REGINAB,
		BACnetVendorId_DIMENSION_SOFTWARE_INC,
		BACnetVendorId_SYNAP_SENSE_CORPORATION,
		BACnetVendorId_BEIJING_NANTREE_ELECTRONIC_CO_LTD,
		BACnetVendorId_CAMUS_HYDRONICS_LTD,
		BACnetVendorId_KAWASAKI_HEAVY_INDUSTRIES_LTD,
		BACnetVendorId_CRITICAL_ENVIRONMENT_TECHNOLOGIES,
		BACnetVendorId_ILSHINIBS_CO_LTD,
		BACnetVendorId_ELESTA_ENERGY_CONTROLAG,
		BACnetVendorId_KROPMAN_INSTALLATIETECHNIEK,
		BACnetVendorId_BALDOR_ELECTRIC_COMPANY,
		BACnetVendorId_ING_AMBH,
		BACnetVendorId_GE_CONSUMER_INDUSTRIAL,
		BACnetVendorId_FUNCTIONAL_DEVICES_INC,
		BACnetVendorId_STUDIOSC,
		BACnetVendorId_MGCOLTD,
		BACnetVendorId_YOKOTA_CO_LTD,
		BACnetVendorId_HITRANSE_TECHNOLOGY_COLTD,
		BACnetVendorId_VIGILENT_CORPORATION,
		BACnetVendorId_KELE_INC,
		BACnetVendorId_BELIMO_AUTOMATIONAG,
		BACnetVendorId_GENTEC,
		BACnetVendorId_EMBEDDED_SCIENCE_LABSLLC,
		BACnetVendorId_PARKER_HANNIFIN_CORPORATION,
		BACnetVendorId_MA_CAPS_INTERNATIONAL_LIMITED,
		BACnetVendorId_LINK_CORPORATION,
		BACnetVendorId_ROMUTEC_STEUERU_REGELSYSTEME_GMBH,
		BACnetVendorId_PRIBUSIN_INC,
		BACnetVendorId_ADVANTAGE_CONTROLS,
		BACnetVendorId_CRITICAL_ROOM_CONTROL,
		BACnetVendorId_LEGRAND,
		BACnetVendorId_TONGDY_CONTROL_TECHNOLOGY_CO_LTD,
		BACnetVendorId_ISSARO_INTEGRIERTE_SYSTEMTECHNIK,
		BACnetVendorId_PRO_DEV_INDUSTRIES,
		BACnetVendorId_DRISTEEM,
		BACnetVendorId_CREATIVE_ELECTRONIC_GMBH,
		BACnetVendorId_SWEGONAB,
		BACnetVendorId_FIRVEN_ASRO,
		BACnetVendorId_HITACHI_APPLIANCES_INC,
		BACnetVendorId_REAL_TIME_AUTOMATION_INC,
		BACnetVendorId_ITEC_HANKYU_HANSHIN_CO,
		BACnetVendorId_CYRUSEM_ENGINEERING_CO_LTD,
		BACnetVendorId_BADGER_METER,
		BACnetVendorId_CIRRASCALE_CORPORATION,
		BACnetVendorId_ELESTA_GMBH_BUILDING_AUTOMATION,
		BACnetVendorId_SECURITON,
		BACnetVendorId_O_SLSOFT_INC,
		BACnetVendorId_HANAZEDER_ELECTRONIC_GMBH,
		BACnetVendorId_HONEYWELL_SECURITY_DEUTSCHLAND_NOVAR_GMBH,
		BACnetVendorId_SIEMENS_INDUSTRY_INC,
		BACnetVendorId_ETM_PROFESSIONAL_CONTROL_GMBH,
		BACnetVendorId_MEITAVTEC_LTD,
		BACnetVendorId_JANITZA_ELECTRONICS_GMBH,
		BACnetVendorId_MKS_NORDHAUSEN,
		BACnetVendorId_DE_GIER_DRIVE_SYSTEMSBV,
		BACnetVendorId_CYPRESS_ENVIROSYSTEMS,
		BACnetVendorId_SMAR_TRONSRO,
		BACnetVendorId_VERARI_SYSTEMS_INC,
		BACnetVendorId_KW_ELECTRONIC_SERVICE_INC,
		BACnetVendorId_ALFASMART_ENERGY_MANAGEMENT,
		BACnetVendorId_TELKONET_INC,
		BACnetVendorId_SECURITON_GMBH,
		BACnetVendorId_CEMTREX_INC,
		BACnetVendorId_PERFORMANCE_TECHNOLOGIES_INC,
		BACnetVendorId_XTRALIS_AUST_PTY_LTD,
		BACnetVendorId_TROX_GMBH,
		BACnetVendorId_BEIJING_HYSINE_TECHNOLOGY_CO_LTD,
		BACnetVendorId_RCK_CONTROLS_INC,
		BACnetVendorId_DISTECH_CONTROLSSAS,
		BACnetVendorId_NOVAR_HONEYWELL,
		BACnetVendorId_S_INTEGRATION_SOLUTIONS,
		BACnetVendorId_SCHNEIDER_ELECTRIC1,
		BACnetVendorId_LHA_SYSTEMS,
		BACnetVendorId_GH_MENGINEERING_GROUP_INC,
		BACnetVendorId_CLLIMALUXSA,
		BACnetVendorId_VAISALA_OYJ,
		BACnetVendorId_COMPLEX_BEIJING_TECHNOLOGY_COLTD,
		BACnetVendorId_SCAD_AMETRICS,
		BACnetVendorId_POWERPEGNSI_LIMITED,
		BACnetVendorId_BA_CNET_INTEROPERABILITY_TESTING_SERVICES_INC,
		BACnetVendorId_TECOAS,
		BACnetVendorId_PLEXUS_TECHNOLOGY_INC,
		BACnetVendorId_ENERGY_FOCUS_INC,
		BACnetVendorId_POWERSMITHS_INTERNATIONAL_CORP,
		BACnetVendorId_NICHIBEI_CO_LTD,
		BACnetVendorId_HKC_TECHNOLOGY_LTD,
		BACnetVendorId_OVATION_NETWORKS_INC,
		BACnetVendorId_SETRA_SYSTEMS,
		BACnetVendorId_AVG_AUTOMATION,
		BACnetVendorId_ZXC_LTD,
		BACnetVendorId_BYTE_SPHERE,
		BACnetVendorId_GENERITON_CO_LTD,
		BACnetVendorId_HOLTER_REGELARMATUREN_GMBH_COKG,
		BACnetVendorId_BEDFORD_INSTRUMENTSLLC,
		BACnetVendorId_STANDAIR_INC,
		BACnetVendorId_WEG_AUTOMATIONRD,
		BACnetVendorId_PROLON_CONTROL_SYSTEMS_APS,
		BACnetVendorId_INNEASOFT,
		BACnetVendorId_CONNEX_SOFT_GMBH,
		BACnetVendorId_CEAG_NOTLICHTSYSTEME_GMBH,
		BACnetVendorId_DISTECH_CONTROLS_INC,
		BACnetVendorId_INDUSTRIAL_TECHNOLOGY_RESEARCH_INSTITUTE,
		BACnetVendorId_MITSUBISHI_ELECTRIC_ICONICS_DIGITAL_SOLUTIONS,
		BACnetVendorId_IQ_CONTROLSSC,
		BACnetVendorId_OJ_ELECTRONICSAS,
		BACnetVendorId_ROLBIT_LTD,
		BACnetVendorId_SYNAPSYS_SOLUTIONS_LTD,
		BACnetVendorId_ACME_ENGINEERING_PROD_LTD,
		BACnetVendorId_ZENER_ELECTRIC_PTY_LTD,
		BACnetVendorId_SELECTRONIX_INC,
		BACnetVendorId_GORBET_BANERJEELLC,
		BACnetVendorId_IME,
		BACnetVendorId_STEPHENH_DAWSON_COMPUTER_SERVICE,
		BACnetVendorId_ACCUTROLLLC,
		BACnetVendorId_SCHNEIDER_ELEKTRONIK_GMBH,
		BACnetVendorId_ALPHA_INNO_TEC_GMBH,
		BACnetVendorId_ADM_MICRO_INC,
		BACnetVendorId_GREYSTONE_ENERGY_SYSTEMS_INC,
		BACnetVendorId_CAP_TECHNOLOGIE,
		BACnetVendorId_KE_RO_SYSTEMS,
		BACnetVendorId_DOMAT_CONTROL_SYSTEMSRO,
		BACnetVendorId_EFEKTRONICS_PTY_LTD,
		BACnetVendorId_HEKATRON_VERTRIEBS_GMBH,
		BACnetVendorId_SECURITONAG,
		BACnetVendorId_CARLO_GAVAZZI_CONTROLS_SPA,
		BACnetVendorId_CHIPKIN_AUTOMATION_SYSTEMS,
		BACnetVendorId_SAVANT_SYSTEMSLLC,
		BACnetVendorId_SIMMTRONIC_LIGHTING_CONTROLS,
		BACnetVendorId_ABELKO_INNOVATIONAB,
		BACnetVendorId_SERESCO_TECHNOLOGIES_INC,
		BACnetVendorId_IT_WATCHDOGS,
		BACnetVendorId_AUTOMATION_ASSIST_JAPAN_CORP,
		BACnetVendorId_THERMOKON_SENSORTECHNIK_GMBH,
		BACnetVendorId_E_GAUGE_SYSTEMSLLC,
		BACnetVendorId_QUANTUM_AUTOMATIONASIAPTE_LTD,
		BACnetVendorId_TOSHIBA_LIGHTING_TECHNOLOGY_CORP,
		BACnetVendorId_SPIN_ENGENHARIADE_AUTOMAO_LTDA,
		BACnetVendorId_LOGISTICS_SYSTEMS_SOFTWARE_SERVICES_INDIAPVT_LTD,
		BACnetVendorId_DELTA_CONTROLS_INTEGRATION_PRODUCTS,
		BACnetVendorId_FOCUS_MEDIA,
		BACnetVendorId_LUM_ENERGI_INC,
		BACnetVendorId_KARA_SYSTEMS,
		BACnetVendorId_RF_CODE_INC,
		BACnetVendorId_FATEK_AUTOMATION_CORP,
		BACnetVendorId_JANDA_SOFTWARE_COMPANYLLC,
		BACnetVendorId_OPEN_SYSTEM_SOLUTIONS_LIMITED,
		BACnetVendorId_INTELEC_SYSTEMSPTY_LTD,
		BACnetVendorId_ECOLODGIXLLC,
		BACnetVendorId_DOUGLAS_LIGHTING_CONTROLS,
		BACnetVendorId_IS_ATECH_GMBH,
		BACnetVendorId_AREAL,
		BACnetVendorId_BECKHOFF_AUTOMATION,
		BACnetVendorId_IPAS_GMBH,
		BACnetVendorId_KE_THERM_SOLUTIONS,
		BACnetVendorId_BASE_PRODUCTS,
		BACnetVendorId_DTL_CONTROLSLLC,
		BACnetVendorId_INNCOM_INTERNATIONAL_INC,
		BACnetVendorId_METZCONNECT_GMBH,
		BACnetVendorId_GREENTROL_AUTOMATION_INC,
		BACnetVendorId_BELIMO_AUTOMATIONAG1,
		BACnetVendorId_SAMSUNG_HEAVY_INDUSTRIES_CO_LTD,
		BACnetVendorId_TRIACTA_POWER_TECHNOLOGIES_INC,
		BACnetVendorId_GLOBESTAR_SYSTEMS,
		BACnetVendorId_MLB_ADVANCED_MEDIALP,
		BACnetVendorId_SWG_STUCKMANN_WIRTSCHAFTLICHE_GEBUDESYSTEME_GMBH,
		BACnetVendorId_SENSOR_SWITCH,
		BACnetVendorId_MULTITEK_POWER_LIMITED,
		BACnetVendorId_INTEGRA_METERINGAG,
		BACnetVendorId_LG_ELECTRONICS_INC,
		BACnetVendorId_ELECTRONIC_THEATRE_CONTROLS_INC,
		BACnetVendorId_MITSUBISHI_ELECTRIC_CORPORATION_NAGOYA_WORKS,
		BACnetVendorId_DELTA_ELECTRONICS_INC,
		BACnetVendorId_ELMA_KURTALJ_LTD,
		BACnetVendorId_TYCO_FIRE_SECURITY_GMBH,
		BACnetVendorId_NEDAP_SECURITY_MANAGEMENT,
		BACnetVendorId_ESC_AUTOMATION_INC,
		BACnetVendorId_DSPYOU_LTD,
		BACnetVendorId_GE_SENSINGAND_INSPECTION_TECHNOLOGIES,
		BACnetVendorId_EMBEDDED_SYSTEMSSIA,
		BACnetVendorId_BEFEGA_GMBH,
		BACnetVendorId_BASELINE_INC,
		BACnetVendorId_KEY_ACT,
		BACnetVendorId_OEM_CTRL,
		BACnetVendorId_CLARKSON_CONTROLS_LIMITED,
		BACnetVendorId_ROGERWELL_CONTROL_SYSTEM_LIMITED,
		BACnetVendorId_SCL_ELEMENTS,
		BACnetVendorId_HITACHI_LTD1,
		BACnetVendorId_NEWRON_SYSTEMSA,
		BACnetVendorId_BEVECO_GEBOUWAUTOMATISERINGBV,
		BACnetVendorId_STREAMSIDE_SOLUTIONS,
		BACnetVendorId_YELLOWSTONE_SOFT,
		BACnetVendorId_OZTECH_INTELLIGENT_SYSTEMS_PTY_LTD,
		BACnetVendorId_NOVELAN_GMBH,
		BACnetVendorId_FLEXIM_AMERICAS_CORPORATION,
		BACnetVendorId_ICPDAS_CO_LTD,
		BACnetVendorId_CARMA_INDUSTRIES_INC,
		BACnetVendorId_LOG_ONE_LTD,
		BACnetVendorId_TECO_ELECTRIC_MACHINERY_CO_LTD,
		BACnetVendorId_CONNECT_EX_INC,
		BACnetVendorId_TURBODDC_SDWEST,
		BACnetVendorId_QUATROSENSE_ENVIRONMENTAL_LTD,
		BACnetVendorId_FIFTH_LIGHT_TECHNOLOGY_LTD,
		BACnetVendorId_SCIENTIFIC_SOLUTIONS_LTD,
		BACnetVendorId_CONTROLLER_AREA_NETWORK_SOLUTIONSM_SDN_BHD,
		BACnetVendorId_RESOL_ELEKTRONISCHE_REGELUNGEN_GMBH,
		BACnetVendorId_RPBUSLLC,
		BACnetVendorId_BRS_SISTEMAS_ELETRONICOS,
		BACnetVendorId_WINDOW_MASTERAS,
		BACnetVendorId_SUNLUX_TECHNOLOGIES_LTD,
		BACnetVendorId_MEASURLOGIC,
		BACnetVendorId_FRIMAT_GMBH,
		BACnetVendorId_SPIRAX_SARCO,
		BACnetVendorId_LUXTRON,
		BACnetVendorId_RAYPAK_INC,
		BACnetVendorId_AIR_MONITOR_CORPORATION1,
		BACnetVendorId_REGLER_OCH_WEBBTEKNIK_SVERIGEROWS,
		BACnetVendorId_INTELLIGENT_LIGHTING_CONTROLS_INC,
		BACnetVendorId_SANYO_ELECTRIC_INDUSTRY_CO_LTD,
		BACnetVendorId_E_MON_ENERGY_MONITORING_PRODUCTS,
		BACnetVendorId_DIGITAL_CONTROL_SYSTEMS,
		BACnetVendorId_ATI_AIRTEST_TECHNOLOGIES_INC,
		BACnetVendorId_SCSSA,
		BACnetVendorId_HMS_INDUSTRIAL_NETWORKSAB,
		BACnetVendorId_SHENZHEN_UNIVERSAL_INTELLISYS_CO_LTD,
		BACnetVendorId_EK_INTELLISYS_SDN_BHD,
		BACnetVendorId_SYS_COM,
		BACnetVendorId_FIRECOM_INC,
		BACnetVendorId_ESA_ELEKTROSCHALTANLAGEN_GRIMMA_GMBH,
		BACnetVendorId_KUMAHIRA_CO_LTD,
		BACnetVendorId_HOTRACO,
		BACnetVendorId_SABO_ELEKTRONIK_GMBH,
		BACnetVendorId_EQUIP_TRANS,
		BACnetVendorId_TEMPERATURE_CONTROL_SPECIALITIES_CO_INCTCS,
		BACnetVendorId_FLOW_CON_INTERNATIONALAS,
		BACnetVendorId_THYSSEN_KRUPP_ELEVATOR_AMERICAS,
		BACnetVendorId_ABATEMENT_TECHNOLOGIES,
		BACnetVendorId_CONTINENTAL_CONTROL_SYSTEMSLLC,
		BACnetVendorId_WISAG_AUTOMATISIERUNGSTECHNIK_GMBH_COKG,
		BACnetVendorId_EASYIO,
		BACnetVendorId_EAP_ELECTRIC_GMBH,
		BACnetVendorId_HARDMEIER,
		BACnetVendorId_MIRCOM_GROUPOF_COMPANIES,
		BACnetVendorId_QUEST_CONTROLS,
		BACnetVendorId_MESTEK_INC,
		BACnetVendorId_PULSE_ENERGY,
		BACnetVendorId_TACHIKAWA_CORPORATION,
		BACnetVendorId_UNIVERSITYOF_NEBRASKA_LINCOLN,
		BACnetVendorId_REDWOOD_SYSTEMS,
		BACnetVendorId_PAS_STEC_INDUSTRIE_ELEKTRONIK_GMBH,
		BACnetVendorId_NGEK_INC,
		BACnetVendorId_TMAC_TECHNOLOGIES,
		BACnetVendorId_JIREH_ENERGY_TECH_CO_LTD,
		BACnetVendorId_ENLIGHTED_INC,
		BACnetVendorId_EL_PIAST_SP_ZOO,
		BACnetVendorId_NETX_AUTOMATION_SOFTWARE_GMBH,
		BACnetVendorId_INVERTEK_DRIVES,
		BACnetVendorId_DEUTSCHMANN_AUTOMATION_GMBH_COKG,
		BACnetVendorId_EMU_ELECTRONICAG,
		BACnetVendorId_PHAEDRUS_LIMITED,
		BACnetVendorId_SIGMATEK_GMBH_COKG,
		BACnetVendorId_MARLIN_CONTROLS,
		BACnetVendorId_CIRCUTORSA,
		BACnetVendorId_UTC_FIRE_SECURITY,
		BACnetVendorId_DENT_INSTRUMENTS_INC,
		BACnetVendorId_FHP_MANUFACTURING_COMPANY_BOSCH_GROUP,
		BACnetVendorId_GE_INTELLIGENT_PLATFORMS,
		BACnetVendorId_INNER_RANGE_PTY_LTD,
		BACnetVendorId_GLAS_ENERGY_TECHNOLOGY,
		BACnetVendorId_MSR_ELECTRONIC_GMBH,
		BACnetVendorId_ENERGY_CONTROL_SYSTEMS_INC,
		BACnetVendorId_EMT_CONTROLS,
		BACnetVendorId_DAINTREE,
		BACnetVendorId_EUROIC_CDOO,
		BACnetVendorId_TE_CONNECTIVITY_ENERGY,
		BACnetVendorId_GEZE_GMBH,
		BACnetVendorId_NEC_CORPORATION,
		BACnetVendorId_HO_CHEUNG_INTERNATIONAL_COMPANY_LIMITED,
		BACnetVendorId_SHARP_MANUFACTURING_SYSTEMS_CORPORATION,
		BACnetVendorId_DOTCONTROL_SAS,
		BACnetVendorId_BEACON_MEDS,
		BACnetVendorId_MIDEA_COMMERCIAL_AIRCON,
		BACnetVendorId_AAON,
		BACnetVendorId_KAMSTRUPAS,
		BACnetVendorId_CA_COMPUTER_AUTOMATION_GMBH,
		BACnetVendorId_LAARS_HEATING_SYSTEMS_COMPANY,
		BACnetVendorId_HITACHI_SYSTEMS_LTD,
		BACnetVendorId_FUSHANAKE_ELECTRONIC_ENGINEERING_CO_LTD,
		BACnetVendorId_TOSHIBA_INTERNATIONAL_CORPORATION,
		BACnetVendorId_STARMAN_SYSTEMSLLC,
		BACnetVendorId_SAMSUNG_TECHWIN_CO_LTD,
		BACnetVendorId_ISAS_INTEGRATED_SWITCHGEARAND_SYSTEMSPL,
		BACnetVendorId_OBVIUS,
		BACnetVendorId_MAREK_GUZIK,
		BACnetVendorId_VORTEK_INSTRUMENTSLLC,
		BACnetVendorId_UNIVERSAL_LIGHTING_TECHNOLOGIES,
		BACnetVendorId_MYERS_POWER_PRODUCTS_INC,
		BACnetVendorId_VECTOR_CONTROLS_GMBH,
		BACnetVendorId_CRESTRON_ELECTRONICS_INC,
		BACnetVendorId_AE_CONTROLS_LIMITED,
		BACnetVendorId_PROJEKTOMONTAZAAD,
		BACnetVendorId_FREEAIRE_REFRIGERATION,
		BACnetVendorId_AQUA_COOLER_PTY_LIMITED,
		BACnetVendorId_BASIC_CONTROLS,
		BACnetVendorId_GE_MEASUREMENTAND_CONTROL_SOLUTIONS_ADVANCED_SENSORS,
		BACnetVendorId_EQUAL_NETWORKS,
		BACnetVendorId_MILLENNIAL_NET,
		BACnetVendorId_APLI_LTD,
		BACnetVendorId_ELECTRO_INDUSTRIES_GAUGE_TECH,
		BACnetVendorId_SANG_MYUNG_UNIVERSITY,
		BACnetVendorId_COPPERTREE_ANALYTICS_INC,
		BACnetVendorId_CORE_NETIX_GMBH,
		BACnetVendorId_ACUTHERM,
		BACnetVendorId_DR_RIEDEL_AUTOMATISIERUNGSTECHNIK_GMBH,
		BACnetVendorId_SHINA_SYSTEM_CO_LTD,
		BACnetVendorId_IQAPERTUS,
		BACnetVendorId_PSE_TECHNOLOGY,
		BACnetVendorId_BA_SYSTEMS,
		BACnetVendorId_BTICINO,
		BACnetVendorId_MONICO_INC,
		BACnetVendorId_I_CUE,
		BACnetVendorId_TEKMAR_CONTROL_SYSTEMS_LTD,
		BACnetVendorId_CONTROL_TECHNOLOGY_CORPORATION,
		BACnetVendorId_GFAE_GMBH,
		BACnetVendorId_BE_KA_SOFTWARE_GMBH,
		BACnetVendorId_ISOIL_INDUSTRIA_SPA,
		BACnetVendorId_HOME_SYSTEMS_CONSULTING_SPA,
		BACnetVendorId_SOCOMEC,
		BACnetVendorId_EVEREX_COMMUNICATIONS_INC,
		BACnetVendorId_CET_ELECTRIC_TECHNOLOGY_INC,
		BACnetVendorId_ATRILA_GMBH,
		BACnetVendorId_WING_TECHS,
		BACnetVendorId_SHENZHEN_MEK_INTELLISYS_PTE_LTD,
		BACnetVendorId_NESTFIELD_CO_LTD,
		BACnetVendorId_SWISSPHONE_TELECOMAG,
		BACnetVendorId_PNTECHJSC,
		BACnetVendorId_HORNERAPGLLC,
		BACnetVendorId_PVI_INDUSTRIESLLC,
		BACnetVendorId_ELACOMPIL,
		BACnetVendorId_PEGASUS_AUTOMATION_INTERNATIONALLLC,
		BACnetVendorId_WIGHT_ELECTRONIC_SERVICES_LTD,
		BACnetVendorId_MARCOM,
		BACnetVendorId_EXHAUSTOAS,
		BACnetVendorId_DWYER_INSTRUMENTS_INC,
		BACnetVendorId_LINK_GMBH,
		BACnetVendorId_OPPERMANN_REGELGERATE_GMBH,
		BACnetVendorId_NU_AIRE_INC,
		BACnetVendorId_NORTEC_HUMIDITY_INC,
		BACnetVendorId_BIGWOOD_SYSTEMS_INC,
		BACnetVendorId_ENBALA_POWER_NETWORKS,
		BACnetVendorId_INTER_ENERGY_CO_LTD,
		BACnetVendorId_ETC,
		BACnetVendorId_COMELECSARL,
		BACnetVendorId_PYTHIA_TECHNOLOGIES,
		BACnetVendorId_TREND_POINT_SYSTEMS_INC,
		BACnetVendorId_AWEX,
		BACnetVendorId_EUREVIA,
		BACnetVendorId_KONGSBERGELONAS,
		BACnetVendorId_FLAKT_WOODS,
		BACnetVendorId_EE_ELEKTRONIKGESMBH,
		BACnetVendorId_ARC_INFORMATIQUE,
		BACnetVendorId_SKIDATAAG,
		BACnetVendorId_WSW_SOLUTIONS,
		BACnetVendorId_TREFON_ELECTRONIC_GMBH,
		BACnetVendorId_DONGSEO_SYSTEM,
		BACnetVendorId_KANONTEC_INTELLIGENCE_TECHNOLOGY_CO_LTD,
		BACnetVendorId_EVCO_SPA,
		BACnetVendorId_ACCUENERGY_CANADA_INC,
		BACnetVendorId_SOFTDEL,
		BACnetVendorId_ORION_ENERGY_SYSTEMS_INC,
		BACnetVendorId_ROBOTICSWARE,
		BACnetVendorId_DOMIQ_SPZOO,
		BACnetVendorId_SOLIDYNE,
		BACnetVendorId_ELECSYS_CORPORATION,
		BACnetVendorId_CONDITIONAIRE_INTERNATIONAL_PTY_LIMITED,
		BACnetVendorId_QUEBEC_INC,
		BACnetVendorId_HOMERUN_HOLDINGS,
		BACnetVendorId_MURATA_AMERICAS,
		BACnetVendorId_COMPTEK,
		BACnetVendorId_WESTCO_SYSTEMS_INC,
		BACnetVendorId_ADVANCIS_SOFTWARE_SERVICES_GMBH,
		BACnetVendorId_INTERGRIDLLC,
		BACnetVendorId_MARKERR_CONTROLS_INC,
		BACnetVendorId_TOSHIBA_ELEVATORAND_BUILDING_SYSTEMS_CORPORATION,
		BACnetVendorId_SPECTRUM_CONTROLS_INC,
		BACnetVendorId_MKSERVICE,
		BACnetVendorId_FOX_THERMAL_INSTRUMENTS,
		BACnetVendorId_SYXTH_SENSE_LTD,
		BACnetVendorId_DUHA_SYSTEMSRO,
		BACnetVendorId_NIBE,
		BACnetVendorId_MELINK_CORPORATION,
		BACnetVendorId_FRITZ_HABER_INSTITUT,
		BACnetVendorId_MTU_ONSITE_ENERGY_GMBH_GAS_POWER_SYSTEMS,
		BACnetVendorId_OMEGA_ENGINEERING_INC,
		BACnetVendorId_AVELON,
		BACnetVendorId_YWIRE_TECHNOLOGIES_INC,
		BACnetVendorId_MR_ENGINEERING_CO_LTD,
		BACnetVendorId_LOCHINVARLLC,
		BACnetVendorId_SONTAY_LIMITED,
		BACnetVendorId_GRUPA_SLAWOMIR_CHELMINSKI,
		BACnetVendorId_ARCH_METER_CORPORATION,
		BACnetVendorId_SENVA_INC,
		BACnetVendorId_FM_TEC,
		BACnetVendorId_SYSTEMS_SPECIALISTS_INC,
		BACnetVendorId_SENSE_AIR,
		BACnetVendorId_AB_INDUSTRIE_TECHNIK_SRL,
		BACnetVendorId_CORTLAND_RESEARCHLLC,
		BACnetVendorId_MEDIA_VIEW,
		BACnetVendorId_VDA_ELETTRONICA,
		BACnetVendorId_CSS_INC,
		BACnetVendorId_TEK_AIR_SYSTEMS_INC,
		BACnetVendorId_ICDT,
		BACnetVendorId_THE_ARMSTRONG_MONITORING_CORPORATION,
		BACnetVendorId_DIXELL_SRL,
		BACnetVendorId_LEAD_SYSTEM_INC,
		BACnetVendorId_ISM_EURO_CENTERSA,
		BACnetVendorId_TDIS,
		BACnetVendorId_TRADEFIDES,
		BACnetVendorId_KNRR_GMBH_EMERSON_NETWORK_POWER,
		BACnetVendorId_RESOURCE_DATA_MANAGEMENT,
		BACnetVendorId_ABIES_TECHNOLOGY_INC,
		BACnetVendorId_UAB_KOMFOVENT,
		BACnetVendorId_MIRAE_ELECTRICAL_MFG_CO_LTD,
		BACnetVendorId_HUNTER_DOUGLAS_ARCHITECTURAL_PROJECTS_SCANDINAVIA_APS,
		BACnetVendorId_RUNPAQ_GROUP_CO_LTD,
		BACnetVendorId_UNICARDSA,
		BACnetVendorId_IE_TECHNOLOGIES,
		BACnetVendorId_RUSKIN_MANUFACTURING,
		BACnetVendorId_CALON_ASSOCIATES_LIMITED,
		BACnetVendorId_CONTEC_CO_LTD,
		BACnetVendorId_IT_GMBH,
		BACnetVendorId_AUTANI_CORPORATION,
		BACnetVendorId_CHRISTIAN_FORTIN,
		BACnetVendorId_HDL,
		BACnetVendorId_IPID_SPZOO_LIMITED,
		BACnetVendorId_FUJI_ELECTRIC_CO_LTD,
		BACnetVendorId_VIEW_INC,
		BACnetVendorId_SAMSUNGS1_CORPORATION,
		BACnetVendorId_NEW_LIFT,
		BACnetVendorId_VRT_SYSTEMS,
		BACnetVendorId_MOTION_CONTROL_ENGINEERING_INC,
		BACnetVendorId_WEISS_KLIMATECHNIK_GMBH,
		BACnetVendorId_ELKON,
		BACnetVendorId_ELIWELL_CONTROLS_SRL,
		BACnetVendorId_JAPAN_COMPUTER_TECHNOS_CORP,
		BACnetVendorId_RATIONAL_NETWORKEHF,
		BACnetVendorId_MAGNUM_ENERGY_SOLUTIONSLLC,
		BACnetVendorId_MEL_ROK,
		BACnetVendorId_VAE_GROUP,
		BACnetVendorId_LGCNS,
		BACnetVendorId_BERGHOF_AUTOMATIONSTECHNIK_GMBH,
		BACnetVendorId_QUARK_COMMUNICATIONS_INC,
		BACnetVendorId_SONTEX,
		BACnetVendorId_MIVUNEAG,
		BACnetVendorId_PANDUIT,
		BACnetVendorId_SMART_CONTROLSLLC,
		BACnetVendorId_COMPU_AIRE_INC,
		BACnetVendorId_SIERRA,
		BACnetVendorId_PROTO_SENSE_TECHNOLOGIES,
		BACnetVendorId_ELTRAC_TECHNOLOGIES_PVT_LTD,
		BACnetVendorId_BEKTAS_INVISIBLE_CONTROLS_GMBH,
		BACnetVendorId_ENTELEC,
		BACnetVendorId_INNEXIV,
		BACnetVendorId_COVENANT,
		BACnetVendorId_DAVITORAB,
		BACnetVendorId_TONG_FANG_TECHNOVATOR,
		BACnetVendorId_BUILDING_ROBOTICS_INC,
		BACnetVendorId_HSSMSRUG,
		BACnetVendorId_FRAM_TACKLLC,
		BACnetVendorId_BL_ACOUSTICS_LTD,
		BACnetVendorId_TRAXXON_ROCK_DRILLS_LTD,
		BACnetVendorId_FRANKE,
		BACnetVendorId_WURM_GMBH_CO,
		BACnetVendorId_ADDENERGIE,
		BACnetVendorId_MIRLE_AUTOMATION_CORPORATION,
		BACnetVendorId_IBIS_NETWORKS,
		BACnetVendorId_IDKART_ASRO,
		BACnetVendorId_ANAREN_INC,
		BACnetVendorId_SPAN_INCORPORATED,
		BACnetVendorId_BOSCH_THERMOTECHNOLOGY_CORP,
		BACnetVendorId_DRC_TECHNOLOGYSA,
		BACnetVendorId_SHANGHAI_ENERGY_BUILDING_TECHNOLOGY_CO_LTD,
		BACnetVendorId_FRAPORTAG,
		BACnetVendorId_FLOWGROUP,
		BACnetVendorId_SKYTRON_ENERGY_GMBH,
		BACnetVendorId_ALTEL_WICHA_GOLDA_SPJ,
		BACnetVendorId_DRUPAL,
		BACnetVendorId_AXIOMATIC_TECHNOLOGY_LTD,
		BACnetVendorId_BOHNKE_PARTNER,
		BACnetVendorId_FUNCTION1,
		BACnetVendorId_OPTERGY_PTY_LTD,
		BACnetVendorId_LSI_VIRTICUS,
		BACnetVendorId_KONZEPTPARK_GMBH,
		BACnetVendorId_NX_LIGHTING_CONTROLS,
		BACnetVendorId_E_CURV_INC,
		BACnetVendorId_AGNOSYS_GMBH,
		BACnetVendorId_SHANGHAI_SUNFULL_AUTOMATION_COLTD,
		BACnetVendorId_KURZ_INSTRUMENTS_INC,
		BACnetVendorId_CIAS_ELETTRONICA_SRL,
		BACnetVendorId_MULTIAQUA_INC,
		BACnetVendorId_BLUE_BOX,
		BACnetVendorId_SENSIDYNE,
		BACnetVendorId_VIESSMANN_ELEKTRONIK_GMBH,
		BACnetVendorId_AD_FWEBCOMSRL,
		BACnetVendorId_GAYLORD_INDUSTRIES,
		BACnetVendorId_MAJUR_LTD,
		BACnetVendorId_SHANGHAI_HUILIN_TECHNOLOGY_CO_LTD,
		BACnetVendorId_EXOTRONIC,
		BACnetVendorId_SAFECONTRO_LSRO,
		BACnetVendorId_AMATIS,
		BACnetVendorId_UNIVERSAL_ELECTRIC_CORPORATION,
		BACnetVendorId_IBA_CNET,
		BACnetVendorId_SMARTRISE_ENGINEERING_INC,
		BACnetVendorId_MIRATRON_INC,
		BACnetVendorId_SMART_EDGE,
		BACnetVendorId_MITSUBISHI_ELECTRIC_AUSTRALIA_PTY_LTD,
		BACnetVendorId_TRIANGLE_RESEARCH_INTERNATIONAL_PTD_LTD,
		BACnetVendorId_PRODUAL_OY,
		BACnetVendorId_MILESTONE_SYSTEMSAS,
		BACnetVendorId_TRUSTBRIDGE,
		BACnetVendorId_FEEDBACK_SOLUTIONS,
		BACnetVendorId_IES,
		BACnetVendorId_ABB_POWER_PROTECTIONSA,
		BACnetVendorId_RIPTIDEIO,
		BACnetVendorId_MESSERSCHMITT_SYSTEMSAG,
		BACnetVendorId_DEZEM_ENERGY_CONTROLLING,
		BACnetVendorId_MECHO_SYSTEMS,
		BACnetVendorId_EVON_GMBH,
		BACnetVendorId_CS_LAB_GMBH,
		BACnetVendorId_N_0_ENTERPRISES_INC,
		BACnetVendorId_TOUCHE_CONTROLS,
		BACnetVendorId_ONTROL_TEKNIK_MALZEME_SANVE_TICAS,
		BACnetVendorId_UNI_CONTROL_SYSTEM_SP_ZOO,
		BACnetVendorId_WEIHAI_PLOUMETER_CO_LTD,
		BACnetVendorId_ELCOM_INTERNATIONAL_PVT_LTD,
		BACnetVendorId_SIGNIFY,
		BACnetVendorId_AUTOMATION_DIRECT,
		BACnetVendorId_PARAGON_ROBOTICS,
		BACnetVendorId_SMT_SYSTEM_MODULES_TECHNOLOGYAG,
		BACnetVendorId_RADIX_IOTLLC,
		BACnetVendorId_CMR_CONTROLS_LTD,
		BACnetVendorId_INNOVARI_INC,
		BACnetVendorId_ABB_CONTROL_PRODUCTS,
		BACnetVendorId_GESELLSCHAFTFUR_GEBUDEAUTOMATIONMBH,
		BACnetVendorId_RODI_SYSTEMS_CORP,
		BACnetVendorId_NEXTEK_POWER_SYSTEMS,
		BACnetVendorId_CREATIVE_LIGHTING,
		BACnetVendorId_WATER_FURNACE_INTERNATIONAL,
		BACnetVendorId_MERCURY_SECURITY,
		BACnetVendorId_HISENSE_SHANDONG_AIR_CONDITIONING_CO_LTD,
		BACnetVendorId_LAYERED_SOLUTIONS_INC,
		BACnetVendorId_LEEGOOD_AUTOMATIC_SYSTEM_INC,
		BACnetVendorId_SHANGHAI_RESTAR_TECHNOLOGY_CO_LTD,
		BACnetVendorId_REIMANN_INGENIEURBRO,
		BACnetVendorId_LYN_TEC,
		BACnetVendorId_HTP,
		BACnetVendorId_ELKOR_TECHNOLOGIES_INC,
		BACnetVendorId_BENTROL_PTY_LTD,
		BACnetVendorId_TEAM_CONTROL_OY,
		BACnetVendorId_NEXT_DEVICELLC,
		BACnetVendorId_ISMACONTROLLI_SPA,
		BACnetVendorId_KINGI_ELECTRONICS_CO_LTD,
		BACnetVendorId_SAMDAV,
		BACnetVendorId_NEXT_GEN_INDUSTRIES_PVT_LTD,
		BACnetVendorId_ENTICLLC,
		BACnetVendorId_ETAP,
		BACnetVendorId_MORALLE_ELECTRONICS_LIMITED,
		BACnetVendorId_LEICOMAG,
		BACnetVendorId_WATTS_REGULATOR_COMPANY,
		BACnetVendorId_SC_ORBTRONICSSRL,
		BACnetVendorId_GAUSSAN_TECHNOLOGIES,
		BACnetVendorId_WE_BFACTORY_GMBH,
		BACnetVendorId_OCEAN_CONTROLS,
		BACnetVendorId_MESSANA_AIR_RAY_CONDITIONINGSRL,
		BACnetVendorId_HANGZHOUBATOWN_TECHNOLOGY_CO_LTD,
		BACnetVendorId_REASONABLE_CONTROLS,
		BACnetVendorId_SERVISYS_INC,
		BACnetVendorId_HALSTRUPWALCHER_GMBH,
		BACnetVendorId_SWG_AUTOMATION_FUZHOU_LIMITED,
		BACnetVendorId_KSB_AKTIENGESELLSCHAFT,
		BACnetVendorId_HYBRYD_SPZOO,
		BACnetVendorId_HELVATRONAG,
		BACnetVendorId_ODERON_SPZOO,
		BACnetVendorId_MIKOLAB,
		BACnetVendorId_EXODRAFT,
		BACnetVendorId_HOCHHUTH_GMBH,
		BACnetVendorId_INTEGRATED_SYSTEM_TECHNOLOGIES_LTD,
		BACnetVendorId_SHANGHAI_CELLCONS_CONTROLS_CO_LTD,
		BACnetVendorId_EMME_CONTROLSLLC,
		BACnetVendorId_FIELD_DIAGNOSTIC_SERVICES_INC,
		BACnetVendorId_GES_TEKNIKAS,
		BACnetVendorId_GLOBAL_POWER_PRODUCTS_INC,
		BACnetVendorId_OPTIONNV,
		BACnetVendorId_BV_CONTROLAG,
		BACnetVendorId_SIGREN_ENGINEERINGAG,
		BACnetVendorId_SHANGHAI_JALTONE_TECHNOLOGY_CO_LTD,
		BACnetVendorId_MAX_LINE_SOLUTIONS_LTD,
		BACnetVendorId_KRON_INSTRUMENTOS_ELTRICOS_LTDA,
		BACnetVendorId_THERMO_MATRIX,
		BACnetVendorId_INFINITE_AUTOMATION_SYSTEMS_INC,
		BACnetVendorId_VANTAGE,
		BACnetVendorId_ELECON_MEASUREMENTS_PVT_LTD,
		BACnetVendorId_TBA,
		BACnetVendorId_CARNES_COMPANY,
		BACnetVendorId_HARMAN_PROFESSIONAL,
		BACnetVendorId_NENUTEC_ASIA_PACIFIC_PTE_LTD,
		BACnetVendorId_GIANV,
		BACnetVendorId_KEPWARE_TEHNOLOGIES,
		BACnetVendorId_TEMPERATURE_ELECTRONICS_LTD,
		BACnetVendorId_PACKET_POWER,
		BACnetVendorId_PROJECT_HAYSTACK_CORPORATION,
		BACnetVendorId_DEOS_CONTROLS_AMERICAS_INC,
		BACnetVendorId_SENSEWARE_INC,
		BACnetVendorId_MST_SYSTEMTECHNIKAG,
		BACnetVendorId_LONIX_LTD,
		BACnetVendorId_GOSSEN_METRAWATT_GMBH,
		BACnetVendorId_AVIOSYS_INTERNATIONAL_INC,
		BACnetVendorId_EFFICIENT_BUILDING_AUTOMATION_CORP,
		BACnetVendorId_ACCUTRON_INSTRUMENTS_INC,
		BACnetVendorId_VERMONT_ENERGY_CONTROL_SYSTEMSLLC,
		BACnetVendorId_DCC_DYNAMICS,
		BACnetVendorId_BEG_BRCK_ELECTRONIC_GMBH,
		BACnetVendorId_NGBS_HUNGARY_LTD,
		BACnetVendorId_ILLUM_TECHNOLOGYLLC,
		BACnetVendorId_DELTA_CONTROLS_GERMANY_LIMITED,
		BACnetVendorId_ST_SERVICE_TECHNIQUESA,
		BACnetVendorId_SIMPLE_SOFT,
		BACnetVendorId_ALTAIR_ENGINEERING,
		BACnetVendorId_EZEN_SOLUTION_INC,
		BACnetVendorId_FUJITEC_CO_LTD,
		BACnetVendorId_TERRALUX,
		BACnetVendorId_ANNICOM,
		BACnetVendorId_BIHL_WIEDEMANN_GMBH,
		BACnetVendorId_DRAPER_INC,
		BACnetVendorId_SCHCO_INTERNATIONALKG,
		BACnetVendorId_OTIS_ELEVATOR_COMPANY,
		BACnetVendorId_FIDELIX_OY,
		BACnetVendorId_RAM_GMBH_MESSUND_REGELTECHNIK,
		BACnetVendorId_WEMS,
		BACnetVendorId_RAVEL_ELECTRONICS_PVT_LTD,
		BACnetVendorId_OMNI_MAGNI,
		BACnetVendorId_ECHELON,
		BACnetVendorId_INTELLIMETER_CANADA_INC,
		BACnetVendorId_BITHOUSE_OY,
		BACnetVendorId_BUILD_PULSE,
		BACnetVendorId_SHENZHEN1000_BUILDING_AUTOMATION_CO_LTD,
		BACnetVendorId_AED_ENGINEERING_GMBH,
		BACnetVendorId_GNTNER_GMBH_COKG,
		BACnetVendorId_KN_XLOGIC,
		BACnetVendorId_CIM_ENVIRONMENTAL_GROUP,
		BACnetVendorId_FLOW_CONTROL,
		BACnetVendorId_LUMEN_CACHE_INC,
		BACnetVendorId_ECOSYSTEM,
		BACnetVendorId_POTTER_ELECTRIC_SIGNAL_COMPANYLLC,
		BACnetVendorId_TYCO_FIRE_SECURITY_SPA,
		BACnetVendorId_WATANABE_ELECTRIC_INDUSTRY_CO_LTD,
		BACnetVendorId_CAUSAM_ENERGY,
		BACnetVendorId_WTECAG,
		BACnetVendorId_IMI_HYDRONIC_ENGINEERING_INTERNATIONALSA,
		BACnetVendorId_ARIGO_SOFTWARE,
		BACnetVendorId_MSA_SAFETY1,
		BACnetVendorId_SMART_SOLUCOES_LTDAMERCATO,
		BACnetVendorId_PIATRA_ENGINEERING,
		BACnetVendorId_ODIN_AUTOMATION_SYSTEMSLLC,
		BACnetVendorId_BELPARTSNV,
		BACnetVendorId_UABSALDA,
		BACnetVendorId_ALREIT_REGELTECHNIK_GMBH,
		BACnetVendorId_INGENIEURBROH_LERTES_GMBH_COKG,
		BACnetVendorId_BREATHING_BUILDINGS,
		BACnetVendorId_EWONSA,
		BACnetVendorId_CAV_UFF_GIACOMO_CIMBERIO_SPA,
		BACnetVendorId_PKE_ELECTRONICSAG,
		BACnetVendorId_ALLEN,
		BACnetVendorId_KASTLE_SYSTEMS,
		BACnetVendorId_LOGICAL_ELECTRO_MECHANICALEM_SYSTEMS_INC,
		BACnetVendorId_PP_KINETICS_INSTRUMENTSLLC,
		BACnetVendorId_CATHEXIS_TECHNOLOGIES,
		BACnetVendorId_SYLOPSP_ZOOSPK,
		BACnetVendorId_BRAUNS_CONTROL_GMBH,
		BACnetVendorId_OMRONSOCIALSOLUTIONSCOLTD,
		BACnetVendorId_WILDEBOER_BAUTEILE_GMBH,
		BACnetVendorId_SHANGHAI_BIENS_TECHNOLOGIES_LTD,
		BACnetVendorId_BEIJINGHZHY_TECHNOLOGY_CO_LTD,
		BACnetVendorId_BUILDING_CLOUDS,
		BACnetVendorId_THE_UNIVERSITYOF_SHEFFIELD_DEPARTMENTOF_ELECTRONICAND_ELECTRICAL_ENGINEERING,
		BACnetVendorId_FABTRONICS_AUSTRALIA_PTY_LTD,
		BACnetVendorId_SLAT,
		BACnetVendorId_SOFTWARE_MOTOR_CORPORATION,
		BACnetVendorId_ARMSTRONG_INTERNATIONAL_INC,
		BACnetVendorId_STERIL_AIRE_INC,
		BACnetVendorId_INFINIQUE,
		BACnetVendorId_ARCOM,
		BACnetVendorId_ARGO_PERFORMANCE_LTD,
		BACnetVendorId_DIALIGHT,
		BACnetVendorId_IDEAL_TECHNICAL_SOLUTIONS,
		BACnetVendorId_NEUROBATAG,
		BACnetVendorId_NEYER_SOFTWARE_CONSULTINGLLC,
		BACnetVendorId_SCADA_TECHNOLOGY_DEVELOPMENT_CO_LTD,
		BACnetVendorId_DEMAND_LOGIC_LIMITED,
		BACnetVendorId_GWA_GROUP_LIMITED,
		BACnetVendorId_OCCITALINE,
		BACnetVendorId_NAO_DIGITAL_CO_LTD,
		BACnetVendorId_SHENZHEN_CHANSLINK_NETWORK_TECHNOLOGY_CO_LTD,
		BACnetVendorId_SAMSUNG_ELECTRONICS_CO_LTD,
		BACnetVendorId_MESA_LABORATORIES_INC,
		BACnetVendorId_FISCHER,
		BACnetVendorId_OP_SYS_SOLUTIONS_LTD,
		BACnetVendorId_ADVANCED_DEVICES_LIMITED,
		BACnetVendorId_CONDAIR,
		BACnetVendorId_INELCOM_INGENIERIA_ELECTRONICA_COMERCIALSA,
		BACnetVendorId_GRID_POINT_INC,
		BACnetVendorId_ADF_TECHNOLOGIES_SDN_BHD,
		BACnetVendorId_EPM_INC,
		BACnetVendorId_LIGHTING_CONTROLS_LTD,
		BACnetVendorId_PERIX_CONTROLS_LTD,
		BACnetVendorId_AERCO_INTERNATIONAL_INC,
		BACnetVendorId_KONE_INC,
		BACnetVendorId_ZIEHL_ABEGGSE,
		BACnetVendorId_ROBOTSA,
		BACnetVendorId_OPTIGO_NETWORKS_INC,
		BACnetVendorId_OPENMOTICSBVBA,
		BACnetVendorId_METROPOLITAN_INDUSTRIES_INC,
		BACnetVendorId_HUAWEI_TECHNOLOGIES_CO_LTD,
		BACnetVendorId_DIGITAL_LUMENS_INC,
		BACnetVendorId_VANTI,
		BACnetVendorId_CREE_LIGHTING,
		BACnetVendorId_RICHMOND_HEIGHTSSDNBHD,
		BACnetVendorId_PAYNE_SPARKMAN_LIGHTING_MANGEMENT,
		BACnetVendorId_ASHCROFT,
		BACnetVendorId_JET_CONTROLS_CORP,
		BACnetVendorId_ZUMTOBEL_LIGHTING_GMBH,
		BACnetVendorId_EKON_GMBH,
		BACnetVendorId_MOLEX,
		BACnetVendorId_MACO_LIGHTING_PTY_LTD,
		BACnetVendorId_AXECON_CORP,
		BACnetVendorId_TENSORPLC,
		BACnetVendorId_KASEMAN_ENVIRONMENTAL_CONTROL_EQUIPMENT_SHANGHAI_LIMITED,
		BACnetVendorId_AB_AXIS_INDUSTRIES,
		BACnetVendorId_NETIX_CONTROLS,
		BACnetVendorId_ELDRIDGE_PRODUCTS_INC,
		BACnetVendorId_MICRONICS,
		BACnetVendorId_FORTECHO_SOLUTIONS_LTD,
		BACnetVendorId_SELLERS_MANUFACTURING_COMPANY,
		BACnetVendorId_RITE_HITE_DOORS_INC,
		BACnetVendorId_VIOLET_DEFENSELLC,
		BACnetVendorId_SIMNA,
		BACnetVendorId_MULTINERGIE_BEST_INC,
		BACnetVendorId_MEGA_SYSTEM_TECHNOLOGIES_INC,
		BACnetVendorId_RHEEM,
		BACnetVendorId_ING_PUNZENBERGERCOPADATA_GMBH,
		BACnetVendorId_MEC_ELECTRONICS_GMBH,
		BACnetVendorId_TACO_COMFORT_SOLUTIONS,
		BACnetVendorId_ALEXANDER_MAIER_GMBH,
		BACnetVendorId_ECORITHM_INC,
		BACnetVendorId_ACCURRO_LTD,
		BACnetVendorId_ROMTECK_AUSTRALIA_PTY_LTD,
		BACnetVendorId_SPLASH_MONITORING_LIMITED,
		BACnetVendorId_LIGHT_APPLICATION,
		BACnetVendorId_LOGICAL_BUILDING_AUTOMATION,
		BACnetVendorId_EXILIGHT_OY,
		BACnetVendorId_HAGER_ELECTROSAS,
		BACnetVendorId_KLIF_COLTD,
		BACnetVendorId_HYGRO_MATIK,
		BACnetVendorId_DANIEL_MOUSSEAU_PROGRAMMATION_ELECTRONIQUE,
		BACnetVendorId_AERIONICS_INC,
		BACnetVendorId_MS_ELECTRONIQUE_LTEE,
		BACnetVendorId_AUTOMATION_COMPONENTS_INC,
		BACnetVendorId_NIOBRARA_RESEARCH_DEVELOPMENT_CORPORATION,
		BACnetVendorId_NETCOM_SICHERHEITSTECHNIK_GMBH,
		BACnetVendorId_LUMELSA,
		BACnetVendorId_GREAT_PLAINS_INDUSTRIES_INC,
		BACnetVendorId_DOMOTICA_LABSSRL,
		BACnetVendorId_ENERGY_CLOUD_INC,
		BACnetVendorId_VOMATEC,
		BACnetVendorId_DEMMA_COMPANIES,
		BACnetVendorId_VALSENA,
		BACnetVendorId_COMSYS_BRTSCHAG,
		BACnetVendorId_B_GRID,
		BACnetVendorId_MDJ_SOFTWARE_PTY_LTD,
		BACnetVendorId_DIMONOFF_INC,
		BACnetVendorId_EDOMO_SYSTEMS_GMBH,
		BACnetVendorId_EFFEKTIVLLC,
		BACnetVendorId_STEAMO_VAP,
		BACnetVendorId_GRANDCENTRIX_GMBH,
		BACnetVendorId_WEINTEK_LABS_INC,
		BACnetVendorId_INTEFOX_GMBH,
		BACnetVendorId_RADIUS_AUTOMATION_COMPANY,
		BACnetVendorId_RINGDALE_INC,
		BACnetVendorId_IWAKI_AMERICA,
		BACnetVendorId_BRACTLET,
		BACnetVendorId_STULZ_AIR_TECHNOLOGY_SYSTEMS_INC,
		BACnetVendorId_CLIMATE_READY_ENGINEERING_PTY_LTD,
		BACnetVendorId_GENEA_ENERGY_PARTNERS,
		BACnetVendorId_IO_TALL_CHILE,
		BACnetVendorId_IKS_CO_LTD,
		BACnetVendorId_YODIWOAB,
		BACnetVendorId_TITA_NELECTRONIC_GMBH,
		BACnetVendorId_IDEC_CORPORATION,
		BACnetVendorId_SIFRISL,
		BACnetVendorId_THERMAL_GAS_SYSTEMS_INC,
		BACnetVendorId_BUILDING_AUTOMATION_PRODUCTS_INC,
		BACnetVendorId_ASSET_MAPPING,
		BACnetVendorId_SMARTEH_COMPANY,
		BACnetVendorId_DATAPOD_AUSTRALIA_PTY_LTD,
		BACnetVendorId_BUILDINGS_ALIVE_PTY_LTD,
		BACnetVendorId_DIGITAL_ELEKTRONIK,
		BACnetVendorId_TALENT_AUTOMAOE_TECNOLOGIA_LTDA,
		BACnetVendorId_NORPOSH_LIMITED,
		BACnetVendorId_MERKUR_FUNKSYSTEMEAG,
		BACnetVendorId_FASTERC_ZSPOL_SRO,
		BACnetVendorId_ECO_ADAPT,
		BACnetVendorId_ENERGOCENTRUM_PLUSSRO,
		BACnetVendorId_AMBXUK_LTD,
		BACnetVendorId_WESTERN_RESERVE_CONTROLS_INC,
		BACnetVendorId_LAYER_ZERO_POWER_SYSTEMS_INC,
		BACnetVendorId_CIC_JAN_HEBECSRO,
		BACnetVendorId_SIGROVBV,
		BACnetVendorId_ISYS_INTELLIGENT_SYSTEMS,
		BACnetVendorId_GAS_DETECTION_AUSTRALIA_PTY_LTD,
		BACnetVendorId_KINCO_AUTOMATION_SHANGHAI_LTD,
		BACnetVendorId_LARS_ENERGYLLC,
		BACnetVendorId_FLAMEFASTUK_LTD,
		BACnetVendorId_ROYAL_SERVICE_AIR_CONDITIONING,
		BACnetVendorId_AMPIO_SP_ZOO,
		BACnetVendorId_INOVONICS_WIRELESS_CORPORATION,
		BACnetVendorId_NVENT_THERMAL_MANAGEMENT,
		BACnetVendorId_SINOWELL_CONTROL_SYSTEM_LTD,
		BACnetVendorId_MOXA_INC,
		BACnetVendorId_MATRIXI_CONTROLSDNBHD,
		BACnetVendorId_PURPLE_SWIFT,
		BACnetVendorId_OTIM_TECHNOLOGIES,
		BACnetVendorId_FLOW_MATE_LIMITED,
		BACnetVendorId_DEGREE_CONTROLS_INC,
		BACnetVendorId_FEI_XING_SHANGHAI_SOFTWARE_TECHNOLOGIES_CO_LTD,
		BACnetVendorId_BERG_GMBH,
		BACnetVendorId_ARENZIT,
		BACnetVendorId_EDELSTROM_ELECTRONIC_DEVICES_DESIGNINGLLC,
		BACnetVendorId_DRIVE_CONNECTLLC,
		BACnetVendorId_DEVELOP_NOW,
		BACnetVendorId_POORT,
		BACnetVendorId_VMEIL_INFORMATION_SHANGHAI_LTD,
		BACnetVendorId_RAYLEIGH_INSTRUMENTS,
		BACnetVendorId_CODESYS_DEVELOPMENT,
		BACnetVendorId_SMARTWARE_TECHNOLOGIES_GROUPLLC,
		BACnetVendorId_POLAR_BEAR_SOLUTIONS,
		BACnetVendorId_CODRA,
		BACnetVendorId_PHAROS_ARCHITECTURAL_CONTROLS_LTD,
		BACnetVendorId_ENGI_NEAR_LTD,
		BACnetVendorId_AD_HOC_ELECTRONICS,
		BACnetVendorId_UNIFIED_MICROSYSTEMS,
		BACnetVendorId_INDUSTRIEELEKTRONIK_BRANDENBURG_GMBH,
		BACnetVendorId_HARTMANN_GMBH,
		BACnetVendorId_PISCADA,
		BACnetVendorId_KM_BSYSTEMSSRO,
		BACnetVendorId_POWER_TECH_ENGINEERINGAS,
		BACnetVendorId_TELEFONBAU_ARTHUR_SCHWABE_GMBH_COKG,
		BACnetVendorId_WUXI_FISTWELOVE_TECHNOLOGY_CO_LTD,
		BACnetVendorId_PRYSM,
		BACnetVendorId_STEINEL_GMBH,
		BACnetVendorId_GEORG_FISCHERJRGAG,
		BACnetVendorId_MAKE_DEVELOPSL,
		BACnetVendorId_MONNIT_CORPORATION,
		BACnetVendorId_MIRROR_LIFE_CORPORATION,
		BACnetVendorId_SECURE_METERS_LIMITED,
		BACnetVendorId_PECO,
		BACnetVendorId_CCTECH_INC,
		BACnetVendorId_LIGHT_FI_LIMITED,
		BACnetVendorId_NICE_SPA,
		BACnetVendorId_FIBER_SEN_SYS_INC,
		BACnetVendorId_BD_BUCHTAUND_DEGEORGI,
		BACnetVendorId_VENTACITY_SYSTEMS_INC,
		BACnetVendorId_HITACHI_JOHNSON_CONTROLS_AIR_CONDITIONING_INC,
		BACnetVendorId_SAGE_METERING_INC,
		BACnetVendorId_ANDEL_LIMITED,
		BACnetVendorId_ECO_SMART_TECHNOLOGIES,
		BACnetVendorId_SET,
		BACnetVendorId_PROTEC_FIRE_DETECTION_SPAINSL,
		BACnetVendorId_AGRAMERUG,
		BACnetVendorId_ANYLINK_ELECTRONIC_GMBH,
		BACnetVendorId_SCHINDLER_LTD,
		BACnetVendorId_JIBREEL_ABDEEN_EST,
		BACnetVendorId_FLUIDYNE_CONTROL_SYSTEMS_PVT_LTD,
		BACnetVendorId_PRISM_SYSTEMS_INC,
		BACnetVendorId_ENERTIV,
		BACnetVendorId_MIRASOFT_GMBH_COKG,
		BACnetVendorId_DUALTECHIT,
		BACnetVendorId_COUNTLOGICLLC,
		BACnetVendorId_KOHLER,
		BACnetVendorId_CHEN_SEN_CONTROLS_CO_LTD,
		BACnetVendorId_GREENHECK,
		BACnetVendorId_INTWINE_CONNECTLLC,
		BACnetVendorId_KARLBORGS_ELKONTROLL,
		BACnetVendorId_DATAKOM,
		BACnetVendorId_HOGA_CONTROLAS,
		BACnetVendorId_COOL_AUTOMATION,
		BACnetVendorId_INTER_SEARCH_CO_LTD,
		BACnetVendorId_DABBEL_AUTOMATION_INTELLIGENCE_GMBH,
		BACnetVendorId_GADGEON_ENGINEERING_SMARTNESS,
		BACnetVendorId_COSTER_GROUP_SRL,
		BACnetVendorId_WALTER_MLLERAG,
		BACnetVendorId_FLUKE,
		BACnetVendorId_QUINTEX_SYSTEMS_LTD,
		BACnetVendorId_SENFFICIENTSDNBHD,
		BACnetVendorId_NUBEIO_OPERATIONS_PTY_LTD,
		BACnetVendorId_DAS_INTEGRATOR_PTE_LTD,
		BACnetVendorId_CREVIS_CO_LTD,
		BACnetVendorId_I_SQUAREDSOFTWAREINC,
		BACnetVendorId_KTG_GMBH,
		BACnetVendorId_POK_GROUP_OY,
		BACnetVendorId_ADISCOM,
		BACnetVendorId_INCUSENSE,
		BACnetVendorId_F,
		BACnetVendorId_ANORD_MARDIX_INC,
		BACnetVendorId_HOSCH_GEBUDEAUTOMATION_NEUE_PRODUKTE_GMBH,
		BACnetVendorId_BOSCHIO_GMBH,
		BACnetVendorId_ROYAL_BOON_EDAM_INTERNATIONALBV,
		BACnetVendorId_CLACK_CORPORATION,
		BACnetVendorId_UNITEX_CONTROLSLLC,
		BACnetVendorId_KTC_GTEBORGAB,
		BACnetVendorId_INTERZONAB,
		BACnetVendorId_ISDEINGSL,
		BACnetVendorId_AB_MAUTOMATIONBUILDINGMESSAGING_GMBH,
		BACnetVendorId_KENTEC_ELECTRONICS_LTD,
		BACnetVendorId_COPELANDLP,
		BACnetVendorId_POWERSIDE,
		BACnetVendorId_SMC_GROUP,
		BACnetVendorId_EOS_WEATHER_INSTRUMENTS,
		BACnetVendorId_ZONEX_SYSTEMS,
		BACnetVendorId_GENEREX_SYSTEMS_COMPUTERVERTRIEBSGESELLSCHAFTMBH,
		BACnetVendorId_ENERGY_WALLLLC,
		BACnetVendorId_THERMOFIN,
		BACnetVendorId_SDATAWAYSA,
		BACnetVendorId_BIDDLE_AIR_SYSTEMS_LIMITED,
		BACnetVendorId_KESSLER_ELLIS_PRODUCTS,
		BACnetVendorId_THERMOSCREENS,
		BACnetVendorId_MODIO,
		BACnetVendorId_NEWRON_SOLUTIONS,
		BACnetVendorId_UNITRONICS,
		BACnetVendorId_TRILUX_GMBH_COKG,
		BACnetVendorId_KOLLMORGEN_STEUERUNGSTECHNIK_GMBH,
		BACnetVendorId_BOSCH_REXROTHAG,
		BACnetVendorId_ALARKO_CARRIER,
		BACnetVendorId_VERDIGRIS_TECHNOLOGIES,
		BACnetVendorId_SHANGHAISIIC_LONGCHUANG_SMARTECH_SO_LTD,
		BACnetVendorId_QUINDA_CO,
		BACnetVendorId_GRUNERAG,
		BACnetVendorId_BACMOVE,
		BACnetVendorId_PSIDACAB,
		BACnetVendorId_ISICON_CONTROL_AUTOMATION,
		BACnetVendorId_BIG_ASS_FANS,
		BACnetVendorId_DIN_DIETMAR_NOCKER_FACILITY_MANAGEMENT_GMBH,
		BACnetVendorId_TELDIO,
		BACnetVendorId_MIKROKLIM_ASRO,
		BACnetVendorId_DENSITY,
		BACnetVendorId_ICONAG_LEITTECHNIK_GMBH,
		BACnetVendorId_AWAIR,
		BACnetVendorId_TD_ENGINEERING_LTD,
		BACnetVendorId_SISTEMAS_DIGITALES,
		BACnetVendorId_LOXONE_ELECTRONICS_GMBH,
		BACnetVendorId_ACTRON_AIR,
		BACnetVendorId_INDUCTIVE_AUTOMATION,
		BACnetVendorId_THOR_ENGINEERING_GMBH,
		BACnetVendorId_BERNER_INTERNATIONALLLC,
		BACnetVendorId_POTSDAM_SENSORSLLC,
		BACnetVendorId_KOHLER_MIRA_LTD,
		BACnetVendorId_TECOMON_GMBH,
		BACnetVendorId_TWO_DIMENSIONAL_INSTRUMENTSLLC,
		BACnetVendorId_LEFA_TECHNOLOGIES_PTE_LTD,
		BACnetVendorId_EATONCEAG_NOTLICHTSYSTEME_GMBH,
		BACnetVendorId_COMMBOX_TECNOLOGIA,
		BACnetVendorId_IP_VIDEO_CORPORATION,
		BACnetVendorId_BENDER_GMBH_COKG,
		BACnetVendorId_RHYMEBUS_CORPORATION,
		BACnetVendorId_AXON_SYSTEMS_LTD,
		BACnetVendorId_ENGINEERED_AIR,
		BACnetVendorId_ELIPSE_SOFTWARE_LTDA,
		BACnetVendorId_SIMATIX_BUILDING_TECHNOLOGIES_PVT_LTD,
		BACnetVendorId_WA_BENJAMIN_ELECTRIC_CO,
		BACnetVendorId_TROX_AIR_CONDITIONING_COMPONENTS_SUZHOU_CO_LTD,
		BACnetVendorId_SC_MEDICAL_PTY_LTD,
		BACnetVendorId_ELCANICAS,
		BACnetVendorId_OBEOAS,
		BACnetVendorId_TAPA_INC,
		BACnetVendorId_ASE_SMART_ENERGY_INC,
		BACnetVendorId_PERFORMANCE_SERVICES_INC,
		BACnetVendorId_VERIDIFY_SECURITY,
		BACnetVendorId_CD_INNOVATIONLTD,
		BACnetVendorId_BEN_PEOPLES_INDUSTRIESLLC,
		BACnetVendorId_UNICOMM_SPZOO,
		BACnetVendorId_THING_TECHNOLOGIES_GMBH,
		BACnetVendorId_BEIJING_HAILIN_CONTROL_TECHNOLOGY_INC,
		BACnetVendorId_DIGITAL_REALTY,
		BACnetVendorId_AGROWTEK_INC,
		BACnetVendorId_DSP_INNOVATIONBV,
		BACnetVendorId_STV_ELECTRONIC_GMBH,
		BACnetVendorId_ELMEASURE_INDIA_PVT_LTD,
		BACnetVendorId_PINESHORE_ENERGYLLC,
		BACnetVendorId_BRASCH_ENVIRONMENTAL_TECHNOLOGIESLLC,
		BACnetVendorId_SHEN_ZHEN_ZHI_XING_BUILDING_TECH_CO_LTD,
		BACnetVendorId_SINUX,
		BACnetVendorId_AVNET_INC,
		BACnetVendorId_SOMFY_ACTIVITESSA,
		BACnetVendorId_AMICO,
		BACnetVendorId_SAGE_GLASS,
		BACnetVendorId_AU_VERTE,
		BACnetVendorId_AGILE_CONNECTS_PVT_LTD,
		BACnetVendorId_LOCIMATION_PTY_LTD,
		BACnetVendorId_ENVIO_SYSTEMS_GMBH,
		BACnetVendorId_VOYTECH_SYSTEMS_LIMITED,
		BACnetVendorId_DAVIDSMEYERUND_PAUL_GMBH,
		BACnetVendorId_LUSHER_ENGINEERING_SERVICES,
		BACnetVendorId_CHNT_NANJING_TECHSEL_INTELLIGENT_COMPANYLTD,
		BACnetVendorId_THREETRONICS_PTY_LTD,
		BACnetVendorId_SKY_FOUNDRYLLC,
		BACnetVendorId_HANIL_PRO_TECH,
		BACnetVendorId_SENSORSCALL,
		BACnetVendorId_SHANGHAI_JINGPU_INFORMATION_TECHNOLOGY_CO_LTD,
		BACnetVendorId_LICHTMANUFAKTUR_BERLIN_GMBH,
		BACnetVendorId_ECO_PARKING_TECHNOLOGIES,
		BACnetVendorId_ENVISION_DIGITAL_INTERNATIONAL_PTE_LTD,
		BACnetVendorId_ANTONY_DEVELOPPEMENT_ELECTRONIQUE,
		BACnetVendorId_ISYSTEMS,
		BACnetVendorId_THUREON_INTERNATIONAL_LIMITED,
		BACnetVendorId_PULSAFEEDER,
		BACnetVendorId_MEGA_CHIPS_CORPORATION,
		BACnetVendorId_TES_CONTROLS,
		BACnetVendorId_CERMATE,
		BACnetVendorId_GRAND_VALLEY_STATE_UNIVERSITY,
		BACnetVendorId_SYMCON_GMBH,
		BACnetVendorId_THE_CHICAGO_FAUCET_COMPANY,
		BACnetVendorId_GEBERITAG,
		BACnetVendorId_REX_CONTROLS,
		BACnetVendorId_IVMS_GMBH,
		BACnetVendorId_MNPP_SATURN_LTD,
		BACnetVendorId_REGAL_BELOIT,
		BACnetVendorId_ACS_AIR_CONDITIONING_SOLUTIONS,
		BACnetVendorId_GBX_TECHNOLOGYLLC,
		BACnetVendorId_KAITERRA,
		BACnetVendorId_THIN_KUANLOT_TECHNOLOGY_SHANGHAI_CO_LTD,
		BACnetVendorId_HO_CO_STOBV,
		BACnetVendorId_SHENZHENASAI_TECHNOLOGY_CO_LTD,
		BACnetVendorId_RPS_SPA,
		BACnetVendorId_ESMSOLUTIONS,
		BACnetVendorId_IO_TECH_SYSTEMS_LIMITED,
		BACnetVendorId_I_AUTO_LOGIC_CO_LTD,
		BACnetVendorId_NEW_AGE_MICROLLC,
		BACnetVendorId_GUARDIAN_GLASS,
		BACnetVendorId_GUANGZHOU_ZHAOYU_INFORMATION_TECHNOLOGY,
		BACnetVendorId_ACE_IOT_SOLUTIONSLLC,
		BACnetVendorId_PORIS_ELECTRONICS_CO_LTD,
		BACnetVendorId_TERMINUS_TECHNOLOGIES_GROUP,
		BACnetVendorId_INTECH1_INC,
		BACnetVendorId_ACCURATE_ELECTRONICS,
		BACnetVendorId_FLUENCE_BIOENGINEERING,
		BACnetVendorId_MUN_HEAN_SINGAPORE_PTE_LTD,
		BACnetVendorId_KATRONICAG_COKG,
		BACnetVendorId_SUZHOU_XIN_AO_INFORMATION_TECHNOLOGY_CO_LTD,
		BACnetVendorId_LINKTEKK_TECHNOLOGYJSC,
		BACnetVendorId_STIRLING_ULTRACOLD,
		BACnetVendorId_UV_PARTNERS_INC,
		BACnetVendorId_PRO_MINENT_GMBH,
		BACnetVendorId_MULTI_TECH_SYSTEMS_INC,
		BACnetVendorId_JUMO_GMBH_COKG,
		BACnetVendorId_QINGDAO_HUARUI_TECHNOLOGY_CO_LTD,
		BACnetVendorId_CAIRN_SYSTEMES,
		BACnetVendorId_NEURO_LOGIC_RESEARCH_CORP,
		BACnetVendorId_TRANSITION_TECHNOLOGIES_ADVANCED_SOLUTIONS_SPZOO,
		BACnetVendorId_XXTERBV,
		BACnetVendorId_PASSIVE_LOGIC,
		BACnetVendorId_EN_SMART_CONTROLS,
		BACnetVendorId_WATTS_HEATINGAND_HOT_WATER_SOLUTIONSDBA_LYNC,
		BACnetVendorId_TROPOSPHAIRA_TECHNOLOGIESLLP,
		BACnetVendorId_NETWORK_THERMOSTAT,
		BACnetVendorId_TITANIUM_INTELLIGENT_SOLUTIONSLLC,
		BACnetVendorId_NUMA_PRODUCTSLLC,
		BACnetVendorId_WAREMA_RENKHOFFSE,
		BACnetVendorId_FRESEAS,
		BACnetVendorId_MAPPED,
		BACnetVendorId_ELEKTRODESIG_NVENTILATORYSRO,
		BACnetVendorId_AIR_CARE_AUTOMATION_INC,
		BACnetVendorId_ANTRUM,
		BACnetVendorId_BAO_LINH_CONNECT_TECHNOLOGY,
		BACnetVendorId_VIRGINIA_CONTROLSLLC,
		BACnetVendorId_DUOSYSSDNBHD,
		BACnetVendorId_ONSENSAS,
		BACnetVendorId_VAUGHN_THERMAL_CORPORATION,
		BACnetVendorId_THERMOPLASTIC_ENGINEERING_LTDTPE,
		BACnetVendorId_WIRTH_RESEARCH_LTD,
		BACnetVendorId_SST_AUTOMATION,
		BACnetVendorId_SHANGHAI_BENCOL_ELECTRONIC_TECHNOLOGY_CO_LTD,
		BACnetVendorId_AIWAA_SYSTEMS_PRIVATE_LIMITED,
		BACnetVendorId_ENLESS_WIRELESS,
		BACnetVendorId_OZUNO_ENGINEERING_PTY_LTD,
		BACnetVendorId_HUBBELL_THE_ELECTRIC_HEATER_COMPANY,
		BACnetVendorId_INDUSTRIAL_TURNAROUND_CORPORATIONITAC,
		BACnetVendorId_WADSWORTH_CONTROL_SYSTEMS,
		BACnetVendorId_SERVICES_HILO_INC,
		BACnetVendorId_IDM_ENERGIESYSTEME_GMBH,
		BACnetVendorId_BE_NEXTBV,
		BACnetVendorId_CLEAN_AIRAI_CORPORATION,
		BACnetVendorId_REVOLUTION_MICROELECTRONICS_AMERICA_INC,
		BACnetVendorId_REAL_TIME_SYSTEMS_GMBH,
		BACnetVendorId_ZED_BEE_TECHNOLOGIES_PVT_LTD,
		BACnetVendorId_WIMATE_TECHNOLOGY_SOLUTIONS_PVT_LTD,
		BACnetVendorId_SENTICON_LTD,
		BACnetVendorId_ROSSAKERAB,
		BACnetVendorId_OPIT_SOLUTIONS_LTD,
		BACnetVendorId_HOTOWELL_INTERNATIONAL_CO_LIMITED,
		BACnetVendorId_INIM_ELECTRONICSSRL_UNIPERSONALE,
		BACnetVendorId_AIRTHINGSASA,
		BACnetVendorId_ANALOG_DEVICES_INC,
		BACnetVendorId_AI_DIRECTIONSDMCC,
		BACnetVendorId_PRIMA_ELECTRO_SPA,
		BACnetVendorId_KLT_CONTROL_SYSTEM_LTD,
		BACnetVendorId_EVOLUTION_CONTROLS_INC,
		BACnetVendorId_BEVER_INNOVATIONS,
		BACnetVendorId_PELICAN_WIRELESS_SYSTEMS,
		BACnetVendorId_CONTROL_CONCEPTS_INC,
		BACnetVendorId_AUGMATIC_TECHNOLOGIES_PVT_LTD,
		BACnetVendorId_XIAMEN_MILESIGHTLOT_CO_LTD,
		BACnetVendorId_TIANJIN_ANJIELOT_SCHIENCEAND_TECHNOLOGY_CO_LTD,
		BACnetVendorId_GUANGZHOUS_ENERGY_ELECTRONICS_TECHNOLOGY_CO_LTD,
		BACnetVendorId_AKVO_ATMOSPHERIC_WATER_SYSTEMS_PVT_LTD,
		BACnetVendorId_EM_FIRST_CO_LTD,
		BACnetVendorId_IION_SYSTEMS_APS,
		BACnetVendorId_SAF_TEHNIKAJSC,
		BACnetVendorId_KOMFORTIQ_INC,
		BACnetVendorId_COOL_TERA_LIMITED,
		BACnetVendorId_HADRON_SOLUTIONS_SRLS,
		BACnetVendorId_BITPOOL,
		BACnetVendorId_SONICULLC,
		BACnetVendorId_RISHABH_INSTRUMENTS_LIMITED,
		BACnetVendorId_THING_WAREHOUSELLC,
		BACnetVendorId_INNOFRIENDS_GMBH,
		BACnetVendorId_METRONICAKP_SPJ,
		BACnetVendorId_TECHKNAVE,
		BACnetVendorId_ELSNER_ELEKTRONIK,
		BACnetVendorId_LEFOO_INDUSTRIAL_HANGZHOU_CO_LTD,
		BACnetVendorId_CALIBRATION_TECHNOLOGIES_INC,
		BACnetVendorId_ALLORADO,
		BACnetVendorId_VERKADA,
		BACnetVendorId_WATTSENSE,
		BACnetVendorId_EMERSON_AUTOMATION_SOLUTIONS,
		BACnetVendorId_GROWLINK,
		BACnetVendorId_OLYMPIA_ELECTRONICS,
		BACnetVendorId_NORMAL_SOFTWARE_INC,
		BACnetVendorId_ST_ENGINEERING_SOLUTIONJSC,
		BACnetVendorId_INDUSTRIAL_FLOW_SOLUTIONS,
		BACnetVendorId_UBIQISENSE_APS,
		BACnetVendorId_TIGER_SOFT,
		BACnetVendorId_ECODOM_SRL,
		BACnetVendorId_BILGIPRO_IOT_SYSTEMS,
		BACnetVendorId_PLANSPURNETDESIGN_GMBH,
		BACnetVendorId_DOLPHIN_SOLUTIONS_LTD,
		BACnetVendorId_MITSUBISHI_ELECTRIC_CORPORATION_KOBE_WORKS,
		BACnetVendorId_ECOVENA,
		BACnetVendorId_GREE_ELECTRIC_APPLIANCES_INCOF_ZHUHAI,
		BACnetVendorId_CONSPEC_CONTROLS,
		BACnetVendorId_HANGZHOU_HIKVISION_DIGITAL_TECHNOLOGY_CO_LTD,
		BACnetVendorId_CRYSTAL_PEAK_SECURITY,
		BACnetVendorId_PERM_ALERT,
		BACnetVendorId_ZHEJIANG_MISILIN_TECHNOLOGY_CO_LTD,
		BACnetVendorId_DEKKER_VACUUM_TECHNOLOGIES,
		BACnetVendorId_EDWARDS_LIMITED,
		BACnetVendorId_LEYBOLD_GMBH,
		BACnetVendorId_INTERNATIONAL_GAS_DETECTORS,
		BACnetVendorId_ATLAS_COPCO_AIRPOWERNV,
		BACnetVendorId_AIR_SENTRY_LIMITED,
		BACnetVendorId_AELSYS,
		BACnetVendorId_GRANBY_CONSULTINGLLC,
		BACnetVendorId_CLEVER_RELAY,
		BACnetVendorId_MONICO_MONITORING_INC,
		BACnetVendorId_OQDO,
		BACnetVendorId_MATRIX_COMSEC_PRIVATE_LIMITED,
		BACnetVendorId_RESOURCE_SOLUTIONS,
		BACnetVendorId_AMERICAN_GAS_SAFETYLLC,
		BACnetVendorId_SS_NORTHERN_LTD,
		BACnetVendorId_ULBIOS_TECHSENS,
		BACnetVendorId_BOWERY_FARMING_INC,
		BACnetVendorId_RYOBI_LIMITED,
		BACnetVendorId_EKKO_SENSE_LTD,
		BACnetVendorId_CLIMA_COOL,
		BACnetVendorId_GRID_CONNECT_INC,
		BACnetVendorId_ZIEGLER_INSTRUMENTATIONUK_LTD,
		BACnetVendorId_CONTROL_TECLLC,
		BACnetVendorId_AETERLINK_CORPORATION,
		BACnetVendorId_ALPHA_EPSILON_AUTOMATION,
		BACnetVendorId_ASTRALITE_INC,
		BACnetVendorId_DELTA_FIRE_LTDA,
		BACnetVendorId_BOCK_WATER_HEATERS_INC,
		BACnetVendorId_CLEAVER_BROOKS,
		BACnetVendorId_SCANALYTICS_INC,
		BACnetVendorId_WILABS,
		BACnetVendorId_ACT_SYSTEM_CO_LTD,
		BACnetVendorId_VERGE_SENSE,
		BACnetVendorId_SYSTEMAIR_MFG_INC,
		BACnetVendorId_SEELEY_INTERNATIONAL,
		BACnetVendorId_CRANE_BUILDING_SERVICES_UTILITIES,
		BACnetVendorId_BRADY_CORPORATION,
		BACnetVendorId_QINGDAO_HISENSE_HITACHI_AIR_CONDITIONING_SYSTEMS_CO_LTD,
		BACnetVendorId_GOLDEN_QUALITY_CO_LTD,
		BACnetVendorId_ELVACOAB,
		BACnetVendorId_STRONG_TECHNOLOGYLLC,
		BACnetVendorId_REC_ENVIRONMENTAL_TECHNOLOGY_GUANGZHOU_COMPANY_LIMITED,
		BACnetVendorId_DISRUPTIVE_TECHNOLOGIES_RESEARCHAS,
		BACnetVendorId_NICO_CONSULTANCY_LIMITED,
		BACnetVendorId_HORTENLOT_JIANGSU_CO_LTD,
		BACnetVendorId_PAXTON_CONTROLS_CORP,
		BACnetVendorId_FELL_TECHNOLOGYAS,
		BACnetVendorId_SHLOK_INFORMATION_SYSTEMS_INDIA_PRIVATE_LIMITED,
		BACnetVendorId_MICROGROPLC_LTD,
		BACnetVendorId_CLOUDER_OY,
		BACnetVendorId_GEBUDE_AUTOMATISIERUNG_GMBH,
		BACnetVendorId_SOLVIMUS_GMBH,
		BACnetVendorId_GUANG_ZHOU_WANGKONG_LTD,
		BACnetVendorId_SAFE_SQUARE_GMBH,
		BACnetVendorId_HEKLATECHAB,
		BACnetVendorId_SILVAIR,
		BACnetVendorId_ADVECO,
		BACnetVendorId_EURA_DRIVES_ELECTRIC_CO_LTD,
		BACnetVendorId_CALEB_CONTROLS,
		BACnetVendorId_IN_BIOT_MONITORINGSL,
		BACnetVendorId_QINGDAO_HAIER_AIR_CONDITIONER_ELECTRIC_CO_LTD,
		BACnetVendorId_HANGZHOU_WEIYL_TECHNOLOGY_CO_LTD,
		BACnetVendorId_YORDSRL,
		BACnetVendorId_INFINITUM_ELECTRIC,
		BACnetVendorId_RED_BEAN_SYSTEMS_LIMITED,
		BACnetVendorId_BLUE_TIME_CONCEPTSA,
		BACnetVendorId_SHENZHENINVT_ELECTRIC_CO_LTD,
		BACnetVendorId_MESSUNG_SYSTEMS_PVT_LTD,
		BACnetVendorId_ABB_ELECTRIFICATION_CANADA_INC,
		BACnetVendorId_CORE_CONTROLS,
		BACnetVendorId_NOORD_TECHDOO,
		BACnetVendorId_VARIBITSAS,
		BACnetVendorId_ROGER_SPZOOSPK,
		BACnetVendorId_VIEGA_GMBH_COKG,
		BACnetVendorId_ASTERSOFT,
		BACnetVendorId_BIGEU,
		BACnetVendorId_INFERRIX_LIMITED,
		BACnetVendorId_RICHARDS_ELECTRIC_MOTOR_CO,
		BACnetVendorId_DAPP_CONTROLS,
		BACnetVendorId_ENTOUCH_CONTROLS,
		BACnetVendorId_MAVILI_ELEKTRONIK_TICARETVE_SANAYI_ANONIM_SIRKETI,
		BACnetVendorId_BUBBLY_NET,
		BACnetVendorId_AL_MAYSSAN_TECHNICAL_SERVICES_CO_LTD,
		BACnetVendorId_VIRIDI_PARENTE_INC,
		BACnetVendorId_NOVEL_APPS_CORP,
		BACnetVendorId_OVENTROP_CHINAHVAC_SYSTEM_TECHNOLOGY_CO_LTD,
		BACnetVendorId_LACROIX_SOFREL,
		BACnetVendorId_MACHINE_SENSLOT_TRADING_COLLC,
		BACnetVendorId_ELMEC_INC,
		BACnetVendorId_BEIJING_HAISHI_SOFTWARE_CO_LTD,
		BACnetVendorId_RADIX_ELECTROSYSTEMS_PVT_LTD,
		BACnetVendorId_VRMEBARONENAB,
		BACnetVendorId_TREAU_INCDBA_GRADIENT,
		BACnetVendorId_WEST_SOLUTIONAG,
		BACnetVendorId_TRUEWAY_CONTROLS_HONGKONG_LIMITED,
		BACnetVendorId_BUILDING_LOGIX,
		BACnetVendorId_IFESCA_GMBH,
		BACnetVendorId_FELLOWES_INC,
		BACnetVendorId_CALEFFI_SPA,
		BACnetVendorId_JDRF_ELECTROMAG,
		BACnetVendorId_REDWIRE_LABS,
		BACnetVendorId_WECON_TECHNOLOGY_CO_LTD,
		BACnetVendorId_ACACIA_GREEN_TECHNOLOGIES_LTD,
		BACnetVendorId_DEGREE_ANALYTICS,
		BACnetVendorId_ROLTEK_TEKNOLOJIAS,
		BACnetVendorId_DIGITAL_CONTROL_TECHNOLOGY_LIMITED,
		BACnetVendorId_KENTIMAAB,
		BACnetVendorId_PERGAMON_PERCEPTIVE_TECHNOLOGIES,
		BACnetVendorId_PREFECT_CONTROLS_LTD,
		BACnetVendorId_SEN_TECH_CORPORATION,
		BACnetVendorId_SS_REGELTECHNIK_GMBH,
		BACnetVendorId_AIR_BOX_INC,
		BACnetVendorId_RVE,
		BACnetVendorId_MOTOROLA_SOLUTIONS,
		BACnetVendorId_BACSYS_INNOVATIONS_PRIVATE_LIMITED,
		BACnetVendorId_EWATTCH,
		BACnetVendorId_BUILTLAYERLLC,
		BACnetVendorId_AG_DOMOTIXSRL,
		BACnetVendorId_HYTRONIK_INDUSTRIAL_LIMITED,
		BACnetVendorId_WHO_REINRAUMTECHNIK,
		BACnetVendorId_TRICO_LIMITED,
		BACnetVendorId_SLK_AUTOMATIONSRL,
		BACnetVendorId_ZAPHIREAS,
		BACnetVendorId_AJ_MANUFACTURING,
		BACnetVendorId_FUTURE_MOTORS_LTD,
		BACnetVendorId_HIMEL_HONG_KONG_LIMITED,
		BACnetVendorId_SHENZHEN_SUNRICHER_TECHNOLOGY_CO_LTD,
		BACnetVendorId_ACTILITYSA,
		BACnetVendorId_OY_HALTON_GROUP_LTD,
		BACnetVendorId_AVTECH_SOFTWARE_INC,
		BACnetVendorId_IN_CONTROL_ENGINEERINGLLC,
		BACnetVendorId_SOUND_WATER_TECHNOLOGIESLLC,
		BACnetVendorId_UNKNOWN_VENDOR,
	}
}

func (e BACnetVendorId) VendorId() uint16 {
	switch e {
	case 0:
		{ /* '0' */
			return 0
		}
	case 0xFFFF:
		{ /* '0xFFFF' */
			return 0xFFFF
		}
	case 1:
		{ /* '1' */
			return 1
		}
	case 10:
		{ /* '10' */
			return 10
		}
	case 100:
		{ /* '100' */
			return 100
		}
	case 1000:
		{ /* '1000' */
			return 1000
		}
	case 1001:
		{ /* '1001' */
			return 1001
		}
	case 1002:
		{ /* '1002' */
			return 1002
		}
	case 1003:
		{ /* '1003' */
			return 1003
		}
	case 1004:
		{ /* '1004' */
			return 1004
		}
	case 1005:
		{ /* '1005' */
			return 1005
		}
	case 1006:
		{ /* '1006' */
			return 1006
		}
	case 1007:
		{ /* '1007' */
			return 1007
		}
	case 1008:
		{ /* '1008' */
			return 1008
		}
	case 1009:
		{ /* '1009' */
			return 1009
		}
	case 101:
		{ /* '101' */
			return 101
		}
	case 1010:
		{ /* '1010' */
			return 1010
		}
	case 1011:
		{ /* '1011' */
			return 1011
		}
	case 1012:
		{ /* '1012' */
			return 1012
		}
	case 1013:
		{ /* '1013' */
			return 1013
		}
	case 1014:
		{ /* '1014' */
			return 1014
		}
	case 1015:
		{ /* '1015' */
			return 1015
		}
	case 1016:
		{ /* '1016' */
			return 1016
		}
	case 1017:
		{ /* '1017' */
			return 1017
		}
	case 1018:
		{ /* '1018' */
			return 1018
		}
	case 1019:
		{ /* '1019' */
			return 1019
		}
	case 102:
		{ /* '102' */
			return 102
		}
	case 1020:
		{ /* '1020' */
			return 1020
		}
	case 1021:
		{ /* '1021' */
			return 1021
		}
	case 1022:
		{ /* '1022' */
			return 1022
		}
	case 1023:
		{ /* '1023' */
			return 1023
		}
	case 1024:
		{ /* '1024' */
			return 1024
		}
	case 1025:
		{ /* '1025' */
			return 1025
		}
	case 1026:
		{ /* '1026' */
			return 1026
		}
	case 1027:
		{ /* '1027' */
			return 1027
		}
	case 1028:
		{ /* '1028' */
			return 1028
		}
	case 1029:
		{ /* '1029' */
			return 1029
		}
	case 103:
		{ /* '103' */
			return 103
		}
	case 1030:
		{ /* '1030' */
			return 1030
		}
	case 1031:
		{ /* '1031' */
			return 1031
		}
	case 1032:
		{ /* '1032' */
			return 1032
		}
	case 1033:
		{ /* '1033' */
			return 1033
		}
	case 1034:
		{ /* '1034' */
			return 1034
		}
	case 1035:
		{ /* '1035' */
			return 1035
		}
	case 1036:
		{ /* '1036' */
			return 1036
		}
	case 1037:
		{ /* '1037' */
			return 1037
		}
	case 1038:
		{ /* '1038' */
			return 1038
		}
	case 1039:
		{ /* '1039' */
			return 1039
		}
	case 104:
		{ /* '104' */
			return 104
		}
	case 1040:
		{ /* '1040' */
			return 1040
		}
	case 1041:
		{ /* '1041' */
			return 1041
		}
	case 1042:
		{ /* '1042' */
			return 1042
		}
	case 1043:
		{ /* '1043' */
			return 1043
		}
	case 1044:
		{ /* '1044' */
			return 1044
		}
	case 1045:
		{ /* '1045' */
			return 1045
		}
	case 1046:
		{ /* '1046' */
			return 1046
		}
	case 1047:
		{ /* '1047' */
			return 1047
		}
	case 1048:
		{ /* '1048' */
			return 1048
		}
	case 1049:
		{ /* '1049' */
			return 1049
		}
	case 105:
		{ /* '105' */
			return 105
		}
	case 1050:
		{ /* '1050' */
			return 1050
		}
	case 1051:
		{ /* '1051' */
			return 1051
		}
	case 1052:
		{ /* '1052' */
			return 1052
		}
	case 1053:
		{ /* '1053' */
			return 1053
		}
	case 1054:
		{ /* '1054' */
			return 1054
		}
	case 1055:
		{ /* '1055' */
			return 1055
		}
	case 1056:
		{ /* '1056' */
			return 1056
		}
	case 1057:
		{ /* '1057' */
			return 1057
		}
	case 1058:
		{ /* '1058' */
			return 1058
		}
	case 1059:
		{ /* '1059' */
			return 1059
		}
	case 106:
		{ /* '106' */
			return 106
		}
	case 1060:
		{ /* '1060' */
			return 1060
		}
	case 1061:
		{ /* '1061' */
			return 1061
		}
	case 1062:
		{ /* '1062' */
			return 1062
		}
	case 1063:
		{ /* '1063' */
			return 1063
		}
	case 1064:
		{ /* '1064' */
			return 1064
		}
	case 1065:
		{ /* '1065' */
			return 1065
		}
	case 1066:
		{ /* '1066' */
			return 1066
		}
	case 1067:
		{ /* '1067' */
			return 1067
		}
	case 1068:
		{ /* '1068' */
			return 1068
		}
	case 1069:
		{ /* '1069' */
			return 1069
		}
	case 107:
		{ /* '107' */
			return 107
		}
	case 1070:
		{ /* '1070' */
			return 1070
		}
	case 1071:
		{ /* '1071' */
			return 1071
		}
	case 1072:
		{ /* '1072' */
			return 1072
		}
	case 1073:
		{ /* '1073' */
			return 1073
		}
	case 1074:
		{ /* '1074' */
			return 1074
		}
	case 1075:
		{ /* '1075' */
			return 1075
		}
	case 1076:
		{ /* '1076' */
			return 1076
		}
	case 1077:
		{ /* '1077' */
			return 1077
		}
	case 1078:
		{ /* '1078' */
			return 1078
		}
	case 1079:
		{ /* '1079' */
			return 1079
		}
	case 108:
		{ /* '108' */
			return 108
		}
	case 1080:
		{ /* '1080' */
			return 1080
		}
	case 1081:
		{ /* '1081' */
			return 1081
		}
	case 1082:
		{ /* '1082' */
			return 1082
		}
	case 1083:
		{ /* '1083' */
			return 1083
		}
	case 1084:
		{ /* '1084' */
			return 1084
		}
	case 1085:
		{ /* '1085' */
			return 1085
		}
	case 1086:
		{ /* '1086' */
			return 1086
		}
	case 1087:
		{ /* '1087' */
			return 1087
		}
	case 1088:
		{ /* '1088' */
			return 1088
		}
	case 1089:
		{ /* '1089' */
			return 1089
		}
	case 109:
		{ /* '109' */
			return 109
		}
	case 1090:
		{ /* '1090' */
			return 1090
		}
	case 1091:
		{ /* '1091' */
			return 1091
		}
	case 1092:
		{ /* '1092' */
			return 1092
		}
	case 1093:
		{ /* '1093' */
			return 1093
		}
	case 1094:
		{ /* '1094' */
			return 1094
		}
	case 1095:
		{ /* '1095' */
			return 1095
		}
	case 1096:
		{ /* '1096' */
			return 1096
		}
	case 1097:
		{ /* '1097' */
			return 1097
		}
	case 1098:
		{ /* '1098' */
			return 1098
		}
	case 1099:
		{ /* '1099' */
			return 1099
		}
	case 11:
		{ /* '11' */
			return 11
		}
	case 110:
		{ /* '110' */
			return 110
		}
	case 1100:
		{ /* '1100' */
			return 1100
		}
	case 1101:
		{ /* '1101' */
			return 1101
		}
	case 1102:
		{ /* '1102' */
			return 1102
		}
	case 1103:
		{ /* '1103' */
			return 1103
		}
	case 1104:
		{ /* '1104' */
			return 1104
		}
	case 1105:
		{ /* '1105' */
			return 1105
		}
	case 1106:
		{ /* '1106' */
			return 1106
		}
	case 1107:
		{ /* '1107' */
			return 1107
		}
	case 1108:
		{ /* '1108' */
			return 1108
		}
	case 1109:
		{ /* '1109' */
			return 1109
		}
	case 111:
		{ /* '111' */
			return 111
		}
	case 1110:
		{ /* '1110' */
			return 1110
		}
	case 1112:
		{ /* '1112' */
			return 1112
		}
	case 1113:
		{ /* '1113' */
			return 1113
		}
	case 1114:
		{ /* '1114' */
			return 1114
		}
	case 1115:
		{ /* '1115' */
			return 1115
		}
	case 1116:
		{ /* '1116' */
			return 1116
		}
	case 1117:
		{ /* '1117' */
			return 1117
		}
	case 1118:
		{ /* '1118' */
			return 1118
		}
	case 1119:
		{ /* '1119' */
			return 1119
		}
	case 112:
		{ /* '112' */
			return 112
		}
	case 1120:
		{ /* '1120' */
			return 1120
		}
	case 1121:
		{ /* '1121' */
			return 1121
		}
	case 1122:
		{ /* '1122' */
			return 1122
		}
	case 1123:
		{ /* '1123' */
			return 1123
		}
	case 1124:
		{ /* '1124' */
			return 1124
		}
	case 1125:
		{ /* '1125' */
			return 1125
		}
	case 1126:
		{ /* '1126' */
			return 1126
		}
	case 1127:
		{ /* '1127' */
			return 1127
		}
	case 1128:
		{ /* '1128' */
			return 1128
		}
	case 1129:
		{ /* '1129' */
			return 1129
		}
	case 113:
		{ /* '113' */
			return 113
		}
	case 1130:
		{ /* '1130' */
			return 1130
		}
	case 1131:
		{ /* '1131' */
			return 1131
		}
	case 1132:
		{ /* '1132' */
			return 1132
		}
	case 1133:
		{ /* '1133' */
			return 1133
		}
	case 1134:
		{ /* '1134' */
			return 1134
		}
	case 1135:
		{ /* '1135' */
			return 1135
		}
	case 1136:
		{ /* '1136' */
			return 1136
		}
	case 1137:
		{ /* '1137' */
			return 1137
		}
	case 1138:
		{ /* '1138' */
			return 1138
		}
	case 1139:
		{ /* '1139' */
			return 1139
		}
	case 114:
		{ /* '114' */
			return 114
		}
	case 1140:
		{ /* '1140' */
			return 1140
		}
	case 1141:
		{ /* '1141' */
			return 1141
		}
	case 1142:
		{ /* '1142' */
			return 1142
		}
	case 1143:
		{ /* '1143' */
			return 1143
		}
	case 1144:
		{ /* '1144' */
			return 1144
		}
	case 1145:
		{ /* '1145' */
			return 1145
		}
	case 1146:
		{ /* '1146' */
			return 1146
		}
	case 1147:
		{ /* '1147' */
			return 1147
		}
	case 1148:
		{ /* '1148' */
			return 1148
		}
	case 1149:
		{ /* '1149' */
			return 1149
		}
	case 115:
		{ /* '115' */
			return 115
		}
	case 1150:
		{ /* '1150' */
			return 1150
		}
	case 1151:
		{ /* '1151' */
			return 1151
		}
	case 1152:
		{ /* '1152' */
			return 1152
		}
	case 1153:
		{ /* '1153' */
			return 1153
		}
	case 1154:
		{ /* '1154' */
			return 1154
		}
	case 1155:
		{ /* '1155' */
			return 1155
		}
	case 1156:
		{ /* '1156' */
			return 1156
		}
	case 1157:
		{ /* '1157' */
			return 1157
		}
	case 1158:
		{ /* '1158' */
			return 1158
		}
	case 1159:
		{ /* '1159' */
			return 1159
		}
	case 116:
		{ /* '116' */
			return 116
		}
	case 1160:
		{ /* '1160' */
			return 1160
		}
	case 1161:
		{ /* '1161' */
			return 1161
		}
	case 1162:
		{ /* '1162' */
			return 1162
		}
	case 1163:
		{ /* '1163' */
			return 1163
		}
	case 1164:
		{ /* '1164' */
			return 1164
		}
	case 1165:
		{ /* '1165' */
			return 1165
		}
	case 1166:
		{ /* '1166' */
			return 1166
		}
	case 1167:
		{ /* '1167' */
			return 1167
		}
	case 1168:
		{ /* '1168' */
			return 1168
		}
	case 1169:
		{ /* '1169' */
			return 1169
		}
	case 117:
		{ /* '117' */
			return 117
		}
	case 1170:
		{ /* '1170' */
			return 1170
		}
	case 1171:
		{ /* '1171' */
			return 1171
		}
	case 1172:
		{ /* '1172' */
			return 1172
		}
	case 1173:
		{ /* '1173' */
			return 1173
		}
	case 1174:
		{ /* '1174' */
			return 1174
		}
	case 1175:
		{ /* '1175' */
			return 1175
		}
	case 1176:
		{ /* '1176' */
			return 1176
		}
	case 1177:
		{ /* '1177' */
			return 1177
		}
	case 1178:
		{ /* '1178' */
			return 1178
		}
	case 1179:
		{ /* '1179' */
			return 1179
		}
	case 118:
		{ /* '118' */
			return 118
		}
	case 1180:
		{ /* '1180' */
			return 1180
		}
	case 1181:
		{ /* '1181' */
			return 1181
		}
	case 1182:
		{ /* '1182' */
			return 1182
		}
	case 1183:
		{ /* '1183' */
			return 1183
		}
	case 1184:
		{ /* '1184' */
			return 1184
		}
	case 1185:
		{ /* '1185' */
			return 1185
		}
	case 1186:
		{ /* '1186' */
			return 1186
		}
	case 1187:
		{ /* '1187' */
			return 1187
		}
	case 1188:
		{ /* '1188' */
			return 1188
		}
	case 1189:
		{ /* '1189' */
			return 1189
		}
	case 119:
		{ /* '119' */
			return 119
		}
	case 1190:
		{ /* '1190' */
			return 1190
		}
	case 1191:
		{ /* '1191' */
			return 1191
		}
	case 1192:
		{ /* '1192' */
			return 1192
		}
	case 1193:
		{ /* '1193' */
			return 1193
		}
	case 1194:
		{ /* '1194' */
			return 1194
		}
	case 1195:
		{ /* '1195' */
			return 1195
		}
	case 1196:
		{ /* '1196' */
			return 1196
		}
	case 1197:
		{ /* '1197' */
			return 1197
		}
	case 1198:
		{ /* '1198' */
			return 1198
		}
	case 1199:
		{ /* '1199' */
			return 1199
		}
	case 12:
		{ /* '12' */
			return 12
		}
	case 120:
		{ /* '120' */
			return 120
		}
	case 1200:
		{ /* '1200' */
			return 1200
		}
	case 1201:
		{ /* '1201' */
			return 1201
		}
	case 1202:
		{ /* '1202' */
			return 1202
		}
	case 1203:
		{ /* '1203' */
			return 1203
		}
	case 1204:
		{ /* '1204' */
			return 1204
		}
	case 1205:
		{ /* '1205' */
			return 1205
		}
	case 1206:
		{ /* '1206' */
			return 1206
		}
	case 1207:
		{ /* '1207' */
			return 1207
		}
	case 1208:
		{ /* '1208' */
			return 1208
		}
	case 1209:
		{ /* '1209' */
			return 1209
		}
	case 121:
		{ /* '121' */
			return 121
		}
	case 1210:
		{ /* '1210' */
			return 1210
		}
	case 1211:
		{ /* '1211' */
			return 1211
		}
	case 1212:
		{ /* '1212' */
			return 1212
		}
	case 1213:
		{ /* '1213' */
			return 1213
		}
	case 1214:
		{ /* '1214' */
			return 1214
		}
	case 1215:
		{ /* '1215' */
			return 1215
		}
	case 1216:
		{ /* '1216' */
			return 1216
		}
	case 1217:
		{ /* '1217' */
			return 1217
		}
	case 1218:
		{ /* '1218' */
			return 1218
		}
	case 1219:
		{ /* '1219' */
			return 1219
		}
	case 122:
		{ /* '122' */
			return 122
		}
	case 1220:
		{ /* '1220' */
			return 1220
		}
	case 1221:
		{ /* '1221' */
			return 1221
		}
	case 1222:
		{ /* '1222' */
			return 1222
		}
	case 1223:
		{ /* '1223' */
			return 1223
		}
	case 1224:
		{ /* '1224' */
			return 1224
		}
	case 1225:
		{ /* '1225' */
			return 1225
		}
	case 1226:
		{ /* '1226' */
			return 1226
		}
	case 1227:
		{ /* '1227' */
			return 1227
		}
	case 1228:
		{ /* '1228' */
			return 1228
		}
	case 1229:
		{ /* '1229' */
			return 1229
		}
	case 123:
		{ /* '123' */
			return 123
		}
	case 1230:
		{ /* '1230' */
			return 1230
		}
	case 1231:
		{ /* '1231' */
			return 1231
		}
	case 1232:
		{ /* '1232' */
			return 1232
		}
	case 1233:
		{ /* '1233' */
			return 1233
		}
	case 1234:
		{ /* '1234' */
			return 1234
		}
	case 1235:
		{ /* '1235' */
			return 1235
		}
	case 1236:
		{ /* '1236' */
			return 1236
		}
	case 1237:
		{ /* '1237' */
			return 1237
		}
	case 1238:
		{ /* '1238' */
			return 1238
		}
	case 1239:
		{ /* '1239' */
			return 1239
		}
	case 124:
		{ /* '124' */
			return 124
		}
	case 1240:
		{ /* '1240' */
			return 1240
		}
	case 1241:
		{ /* '1241' */
			return 1241
		}
	case 1242:
		{ /* '1242' */
			return 1242
		}
	case 1243:
		{ /* '1243' */
			return 1243
		}
	case 1244:
		{ /* '1244' */
			return 1244
		}
	case 1245:
		{ /* '1245' */
			return 1245
		}
	case 1246:
		{ /* '1246' */
			return 1246
		}
	case 1247:
		{ /* '1247' */
			return 1247
		}
	case 1248:
		{ /* '1248' */
			return 1248
		}
	case 1249:
		{ /* '1249' */
			return 1249
		}
	case 125:
		{ /* '125' */
			return 125
		}
	case 1250:
		{ /* '1250' */
			return 1250
		}
	case 1251:
		{ /* '1251' */
			return 1251
		}
	case 1252:
		{ /* '1252' */
			return 1252
		}
	case 1253:
		{ /* '1253' */
			return 1253
		}
	case 1254:
		{ /* '1254' */
			return 1254
		}
	case 1255:
		{ /* '1255' */
			return 1255
		}
	case 1256:
		{ /* '1256' */
			return 1256
		}
	case 1257:
		{ /* '1257' */
			return 1257
		}
	case 1258:
		{ /* '1258' */
			return 1258
		}
	case 1259:
		{ /* '1259' */
			return 1259
		}
	case 126:
		{ /* '126' */
			return 126
		}
	case 1260:
		{ /* '1260' */
			return 1260
		}
	case 1261:
		{ /* '1261' */
			return 1261
		}
	case 1262:
		{ /* '1262' */
			return 1262
		}
	case 1263:
		{ /* '1263' */
			return 1263
		}
	case 1264:
		{ /* '1264' */
			return 1264
		}
	case 1265:
		{ /* '1265' */
			return 1265
		}
	case 1266:
		{ /* '1266' */
			return 1266
		}
	case 1267:
		{ /* '1267' */
			return 1267
		}
	case 1268:
		{ /* '1268' */
			return 1268
		}
	case 1269:
		{ /* '1269' */
			return 1269
		}
	case 127:
		{ /* '127' */
			return 127
		}
	case 1270:
		{ /* '1270' */
			return 1270
		}
	case 1271:
		{ /* '1271' */
			return 1271
		}
	case 1272:
		{ /* '1272' */
			return 1272
		}
	case 1273:
		{ /* '1273' */
			return 1273
		}
	case 1274:
		{ /* '1274' */
			return 1274
		}
	case 1275:
		{ /* '1275' */
			return 1275
		}
	case 1276:
		{ /* '1276' */
			return 1276
		}
	case 1277:
		{ /* '1277' */
			return 1277
		}
	case 1278:
		{ /* '1278' */
			return 1278
		}
	case 1279:
		{ /* '1279' */
			return 1279
		}
	case 128:
		{ /* '128' */
			return 128
		}
	case 1280:
		{ /* '1280' */
			return 1280
		}
	case 1281:
		{ /* '1281' */
			return 1281
		}
	case 1282:
		{ /* '1282' */
			return 1282
		}
	case 1283:
		{ /* '1283' */
			return 1283
		}
	case 1284:
		{ /* '1284' */
			return 1284
		}
	case 1285:
		{ /* '1285' */
			return 1285
		}
	case 1286:
		{ /* '1286' */
			return 1286
		}
	case 1287:
		{ /* '1287' */
			return 1287
		}
	case 1288:
		{ /* '1288' */
			return 1288
		}
	case 1289:
		{ /* '1289' */
			return 1289
		}
	case 129:
		{ /* '129' */
			return 129
		}
	case 1290:
		{ /* '1290' */
			return 1290
		}
	case 1291:
		{ /* '1291' */
			return 1291
		}
	case 1292:
		{ /* '1292' */
			return 1292
		}
	case 1293:
		{ /* '1293' */
			return 1293
		}
	case 1294:
		{ /* '1294' */
			return 1294
		}
	case 1295:
		{ /* '1295' */
			return 1295
		}
	case 1296:
		{ /* '1296' */
			return 1296
		}
	case 1297:
		{ /* '1297' */
			return 1297
		}
	case 1298:
		{ /* '1298' */
			return 1298
		}
	case 1299:
		{ /* '1299' */
			return 1299
		}
	case 13:
		{ /* '13' */
			return 13
		}
	case 130:
		{ /* '130' */
			return 130
		}
	case 1300:
		{ /* '1300' */
			return 1300
		}
	case 1301:
		{ /* '1301' */
			return 1301
		}
	case 1302:
		{ /* '1302' */
			return 1302
		}
	case 1303:
		{ /* '1303' */
			return 1303
		}
	case 1304:
		{ /* '1304' */
			return 1304
		}
	case 1305:
		{ /* '1305' */
			return 1305
		}
	case 1306:
		{ /* '1306' */
			return 1306
		}
	case 1307:
		{ /* '1307' */
			return 1307
		}
	case 1308:
		{ /* '1308' */
			return 1308
		}
	case 1309:
		{ /* '1309' */
			return 1309
		}
	case 131:
		{ /* '131' */
			return 131
		}
	case 1310:
		{ /* '1310' */
			return 1310
		}
	case 1311:
		{ /* '1311' */
			return 1311
		}
	case 1312:
		{ /* '1312' */
			return 1312
		}
	case 1313:
		{ /* '1313' */
			return 1313
		}
	case 1314:
		{ /* '1314' */
			return 1314
		}
	case 1315:
		{ /* '1315' */
			return 1315
		}
	case 1316:
		{ /* '1316' */
			return 1316
		}
	case 1317:
		{ /* '1317' */
			return 1317
		}
	case 1318:
		{ /* '1318' */
			return 1318
		}
	case 1319:
		{ /* '1319' */
			return 1319
		}
	case 132:
		{ /* '132' */
			return 132
		}
	case 1320:
		{ /* '1320' */
			return 1320
		}
	case 1321:
		{ /* '1321' */
			return 1321
		}
	case 1322:
		{ /* '1322' */
			return 1322
		}
	case 1323:
		{ /* '1323' */
			return 1323
		}
	case 1324:
		{ /* '1324' */
			return 1324
		}
	case 1325:
		{ /* '1325' */
			return 1325
		}
	case 1326:
		{ /* '1326' */
			return 1326
		}
	case 1327:
		{ /* '1327' */
			return 1327
		}
	case 1328:
		{ /* '1328' */
			return 1328
		}
	case 1329:
		{ /* '1329' */
			return 1329
		}
	case 133:
		{ /* '133' */
			return 133
		}
	case 1330:
		{ /* '1330' */
			return 1330
		}
	case 1331:
		{ /* '1331' */
			return 1331
		}
	case 1332:
		{ /* '1332' */
			return 1332
		}
	case 1333:
		{ /* '1333' */
			return 1333
		}
	case 1334:
		{ /* '1334' */
			return 1334
		}
	case 1335:
		{ /* '1335' */
			return 1335
		}
	case 1336:
		{ /* '1336' */
			return 1336
		}
	case 1337:
		{ /* '1337' */
			return 1337
		}
	case 1338:
		{ /* '1338' */
			return 1338
		}
	case 1339:
		{ /* '1339' */
			return 1339
		}
	case 134:
		{ /* '134' */
			return 134
		}
	case 1340:
		{ /* '1340' */
			return 1340
		}
	case 1341:
		{ /* '1341' */
			return 1341
		}
	case 1342:
		{ /* '1342' */
			return 1342
		}
	case 1343:
		{ /* '1343' */
			return 1343
		}
	case 1344:
		{ /* '1344' */
			return 1344
		}
	case 1345:
		{ /* '1345' */
			return 1345
		}
	case 1346:
		{ /* '1346' */
			return 1346
		}
	case 1347:
		{ /* '1347' */
			return 1347
		}
	case 1348:
		{ /* '1348' */
			return 1348
		}
	case 1349:
		{ /* '1349' */
			return 1349
		}
	case 135:
		{ /* '135' */
			return 135
		}
	case 1350:
		{ /* '1350' */
			return 1350
		}
	case 1351:
		{ /* '1351' */
			return 1351
		}
	case 1352:
		{ /* '1352' */
			return 1352
		}
	case 1353:
		{ /* '1353' */
			return 1353
		}
	case 1354:
		{ /* '1354' */
			return 1354
		}
	case 1355:
		{ /* '1355' */
			return 1355
		}
	case 1356:
		{ /* '1356' */
			return 1356
		}
	case 1357:
		{ /* '1357' */
			return 1357
		}
	case 1358:
		{ /* '1358' */
			return 1358
		}
	case 1359:
		{ /* '1359' */
			return 1359
		}
	case 136:
		{ /* '136' */
			return 136
		}
	case 1360:
		{ /* '1360' */
			return 1360
		}
	case 1361:
		{ /* '1361' */
			return 1361
		}
	case 1362:
		{ /* '1362' */
			return 1362
		}
	case 1363:
		{ /* '1363' */
			return 1363
		}
	case 1364:
		{ /* '1364' */
			return 1364
		}
	case 1365:
		{ /* '1365' */
			return 1365
		}
	case 1366:
		{ /* '1366' */
			return 1366
		}
	case 1367:
		{ /* '1367' */
			return 1367
		}
	case 1368:
		{ /* '1368' */
			return 1368
		}
	case 1369:
		{ /* '1369' */
			return 1369
		}
	case 137:
		{ /* '137' */
			return 137
		}
	case 1370:
		{ /* '1370' */
			return 1370
		}
	case 1371:
		{ /* '1371' */
			return 1371
		}
	case 1372:
		{ /* '1372' */
			return 1372
		}
	case 1373:
		{ /* '1373' */
			return 1373
		}
	case 1374:
		{ /* '1374' */
			return 1374
		}
	case 1375:
		{ /* '1375' */
			return 1375
		}
	case 1376:
		{ /* '1376' */
			return 1376
		}
	case 1377:
		{ /* '1377' */
			return 1377
		}
	case 1378:
		{ /* '1378' */
			return 1378
		}
	case 1379:
		{ /* '1379' */
			return 1379
		}
	case 138:
		{ /* '138' */
			return 138
		}
	case 1380:
		{ /* '1380' */
			return 1380
		}
	case 1381:
		{ /* '1381' */
			return 1381
		}
	case 1382:
		{ /* '1382' */
			return 1382
		}
	case 1383:
		{ /* '1383' */
			return 1383
		}
	case 1384:
		{ /* '1384' */
			return 1384
		}
	case 1385:
		{ /* '1385' */
			return 1385
		}
	case 1386:
		{ /* '1386' */
			return 1386
		}
	case 1387:
		{ /* '1387' */
			return 1387
		}
	case 1388:
		{ /* '1388' */
			return 1388
		}
	case 1389:
		{ /* '1389' */
			return 1389
		}
	case 139:
		{ /* '139' */
			return 139
		}
	case 1390:
		{ /* '1390' */
			return 1390
		}
	case 1391:
		{ /* '1391' */
			return 1391
		}
	case 1392:
		{ /* '1392' */
			return 1392
		}
	case 1393:
		{ /* '1393' */
			return 1393
		}
	case 1394:
		{ /* '1394' */
			return 1394
		}
	case 1396:
		{ /* '1396' */
			return 1396
		}
	case 1397:
		{ /* '1397' */
			return 1397
		}
	case 1398:
		{ /* '1398' */
			return 1398
		}
	case 1399:
		{ /* '1399' */
			return 1399
		}
	case 14:
		{ /* '14' */
			return 14
		}
	case 140:
		{ /* '140' */
			return 140
		}
	case 1401:
		{ /* '1401' */
			return 1401
		}
	case 1402:
		{ /* '1402' */
			return 1402
		}
	case 1403:
		{ /* '1403' */
			return 1403
		}
	case 1404:
		{ /* '1404' */
			return 1404
		}
	case 1405:
		{ /* '1405' */
			return 1405
		}
	case 1406:
		{ /* '1406' */
			return 1406
		}
	case 1407:
		{ /* '1407' */
			return 1407
		}
	case 1408:
		{ /* '1408' */
			return 1408
		}
	case 1409:
		{ /* '1409' */
			return 1409
		}
	case 141:
		{ /* '141' */
			return 141
		}
	case 1410:
		{ /* '1410' */
			return 1410
		}
	case 1411:
		{ /* '1411' */
			return 1411
		}
	case 1412:
		{ /* '1412' */
			return 1412
		}
	case 1413:
		{ /* '1413' */
			return 1413
		}
	case 1414:
		{ /* '1414' */
			return 1414
		}
	case 1415:
		{ /* '1415' */
			return 1415
		}
	case 1416:
		{ /* '1416' */
			return 1416
		}
	case 1417:
		{ /* '1417' */
			return 1417
		}
	case 1418:
		{ /* '1418' */
			return 1418
		}
	case 1419:
		{ /* '1419' */
			return 1419
		}
	case 142:
		{ /* '142' */
			return 142
		}
	case 1420:
		{ /* '1420' */
			return 1420
		}
	case 1421:
		{ /* '1421' */
			return 1421
		}
	case 1422:
		{ /* '1422' */
			return 1422
		}
	case 1423:
		{ /* '1423' */
			return 1423
		}
	case 1424:
		{ /* '1424' */
			return 1424
		}
	case 1425:
		{ /* '1425' */
			return 1425
		}
	case 1426:
		{ /* '1426' */
			return 1426
		}
	case 1427:
		{ /* '1427' */
			return 1427
		}
	case 1428:
		{ /* '1428' */
			return 1428
		}
	case 1429:
		{ /* '1429' */
			return 1429
		}
	case 143:
		{ /* '143' */
			return 143
		}
	case 1430:
		{ /* '1430' */
			return 1430
		}
	case 1431:
		{ /* '1431' */
			return 1431
		}
	case 1432:
		{ /* '1432' */
			return 1432
		}
	case 1433:
		{ /* '1433' */
			return 1433
		}
	case 1434:
		{ /* '1434' */
			return 1434
		}
	case 1435:
		{ /* '1435' */
			return 1435
		}
	case 1436:
		{ /* '1436' */
			return 1436
		}
	case 1437:
		{ /* '1437' */
			return 1437
		}
	case 1438:
		{ /* '1438' */
			return 1438
		}
	case 1439:
		{ /* '1439' */
			return 1439
		}
	case 144:
		{ /* '144' */
			return 144
		}
	case 1440:
		{ /* '1440' */
			return 1440
		}
	case 1441:
		{ /* '1441' */
			return 1441
		}
	case 1442:
		{ /* '1442' */
			return 1442
		}
	case 1443:
		{ /* '1443' */
			return 1443
		}
	case 1444:
		{ /* '1444' */
			return 1444
		}
	case 1445:
		{ /* '1445' */
			return 1445
		}
	case 1446:
		{ /* '1446' */
			return 1446
		}
	case 1447:
		{ /* '1447' */
			return 1447
		}
	case 1448:
		{ /* '1448' */
			return 1448
		}
	case 1449:
		{ /* '1449' */
			return 1449
		}
	case 145:
		{ /* '145' */
			return 145
		}
	case 1450:
		{ /* '1450' */
			return 1450
		}
	case 1451:
		{ /* '1451' */
			return 1451
		}
	case 1452:
		{ /* '1452' */
			return 1452
		}
	case 1453:
		{ /* '1453' */
			return 1453
		}
	case 1454:
		{ /* '1454' */
			return 1454
		}
	case 1455:
		{ /* '1455' */
			return 1455
		}
	case 1456:
		{ /* '1456' */
			return 1456
		}
	case 1457:
		{ /* '1457' */
			return 1457
		}
	case 1458:
		{ /* '1458' */
			return 1458
		}
	case 1459:
		{ /* '1459' */
			return 1459
		}
	case 146:
		{ /* '146' */
			return 146
		}
	case 1460:
		{ /* '1460' */
			return 1460
		}
	case 1461:
		{ /* '1461' */
			return 1461
		}
	case 1462:
		{ /* '1462' */
			return 1462
		}
	case 1463:
		{ /* '1463' */
			return 1463
		}
	case 1464:
		{ /* '1464' */
			return 1464
		}
	case 1465:
		{ /* '1465' */
			return 1465
		}
	case 1466:
		{ /* '1466' */
			return 1466
		}
	case 1467:
		{ /* '1467' */
			return 1467
		}
	case 1468:
		{ /* '1468' */
			return 1468
		}
	case 1469:
		{ /* '1469' */
			return 1469
		}
	case 147:
		{ /* '147' */
			return 147
		}
	case 1470:
		{ /* '1470' */
			return 1470
		}
	case 1471:
		{ /* '1471' */
			return 1471
		}
	case 1472:
		{ /* '1472' */
			return 1472
		}
	case 1473:
		{ /* '1473' */
			return 1473
		}
	case 1474:
		{ /* '1474' */
			return 1474
		}
	case 1475:
		{ /* '1475' */
			return 1475
		}
	case 1476:
		{ /* '1476' */
			return 1476
		}
	case 1477:
		{ /* '1477' */
			return 1477
		}
	case 1478:
		{ /* '1478' */
			return 1478
		}
	case 1479:
		{ /* '1479' */
			return 1479
		}
	case 148:
		{ /* '148' */
			return 148
		}
	case 1480:
		{ /* '1480' */
			return 1480
		}
	case 1481:
		{ /* '1481' */
			return 1481
		}
	case 1482:
		{ /* '1482' */
			return 1482
		}
	case 1483:
		{ /* '1483' */
			return 1483
		}
	case 1484:
		{ /* '1484' */
			return 1484
		}
	case 1485:
		{ /* '1485' */
			return 1485
		}
	case 1486:
		{ /* '1486' */
			return 1486
		}
	case 1487:
		{ /* '1487' */
			return 1487
		}
	case 1488:
		{ /* '1488' */
			return 1488
		}
	case 1489:
		{ /* '1489' */
			return 1489
		}
	case 149:
		{ /* '149' */
			return 149
		}
	case 1490:
		{ /* '1490' */
			return 1490
		}
	case 1491:
		{ /* '1491' */
			return 1491
		}
	case 1492:
		{ /* '1492' */
			return 1492
		}
	case 1493:
		{ /* '1493' */
			return 1493
		}
	case 1494:
		{ /* '1494' */
			return 1494
		}
	case 1495:
		{ /* '1495' */
			return 1495
		}
	case 1496:
		{ /* '1496' */
			return 1496
		}
	case 1497:
		{ /* '1497' */
			return 1497
		}
	case 1498:
		{ /* '1498' */
			return 1498
		}
	case 1499:
		{ /* '1499' */
			return 1499
		}
	case 15:
		{ /* '15' */
			return 15
		}
	case 150:
		{ /* '150' */
			return 150
		}
	case 1500:
		{ /* '1500' */
			return 1500
		}
	case 1501:
		{ /* '1501' */
			return 1501
		}
	case 1502:
		{ /* '1502' */
			return 1502
		}
	case 1503:
		{ /* '1503' */
			return 1503
		}
	case 1504:
		{ /* '1504' */
			return 1504
		}
	case 1505:
		{ /* '1505' */
			return 1505
		}
	case 1506:
		{ /* '1506' */
			return 1506
		}
	case 1507:
		{ /* '1507' */
			return 1507
		}
	case 1508:
		{ /* '1508' */
			return 1508
		}
	case 1509:
		{ /* '1509' */
			return 1509
		}
	case 151:
		{ /* '151' */
			return 151
		}
	case 1510:
		{ /* '1510' */
			return 1510
		}
	case 1511:
		{ /* '1511' */
			return 1511
		}
	case 1512:
		{ /* '1512' */
			return 1512
		}
	case 1513:
		{ /* '1513' */
			return 1513
		}
	case 1514:
		{ /* '1514' */
			return 1514
		}
	case 1515:
		{ /* '1515' */
			return 1515
		}
	case 1516:
		{ /* '1516' */
			return 1516
		}
	case 1517:
		{ /* '1517' */
			return 1517
		}
	case 1518:
		{ /* '1518' */
			return 1518
		}
	case 1519:
		{ /* '1519' */
			return 1519
		}
	case 152:
		{ /* '152' */
			return 152
		}
	case 1521:
		{ /* '1521' */
			return 1521
		}
	case 1522:
		{ /* '1522' */
			return 1522
		}
	case 1523:
		{ /* '1523' */
			return 1523
		}
	case 1524:
		{ /* '1524' */
			return 1524
		}
	case 1525:
		{ /* '1525' */
			return 1525
		}
	case 1526:
		{ /* '1526' */
			return 1526
		}
	case 1527:
		{ /* '1527' */
			return 1527
		}
	case 1528:
		{ /* '1528' */
			return 1528
		}
	case 1529:
		{ /* '1529' */
			return 1529
		}
	case 153:
		{ /* '153' */
			return 153
		}
	case 1530:
		{ /* '1530' */
			return 1530
		}
	case 1531:
		{ /* '1531' */
			return 1531
		}
	case 1532:
		{ /* '1532' */
			return 1532
		}
	case 1533:
		{ /* '1533' */
			return 1533
		}
	case 1534:
		{ /* '1534' */
			return 1534
		}
	case 1535:
		{ /* '1535' */
			return 1535
		}
	case 1536:
		{ /* '1536' */
			return 1536
		}
	case 1537:
		{ /* '1537' */
			return 1537
		}
	case 1538:
		{ /* '1538' */
			return 1538
		}
	case 1539:
		{ /* '1539' */
			return 1539
		}
	case 154:
		{ /* '154' */
			return 154
		}
	case 1540:
		{ /* '1540' */
			return 1540
		}
	case 1541:
		{ /* '1541' */
			return 1541
		}
	case 1542:
		{ /* '1542' */
			return 1542
		}
	case 1543:
		{ /* '1543' */
			return 1543
		}
	case 1544:
		{ /* '1544' */
			return 1544
		}
	case 1545:
		{ /* '1545' */
			return 1545
		}
	case 1546:
		{ /* '1546' */
			return 1546
		}
	case 1547:
		{ /* '1547' */
			return 1547
		}
	case 1548:
		{ /* '1548' */
			return 1548
		}
	case 1549:
		{ /* '1549' */
			return 1549
		}
	case 155:
		{ /* '155' */
			return 155
		}
	case 1550:
		{ /* '1550' */
			return 1550
		}
	case 1551:
		{ /* '1551' */
			return 1551
		}
	case 1552:
		{ /* '1552' */
			return 1552
		}
	case 1553:
		{ /* '1553' */
			return 1553
		}
	case 1554:
		{ /* '1554' */
			return 1554
		}
	case 1555:
		{ /* '1555' */
			return 1555
		}
	case 1556:
		{ /* '1556' */
			return 1556
		}
	case 1557:
		{ /* '1557' */
			return 1557
		}
	case 1558:
		{ /* '1558' */
			return 1558
		}
	case 1559:
		{ /* '1559' */
			return 1559
		}
	case 156:
		{ /* '156' */
			return 156
		}
	case 1560:
		{ /* '1560' */
			return 1560
		}
	case 1561:
		{ /* '1561' */
			return 1561
		}
	case 1562:
		{ /* '1562' */
			return 1562
		}
	case 1563:
		{ /* '1563' */
			return 1563
		}
	case 1564:
		{ /* '1564' */
			return 1564
		}
	case 1565:
		{ /* '1565' */
			return 1565
		}
	case 1566:
		{ /* '1566' */
			return 1566
		}
	case 157:
		{ /* '157' */
			return 157
		}
	case 158:
		{ /* '158' */
			return 158
		}
	case 159:
		{ /* '159' */
			return 159
		}
	case 16:
		{ /* '16' */
			return 16
		}
	case 160:
		{ /* '160' */
			return 160
		}
	case 161:
		{ /* '161' */
			return 161
		}
	case 162:
		{ /* '162' */
			return 162
		}
	case 163:
		{ /* '163' */
			return 163
		}
	case 164:
		{ /* '164' */
			return 164
		}
	case 165:
		{ /* '165' */
			return 165
		}
	case 166:
		{ /* '166' */
			return 166
		}
	case 167:
		{ /* '167' */
			return 167
		}
	case 168:
		{ /* '168' */
			return 168
		}
	case 169:
		{ /* '169' */
			return 169
		}
	case 17:
		{ /* '17' */
			return 17
		}
	case 170:
		{ /* '170' */
			return 170
		}
	case 171:
		{ /* '171' */
			return 171
		}
	case 172:
		{ /* '172' */
			return 172
		}
	case 173:
		{ /* '173' */
			return 173
		}
	case 174:
		{ /* '174' */
			return 174
		}
	case 175:
		{ /* '175' */
			return 175
		}
	case 176:
		{ /* '176' */
			return 176
		}
	case 177:
		{ /* '177' */
			return 177
		}
	case 178:
		{ /* '178' */
			return 178
		}
	case 179:
		{ /* '179' */
			return 179
		}
	case 18:
		{ /* '18' */
			return 18
		}
	case 180:
		{ /* '180' */
			return 180
		}
	case 181:
		{ /* '181' */
			return 181
		}
	case 182:
		{ /* '182' */
			return 182
		}
	case 183:
		{ /* '183' */
			return 183
		}
	case 184:
		{ /* '184' */
			return 184
		}
	case 185:
		{ /* '185' */
			return 185
		}
	case 186:
		{ /* '186' */
			return 186
		}
	case 187:
		{ /* '187' */
			return 187
		}
	case 188:
		{ /* '188' */
			return 188
		}
	case 189:
		{ /* '189' */
			return 189
		}
	case 19:
		{ /* '19' */
			return 19
		}
	case 190:
		{ /* '190' */
			return 190
		}
	case 191:
		{ /* '191' */
			return 191
		}
	case 192:
		{ /* '192' */
			return 192
		}
	case 193:
		{ /* '193' */
			return 193
		}
	case 194:
		{ /* '194' */
			return 194
		}
	case 195:
		{ /* '195' */
			return 195
		}
	case 196:
		{ /* '196' */
			return 196
		}
	case 197:
		{ /* '197' */
			return 197
		}
	case 198:
		{ /* '198' */
			return 198
		}
	case 199:
		{ /* '199' */
			return 199
		}
	case 2:
		{ /* '2' */
			return 2
		}
	case 20:
		{ /* '20' */
			return 20
		}
	case 200:
		{ /* '200' */
			return 200
		}
	case 201:
		{ /* '201' */
			return 201
		}
	case 202:
		{ /* '202' */
			return 202
		}
	case 203:
		{ /* '203' */
			return 203
		}
	case 204:
		{ /* '204' */
			return 204
		}
	case 205:
		{ /* '205' */
			return 205
		}
	case 206:
		{ /* '206' */
			return 206
		}
	case 207:
		{ /* '207' */
			return 207
		}
	case 208:
		{ /* '208' */
			return 208
		}
	case 209:
		{ /* '209' */
			return 209
		}
	case 21:
		{ /* '21' */
			return 21
		}
	case 210:
		{ /* '210' */
			return 210
		}
	case 211:
		{ /* '211' */
			return 211
		}
	case 212:
		{ /* '212' */
			return 212
		}
	case 213:
		{ /* '213' */
			return 213
		}
	case 214:
		{ /* '214' */
			return 214
		}
	case 215:
		{ /* '215' */
			return 215
		}
	case 216:
		{ /* '216' */
			return 216
		}
	case 217:
		{ /* '217' */
			return 217
		}
	case 218:
		{ /* '218' */
			return 218
		}
	case 219:
		{ /* '219' */
			return 219
		}
	case 22:
		{ /* '22' */
			return 22
		}
	case 220:
		{ /* '220' */
			return 220
		}
	case 221:
		{ /* '221' */
			return 221
		}
	case 222:
		{ /* '222' */
			return 222
		}
	case 223:
		{ /* '223' */
			return 223
		}
	case 224:
		{ /* '224' */
			return 224
		}
	case 225:
		{ /* '225' */
			return 225
		}
	case 226:
		{ /* '226' */
			return 226
		}
	case 227:
		{ /* '227' */
			return 227
		}
	case 228:
		{ /* '228' */
			return 228
		}
	case 229:
		{ /* '229' */
			return 229
		}
	case 23:
		{ /* '23' */
			return 23
		}
	case 230:
		{ /* '230' */
			return 230
		}
	case 231:
		{ /* '231' */
			return 231
		}
	case 232:
		{ /* '232' */
			return 232
		}
	case 233:
		{ /* '233' */
			return 233
		}
	case 234:
		{ /* '234' */
			return 234
		}
	case 235:
		{ /* '235' */
			return 235
		}
	case 236:
		{ /* '236' */
			return 236
		}
	case 237:
		{ /* '237' */
			return 237
		}
	case 238:
		{ /* '238' */
			return 238
		}
	case 239:
		{ /* '239' */
			return 239
		}
	case 24:
		{ /* '24' */
			return 24
		}
	case 240:
		{ /* '240' */
			return 240
		}
	case 241:
		{ /* '241' */
			return 241
		}
	case 242:
		{ /* '242' */
			return 242
		}
	case 243:
		{ /* '243' */
			return 243
		}
	case 244:
		{ /* '244' */
			return 244
		}
	case 245:
		{ /* '245' */
			return 245
		}
	case 246:
		{ /* '246' */
			return 246
		}
	case 247:
		{ /* '247' */
			return 247
		}
	case 248:
		{ /* '248' */
			return 248
		}
	case 249:
		{ /* '249' */
			return 249
		}
	case 25:
		{ /* '25' */
			return 25
		}
	case 250:
		{ /* '250' */
			return 250
		}
	case 251:
		{ /* '251' */
			return 251
		}
	case 252:
		{ /* '252' */
			return 252
		}
	case 253:
		{ /* '253' */
			return 253
		}
	case 254:
		{ /* '254' */
			return 254
		}
	case 255:
		{ /* '255' */
			return 255
		}
	case 256:
		{ /* '256' */
			return 256
		}
	case 257:
		{ /* '257' */
			return 257
		}
	case 258:
		{ /* '258' */
			return 258
		}
	case 259:
		{ /* '259' */
			return 259
		}
	case 26:
		{ /* '26' */
			return 26
		}
	case 260:
		{ /* '260' */
			return 260
		}
	case 261:
		{ /* '261' */
			return 261
		}
	case 262:
		{ /* '262' */
			return 262
		}
	case 263:
		{ /* '263' */
			return 263
		}
	case 264:
		{ /* '264' */
			return 264
		}
	case 265:
		{ /* '265' */
			return 265
		}
	case 266:
		{ /* '266' */
			return 266
		}
	case 267:
		{ /* '267' */
			return 267
		}
	case 268:
		{ /* '268' */
			return 268
		}
	case 269:
		{ /* '269' */
			return 269
		}
	case 27:
		{ /* '27' */
			return 27
		}
	case 270:
		{ /* '270' */
			return 270
		}
	case 271:
		{ /* '271' */
			return 271
		}
	case 272:
		{ /* '272' */
			return 272
		}
	case 273:
		{ /* '273' */
			return 273
		}
	case 274:
		{ /* '274' */
			return 274
		}
	case 275:
		{ /* '275' */
			return 275
		}
	case 276:
		{ /* '276' */
			return 276
		}
	case 277:
		{ /* '277' */
			return 277
		}
	case 278:
		{ /* '278' */
			return 278
		}
	case 279:
		{ /* '279' */
			return 279
		}
	case 28:
		{ /* '28' */
			return 28
		}
	case 280:
		{ /* '280' */
			return 280
		}
	case 281:
		{ /* '281' */
			return 281
		}
	case 282:
		{ /* '282' */
			return 282
		}
	case 283:
		{ /* '283' */
			return 283
		}
	case 284:
		{ /* '284' */
			return 284
		}
	case 285:
		{ /* '285' */
			return 285
		}
	case 286:
		{ /* '286' */
			return 286
		}
	case 287:
		{ /* '287' */
			return 287
		}
	case 288:
		{ /* '288' */
			return 288
		}
	case 289:
		{ /* '289' */
			return 289
		}
	case 29:
		{ /* '29' */
			return 29
		}
	case 290:
		{ /* '290' */
			return 290
		}
	case 291:
		{ /* '291' */
			return 291
		}
	case 292:
		{ /* '292' */
			return 292
		}
	case 293:
		{ /* '293' */
			return 293
		}
	case 294:
		{ /* '294' */
			return 294
		}
	case 295:
		{ /* '295' */
			return 295
		}
	case 296:
		{ /* '296' */
			return 296
		}
	case 297:
		{ /* '297' */
			return 297
		}
	case 298:
		{ /* '298' */
			return 298
		}
	case 299:
		{ /* '299' */
			return 299
		}
	case 3:
		{ /* '3' */
			return 3
		}
	case 30:
		{ /* '30' */
			return 30
		}
	case 300:
		{ /* '300' */
			return 300
		}
	case 301:
		{ /* '301' */
			return 301
		}
	case 302:
		{ /* '302' */
			return 302
		}
	case 303:
		{ /* '303' */
			return 303
		}
	case 304:
		{ /* '304' */
			return 304
		}
	case 305:
		{ /* '305' */
			return 305
		}
	case 306:
		{ /* '306' */
			return 306
		}
	case 307:
		{ /* '307' */
			return 307
		}
	case 308:
		{ /* '308' */
			return 308
		}
	case 309:
		{ /* '309' */
			return 309
		}
	case 31:
		{ /* '31' */
			return 31
		}
	case 310:
		{ /* '310' */
			return 310
		}
	case 311:
		{ /* '311' */
			return 311
		}
	case 312:
		{ /* '312' */
			return 312
		}
	case 313:
		{ /* '313' */
			return 313
		}
	case 314:
		{ /* '314' */
			return 314
		}
	case 315:
		{ /* '315' */
			return 315
		}
	case 316:
		{ /* '316' */
			return 316
		}
	case 317:
		{ /* '317' */
			return 317
		}
	case 318:
		{ /* '318' */
			return 318
		}
	case 319:
		{ /* '319' */
			return 319
		}
	case 32:
		{ /* '32' */
			return 32
		}
	case 320:
		{ /* '320' */
			return 320
		}
	case 321:
		{ /* '321' */
			return 321
		}
	case 322:
		{ /* '322' */
			return 322
		}
	case 323:
		{ /* '323' */
			return 323
		}
	case 324:
		{ /* '324' */
			return 324
		}
	case 325:
		{ /* '325' */
			return 325
		}
	case 326:
		{ /* '326' */
			return 326
		}
	case 327:
		{ /* '327' */
			return 327
		}
	case 328:
		{ /* '328' */
			return 328
		}
	case 329:
		{ /* '329' */
			return 329
		}
	case 33:
		{ /* '33' */
			return 33
		}
	case 330:
		{ /* '330' */
			return 330
		}
	case 331:
		{ /* '331' */
			return 331
		}
	case 332:
		{ /* '332' */
			return 332
		}
	case 333:
		{ /* '333' */
			return 333
		}
	case 334:
		{ /* '334' */
			return 334
		}
	case 335:
		{ /* '335' */
			return 335
		}
	case 336:
		{ /* '336' */
			return 336
		}
	case 337:
		{ /* '337' */
			return 337
		}
	case 338:
		{ /* '338' */
			return 338
		}
	case 339:
		{ /* '339' */
			return 339
		}
	case 34:
		{ /* '34' */
			return 34
		}
	case 340:
		{ /* '340' */
			return 340
		}
	case 341:
		{ /* '341' */
			return 341
		}
	case 342:
		{ /* '342' */
			return 342
		}
	case 343:
		{ /* '343' */
			return 343
		}
	case 344:
		{ /* '344' */
			return 344
		}
	case 345:
		{ /* '345' */
			return 345
		}
	case 346:
		{ /* '346' */
			return 346
		}
	case 347:
		{ /* '347' */
			return 347
		}
	case 348:
		{ /* '348' */
			return 348
		}
	case 349:
		{ /* '349' */
			return 349
		}
	case 35:
		{ /* '35' */
			return 35
		}
	case 350:
		{ /* '350' */
			return 350
		}
	case 351:
		{ /* '351' */
			return 351
		}
	case 352:
		{ /* '352' */
			return 352
		}
	case 353:
		{ /* '353' */
			return 353
		}
	case 354:
		{ /* '354' */
			return 354
		}
	case 355:
		{ /* '355' */
			return 355
		}
	case 356:
		{ /* '356' */
			return 356
		}
	case 357:
		{ /* '357' */
			return 357
		}
	case 358:
		{ /* '358' */
			return 358
		}
	case 359:
		{ /* '359' */
			return 359
		}
	case 36:
		{ /* '36' */
			return 36
		}
	case 360:
		{ /* '360' */
			return 360
		}
	case 361:
		{ /* '361' */
			return 361
		}
	case 362:
		{ /* '362' */
			return 362
		}
	case 363:
		{ /* '363' */
			return 363
		}
	case 364:
		{ /* '364' */
			return 364
		}
	case 365:
		{ /* '365' */
			return 365
		}
	case 366:
		{ /* '366' */
			return 366
		}
	case 367:
		{ /* '367' */
			return 367
		}
	case 368:
		{ /* '368' */
			return 368
		}
	case 369:
		{ /* '369' */
			return 369
		}
	case 37:
		{ /* '37' */
			return 37
		}
	case 370:
		{ /* '370' */
			return 370
		}
	case 371:
		{ /* '371' */
			return 371
		}
	case 372:
		{ /* '372' */
			return 372
		}
	case 373:
		{ /* '373' */
			return 373
		}
	case 374:
		{ /* '374' */
			return 374
		}
	case 375:
		{ /* '375' */
			return 375
		}
	case 376:
		{ /* '376' */
			return 376
		}
	case 377:
		{ /* '377' */
			return 377
		}
	case 378:
		{ /* '378' */
			return 378
		}
	case 379:
		{ /* '379' */
			return 379
		}
	case 38:
		{ /* '38' */
			return 38
		}
	case 380:
		{ /* '380' */
			return 380
		}
	case 381:
		{ /* '381' */
			return 381
		}
	case 382:
		{ /* '382' */
			return 382
		}
	case 383:
		{ /* '383' */
			return 383
		}
	case 384:
		{ /* '384' */
			return 384
		}
	case 385:
		{ /* '385' */
			return 385
		}
	case 386:
		{ /* '386' */
			return 386
		}
	case 387:
		{ /* '387' */
			return 387
		}
	case 388:
		{ /* '388' */
			return 388
		}
	case 389:
		{ /* '389' */
			return 389
		}
	case 39:
		{ /* '39' */
			return 39
		}
	case 390:
		{ /* '390' */
			return 390
		}
	case 391:
		{ /* '391' */
			return 391
		}
	case 392:
		{ /* '392' */
			return 392
		}
	case 393:
		{ /* '393' */
			return 393
		}
	case 394:
		{ /* '394' */
			return 394
		}
	case 395:
		{ /* '395' */
			return 395
		}
	case 396:
		{ /* '396' */
			return 396
		}
	case 397:
		{ /* '397' */
			return 397
		}
	case 398:
		{ /* '398' */
			return 398
		}
	case 399:
		{ /* '399' */
			return 399
		}
	case 4:
		{ /* '4' */
			return 4
		}
	case 40:
		{ /* '40' */
			return 40
		}
	case 400:
		{ /* '400' */
			return 400
		}
	case 401:
		{ /* '401' */
			return 401
		}
	case 402:
		{ /* '402' */
			return 402
		}
	case 403:
		{ /* '403' */
			return 403
		}
	case 404:
		{ /* '404' */
			return 404
		}
	case 405:
		{ /* '405' */
			return 405
		}
	case 406:
		{ /* '406' */
			return 406
		}
	case 407:
		{ /* '407' */
			return 407
		}
	case 408:
		{ /* '408' */
			return 408
		}
	case 409:
		{ /* '409' */
			return 409
		}
	case 41:
		{ /* '41' */
			return 41
		}
	case 410:
		{ /* '410' */
			return 410
		}
	case 411:
		{ /* '411' */
			return 411
		}
	case 412:
		{ /* '412' */
			return 412
		}
	case 413:
		{ /* '413' */
			return 413
		}
	case 414:
		{ /* '414' */
			return 414
		}
	case 415:
		{ /* '415' */
			return 415
		}
	case 416:
		{ /* '416' */
			return 416
		}
	case 417:
		{ /* '417' */
			return 417
		}
	case 418:
		{ /* '418' */
			return 418
		}
	case 419:
		{ /* '419' */
			return 419
		}
	case 42:
		{ /* '42' */
			return 42
		}
	case 420:
		{ /* '420' */
			return 420
		}
	case 421:
		{ /* '421' */
			return 421
		}
	case 422:
		{ /* '422' */
			return 422
		}
	case 423:
		{ /* '423' */
			return 423
		}
	case 424:
		{ /* '424' */
			return 424
		}
	case 425:
		{ /* '425' */
			return 425
		}
	case 426:
		{ /* '426' */
			return 426
		}
	case 427:
		{ /* '427' */
			return 427
		}
	case 428:
		{ /* '428' */
			return 428
		}
	case 429:
		{ /* '429' */
			return 429
		}
	case 43:
		{ /* '43' */
			return 43
		}
	case 430:
		{ /* '430' */
			return 430
		}
	case 431:
		{ /* '431' */
			return 431
		}
	case 432:
		{ /* '432' */
			return 432
		}
	case 433:
		{ /* '433' */
			return 433
		}
	case 434:
		{ /* '434' */
			return 434
		}
	case 435:
		{ /* '435' */
			return 435
		}
	case 436:
		{ /* '436' */
			return 436
		}
	case 437:
		{ /* '437' */
			return 437
		}
	case 438:
		{ /* '438' */
			return 438
		}
	case 439:
		{ /* '439' */
			return 439
		}
	case 44:
		{ /* '44' */
			return 44
		}
	case 440:
		{ /* '440' */
			return 440
		}
	case 441:
		{ /* '441' */
			return 441
		}
	case 442:
		{ /* '442' */
			return 442
		}
	case 443:
		{ /* '443' */
			return 443
		}
	case 444:
		{ /* '444' */
			return 444
		}
	case 445:
		{ /* '445' */
			return 445
		}
	case 446:
		{ /* '446' */
			return 446
		}
	case 447:
		{ /* '447' */
			return 447
		}
	case 448:
		{ /* '448' */
			return 448
		}
	case 449:
		{ /* '449' */
			return 449
		}
	case 45:
		{ /* '45' */
			return 45
		}
	case 450:
		{ /* '450' */
			return 450
		}
	case 451:
		{ /* '451' */
			return 451
		}
	case 452:
		{ /* '452' */
			return 452
		}
	case 453:
		{ /* '453' */
			return 453
		}
	case 454:
		{ /* '454' */
			return 454
		}
	case 455:
		{ /* '455' */
			return 455
		}
	case 456:
		{ /* '456' */
			return 456
		}
	case 457:
		{ /* '457' */
			return 457
		}
	case 458:
		{ /* '458' */
			return 458
		}
	case 459:
		{ /* '459' */
			return 459
		}
	case 46:
		{ /* '46' */
			return 46
		}
	case 460:
		{ /* '460' */
			return 460
		}
	case 461:
		{ /* '461' */
			return 461
		}
	case 462:
		{ /* '462' */
			return 462
		}
	case 463:
		{ /* '463' */
			return 463
		}
	case 464:
		{ /* '464' */
			return 464
		}
	case 465:
		{ /* '465' */
			return 465
		}
	case 466:
		{ /* '466' */
			return 466
		}
	case 467:
		{ /* '467' */
			return 467
		}
	case 468:
		{ /* '468' */
			return 468
		}
	case 469:
		{ /* '469' */
			return 469
		}
	case 47:
		{ /* '47' */
			return 47
		}
	case 470:
		{ /* '470' */
			return 470
		}
	case 471:
		{ /* '471' */
			return 471
		}
	case 472:
		{ /* '472' */
			return 472
		}
	case 473:
		{ /* '473' */
			return 473
		}
	case 474:
		{ /* '474' */
			return 474
		}
	case 475:
		{ /* '475' */
			return 475
		}
	case 476:
		{ /* '476' */
			return 476
		}
	case 477:
		{ /* '477' */
			return 477
		}
	case 478:
		{ /* '478' */
			return 478
		}
	case 479:
		{ /* '479' */
			return 479
		}
	case 48:
		{ /* '48' */
			return 48
		}
	case 480:
		{ /* '480' */
			return 480
		}
	case 481:
		{ /* '481' */
			return 481
		}
	case 482:
		{ /* '482' */
			return 482
		}
	case 483:
		{ /* '483' */
			return 483
		}
	case 484:
		{ /* '484' */
			return 484
		}
	case 485:
		{ /* '485' */
			return 485
		}
	case 486:
		{ /* '486' */
			return 486
		}
	case 487:
		{ /* '487' */
			return 487
		}
	case 488:
		{ /* '488' */
			return 488
		}
	case 489:
		{ /* '489' */
			return 489
		}
	case 49:
		{ /* '49' */
			return 49
		}
	case 490:
		{ /* '490' */
			return 490
		}
	case 491:
		{ /* '491' */
			return 491
		}
	case 492:
		{ /* '492' */
			return 492
		}
	case 493:
		{ /* '493' */
			return 493
		}
	case 494:
		{ /* '494' */
			return 494
		}
	case 495:
		{ /* '495' */
			return 495
		}
	case 496:
		{ /* '496' */
			return 496
		}
	case 497:
		{ /* '497' */
			return 497
		}
	case 498:
		{ /* '498' */
			return 498
		}
	case 499:
		{ /* '499' */
			return 499
		}
	case 5:
		{ /* '5' */
			return 5
		}
	case 50:
		{ /* '50' */
			return 50
		}
	case 500:
		{ /* '500' */
			return 500
		}
	case 501:
		{ /* '501' */
			return 501
		}
	case 502:
		{ /* '502' */
			return 502
		}
	case 503:
		{ /* '503' */
			return 503
		}
	case 504:
		{ /* '504' */
			return 504
		}
	case 505:
		{ /* '505' */
			return 505
		}
	case 506:
		{ /* '506' */
			return 506
		}
	case 507:
		{ /* '507' */
			return 507
		}
	case 508:
		{ /* '508' */
			return 508
		}
	case 509:
		{ /* '509' */
			return 509
		}
	case 51:
		{ /* '51' */
			return 51
		}
	case 510:
		{ /* '510' */
			return 510
		}
	case 511:
		{ /* '511' */
			return 511
		}
	case 512:
		{ /* '512' */
			return 512
		}
	case 513:
		{ /* '513' */
			return 513
		}
	case 514:
		{ /* '514' */
			return 514
		}
	case 515:
		{ /* '515' */
			return 515
		}
	case 516:
		{ /* '516' */
			return 516
		}
	case 517:
		{ /* '517' */
			return 517
		}
	case 518:
		{ /* '518' */
			return 518
		}
	case 519:
		{ /* '519' */
			return 519
		}
	case 52:
		{ /* '52' */
			return 52
		}
	case 520:
		{ /* '520' */
			return 520
		}
	case 521:
		{ /* '521' */
			return 521
		}
	case 522:
		{ /* '522' */
			return 522
		}
	case 523:
		{ /* '523' */
			return 523
		}
	case 524:
		{ /* '524' */
			return 524
		}
	case 525:
		{ /* '525' */
			return 525
		}
	case 526:
		{ /* '526' */
			return 526
		}
	case 527:
		{ /* '527' */
			return 527
		}
	case 528:
		{ /* '528' */
			return 528
		}
	case 529:
		{ /* '529' */
			return 529
		}
	case 53:
		{ /* '53' */
			return 53
		}
	case 530:
		{ /* '530' */
			return 530
		}
	case 531:
		{ /* '531' */
			return 531
		}
	case 532:
		{ /* '532' */
			return 532
		}
	case 533:
		{ /* '533' */
			return 533
		}
	case 534:
		{ /* '534' */
			return 534
		}
	case 535:
		{ /* '535' */
			return 535
		}
	case 536:
		{ /* '536' */
			return 536
		}
	case 537:
		{ /* '537' */
			return 537
		}
	case 538:
		{ /* '538' */
			return 538
		}
	case 539:
		{ /* '539' */
			return 539
		}
	case 54:
		{ /* '54' */
			return 54
		}
	case 540:
		{ /* '540' */
			return 540
		}
	case 541:
		{ /* '541' */
			return 541
		}
	case 542:
		{ /* '542' */
			return 542
		}
	case 543:
		{ /* '543' */
			return 543
		}
	case 544:
		{ /* '544' */
			return 544
		}
	case 545:
		{ /* '545' */
			return 545
		}
	case 546:
		{ /* '546' */
			return 546
		}
	case 547:
		{ /* '547' */
			return 547
		}
	case 548:
		{ /* '548' */
			return 548
		}
	case 549:
		{ /* '549' */
			return 549
		}
	case 55:
		{ /* '55' */
			return 55
		}
	case 550:
		{ /* '550' */
			return 550
		}
	case 551:
		{ /* '551' */
			return 551
		}
	case 552:
		{ /* '552' */
			return 552
		}
	case 553:
		{ /* '553' */
			return 553
		}
	case 554:
		{ /* '554' */
			return 554
		}
	case 556:
		{ /* '556' */
			return 556
		}
	case 557:
		{ /* '557' */
			return 557
		}
	case 558:
		{ /* '558' */
			return 558
		}
	case 559:
		{ /* '559' */
			return 559
		}
	case 56:
		{ /* '56' */
			return 56
		}
	case 560:
		{ /* '560' */
			return 560
		}
	case 561:
		{ /* '561' */
			return 561
		}
	case 562:
		{ /* '562' */
			return 562
		}
	case 563:
		{ /* '563' */
			return 563
		}
	case 564:
		{ /* '564' */
			return 564
		}
	case 565:
		{ /* '565' */
			return 565
		}
	case 566:
		{ /* '566' */
			return 566
		}
	case 567:
		{ /* '567' */
			return 567
		}
	case 568:
		{ /* '568' */
			return 568
		}
	case 569:
		{ /* '569' */
			return 569
		}
	case 57:
		{ /* '57' */
			return 57
		}
	case 570:
		{ /* '570' */
			return 570
		}
	case 571:
		{ /* '571' */
			return 571
		}
	case 572:
		{ /* '572' */
			return 572
		}
	case 573:
		{ /* '573' */
			return 573
		}
	case 574:
		{ /* '574' */
			return 574
		}
	case 575:
		{ /* '575' */
			return 575
		}
	case 576:
		{ /* '576' */
			return 576
		}
	case 577:
		{ /* '577' */
			return 577
		}
	case 578:
		{ /* '578' */
			return 578
		}
	case 579:
		{ /* '579' */
			return 579
		}
	case 58:
		{ /* '58' */
			return 58
		}
	case 580:
		{ /* '580' */
			return 580
		}
	case 581:
		{ /* '581' */
			return 581
		}
	case 582:
		{ /* '582' */
			return 582
		}
	case 583:
		{ /* '583' */
			return 583
		}
	case 584:
		{ /* '584' */
			return 584
		}
	case 585:
		{ /* '585' */
			return 585
		}
	case 586:
		{ /* '586' */
			return 586
		}
	case 587:
		{ /* '587' */
			return 587
		}
	case 588:
		{ /* '588' */
			return 588
		}
	case 589:
		{ /* '589' */
			return 589
		}
	case 59:
		{ /* '59' */
			return 59
		}
	case 590:
		{ /* '590' */
			return 590
		}
	case 591:
		{ /* '591' */
			return 591
		}
	case 592:
		{ /* '592' */
			return 592
		}
	case 593:
		{ /* '593' */
			return 593
		}
	case 594:
		{ /* '594' */
			return 594
		}
	case 595:
		{ /* '595' */
			return 595
		}
	case 596:
		{ /* '596' */
			return 596
		}
	case 597:
		{ /* '597' */
			return 597
		}
	case 598:
		{ /* '598' */
			return 598
		}
	case 599:
		{ /* '599' */
			return 599
		}
	case 6:
		{ /* '6' */
			return 6
		}
	case 60:
		{ /* '60' */
			return 60
		}
	case 600:
		{ /* '600' */
			return 600
		}
	case 601:
		{ /* '601' */
			return 601
		}
	case 602:
		{ /* '602' */
			return 602
		}
	case 603:
		{ /* '603' */
			return 603
		}
	case 604:
		{ /* '604' */
			return 604
		}
	case 605:
		{ /* '605' */
			return 605
		}
	case 606:
		{ /* '606' */
			return 606
		}
	case 607:
		{ /* '607' */
			return 607
		}
	case 608:
		{ /* '608' */
			return 608
		}
	case 609:
		{ /* '609' */
			return 609
		}
	case 61:
		{ /* '61' */
			return 61
		}
	case 610:
		{ /* '610' */
			return 610
		}
	case 611:
		{ /* '611' */
			return 611
		}
	case 612:
		{ /* '612' */
			return 612
		}
	case 613:
		{ /* '613' */
			return 613
		}
	case 614:
		{ /* '614' */
			return 614
		}
	case 615:
		{ /* '615' */
			return 615
		}
	case 616:
		{ /* '616' */
			return 616
		}
	case 617:
		{ /* '617' */
			return 617
		}
	case 618:
		{ /* '618' */
			return 618
		}
	case 619:
		{ /* '619' */
			return 619
		}
	case 62:
		{ /* '62' */
			return 62
		}
	case 620:
		{ /* '620' */
			return 620
		}
	case 621:
		{ /* '621' */
			return 621
		}
	case 622:
		{ /* '622' */
			return 622
		}
	case 623:
		{ /* '623' */
			return 623
		}
	case 624:
		{ /* '624' */
			return 624
		}
	case 625:
		{ /* '625' */
			return 625
		}
	case 626:
		{ /* '626' */
			return 626
		}
	case 627:
		{ /* '627' */
			return 627
		}
	case 628:
		{ /* '628' */
			return 628
		}
	case 629:
		{ /* '629' */
			return 629
		}
	case 63:
		{ /* '63' */
			return 63
		}
	case 630:
		{ /* '630' */
			return 630
		}
	case 631:
		{ /* '631' */
			return 631
		}
	case 632:
		{ /* '632' */
			return 632
		}
	case 633:
		{ /* '633' */
			return 633
		}
	case 634:
		{ /* '634' */
			return 634
		}
	case 635:
		{ /* '635' */
			return 635
		}
	case 636:
		{ /* '636' */
			return 636
		}
	case 637:
		{ /* '637' */
			return 637
		}
	case 638:
		{ /* '638' */
			return 638
		}
	case 639:
		{ /* '639' */
			return 639
		}
	case 64:
		{ /* '64' */
			return 64
		}
	case 640:
		{ /* '640' */
			return 640
		}
	case 641:
		{ /* '641' */
			return 641
		}
	case 642:
		{ /* '642' */
			return 642
		}
	case 643:
		{ /* '643' */
			return 643
		}
	case 644:
		{ /* '644' */
			return 644
		}
	case 645:
		{ /* '645' */
			return 645
		}
	case 646:
		{ /* '646' */
			return 646
		}
	case 647:
		{ /* '647' */
			return 647
		}
	case 648:
		{ /* '648' */
			return 648
		}
	case 649:
		{ /* '649' */
			return 649
		}
	case 65:
		{ /* '65' */
			return 65
		}
	case 650:
		{ /* '650' */
			return 650
		}
	case 651:
		{ /* '651' */
			return 651
		}
	case 652:
		{ /* '652' */
			return 652
		}
	case 653:
		{ /* '653' */
			return 653
		}
	case 654:
		{ /* '654' */
			return 654
		}
	case 655:
		{ /* '655' */
			return 655
		}
	case 656:
		{ /* '656' */
			return 656
		}
	case 657:
		{ /* '657' */
			return 657
		}
	case 658:
		{ /* '658' */
			return 658
		}
	case 659:
		{ /* '659' */
			return 659
		}
	case 66:
		{ /* '66' */
			return 66
		}
	case 660:
		{ /* '660' */
			return 660
		}
	case 661:
		{ /* '661' */
			return 661
		}
	case 662:
		{ /* '662' */
			return 662
		}
	case 663:
		{ /* '663' */
			return 663
		}
	case 664:
		{ /* '664' */
			return 664
		}
	case 665:
		{ /* '665' */
			return 665
		}
	case 667:
		{ /* '667' */
			return 667
		}
	case 668:
		{ /* '668' */
			return 668
		}
	case 669:
		{ /* '669' */
			return 669
		}
	case 67:
		{ /* '67' */
			return 67
		}
	case 670:
		{ /* '670' */
			return 670
		}
	case 671:
		{ /* '671' */
			return 671
		}
	case 672:
		{ /* '672' */
			return 672
		}
	case 673:
		{ /* '673' */
			return 673
		}
	case 674:
		{ /* '674' */
			return 674
		}
	case 675:
		{ /* '675' */
			return 675
		}
	case 676:
		{ /* '676' */
			return 676
		}
	case 677:
		{ /* '677' */
			return 677
		}
	case 678:
		{ /* '678' */
			return 678
		}
	case 679:
		{ /* '679' */
			return 679
		}
	case 68:
		{ /* '68' */
			return 68
		}
	case 680:
		{ /* '680' */
			return 680
		}
	case 681:
		{ /* '681' */
			return 681
		}
	case 682:
		{ /* '682' */
			return 682
		}
	case 683:
		{ /* '683' */
			return 683
		}
	case 684:
		{ /* '684' */
			return 684
		}
	case 685:
		{ /* '685' */
			return 685
		}
	case 686:
		{ /* '686' */
			return 686
		}
	case 687:
		{ /* '687' */
			return 687
		}
	case 688:
		{ /* '688' */
			return 688
		}
	case 689:
		{ /* '689' */
			return 689
		}
	case 69:
		{ /* '69' */
			return 69
		}
	case 690:
		{ /* '690' */
			return 690
		}
	case 691:
		{ /* '691' */
			return 691
		}
	case 692:
		{ /* '692' */
			return 692
		}
	case 693:
		{ /* '693' */
			return 693
		}
	case 694:
		{ /* '694' */
			return 694
		}
	case 695:
		{ /* '695' */
			return 695
		}
	case 696:
		{ /* '696' */
			return 696
		}
	case 697:
		{ /* '697' */
			return 697
		}
	case 698:
		{ /* '698' */
			return 698
		}
	case 699:
		{ /* '699' */
			return 699
		}
	case 7:
		{ /* '7' */
			return 7
		}
	case 70:
		{ /* '70' */
			return 70
		}
	case 700:
		{ /* '700' */
			return 700
		}
	case 701:
		{ /* '701' */
			return 701
		}
	case 702:
		{ /* '702' */
			return 702
		}
	case 703:
		{ /* '703' */
			return 703
		}
	case 704:
		{ /* '704' */
			return 704
		}
	case 705:
		{ /* '705' */
			return 705
		}
	case 706:
		{ /* '706' */
			return 706
		}
	case 707:
		{ /* '707' */
			return 707
		}
	case 708:
		{ /* '708' */
			return 708
		}
	case 709:
		{ /* '709' */
			return 709
		}
	case 71:
		{ /* '71' */
			return 71
		}
	case 710:
		{ /* '710' */
			return 710
		}
	case 711:
		{ /* '711' */
			return 711
		}
	case 712:
		{ /* '712' */
			return 712
		}
	case 713:
		{ /* '713' */
			return 713
		}
	case 714:
		{ /* '714' */
			return 714
		}
	case 715:
		{ /* '715' */
			return 715
		}
	case 716:
		{ /* '716' */
			return 716
		}
	case 717:
		{ /* '717' */
			return 717
		}
	case 718:
		{ /* '718' */
			return 718
		}
	case 719:
		{ /* '719' */
			return 719
		}
	case 72:
		{ /* '72' */
			return 72
		}
	case 720:
		{ /* '720' */
			return 720
		}
	case 721:
		{ /* '721' */
			return 721
		}
	case 722:
		{ /* '722' */
			return 722
		}
	case 723:
		{ /* '723' */
			return 723
		}
	case 724:
		{ /* '724' */
			return 724
		}
	case 725:
		{ /* '725' */
			return 725
		}
	case 726:
		{ /* '726' */
			return 726
		}
	case 727:
		{ /* '727' */
			return 727
		}
	case 728:
		{ /* '728' */
			return 728
		}
	case 729:
		{ /* '729' */
			return 729
		}
	case 73:
		{ /* '73' */
			return 73
		}
	case 730:
		{ /* '730' */
			return 730
		}
	case 731:
		{ /* '731' */
			return 731
		}
	case 732:
		{ /* '732' */
			return 732
		}
	case 733:
		{ /* '733' */
			return 733
		}
	case 734:
		{ /* '734' */
			return 734
		}
	case 735:
		{ /* '735' */
			return 735
		}
	case 736:
		{ /* '736' */
			return 736
		}
	case 737:
		{ /* '737' */
			return 737
		}
	case 738:
		{ /* '738' */
			return 738
		}
	case 739:
		{ /* '739' */
			return 739
		}
	case 74:
		{ /* '74' */
			return 74
		}
	case 740:
		{ /* '740' */
			return 740
		}
	case 741:
		{ /* '741' */
			return 741
		}
	case 742:
		{ /* '742' */
			return 742
		}
	case 743:
		{ /* '743' */
			return 743
		}
	case 744:
		{ /* '744' */
			return 744
		}
	case 745:
		{ /* '745' */
			return 745
		}
	case 746:
		{ /* '746' */
			return 746
		}
	case 747:
		{ /* '747' */
			return 747
		}
	case 748:
		{ /* '748' */
			return 748
		}
	case 749:
		{ /* '749' */
			return 749
		}
	case 75:
		{ /* '75' */
			return 75
		}
	case 750:
		{ /* '750' */
			return 750
		}
	case 751:
		{ /* '751' */
			return 751
		}
	case 752:
		{ /* '752' */
			return 752
		}
	case 753:
		{ /* '753' */
			return 753
		}
	case 754:
		{ /* '754' */
			return 754
		}
	case 755:
		{ /* '755' */
			return 755
		}
	case 756:
		{ /* '756' */
			return 756
		}
	case 757:
		{ /* '757' */
			return 757
		}
	case 758:
		{ /* '758' */
			return 758
		}
	case 759:
		{ /* '759' */
			return 759
		}
	case 76:
		{ /* '76' */
			return 76
		}
	case 760:
		{ /* '760' */
			return 760
		}
	case 761:
		{ /* '761' */
			return 761
		}
	case 762:
		{ /* '762' */
			return 762
		}
	case 763:
		{ /* '763' */
			return 763
		}
	case 764:
		{ /* '764' */
			return 764
		}
	case 765:
		{ /* '765' */
			return 765
		}
	case 766:
		{ /* '766' */
			return 766
		}
	case 767:
		{ /* '767' */
			return 767
		}
	case 768:
		{ /* '768' */
			return 768
		}
	case 769:
		{ /* '769' */
			return 769
		}
	case 77:
		{ /* '77' */
			return 77
		}
	case 770:
		{ /* '770' */
			return 770
		}
	case 771:
		{ /* '771' */
			return 771
		}
	case 772:
		{ /* '772' */
			return 772
		}
	case 773:
		{ /* '773' */
			return 773
		}
	case 774:
		{ /* '774' */
			return 774
		}
	case 775:
		{ /* '775' */
			return 775
		}
	case 776:
		{ /* '776' */
			return 776
		}
	case 778:
		{ /* '778' */
			return 778
		}
	case 779:
		{ /* '779' */
			return 779
		}
	case 78:
		{ /* '78' */
			return 78
		}
	case 780:
		{ /* '780' */
			return 780
		}
	case 781:
		{ /* '781' */
			return 781
		}
	case 782:
		{ /* '782' */
			return 782
		}
	case 783:
		{ /* '783' */
			return 783
		}
	case 784:
		{ /* '784' */
			return 784
		}
	case 785:
		{ /* '785' */
			return 785
		}
	case 786:
		{ /* '786' */
			return 786
		}
	case 787:
		{ /* '787' */
			return 787
		}
	case 788:
		{ /* '788' */
			return 788
		}
	case 789:
		{ /* '789' */
			return 789
		}
	case 79:
		{ /* '79' */
			return 79
		}
	case 790:
		{ /* '790' */
			return 790
		}
	case 791:
		{ /* '791' */
			return 791
		}
	case 792:
		{ /* '792' */
			return 792
		}
	case 793:
		{ /* '793' */
			return 793
		}
	case 794:
		{ /* '794' */
			return 794
		}
	case 795:
		{ /* '795' */
			return 795
		}
	case 796:
		{ /* '796' */
			return 796
		}
	case 797:
		{ /* '797' */
			return 797
		}
	case 798:
		{ /* '798' */
			return 798
		}
	case 799:
		{ /* '799' */
			return 799
		}
	case 8:
		{ /* '8' */
			return 8
		}
	case 80:
		{ /* '80' */
			return 80
		}
	case 800:
		{ /* '800' */
			return 800
		}
	case 801:
		{ /* '801' */
			return 801
		}
	case 802:
		{ /* '802' */
			return 802
		}
	case 803:
		{ /* '803' */
			return 803
		}
	case 804:
		{ /* '804' */
			return 804
		}
	case 805:
		{ /* '805' */
			return 805
		}
	case 806:
		{ /* '806' */
			return 806
		}
	case 807:
		{ /* '807' */
			return 807
		}
	case 808:
		{ /* '808' */
			return 808
		}
	case 809:
		{ /* '809' */
			return 809
		}
	case 81:
		{ /* '81' */
			return 81
		}
	case 810:
		{ /* '810' */
			return 810
		}
	case 811:
		{ /* '811' */
			return 811
		}
	case 812:
		{ /* '812' */
			return 812
		}
	case 813:
		{ /* '813' */
			return 813
		}
	case 814:
		{ /* '814' */
			return 814
		}
	case 815:
		{ /* '815' */
			return 815
		}
	case 816:
		{ /* '816' */
			return 816
		}
	case 817:
		{ /* '817' */
			return 817
		}
	case 818:
		{ /* '818' */
			return 818
		}
	case 819:
		{ /* '819' */
			return 819
		}
	case 82:
		{ /* '82' */
			return 82
		}
	case 820:
		{ /* '820' */
			return 820
		}
	case 821:
		{ /* '821' */
			return 821
		}
	case 822:
		{ /* '822' */
			return 822
		}
	case 823:
		{ /* '823' */
			return 823
		}
	case 824:
		{ /* '824' */
			return 824
		}
	case 825:
		{ /* '825' */
			return 825
		}
	case 826:
		{ /* '826' */
			return 826
		}
	case 827:
		{ /* '827' */
			return 827
		}
	case 828:
		{ /* '828' */
			return 828
		}
	case 829:
		{ /* '829' */
			return 829
		}
	case 83:
		{ /* '83' */
			return 83
		}
	case 830:
		{ /* '830' */
			return 830
		}
	case 831:
		{ /* '831' */
			return 831
		}
	case 832:
		{ /* '832' */
			return 832
		}
	case 833:
		{ /* '833' */
			return 833
		}
	case 834:
		{ /* '834' */
			return 834
		}
	case 835:
		{ /* '835' */
			return 835
		}
	case 836:
		{ /* '836' */
			return 836
		}
	case 837:
		{ /* '837' */
			return 837
		}
	case 838:
		{ /* '838' */
			return 838
		}
	case 839:
		{ /* '839' */
			return 839
		}
	case 84:
		{ /* '84' */
			return 84
		}
	case 840:
		{ /* '840' */
			return 840
		}
	case 841:
		{ /* '841' */
			return 841
		}
	case 842:
		{ /* '842' */
			return 842
		}
	case 843:
		{ /* '843' */
			return 843
		}
	case 844:
		{ /* '844' */
			return 844
		}
	case 845:
		{ /* '845' */
			return 845
		}
	case 846:
		{ /* '846' */
			return 846
		}
	case 847:
		{ /* '847' */
			return 847
		}
	case 848:
		{ /* '848' */
			return 848
		}
	case 849:
		{ /* '849' */
			return 849
		}
	case 85:
		{ /* '85' */
			return 85
		}
	case 850:
		{ /* '850' */
			return 850
		}
	case 851:
		{ /* '851' */
			return 851
		}
	case 852:
		{ /* '852' */
			return 852
		}
	case 853:
		{ /* '853' */
			return 853
		}
	case 854:
		{ /* '854' */
			return 854
		}
	case 855:
		{ /* '855' */
			return 855
		}
	case 856:
		{ /* '856' */
			return 856
		}
	case 857:
		{ /* '857' */
			return 857
		}
	case 858:
		{ /* '858' */
			return 858
		}
	case 859:
		{ /* '859' */
			return 859
		}
	case 86:
		{ /* '86' */
			return 86
		}
	case 860:
		{ /* '860' */
			return 860
		}
	case 861:
		{ /* '861' */
			return 861
		}
	case 862:
		{ /* '862' */
			return 862
		}
	case 863:
		{ /* '863' */
			return 863
		}
	case 864:
		{ /* '864' */
			return 864
		}
	case 865:
		{ /* '865' */
			return 865
		}
	case 866:
		{ /* '866' */
			return 866
		}
	case 867:
		{ /* '867' */
			return 867
		}
	case 868:
		{ /* '868' */
			return 868
		}
	case 869:
		{ /* '869' */
			return 869
		}
	case 87:
		{ /* '87' */
			return 87
		}
	case 870:
		{ /* '870' */
			return 870
		}
	case 871:
		{ /* '871' */
			return 871
		}
	case 872:
		{ /* '872' */
			return 872
		}
	case 873:
		{ /* '873' */
			return 873
		}
	case 874:
		{ /* '874' */
			return 874
		}
	case 875:
		{ /* '875' */
			return 875
		}
	case 876:
		{ /* '876' */
			return 876
		}
	case 877:
		{ /* '877' */
			return 877
		}
	case 878:
		{ /* '878' */
			return 878
		}
	case 879:
		{ /* '879' */
			return 879
		}
	case 88:
		{ /* '88' */
			return 88
		}
	case 880:
		{ /* '880' */
			return 880
		}
	case 881:
		{ /* '881' */
			return 881
		}
	case 882:
		{ /* '882' */
			return 882
		}
	case 883:
		{ /* '883' */
			return 883
		}
	case 884:
		{ /* '884' */
			return 884
		}
	case 885:
		{ /* '885' */
			return 885
		}
	case 886:
		{ /* '886' */
			return 886
		}
	case 887:
		{ /* '887' */
			return 887
		}
	case 889:
		{ /* '889' */
			return 889
		}
	case 89:
		{ /* '89' */
			return 89
		}
	case 890:
		{ /* '890' */
			return 890
		}
	case 891:
		{ /* '891' */
			return 891
		}
	case 892:
		{ /* '892' */
			return 892
		}
	case 893:
		{ /* '893' */
			return 893
		}
	case 894:
		{ /* '894' */
			return 894
		}
	case 895:
		{ /* '895' */
			return 895
		}
	case 896:
		{ /* '896' */
			return 896
		}
	case 897:
		{ /* '897' */
			return 897
		}
	case 898:
		{ /* '898' */
			return 898
		}
	case 899:
		{ /* '899' */
			return 899
		}
	case 9:
		{ /* '9' */
			return 9
		}
	case 90:
		{ /* '90' */
			return 90
		}
	case 900:
		{ /* '900' */
			return 900
		}
	case 901:
		{ /* '901' */
			return 901
		}
	case 902:
		{ /* '902' */
			return 902
		}
	case 903:
		{ /* '903' */
			return 903
		}
	case 904:
		{ /* '904' */
			return 904
		}
	case 905:
		{ /* '905' */
			return 905
		}
	case 906:
		{ /* '906' */
			return 906
		}
	case 907:
		{ /* '907' */
			return 907
		}
	case 908:
		{ /* '908' */
			return 908
		}
	case 909:
		{ /* '909' */
			return 909
		}
	case 91:
		{ /* '91' */
			return 91
		}
	case 910:
		{ /* '910' */
			return 910
		}
	case 912:
		{ /* '912' */
			return 912
		}
	case 913:
		{ /* '913' */
			return 913
		}
	case 914:
		{ /* '914' */
			return 914
		}
	case 915:
		{ /* '915' */
			return 915
		}
	case 916:
		{ /* '916' */
			return 916
		}
	case 917:
		{ /* '917' */
			return 917
		}
	case 918:
		{ /* '918' */
			return 918
		}
	case 919:
		{ /* '919' */
			return 919
		}
	case 92:
		{ /* '92' */
			return 92
		}
	case 920:
		{ /* '920' */
			return 920
		}
	case 921:
		{ /* '921' */
			return 921
		}
	case 922:
		{ /* '922' */
			return 922
		}
	case 923:
		{ /* '923' */
			return 923
		}
	case 924:
		{ /* '924' */
			return 924
		}
	case 925:
		{ /* '925' */
			return 925
		}
	case 926:
		{ /* '926' */
			return 926
		}
	case 927:
		{ /* '927' */
			return 927
		}
	case 928:
		{ /* '928' */
			return 928
		}
	case 929:
		{ /* '929' */
			return 929
		}
	case 93:
		{ /* '93' */
			return 93
		}
	case 930:
		{ /* '930' */
			return 930
		}
	case 931:
		{ /* '931' */
			return 931
		}
	case 932:
		{ /* '932' */
			return 932
		}
	case 933:
		{ /* '933' */
			return 933
		}
	case 934:
		{ /* '934' */
			return 934
		}
	case 935:
		{ /* '935' */
			return 935
		}
	case 936:
		{ /* '936' */
			return 936
		}
	case 937:
		{ /* '937' */
			return 937
		}
	case 938:
		{ /* '938' */
			return 938
		}
	case 939:
		{ /* '939' */
			return 939
		}
	case 94:
		{ /* '94' */
			return 94
		}
	case 940:
		{ /* '940' */
			return 940
		}
	case 941:
		{ /* '941' */
			return 941
		}
	case 942:
		{ /* '942' */
			return 942
		}
	case 943:
		{ /* '943' */
			return 943
		}
	case 944:
		{ /* '944' */
			return 944
		}
	case 945:
		{ /* '945' */
			return 945
		}
	case 946:
		{ /* '946' */
			return 946
		}
	case 947:
		{ /* '947' */
			return 947
		}
	case 948:
		{ /* '948' */
			return 948
		}
	case 949:
		{ /* '949' */
			return 949
		}
	case 95:
		{ /* '95' */
			return 95
		}
	case 950:
		{ /* '950' */
			return 950
		}
	case 951:
		{ /* '951' */
			return 951
		}
	case 952:
		{ /* '952' */
			return 952
		}
	case 953:
		{ /* '953' */
			return 953
		}
	case 954:
		{ /* '954' */
			return 954
		}
	case 955:
		{ /* '955' */
			return 955
		}
	case 956:
		{ /* '956' */
			return 956
		}
	case 957:
		{ /* '957' */
			return 957
		}
	case 958:
		{ /* '958' */
			return 958
		}
	case 959:
		{ /* '959' */
			return 959
		}
	case 96:
		{ /* '96' */
			return 96
		}
	case 960:
		{ /* '960' */
			return 960
		}
	case 961:
		{ /* '961' */
			return 961
		}
	case 962:
		{ /* '962' */
			return 962
		}
	case 963:
		{ /* '963' */
			return 963
		}
	case 964:
		{ /* '964' */
			return 964
		}
	case 965:
		{ /* '965' */
			return 965
		}
	case 966:
		{ /* '966' */
			return 966
		}
	case 967:
		{ /* '967' */
			return 967
		}
	case 968:
		{ /* '968' */
			return 968
		}
	case 969:
		{ /* '969' */
			return 969
		}
	case 97:
		{ /* '97' */
			return 97
		}
	case 970:
		{ /* '970' */
			return 970
		}
	case 971:
		{ /* '971' */
			return 971
		}
	case 972:
		{ /* '972' */
			return 972
		}
	case 973:
		{ /* '973' */
			return 973
		}
	case 974:
		{ /* '974' */
			return 974
		}
	case 975:
		{ /* '975' */
			return 975
		}
	case 976:
		{ /* '976' */
			return 976
		}
	case 977:
		{ /* '977' */
			return 977
		}
	case 978:
		{ /* '978' */
			return 978
		}
	case 979:
		{ /* '979' */
			return 979
		}
	case 98:
		{ /* '98' */
			return 98
		}
	case 980:
		{ /* '980' */
			return 980
		}
	case 981:
		{ /* '981' */
			return 981
		}
	case 982:
		{ /* '982' */
			return 982
		}
	case 983:
		{ /* '983' */
			return 983
		}
	case 984:
		{ /* '984' */
			return 984
		}
	case 985:
		{ /* '985' */
			return 985
		}
	case 986:
		{ /* '986' */
			return 986
		}
	case 987:
		{ /* '987' */
			return 987
		}
	case 988:
		{ /* '988' */
			return 988
		}
	case 989:
		{ /* '989' */
			return 989
		}
	case 99:
		{ /* '99' */
			return 99
		}
	case 990:
		{ /* '990' */
			return 990
		}
	case 991:
		{ /* '991' */
			return 991
		}
	case 992:
		{ /* '992' */
			return 992
		}
	case 993:
		{ /* '993' */
			return 993
		}
	case 994:
		{ /* '994' */
			return 994
		}
	case 995:
		{ /* '995' */
			return 995
		}
	case 996:
		{ /* '996' */
			return 996
		}
	case 997:
		{ /* '997' */
			return 997
		}
	case 998:
		{ /* '998' */
			return 998
		}
	default:
		{
			return 0
		}
	}
}

func BACnetVendorIdFirstEnumForFieldVendorId(value uint16) (enum BACnetVendorId, ok bool) {
	for _, sizeValue := range BACnetVendorIdValues {
		if sizeValue.VendorId() == value {
			return sizeValue, true
		}
	}
	return 0, false
}

func (e BACnetVendorId) VendorName() string {
	switch e {
	case 0:
		{ /* '0' */
			return "ASHRAE"
		}
	case 0xFFFF:
		{ /* '0xFFFF' */
			return "Unknown"
		}
	case 1:
		{ /* '1' */
			return "NIST"
		}
	case 10:
		{ /* '10' */
			return "Schneider Electric"
		}
	case 100:
		{ /* '100' */
			return "Custom Mechanical Equipment, LLC"
		}
	case 1000:
		{ /* '1000' */
			return "Ekon GmbH"
		}
	case 1001:
		{ /* '1001' */
			return "Molex"
		}
	case 1002:
		{ /* '1002' */
			return "Maco Lighting Pty Ltd."
		}
	case 1003:
		{ /* '1003' */
			return "Axecon Corp."
		}
	case 1004:
		{ /* '1004' */
			return "Tensor plc"
		}
	case 1005:
		{ /* '1005' */
			return "Kaseman Environmental Control Equipment (Shanghai) Limited"
		}
	case 1006:
		{ /* '1006' */
			return "AB Axis Industries"
		}
	case 1007:
		{ /* '1007' */
			return "Netix Controls"
		}
	case 1008:
		{ /* '1008' */
			return "Eldridge Products, Inc."
		}
	case 1009:
		{ /* '1009' */
			return "Micronics"
		}
	case 101:
		{ /* '101' */
			return "ClimateMaster"
		}
	case 1010:
		{ /* '1010' */
			return "Fortecho Solutions Ltd"
		}
	case 1011:
		{ /* '1011' */
			return "Sellers Manufacturing Company"
		}
	case 1012:
		{ /* '1012' */
			return "Rite-Hite Doors, Inc."
		}
	case 1013:
		{ /* '1013' */
			return "Violet Defense LLC"
		}
	case 1014:
		{ /* '1014' */
			return "Simna"
		}
	case 1015:
		{ /* '1015' */
			return "Multi-Énergie Best Inc."
		}
	case 1016:
		{ /* '1016' */
			return "Mega System Technologies, Inc."
		}
	case 1017:
		{ /* '1017' */
			return "Rheem"
		}
	case 1018:
		{ /* '1018' */
			return "Ing. Punzenberger COPA-DATA GmbH"
		}
	case 1019:
		{ /* '1019' */
			return "MEC Electronics GmbH"
		}
	case 102:
		{ /* '102' */
			return "ICP Panel-Tec, Inc."
		}
	case 1020:
		{ /* '1020' */
			return "Taco Comfort Solutions"
		}
	case 1021:
		{ /* '1021' */
			return "Alexander Maier GmbH"
		}
	case 1022:
		{ /* '1022' */
			return "Ecorithm, Inc."
		}
	case 1023:
		{ /* '1023' */
			return "Accurro Ltd"
		}
	case 1024:
		{ /* '1024' */
			return "ROMTECK Australia Pty Ltd"
		}
	case 1025:
		{ /* '1025' */
			return "Splash Monitoring Limited"
		}
	case 1026:
		{ /* '1026' */
			return "Light Application"
		}
	case 1027:
		{ /* '1027' */
			return "Logical Building Automation"
		}
	case 1028:
		{ /* '1028' */
			return "Exilight Oy"
		}
	case 1029:
		{ /* '1029' */
			return "Hager Electro SAS"
		}
	case 103:
		{ /* '103' */
			return "D-Tek Controls"
		}
	case 1030:
		{ /* '1030' */
			return "KLIF Co., LTD"
		}
	case 1031:
		{ /* '1031' */
			return "HygroMatik"
		}
	case 1032:
		{ /* '1032' */
			return "Daniel Mousseau Programmation & Electronique"
		}
	case 1033:
		{ /* '1033' */
			return "Aerionics Inc."
		}
	case 1034:
		{ /* '1034' */
			return "M2S Electronique Ltee"
		}
	case 1035:
		{ /* '1035' */
			return "Automation Components, Inc."
		}
	case 1036:
		{ /* '1036' */
			return "Niobrara Research & Development Corporation"
		}
	case 1037:
		{ /* '1037' */
			return "Netcom Sicherheitstechnik GmbH"
		}
	case 1038:
		{ /* '1038' */
			return "Lumel S.A."
		}
	case 1039:
		{ /* '1039' */
			return "Great Plains Industries, Inc."
		}
	case 104:
		{ /* '104' */
			return "NEC Engineering, Ltd."
		}
	case 1040:
		{ /* '1040' */
			return "Domotica Labs S.R.L"
		}
	case 1041:
		{ /* '1041' */
			return "Energy Cloud, Inc."
		}
	case 1042:
		{ /* '1042' */
			return "Vomatec"
		}
	case 1043:
		{ /* '1043' */
			return "Demma Companies"
		}
	case 1044:
		{ /* '1044' */
			return "Valsena"
		}
	case 1045:
		{ /* '1045' */
			return "Comsys Bärtsch AG"
		}
	case 1046:
		{ /* '1046' */
			return "bGrid"
		}
	case 1047:
		{ /* '1047' */
			return "MDJ Software Pty Ltd"
		}
	case 1048:
		{ /* '1048' */
			return "Dimonoff, Inc."
		}
	case 1049:
		{ /* '1049' */
			return "Edomo Systems, GmbH"
		}
	case 105:
		{ /* '105' */
			return "PRIVA BV"
		}
	case 1050:
		{ /* '1050' */
			return "Effektiv, LLC"
		}
	case 1051:
		{ /* '1051' */
			return "SteamOVap"
		}
	case 1052:
		{ /* '1052' */
			return "grandcentrix GmbH"
		}
	case 1053:
		{ /* '1053' */
			return "Weintek Labs, Inc."
		}
	case 1054:
		{ /* '1054' */
			return "Intefox GmbH"
		}
	case 1055:
		{ /* '1055' */
			return "Radius22 Automation Company"
		}
	case 1056:
		{ /* '1056' */
			return "Ringdale, Inc."
		}
	case 1057:
		{ /* '1057' */
			return "Iwaki America"
		}
	case 1058:
		{ /* '1058' */
			return "Bractlet"
		}
	case 1059:
		{ /* '1059' */
			return "STULZ Air Technology Systems, Inc."
		}
	case 106:
		{ /* '106' */
			return "Meidensha Corporation"
		}
	case 1060:
		{ /* '1060' */
			return "Climate Ready Engineering Pty Ltd"
		}
	case 1061:
		{ /* '1061' */
			return "Genea Energy Partners"
		}
	case 1062:
		{ /* '1062' */
			return "IoTall Chile"
		}
	case 1063:
		{ /* '1063' */
			return "IKS Co., Ltd."
		}
	case 1064:
		{ /* '1064' */
			return "Yodiwo AB"
		}
	case 1065:
		{ /* '1065' */
			return "TITAN electronic GmbH"
		}
	case 1066:
		{ /* '1066' */
			return "IDEC Corporation"
		}
	case 1067:
		{ /* '1067' */
			return "SIFRI SL"
		}
	case 1068:
		{ /* '1068' */
			return "Thermal Gas Systems Inc."
		}
	case 1069:
		{ /* '1069' */
			return "Building Automation Products, Inc."
		}
	case 107:
		{ /* '107' */
			return "JCI Systems Integration Services"
		}
	case 1070:
		{ /* '1070' */
			return "Asset Mapping"
		}
	case 1071:
		{ /* '1071' */
			return "Smarteh Company"
		}
	case 1072:
		{ /* '1072' */
			return "Datapod (Australia) Pty Ltd."
		}
	case 1073:
		{ /* '1073' */
			return "Buildings Alive Pty Ltd"
		}
	case 1074:
		{ /* '1074' */
			return "Digital Elektronik"
		}
	case 1075:
		{ /* '1075' */
			return "Talent Automação e Tecnologia Ltda"
		}
	case 1076:
		{ /* '1076' */
			return "Norposh Limited"
		}
	case 1077:
		{ /* '1077' */
			return "Merkur Funksysteme AG"
		}
	case 1078:
		{ /* '1078' */
			return "Faster CZ spol. S.r.o"
		}
	case 1079:
		{ /* '1079' */
			return "Eco-Adapt"
		}
	case 108:
		{ /* '108' */
			return "Freedom Corporation"
		}
	case 1080:
		{ /* '1080' */
			return "Energocentrum Plus, s.r.o"
		}
	case 1081:
		{ /* '1081' */
			return "amBX UK Ltd"
		}
	case 1082:
		{ /* '1082' */
			return "Western Reserve Controls, Inc."
		}
	case 1083:
		{ /* '1083' */
			return "LayerZero Power Systems, Inc."
		}
	case 1084:
		{ /* '1084' */
			return "CIC Jan Hřebec s.r.o."
		}
	case 1085:
		{ /* '1085' */
			return "Sigrov BV"
		}
	case 1086:
		{ /* '1086' */
			return "ISYS-Intelligent Systems"
		}
	case 1087:
		{ /* '1087' */
			return "Gas Detection (Australia) Pty Ltd"
		}
	case 1088:
		{ /* '1088' */
			return "Kinco Automation (Shanghai) Ltd."
		}
	case 1089:
		{ /* '1089' */
			return "Lars Energy, LLC"
		}
	case 109:
		{ /* '109' */
			return "Neuberger Gebäudeautomation GmbH"
		}
	case 1090:
		{ /* '1090' */
			return "Flamefast (UK) Ltd."
		}
	case 1091:
		{ /* '1091' */
			return "Royal Service Air Conditioning"
		}
	case 1092:
		{ /* '1092' */
			return "Ampio Sp. Z o.o."
		}
	case 1093:
		{ /* '1093' */
			return "Inovonics Wireless Corporation"
		}
	case 1094:
		{ /* '1094' */
			return "Nvent Thermal Management"
		}
	case 1095:
		{ /* '1095' */
			return "Sinowell Control System Ltd"
		}
	case 1096:
		{ /* '1096' */
			return "Moxa Inc."
		}
	case 1097:
		{ /* '1097' */
			return "Matrix iControl SDN BHD"
		}
	case 1098:
		{ /* '1098' */
			return "PurpleSwift"
		}
	case 1099:
		{ /* '1099' */
			return "OTIM Technologies"
		}
	case 11:
		{ /* '11' */
			return "TAC"
		}
	case 110:
		{ /* '110' */
			return "eZi Controls"
		}
	case 1100:
		{ /* '1100' */
			return "FlowMate Limited"
		}
	case 1101:
		{ /* '1101' */
			return "Degree Controls, Inc."
		}
	case 1102:
		{ /* '1102' */
			return "Fei Xing (Shanghai) Software Technologies Co., Ltd."
		}
	case 1103:
		{ /* '1103' */
			return "Berg GmbH"
		}
	case 1104:
		{ /* '1104' */
			return "ARENZ.IT"
		}
	case 1105:
		{ /* '1105' */
			return "Edelstrom Electronic Devices & Designing LLC"
		}
	case 1106:
		{ /* '1106' */
			return "Drive Connect, LLC"
		}
	case 1107:
		{ /* '1107' */
			return "DevelopNow"
		}
	case 1108:
		{ /* '1108' */
			return "Poort"
		}
	case 1109:
		{ /* '1109' */
			return "VMEIL Information (Shanghai) Ltd"
		}
	case 111:
		{ /* '111' */
			return "Leviton Manufacturing"
		}
	case 1110:
		{ /* '1110' */
			return "Rayleigh Instruments"
		}
	case 1112:
		{ /* '1112' */
			return "CODESYS Development"
		}
	case 1113:
		{ /* '1113' */
			return "Smartware Technologies Group, LLC"
		}
	case 1114:
		{ /* '1114' */
			return "Polar Bear Solutions"
		}
	case 1115:
		{ /* '1115' */
			return "Codra"
		}
	case 1116:
		{ /* '1116' */
			return "Pharos Architectural Controls Ltd"
		}
	case 1117:
		{ /* '1117' */
			return "EngiNear Ltd."
		}
	case 1118:
		{ /* '1118' */
			return "Ad Hoc Electronics"
		}
	case 1119:
		{ /* '1119' */
			return "Unified Microsystems"
		}
	case 112:
		{ /* '112' */
			return "Fujitsu Limited"
		}
	case 1120:
		{ /* '1120' */
			return "Industrieelektronik Brandenburg GmbH"
		}
	case 1121:
		{ /* '1121' */
			return "Hartmann GmbH"
		}
	case 1122:
		{ /* '1122' */
			return "Piscada"
		}
	case 1123:
		{ /* '1123' */
			return "KMB systems, s.r.o."
		}
	case 1124:
		{ /* '1124' */
			return "PowerTech Engineering AS"
		}
	case 1125:
		{ /* '1125' */
			return "Telefonbau Arthur Schwabe GmbH & Co. KG"
		}
	case 1126:
		{ /* '1126' */
			return "Wuxi Fistwelove Technology Co., Ltd."
		}
	case 1127:
		{ /* '1127' */
			return "Prysm"
		}
	case 1128:
		{ /* '1128' */
			return "STEINEL GmbH"
		}
	case 1129:
		{ /* '1129' */
			return "Georg Fischer JRG AG"
		}
	case 113:
		{ /* '113' */
			return "Vertiv (Formerly Emerson Network Power)"
		}
	case 1130:
		{ /* '1130' */
			return "Make Develop SL"
		}
	case 1131:
		{ /* '1131' */
			return "Monnit Corporation"
		}
	case 1132:
		{ /* '1132' */
			return "Mirror Life Corporation"
		}
	case 1133:
		{ /* '1133' */
			return "Secure Meters Limited"
		}
	case 1134:
		{ /* '1134' */
			return "PECO"
		}
	case 1135:
		{ /* '1135' */
			return ".CCTECH, Inc."
		}
	case 1136:
		{ /* '1136' */
			return "LightFi Limited"
		}
	case 1137:
		{ /* '1137' */
			return "Nice Spa"
		}
	case 1138:
		{ /* '1138' */
			return "Fiber SenSys, Inc."
		}
	case 1139:
		{ /* '1139' */
			return "B&D Buchta und Degeorgi"
		}
	case 114:
		{ /* '114' */
			return "S. A. Armstrong, Ltd."
		}
	case 1140:
		{ /* '1140' */
			return "Ventacity Systems, Inc."
		}
	case 1141:
		{ /* '1141' */
			return "Hitachi-Johnson Controls Air Conditioning, Inc."
		}
	case 1142:
		{ /* '1142' */
			return "Sage Metering, Inc."
		}
	case 1143:
		{ /* '1143' */
			return "Andel Limited"
		}
	case 1144:
		{ /* '1144' */
			return "ECOSmart Technologies"
		}
	case 1145:
		{ /* '1145' */
			return "S.E.T."
		}
	case 1146:
		{ /* '1146' */
			return "Protec Fire Detection Spain SL"
		}
	case 1147:
		{ /* '1147' */
			return "AGRAMER UG"
		}
	case 1148:
		{ /* '1148' */
			return "Anylink Electronic GmbH"
		}
	case 1149:
		{ /* '1149' */
			return "Schindler, Ltd"
		}
	case 115:
		{ /* '115' */
			return "Visonet AG"
		}
	case 1150:
		{ /* '1150' */
			return "Jibreel Abdeen Est."
		}
	case 1151:
		{ /* '1151' */
			return "Fluidyne Control Systems Pvt. Ltd"
		}
	case 1152:
		{ /* '1152' */
			return "Prism Systems, Inc."
		}
	case 1153:
		{ /* '1153' */
			return "Enertiv"
		}
	case 1154:
		{ /* '1154' */
			return "Mirasoft GmbH & Co. KG"
		}
	case 1155:
		{ /* '1155' */
			return "DUALTECH IT"
		}
	case 1156:
		{ /* '1156' */
			return "Countlogic, LLC"
		}
	case 1157:
		{ /* '1157' */
			return "Kohler"
		}
	case 1158:
		{ /* '1158' */
			return "Chen Sen Controls Co., Ltd."
		}
	case 1159:
		{ /* '1159' */
			return "Greenheck"
		}
	case 116:
		{ /* '116' */
			return "M&M Systems, Inc."
		}
	case 1160:
		{ /* '1160' */
			return "Intwine Connect, LLC"
		}
	case 1161:
		{ /* '1161' */
			return "Karlborgs Elkontroll"
		}
	case 1162:
		{ /* '1162' */
			return "Datakom"
		}
	case 1163:
		{ /* '1163' */
			return "Hoga Control AS"
		}
	case 1164:
		{ /* '1164' */
			return "Cool Automation"
		}
	case 1165:
		{ /* '1165' */
			return "Inter Search Co., Ltd"
		}
	case 1166:
		{ /* '1166' */
			return "DABBEL-Automation Intelligence GmbH"
		}
	case 1167:
		{ /* '1167' */
			return "Gadgeon Engineering Smartness"
		}
	case 1168:
		{ /* '1168' */
			return "Coster Group S.r.l."
		}
	case 1169:
		{ /* '1169' */
			return "Walter Müller AG"
		}
	case 117:
		{ /* '117' */
			return "Custom Software Engineering"
		}
	case 1170:
		{ /* '1170' */
			return "Fluke"
		}
	case 1171:
		{ /* '1171' */
			return "Quintex Systems Ltd"
		}
	case 1172:
		{ /* '1172' */
			return "Senfficient SDN BHD"
		}
	case 1173:
		{ /* '1173' */
			return "Nube iO Operations Pty Ltd"
		}
	case 1174:
		{ /* '1174' */
			return "DAS Integrator Pte Ltd"
		}
	case 1175:
		{ /* '1175' */
			return "CREVIS Co., Ltd"
		}
	case 1176:
		{ /* '1176' */
			return "iSquared software inc."
		}
	case 1177:
		{ /* '1177' */
			return "KTG GmbH"
		}
	case 1178:
		{ /* '1178' */
			return "POK Group Oy"
		}
	case 1179:
		{ /* '1179' */
			return "Adiscom"
		}
	case 118:
		{ /* '118' */
			return "Nittan Company, Limited"
		}
	case 1180:
		{ /* '1180' */
			return "Incusense"
		}
	case 1181:
		{ /* '1181' */
			return "75F"
		}
	case 1182:
		{ /* '1182' */
			return "Anord Mardix, Inc."
		}
	case 1183:
		{ /* '1183' */
			return "HOSCH Gebäudeautomation Neue Produkte GmbH"
		}
	case 1184:
		{ /* '1184' */
			return "Bosch.IO GmbH"
		}
	case 1185:
		{ /* '1185' */
			return "Royal Boon Edam International B.V."
		}
	case 1186:
		{ /* '1186' */
			return "Clack Corporation"
		}
	case 1187:
		{ /* '1187' */
			return "Unitex Controls LLC"
		}
	case 1188:
		{ /* '1188' */
			return "KTC Göteborg AB"
		}
	case 1189:
		{ /* '1189' */
			return "Interzon AB"
		}
	case 119:
		{ /* '119' */
			return "Elutions Inc. (Wizcon Systems SAS)"
		}
	case 1190:
		{ /* '1190' */
			return "ISDE ING SL"
		}
	case 1191:
		{ /* '1191' */
			return "ABM automation building messaging GmbH"
		}
	case 1192:
		{ /* '1192' */
			return "Kentec Electronics Ltd"
		}
	case 1193:
		{ /* '1193' */
			return "Copeland LP"
		}
	case 1194:
		{ /* '1194' */
			return "Powerside"
		}
	case 1195:
		{ /* '1195' */
			return "SMC Group"
		}
	case 1196:
		{ /* '1196' */
			return "EOS Weather Instruments"
		}
	case 1197:
		{ /* '1197' */
			return "Zonex Systems"
		}
	case 1198:
		{ /* '1198' */
			return "Generex Systems Computervertriebsgesellschaft mbH"
		}
	case 1199:
		{ /* '1199' */
			return "Energy Wall LLC"
		}
	case 12:
		{ /* '12' */
			return "Orion Analysis Corporation"
		}
	case 120:
		{ /* '120' */
			return "Pacom Systems Pty., Ltd."
		}
	case 1200:
		{ /* '1200' */
			return "Thermofin"
		}
	case 1201:
		{ /* '1201' */
			return "SDATAWAY SA"
		}
	case 1202:
		{ /* '1202' */
			return "Biddle Air Systems Limited"
		}
	case 1203:
		{ /* '1203' */
			return "Kessler Ellis Products"
		}
	case 1204:
		{ /* '1204' */
			return "Thermoscreens"
		}
	case 1205:
		{ /* '1205' */
			return "Modio"
		}
	case 1206:
		{ /* '1206' */
			return "Newron Solutions"
		}
	case 1207:
		{ /* '1207' */
			return "Unitronics"
		}
	case 1208:
		{ /* '1208' */
			return "TRILUX GmbH & Co. KG"
		}
	case 1209:
		{ /* '1209' */
			return "Kollmorgen Steuerungstechnik GmbH"
		}
	case 121:
		{ /* '121' */
			return "Unico, Inc."
		}
	case 1210:
		{ /* '1210' */
			return "Bosch Rexroth AG"
		}
	case 1211:
		{ /* '1211' */
			return "Alarko Carrier"
		}
	case 1212:
		{ /* '1212' */
			return "Verdigris Technologies"
		}
	case 1213:
		{ /* '1213' */
			return "Shanghai SIIC-Longchuang Smartech So., Ltd."
		}
	case 1214:
		{ /* '1214' */
			return "Quinda Co."
		}
	case 1215:
		{ /* '1215' */
			return "GRUNER AG"
		}
	case 1216:
		{ /* '1216' */
			return "BACMOVE"
		}
	case 1217:
		{ /* '1217' */
			return "PSIDAC AB"
		}
	case 1218:
		{ /* '1218' */
			return "ISICON-Control Automation"
		}
	case 1219:
		{ /* '1219' */
			return "Big Ass Fans"
		}
	case 122:
		{ /* '122' */
			return "Ebtron, Inc."
		}
	case 1220:
		{ /* '1220' */
			return "din – Dietmar Nocker Facility Management GmbH"
		}
	case 1221:
		{ /* '1221' */
			return "Teldio"
		}
	case 1222:
		{ /* '1222' */
			return "MIKROKLIMA s.r.o."
		}
	case 1223:
		{ /* '1223' */
			return "Density"
		}
	case 1224:
		{ /* '1224' */
			return "ICONAG-Leittechnik GmbH"
		}
	case 1225:
		{ /* '1225' */
			return "Awair"
		}
	case 1226:
		{ /* '1226' */
			return "T&D Engineering, Ltd"
		}
	case 1227:
		{ /* '1227' */
			return "Sistemas Digitales"
		}
	case 1228:
		{ /* '1228' */
			return "Loxone Electronics GmbH"
		}
	case 1229:
		{ /* '1229' */
			return "ActronAir"
		}
	case 123:
		{ /* '123' */
			return "Scada Engine"
		}
	case 1230:
		{ /* '1230' */
			return "Inductive Automation"
		}
	case 1231:
		{ /* '1231' */
			return "Thor Engineering GmbH"
		}
	case 1232:
		{ /* '1232' */
			return "Berner International, LLC"
		}
	case 1233:
		{ /* '1233' */
			return "Potsdam Sensors LLC"
		}
	case 1234:
		{ /* '1234' */
			return "Kohler Mira Ltd"
		}
	case 1235:
		{ /* '1235' */
			return "Tecomon GmbH"
		}
	case 1236:
		{ /* '1236' */
			return "Two Dimensional Instruments, LLC"
		}
	case 1237:
		{ /* '1237' */
			return "LEFA Technologies Pte. Ltd."
		}
	case 1238:
		{ /* '1238' */
			return "EATON CEAG Notlichtsysteme GmbH"
		}
	case 1239:
		{ /* '1239' */
			return "Commbox Tecnologia"
		}
	case 124:
		{ /* '124' */
			return "Lenze Americas (Formerly: AC Technology Corporation)"
		}
	case 1240:
		{ /* '1240' */
			return "IPVideo Corporation"
		}
	case 1241:
		{ /* '1241' */
			return "Bender GmbH & Co. KG"
		}
	case 1242:
		{ /* '1242' */
			return "Rhymebus Corporation"
		}
	case 1243:
		{ /* '1243' */
			return "Axon Systems Ltd"
		}
	case 1244:
		{ /* '1244' */
			return "Engineered Air"
		}
	case 1245:
		{ /* '1245' */
			return "Elipse Software Ltda"
		}
	case 1246:
		{ /* '1246' */
			return "Simatix Building Technologies Pvt. Ltd."
		}
	case 1247:
		{ /* '1247' */
			return "W.A. Benjamin Electric Co."
		}
	case 1248:
		{ /* '1248' */
			return "TROX Air Conditioning Components (Suzhou) Co. Ltd."
		}
	case 1249:
		{ /* '1249' */
			return "SC Medical Pty Ltd."
		}
	case 125:
		{ /* '125' */
			return "Eagle Technology"
		}
	case 1250:
		{ /* '1250' */
			return "Elcanic A/S"
		}
	case 1251:
		{ /* '1251' */
			return "Obeo AS"
		}
	case 1252:
		{ /* '1252' */
			return "Tapa, Inc."
		}
	case 1253:
		{ /* '1253' */
			return "ASE Smart Energy, Inc."
		}
	case 1254:
		{ /* '1254' */
			return "Performance Services, Inc."
		}
	case 1255:
		{ /* '1255' */
			return "Veridify Security"
		}
	case 1256:
		{ /* '1256' */
			return "CD Innovation LTD"
		}
	case 1257:
		{ /* '1257' */
			return "Ben Peoples Industries, LLC"
		}
	case 1258:
		{ /* '1258' */
			return "UNICOMM Sp. z o.o"
		}
	case 1259:
		{ /* '1259' */
			return "Thing Technologies GmbH"
		}
	case 126:
		{ /* '126' */
			return "Data Aire, Inc."
		}
	case 1260:
		{ /* '1260' */
			return "Beijing Hailin Control Technology, Inc."
		}
	case 1261:
		{ /* '1261' */
			return "Digital Realty"
		}
	case 1262:
		{ /* '1262' */
			return "Agrowtek Inc."
		}
	case 1263:
		{ /* '1263' */
			return "DSP Innovation BV"
		}
	case 1264:
		{ /* '1264' */
			return "STV Electronic GmbH"
		}
	case 1265:
		{ /* '1265' */
			return "Elmeasure India Pvt Ltd."
		}
	case 1266:
		{ /* '1266' */
			return "Pineshore Energy LLC"
		}
	case 1267:
		{ /* '1267' */
			return "Brasch Environmental Technologies, LLC"
		}
	case 1268:
		{ /* '1268' */
			return "ShenZhen ZhiXing Building Tech Co., Ltd"
		}
	case 1269:
		{ /* '1269' */
			return "Sinux"
		}
	case 127:
		{ /* '127' */
			return "ABB, Inc."
		}
	case 1270:
		{ /* '1270' */
			return "Avnet Inc."
		}
	case 1271:
		{ /* '1271' */
			return "Somfy Activites SA"
		}
	case 1272:
		{ /* '1272' */
			return "Amico"
		}
	case 1273:
		{ /* '1273' */
			return "SageGlass"
		}
	case 1274:
		{ /* '1274' */
			return "AuVerte"
		}
	case 1275:
		{ /* '1275' */
			return "Agile Connects Pvt. Ltd."
		}
	case 1276:
		{ /* '1276' */
			return "Locimation Pty Ltd"
		}
	case 1277:
		{ /* '1277' */
			return "Envio Systems GmbH"
		}
	case 1278:
		{ /* '1278' */
			return "Voytech Systems Limited"
		}
	case 1279:
		{ /* '1279' */
			return "Davidsmeyer und Paul GmbH"
		}
	case 128:
		{ /* '128' */
			return "Transbit Sp. z o. o."
		}
	case 1280:
		{ /* '1280' */
			return "Lusher Engineering Services"
		}
	case 1281:
		{ /* '1281' */
			return "CHNT Nanjing Techsel Intelligent Company LTD"
		}
	case 1282:
		{ /* '1282' */
			return "Threetronics Pty Ltd"
		}
	case 1283:
		{ /* '1283' */
			return "SkyFoundry, LLC"
		}
	case 1284:
		{ /* '1284' */
			return "HanilProTech"
		}
	case 1285:
		{ /* '1285' */
			return "Sensorscall"
		}
	case 1286:
		{ /* '1286' */
			return "Shanghai Jingpu Information Technology, Co., Ltd."
		}
	case 1287:
		{ /* '1287' */
			return "Lichtmanufaktur Berlin GmbH"
		}
	case 1288:
		{ /* '1288' */
			return "Eco Parking Technologies"
		}
	case 1289:
		{ /* '1289' */
			return "Envision Digital International Pte Ltd"
		}
	case 129:
		{ /* '129' */
			return "Carrier Japan Corporation"
		}
	case 1290:
		{ /* '1290' */
			return "Antony Developpement Electronique"
		}
	case 1291:
		{ /* '1291' */
			return "i2systems"
		}
	case 1292:
		{ /* '1292' */
			return "Thureon International Limited"
		}
	case 1293:
		{ /* '1293' */
			return "Pulsafeeder"
		}
	case 1294:
		{ /* '1294' */
			return "MegaChips Corporation"
		}
	case 1295:
		{ /* '1295' */
			return "TES Controls"
		}
	case 1296:
		{ /* '1296' */
			return "Cermate"
		}
	case 1297:
		{ /* '1297' */
			return "Grand Valley State University"
		}
	case 1298:
		{ /* '1298' */
			return "Symcon Gmbh"
		}
	case 1299:
		{ /* '1299' */
			return "The Chicago Faucet Company"
		}
	case 13:
		{ /* '13' */
			return "Teletrol Systems Inc."
		}
	case 130:
		{ /* '130' */
			return "Shenzhen Junzhi Hi-Tech Co., Ltd."
		}
	case 1300:
		{ /* '1300' */
			return "Geberit AG"
		}
	case 1301:
		{ /* '1301' */
			return "Rex Controls"
		}
	case 1302:
		{ /* '1302' */
			return "IVMS GmbH"
		}
	case 1303:
		{ /* '1303' */
			return "MNPP Saturn Ltd."
		}
	case 1304:
		{ /* '1304' */
			return "Regal Beloit"
		}
	case 1305:
		{ /* '1305' */
			return "ACS-Air Conditioning Solutions"
		}
	case 1306:
		{ /* '1306' */
			return "GBX Technology, LLC"
		}
	case 1307:
		{ /* '1307' */
			return "Kaiterra"
		}
	case 1308:
		{ /* '1308' */
			return "ThinKuan loT Technology (Shanghai) Co., Ltd"
		}
	case 1309:
		{ /* '1309' */
			return "HoCoSto B.V."
		}
	case 131:
		{ /* '131' */
			return "Tokai Soft"
		}
	case 1310:
		{ /* '1310' */
			return "Shenzhen AS-AI Technology Co., Ltd."
		}
	case 1311:
		{ /* '1311' */
			return "RPS S.p.a."
		}
	case 1312:
		{ /* '1312' */
			return "Esmé solutions"
		}
	case 1313:
		{ /* '1313' */
			return "IOTech Systems Limited"
		}
	case 1314:
		{ /* '1314' */
			return "i-AutoLogic Co., Ltd."
		}
	case 1315:
		{ /* '1315' */
			return "New Age Micro, LLC"
		}
	case 1316:
		{ /* '1316' */
			return "Guardian Glass"
		}
	case 1317:
		{ /* '1317' */
			return "Guangzhou Zhaoyu Information Technology"
		}
	case 1318:
		{ /* '1318' */
			return "ACE IoT Solutions LLC"
		}
	case 1319:
		{ /* '1319' */
			return "Poris Electronics Co., Ltd."
		}
	case 132:
		{ /* '132' */
			return "Blue Ridge Technologies"
		}
	case 1320:
		{ /* '1320' */
			return "Terminus Technologies Group"
		}
	case 1321:
		{ /* '1321' */
			return "Intech 21, Inc."
		}
	case 1322:
		{ /* '1322' */
			return "Accurate Electronics"
		}
	case 1323:
		{ /* '1323' */
			return "Fluence Bioengineering"
		}
	case 1324:
		{ /* '1324' */
			return "Mun Hean Singapore Pte Ltd"
		}
	case 1325:
		{ /* '1325' */
			return "Katronic AG & Co. KG"
		}
	case 1326:
		{ /* '1326' */
			return "Suzhou XinAo Information Technology Co. Ltd"
		}
	case 1327:
		{ /* '1327' */
			return "Linktekk Technology, JSC."
		}
	case 1328:
		{ /* '1328' */
			return "Stirling Ultracold"
		}
	case 1329:
		{ /* '1329' */
			return "UV Partners, Inc."
		}
	case 133:
		{ /* '133' */
			return "Veris Industries"
		}
	case 1330:
		{ /* '1330' */
			return "ProMinent GmbH"
		}
	case 1331:
		{ /* '1331' */
			return "Multi-Tech Systems, Inc."
		}
	case 1332:
		{ /* '1332' */
			return "JUMO GmbH & Co. KG"
		}
	case 1333:
		{ /* '1333' */
			return "Qingdao Huarui Technology Co. Ltd.,"
		}
	case 1334:
		{ /* '1334' */
			return "Cairn Systemes"
		}
	case 1335:
		{ /* '1335' */
			return "NeuroLogic Research Corp."
		}
	case 1336:
		{ /* '1336' */
			return "Transition Technologies Advanced Solutions Sp. z o.o"
		}
	case 1337:
		{ /* '1337' */
			return "Xxter bv"
		}
	case 1338:
		{ /* '1338' */
			return "PassiveLogic"
		}
	case 1339:
		{ /* '1339' */
			return "EnSmart Controls"
		}
	case 134:
		{ /* '134' */
			return "Centaurus Prime"
		}
	case 1340:
		{ /* '1340' */
			return "Watts Heating and Hot Water Solutions, dba Lync"
		}
	case 1341:
		{ /* '1341' */
			return "Troposphaira Technologies LLP"
		}
	case 1342:
		{ /* '1342' */
			return "Network Thermostat"
		}
	case 1343:
		{ /* '1343' */
			return "Titanium Intelligent Solutions, LLC"
		}
	case 1344:
		{ /* '1344' */
			return "Numa Products, LLC"
		}
	case 1345:
		{ /* '1345' */
			return "WAREMA Renkhoff SE"
		}
	case 1346:
		{ /* '1346' */
			return "Frese A/S"
		}
	case 1347:
		{ /* '1347' */
			return "Mapped"
		}
	case 1348:
		{ /* '1348' */
			return "ELEKTRODESIGN ventilatory s.r.o"
		}
	case 1349:
		{ /* '1349' */
			return "AirCare Automation, Inc."
		}
	case 135:
		{ /* '135' */
			return "Sand Network Systems"
		}
	case 1350:
		{ /* '1350' */
			return "Antrum"
		}
	case 1351:
		{ /* '1351' */
			return "Bao Linh Connect Technology"
		}
	case 1352:
		{ /* '1352' */
			return "Virginia Controls, LLC"
		}
	case 1353:
		{ /* '1353' */
			return "Duosys SDN BHD"
		}
	case 1354:
		{ /* '1354' */
			return "Onsen SAS"
		}
	case 1355:
		{ /* '1355' */
			return "Vaughn Thermal Corporation"
		}
	case 1356:
		{ /* '1356' */
			return "Thermoplastic Engineering Ltd (TPE)"
		}
	case 1357:
		{ /* '1357' */
			return "Wirth Research Ltd."
		}
	case 1358:
		{ /* '1358' */
			return "SST Automation"
		}
	case 1359:
		{ /* '1359' */
			return "Shanghai Bencol Electronic Technology Co., Ltd"
		}
	case 136:
		{ /* '136' */
			return "Regulvar, Inc."
		}
	case 1360:
		{ /* '1360' */
			return "AIWAA Systems Private Limited"
		}
	case 1361:
		{ /* '1361' */
			return "Enless Wireless"
		}
	case 1362:
		{ /* '1362' */
			return "Ozuno Engineering Pty Ltd"
		}
	case 1363:
		{ /* '1363' */
			return "Hubbell, The Electric Heater Company"
		}
	case 1364:
		{ /* '1364' */
			return "Industrial Turnaround Corporation (ITAC)"
		}
	case 1365:
		{ /* '1365' */
			return "Wadsworth Control Systems"
		}
	case 1366:
		{ /* '1366' */
			return "Services Hilo Inc."
		}
	case 1367:
		{ /* '1367' */
			return "iDM Energiesysteme GmbH"
		}
	case 1368:
		{ /* '1368' */
			return "BeNext B.V."
		}
	case 1369:
		{ /* '1369' */
			return "CleanAir.ai Corporation"
		}
	case 137:
		{ /* '137' */
			return "AFDtek Division of Fastek International Inc."
		}
	case 1370:
		{ /* '1370' */
			return "Revolution Microelectronics (America) Inc."
		}
	case 1371:
		{ /* '1371' */
			return "Real-Time Systems GmbH"
		}
	case 1372:
		{ /* '1372' */
			return "ZedBee Technologies Pvt Ltd"
		}
	case 1373:
		{ /* '1373' */
			return "Wimate Technology Solutions Pvt. Ltd."
		}
	case 1374:
		{ /* '1374' */
			return "Senticon Ltd."
		}
	case 1375:
		{ /* '1375' */
			return "Rossaker AB"
		}
	case 1376:
		{ /* '1376' */
			return "OPIT Solutions Ltd"
		}
	case 1377:
		{ /* '1377' */
			return "Hotowell International Co., Limited"
		}
	case 1378:
		{ /* '1378' */
			return "Inim Electronics S.R.L. Unipersonale"
		}
	case 1379:
		{ /* '1379' */
			return "Airthings ASA"
		}
	case 138:
		{ /* '138' */
			return "PowerCold Comfort Air Solutions, Inc."
		}
	case 1380:
		{ /* '1380' */
			return "Analog Devices, Inc."
		}
	case 1381:
		{ /* '1381' */
			return "AIDirections DMCC"
		}
	case 1382:
		{ /* '1382' */
			return "Prima Electro S.p.A."
		}
	case 1383:
		{ /* '1383' */
			return "KLT Control System Ltd."
		}
	case 1384:
		{ /* '1384' */
			return "Evolution Controls Inc."
		}
	case 1385:
		{ /* '1385' */
			return "Bever Innovations"
		}
	case 1386:
		{ /* '1386' */
			return "Pelican Wireless Systems"
		}
	case 1387:
		{ /* '1387' */
			return "Control Concepts Inc."
		}
	case 1388:
		{ /* '1388' */
			return "Augmatic Technologies Pvt. Ltd."
		}
	case 1389:
		{ /* '1389' */
			return "Xiamen Milesight loT Co., Ltd"
		}
	case 139:
		{ /* '139' */
			return "I Controls"
		}
	case 1390:
		{ /* '1390' */
			return "Tianjin Anjie loT Schience and Technology Co., Ltd"
		}
	case 1391:
		{ /* '1391' */
			return "Guangzhou S. Energy Electronics Technology Co. Ltd."
		}
	case 1392:
		{ /* '1392' */
			return "AKVO Atmospheric Water Systems Pvt. Ltd."
		}
	case 1393:
		{ /* '1393' */
			return "EmFirst Co. Ltd."
		}
	case 1394:
		{ /* '1394' */
			return "Iion Systems ApS"
		}
	case 1396:
		{ /* '1396' */
			return "SAF Tehnika JSC"
		}
	case 1397:
		{ /* '1397' */
			return "Komfort IQ, Inc."
		}
	case 1398:
		{ /* '1398' */
			return "CoolTera Limited"
		}
	case 1399:
		{ /* '1399' */
			return "Hadron Solutions S.r.l.s"
		}
	case 14:
		{ /* '14' */
			return "Cimetrics Technology"
		}
	case 140:
		{ /* '140' */
			return "Viconics Electronics, Inc."
		}
	case 1401:
		{ /* '1401' */
			return "Bitpool"
		}
	case 1402:
		{ /* '1402' */
			return "Sonicu, LLC"
		}
	case 1403:
		{ /* '1403' */
			return "Rishabh Instruments Limited"
		}
	case 1404:
		{ /* '1404' */
			return "Thing Warehouse LLC"
		}
	case 1405:
		{ /* '1405' */
			return "Innofriends GmbH"
		}
	case 1406:
		{ /* '1406' */
			return "Metronic AKP Sp. J."
		}
	case 1407:
		{ /* '1407' */
			return "Techknave"
		}
	case 1408:
		{ /* '1408' */
			return "Elsner Elektronik"
		}
	case 1409:
		{ /* '1409' */
			return "LEFOO Industrial (Hangzhou) Co., Ltd."
		}
	case 141:
		{ /* '141' */
			return "Yaskawa America, Inc."
		}
	case 1410:
		{ /* '1410' */
			return "Calibration Technologies, Inc."
		}
	case 1411:
		{ /* '1411' */
			return "Allorado"
		}
	case 1412:
		{ /* '1412' */
			return "Verkada"
		}
	case 1413:
		{ /* '1413' */
			return "Wattsense"
		}
	case 1414:
		{ /* '1414' */
			return "Emerson Automation Solutions"
		}
	case 1415:
		{ /* '1415' */
			return "Growlink"
		}
	case 1416:
		{ /* '1416' */
			return "Olympia Electronics"
		}
	case 1417:
		{ /* '1417' */
			return "Normal Software, Inc."
		}
	case 1418:
		{ /* '1418' */
			return "ST Engineering Solution JSC"
		}
	case 1419:
		{ /* '1419' */
			return "Industrial Flow Solutions"
		}
	case 142:
		{ /* '142' */
			return "DEOS control systems GmbH"
		}
	case 1420:
		{ /* '1420' */
			return "Ubiqisense ApS"
		}
	case 1421:
		{ /* '1421' */
			return "Tiger-Soft"
		}
	case 1422:
		{ /* '1422' */
			return "Ecodom Srl"
		}
	case 1423:
		{ /* '1423' */
			return "Bilgipro IoT Systems"
		}
	case 1424:
		{ /* '1424' */
			return "planspur netdesign GmbH"
		}
	case 1425:
		{ /* '1425' */
			return "Dolphin Solutions Ltd"
		}
	case 1426:
		{ /* '1426' */
			return "Mitsubishi Electric Corporation, Kobe Works"
		}
	case 1427:
		{ /* '1427' */
			return "Ecovena"
		}
	case 1428:
		{ /* '1428' */
			return "Gree Electric Appliances Inc of Zhuhai"
		}
	case 1429:
		{ /* '1429' */
			return "Conspec Controls"
		}
	case 143:
		{ /* '143' */
			return "Digitale Mess- und Steuersysteme AG"
		}
	case 1430:
		{ /* '1430' */
			return "Hangzhou Hikvision Digital Technology Co., Ltd."
		}
	case 1431:
		{ /* '1431' */
			return "Crystal Peak Security"
		}
	case 1432:
		{ /* '1432' */
			return "PermAlert"
		}
	case 1433:
		{ /* '1433' */
			return "Zhejiang Misilin Technology Co., Ltd."
		}
	case 1434:
		{ /* '1434' */
			return "Dekker Vacuum Technologies"
		}
	case 1435:
		{ /* '1435' */
			return "Edwards Limited"
		}
	case 1436:
		{ /* '1436' */
			return "Leybold GmbH"
		}
	case 1437:
		{ /* '1437' */
			return "International Gas Detectors"
		}
	case 1438:
		{ /* '1438' */
			return "Atlas Copco Airpower NV"
		}
	case 1439:
		{ /* '1439' */
			return "Air Sentry Limited"
		}
	case 144:
		{ /* '144' */
			return "Fujitsu General Limited"
		}
	case 1440:
		{ /* '1440' */
			return "Aelsys"
		}
	case 1441:
		{ /* '1441' */
			return "Granby Consulting LLC"
		}
	case 1442:
		{ /* '1442' */
			return "Clever Relay"
		}
	case 1443:
		{ /* '1443' */
			return "Monico Monitoring, Inc."
		}
	case 1444:
		{ /* '1444' */
			return "Oqdo"
		}
	case 1445:
		{ /* '1445' */
			return "Matrix Comsec Private Limited"
		}
	case 1446:
		{ /* '1446' */
			return "Resource Solutions"
		}
	case 1447:
		{ /* '1447' */
			return "American Gas Safety, LLC"
		}
	case 1448:
		{ /* '1448' */
			return "S&S Northern Ltd."
		}
	case 1449:
		{ /* '1449' */
			return "Ulbios Techsens"
		}
	case 145:
		{ /* '145' */
			return "Project Engineering S.r.l."
		}
	case 1450:
		{ /* '1450' */
			return "Bowery Farming, Inc."
		}
	case 1451:
		{ /* '1451' */
			return "Ryobi Limited"
		}
	case 1452:
		{ /* '1452' */
			return "EkkoSense Ltd"
		}
	case 1453:
		{ /* '1453' */
			return "ClimaCool"
		}
	case 1454:
		{ /* '1454' */
			return "Grid Connect Inc."
		}
	case 1455:
		{ /* '1455' */
			return "Ziegler Instrumentation UK Ltd"
		}
	case 1456:
		{ /* '1456' */
			return "ControlTec, LLC"
		}
	case 1457:
		{ /* '1457' */
			return "Aeterlink Corporation"
		}
	case 1458:
		{ /* '1458' */
			return "Alpha Epsilon Automation"
		}
	case 1459:
		{ /* '1459' */
			return "Astralite Inc."
		}
	case 146:
		{ /* '146' */
			return "Sanyo Electric Co., Ltd."
		}
	case 1460:
		{ /* '1460' */
			return "Delta Fire Ltda."
		}
	case 1461:
		{ /* '1461' */
			return "Bock Water Heaters, Inc."
		}
	case 1462:
		{ /* '1462' */
			return "Cleaver-Brooks"
		}
	case 1463:
		{ /* '1463' */
			return "Scanalytics, Inc."
		}
	case 1464:
		{ /* '1464' */
			return "WI6LABS"
		}
	case 1465:
		{ /* '1465' */
			return "AC&T System Co., Ltd"
		}
	case 1466:
		{ /* '1466' */
			return "VergeSense"
		}
	case 1467:
		{ /* '1467' */
			return "Systemair Mfg. Inc."
		}
	case 1468:
		{ /* '1468' */
			return "Seeley International"
		}
	case 1469:
		{ /* '1469' */
			return "Crane Building Services & Utilities"
		}
	case 147:
		{ /* '147' */
			return "Integrated Information Systems, Inc."
		}
	case 1470:
		{ /* '1470' */
			return "Brady Corporation"
		}
	case 1471:
		{ /* '1471' */
			return "Qingdao Hisense Hitachi Air-Conditioning Systems Co., Ltd."
		}
	case 1472:
		{ /* '1472' */
			return "Golden Quality Co. Ltd."
		}
	case 1473:
		{ /* '1473' */
			return "Elvaco AB"
		}
	case 1474:
		{ /* '1474' */
			return "Strong Technology, LLC"
		}
	case 1475:
		{ /* '1475' */
			return "REC Environmental Technology (Guangzhou) Company Limited"
		}
	case 1476:
		{ /* '1476' */
			return "Disruptive Technologies Research AS"
		}
	case 1477:
		{ /* '1477' */
			return "Nico Consultancy Limited"
		}
	case 1478:
		{ /* '1478' */
			return "Horten lot (Jiangsu) Co., Ltd."
		}
	case 1479:
		{ /* '1479' */
			return "Paxton Controls Corp."
		}
	case 148:
		{ /* '148' */
			return "Temco Controls, Ltd."
		}
	case 1480:
		{ /* '1480' */
			return "Fell Technology AS"
		}
	case 1481:
		{ /* '1481' */
			return "SHLOK Information Systems India Private Limited"
		}
	case 1482:
		{ /* '1482' */
			return "Microgro PLC Ltd."
		}
	case 1483:
		{ /* '1483' */
			return "Clouder Oy"
		}
	case 1484:
		{ /* '1484' */
			return "Gebäude Automatisierung GmbH"
		}
	case 1485:
		{ /* '1485' */
			return "solvimus GmbH"
		}
	case 1486:
		{ /* '1486' */
			return "GuangZhou Wangkong Ltd."
		}
	case 1487:
		{ /* '1487' */
			return "SafeSquare GmbH"
		}
	case 1488:
		{ /* '1488' */
			return "Heklatech AB"
		}
	case 1489:
		{ /* '1489' */
			return "Silvair"
		}
	case 149:
		{ /* '149' */
			return "Airtek International Inc."
		}
	case 1490:
		{ /* '1490' */
			return "Adveco"
		}
	case 1491:
		{ /* '1491' */
			return "Eura Drives Electric Co., Ltd."
		}
	case 1492:
		{ /* '1492' */
			return "Caleb Controls"
		}
	case 1493:
		{ /* '1493' */
			return "InBiot Monitoring S.L"
		}
	case 1494:
		{ /* '1494' */
			return "Qingdao Haier Air Conditioner Electric Co., Ltd."
		}
	case 1495:
		{ /* '1495' */
			return "Hangzhou Weiyl Technology Co., Ltd."
		}
	case 1496:
		{ /* '1496' */
			return "yord sàrl"
		}
	case 1497:
		{ /* '1497' */
			return "Infinitum Electric"
		}
	case 1498:
		{ /* '1498' */
			return "Red Bean Systems Limited"
		}
	case 1499:
		{ /* '1499' */
			return "Blue Time Concept SA"
		}
	case 15:
		{ /* '15' */
			return "Cornell University"
		}
	case 150:
		{ /* '150' */
			return "Advantech Corporation"
		}
	case 1500:
		{ /* '1500' */
			return "Shenzhen INVT Electric Co., Ltd."
		}
	case 1501:
		{ /* '1501' */
			return "Messung Systems Pvt Ltd."
		}
	case 1502:
		{ /* '1502' */
			return "ABB Electrification Canada Inc."
		}
	case 1503:
		{ /* '1503' */
			return "Core Controls"
		}
	case 1504:
		{ /* '1504' */
			return "Noord Tech d.o.o."
		}
	case 1505:
		{ /* '1505' */
			return "Varibits AS"
		}
	case 1506:
		{ /* '1506' */
			return "Roger Sp. z o.o. sp.k."
		}
	case 1507:
		{ /* '1507' */
			return "Viega GmbH & Co. KG"
		}
	case 1508:
		{ /* '1508' */
			return "Astersoft"
		}
	case 1509:
		{ /* '1509' */
			return "BIG-EU"
		}
	case 151:
		{ /* '151' */
			return "Titan Products, Ltd."
		}
	case 1510:
		{ /* '1510' */
			return "Inferrix Limited"
		}
	case 1511:
		{ /* '1511' */
			return "Richards Electric Motor Co."
		}
	case 1512:
		{ /* '1512' */
			return "dAPPControls"
		}
	case 1513:
		{ /* '1513' */
			return "Entouch Controls"
		}
	case 1514:
		{ /* '1514' */
			return "Mavili Elektronik Ticaret ve Sanayi Anonim Sirketi"
		}
	case 1515:
		{ /* '1515' */
			return "BubblyNet"
		}
	case 1516:
		{ /* '1516' */
			return "AlMayssan Technical Services Co. Ltd."
		}
	case 1517:
		{ /* '1517' */
			return "Viridi Parente, Inc."
		}
	case 1518:
		{ /* '1518' */
			return "Novel Apps Corp."
		}
	case 1519:
		{ /* '1519' */
			return "Oventrop (China) HVAC System Technology Co., Ltd."
		}
	case 152:
		{ /* '152' */
			return "Regel Partners"
		}
	case 1521:
		{ /* '1521' */
			return "Lacroix Sofrel"
		}
	case 1522:
		{ /* '1522' */
			return "MachineSens loT Trading Co., LLC"
		}
	case 1523:
		{ /* '1523' */
			return "Elmec Inc."
		}
	case 1524:
		{ /* '1524' */
			return "Beijing Haishi Software Co., Ltd."
		}
	case 1525:
		{ /* '1525' */
			return "Radix Electrosystems Pvt. Ltd."
		}
	case 1526:
		{ /* '1526' */
			return "Värmebaronen AB"
		}
	case 1527:
		{ /* '1527' */
			return "Treau Inc., dba Gradient"
		}
	case 1528:
		{ /* '1528' */
			return "WEST Solution AG"
		}
	case 1529:
		{ /* '1529' */
			return "Trueway Controls Hongkong Limited"
		}
	case 153:
		{ /* '153' */
			return "National Environmental Product"
		}
	case 1530:
		{ /* '1530' */
			return "BuildingLogiX"
		}
	case 1531:
		{ /* '1531' */
			return "Ifesca GmbH"
		}
	case 1532:
		{ /* '1532' */
			return "Fellowes Inc."
		}
	case 1533:
		{ /* '1533' */
			return "Caleffi S.p.A."
		}
	case 1534:
		{ /* '1534' */
			return "JDRF Electromag"
		}
	case 1535:
		{ /* '1535' */
			return "Redwire Labs"
		}
	case 1536:
		{ /* '1536' */
			return "Wecon Technology Co., Ltd."
		}
	case 1537:
		{ /* '1537' */
			return "Acacia Green Technologies Ltd"
		}
	case 1538:
		{ /* '1538' */
			return "Degree Analytics"
		}
	case 1539:
		{ /* '1539' */
			return "Roltek Teknoloji A.S."
		}
	case 154:
		{ /* '154' */
			return "Unitec Corporation"
		}
	case 1540:
		{ /* '1540' */
			return "Digital Control Technology Limited"
		}
	case 1541:
		{ /* '1541' */
			return "Kentima AB"
		}
	case 1542:
		{ /* '1542' */
			return "Pergamon Perceptive Technologies"
		}
	case 1543:
		{ /* '1543' */
			return "Prefect Controls Ltd."
		}
	case 1544:
		{ /* '1544' */
			return "SenTech Corporation"
		}
	case 1545:
		{ /* '1545' */
			return "S+S Regeltechnik GmbH"
		}
	case 1546:
		{ /* '1546' */
			return "AirBox, Inc."
		}
	case 1547:
		{ /* '1547' */
			return "RVE"
		}
	case 1548:
		{ /* '1548' */
			return "Motorola Solutions"
		}
	case 1549:
		{ /* '1549' */
			return "BACSYS Innovations Private Limited"
		}
	case 155:
		{ /* '155' */
			return "Kanden Engineering Company"
		}
	case 1550:
		{ /* '1550' */
			return "Ewattch"
		}
	case 1551:
		{ /* '1551' */
			return "Builtlayer LLC"
		}
	case 1552:
		{ /* '1552' */
			return "A&G Domotix S.R.L."
		}
	case 1553:
		{ /* '1553' */
			return "Hytronik Industrial Limited"
		}
	case 1554:
		{ /* '1554' */
			return "WHO Reinraumtechnik"
		}
	case 1555:
		{ /* '1555' */
			return "TRICO Limited"
		}
	case 1556:
		{ /* '1556' */
			return "SLKAutomation SRL"
		}
	case 1557:
		{ /* '1557' */
			return "Zaphire AS"
		}
	case 1558:
		{ /* '1558' */
			return "AJ Manufacturing"
		}
	case 1559:
		{ /* '1559' */
			return "Future Motors Ltd."
		}
	case 156:
		{ /* '156' */
			return "Messner Gebäudetechnik GmbH"
		}
	case 1560:
		{ /* '1560' */
			return "Himel Hong Kong Limited"
		}
	case 1561:
		{ /* '1561' */
			return "Shenzhen Sunricher Technology Co., Ltd."
		}
	case 1562:
		{ /* '1562' */
			return "Actility S.A."
		}
	case 1563:
		{ /* '1563' */
			return "Oy Halton Group Ltd."
		}
	case 1564:
		{ /* '1564' */
			return "AVTECH Software, Inc."
		}
	case 1565:
		{ /* '1565' */
			return "InControl Engineering LLC"
		}
	case 1566:
		{ /* '1566' */
			return "SoundWater Technologies LLC"
		}
	case 157:
		{ /* '157' */
			return "Integrated.CH"
		}
	case 158:
		{ /* '158' */
			return "Price Industries"
		}
	case 159:
		{ /* '159' */
			return "SE-Elektronic GmbH"
		}
	case 16:
		{ /* '16' */
			return "United Technologies Carrier"
		}
	case 160:
		{ /* '160' */
			return "Rockwell Automation"
		}
	case 161:
		{ /* '161' */
			return "Enflex Corp."
		}
	case 162:
		{ /* '162' */
			return "ASI Controls"
		}
	case 163:
		{ /* '163' */
			return "SysMik GmbH Dresden"
		}
	case 164:
		{ /* '164' */
			return "HSC Regelungstechnik GmbH"
		}
	case 165:
		{ /* '165' */
			return "Smart Temp Australia Pty. Ltd."
		}
	case 166:
		{ /* '166' */
			return "Cooper Controls"
		}
	case 167:
		{ /* '167' */
			return "Duksan Mecasys Co., Ltd."
		}
	case 168:
		{ /* '168' */
			return "Fuji IT Co., Ltd."
		}
	case 169:
		{ /* '169' */
			return "Vacon Plc"
		}
	case 17:
		{ /* '17' */
			return "Honeywell Inc."
		}
	case 170:
		{ /* '170' */
			return "Leader Controls"
		}
	case 171:
		{ /* '171' */
			return "ABB (Formerly Cylon Controls, Ltd)"
		}
	case 172:
		{ /* '172' */
			return "Compas"
		}
	case 173:
		{ /* '173' */
			return "Mitsubishi Electric Building Techno-Service Co., Ltd."
		}
	case 174:
		{ /* '174' */
			return "Building Control Integrators"
		}
	case 175:
		{ /* '175' */
			return "ITG Worldwide (M) Sdn Bhd"
		}
	case 176:
		{ /* '176' */
			return "Lutron Electronics Co., Inc."
		}
	case 177:
		{ /* '177' */
			return "Cooper-Atkins Corporation"
		}
	case 178:
		{ /* '178' */
			return "LOYTEC Electronics GmbH"
		}
	case 179:
		{ /* '179' */
			return "ProLon"
		}
	case 18:
		{ /* '18' */
			return "Alerton / Honeywell"
		}
	case 180:
		{ /* '180' */
			return "Mega Controls Limited"
		}
	case 181:
		{ /* '181' */
			return "Micro Control Systems, Inc."
		}
	case 182:
		{ /* '182' */
			return "Kiyon, Inc."
		}
	case 183:
		{ /* '183' */
			return "Dust Networks"
		}
	case 184:
		{ /* '184' */
			return "Advanced Building Automation Systems"
		}
	case 185:
		{ /* '185' */
			return "Hermos AG"
		}
	case 186:
		{ /* '186' */
			return "CEZIM"
		}
	case 187:
		{ /* '187' */
			return "Softing"
		}
	case 188:
		{ /* '188' */
			return "Lynxspring, Inc."
		}
	case 189:
		{ /* '189' */
			return "Schneider Toshiba Inverter Europe"
		}
	case 19:
		{ /* '19' */
			return "TAC AB"
		}
	case 190:
		{ /* '190' */
			return "Danfoss Drives A/S"
		}
	case 191:
		{ /* '191' */
			return "Eaton Corporation"
		}
	case 192:
		{ /* '192' */
			return "Matyca S.A."
		}
	case 193:
		{ /* '193' */
			return "Botech AB"
		}
	case 194:
		{ /* '194' */
			return "Noveo, Inc."
		}
	case 195:
		{ /* '195' */
			return "AMEV"
		}
	case 196:
		{ /* '196' */
			return "Yokogawa Electric Corporation"
		}
	case 197:
		{ /* '197' */
			return "Bosch Building Automation GmbH"
		}
	case 198:
		{ /* '198' */
			return "Exact Logic"
		}
	case 199:
		{ /* '199' */
			return "Mass Electronics Pty Ltd dba Innotech Control Systems Australia"
		}
	case 2:
		{ /* '2' */
			return "The Trane Company"
		}
	case 20:
		{ /* '20' */
			return "Hewlett-Packard Company"
		}
	case 200:
		{ /* '200' */
			return "Kandenko Co., Ltd."
		}
	case 201:
		{ /* '201' */
			return "DTF, Daten-Technik Fries"
		}
	case 202:
		{ /* '202' */
			return "Klimasoft, Ltd."
		}
	case 203:
		{ /* '203' */
			return "Toshiba Schneider Inverter Corporation"
		}
	case 204:
		{ /* '204' */
			return "Control Applications, Ltd."
		}
	case 205:
		{ /* '205' */
			return "CIMON CO., Ltd."
		}
	case 206:
		{ /* '206' */
			return "Onicon Incorporated"
		}
	case 207:
		{ /* '207' */
			return "Automation Displays, Inc."
		}
	case 208:
		{ /* '208' */
			return "Control Solutions, Inc."
		}
	case 209:
		{ /* '209' */
			return "Remsdaq Limited"
		}
	case 21:
		{ /* '21' */
			return "Dorsette’s Inc."
		}
	case 210:
		{ /* '210' */
			return "NTT Facilities, Inc."
		}
	case 211:
		{ /* '211' */
			return "VIPA GmbH"
		}
	case 212:
		{ /* '212' */
			return "TSC21 Association of Japan"
		}
	case 213:
		{ /* '213' */
			return "Strato Automation"
		}
	case 214:
		{ /* '214' */
			return "HRW Limited"
		}
	case 215:
		{ /* '215' */
			return "Lighting Control & Design, Inc."
		}
	case 216:
		{ /* '216' */
			return "Mercy Electronic and Electrical Industries"
		}
	case 217:
		{ /* '217' */
			return "Samsung SDS Co., Ltd"
		}
	case 218:
		{ /* '218' */
			return "Impact Facility Solutions, Inc."
		}
	case 219:
		{ /* '219' */
			return "Aircuity"
		}
	case 22:
		{ /* '22' */
			return "Siemens Schweiz AG"
		}
	case 220:
		{ /* '220' */
			return "Control Techniques, Ltd."
		}
	case 221:
		{ /* '221' */
			return "OpenGeneral Pty., Ltd."
		}
	case 222:
		{ /* '222' */
			return "WAGO Kontakttechnik GmbH & Co. KG"
		}
	case 223:
		{ /* '223' */
			return "Franklin Electric"
		}
	case 224:
		{ /* '224' */
			return "Chloride Power Protection Company"
		}
	case 225:
		{ /* '225' */
			return "Computrols, Inc."
		}
	case 226:
		{ /* '226' */
			return "Phoenix Contact GmbH & Co. KG"
		}
	case 227:
		{ /* '227' */
			return "Grundfos Management A/S"
		}
	case 228:
		{ /* '228' */
			return "Ridder Drive Systems"
		}
	case 229:
		{ /* '229' */
			return "Soft Device SDN BHD"
		}
	case 23:
		{ /* '23' */
			return "York Controls Group"
		}
	case 230:
		{ /* '230' */
			return "Integrated Control Technology Limited"
		}
	case 231:
		{ /* '231' */
			return "AIRxpert Systems, Inc."
		}
	case 232:
		{ /* '232' */
			return "Microtrol Limited"
		}
	case 233:
		{ /* '233' */
			return "Red Lion Controls"
		}
	case 234:
		{ /* '234' */
			return "Digital Electronics Corporation"
		}
	case 235:
		{ /* '235' */
			return "Ennovatis GmbH"
		}
	case 236:
		{ /* '236' */
			return "Serotonin Software Technologies, Inc."
		}
	case 237:
		{ /* '237' */
			return "LS Industrial Systems Co., Ltd."
		}
	case 238:
		{ /* '238' */
			return "Square D Company"
		}
	case 239:
		{ /* '239' */
			return "S Squared Innovations, Inc."
		}
	case 24:
		{ /* '24' */
			return "Automated Logic Corporation"
		}
	case 240:
		{ /* '240' */
			return "Aricent Ltd."
		}
	case 241:
		{ /* '241' */
			return "EtherMetrics, LLC"
		}
	case 242:
		{ /* '242' */
			return "Industrial Control Communications, Inc."
		}
	case 243:
		{ /* '243' */
			return "Paragon Controls, Inc."
		}
	case 244:
		{ /* '244' */
			return "A. O. Smith Corporation"
		}
	case 245:
		{ /* '245' */
			return "Contemporary Control Systems, Inc."
		}
	case 246:
		{ /* '246' */
			return "HMS Industrial Networks SLU"
		}
	case 247:
		{ /* '247' */
			return "Ingenieurgesellschaft N. Hartleb mbH"
		}
	case 248:
		{ /* '248' */
			return "Heat-Timer Corporation"
		}
	case 249:
		{ /* '249' */
			return "Ingrasys Technology, Inc."
		}
	case 25:
		{ /* '25' */
			return "CSI Control Systems International"
		}
	case 250:
		{ /* '250' */
			return "Costerm Building Automation"
		}
	case 251:
		{ /* '251' */
			return "WILO SE"
		}
	case 252:
		{ /* '252' */
			return "Embedia Technologies Corp."
		}
	case 253:
		{ /* '253' */
			return "Technilog"
		}
	case 254:
		{ /* '254' */
			return "HR Controls Ltd. & Co. KG"
		}
	case 255:
		{ /* '255' */
			return "Lennox International, Inc."
		}
	case 256:
		{ /* '256' */
			return "RK-Tec Rauchklappen-Steuerungssysteme GmbH & Co. KG"
		}
	case 257:
		{ /* '257' */
			return "Thermomax, Ltd."
		}
	case 258:
		{ /* '258' */
			return "ELCON Electronic Control, Ltd."
		}
	case 259:
		{ /* '259' */
			return "Larmia Control AB"
		}
	case 26:
		{ /* '26' */
			return "Phoenix Controls Corporation"
		}
	case 260:
		{ /* '260' */
			return "BACnet Stack at SourceForge"
		}
	case 261:
		{ /* '261' */
			return "G4S Security Services A/S"
		}
	case 262:
		{ /* '262' */
			return "Exor International S.p.A."
		}
	case 263:
		{ /* '263' */
			return "Cristal Controles"
		}
	case 264:
		{ /* '264' */
			return "Regin AB"
		}
	case 265:
		{ /* '265' */
			return "Dimension Software, Inc."
		}
	case 266:
		{ /* '266' */
			return "SynapSense Corporation"
		}
	case 267:
		{ /* '267' */
			return "Beijing Nantree Electronic Co., Ltd."
		}
	case 268:
		{ /* '268' */
			return "Camus Hydronics Ltd."
		}
	case 269:
		{ /* '269' */
			return "Kawasaki Heavy Industries, Ltd."
		}
	case 27:
		{ /* '27' */
			return "Innovex Technologies, Inc."
		}
	case 270:
		{ /* '270' */
			return "Critical Environment Technologies"
		}
	case 271:
		{ /* '271' */
			return "ILSHIN IBS Co., Ltd."
		}
	case 272:
		{ /* '272' */
			return "ELESTA Energy Control AG"
		}
	case 273:
		{ /* '273' */
			return "KROPMAN Installatietechniek"
		}
	case 274:
		{ /* '274' */
			return "Baldor Electric Company"
		}
	case 275:
		{ /* '275' */
			return "INGA mbH"
		}
	case 276:
		{ /* '276' */
			return "GE Consumer & Industrial"
		}
	case 277:
		{ /* '277' */
			return "Functional Devices, Inc."
		}
	case 278:
		{ /* '278' */
			return "StudioSC"
		}
	case 279:
		{ /* '279' */
			return "MG CO., LTD."
		}
	case 28:
		{ /* '28' */
			return "KMC Controls, Inc."
		}
	case 280:
		{ /* '280' */
			return "Yokota Co., Ltd."
		}
	case 281:
		{ /* '281' */
			return "Hitranse Technology Co., LTD"
		}
	case 282:
		{ /* '282' */
			return "Vigilent Corporation"
		}
	case 283:
		{ /* '283' */
			return "Kele, Inc."
		}
	case 284:
		{ /* '284' */
			return "BELIMO Automation AG"
		}
	case 285:
		{ /* '285' */
			return "Gentec"
		}
	case 286:
		{ /* '286' */
			return "Embedded Science Labs, LLC"
		}
	case 287:
		{ /* '287' */
			return "Parker Hannifin Corporation"
		}
	case 288:
		{ /* '288' */
			return "MaCaPS International Limited"
		}
	case 289:
		{ /* '289' */
			return "Link4 Corporation"
		}
	case 29:
		{ /* '29' */
			return "Xn Technologies, Inc."
		}
	case 290:
		{ /* '290' */
			return "Romutec Steuer-u. Regelsysteme GmbH"
		}
	case 291:
		{ /* '291' */
			return "Pribusin, Inc."
		}
	case 292:
		{ /* '292' */
			return "Advantage Controls"
		}
	case 293:
		{ /* '293' */
			return "Critical Room Control"
		}
	case 294:
		{ /* '294' */
			return "LEGRAND"
		}
	case 295:
		{ /* '295' */
			return "Tongdy Control Technology Co., Ltd."
		}
	case 296:
		{ /* '296' */
			return "ISSARO Integrierte Systemtechnik"
		}
	case 297:
		{ /* '297' */
			return "Pro-Dev Industries"
		}
	case 298:
		{ /* '298' */
			return "DRI-STEEM"
		}
	case 299:
		{ /* '299' */
			return "Creative Electronic GmbH"
		}
	case 3:
		{ /* '3' */
			return "Daikin Applied Americas"
		}
	case 30:
		{ /* '30' */
			return "Hyundai Information Technology Co., Ltd."
		}
	case 300:
		{ /* '300' */
			return "Swegon AB"
		}
	case 301:
		{ /* '301' */
			return "FIRVENA s.r.o."
		}
	case 302:
		{ /* '302' */
			return "Hitachi Appliances, Inc."
		}
	case 303:
		{ /* '303' */
			return "Real Time Automation, Inc."
		}
	case 304:
		{ /* '304' */
			return "ITEC Hankyu-Hanshin Co."
		}
	case 305:
		{ /* '305' */
			return "Cyrus E&M Engineering Co., Ltd."
		}
	case 306:
		{ /* '306' */
			return "Badger Meter"
		}
	case 307:
		{ /* '307' */
			return "Cirrascale Corporation"
		}
	case 308:
		{ /* '308' */
			return "Elesta GmbH Building Automation"
		}
	case 309:
		{ /* '309' */
			return "Securiton"
		}
	case 31:
		{ /* '31' */
			return "Tokimec Inc."
		}
	case 310:
		{ /* '310' */
			return "OSlsoft, Inc."
		}
	case 311:
		{ /* '311' */
			return "Hanazeder Electronic GmbH"
		}
	case 312:
		{ /* '312' */
			return "Honeywell Security Deutschland, Novar GmbH"
		}
	case 313:
		{ /* '313' */
			return "Siemens Industry, Inc."
		}
	case 314:
		{ /* '314' */
			return "ETM Professional Control GmbH"
		}
	case 315:
		{ /* '315' */
			return "Meitav-tec, Ltd."
		}
	case 316:
		{ /* '316' */
			return "Janitza Electronics GmbH"
		}
	case 317:
		{ /* '317' */
			return "MKS Nordhausen"
		}
	case 318:
		{ /* '318' */
			return "De Gier Drive Systems B.V."
		}
	case 319:
		{ /* '319' */
			return "Cypress Envirosystems"
		}
	case 32:
		{ /* '32' */
			return "Simplex"
		}
	case 320:
		{ /* '320' */
			return "SMARTron s.r.o."
		}
	case 321:
		{ /* '321' */
			return "Verari Systems, Inc."
		}
	case 322:
		{ /* '322' */
			return "K-W Electronic Service, Inc."
		}
	case 323:
		{ /* '323' */
			return "ALFA-SMART Energy Management"
		}
	case 324:
		{ /* '324' */
			return "Telkonet, Inc."
		}
	case 325:
		{ /* '325' */
			return "Securiton GmbH"
		}
	case 326:
		{ /* '326' */
			return "Cemtrex, Inc."
		}
	case 327:
		{ /* '327' */
			return "Performance Technologies, Inc."
		}
	case 328:
		{ /* '328' */
			return "Xtralis (Aust) Pty Ltd"
		}
	case 329:
		{ /* '329' */
			return "TROX GmbH"
		}
	case 33:
		{ /* '33' */
			return "North Building Technologies Limited"
		}
	case 330:
		{ /* '330' */
			return "Beijing Hysine Technology Co., Ltd"
		}
	case 331:
		{ /* '331' */
			return "RCK Controls, Inc."
		}
	case 332:
		{ /* '332' */
			return "Distech Controls SAS"
		}
	case 333:
		{ /* '333' */
			return "Novar/Honeywell"
		}
	case 334:
		{ /* '334' */
			return "S4 Integration Solutions"
		}
	case 335:
		{ /* '335' */
			return "Schneider Electric"
		}
	case 336:
		{ /* '336' */
			return "LHA Systems"
		}
	case 337:
		{ /* '337' */
			return "GHM engineering Group, Inc."
		}
	case 338:
		{ /* '338' */
			return "Cllimalux S.A."
		}
	case 339:
		{ /* '339' */
			return "VAISALA Oyj"
		}
	case 34:
		{ /* '34' */
			return "Notifier"
		}
	case 340:
		{ /* '340' */
			return "COMPLEX (Beijing) Technology, Co., LTD."
		}
	case 341:
		{ /* '341' */
			return "SCADAmetrics"
		}
	case 342:
		{ /* '342' */
			return "POWERPEG NSI Limited"
		}
	case 343:
		{ /* '343' */
			return "BACnet Interoperability Testing Services, Inc."
		}
	case 344:
		{ /* '344' */
			return "Teco a.s."
		}
	case 345:
		{ /* '345' */
			return "Plexus Technology, Inc."
		}
	case 346:
		{ /* '346' */
			return "Energy Focus, Inc."
		}
	case 347:
		{ /* '347' */
			return "Powersmiths International Corp."
		}
	case 348:
		{ /* '348' */
			return "Nichibei Co., Ltd."
		}
	case 349:
		{ /* '349' */
			return "HKC Technology Ltd."
		}
	case 35:
		{ /* '35' */
			return "Reliable Controls Corporation"
		}
	case 350:
		{ /* '350' */
			return "Ovation Networks, Inc."
		}
	case 351:
		{ /* '351' */
			return "Setra Systems"
		}
	case 352:
		{ /* '352' */
			return "AVG Automation"
		}
	case 353:
		{ /* '353' */
			return "ZXC Ltd."
		}
	case 354:
		{ /* '354' */
			return "Byte Sphere"
		}
	case 355:
		{ /* '355' */
			return "Generiton Co., Ltd."
		}
	case 356:
		{ /* '356' */
			return "Holter Regelarmaturen GmbH & Co. KG"
		}
	case 357:
		{ /* '357' */
			return "Bedford Instruments, LLC"
		}
	case 358:
		{ /* '358' */
			return "Standair Inc."
		}
	case 359:
		{ /* '359' */
			return "WEG Automation – R&D"
		}
	case 36:
		{ /* '36' */
			return "Tridium Inc."
		}
	case 360:
		{ /* '360' */
			return "Prolon Control Systems ApS"
		}
	case 361:
		{ /* '361' */
			return "Inneasoft"
		}
	case 362:
		{ /* '362' */
			return "ConneXSoft GmbH"
		}
	case 363:
		{ /* '363' */
			return "CEAG Notlichtsysteme GmbH"
		}
	case 364:
		{ /* '364' */
			return "Distech Controls Inc."
		}
	case 365:
		{ /* '365' */
			return "Industrial Technology Research Institute"
		}
	case 366:
		{ /* '366' */
			return "Mitsubishi Electric Iconics Digital Solutions"
		}
	case 367:
		{ /* '367' */
			return "IQ Controls s.c."
		}
	case 368:
		{ /* '368' */
			return "OJ Electronics A/S"
		}
	case 369:
		{ /* '369' */
			return "Rolbit Ltd."
		}
	case 37:
		{ /* '37' */
			return "MSA Safety"
		}
	case 370:
		{ /* '370' */
			return "Synapsys Solutions Ltd."
		}
	case 371:
		{ /* '371' */
			return "ACME Engineering Prod. Ltd."
		}
	case 372:
		{ /* '372' */
			return "Zener Electric Pty, Ltd."
		}
	case 373:
		{ /* '373' */
			return "Selectronix, Inc."
		}
	case 374:
		{ /* '374' */
			return "Gorbet & Banerjee, LLC."
		}
	case 375:
		{ /* '375' */
			return "IME"
		}
	case 376:
		{ /* '376' */
			return "Stephen H. Dawson Computer Service"
		}
	case 377:
		{ /* '377' */
			return "Accutrol, LLC"
		}
	case 378:
		{ /* '378' */
			return "Schneider Elektronik GmbH"
		}
	case 379:
		{ /* '379' */
			return "Alpha-Inno Tec GmbH"
		}
	case 38:
		{ /* '38' */
			return "Silicon Energy"
		}
	case 380:
		{ /* '380' */
			return "ADMMicro, Inc."
		}
	case 381:
		{ /* '381' */
			return "Greystone Energy Systems, Inc."
		}
	case 382:
		{ /* '382' */
			return "CAP Technologie"
		}
	case 383:
		{ /* '383' */
			return "KeRo Systems"
		}
	case 384:
		{ /* '384' */
			return "Domat Control System s.r.o."
		}
	case 385:
		{ /* '385' */
			return "Efektronics Pty. Ltd."
		}
	case 386:
		{ /* '386' */
			return "Hekatron Vertriebs GmbH"
		}
	case 387:
		{ /* '387' */
			return "Securiton AG"
		}
	case 388:
		{ /* '388' */
			return "Carlo Gavazzi Controls SpA"
		}
	case 389:
		{ /* '389' */
			return "Chipkin Automation Systems"
		}
	case 39:
		{ /* '39' */
			return "Kieback & Peter GmbH & Co KG"
		}
	case 390:
		{ /* '390' */
			return "Savant Systems, LLC"
		}
	case 391:
		{ /* '391' */
			return "Simmtronic Lighting Controls"
		}
	case 392:
		{ /* '392' */
			return "Abelko Innovation AB"
		}
	case 393:
		{ /* '393' */
			return "Seresco Technologies Inc."
		}
	case 394:
		{ /* '394' */
			return "IT Watchdogs"
		}
	case 395:
		{ /* '395' */
			return "Automation Assist Japan Corp."
		}
	case 396:
		{ /* '396' */
			return "Thermokon Sensortechnik GmbH"
		}
	case 397:
		{ /* '397' */
			return "EGauge Systems, LLC"
		}
	case 398:
		{ /* '398' */
			return "Quantum Automation (ASIA) PTE, Ltd."
		}
	case 399:
		{ /* '399' */
			return "Toshiba Lighting & Technology Corp."
		}
	case 4:
		{ /* '4' */
			return "PolarSoft"
		}
	case 40:
		{ /* '40' */
			return "Anacon Systems, Inc."
		}
	case 400:
		{ /* '400' */
			return "SPIN Engenharia de Automação Ltda."
		}
	case 401:
		{ /* '401' */
			return "Logistics Systems & Software Services India PVT. Ltd."
		}
	case 402:
		{ /* '402' */
			return "Delta Controls Integration Products"
		}
	case 403:
		{ /* '403' */
			return "Focus Media"
		}
	case 404:
		{ /* '404' */
			return "LUMEnergi Inc."
		}
	case 405:
		{ /* '405' */
			return "Kara Systems"
		}
	case 406:
		{ /* '406' */
			return "RF Code, Inc."
		}
	case 407:
		{ /* '407' */
			return "Fatek Automation Corp."
		}
	case 408:
		{ /* '408' */
			return "JANDA Software Company, LLC"
		}
	case 409:
		{ /* '409' */
			return "Open System Solutions Limited"
		}
	case 41:
		{ /* '41' */
			return "Systems Controls & Instruments, LLC"
		}
	case 410:
		{ /* '410' */
			return "Intelec Systems PTY Ltd."
		}
	case 411:
		{ /* '411' */
			return "Ecolodgix, LLC"
		}
	case 412:
		{ /* '412' */
			return "Douglas Lighting Controls"
		}
	case 413:
		{ /* '413' */
			return "iSAtech GmbH"
		}
	case 414:
		{ /* '414' */
			return "AREAL"
		}
	case 415:
		{ /* '415' */
			return "Beckhoff Automation"
		}
	case 416:
		{ /* '416' */
			return "IPAS GmbH"
		}
	case 417:
		{ /* '417' */
			return "KE2 Therm Solutions"
		}
	case 418:
		{ /* '418' */
			return "Base2Products"
		}
	case 419:
		{ /* '419' */
			return "DTL Controls, LLC"
		}
	case 42:
		{ /* '42' */
			return "Acuity Brands Lighting, Inc."
		}
	case 420:
		{ /* '420' */
			return "INNCOM International, Inc."
		}
	case 421:
		{ /* '421' */
			return "METZ CONNECT GmbH"
		}
	case 422:
		{ /* '422' */
			return "Greentrol Automation, Inc"
		}
	case 423:
		{ /* '423' */
			return "BELIMO Automation AG"
		}
	case 424:
		{ /* '424' */
			return "Samsung Heavy Industries Co, Ltd"
		}
	case 425:
		{ /* '425' */
			return "Triacta Power Technologies, Inc."
		}
	case 426:
		{ /* '426' */
			return "Globestar Systems"
		}
	case 427:
		{ /* '427' */
			return "MLB Advanced Media, LP"
		}
	case 428:
		{ /* '428' */
			return "SWG Stuckmann Wirtschaftliche Gebäudesysteme GmbH"
		}
	case 429:
		{ /* '429' */
			return "SensorSwitch"
		}
	case 43:
		{ /* '43' */
			return "Micropower Manufacturing"
		}
	case 430:
		{ /* '430' */
			return "Multitek Power Limited"
		}
	case 431:
		{ /* '431' */
			return "Integra Metering AG"
		}
	case 432:
		{ /* '432' */
			return "LG Electronics Inc."
		}
	case 433:
		{ /* '433' */
			return "Electronic Theatre Controls, Inc."
		}
	case 434:
		{ /* '434' */
			return "Mitsubishi Electric Corporation Nagoya Works"
		}
	case 435:
		{ /* '435' */
			return "Delta Electronics, Inc."
		}
	case 436:
		{ /* '436' */
			return "Elma Kurtalj, Ltd."
		}
	case 437:
		{ /* '437' */
			return "Tyco Fire & Security GmbH"
		}
	case 438:
		{ /* '438' */
			return "Nedap Security Management"
		}
	case 439:
		{ /* '439' */
			return "ESC Automation Inc."
		}
	case 44:
		{ /* '44' */
			return "Matrix Controls"
		}
	case 440:
		{ /* '440' */
			return "DSP4YOU Ltd."
		}
	case 441:
		{ /* '441' */
			return "GE Sensing and Inspection Technologies"
		}
	case 442:
		{ /* '442' */
			return "Embedded Systems SIA"
		}
	case 443:
		{ /* '443' */
			return "BEFEGA GmbH"
		}
	case 444:
		{ /* '444' */
			return "Baseline Inc."
		}
	case 445:
		{ /* '445' */
			return "Key2Act"
		}
	case 446:
		{ /* '446' */
			return "OEMCtrl"
		}
	case 447:
		{ /* '447' */
			return "Clarkson Controls Limited"
		}
	case 448:
		{ /* '448' */
			return "Rogerwell Control System Limited"
		}
	case 449:
		{ /* '449' */
			return "SCL Elements"
		}
	case 45:
		{ /* '45' */
			return "METALAIRE"
		}
	case 450:
		{ /* '450' */
			return "Hitachi Ltd."
		}
	case 451:
		{ /* '451' */
			return "Newron System SA"
		}
	case 452:
		{ /* '452' */
			return "BEVECO Gebouwautomatisering BV"
		}
	case 453:
		{ /* '453' */
			return "Streamside Solutions"
		}
	case 454:
		{ /* '454' */
			return "Yellowstone Soft"
		}
	case 455:
		{ /* '455' */
			return "Oztech Intelligent Systems Pty Ltd."
		}
	case 456:
		{ /* '456' */
			return "Novelan GmbH"
		}
	case 457:
		{ /* '457' */
			return "Flexim Americas Corporation"
		}
	case 458:
		{ /* '458' */
			return "ICP DAS Co., Ltd."
		}
	case 459:
		{ /* '459' */
			return "CARMA Industries Inc."
		}
	case 46:
		{ /* '46' */
			return "ESS Engineering"
		}
	case 460:
		{ /* '460' */
			return "Log-One Ltd."
		}
	case 461:
		{ /* '461' */
			return "TECO Electric & Machinery Co., Ltd."
		}
	case 462:
		{ /* '462' */
			return "ConnectEx, Inc."
		}
	case 463:
		{ /* '463' */
			return "Turbo DDC Südwest"
		}
	case 464:
		{ /* '464' */
			return "Quatrosense Environmental Ltd."
		}
	case 465:
		{ /* '465' */
			return "Fifth Light Technology Ltd."
		}
	case 466:
		{ /* '466' */
			return "Scientific Solutions, Ltd."
		}
	case 467:
		{ /* '467' */
			return "Controller Area Network Solutions (M) Sdn Bhd"
		}
	case 468:
		{ /* '468' */
			return "RESOL – Elektronische Regelungen GmbH"
		}
	case 469:
		{ /* '469' */
			return "RPBUS LLC"
		}
	case 47:
		{ /* '47' */
			return "Sphere Systems Pty Ltd."
		}
	case 470:
		{ /* '470' */
			return "BRS Sistemas Eletronicos"
		}
	case 471:
		{ /* '471' */
			return "WindowMaster A/S"
		}
	case 472:
		{ /* '472' */
			return "Sunlux Technologies Ltd."
		}
	case 473:
		{ /* '473' */
			return "Measurlogic"
		}
	case 474:
		{ /* '474' */
			return "Frimat GmbH"
		}
	case 475:
		{ /* '475' */
			return "Spirax Sarco"
		}
	case 476:
		{ /* '476' */
			return "Luxtron"
		}
	case 477:
		{ /* '477' */
			return "Raypak Inc"
		}
	case 478:
		{ /* '478' */
			return "Air Monitor Corporation"
		}
	case 479:
		{ /* '479' */
			return "Regler Och Webbteknik Sverige (ROWS)"
		}
	case 48:
		{ /* '48' */
			return "Walker Technologies Corporation"
		}
	case 480:
		{ /* '480' */
			return "Intelligent Lighting Controls Inc."
		}
	case 481:
		{ /* '481' */
			return "Sanyo Electric Industry Co., Ltd"
		}
	case 482:
		{ /* '482' */
			return "E-Mon Energy Monitoring Products"
		}
	case 483:
		{ /* '483' */
			return "Digital Control Systems"
		}
	case 484:
		{ /* '484' */
			return "ATI Airtest Technologies, Inc."
		}
	case 485:
		{ /* '485' */
			return "SCS SA"
		}
	case 486:
		{ /* '486' */
			return "HMS Industrial Networks AB"
		}
	case 487:
		{ /* '487' */
			return "Shenzhen Universal Intellisys Co Ltd"
		}
	case 488:
		{ /* '488' */
			return "EK Intellisys Sdn Bhd"
		}
	case 489:
		{ /* '489' */
			return "SysCom"
		}
	case 49:
		{ /* '49' */
			return "H I Solutions, Inc."
		}
	case 490:
		{ /* '490' */
			return "Firecom, Inc."
		}
	case 491:
		{ /* '491' */
			return "ESA Elektroschaltanlagen Grimma GmbH"
		}
	case 492:
		{ /* '492' */
			return "Kumahira Co Ltd"
		}
	case 493:
		{ /* '493' */
			return "Hotraco"
		}
	case 494:
		{ /* '494' */
			return "SABO Elektronik GmbH"
		}
	case 495:
		{ /* '495' */
			return "Equip’Trans"
		}
	case 496:
		{ /* '496' */
			return "Temperature Control Specialities Co., Inc (TCS)"
		}
	case 497:
		{ /* '497' */
			return "FlowCon International A/S"
		}
	case 498:
		{ /* '498' */
			return "ThyssenKrupp Elevator Americas"
		}
	case 499:
		{ /* '499' */
			return "Abatement Technologies"
		}
	case 5:
		{ /* '5' */
			return "Johnson Controls, Inc."
		}
	case 50:
		{ /* '50' */
			return "MBS GmbH"
		}
	case 500:
		{ /* '500' */
			return "Continental Control Systems, LLC"
		}
	case 501:
		{ /* '501' */
			return "WISAG Automatisierungstechnik GmbH & Co KG"
		}
	case 502:
		{ /* '502' */
			return "EasyIO"
		}
	case 503:
		{ /* '503' */
			return "EAP-Electric GmbH"
		}
	case 504:
		{ /* '504' */
			return "Hardmeier"
		}
	case 505:
		{ /* '505' */
			return "Mircom Group of Companies"
		}
	case 506:
		{ /* '506' */
			return "Quest Controls"
		}
	case 507:
		{ /* '507' */
			return "Mestek, Inc"
		}
	case 508:
		{ /* '508' */
			return "Pulse Energy"
		}
	case 509:
		{ /* '509' */
			return "Tachikawa Corporation"
		}
	case 51:
		{ /* '51' */
			return "SAMSON AG"
		}
	case 510:
		{ /* '510' */
			return "University of Nebraska-Lincoln"
		}
	case 511:
		{ /* '511' */
			return "Redwood Systems"
		}
	case 512:
		{ /* '512' */
			return "PASStec Industrie-Elektronik GmbH"
		}
	case 513:
		{ /* '513' */
			return "NgEK, Inc."
		}
	case 514:
		{ /* '514' */
			return "t-mac Technologies"
		}
	case 515:
		{ /* '515' */
			return "Jireh Energy Tech Co., Ltd."
		}
	case 516:
		{ /* '516' */
			return "Enlighted Inc."
		}
	case 517:
		{ /* '517' */
			return "El-Piast Sp. Z o.o"
		}
	case 518:
		{ /* '518' */
			return "NetxAutomation Software GmbH"
		}
	case 519:
		{ /* '519' */
			return "Invertek Drives"
		}
	case 52:
		{ /* '52' */
			return "Badger Meter Inc."
		}
	case 520:
		{ /* '520' */
			return "Deutschmann Automation GmbH & Co. KG"
		}
	case 521:
		{ /* '521' */
			return "EMU Electronic AG"
		}
	case 522:
		{ /* '522' */
			return "Phaedrus Limited"
		}
	case 523:
		{ /* '523' */
			return "Sigmatek GmbH & Co KG"
		}
	case 524:
		{ /* '524' */
			return "Marlin Controls"
		}
	case 525:
		{ /* '525' */
			return "Circutor, SA"
		}
	case 526:
		{ /* '526' */
			return "UTC Fire & Security"
		}
	case 527:
		{ /* '527' */
			return "DENT Instruments, Inc."
		}
	case 528:
		{ /* '528' */
			return "FHP Manufacturing Company – Bosch Group"
		}
	case 529:
		{ /* '529' */
			return "GE Intelligent Platforms"
		}
	case 53:
		{ /* '53' */
			return "DAIKIN Industries Ltd."
		}
	case 530:
		{ /* '530' */
			return "Inner Range Pty Ltd"
		}
	case 531:
		{ /* '531' */
			return "GLAS Energy Technology"
		}
	case 532:
		{ /* '532' */
			return "MSR-Electronic-GmbH"
		}
	case 533:
		{ /* '533' */
			return "Energy Control Systems, Inc."
		}
	case 534:
		{ /* '534' */
			return "EMT Controls"
		}
	case 535:
		{ /* '535' */
			return "Daintree"
		}
	case 536:
		{ /* '536' */
			return "EURO ICC d.o.o"
		}
	case 537:
		{ /* '537' */
			return "TE Connectivity Energy"
		}
	case 538:
		{ /* '538' */
			return "GEZE GmbH"
		}
	case 539:
		{ /* '539' */
			return "NEC Corporation"
		}
	case 54:
		{ /* '54' */
			return "NARA Controls Inc."
		}
	case 540:
		{ /* '540' */
			return "Ho Cheung International Company Limited"
		}
	case 541:
		{ /* '541' */
			return "Sharp Manufacturing Systems Corporation"
		}
	case 542:
		{ /* '542' */
			return "DOT CONTROLS a.s."
		}
	case 543:
		{ /* '543' */
			return "BeaconMedæs"
		}
	case 544:
		{ /* '544' */
			return "Midea Commercial Aircon"
		}
	case 545:
		{ /* '545' */
			return "AAON"
		}
	case 546:
		{ /* '546' */
			return "Kamstrup A/S"
		}
	case 547:
		{ /* '547' */
			return "CA Computer Automation GmbH"
		}
	case 548:
		{ /* '548' */
			return "Laars Heating Systems Company"
		}
	case 549:
		{ /* '549' */
			return "Hitachi Systems, Ltd."
		}
	case 55:
		{ /* '55' */
			return "Mammoth Inc."
		}
	case 550:
		{ /* '550' */
			return "Fushan AKE Electronic Engineering Co., Ltd."
		}
	case 551:
		{ /* '551' */
			return "Toshiba International Corporation"
		}
	case 552:
		{ /* '552' */
			return "Starman Systems, LLC"
		}
	case 553:
		{ /* '553' */
			return "Samsung Techwin Co., Ltd."
		}
	case 554:
		{ /* '554' */
			return "ISAS-Integrated Switchgear and Systems P/L"
		}
	case 556:
		{ /* '556' */
			return "Obvius"
		}
	case 557:
		{ /* '557' */
			return "Marek Guzik"
		}
	case 558:
		{ /* '558' */
			return "Vortek Instruments, LLC"
		}
	case 559:
		{ /* '559' */
			return "Universal Lighting Technologies"
		}
	case 56:
		{ /* '56' */
			return "Liebert Corporation"
		}
	case 560:
		{ /* '560' */
			return "Myers Power Products, Inc."
		}
	case 561:
		{ /* '561' */
			return "Vector Controls GmbH"
		}
	case 562:
		{ /* '562' */
			return "Crestron Electronics, Inc."
		}
	case 563:
		{ /* '563' */
			return "A&E Controls Limited"
		}
	case 564:
		{ /* '564' */
			return "Projektomontaza A.D."
		}
	case 565:
		{ /* '565' */
			return "Freeaire Refrigeration"
		}
	case 566:
		{ /* '566' */
			return "Aqua Cooler Pty Limited"
		}
	case 567:
		{ /* '567' */
			return "Basic Controls"
		}
	case 568:
		{ /* '568' */
			return "GE Measurement and Control Solutions Advanced Sensors"
		}
	case 569:
		{ /* '569' */
			return "EQUAL Networks"
		}
	case 57:
		{ /* '57' */
			return "SEMCO Incorporated"
		}
	case 570:
		{ /* '570' */
			return "Millennial Net"
		}
	case 571:
		{ /* '571' */
			return "APLI Ltd"
		}
	case 572:
		{ /* '572' */
			return "Electro Industries/GaugeTech"
		}
	case 573:
		{ /* '573' */
			return "SangMyung University"
		}
	case 574:
		{ /* '574' */
			return "Coppertree Analytics, Inc."
		}
	case 575:
		{ /* '575' */
			return "CoreNetiX GmbH"
		}
	case 576:
		{ /* '576' */
			return "Acutherm"
		}
	case 577:
		{ /* '577' */
			return "Dr. Riedel Automatisierungstechnik GmbH"
		}
	case 578:
		{ /* '578' */
			return "Shina System Co., Ltd"
		}
	case 579:
		{ /* '579' */
			return "Iqapertus"
		}
	case 58:
		{ /* '58' */
			return "Air Monitor Corporation"
		}
	case 580:
		{ /* '580' */
			return "PSE Technology"
		}
	case 581:
		{ /* '581' */
			return "BA Systems"
		}
	case 582:
		{ /* '582' */
			return "BTICINO"
		}
	case 583:
		{ /* '583' */
			return "Monico, Inc."
		}
	case 584:
		{ /* '584' */
			return "iCue"
		}
	case 585:
		{ /* '585' */
			return "tekmar Control Systems Ltd."
		}
	case 586:
		{ /* '586' */
			return "Control Technology Corporation"
		}
	case 587:
		{ /* '587' */
			return "GFAE GmbH"
		}
	case 588:
		{ /* '588' */
			return "BeKa Software GmbH"
		}
	case 589:
		{ /* '589' */
			return "Isoil Industria SpA"
		}
	case 59:
		{ /* '59' */
			return "TRIATEK, LLC"
		}
	case 590:
		{ /* '590' */
			return "Home Systems Consulting SpA"
		}
	case 591:
		{ /* '591' */
			return "Socomec"
		}
	case 592:
		{ /* '592' */
			return "Everex Communications, Inc."
		}
	case 593:
		{ /* '593' */
			return "CET Electric Technology, Inc."
		}
	case 594:
		{ /* '594' */
			return "Atrila GmbH"
		}
	case 595:
		{ /* '595' */
			return "WingTechs"
		}
	case 596:
		{ /* '596' */
			return "Shenzhen Mek Intellisys Pte Ltd."
		}
	case 597:
		{ /* '597' */
			return "Nestfield Co., Ltd."
		}
	case 598:
		{ /* '598' */
			return "Swissphone Telecom AG"
		}
	case 599:
		{ /* '599' */
			return "PNTECH JSC"
		}
	case 6:
		{ /* '6' */
			return "ABB (Formerly American Auto-Matrix)"
		}
	case 60:
		{ /* '60' */
			return "NexLight"
		}
	case 600:
		{ /* '600' */
			return "Horner APG, LLC"
		}
	case 601:
		{ /* '601' */
			return "PVI Industries, LLC"
		}
	case 602:
		{ /* '602' */
			return "Ela-compil"
		}
	case 603:
		{ /* '603' */
			return "Pegasus Automation International LLC"
		}
	case 604:
		{ /* '604' */
			return "Wight Electronic Services Ltd."
		}
	case 605:
		{ /* '605' */
			return "Marcom"
		}
	case 606:
		{ /* '606' */
			return "Exhausto A/S"
		}
	case 607:
		{ /* '607' */
			return "Dwyer Instruments, Inc."
		}
	case 608:
		{ /* '608' */
			return "Link GmbH"
		}
	case 609:
		{ /* '609' */
			return "Oppermann Regelgerate GmbH"
		}
	case 61:
		{ /* '61' */
			return "Multistack"
		}
	case 610:
		{ /* '610' */
			return "NuAire, Inc."
		}
	case 611:
		{ /* '611' */
			return "Nortec Humidity, Inc."
		}
	case 612:
		{ /* '612' */
			return "Bigwood Systems, Inc."
		}
	case 613:
		{ /* '613' */
			return "Enbala Power Networks"
		}
	case 614:
		{ /* '614' */
			return "Inter Energy Co., Ltd."
		}
	case 615:
		{ /* '615' */
			return "ETC"
		}
	case 616:
		{ /* '616' */
			return "COMELEC S.A.R.L"
		}
	case 617:
		{ /* '617' */
			return "Pythia Technologies"
		}
	case 618:
		{ /* '618' */
			return "TrendPoint Systems, Inc."
		}
	case 619:
		{ /* '619' */
			return "AWEX"
		}
	case 62:
		{ /* '62' */
			return "TSI Incorporated"
		}
	case 620:
		{ /* '620' */
			return "Eurevia"
		}
	case 621:
		{ /* '621' */
			return "Kongsberg E-lon AS"
		}
	case 622:
		{ /* '622' */
			return "FlaktWoods"
		}
	case 623:
		{ /* '623' */
			return "E + E Elektronik GES M.B.H."
		}
	case 624:
		{ /* '624' */
			return "ARC Informatique"
		}
	case 625:
		{ /* '625' */
			return "SKIDATA AG"
		}
	case 626:
		{ /* '626' */
			return "WSW Solutions"
		}
	case 627:
		{ /* '627' */
			return "Trefon Electronic GmbH"
		}
	case 628:
		{ /* '628' */
			return "Dongseo System"
		}
	case 629:
		{ /* '629' */
			return "Kanontec Intelligence Technology Co., Ltd."
		}
	case 63:
		{ /* '63' */
			return "Weather-Rite, Inc."
		}
	case 630:
		{ /* '630' */
			return "EVCO S.p.A."
		}
	case 631:
		{ /* '631' */
			return "Accuenergy (Canada) Inc."
		}
	case 632:
		{ /* '632' */
			return "SoftDEL"
		}
	case 633:
		{ /* '633' */
			return "Orion Energy Systems, Inc."
		}
	case 634:
		{ /* '634' */
			return "Roboticsware"
		}
	case 635:
		{ /* '635' */
			return "DOMIQ Sp. z o.o."
		}
	case 636:
		{ /* '636' */
			return "Solidyne"
		}
	case 637:
		{ /* '637' */
			return "Elecsys Corporation"
		}
	case 638:
		{ /* '638' */
			return "Conditionaire International Pty. Limited"
		}
	case 639:
		{ /* '639' */
			return "Quebec, Inc."
		}
	case 64:
		{ /* '64' */
			return "Dunham-Bush"
		}
	case 640:
		{ /* '640' */
			return "Homerun Holdings"
		}
	case 641:
		{ /* '641' */
			return "Murata Americas"
		}
	case 642:
		{ /* '642' */
			return "Comptek"
		}
	case 643:
		{ /* '643' */
			return "Westco Systems, Inc."
		}
	case 644:
		{ /* '644' */
			return "Advancis Software & Services GmbH"
		}
	case 645:
		{ /* '645' */
			return "Intergrid, LLC"
		}
	case 646:
		{ /* '646' */
			return "Markerr Controls, Inc."
		}
	case 647:
		{ /* '647' */
			return "Toshiba Elevator and Building Systems Corporation"
		}
	case 648:
		{ /* '648' */
			return "Spectrum Controls, Inc."
		}
	case 649:
		{ /* '649' */
			return "Mkservice"
		}
	case 65:
		{ /* '65' */
			return "Reliance Electric"
		}
	case 650:
		{ /* '650' */
			return "Fox Thermal Instruments"
		}
	case 651:
		{ /* '651' */
			return "SyxthSense Ltd"
		}
	case 652:
		{ /* '652' */
			return "DUHA System S R.O."
		}
	case 653:
		{ /* '653' */
			return "NIBE"
		}
	case 654:
		{ /* '654' */
			return "Melink Corporation"
		}
	case 655:
		{ /* '655' */
			return "Fritz-Haber-Institut"
		}
	case 656:
		{ /* '656' */
			return "MTU Onsite Energy GmbH, Gas Power Systems"
		}
	case 657:
		{ /* '657' */
			return "Omega Engineering, Inc."
		}
	case 658:
		{ /* '658' */
			return "Avelon"
		}
	case 659:
		{ /* '659' */
			return "Ywire Technologies, Inc."
		}
	case 66:
		{ /* '66' */
			return "LCS Inc."
		}
	case 660:
		{ /* '660' */
			return "M.R. Engineering Co., Ltd."
		}
	case 661:
		{ /* '661' */
			return "Lochinvar, LLC"
		}
	case 662:
		{ /* '662' */
			return "Sontay Limited"
		}
	case 663:
		{ /* '663' */
			return "GRUPA Slawomir Chelminski"
		}
	case 664:
		{ /* '664' */
			return "Arch Meter Corporation"
		}
	case 665:
		{ /* '665' */
			return "Senva, Inc."
		}
	case 667:
		{ /* '667' */
			return "FM-Tec"
		}
	case 668:
		{ /* '668' */
			return "Systems Specialists, Inc."
		}
	case 669:
		{ /* '669' */
			return "SenseAir"
		}
	case 67:
		{ /* '67' */
			return "Regulator Australia PTY Ltd."
		}
	case 670:
		{ /* '670' */
			return "AB IndustrieTechnik Srl"
		}
	case 671:
		{ /* '671' */
			return "Cortland Research, LLC"
		}
	case 672:
		{ /* '672' */
			return "MediaView"
		}
	case 673:
		{ /* '673' */
			return "VDA Elettronica"
		}
	case 674:
		{ /* '674' */
			return "CSS, Inc."
		}
	case 675:
		{ /* '675' */
			return "Tek-Air Systems, Inc."
		}
	case 676:
		{ /* '676' */
			return "ICDT"
		}
	case 677:
		{ /* '677' */
			return "The Armstrong Monitoring Corporation"
		}
	case 678:
		{ /* '678' */
			return "DIXELL S.r.l"
		}
	case 679:
		{ /* '679' */
			return "Lead System, Inc."
		}
	case 68:
		{ /* '68' */
			return "Touch-Plate Lighting Controls"
		}
	case 680:
		{ /* '680' */
			return "ISM EuroCenter S.A."
		}
	case 681:
		{ /* '681' */
			return "TDIS"
		}
	case 682:
		{ /* '682' */
			return "Trade FIDES"
		}
	case 683:
		{ /* '683' */
			return "Knürr GmbH (Emerson Network Power)"
		}
	case 684:
		{ /* '684' */
			return "Resource Data Management"
		}
	case 685:
		{ /* '685' */
			return "Abies Technology, Inc."
		}
	case 686:
		{ /* '686' */
			return "UAB Komfovent"
		}
	case 687:
		{ /* '687' */
			return "MIRAE Electrical Mfg. Co., Ltd."
		}
	case 688:
		{ /* '688' */
			return "HunterDouglas Architectural Projects Scandinavia ApS"
		}
	case 689:
		{ /* '689' */
			return "RUNPAQ Group Co., Ltd"
		}
	case 69:
		{ /* '69' */
			return "Amann GmbH"
		}
	case 690:
		{ /* '690' */
			return "Unicard SA"
		}
	case 691:
		{ /* '691' */
			return "IE Technologies"
		}
	case 692:
		{ /* '692' */
			return "Ruskin Manufacturing"
		}
	case 693:
		{ /* '693' */
			return "Calon Associates Limited"
		}
	case 694:
		{ /* '694' */
			return "Contec Co., Ltd."
		}
	case 695:
		{ /* '695' */
			return "iT GmbH"
		}
	case 696:
		{ /* '696' */
			return "Autani Corporation"
		}
	case 697:
		{ /* '697' */
			return "Christian Fortin"
		}
	case 698:
		{ /* '698' */
			return "HDL"
		}
	case 699:
		{ /* '699' */
			return "IPID Sp. Z.O.O Limited"
		}
	case 7:
		{ /* '7' */
			return "Siemens Schweiz AG"
		}
	case 70:
		{ /* '70' */
			return "RLE Technologies"
		}
	case 700:
		{ /* '700' */
			return "Fuji Electric Co., Ltd"
		}
	case 701:
		{ /* '701' */
			return "View, Inc."
		}
	case 702:
		{ /* '702' */
			return "Samsung S1 Corporation"
		}
	case 703:
		{ /* '703' */
			return "New Lift"
		}
	case 704:
		{ /* '704' */
			return "VRT Systems"
		}
	case 705:
		{ /* '705' */
			return "Motion Control Engineering, Inc."
		}
	case 706:
		{ /* '706' */
			return "Weiss Klimatechnik GmbH"
		}
	case 707:
		{ /* '707' */
			return "Elkon"
		}
	case 708:
		{ /* '708' */
			return "Eliwell Controls S.r.l."
		}
	case 709:
		{ /* '709' */
			return "Japan Computer Technos Corp"
		}
	case 71:
		{ /* '71' */
			return "Cardkey Systems"
		}
	case 710:
		{ /* '710' */
			return "Rational Network ehf"
		}
	case 711:
		{ /* '711' */
			return "Magnum Energy Solutions, LLC"
		}
	case 712:
		{ /* '712' */
			return "MelRok"
		}
	case 713:
		{ /* '713' */
			return "VAE Group"
		}
	case 714:
		{ /* '714' */
			return "LGCNS"
		}
	case 715:
		{ /* '715' */
			return "Berghof Automationstechnik GmbH"
		}
	case 716:
		{ /* '716' */
			return "Quark Communications, Inc."
		}
	case 717:
		{ /* '717' */
			return "Sontex"
		}
	case 718:
		{ /* '718' */
			return "mivune AG"
		}
	case 719:
		{ /* '719' */
			return "Panduit"
		}
	case 72:
		{ /* '72' */
			return "SECOM Co., Ltd."
		}
	case 720:
		{ /* '720' */
			return "Smart Controls, LLC"
		}
	case 721:
		{ /* '721' */
			return "Compu-Aire, Inc."
		}
	case 722:
		{ /* '722' */
			return "Sierra"
		}
	case 723:
		{ /* '723' */
			return "ProtoSense Technologies"
		}
	case 724:
		{ /* '724' */
			return "Eltrac Technologies Pvt Ltd"
		}
	case 725:
		{ /* '725' */
			return "Bektas Invisible Controls GmbH"
		}
	case 726:
		{ /* '726' */
			return "Entelec"
		}
	case 727:
		{ /* '727' */
			return "INNEXIV"
		}
	case 728:
		{ /* '728' */
			return "Covenant"
		}
	case 729:
		{ /* '729' */
			return "Davitor AB"
		}
	case 73:
		{ /* '73' */
			return "ABB Gebäudetechnik AG Bereich NetServ"
		}
	case 730:
		{ /* '730' */
			return "TongFang Technovator"
		}
	case 731:
		{ /* '731' */
			return "Building Robotics, Inc."
		}
	case 732:
		{ /* '732' */
			return "HSS-MSR UG"
		}
	case 733:
		{ /* '733' */
			return "FramTack LLC"
		}
	case 734:
		{ /* '734' */
			return "B. L. Acoustics, Ltd."
		}
	case 735:
		{ /* '735' */
			return "Traxxon Rock Drills, Ltd"
		}
	case 736:
		{ /* '736' */
			return "Franke"
		}
	case 737:
		{ /* '737' */
			return "Wurm GmbH & Co"
		}
	case 738:
		{ /* '738' */
			return "AddENERGIE"
		}
	case 739:
		{ /* '739' */
			return "Mirle Automation Corporation"
		}
	case 74:
		{ /* '74' */
			return "KNX Association cvba"
		}
	case 740:
		{ /* '740' */
			return "Ibis Networks"
		}
	case 741:
		{ /* '741' */
			return "ID-KARTA s.r.o."
		}
	case 742:
		{ /* '742' */
			return "Anaren, Inc."
		}
	case 743:
		{ /* '743' */
			return "Span, Incorporated"
		}
	case 744:
		{ /* '744' */
			return "Bosch Thermotechnology Corp"
		}
	case 745:
		{ /* '745' */
			return "DRC Technology S.A."
		}
	case 746:
		{ /* '746' */
			return "Shanghai Energy Building Technology Co, Ltd"
		}
	case 747:
		{ /* '747' */
			return "Fraport AG"
		}
	case 748:
		{ /* '748' */
			return "Flowgroup"
		}
	case 749:
		{ /* '749' */
			return "Skytron Energy, GmbH"
		}
	case 75:
		{ /* '75' */
			return "Institute of Electrical Installation Engineers of Japan (IEIEJ)"
		}
	case 750:
		{ /* '750' */
			return "ALTEL Wicha, Golda Sp. J."
		}
	case 751:
		{ /* '751' */
			return "Drupal"
		}
	case 752:
		{ /* '752' */
			return "Axiomatic Technology, Ltd"
		}
	case 753:
		{ /* '753' */
			return "Bohnke + Partner"
		}
	case 754:
		{ /* '754' */
			return "Function1"
		}
	case 755:
		{ /* '755' */
			return "Optergy Pty, Ltd"
		}
	case 756:
		{ /* '756' */
			return "LSI Virticus"
		}
	case 757:
		{ /* '757' */
			return "Konzeptpark GmbH"
		}
	case 758:
		{ /* '758' */
			return "NX Lighting Controls"
		}
	case 759:
		{ /* '759' */
			return "eCurv, Inc."
		}
	case 76:
		{ /* '76' */
			return "Nohmi Bosai, Ltd."
		}
	case 760:
		{ /* '760' */
			return "Agnosys GmbH"
		}
	case 761:
		{ /* '761' */
			return "Shanghai Sunfull Automation Co., LTD"
		}
	case 762:
		{ /* '762' */
			return "Kurz Instruments, Inc."
		}
	case 763:
		{ /* '763' */
			return "Cias Elettronica S.r.l."
		}
	case 764:
		{ /* '764' */
			return "Multiaqua, Inc."
		}
	case 765:
		{ /* '765' */
			return "BlueBox"
		}
	case 766:
		{ /* '766' */
			return "Sensidyne"
		}
	case 767:
		{ /* '767' */
			return "Viessmann Elektronik GmbH"
		}
	case 768:
		{ /* '768' */
			return "ADFweb.com srl"
		}
	case 769:
		{ /* '769' */
			return "Gaylord Industries"
		}
	case 77:
		{ /* '77' */
			return "Carel Industries S.p.A."
		}
	case 770:
		{ /* '770' */
			return "Majur Ltd."
		}
	case 771:
		{ /* '771' */
			return "Shanghai Huilin Technology Co., Ltd."
		}
	case 772:
		{ /* '772' */
			return "Exotronic"
		}
	case 773:
		{ /* '773' */
			return "SAFECONTROL s.r.o."
		}
	case 774:
		{ /* '774' */
			return "Amatis"
		}
	case 775:
		{ /* '775' */
			return "Universal Electric Corporation"
		}
	case 776:
		{ /* '776' */
			return "iBACnet"
		}
	case 778:
		{ /* '778' */
			return "Smartrise Engineering, Inc."
		}
	case 779:
		{ /* '779' */
			return "Miratron, Inc."
		}
	case 78:
		{ /* '78' */
			return "UTC Fire & Security España, S.L."
		}
	case 780:
		{ /* '780' */
			return "SmartEdge"
		}
	case 781:
		{ /* '781' */
			return "Mitsubishi Electric Australia Pty Ltd"
		}
	case 782:
		{ /* '782' */
			return "Triangle Research International Ptd Ltd"
		}
	case 783:
		{ /* '783' */
			return "Produal Oy"
		}
	case 784:
		{ /* '784' */
			return "Milestone Systems A/S"
		}
	case 785:
		{ /* '785' */
			return "Trustbridge"
		}
	case 786:
		{ /* '786' */
			return "Feedback Solutions"
		}
	case 787:
		{ /* '787' */
			return "IES"
		}
	case 788:
		{ /* '788' */
			return "ABB Power Protection SA"
		}
	case 789:
		{ /* '789' */
			return "Riptide IO"
		}
	case 79:
		{ /* '79' */
			return "Hochiki Corporation"
		}
	case 790:
		{ /* '790' */
			return "Messerschmitt Systems AG"
		}
	case 791:
		{ /* '791' */
			return "Dezem Energy Controlling"
		}
	case 792:
		{ /* '792' */
			return "MechoSystems"
		}
	case 793:
		{ /* '793' */
			return "evon GmbH"
		}
	case 794:
		{ /* '794' */
			return "CS Lab GmbH"
		}
	case 795:
		{ /* '795' */
			return "8760 Enterprises, Inc."
		}
	case 796:
		{ /* '796' */
			return "Touche Controls"
		}
	case 797:
		{ /* '797' */
			return "Ontrol Teknik Malzeme San. ve Tic. A.S."
		}
	case 798:
		{ /* '798' */
			return "Uni Control System Sp. Z o.o."
		}
	case 799:
		{ /* '799' */
			return "Weihai Ploumeter Co., Ltd"
		}
	case 8:
		{ /* '8' */
			return "Delta Controls"
		}
	case 80:
		{ /* '80' */
			return "Fr. Sauter AG"
		}
	case 800:
		{ /* '800' */
			return "Elcom International Pvt. Ltd"
		}
	case 801:
		{ /* '801' */
			return "Signify"
		}
	case 802:
		{ /* '802' */
			return "AutomationDirect"
		}
	case 803:
		{ /* '803' */
			return "Paragon Robotics"
		}
	case 804:
		{ /* '804' */
			return "SMT System & Modules Technology AG"
		}
	case 805:
		{ /* '805' */
			return "Radix IoT LLC"
		}
	case 806:
		{ /* '806' */
			return "CMR Controls Ltd"
		}
	case 807:
		{ /* '807' */
			return "Innovari, Inc."
		}
	case 808:
		{ /* '808' */
			return "ABB Control Products"
		}
	case 809:
		{ /* '809' */
			return "Gesellschaft fur Gebäudeautomation mbH"
		}
	case 81:
		{ /* '81' */
			return "Matsushita Electric Works, Ltd."
		}
	case 810:
		{ /* '810' */
			return "RODI Systems Corp."
		}
	case 811:
		{ /* '811' */
			return "Nextek Power Systems"
		}
	case 812:
		{ /* '812' */
			return "Creative Lighting"
		}
	case 813:
		{ /* '813' */
			return "WaterFurnace International"
		}
	case 814:
		{ /* '814' */
			return "Mercury Security"
		}
	case 815:
		{ /* '815' */
			return "Hisense (Shandong) Air-Conditioning Co., Ltd."
		}
	case 816:
		{ /* '816' */
			return "Layered Solutions, Inc."
		}
	case 817:
		{ /* '817' */
			return "Leegood Automatic System, Inc."
		}
	case 818:
		{ /* '818' */
			return "Shanghai Restar Technology Co., Ltd."
		}
	case 819:
		{ /* '819' */
			return "Reimann Ingenieurbüro"
		}
	case 82:
		{ /* '82' */
			return "Mitsubishi Electric Corporation, Inazawa Works"
		}
	case 820:
		{ /* '820' */
			return "LynTec"
		}
	case 821:
		{ /* '821' */
			return "HTP"
		}
	case 822:
		{ /* '822' */
			return "Elkor Technologies, Inc."
		}
	case 823:
		{ /* '823' */
			return "Bentrol Pty Ltd"
		}
	case 824:
		{ /* '824' */
			return "Team-Control Oy"
		}
	case 825:
		{ /* '825' */
			return "NextDevice, LLC"
		}
	case 826:
		{ /* '826' */
			return "iSMA CONTROLLI S.p.a."
		}
	case 827:
		{ /* '827' */
			return "King I Electronics Co., Ltd"
		}
	case 828:
		{ /* '828' */
			return "SAMDAV"
		}
	case 829:
		{ /* '829' */
			return "Next Gen Industries Pvt. Ltd."
		}
	case 83:
		{ /* '83' */
			return "Mitsubishi Heavy Industries, Ltd."
		}
	case 830:
		{ /* '830' */
			return "Entic LLC"
		}
	case 831:
		{ /* '831' */
			return "ETAP"
		}
	case 832:
		{ /* '832' */
			return "Moralle Electronics Limited"
		}
	case 833:
		{ /* '833' */
			return "Leicom AG"
		}
	case 834:
		{ /* '834' */
			return "Watts Regulator Company"
		}
	case 835:
		{ /* '835' */
			return "S.C. Orbtronics S.R.L."
		}
	case 836:
		{ /* '836' */
			return "Gaussan Technologies"
		}
	case 837:
		{ /* '837' */
			return "WEBfactory GmbH"
		}
	case 838:
		{ /* '838' */
			return "Ocean Controls"
		}
	case 839:
		{ /* '839' */
			return "Messana Air-Ray Conditioning s.r.l."
		}
	case 84:
		{ /* '84' */
			return "Xylem, Inc."
		}
	case 840:
		{ /* '840' */
			return "Hangzhou BATOWN Technology Co. Ltd."
		}
	case 841:
		{ /* '841' */
			return "Reasonable Controls"
		}
	case 842:
		{ /* '842' */
			return "Servisys, Inc."
		}
	case 843:
		{ /* '843' */
			return "halstrup-walcher GmbH"
		}
	case 844:
		{ /* '844' */
			return "SWG Automation Fuzhou Limited"
		}
	case 845:
		{ /* '845' */
			return "KSB Aktiengesellschaft"
		}
	case 846:
		{ /* '846' */
			return "Hybryd Sp. z o.o."
		}
	case 847:
		{ /* '847' */
			return "Helvatron AG"
		}
	case 848:
		{ /* '848' */
			return "Oderon Sp. Z.O.O."
		}
	case 849:
		{ /* '849' */
			return "mikolab"
		}
	case 85:
		{ /* '85' */
			return "Yamatake Building Systems Co., Ltd."
		}
	case 850:
		{ /* '850' */
			return "Exodraft"
		}
	case 851:
		{ /* '851' */
			return "Hochhuth GmbH"
		}
	case 852:
		{ /* '852' */
			return "Integrated System Technologies Ltd."
		}
	case 853:
		{ /* '853' */
			return "Shanghai Cellcons Controls Co., Ltd"
		}
	case 854:
		{ /* '854' */
			return "Emme Controls, LLC"
		}
	case 855:
		{ /* '855' */
			return "Field Diagnostic Services, Inc."
		}
	case 856:
		{ /* '856' */
			return "Ges Teknik A.S."
		}
	case 857:
		{ /* '857' */
			return "Global Power Products, Inc."
		}
	case 858:
		{ /* '858' */
			return "Option NV"
		}
	case 859:
		{ /* '859' */
			return "BV-Control AG"
		}
	case 86:
		{ /* '86' */
			return "The Watt Stopper, Inc."
		}
	case 860:
		{ /* '860' */
			return "Sigren Engineering AG"
		}
	case 861:
		{ /* '861' */
			return "Shanghai Jaltone Technology Co., Ltd."
		}
	case 862:
		{ /* '862' */
			return "MaxLine Solutions Ltd"
		}
	case 863:
		{ /* '863' */
			return "Kron Instrumentos Elétricos Ltda"
		}
	case 864:
		{ /* '864' */
			return "Thermo Matrix"
		}
	case 865:
		{ /* '865' */
			return "Infinite Automation Systems, Inc."
		}
	case 866:
		{ /* '866' */
			return "Vantage"
		}
	case 867:
		{ /* '867' */
			return "Elecon Measurements Pvt Ltd"
		}
	case 868:
		{ /* '868' */
			return "TBA"
		}
	case 869:
		{ /* '869' */
			return "Carnes Company"
		}
	case 87:
		{ /* '87' */
			return "Aichi Tokei Denki Co., Ltd."
		}
	case 870:
		{ /* '870' */
			return "Harman Professional"
		}
	case 871:
		{ /* '871' */
			return "Nenutec Asia Pacific Pte Ltd"
		}
	case 872:
		{ /* '872' */
			return "Gia NV"
		}
	case 873:
		{ /* '873' */
			return "Kepware Tehnologies"
		}
	case 874:
		{ /* '874' */
			return "Temperature Electronics Ltd"
		}
	case 875:
		{ /* '875' */
			return "Packet Power"
		}
	case 876:
		{ /* '876' */
			return "Project Haystack Corporation"
		}
	case 877:
		{ /* '877' */
			return "DEOS Controls Americas Inc."
		}
	case 878:
		{ /* '878' */
			return "Senseware Inc"
		}
	case 879:
		{ /* '879' */
			return "MST Systemtechnik AG"
		}
	case 88:
		{ /* '88' */
			return "Activation Technologies, LLC"
		}
	case 880:
		{ /* '880' */
			return "Lonix Ltd"
		}
	case 881:
		{ /* '881' */
			return "Gossen Metrawatt GmbH"
		}
	case 882:
		{ /* '882' */
			return "Aviosys International Inc."
		}
	case 883:
		{ /* '883' */
			return "Efficient Building Automation Corp."
		}
	case 884:
		{ /* '884' */
			return "Accutron Instruments Inc."
		}
	case 885:
		{ /* '885' */
			return "Vermont Energy Control Systems LLC"
		}
	case 886:
		{ /* '886' */
			return "DCC Dynamics"
		}
	case 887:
		{ /* '887' */
			return "B.E.G. Brück Electronic GmbH"
		}
	case 889:
		{ /* '889' */
			return "NGBS Hungary Ltd."
		}
	case 89:
		{ /* '89' */
			return "Saia-Burgess Controls, Ltd."
		}
	case 890:
		{ /* '890' */
			return "ILLUM Technology, LLC"
		}
	case 891:
		{ /* '891' */
			return "Delta Controls Germany Limited"
		}
	case 892:
		{ /* '892' */
			return "S+T Service & Technique S.A."
		}
	case 893:
		{ /* '893' */
			return "SimpleSoft"
		}
	case 894:
		{ /* '894' */
			return "Altair Engineering"
		}
	case 895:
		{ /* '895' */
			return "EZEN Solution Inc."
		}
	case 896:
		{ /* '896' */
			return "Fujitec Co. Ltd."
		}
	case 897:
		{ /* '897' */
			return "Terralux"
		}
	case 898:
		{ /* '898' */
			return "Annicom"
		}
	case 899:
		{ /* '899' */
			return "Bihl+Wiedemann GmbH"
		}
	case 9:
		{ /* '9' */
			return "Siemens Schweiz AG"
		}
	case 90:
		{ /* '90' */
			return "Hitachi, Ltd."
		}
	case 900:
		{ /* '900' */
			return "Draper, Inc."
		}
	case 901:
		{ /* '901' */
			return "Schüco International KG"
		}
	case 902:
		{ /* '902' */
			return "Otis Elevator Company"
		}
	case 903:
		{ /* '903' */
			return "Fidelix Oy"
		}
	case 904:
		{ /* '904' */
			return "RAM GmbH Mess- und Regeltechnik"
		}
	case 905:
		{ /* '905' */
			return "WEMS"
		}
	case 906:
		{ /* '906' */
			return "Ravel Electronics Pvt Ltd"
		}
	case 907:
		{ /* '907' */
			return "OmniMagni"
		}
	case 908:
		{ /* '908' */
			return "Echelon"
		}
	case 909:
		{ /* '909' */
			return "Intellimeter Canada, Inc."
		}
	case 91:
		{ /* '91' */
			return "Novar Corp./Trend Control Systems Ltd."
		}
	case 910:
		{ /* '910' */
			return "Bithouse Oy"
		}
	case 912:
		{ /* '912' */
			return "BuildPulse"
		}
	case 913:
		{ /* '913' */
			return "Shenzhen 1000 Building Automation Co. Ltd"
		}
	case 914:
		{ /* '914' */
			return "AED Engineering GmbH"
		}
	case 915:
		{ /* '915' */
			return "Güntner GmbH & Co. KG"
		}
	case 916:
		{ /* '916' */
			return "KNXlogic"
		}
	case 917:
		{ /* '917' */
			return "CIM Environmental Group"
		}
	case 918:
		{ /* '918' */
			return "Flow Control"
		}
	case 919:
		{ /* '919' */
			return "Lumen Cache, Inc."
		}
	case 92:
		{ /* '92' */
			return "Mitsubishi Electric Lighting Corporation"
		}
	case 920:
		{ /* '920' */
			return "Ecosystem"
		}
	case 921:
		{ /* '921' */
			return "Potter Electric Signal Company, LLC"
		}
	case 922:
		{ /* '922' */
			return "Tyco Fire & Security S.p.A."
		}
	case 923:
		{ /* '923' */
			return "Watanabe Electric Industry Co., Ltd."
		}
	case 924:
		{ /* '924' */
			return "Causam Energy"
		}
	case 925:
		{ /* '925' */
			return "W-tec AG"
		}
	case 926:
		{ /* '926' */
			return "IMI Hydronic Engineering International SA"
		}
	case 927:
		{ /* '927' */
			return "ARIGO Software"
		}
	case 928:
		{ /* '928' */
			return "MSA Safety"
		}
	case 929:
		{ /* '929' */
			return "Smart Solucoes Ltda – MERCATO"
		}
	case 93:
		{ /* '93' */
			return "Argus Control Systems, Ltd."
		}
	case 930:
		{ /* '930' */
			return "PIATRA Engineering"
		}
	case 931:
		{ /* '931' */
			return "ODIN Automation Systems, LLC"
		}
	case 932:
		{ /* '932' */
			return "Belparts NV"
		}
	case 933:
		{ /* '933' */
			return "UAB, SALDA"
		}
	case 934:
		{ /* '934' */
			return "Alre-IT Regeltechnik GmbH"
		}
	case 935:
		{ /* '935' */
			return "Ingenieurbüro H. Lertes GmbH & Co. KG"
		}
	case 936:
		{ /* '936' */
			return "Breathing Buildings"
		}
	case 937:
		{ /* '937' */
			return "eWON SA"
		}
	case 938:
		{ /* '938' */
			return "Cav. Uff. Giacomo Cimberio S.p.A"
		}
	case 939:
		{ /* '939' */
			return "PKE Electronics AG"
		}
	case 94:
		{ /* '94' */
			return "Kyuki Corporation"
		}
	case 940:
		{ /* '940' */
			return "Allen"
		}
	case 941:
		{ /* '941' */
			return "Kastle Systems"
		}
	case 942:
		{ /* '942' */
			return "Logical Electro-Mechanical (EM) Systems, Inc."
		}
	case 943:
		{ /* '943' */
			return "ppKinetics Instruments, LLC"
		}
	case 944:
		{ /* '944' */
			return "Cathexis Technologies"
		}
	case 945:
		{ /* '945' */
			return "Sylop sp. Z o.o. sp.k"
		}
	case 946:
		{ /* '946' */
			return "Brauns Control GmbH"
		}
	case 947:
		{ /* '947' */
			return "OMRON SOCIAL SOLUTIONS CO., LTD."
		}
	case 948:
		{ /* '948' */
			return "Wildeboer Bauteile Gmbh"
		}
	case 949:
		{ /* '949' */
			return "Shanghai Biens Technologies Ltd"
		}
	case 95:
		{ /* '95' */
			return "Richards-Zeta Building Intelligence, Inc."
		}
	case 950:
		{ /* '950' */
			return "Beijing HZHY Technology Co., Ltd"
		}
	case 951:
		{ /* '951' */
			return "Building Clouds"
		}
	case 952:
		{ /* '952' */
			return "The University of Sheffield-Department of Electronic and Electrical Engineering"
		}
	case 953:
		{ /* '953' */
			return "Fabtronics Australia Pty Ltd"
		}
	case 954:
		{ /* '954' */
			return "SLAT"
		}
	case 955:
		{ /* '955' */
			return "Software Motor Corporation"
		}
	case 956:
		{ /* '956' */
			return "Armstrong International Inc."
		}
	case 957:
		{ /* '957' */
			return "Steril-Aire, Inc."
		}
	case 958:
		{ /* '958' */
			return "Infinique"
		}
	case 959:
		{ /* '959' */
			return "Arcom"
		}
	case 96:
		{ /* '96' */
			return "Scientech R&D, Inc."
		}
	case 960:
		{ /* '960' */
			return "Argo Performance, Ltd"
		}
	case 961:
		{ /* '961' */
			return "Dialight"
		}
	case 962:
		{ /* '962' */
			return "Ideal Technical Solutions"
		}
	case 963:
		{ /* '963' */
			return "Neurobat AG"
		}
	case 964:
		{ /* '964' */
			return "Neyer Software Consulting LLC"
		}
	case 965:
		{ /* '965' */
			return "SCADA Technology Development Co., Ltd."
		}
	case 966:
		{ /* '966' */
			return "Demand Logic Limited"
		}
	case 967:
		{ /* '967' */
			return "GWA Group Limited"
		}
	case 968:
		{ /* '968' */
			return "Occitaline"
		}
	case 969:
		{ /* '969' */
			return "NAO Digital Co., Ltd."
		}
	case 97:
		{ /* '97' */
			return "VCI Controls, Inc."
		}
	case 970:
		{ /* '970' */
			return "Shenzhen Chanslink Network Technology Co., Ltd."
		}
	case 971:
		{ /* '971' */
			return "Samsung Electronics Co., Ltd."
		}
	case 972:
		{ /* '972' */
			return "Mesa Laboratories, Inc."
		}
	case 973:
		{ /* '973' */
			return "Fischer"
		}
	case 974:
		{ /* '974' */
			return "OpSys Solutions Ltd."
		}
	case 975:
		{ /* '975' */
			return "Advanced Devices Limited"
		}
	case 976:
		{ /* '976' */
			return "Condair"
		}
	case 977:
		{ /* '977' */
			return "INELCOM Ingenieria Electronica Comercial S.A."
		}
	case 978:
		{ /* '978' */
			return "GridPoint, Inc."
		}
	case 979:
		{ /* '979' */
			return "ADF Technologies Sdn Bhd"
		}
	case 98:
		{ /* '98' */
			return "Toshiba Corporation"
		}
	case 980:
		{ /* '980' */
			return "EPM, Inc."
		}
	case 981:
		{ /* '981' */
			return "Lighting Controls Ltd"
		}
	case 982:
		{ /* '982' */
			return "Perix Controls Ltd."
		}
	case 983:
		{ /* '983' */
			return "AERCO International, Inc."
		}
	case 984:
		{ /* '984' */
			return "KONE Inc."
		}
	case 985:
		{ /* '985' */
			return "Ziehl-Abegg SE"
		}
	case 986:
		{ /* '986' */
			return "Robot, S.A."
		}
	case 987:
		{ /* '987' */
			return "Optigo Networks, Inc."
		}
	case 988:
		{ /* '988' */
			return "Openmotics BVBA"
		}
	case 989:
		{ /* '989' */
			return "Metropolitan Industries, Inc."
		}
	case 99:
		{ /* '99' */
			return "Mitsubishi Electric Corporation Air Conditioning & Refrigeration Systems Works"
		}
	case 990:
		{ /* '990' */
			return "Huawei Technologies Co., Ltd."
		}
	case 991:
		{ /* '991' */
			return "Digital Lumens, Inc."
		}
	case 992:
		{ /* '992' */
			return "Vanti"
		}
	case 993:
		{ /* '993' */
			return "Cree Lighting"
		}
	case 994:
		{ /* '994' */
			return "Richmond Heights SDN BHD"
		}
	case 995:
		{ /* '995' */
			return "Payne-Sparkman Lighting Mangement"
		}
	case 996:
		{ /* '996' */
			return "Ashcroft"
		}
	case 997:
		{ /* '997' */
			return "Jet Controls Corp"
		}
	case 998:
		{ /* '998' */
			return "Zumtobel Lighting GmbH"
		}
	default:
		{
			return ""
		}
	}
}

func BACnetVendorIdFirstEnumForFieldVendorName(value string) (enum BACnetVendorId, ok bool) {
	for _, sizeValue := range BACnetVendorIdValues {
		if sizeValue.VendorName() == value {
			return sizeValue, true
		}
	}
	return 0, false
}
func BACnetVendorIdByValue(value uint16) (enum BACnetVendorId, ok bool) {
	switch value {
	case 0:
		return BACnetVendorId_ASHRAE, true
	case 0xFFFF:
		return BACnetVendorId_UNKNOWN_VENDOR, true
	case 1:
		return BACnetVendorId_NIST, true
	case 10:
		return BACnetVendorId_SCHNEIDER_ELECTRIC, true
	case 100:
		return BACnetVendorId_CUSTOM_MECHANICAL_EQUIPMENTLLC, true
	case 1000:
		return BACnetVendorId_EKON_GMBH, true
	case 1001:
		return BACnetVendorId_MOLEX, true
	case 1002:
		return BACnetVendorId_MACO_LIGHTING_PTY_LTD, true
	case 1003:
		return BACnetVendorId_AXECON_CORP, true
	case 1004:
		return BACnetVendorId_TENSORPLC, true
	case 1005:
		return BACnetVendorId_KASEMAN_ENVIRONMENTAL_CONTROL_EQUIPMENT_SHANGHAI_LIMITED, true
	case 1006:
		return BACnetVendorId_AB_AXIS_INDUSTRIES, true
	case 1007:
		return BACnetVendorId_NETIX_CONTROLS, true
	case 1008:
		return BACnetVendorId_ELDRIDGE_PRODUCTS_INC, true
	case 1009:
		return BACnetVendorId_MICRONICS, true
	case 101:
		return BACnetVendorId_CLIMATE_MASTER, true
	case 1010:
		return BACnetVendorId_FORTECHO_SOLUTIONS_LTD, true
	case 1011:
		return BACnetVendorId_SELLERS_MANUFACTURING_COMPANY, true
	case 1012:
		return BACnetVendorId_RITE_HITE_DOORS_INC, true
	case 1013:
		return BACnetVendorId_VIOLET_DEFENSELLC, true
	case 1014:
		return BACnetVendorId_SIMNA, true
	case 1015:
		return BACnetVendorId_MULTINERGIE_BEST_INC, true
	case 1016:
		return BACnetVendorId_MEGA_SYSTEM_TECHNOLOGIES_INC, true
	case 1017:
		return BACnetVendorId_RHEEM, true
	case 1018:
		return BACnetVendorId_ING_PUNZENBERGERCOPADATA_GMBH, true
	case 1019:
		return BACnetVendorId_MEC_ELECTRONICS_GMBH, true
	case 102:
		return BACnetVendorId_ICP_PANEL_TEC_INC, true
	case 1020:
		return BACnetVendorId_TACO_COMFORT_SOLUTIONS, true
	case 1021:
		return BACnetVendorId_ALEXANDER_MAIER_GMBH, true
	case 1022:
		return BACnetVendorId_ECORITHM_INC, true
	case 1023:
		return BACnetVendorId_ACCURRO_LTD, true
	case 1024:
		return BACnetVendorId_ROMTECK_AUSTRALIA_PTY_LTD, true
	case 1025:
		return BACnetVendorId_SPLASH_MONITORING_LIMITED, true
	case 1026:
		return BACnetVendorId_LIGHT_APPLICATION, true
	case 1027:
		return BACnetVendorId_LOGICAL_BUILDING_AUTOMATION, true
	case 1028:
		return BACnetVendorId_EXILIGHT_OY, true
	case 1029:
		return BACnetVendorId_HAGER_ELECTROSAS, true
	case 103:
		return BACnetVendorId_D_TEK_CONTROLS, true
	case 1030:
		return BACnetVendorId_KLIF_COLTD, true
	case 1031:
		return BACnetVendorId_HYGRO_MATIK, true
	case 1032:
		return BACnetVendorId_DANIEL_MOUSSEAU_PROGRAMMATION_ELECTRONIQUE, true
	case 1033:
		return BACnetVendorId_AERIONICS_INC, true
	case 1034:
		return BACnetVendorId_MS_ELECTRONIQUE_LTEE, true
	case 1035:
		return BACnetVendorId_AUTOMATION_COMPONENTS_INC, true
	case 1036:
		return BACnetVendorId_NIOBRARA_RESEARCH_DEVELOPMENT_CORPORATION, true
	case 1037:
		return BACnetVendorId_NETCOM_SICHERHEITSTECHNIK_GMBH, true
	case 1038:
		return BACnetVendorId_LUMELSA, true
	case 1039:
		return BACnetVendorId_GREAT_PLAINS_INDUSTRIES_INC, true
	case 104:
		return BACnetVendorId_NEC_ENGINEERING_LTD, true
	case 1040:
		return BACnetVendorId_DOMOTICA_LABSSRL, true
	case 1041:
		return BACnetVendorId_ENERGY_CLOUD_INC, true
	case 1042:
		return BACnetVendorId_VOMATEC, true
	case 1043:
		return BACnetVendorId_DEMMA_COMPANIES, true
	case 1044:
		return BACnetVendorId_VALSENA, true
	case 1045:
		return BACnetVendorId_COMSYS_BRTSCHAG, true
	case 1046:
		return BACnetVendorId_B_GRID, true
	case 1047:
		return BACnetVendorId_MDJ_SOFTWARE_PTY_LTD, true
	case 1048:
		return BACnetVendorId_DIMONOFF_INC, true
	case 1049:
		return BACnetVendorId_EDOMO_SYSTEMS_GMBH, true
	case 105:
		return BACnetVendorId_PRIVABV, true
	case 1050:
		return BACnetVendorId_EFFEKTIVLLC, true
	case 1051:
		return BACnetVendorId_STEAMO_VAP, true
	case 1052:
		return BACnetVendorId_GRANDCENTRIX_GMBH, true
	case 1053:
		return BACnetVendorId_WEINTEK_LABS_INC, true
	case 1054:
		return BACnetVendorId_INTEFOX_GMBH, true
	case 1055:
		return BACnetVendorId_RADIUS_AUTOMATION_COMPANY, true
	case 1056:
		return BACnetVendorId_RINGDALE_INC, true
	case 1057:
		return BACnetVendorId_IWAKI_AMERICA, true
	case 1058:
		return BACnetVendorId_BRACTLET, true
	case 1059:
		return BACnetVendorId_STULZ_AIR_TECHNOLOGY_SYSTEMS_INC, true
	case 106:
		return BACnetVendorId_MEIDENSHA_CORPORATION, true
	case 1060:
		return BACnetVendorId_CLIMATE_READY_ENGINEERING_PTY_LTD, true
	case 1061:
		return BACnetVendorId_GENEA_ENERGY_PARTNERS, true
	case 1062:
		return BACnetVendorId_IO_TALL_CHILE, true
	case 1063:
		return BACnetVendorId_IKS_CO_LTD, true
	case 1064:
		return BACnetVendorId_YODIWOAB, true
	case 1065:
		return BACnetVendorId_TITA_NELECTRONIC_GMBH, true
	case 1066:
		return BACnetVendorId_IDEC_CORPORATION, true
	case 1067:
		return BACnetVendorId_SIFRISL, true
	case 1068:
		return BACnetVendorId_THERMAL_GAS_SYSTEMS_INC, true
	case 1069:
		return BACnetVendorId_BUILDING_AUTOMATION_PRODUCTS_INC, true
	case 107:
		return BACnetVendorId_JCI_SYSTEMS_INTEGRATION_SERVICES, true
	case 1070:
		return BACnetVendorId_ASSET_MAPPING, true
	case 1071:
		return BACnetVendorId_SMARTEH_COMPANY, true
	case 1072:
		return BACnetVendorId_DATAPOD_AUSTRALIA_PTY_LTD, true
	case 1073:
		return BACnetVendorId_BUILDINGS_ALIVE_PTY_LTD, true
	case 1074:
		return BACnetVendorId_DIGITAL_ELEKTRONIK, true
	case 1075:
		return BACnetVendorId_TALENT_AUTOMAOE_TECNOLOGIA_LTDA, true
	case 1076:
		return BACnetVendorId_NORPOSH_LIMITED, true
	case 1077:
		return BACnetVendorId_MERKUR_FUNKSYSTEMEAG, true
	case 1078:
		return BACnetVendorId_FASTERC_ZSPOL_SRO, true
	case 1079:
		return BACnetVendorId_ECO_ADAPT, true
	case 108:
		return BACnetVendorId_FREEDOM_CORPORATION, true
	case 1080:
		return BACnetVendorId_ENERGOCENTRUM_PLUSSRO, true
	case 1081:
		return BACnetVendorId_AMBXUK_LTD, true
	case 1082:
		return BACnetVendorId_WESTERN_RESERVE_CONTROLS_INC, true
	case 1083:
		return BACnetVendorId_LAYER_ZERO_POWER_SYSTEMS_INC, true
	case 1084:
		return BACnetVendorId_CIC_JAN_HEBECSRO, true
	case 1085:
		return BACnetVendorId_SIGROVBV, true
	case 1086:
		return BACnetVendorId_ISYS_INTELLIGENT_SYSTEMS, true
	case 1087:
		return BACnetVendorId_GAS_DETECTION_AUSTRALIA_PTY_LTD, true
	case 1088:
		return BACnetVendorId_KINCO_AUTOMATION_SHANGHAI_LTD, true
	case 1089:
		return BACnetVendorId_LARS_ENERGYLLC, true
	case 109:
		return BACnetVendorId_NEUBERGER_GEBUDEAUTOMATION_GMBH, true
	case 1090:
		return BACnetVendorId_FLAMEFASTUK_LTD, true
	case 1091:
		return BACnetVendorId_ROYAL_SERVICE_AIR_CONDITIONING, true
	case 1092:
		return BACnetVendorId_AMPIO_SP_ZOO, true
	case 1093:
		return BACnetVendorId_INOVONICS_WIRELESS_CORPORATION, true
	case 1094:
		return BACnetVendorId_NVENT_THERMAL_MANAGEMENT, true
	case 1095:
		return BACnetVendorId_SINOWELL_CONTROL_SYSTEM_LTD, true
	case 1096:
		return BACnetVendorId_MOXA_INC, true
	case 1097:
		return BACnetVendorId_MATRIXI_CONTROLSDNBHD, true
	case 1098:
		return BACnetVendorId_PURPLE_SWIFT, true
	case 1099:
		return BACnetVendorId_OTIM_TECHNOLOGIES, true
	case 11:
		return BACnetVendorId_TAC, true
	case 110:
		return BACnetVendorId_E_ZI_CONTROLS, true
	case 1100:
		return BACnetVendorId_FLOW_MATE_LIMITED, true
	case 1101:
		return BACnetVendorId_DEGREE_CONTROLS_INC, true
	case 1102:
		return BACnetVendorId_FEI_XING_SHANGHAI_SOFTWARE_TECHNOLOGIES_CO_LTD, true
	case 1103:
		return BACnetVendorId_BERG_GMBH, true
	case 1104:
		return BACnetVendorId_ARENZIT, true
	case 1105:
		return BACnetVendorId_EDELSTROM_ELECTRONIC_DEVICES_DESIGNINGLLC, true
	case 1106:
		return BACnetVendorId_DRIVE_CONNECTLLC, true
	case 1107:
		return BACnetVendorId_DEVELOP_NOW, true
	case 1108:
		return BACnetVendorId_POORT, true
	case 1109:
		return BACnetVendorId_VMEIL_INFORMATION_SHANGHAI_LTD, true
	case 111:
		return BACnetVendorId_LEVITON_MANUFACTURING, true
	case 1110:
		return BACnetVendorId_RAYLEIGH_INSTRUMENTS, true
	case 1112:
		return BACnetVendorId_CODESYS_DEVELOPMENT, true
	case 1113:
		return BACnetVendorId_SMARTWARE_TECHNOLOGIES_GROUPLLC, true
	case 1114:
		return BACnetVendorId_POLAR_BEAR_SOLUTIONS, true
	case 1115:
		return BACnetVendorId_CODRA, true
	case 1116:
		return BACnetVendorId_PHAROS_ARCHITECTURAL_CONTROLS_LTD, true
	case 1117:
		return BACnetVendorId_ENGI_NEAR_LTD, true
	case 1118:
		return BACnetVendorId_AD_HOC_ELECTRONICS, true
	case 1119:
		return BACnetVendorId_UNIFIED_MICROSYSTEMS, true
	case 112:
		return BACnetVendorId_FUJITSU_LIMITED, true
	case 1120:
		return BACnetVendorId_INDUSTRIEELEKTRONIK_BRANDENBURG_GMBH, true
	case 1121:
		return BACnetVendorId_HARTMANN_GMBH, true
	case 1122:
		return BACnetVendorId_PISCADA, true
	case 1123:
		return BACnetVendorId_KM_BSYSTEMSSRO, true
	case 1124:
		return BACnetVendorId_POWER_TECH_ENGINEERINGAS, true
	case 1125:
		return BACnetVendorId_TELEFONBAU_ARTHUR_SCHWABE_GMBH_COKG, true
	case 1126:
		return BACnetVendorId_WUXI_FISTWELOVE_TECHNOLOGY_CO_LTD, true
	case 1127:
		return BACnetVendorId_PRYSM, true
	case 1128:
		return BACnetVendorId_STEINEL_GMBH, true
	case 1129:
		return BACnetVendorId_GEORG_FISCHERJRGAG, true
	case 113:
		return BACnetVendorId_VERTIV_FORMERLY_EMERSON_NETWORK_POWER, true
	case 1130:
		return BACnetVendorId_MAKE_DEVELOPSL, true
	case 1131:
		return BACnetVendorId_MONNIT_CORPORATION, true
	case 1132:
		return BACnetVendorId_MIRROR_LIFE_CORPORATION, true
	case 1133:
		return BACnetVendorId_SECURE_METERS_LIMITED, true
	case 1134:
		return BACnetVendorId_PECO, true
	case 1135:
		return BACnetVendorId_CCTECH_INC, true
	case 1136:
		return BACnetVendorId_LIGHT_FI_LIMITED, true
	case 1137:
		return BACnetVendorId_NICE_SPA, true
	case 1138:
		return BACnetVendorId_FIBER_SEN_SYS_INC, true
	case 1139:
		return BACnetVendorId_BD_BUCHTAUND_DEGEORGI, true
	case 114:
		return BACnetVendorId_SA_ARMSTRONG_LTD, true
	case 1140:
		return BACnetVendorId_VENTACITY_SYSTEMS_INC, true
	case 1141:
		return BACnetVendorId_HITACHI_JOHNSON_CONTROLS_AIR_CONDITIONING_INC, true
	case 1142:
		return BACnetVendorId_SAGE_METERING_INC, true
	case 1143:
		return BACnetVendorId_ANDEL_LIMITED, true
	case 1144:
		return BACnetVendorId_ECO_SMART_TECHNOLOGIES, true
	case 1145:
		return BACnetVendorId_SET, true
	case 1146:
		return BACnetVendorId_PROTEC_FIRE_DETECTION_SPAINSL, true
	case 1147:
		return BACnetVendorId_AGRAMERUG, true
	case 1148:
		return BACnetVendorId_ANYLINK_ELECTRONIC_GMBH, true
	case 1149:
		return BACnetVendorId_SCHINDLER_LTD, true
	case 115:
		return BACnetVendorId_VISONETAG, true
	case 1150:
		return BACnetVendorId_JIBREEL_ABDEEN_EST, true
	case 1151:
		return BACnetVendorId_FLUIDYNE_CONTROL_SYSTEMS_PVT_LTD, true
	case 1152:
		return BACnetVendorId_PRISM_SYSTEMS_INC, true
	case 1153:
		return BACnetVendorId_ENERTIV, true
	case 1154:
		return BACnetVendorId_MIRASOFT_GMBH_COKG, true
	case 1155:
		return BACnetVendorId_DUALTECHIT, true
	case 1156:
		return BACnetVendorId_COUNTLOGICLLC, true
	case 1157:
		return BACnetVendorId_KOHLER, true
	case 1158:
		return BACnetVendorId_CHEN_SEN_CONTROLS_CO_LTD, true
	case 1159:
		return BACnetVendorId_GREENHECK, true
	case 116:
		return BACnetVendorId_MM_SYSTEMS_INC, true
	case 1160:
		return BACnetVendorId_INTWINE_CONNECTLLC, true
	case 1161:
		return BACnetVendorId_KARLBORGS_ELKONTROLL, true
	case 1162:
		return BACnetVendorId_DATAKOM, true
	case 1163:
		return BACnetVendorId_HOGA_CONTROLAS, true
	case 1164:
		return BACnetVendorId_COOL_AUTOMATION, true
	case 1165:
		return BACnetVendorId_INTER_SEARCH_CO_LTD, true
	case 1166:
		return BACnetVendorId_DABBEL_AUTOMATION_INTELLIGENCE_GMBH, true
	case 1167:
		return BACnetVendorId_GADGEON_ENGINEERING_SMARTNESS, true
	case 1168:
		return BACnetVendorId_COSTER_GROUP_SRL, true
	case 1169:
		return BACnetVendorId_WALTER_MLLERAG, true
	case 117:
		return BACnetVendorId_CUSTOM_SOFTWARE_ENGINEERING, true
	case 1170:
		return BACnetVendorId_FLUKE, true
	case 1171:
		return BACnetVendorId_QUINTEX_SYSTEMS_LTD, true
	case 1172:
		return BACnetVendorId_SENFFICIENTSDNBHD, true
	case 1173:
		return BACnetVendorId_NUBEIO_OPERATIONS_PTY_LTD, true
	case 1174:
		return BACnetVendorId_DAS_INTEGRATOR_PTE_LTD, true
	case 1175:
		return BACnetVendorId_CREVIS_CO_LTD, true
	case 1176:
		return BACnetVendorId_I_SQUAREDSOFTWAREINC, true
	case 1177:
		return BACnetVendorId_KTG_GMBH, true
	case 1178:
		return BACnetVendorId_POK_GROUP_OY, true
	case 1179:
		return BACnetVendorId_ADISCOM, true
	case 118:
		return BACnetVendorId_NITTAN_COMPANY_LIMITED, true
	case 1180:
		return BACnetVendorId_INCUSENSE, true
	case 1181:
		return BACnetVendorId_F, true
	case 1182:
		return BACnetVendorId_ANORD_MARDIX_INC, true
	case 1183:
		return BACnetVendorId_HOSCH_GEBUDEAUTOMATION_NEUE_PRODUKTE_GMBH, true
	case 1184:
		return BACnetVendorId_BOSCHIO_GMBH, true
	case 1185:
		return BACnetVendorId_ROYAL_BOON_EDAM_INTERNATIONALBV, true
	case 1186:
		return BACnetVendorId_CLACK_CORPORATION, true
	case 1187:
		return BACnetVendorId_UNITEX_CONTROLSLLC, true
	case 1188:
		return BACnetVendorId_KTC_GTEBORGAB, true
	case 1189:
		return BACnetVendorId_INTERZONAB, true
	case 119:
		return BACnetVendorId_ELUTIONS_INC_WIZCON_SYSTEMSSAS, true
	case 1190:
		return BACnetVendorId_ISDEINGSL, true
	case 1191:
		return BACnetVendorId_AB_MAUTOMATIONBUILDINGMESSAGING_GMBH, true
	case 1192:
		return BACnetVendorId_KENTEC_ELECTRONICS_LTD, true
	case 1193:
		return BACnetVendorId_COPELANDLP, true
	case 1194:
		return BACnetVendorId_POWERSIDE, true
	case 1195:
		return BACnetVendorId_SMC_GROUP, true
	case 1196:
		return BACnetVendorId_EOS_WEATHER_INSTRUMENTS, true
	case 1197:
		return BACnetVendorId_ZONEX_SYSTEMS, true
	case 1198:
		return BACnetVendorId_GENEREX_SYSTEMS_COMPUTERVERTRIEBSGESELLSCHAFTMBH, true
	case 1199:
		return BACnetVendorId_ENERGY_WALLLLC, true
	case 12:
		return BACnetVendorId_ORION_ANALYSIS_CORPORATION, true
	case 120:
		return BACnetVendorId_PACOM_SYSTEMS_PTY_LTD, true
	case 1200:
		return BACnetVendorId_THERMOFIN, true
	case 1201:
		return BACnetVendorId_SDATAWAYSA, true
	case 1202:
		return BACnetVendorId_BIDDLE_AIR_SYSTEMS_LIMITED, true
	case 1203:
		return BACnetVendorId_KESSLER_ELLIS_PRODUCTS, true
	case 1204:
		return BACnetVendorId_THERMOSCREENS, true
	case 1205:
		return BACnetVendorId_MODIO, true
	case 1206:
		return BACnetVendorId_NEWRON_SOLUTIONS, true
	case 1207:
		return BACnetVendorId_UNITRONICS, true
	case 1208:
		return BACnetVendorId_TRILUX_GMBH_COKG, true
	case 1209:
		return BACnetVendorId_KOLLMORGEN_STEUERUNGSTECHNIK_GMBH, true
	case 121:
		return BACnetVendorId_UNICO_INC, true
	case 1210:
		return BACnetVendorId_BOSCH_REXROTHAG, true
	case 1211:
		return BACnetVendorId_ALARKO_CARRIER, true
	case 1212:
		return BACnetVendorId_VERDIGRIS_TECHNOLOGIES, true
	case 1213:
		return BACnetVendorId_SHANGHAISIIC_LONGCHUANG_SMARTECH_SO_LTD, true
	case 1214:
		return BACnetVendorId_QUINDA_CO, true
	case 1215:
		return BACnetVendorId_GRUNERAG, true
	case 1216:
		return BACnetVendorId_BACMOVE, true
	case 1217:
		return BACnetVendorId_PSIDACAB, true
	case 1218:
		return BACnetVendorId_ISICON_CONTROL_AUTOMATION, true
	case 1219:
		return BACnetVendorId_BIG_ASS_FANS, true
	case 122:
		return BACnetVendorId_EBTRON_INC, true
	case 1220:
		return BACnetVendorId_DIN_DIETMAR_NOCKER_FACILITY_MANAGEMENT_GMBH, true
	case 1221:
		return BACnetVendorId_TELDIO, true
	case 1222:
		return BACnetVendorId_MIKROKLIM_ASRO, true
	case 1223:
		return BACnetVendorId_DENSITY, true
	case 1224:
		return BACnetVendorId_ICONAG_LEITTECHNIK_GMBH, true
	case 1225:
		return BACnetVendorId_AWAIR, true
	case 1226:
		return BACnetVendorId_TD_ENGINEERING_LTD, true
	case 1227:
		return BACnetVendorId_SISTEMAS_DIGITALES, true
	case 1228:
		return BACnetVendorId_LOXONE_ELECTRONICS_GMBH, true
	case 1229:
		return BACnetVendorId_ACTRON_AIR, true
	case 123:
		return BACnetVendorId_SCADA_ENGINE, true
	case 1230:
		return BACnetVendorId_INDUCTIVE_AUTOMATION, true
	case 1231:
		return BACnetVendorId_THOR_ENGINEERING_GMBH, true
	case 1232:
		return BACnetVendorId_BERNER_INTERNATIONALLLC, true
	case 1233:
		return BACnetVendorId_POTSDAM_SENSORSLLC, true
	case 1234:
		return BACnetVendorId_KOHLER_MIRA_LTD, true
	case 1235:
		return BACnetVendorId_TECOMON_GMBH, true
	case 1236:
		return BACnetVendorId_TWO_DIMENSIONAL_INSTRUMENTSLLC, true
	case 1237:
		return BACnetVendorId_LEFA_TECHNOLOGIES_PTE_LTD, true
	case 1238:
		return BACnetVendorId_EATONCEAG_NOTLICHTSYSTEME_GMBH, true
	case 1239:
		return BACnetVendorId_COMMBOX_TECNOLOGIA, true
	case 124:
		return BACnetVendorId_LENZE_AMERICAS_FORMERLYAC_TECHNOLOGY_CORPORATION, true
	case 1240:
		return BACnetVendorId_IP_VIDEO_CORPORATION, true
	case 1241:
		return BACnetVendorId_BENDER_GMBH_COKG, true
	case 1242:
		return BACnetVendorId_RHYMEBUS_CORPORATION, true
	case 1243:
		return BACnetVendorId_AXON_SYSTEMS_LTD, true
	case 1244:
		return BACnetVendorId_ENGINEERED_AIR, true
	case 1245:
		return BACnetVendorId_ELIPSE_SOFTWARE_LTDA, true
	case 1246:
		return BACnetVendorId_SIMATIX_BUILDING_TECHNOLOGIES_PVT_LTD, true
	case 1247:
		return BACnetVendorId_WA_BENJAMIN_ELECTRIC_CO, true
	case 1248:
		return BACnetVendorId_TROX_AIR_CONDITIONING_COMPONENTS_SUZHOU_CO_LTD, true
	case 1249:
		return BACnetVendorId_SC_MEDICAL_PTY_LTD, true
	case 125:
		return BACnetVendorId_EAGLE_TECHNOLOGY, true
	case 1250:
		return BACnetVendorId_ELCANICAS, true
	case 1251:
		return BACnetVendorId_OBEOAS, true
	case 1252:
		return BACnetVendorId_TAPA_INC, true
	case 1253:
		return BACnetVendorId_ASE_SMART_ENERGY_INC, true
	case 1254:
		return BACnetVendorId_PERFORMANCE_SERVICES_INC, true
	case 1255:
		return BACnetVendorId_VERIDIFY_SECURITY, true
	case 1256:
		return BACnetVendorId_CD_INNOVATIONLTD, true
	case 1257:
		return BACnetVendorId_BEN_PEOPLES_INDUSTRIESLLC, true
	case 1258:
		return BACnetVendorId_UNICOMM_SPZOO, true
	case 1259:
		return BACnetVendorId_THING_TECHNOLOGIES_GMBH, true
	case 126:
		return BACnetVendorId_DATA_AIRE_INC, true
	case 1260:
		return BACnetVendorId_BEIJING_HAILIN_CONTROL_TECHNOLOGY_INC, true
	case 1261:
		return BACnetVendorId_DIGITAL_REALTY, true
	case 1262:
		return BACnetVendorId_AGROWTEK_INC, true
	case 1263:
		return BACnetVendorId_DSP_INNOVATIONBV, true
	case 1264:
		return BACnetVendorId_STV_ELECTRONIC_GMBH, true
	case 1265:
		return BACnetVendorId_ELMEASURE_INDIA_PVT_LTD, true
	case 1266:
		return BACnetVendorId_PINESHORE_ENERGYLLC, true
	case 1267:
		return BACnetVendorId_BRASCH_ENVIRONMENTAL_TECHNOLOGIESLLC, true
	case 1268:
		return BACnetVendorId_SHEN_ZHEN_ZHI_XING_BUILDING_TECH_CO_LTD, true
	case 1269:
		return BACnetVendorId_SINUX, true
	case 127:
		return BACnetVendorId_ABB_INC, true
	case 1270:
		return BACnetVendorId_AVNET_INC, true
	case 1271:
		return BACnetVendorId_SOMFY_ACTIVITESSA, true
	case 1272:
		return BACnetVendorId_AMICO, true
	case 1273:
		return BACnetVendorId_SAGE_GLASS, true
	case 1274:
		return BACnetVendorId_AU_VERTE, true
	case 1275:
		return BACnetVendorId_AGILE_CONNECTS_PVT_LTD, true
	case 1276:
		return BACnetVendorId_LOCIMATION_PTY_LTD, true
	case 1277:
		return BACnetVendorId_ENVIO_SYSTEMS_GMBH, true
	case 1278:
		return BACnetVendorId_VOYTECH_SYSTEMS_LIMITED, true
	case 1279:
		return BACnetVendorId_DAVIDSMEYERUND_PAUL_GMBH, true
	case 128:
		return BACnetVendorId_TRANSBIT_SPZOO, true
	case 1280:
		return BACnetVendorId_LUSHER_ENGINEERING_SERVICES, true
	case 1281:
		return BACnetVendorId_CHNT_NANJING_TECHSEL_INTELLIGENT_COMPANYLTD, true
	case 1282:
		return BACnetVendorId_THREETRONICS_PTY_LTD, true
	case 1283:
		return BACnetVendorId_SKY_FOUNDRYLLC, true
	case 1284:
		return BACnetVendorId_HANIL_PRO_TECH, true
	case 1285:
		return BACnetVendorId_SENSORSCALL, true
	case 1286:
		return BACnetVendorId_SHANGHAI_JINGPU_INFORMATION_TECHNOLOGY_CO_LTD, true
	case 1287:
		return BACnetVendorId_LICHTMANUFAKTUR_BERLIN_GMBH, true
	case 1288:
		return BACnetVendorId_ECO_PARKING_TECHNOLOGIES, true
	case 1289:
		return BACnetVendorId_ENVISION_DIGITAL_INTERNATIONAL_PTE_LTD, true
	case 129:
		return BACnetVendorId_CARRIER_JAPAN_CORPORATION, true
	case 1290:
		return BACnetVendorId_ANTONY_DEVELOPPEMENT_ELECTRONIQUE, true
	case 1291:
		return BACnetVendorId_ISYSTEMS, true
	case 1292:
		return BACnetVendorId_THUREON_INTERNATIONAL_LIMITED, true
	case 1293:
		return BACnetVendorId_PULSAFEEDER, true
	case 1294:
		return BACnetVendorId_MEGA_CHIPS_CORPORATION, true
	case 1295:
		return BACnetVendorId_TES_CONTROLS, true
	case 1296:
		return BACnetVendorId_CERMATE, true
	case 1297:
		return BACnetVendorId_GRAND_VALLEY_STATE_UNIVERSITY, true
	case 1298:
		return BACnetVendorId_SYMCON_GMBH, true
	case 1299:
		return BACnetVendorId_THE_CHICAGO_FAUCET_COMPANY, true
	case 13:
		return BACnetVendorId_TELETROL_SYSTEMS_INC, true
	case 130:
		return BACnetVendorId_SHENZHEN_JUNZHI_HI_TECH_CO_LTD, true
	case 1300:
		return BACnetVendorId_GEBERITAG, true
	case 1301:
		return BACnetVendorId_REX_CONTROLS, true
	case 1302:
		return BACnetVendorId_IVMS_GMBH, true
	case 1303:
		return BACnetVendorId_MNPP_SATURN_LTD, true
	case 1304:
		return BACnetVendorId_REGAL_BELOIT, true
	case 1305:
		return BACnetVendorId_ACS_AIR_CONDITIONING_SOLUTIONS, true
	case 1306:
		return BACnetVendorId_GBX_TECHNOLOGYLLC, true
	case 1307:
		return BACnetVendorId_KAITERRA, true
	case 1308:
		return BACnetVendorId_THIN_KUANLOT_TECHNOLOGY_SHANGHAI_CO_LTD, true
	case 1309:
		return BACnetVendorId_HO_CO_STOBV, true
	case 131:
		return BACnetVendorId_TOKAI_SOFT, true
	case 1310:
		return BACnetVendorId_SHENZHENASAI_TECHNOLOGY_CO_LTD, true
	case 1311:
		return BACnetVendorId_RPS_SPA, true
	case 1312:
		return BACnetVendorId_ESMSOLUTIONS, true
	case 1313:
		return BACnetVendorId_IO_TECH_SYSTEMS_LIMITED, true
	case 1314:
		return BACnetVendorId_I_AUTO_LOGIC_CO_LTD, true
	case 1315:
		return BACnetVendorId_NEW_AGE_MICROLLC, true
	case 1316:
		return BACnetVendorId_GUARDIAN_GLASS, true
	case 1317:
		return BACnetVendorId_GUANGZHOU_ZHAOYU_INFORMATION_TECHNOLOGY, true
	case 1318:
		return BACnetVendorId_ACE_IOT_SOLUTIONSLLC, true
	case 1319:
		return BACnetVendorId_PORIS_ELECTRONICS_CO_LTD, true
	case 132:
		return BACnetVendorId_BLUE_RIDGE_TECHNOLOGIES, true
	case 1320:
		return BACnetVendorId_TERMINUS_TECHNOLOGIES_GROUP, true
	case 1321:
		return BACnetVendorId_INTECH1_INC, true
	case 1322:
		return BACnetVendorId_ACCURATE_ELECTRONICS, true
	case 1323:
		return BACnetVendorId_FLUENCE_BIOENGINEERING, true
	case 1324:
		return BACnetVendorId_MUN_HEAN_SINGAPORE_PTE_LTD, true
	case 1325:
		return BACnetVendorId_KATRONICAG_COKG, true
	case 1326:
		return BACnetVendorId_SUZHOU_XIN_AO_INFORMATION_TECHNOLOGY_CO_LTD, true
	case 1327:
		return BACnetVendorId_LINKTEKK_TECHNOLOGYJSC, true
	case 1328:
		return BACnetVendorId_STIRLING_ULTRACOLD, true
	case 1329:
		return BACnetVendorId_UV_PARTNERS_INC, true
	case 133:
		return BACnetVendorId_VERIS_INDUSTRIES, true
	case 1330:
		return BACnetVendorId_PRO_MINENT_GMBH, true
	case 1331:
		return BACnetVendorId_MULTI_TECH_SYSTEMS_INC, true
	case 1332:
		return BACnetVendorId_JUMO_GMBH_COKG, true
	case 1333:
		return BACnetVendorId_QINGDAO_HUARUI_TECHNOLOGY_CO_LTD, true
	case 1334:
		return BACnetVendorId_CAIRN_SYSTEMES, true
	case 1335:
		return BACnetVendorId_NEURO_LOGIC_RESEARCH_CORP, true
	case 1336:
		return BACnetVendorId_TRANSITION_TECHNOLOGIES_ADVANCED_SOLUTIONS_SPZOO, true
	case 1337:
		return BACnetVendorId_XXTERBV, true
	case 1338:
		return BACnetVendorId_PASSIVE_LOGIC, true
	case 1339:
		return BACnetVendorId_EN_SMART_CONTROLS, true
	case 134:
		return BACnetVendorId_CENTAURUS_PRIME, true
	case 1340:
		return BACnetVendorId_WATTS_HEATINGAND_HOT_WATER_SOLUTIONSDBA_LYNC, true
	case 1341:
		return BACnetVendorId_TROPOSPHAIRA_TECHNOLOGIESLLP, true
	case 1342:
		return BACnetVendorId_NETWORK_THERMOSTAT, true
	case 1343:
		return BACnetVendorId_TITANIUM_INTELLIGENT_SOLUTIONSLLC, true
	case 1344:
		return BACnetVendorId_NUMA_PRODUCTSLLC, true
	case 1345:
		return BACnetVendorId_WAREMA_RENKHOFFSE, true
	case 1346:
		return BACnetVendorId_FRESEAS, true
	case 1347:
		return BACnetVendorId_MAPPED, true
	case 1348:
		return BACnetVendorId_ELEKTRODESIG_NVENTILATORYSRO, true
	case 1349:
		return BACnetVendorId_AIR_CARE_AUTOMATION_INC, true
	case 135:
		return BACnetVendorId_SAND_NETWORK_SYSTEMS, true
	case 1350:
		return BACnetVendorId_ANTRUM, true
	case 1351:
		return BACnetVendorId_BAO_LINH_CONNECT_TECHNOLOGY, true
	case 1352:
		return BACnetVendorId_VIRGINIA_CONTROLSLLC, true
	case 1353:
		return BACnetVendorId_DUOSYSSDNBHD, true
	case 1354:
		return BACnetVendorId_ONSENSAS, true
	case 1355:
		return BACnetVendorId_VAUGHN_THERMAL_CORPORATION, true
	case 1356:
		return BACnetVendorId_THERMOPLASTIC_ENGINEERING_LTDTPE, true
	case 1357:
		return BACnetVendorId_WIRTH_RESEARCH_LTD, true
	case 1358:
		return BACnetVendorId_SST_AUTOMATION, true
	case 1359:
		return BACnetVendorId_SHANGHAI_BENCOL_ELECTRONIC_TECHNOLOGY_CO_LTD, true
	case 136:
		return BACnetVendorId_REGULVAR_INC, true
	case 1360:
		return BACnetVendorId_AIWAA_SYSTEMS_PRIVATE_LIMITED, true
	case 1361:
		return BACnetVendorId_ENLESS_WIRELESS, true
	case 1362:
		return BACnetVendorId_OZUNO_ENGINEERING_PTY_LTD, true
	case 1363:
		return BACnetVendorId_HUBBELL_THE_ELECTRIC_HEATER_COMPANY, true
	case 1364:
		return BACnetVendorId_INDUSTRIAL_TURNAROUND_CORPORATIONITAC, true
	case 1365:
		return BACnetVendorId_WADSWORTH_CONTROL_SYSTEMS, true
	case 1366:
		return BACnetVendorId_SERVICES_HILO_INC, true
	case 1367:
		return BACnetVendorId_IDM_ENERGIESYSTEME_GMBH, true
	case 1368:
		return BACnetVendorId_BE_NEXTBV, true
	case 1369:
		return BACnetVendorId_CLEAN_AIRAI_CORPORATION, true
	case 137:
		return BACnetVendorId_AF_DTEK_DIVISIONOF_FASTEK_INTERNATIONAL_INC, true
	case 1370:
		return BACnetVendorId_REVOLUTION_MICROELECTRONICS_AMERICA_INC, true
	case 1371:
		return BACnetVendorId_REAL_TIME_SYSTEMS_GMBH, true
	case 1372:
		return BACnetVendorId_ZED_BEE_TECHNOLOGIES_PVT_LTD, true
	case 1373:
		return BACnetVendorId_WIMATE_TECHNOLOGY_SOLUTIONS_PVT_LTD, true
	case 1374:
		return BACnetVendorId_SENTICON_LTD, true
	case 1375:
		return BACnetVendorId_ROSSAKERAB, true
	case 1376:
		return BACnetVendorId_OPIT_SOLUTIONS_LTD, true
	case 1377:
		return BACnetVendorId_HOTOWELL_INTERNATIONAL_CO_LIMITED, true
	case 1378:
		return BACnetVendorId_INIM_ELECTRONICSSRL_UNIPERSONALE, true
	case 1379:
		return BACnetVendorId_AIRTHINGSASA, true
	case 138:
		return BACnetVendorId_POWER_COLD_COMFORT_AIR_SOLUTIONS_INC, true
	case 1380:
		return BACnetVendorId_ANALOG_DEVICES_INC, true
	case 1381:
		return BACnetVendorId_AI_DIRECTIONSDMCC, true
	case 1382:
		return BACnetVendorId_PRIMA_ELECTRO_SPA, true
	case 1383:
		return BACnetVendorId_KLT_CONTROL_SYSTEM_LTD, true
	case 1384:
		return BACnetVendorId_EVOLUTION_CONTROLS_INC, true
	case 1385:
		return BACnetVendorId_BEVER_INNOVATIONS, true
	case 1386:
		return BACnetVendorId_PELICAN_WIRELESS_SYSTEMS, true
	case 1387:
		return BACnetVendorId_CONTROL_CONCEPTS_INC, true
	case 1388:
		return BACnetVendorId_AUGMATIC_TECHNOLOGIES_PVT_LTD, true
	case 1389:
		return BACnetVendorId_XIAMEN_MILESIGHTLOT_CO_LTD, true
	case 139:
		return BACnetVendorId_I_CONTROLS, true
	case 1390:
		return BACnetVendorId_TIANJIN_ANJIELOT_SCHIENCEAND_TECHNOLOGY_CO_LTD, true
	case 1391:
		return BACnetVendorId_GUANGZHOUS_ENERGY_ELECTRONICS_TECHNOLOGY_CO_LTD, true
	case 1392:
		return BACnetVendorId_AKVO_ATMOSPHERIC_WATER_SYSTEMS_PVT_LTD, true
	case 1393:
		return BACnetVendorId_EM_FIRST_CO_LTD, true
	case 1394:
		return BACnetVendorId_IION_SYSTEMS_APS, true
	case 1396:
		return BACnetVendorId_SAF_TEHNIKAJSC, true
	case 1397:
		return BACnetVendorId_KOMFORTIQ_INC, true
	case 1398:
		return BACnetVendorId_COOL_TERA_LIMITED, true
	case 1399:
		return BACnetVendorId_HADRON_SOLUTIONS_SRLS, true
	case 14:
		return BACnetVendorId_CIMETRICS_TECHNOLOGY, true
	case 140:
		return BACnetVendorId_VICONICS_ELECTRONICS_INC, true
	case 1401:
		return BACnetVendorId_BITPOOL, true
	case 1402:
		return BACnetVendorId_SONICULLC, true
	case 1403:
		return BACnetVendorId_RISHABH_INSTRUMENTS_LIMITED, true
	case 1404:
		return BACnetVendorId_THING_WAREHOUSELLC, true
	case 1405:
		return BACnetVendorId_INNOFRIENDS_GMBH, true
	case 1406:
		return BACnetVendorId_METRONICAKP_SPJ, true
	case 1407:
		return BACnetVendorId_TECHKNAVE, true
	case 1408:
		return BACnetVendorId_ELSNER_ELEKTRONIK, true
	case 1409:
		return BACnetVendorId_LEFOO_INDUSTRIAL_HANGZHOU_CO_LTD, true
	case 141:
		return BACnetVendorId_YASKAWA_AMERICA_INC, true
	case 1410:
		return BACnetVendorId_CALIBRATION_TECHNOLOGIES_INC, true
	case 1411:
		return BACnetVendorId_ALLORADO, true
	case 1412:
		return BACnetVendorId_VERKADA, true
	case 1413:
		return BACnetVendorId_WATTSENSE, true
	case 1414:
		return BACnetVendorId_EMERSON_AUTOMATION_SOLUTIONS, true
	case 1415:
		return BACnetVendorId_GROWLINK, true
	case 1416:
		return BACnetVendorId_OLYMPIA_ELECTRONICS, true
	case 1417:
		return BACnetVendorId_NORMAL_SOFTWARE_INC, true
	case 1418:
		return BACnetVendorId_ST_ENGINEERING_SOLUTIONJSC, true
	case 1419:
		return BACnetVendorId_INDUSTRIAL_FLOW_SOLUTIONS, true
	case 142:
		return BACnetVendorId_DEO_SCONTROLSYSTEMS_GMBH, true
	case 1420:
		return BACnetVendorId_UBIQISENSE_APS, true
	case 1421:
		return BACnetVendorId_TIGER_SOFT, true
	case 1422:
		return BACnetVendorId_ECODOM_SRL, true
	case 1423:
		return BACnetVendorId_BILGIPRO_IOT_SYSTEMS, true
	case 1424:
		return BACnetVendorId_PLANSPURNETDESIGN_GMBH, true
	case 1425:
		return BACnetVendorId_DOLPHIN_SOLUTIONS_LTD, true
	case 1426:
		return BACnetVendorId_MITSUBISHI_ELECTRIC_CORPORATION_KOBE_WORKS, true
	case 1427:
		return BACnetVendorId_ECOVENA, true
	case 1428:
		return BACnetVendorId_GREE_ELECTRIC_APPLIANCES_INCOF_ZHUHAI, true
	case 1429:
		return BACnetVendorId_CONSPEC_CONTROLS, true
	case 143:
		return BACnetVendorId_DIGITALE_MESSUND_STEUERSYSTEMEAG, true
	case 1430:
		return BACnetVendorId_HANGZHOU_HIKVISION_DIGITAL_TECHNOLOGY_CO_LTD, true
	case 1431:
		return BACnetVendorId_CRYSTAL_PEAK_SECURITY, true
	case 1432:
		return BACnetVendorId_PERM_ALERT, true
	case 1433:
		return BACnetVendorId_ZHEJIANG_MISILIN_TECHNOLOGY_CO_LTD, true
	case 1434:
		return BACnetVendorId_DEKKER_VACUUM_TECHNOLOGIES, true
	case 1435:
		return BACnetVendorId_EDWARDS_LIMITED, true
	case 1436:
		return BACnetVendorId_LEYBOLD_GMBH, true
	case 1437:
		return BACnetVendorId_INTERNATIONAL_GAS_DETECTORS, true
	case 1438:
		return BACnetVendorId_ATLAS_COPCO_AIRPOWERNV, true
	case 1439:
		return BACnetVendorId_AIR_SENTRY_LIMITED, true
	case 144:
		return BACnetVendorId_FUJITSU_GENERAL_LIMITED, true
	case 1440:
		return BACnetVendorId_AELSYS, true
	case 1441:
		return BACnetVendorId_GRANBY_CONSULTINGLLC, true
	case 1442:
		return BACnetVendorId_CLEVER_RELAY, true
	case 1443:
		return BACnetVendorId_MONICO_MONITORING_INC, true
	case 1444:
		return BACnetVendorId_OQDO, true
	case 1445:
		return BACnetVendorId_MATRIX_COMSEC_PRIVATE_LIMITED, true
	case 1446:
		return BACnetVendorId_RESOURCE_SOLUTIONS, true
	case 1447:
		return BACnetVendorId_AMERICAN_GAS_SAFETYLLC, true
	case 1448:
		return BACnetVendorId_SS_NORTHERN_LTD, true
	case 1449:
		return BACnetVendorId_ULBIOS_TECHSENS, true
	case 145:
		return BACnetVendorId_PROJECT_ENGINEERING_SRL, true
	case 1450:
		return BACnetVendorId_BOWERY_FARMING_INC, true
	case 1451:
		return BACnetVendorId_RYOBI_LIMITED, true
	case 1452:
		return BACnetVendorId_EKKO_SENSE_LTD, true
	case 1453:
		return BACnetVendorId_CLIMA_COOL, true
	case 1454:
		return BACnetVendorId_GRID_CONNECT_INC, true
	case 1455:
		return BACnetVendorId_ZIEGLER_INSTRUMENTATIONUK_LTD, true
	case 1456:
		return BACnetVendorId_CONTROL_TECLLC, true
	case 1457:
		return BACnetVendorId_AETERLINK_CORPORATION, true
	case 1458:
		return BACnetVendorId_ALPHA_EPSILON_AUTOMATION, true
	case 1459:
		return BACnetVendorId_ASTRALITE_INC, true
	case 146:
		return BACnetVendorId_SANYO_ELECTRIC_CO_LTD, true
	case 1460:
		return BACnetVendorId_DELTA_FIRE_LTDA, true
	case 1461:
		return BACnetVendorId_BOCK_WATER_HEATERS_INC, true
	case 1462:
		return BACnetVendorId_CLEAVER_BROOKS, true
	case 1463:
		return BACnetVendorId_SCANALYTICS_INC, true
	case 1464:
		return BACnetVendorId_WILABS, true
	case 1465:
		return BACnetVendorId_ACT_SYSTEM_CO_LTD, true
	case 1466:
		return BACnetVendorId_VERGE_SENSE, true
	case 1467:
		return BACnetVendorId_SYSTEMAIR_MFG_INC, true
	case 1468:
		return BACnetVendorId_SEELEY_INTERNATIONAL, true
	case 1469:
		return BACnetVendorId_CRANE_BUILDING_SERVICES_UTILITIES, true
	case 147:
		return BACnetVendorId_INTEGRATED_INFORMATION_SYSTEMS_INC, true
	case 1470:
		return BACnetVendorId_BRADY_CORPORATION, true
	case 1471:
		return BACnetVendorId_QINGDAO_HISENSE_HITACHI_AIR_CONDITIONING_SYSTEMS_CO_LTD, true
	case 1472:
		return BACnetVendorId_GOLDEN_QUALITY_CO_LTD, true
	case 1473:
		return BACnetVendorId_ELVACOAB, true
	case 1474:
		return BACnetVendorId_STRONG_TECHNOLOGYLLC, true
	case 1475:
		return BACnetVendorId_REC_ENVIRONMENTAL_TECHNOLOGY_GUANGZHOU_COMPANY_LIMITED, true
	case 1476:
		return BACnetVendorId_DISRUPTIVE_TECHNOLOGIES_RESEARCHAS, true
	case 1477:
		return BACnetVendorId_NICO_CONSULTANCY_LIMITED, true
	case 1478:
		return BACnetVendorId_HORTENLOT_JIANGSU_CO_LTD, true
	case 1479:
		return BACnetVendorId_PAXTON_CONTROLS_CORP, true
	case 148:
		return BACnetVendorId_TEMCO_CONTROLS_LTD, true
	case 1480:
		return BACnetVendorId_FELL_TECHNOLOGYAS, true
	case 1481:
		return BACnetVendorId_SHLOK_INFORMATION_SYSTEMS_INDIA_PRIVATE_LIMITED, true
	case 1482:
		return BACnetVendorId_MICROGROPLC_LTD, true
	case 1483:
		return BACnetVendorId_CLOUDER_OY, true
	case 1484:
		return BACnetVendorId_GEBUDE_AUTOMATISIERUNG_GMBH, true
	case 1485:
		return BACnetVendorId_SOLVIMUS_GMBH, true
	case 1486:
		return BACnetVendorId_GUANG_ZHOU_WANGKONG_LTD, true
	case 1487:
		return BACnetVendorId_SAFE_SQUARE_GMBH, true
	case 1488:
		return BACnetVendorId_HEKLATECHAB, true
	case 1489:
		return BACnetVendorId_SILVAIR, true
	case 149:
		return BACnetVendorId_AIRTEK_INTERNATIONAL_INC, true
	case 1490:
		return BACnetVendorId_ADVECO, true
	case 1491:
		return BACnetVendorId_EURA_DRIVES_ELECTRIC_CO_LTD, true
	case 1492:
		return BACnetVendorId_CALEB_CONTROLS, true
	case 1493:
		return BACnetVendorId_IN_BIOT_MONITORINGSL, true
	case 1494:
		return BACnetVendorId_QINGDAO_HAIER_AIR_CONDITIONER_ELECTRIC_CO_LTD, true
	case 1495:
		return BACnetVendorId_HANGZHOU_WEIYL_TECHNOLOGY_CO_LTD, true
	case 1496:
		return BACnetVendorId_YORDSRL, true
	case 1497:
		return BACnetVendorId_INFINITUM_ELECTRIC, true
	case 1498:
		return BACnetVendorId_RED_BEAN_SYSTEMS_LIMITED, true
	case 1499:
		return BACnetVendorId_BLUE_TIME_CONCEPTSA, true
	case 15:
		return BACnetVendorId_CORNELL_UNIVERSITY, true
	case 150:
		return BACnetVendorId_ADVANTECH_CORPORATION, true
	case 1500:
		return BACnetVendorId_SHENZHENINVT_ELECTRIC_CO_LTD, true
	case 1501:
		return BACnetVendorId_MESSUNG_SYSTEMS_PVT_LTD, true
	case 1502:
		return BACnetVendorId_ABB_ELECTRIFICATION_CANADA_INC, true
	case 1503:
		return BACnetVendorId_CORE_CONTROLS, true
	case 1504:
		return BACnetVendorId_NOORD_TECHDOO, true
	case 1505:
		return BACnetVendorId_VARIBITSAS, true
	case 1506:
		return BACnetVendorId_ROGER_SPZOOSPK, true
	case 1507:
		return BACnetVendorId_VIEGA_GMBH_COKG, true
	case 1508:
		return BACnetVendorId_ASTERSOFT, true
	case 1509:
		return BACnetVendorId_BIGEU, true
	case 151:
		return BACnetVendorId_TITAN_PRODUCTS_LTD, true
	case 1510:
		return BACnetVendorId_INFERRIX_LIMITED, true
	case 1511:
		return BACnetVendorId_RICHARDS_ELECTRIC_MOTOR_CO, true
	case 1512:
		return BACnetVendorId_DAPP_CONTROLS, true
	case 1513:
		return BACnetVendorId_ENTOUCH_CONTROLS, true
	case 1514:
		return BACnetVendorId_MAVILI_ELEKTRONIK_TICARETVE_SANAYI_ANONIM_SIRKETI, true
	case 1515:
		return BACnetVendorId_BUBBLY_NET, true
	case 1516:
		return BACnetVendorId_AL_MAYSSAN_TECHNICAL_SERVICES_CO_LTD, true
	case 1517:
		return BACnetVendorId_VIRIDI_PARENTE_INC, true
	case 1518:
		return BACnetVendorId_NOVEL_APPS_CORP, true
	case 1519:
		return BACnetVendorId_OVENTROP_CHINAHVAC_SYSTEM_TECHNOLOGY_CO_LTD, true
	case 152:
		return BACnetVendorId_REGEL_PARTNERS, true
	case 1521:
		return BACnetVendorId_LACROIX_SOFREL, true
	case 1522:
		return BACnetVendorId_MACHINE_SENSLOT_TRADING_COLLC, true
	case 1523:
		return BACnetVendorId_ELMEC_INC, true
	case 1524:
		return BACnetVendorId_BEIJING_HAISHI_SOFTWARE_CO_LTD, true
	case 1525:
		return BACnetVendorId_RADIX_ELECTROSYSTEMS_PVT_LTD, true
	case 1526:
		return BACnetVendorId_VRMEBARONENAB, true
	case 1527:
		return BACnetVendorId_TREAU_INCDBA_GRADIENT, true
	case 1528:
		return BACnetVendorId_WEST_SOLUTIONAG, true
	case 1529:
		return BACnetVendorId_TRUEWAY_CONTROLS_HONGKONG_LIMITED, true
	case 153:
		return BACnetVendorId_NATIONAL_ENVIRONMENTAL_PRODUCT, true
	case 1530:
		return BACnetVendorId_BUILDING_LOGIX, true
	case 1531:
		return BACnetVendorId_IFESCA_GMBH, true
	case 1532:
		return BACnetVendorId_FELLOWES_INC, true
	case 1533:
		return BACnetVendorId_CALEFFI_SPA, true
	case 1534:
		return BACnetVendorId_JDRF_ELECTROMAG, true
	case 1535:
		return BACnetVendorId_REDWIRE_LABS, true
	case 1536:
		return BACnetVendorId_WECON_TECHNOLOGY_CO_LTD, true
	case 1537:
		return BACnetVendorId_ACACIA_GREEN_TECHNOLOGIES_LTD, true
	case 1538:
		return BACnetVendorId_DEGREE_ANALYTICS, true
	case 1539:
		return BACnetVendorId_ROLTEK_TEKNOLOJIAS, true
	case 154:
		return BACnetVendorId_UNITEC_CORPORATION, true
	case 1540:
		return BACnetVendorId_DIGITAL_CONTROL_TECHNOLOGY_LIMITED, true
	case 1541:
		return BACnetVendorId_KENTIMAAB, true
	case 1542:
		return BACnetVendorId_PERGAMON_PERCEPTIVE_TECHNOLOGIES, true
	case 1543:
		return BACnetVendorId_PREFECT_CONTROLS_LTD, true
	case 1544:
		return BACnetVendorId_SEN_TECH_CORPORATION, true
	case 1545:
		return BACnetVendorId_SS_REGELTECHNIK_GMBH, true
	case 1546:
		return BACnetVendorId_AIR_BOX_INC, true
	case 1547:
		return BACnetVendorId_RVE, true
	case 1548:
		return BACnetVendorId_MOTOROLA_SOLUTIONS, true
	case 1549:
		return BACnetVendorId_BACSYS_INNOVATIONS_PRIVATE_LIMITED, true
	case 155:
		return BACnetVendorId_KANDEN_ENGINEERING_COMPANY, true
	case 1550:
		return BACnetVendorId_EWATTCH, true
	case 1551:
		return BACnetVendorId_BUILTLAYERLLC, true
	case 1552:
		return BACnetVendorId_AG_DOMOTIXSRL, true
	case 1553:
		return BACnetVendorId_HYTRONIK_INDUSTRIAL_LIMITED, true
	case 1554:
		return BACnetVendorId_WHO_REINRAUMTECHNIK, true
	case 1555:
		return BACnetVendorId_TRICO_LIMITED, true
	case 1556:
		return BACnetVendorId_SLK_AUTOMATIONSRL, true
	case 1557:
		return BACnetVendorId_ZAPHIREAS, true
	case 1558:
		return BACnetVendorId_AJ_MANUFACTURING, true
	case 1559:
		return BACnetVendorId_FUTURE_MOTORS_LTD, true
	case 156:
		return BACnetVendorId_MESSNER_GEBUDETECHNIK_GMBH, true
	case 1560:
		return BACnetVendorId_HIMEL_HONG_KONG_LIMITED, true
	case 1561:
		return BACnetVendorId_SHENZHEN_SUNRICHER_TECHNOLOGY_CO_LTD, true
	case 1562:
		return BACnetVendorId_ACTILITYSA, true
	case 1563:
		return BACnetVendorId_OY_HALTON_GROUP_LTD, true
	case 1564:
		return BACnetVendorId_AVTECH_SOFTWARE_INC, true
	case 1565:
		return BACnetVendorId_IN_CONTROL_ENGINEERINGLLC, true
	case 1566:
		return BACnetVendorId_SOUND_WATER_TECHNOLOGIESLLC, true
	case 157:
		return BACnetVendorId_INTEGRATEDCH, true
	case 158:
		return BACnetVendorId_PRICE_INDUSTRIES, true
	case 159:
		return BACnetVendorId_SE_ELEKTRONIC_GMBH, true
	case 16:
		return BACnetVendorId_UNITED_TECHNOLOGIES_CARRIER, true
	case 160:
		return BACnetVendorId_ROCKWELL_AUTOMATION, true
	case 161:
		return BACnetVendorId_ENFLEX_CORP, true
	case 162:
		return BACnetVendorId_ASI_CONTROLS, true
	case 163:
		return BACnetVendorId_SYS_MIK_GMBH_DRESDEN, true
	case 164:
		return BACnetVendorId_HSC_REGELUNGSTECHNIK_GMBH, true
	case 165:
		return BACnetVendorId_SMART_TEMP_AUSTRALIA_PTY_LTD, true
	case 166:
		return BACnetVendorId_COOPER_CONTROLS, true
	case 167:
		return BACnetVendorId_DUKSAN_MECASYS_CO_LTD, true
	case 168:
		return BACnetVendorId_FUJIIT_CO_LTD, true
	case 169:
		return BACnetVendorId_VACON_PLC, true
	case 17:
		return BACnetVendorId_HONEYWELL_INC, true
	case 170:
		return BACnetVendorId_LEADER_CONTROLS, true
	case 171:
		return BACnetVendorId_ABB_FORMERLY_CYLON_CONTROLS_LTD, true
	case 172:
		return BACnetVendorId_COMPAS, true
	case 173:
		return BACnetVendorId_MITSUBISHI_ELECTRIC_BUILDING_TECHNO_SERVICE_CO_LTD, true
	case 174:
		return BACnetVendorId_BUILDING_CONTROL_INTEGRATORS, true
	case 175:
		return BACnetVendorId_ITG_WORLDWIDEM_SDN_BHD, true
	case 176:
		return BACnetVendorId_LUTRON_ELECTRONICS_CO_INC, true
	case 177:
		return BACnetVendorId_COOPER_ATKINS_CORPORATION, true
	case 178:
		return BACnetVendorId_LOYTEC_ELECTRONICS_GMBH, true
	case 179:
		return BACnetVendorId_PRO_LON, true
	case 18:
		return BACnetVendorId_ALERTON_HONEYWELL, true
	case 180:
		return BACnetVendorId_MEGA_CONTROLS_LIMITED, true
	case 181:
		return BACnetVendorId_MICRO_CONTROL_SYSTEMS_INC, true
	case 182:
		return BACnetVendorId_KIYON_INC, true
	case 183:
		return BACnetVendorId_DUST_NETWORKS, true
	case 184:
		return BACnetVendorId_ADVANCED_BUILDING_AUTOMATION_SYSTEMS, true
	case 185:
		return BACnetVendorId_HERMOSAG, true
	case 186:
		return BACnetVendorId_CEZIM, true
	case 187:
		return BACnetVendorId_SOFTING, true
	case 188:
		return BACnetVendorId_LYNXSPRING_INC, true
	case 189:
		return BACnetVendorId_SCHNEIDER_TOSHIBA_INVERTER_EUROPE, true
	case 19:
		return BACnetVendorId_TACAB, true
	case 190:
		return BACnetVendorId_DANFOSS_DRIVESAS, true
	case 191:
		return BACnetVendorId_EATON_CORPORATION, true
	case 192:
		return BACnetVendorId_MATYCASA, true
	case 193:
		return BACnetVendorId_BOTECHAB, true
	case 194:
		return BACnetVendorId_NOVEO_INC, true
	case 195:
		return BACnetVendorId_AMEV, true
	case 196:
		return BACnetVendorId_YOKOGAWA_ELECTRIC_CORPORATION, true
	case 197:
		return BACnetVendorId_BOSCH_BUILDING_AUTOMATION_GMBH, true
	case 198:
		return BACnetVendorId_EXACT_LOGIC, true
	case 199:
		return BACnetVendorId_MASS_ELECTRONICS_PTY_LTDDBA_INNOTECH_CONTROL_SYSTEMS_AUSTRALIA, true
	case 2:
		return BACnetVendorId_THE_TRANE_COMPANY, true
	case 20:
		return BACnetVendorId_HEWLETT_PACKARD_COMPANY, true
	case 200:
		return BACnetVendorId_KANDENKO_CO_LTD, true
	case 201:
		return BACnetVendorId_DTF_DATEN_TECHNIK_FRIES, true
	case 202:
		return BACnetVendorId_KLIMASOFT_LTD, true
	case 203:
		return BACnetVendorId_TOSHIBA_SCHNEIDER_INVERTER_CORPORATION, true
	case 204:
		return BACnetVendorId_CONTROL_APPLICATIONS_LTD, true
	case 205:
		return BACnetVendorId_CIMONCO_LTD, true
	case 206:
		return BACnetVendorId_ONICON_INCORPORATED, true
	case 207:
		return BACnetVendorId_AUTOMATION_DISPLAYS_INC, true
	case 208:
		return BACnetVendorId_CONTROL_SOLUTIONS_INC, true
	case 209:
		return BACnetVendorId_REMSDAQ_LIMITED, true
	case 21:
		return BACnetVendorId_DORSETTES_INC, true
	case 210:
		return BACnetVendorId_NTT_FACILITIES_INC, true
	case 211:
		return BACnetVendorId_VIPA_GMBH, true
	case 212:
		return BACnetVendorId_TSC1_ASSOCIATIONOF_JAPAN, true
	case 213:
		return BACnetVendorId_STRATO_AUTOMATION, true
	case 214:
		return BACnetVendorId_HRW_LIMITED, true
	case 215:
		return BACnetVendorId_LIGHTING_CONTROL_DESIGN_INC, true
	case 216:
		return BACnetVendorId_MERCY_ELECTRONICAND_ELECTRICAL_INDUSTRIES, true
	case 217:
		return BACnetVendorId_SAMSUNGSDS_CO_LTD, true
	case 218:
		return BACnetVendorId_IMPACT_FACILITY_SOLUTIONS_INC, true
	case 219:
		return BACnetVendorId_AIRCUITY, true
	case 22:
		return BACnetVendorId_SIEMENS_SCHWEIZAG2, true
	case 220:
		return BACnetVendorId_CONTROL_TECHNIQUES_LTD, true
	case 221:
		return BACnetVendorId_OPEN_GENERAL_PTY_LTD, true
	case 222:
		return BACnetVendorId_WAGO_KONTAKTTECHNIK_GMBH_COKG, true
	case 223:
		return BACnetVendorId_FRANKLIN_ELECTRIC, true
	case 224:
		return BACnetVendorId_CHLORIDE_POWER_PROTECTION_COMPANY, true
	case 225:
		return BACnetVendorId_COMPUTROLS_INC, true
	case 226:
		return BACnetVendorId_PHOENIX_CONTACT_GMBH_COKG, true
	case 227:
		return BACnetVendorId_GRUNDFOS_MANAGEMENTAS, true
	case 228:
		return BACnetVendorId_RIDDER_DRIVE_SYSTEMS, true
	case 229:
		return BACnetVendorId_SOFT_DEVICESDNBHD, true
	case 23:
		return BACnetVendorId_YORK_CONTROLS_GROUP, true
	case 230:
		return BACnetVendorId_INTEGRATED_CONTROL_TECHNOLOGY_LIMITED, true
	case 231:
		return BACnetVendorId_AI_RXPERT_SYSTEMS_INC, true
	case 232:
		return BACnetVendorId_MICROTROL_LIMITED, true
	case 233:
		return BACnetVendorId_RED_LION_CONTROLS, true
	case 234:
		return BACnetVendorId_DIGITAL_ELECTRONICS_CORPORATION, true
	case 235:
		return BACnetVendorId_ENNOVATIS_GMBH, true
	case 236:
		return BACnetVendorId_SEROTONIN_SOFTWARE_TECHNOLOGIES_INC, true
	case 237:
		return BACnetVendorId_LS_INDUSTRIAL_SYSTEMS_CO_LTD, true
	case 238:
		return BACnetVendorId_SQUARED_COMPANY, true
	case 239:
		return BACnetVendorId_S_SQUARED_INNOVATIONS_INC, true
	case 24:
		return BACnetVendorId_AUTOMATED_LOGIC_CORPORATION, true
	case 240:
		return BACnetVendorId_ARICENT_LTD, true
	case 241:
		return BACnetVendorId_ETHER_METRICSLLC, true
	case 242:
		return BACnetVendorId_INDUSTRIAL_CONTROL_COMMUNICATIONS_INC, true
	case 243:
		return BACnetVendorId_PARAGON_CONTROLS_INC, true
	case 244:
		return BACnetVendorId_AO_SMITH_CORPORATION, true
	case 245:
		return BACnetVendorId_CONTEMPORARY_CONTROL_SYSTEMS_INC, true
	case 246:
		return BACnetVendorId_HMS_INDUSTRIAL_NETWORKSSLU, true
	case 247:
		return BACnetVendorId_INGENIEURGESELLSCHAFTN_HARTLEBMBH, true
	case 248:
		return BACnetVendorId_HEAT_TIMER_CORPORATION, true
	case 249:
		return BACnetVendorId_INGRASYS_TECHNOLOGY_INC, true
	case 25:
		return BACnetVendorId_CSI_CONTROL_SYSTEMS_INTERNATIONAL, true
	case 250:
		return BACnetVendorId_COSTERM_BUILDING_AUTOMATION, true
	case 251:
		return BACnetVendorId_WILOSE, true
	case 252:
		return BACnetVendorId_EMBEDIA_TECHNOLOGIES_CORP, true
	case 253:
		return BACnetVendorId_TECHNILOG, true
	case 254:
		return BACnetVendorId_HR_CONTROLS_LTD_COKG, true
	case 255:
		return BACnetVendorId_LENNOX_INTERNATIONAL_INC, true
	case 256:
		return BACnetVendorId_RK_TEC_RAUCHKLAPPEN_STEUERUNGSSYSTEME_GMBH_COKG, true
	case 257:
		return BACnetVendorId_THERMOMAX_LTD, true
	case 258:
		return BACnetVendorId_ELCON_ELECTRONIC_CONTROL_LTD, true
	case 259:
		return BACnetVendorId_LARMIA_CONTROLAB, true
	case 26:
		return BACnetVendorId_PHOENIX_CONTROLS_CORPORATION, true
	case 260:
		return BACnetVendorId_BA_CNET_STACKAT_SOURCE_FORGE, true
	case 261:
		return BACnetVendorId_GS_SECURITY_SERVICESAS, true
	case 262:
		return BACnetVendorId_EXOR_INTERNATIONAL_SPA, true
	case 263:
		return BACnetVendorId_CRISTAL_CONTROLES, true
	case 264:
		return BACnetVendorId_REGINAB, true
	case 265:
		return BACnetVendorId_DIMENSION_SOFTWARE_INC, true
	case 266:
		return BACnetVendorId_SYNAP_SENSE_CORPORATION, true
	case 267:
		return BACnetVendorId_BEIJING_NANTREE_ELECTRONIC_CO_LTD, true
	case 268:
		return BACnetVendorId_CAMUS_HYDRONICS_LTD, true
	case 269:
		return BACnetVendorId_KAWASAKI_HEAVY_INDUSTRIES_LTD, true
	case 27:
		return BACnetVendorId_INNOVEX_TECHNOLOGIES_INC, true
	case 270:
		return BACnetVendorId_CRITICAL_ENVIRONMENT_TECHNOLOGIES, true
	case 271:
		return BACnetVendorId_ILSHINIBS_CO_LTD, true
	case 272:
		return BACnetVendorId_ELESTA_ENERGY_CONTROLAG, true
	case 273:
		return BACnetVendorId_KROPMAN_INSTALLATIETECHNIEK, true
	case 274:
		return BACnetVendorId_BALDOR_ELECTRIC_COMPANY, true
	case 275:
		return BACnetVendorId_ING_AMBH, true
	case 276:
		return BACnetVendorId_GE_CONSUMER_INDUSTRIAL, true
	case 277:
		return BACnetVendorId_FUNCTIONAL_DEVICES_INC, true
	case 278:
		return BACnetVendorId_STUDIOSC, true
	case 279:
		return BACnetVendorId_MGCOLTD, true
	case 28:
		return BACnetVendorId_KMC_CONTROLS_INC, true
	case 280:
		return BACnetVendorId_YOKOTA_CO_LTD, true
	case 281:
		return BACnetVendorId_HITRANSE_TECHNOLOGY_COLTD, true
	case 282:
		return BACnetVendorId_VIGILENT_CORPORATION, true
	case 283:
		return BACnetVendorId_KELE_INC, true
	case 284:
		return BACnetVendorId_BELIMO_AUTOMATIONAG, true
	case 285:
		return BACnetVendorId_GENTEC, true
	case 286:
		return BACnetVendorId_EMBEDDED_SCIENCE_LABSLLC, true
	case 287:
		return BACnetVendorId_PARKER_HANNIFIN_CORPORATION, true
	case 288:
		return BACnetVendorId_MA_CAPS_INTERNATIONAL_LIMITED, true
	case 289:
		return BACnetVendorId_LINK_CORPORATION, true
	case 29:
		return BACnetVendorId_XN_TECHNOLOGIES_INC, true
	case 290:
		return BACnetVendorId_ROMUTEC_STEUERU_REGELSYSTEME_GMBH, true
	case 291:
		return BACnetVendorId_PRIBUSIN_INC, true
	case 292:
		return BACnetVendorId_ADVANTAGE_CONTROLS, true
	case 293:
		return BACnetVendorId_CRITICAL_ROOM_CONTROL, true
	case 294:
		return BACnetVendorId_LEGRAND, true
	case 295:
		return BACnetVendorId_TONGDY_CONTROL_TECHNOLOGY_CO_LTD, true
	case 296:
		return BACnetVendorId_ISSARO_INTEGRIERTE_SYSTEMTECHNIK, true
	case 297:
		return BACnetVendorId_PRO_DEV_INDUSTRIES, true
	case 298:
		return BACnetVendorId_DRISTEEM, true
	case 299:
		return BACnetVendorId_CREATIVE_ELECTRONIC_GMBH, true
	case 3:
		return BACnetVendorId_DAIKIN_APPLIED_AMERICAS, true
	case 30:
		return BACnetVendorId_HYUNDAI_INFORMATION_TECHNOLOGY_CO_LTD, true
	case 300:
		return BACnetVendorId_SWEGONAB, true
	case 301:
		return BACnetVendorId_FIRVEN_ASRO, true
	case 302:
		return BACnetVendorId_HITACHI_APPLIANCES_INC, true
	case 303:
		return BACnetVendorId_REAL_TIME_AUTOMATION_INC, true
	case 304:
		return BACnetVendorId_ITEC_HANKYU_HANSHIN_CO, true
	case 305:
		return BACnetVendorId_CYRUSEM_ENGINEERING_CO_LTD, true
	case 306:
		return BACnetVendorId_BADGER_METER, true
	case 307:
		return BACnetVendorId_CIRRASCALE_CORPORATION, true
	case 308:
		return BACnetVendorId_ELESTA_GMBH_BUILDING_AUTOMATION, true
	case 309:
		return BACnetVendorId_SECURITON, true
	case 31:
		return BACnetVendorId_TOKIMEC_INC, true
	case 310:
		return BACnetVendorId_O_SLSOFT_INC, true
	case 311:
		return BACnetVendorId_HANAZEDER_ELECTRONIC_GMBH, true
	case 312:
		return BACnetVendorId_HONEYWELL_SECURITY_DEUTSCHLAND_NOVAR_GMBH, true
	case 313:
		return BACnetVendorId_SIEMENS_INDUSTRY_INC, true
	case 314:
		return BACnetVendorId_ETM_PROFESSIONAL_CONTROL_GMBH, true
	case 315:
		return BACnetVendorId_MEITAVTEC_LTD, true
	case 316:
		return BACnetVendorId_JANITZA_ELECTRONICS_GMBH, true
	case 317:
		return BACnetVendorId_MKS_NORDHAUSEN, true
	case 318:
		return BACnetVendorId_DE_GIER_DRIVE_SYSTEMSBV, true
	case 319:
		return BACnetVendorId_CYPRESS_ENVIROSYSTEMS, true
	case 32:
		return BACnetVendorId_SIMPLEX, true
	case 320:
		return BACnetVendorId_SMAR_TRONSRO, true
	case 321:
		return BACnetVendorId_VERARI_SYSTEMS_INC, true
	case 322:
		return BACnetVendorId_KW_ELECTRONIC_SERVICE_INC, true
	case 323:
		return BACnetVendorId_ALFASMART_ENERGY_MANAGEMENT, true
	case 324:
		return BACnetVendorId_TELKONET_INC, true
	case 325:
		return BACnetVendorId_SECURITON_GMBH, true
	case 326:
		return BACnetVendorId_CEMTREX_INC, true
	case 327:
		return BACnetVendorId_PERFORMANCE_TECHNOLOGIES_INC, true
	case 328:
		return BACnetVendorId_XTRALIS_AUST_PTY_LTD, true
	case 329:
		return BACnetVendorId_TROX_GMBH, true
	case 33:
		return BACnetVendorId_NORTH_BUILDING_TECHNOLOGIES_LIMITED, true
	case 330:
		return BACnetVendorId_BEIJING_HYSINE_TECHNOLOGY_CO_LTD, true
	case 331:
		return BACnetVendorId_RCK_CONTROLS_INC, true
	case 332:
		return BACnetVendorId_DISTECH_CONTROLSSAS, true
	case 333:
		return BACnetVendorId_NOVAR_HONEYWELL, true
	case 334:
		return BACnetVendorId_S_INTEGRATION_SOLUTIONS, true
	case 335:
		return BACnetVendorId_SCHNEIDER_ELECTRIC1, true
	case 336:
		return BACnetVendorId_LHA_SYSTEMS, true
	case 337:
		return BACnetVendorId_GH_MENGINEERING_GROUP_INC, true
	case 338:
		return BACnetVendorId_CLLIMALUXSA, true
	case 339:
		return BACnetVendorId_VAISALA_OYJ, true
	case 34:
		return BACnetVendorId_NOTIFIER, true
	case 340:
		return BACnetVendorId_COMPLEX_BEIJING_TECHNOLOGY_COLTD, true
	case 341:
		return BACnetVendorId_SCAD_AMETRICS, true
	case 342:
		return BACnetVendorId_POWERPEGNSI_LIMITED, true
	case 343:
		return BACnetVendorId_BA_CNET_INTEROPERABILITY_TESTING_SERVICES_INC, true
	case 344:
		return BACnetVendorId_TECOAS, true
	case 345:
		return BACnetVendorId_PLEXUS_TECHNOLOGY_INC, true
	case 346:
		return BACnetVendorId_ENERGY_FOCUS_INC, true
	case 347:
		return BACnetVendorId_POWERSMITHS_INTERNATIONAL_CORP, true
	case 348:
		return BACnetVendorId_NICHIBEI_CO_LTD, true
	case 349:
		return BACnetVendorId_HKC_TECHNOLOGY_LTD, true
	case 35:
		return BACnetVendorId_RELIABLE_CONTROLS_CORPORATION, true
	case 350:
		return BACnetVendorId_OVATION_NETWORKS_INC, true
	case 351:
		return BACnetVendorId_SETRA_SYSTEMS, true
	case 352:
		return BACnetVendorId_AVG_AUTOMATION, true
	case 353:
		return BACnetVendorId_ZXC_LTD, true
	case 354:
		return BACnetVendorId_BYTE_SPHERE, true
	case 355:
		return BACnetVendorId_GENERITON_CO_LTD, true
	case 356:
		return BACnetVendorId_HOLTER_REGELARMATUREN_GMBH_COKG, true
	case 357:
		return BACnetVendorId_BEDFORD_INSTRUMENTSLLC, true
	case 358:
		return BACnetVendorId_STANDAIR_INC, true
	case 359:
		return BACnetVendorId_WEG_AUTOMATIONRD, true
	case 36:
		return BACnetVendorId_TRIDIUM_INC, true
	case 360:
		return BACnetVendorId_PROLON_CONTROL_SYSTEMS_APS, true
	case 361:
		return BACnetVendorId_INNEASOFT, true
	case 362:
		return BACnetVendorId_CONNEX_SOFT_GMBH, true
	case 363:
		return BACnetVendorId_CEAG_NOTLICHTSYSTEME_GMBH, true
	case 364:
		return BACnetVendorId_DISTECH_CONTROLS_INC, true
	case 365:
		return BACnetVendorId_INDUSTRIAL_TECHNOLOGY_RESEARCH_INSTITUTE, true
	case 366:
		return BACnetVendorId_MITSUBISHI_ELECTRIC_ICONICS_DIGITAL_SOLUTIONS, true
	case 367:
		return BACnetVendorId_IQ_CONTROLSSC, true
	case 368:
		return BACnetVendorId_OJ_ELECTRONICSAS, true
	case 369:
		return BACnetVendorId_ROLBIT_LTD, true
	case 37:
		return BACnetVendorId_MSA_SAFETY, true
	case 370:
		return BACnetVendorId_SYNAPSYS_SOLUTIONS_LTD, true
	case 371:
		return BACnetVendorId_ACME_ENGINEERING_PROD_LTD, true
	case 372:
		return BACnetVendorId_ZENER_ELECTRIC_PTY_LTD, true
	case 373:
		return BACnetVendorId_SELECTRONIX_INC, true
	case 374:
		return BACnetVendorId_GORBET_BANERJEELLC, true
	case 375:
		return BACnetVendorId_IME, true
	case 376:
		return BACnetVendorId_STEPHENH_DAWSON_COMPUTER_SERVICE, true
	case 377:
		return BACnetVendorId_ACCUTROLLLC, true
	case 378:
		return BACnetVendorId_SCHNEIDER_ELEKTRONIK_GMBH, true
	case 379:
		return BACnetVendorId_ALPHA_INNO_TEC_GMBH, true
	case 38:
		return BACnetVendorId_SILICON_ENERGY, true
	case 380:
		return BACnetVendorId_ADM_MICRO_INC, true
	case 381:
		return BACnetVendorId_GREYSTONE_ENERGY_SYSTEMS_INC, true
	case 382:
		return BACnetVendorId_CAP_TECHNOLOGIE, true
	case 383:
		return BACnetVendorId_KE_RO_SYSTEMS, true
	case 384:
		return BACnetVendorId_DOMAT_CONTROL_SYSTEMSRO, true
	case 385:
		return BACnetVendorId_EFEKTRONICS_PTY_LTD, true
	case 386:
		return BACnetVendorId_HEKATRON_VERTRIEBS_GMBH, true
	case 387:
		return BACnetVendorId_SECURITONAG, true
	case 388:
		return BACnetVendorId_CARLO_GAVAZZI_CONTROLS_SPA, true
	case 389:
		return BACnetVendorId_CHIPKIN_AUTOMATION_SYSTEMS, true
	case 39:
		return BACnetVendorId_KIEBACK_PETER_GMBH_COKG, true
	case 390:
		return BACnetVendorId_SAVANT_SYSTEMSLLC, true
	case 391:
		return BACnetVendorId_SIMMTRONIC_LIGHTING_CONTROLS, true
	case 392:
		return BACnetVendorId_ABELKO_INNOVATIONAB, true
	case 393:
		return BACnetVendorId_SERESCO_TECHNOLOGIES_INC, true
	case 394:
		return BACnetVendorId_IT_WATCHDOGS, true
	case 395:
		return BACnetVendorId_AUTOMATION_ASSIST_JAPAN_CORP, true
	case 396:
		return BACnetVendorId_THERMOKON_SENSORTECHNIK_GMBH, true
	case 397:
		return BACnetVendorId_E_GAUGE_SYSTEMSLLC, true
	case 398:
		return BACnetVendorId_QUANTUM_AUTOMATIONASIAPTE_LTD, true
	case 399:
		return BACnetVendorId_TOSHIBA_LIGHTING_TECHNOLOGY_CORP, true
	case 4:
		return BACnetVendorId_POLAR_SOFT, true
	case 40:
		return BACnetVendorId_ANACON_SYSTEMS_INC, true
	case 400:
		return BACnetVendorId_SPIN_ENGENHARIADE_AUTOMAO_LTDA, true
	case 401:
		return BACnetVendorId_LOGISTICS_SYSTEMS_SOFTWARE_SERVICES_INDIAPVT_LTD, true
	case 402:
		return BACnetVendorId_DELTA_CONTROLS_INTEGRATION_PRODUCTS, true
	case 403:
		return BACnetVendorId_FOCUS_MEDIA, true
	case 404:
		return BACnetVendorId_LUM_ENERGI_INC, true
	case 405:
		return BACnetVendorId_KARA_SYSTEMS, true
	case 406:
		return BACnetVendorId_RF_CODE_INC, true
	case 407:
		return BACnetVendorId_FATEK_AUTOMATION_CORP, true
	case 408:
		return BACnetVendorId_JANDA_SOFTWARE_COMPANYLLC, true
	case 409:
		return BACnetVendorId_OPEN_SYSTEM_SOLUTIONS_LIMITED, true
	case 41:
		return BACnetVendorId_SYSTEMS_CONTROLS_INSTRUMENTSLLC, true
	case 410:
		return BACnetVendorId_INTELEC_SYSTEMSPTY_LTD, true
	case 411:
		return BACnetVendorId_ECOLODGIXLLC, true
	case 412:
		return BACnetVendorId_DOUGLAS_LIGHTING_CONTROLS, true
	case 413:
		return BACnetVendorId_IS_ATECH_GMBH, true
	case 414:
		return BACnetVendorId_AREAL, true
	case 415:
		return BACnetVendorId_BECKHOFF_AUTOMATION, true
	case 416:
		return BACnetVendorId_IPAS_GMBH, true
	case 417:
		return BACnetVendorId_KE_THERM_SOLUTIONS, true
	case 418:
		return BACnetVendorId_BASE_PRODUCTS, true
	case 419:
		return BACnetVendorId_DTL_CONTROLSLLC, true
	case 42:
		return BACnetVendorId_ACUITY_BRANDS_LIGHTING_INC, true
	case 420:
		return BACnetVendorId_INNCOM_INTERNATIONAL_INC, true
	case 421:
		return BACnetVendorId_METZCONNECT_GMBH, true
	case 422:
		return BACnetVendorId_GREENTROL_AUTOMATION_INC, true
	case 423:
		return BACnetVendorId_BELIMO_AUTOMATIONAG1, true
	case 424:
		return BACnetVendorId_SAMSUNG_HEAVY_INDUSTRIES_CO_LTD, true
	case 425:
		return BACnetVendorId_TRIACTA_POWER_TECHNOLOGIES_INC, true
	case 426:
		return BACnetVendorId_GLOBESTAR_SYSTEMS, true
	case 427:
		return BACnetVendorId_MLB_ADVANCED_MEDIALP, true
	case 428:
		return BACnetVendorId_SWG_STUCKMANN_WIRTSCHAFTLICHE_GEBUDESYSTEME_GMBH, true
	case 429:
		return BACnetVendorId_SENSOR_SWITCH, true
	case 43:
		return BACnetVendorId_MICROPOWER_MANUFACTURING, true
	case 430:
		return BACnetVendorId_MULTITEK_POWER_LIMITED, true
	case 431:
		return BACnetVendorId_INTEGRA_METERINGAG, true
	case 432:
		return BACnetVendorId_LG_ELECTRONICS_INC, true
	case 433:
		return BACnetVendorId_ELECTRONIC_THEATRE_CONTROLS_INC, true
	case 434:
		return BACnetVendorId_MITSUBISHI_ELECTRIC_CORPORATION_NAGOYA_WORKS, true
	case 435:
		return BACnetVendorId_DELTA_ELECTRONICS_INC, true
	case 436:
		return BACnetVendorId_ELMA_KURTALJ_LTD, true
	case 437:
		return BACnetVendorId_TYCO_FIRE_SECURITY_GMBH, true
	case 438:
		return BACnetVendorId_NEDAP_SECURITY_MANAGEMENT, true
	case 439:
		return BACnetVendorId_ESC_AUTOMATION_INC, true
	case 44:
		return BACnetVendorId_MATRIX_CONTROLS, true
	case 440:
		return BACnetVendorId_DSPYOU_LTD, true
	case 441:
		return BACnetVendorId_GE_SENSINGAND_INSPECTION_TECHNOLOGIES, true
	case 442:
		return BACnetVendorId_EMBEDDED_SYSTEMSSIA, true
	case 443:
		return BACnetVendorId_BEFEGA_GMBH, true
	case 444:
		return BACnetVendorId_BASELINE_INC, true
	case 445:
		return BACnetVendorId_KEY_ACT, true
	case 446:
		return BACnetVendorId_OEM_CTRL, true
	case 447:
		return BACnetVendorId_CLARKSON_CONTROLS_LIMITED, true
	case 448:
		return BACnetVendorId_ROGERWELL_CONTROL_SYSTEM_LIMITED, true
	case 449:
		return BACnetVendorId_SCL_ELEMENTS, true
	case 45:
		return BACnetVendorId_METALAIRE, true
	case 450:
		return BACnetVendorId_HITACHI_LTD1, true
	case 451:
		return BACnetVendorId_NEWRON_SYSTEMSA, true
	case 452:
		return BACnetVendorId_BEVECO_GEBOUWAUTOMATISERINGBV, true
	case 453:
		return BACnetVendorId_STREAMSIDE_SOLUTIONS, true
	case 454:
		return BACnetVendorId_YELLOWSTONE_SOFT, true
	case 455:
		return BACnetVendorId_OZTECH_INTELLIGENT_SYSTEMS_PTY_LTD, true
	case 456:
		return BACnetVendorId_NOVELAN_GMBH, true
	case 457:
		return BACnetVendorId_FLEXIM_AMERICAS_CORPORATION, true
	case 458:
		return BACnetVendorId_ICPDAS_CO_LTD, true
	case 459:
		return BACnetVendorId_CARMA_INDUSTRIES_INC, true
	case 46:
		return BACnetVendorId_ESS_ENGINEERING, true
	case 460:
		return BACnetVendorId_LOG_ONE_LTD, true
	case 461:
		return BACnetVendorId_TECO_ELECTRIC_MACHINERY_CO_LTD, true
	case 462:
		return BACnetVendorId_CONNECT_EX_INC, true
	case 463:
		return BACnetVendorId_TURBODDC_SDWEST, true
	case 464:
		return BACnetVendorId_QUATROSENSE_ENVIRONMENTAL_LTD, true
	case 465:
		return BACnetVendorId_FIFTH_LIGHT_TECHNOLOGY_LTD, true
	case 466:
		return BACnetVendorId_SCIENTIFIC_SOLUTIONS_LTD, true
	case 467:
		return BACnetVendorId_CONTROLLER_AREA_NETWORK_SOLUTIONSM_SDN_BHD, true
	case 468:
		return BACnetVendorId_RESOL_ELEKTRONISCHE_REGELUNGEN_GMBH, true
	case 469:
		return BACnetVendorId_RPBUSLLC, true
	case 47:
		return BACnetVendorId_SPHERE_SYSTEMS_PTY_LTD, true
	case 470:
		return BACnetVendorId_BRS_SISTEMAS_ELETRONICOS, true
	case 471:
		return BACnetVendorId_WINDOW_MASTERAS, true
	case 472:
		return BACnetVendorId_SUNLUX_TECHNOLOGIES_LTD, true
	case 473:
		return BACnetVendorId_MEASURLOGIC, true
	case 474:
		return BACnetVendorId_FRIMAT_GMBH, true
	case 475:
		return BACnetVendorId_SPIRAX_SARCO, true
	case 476:
		return BACnetVendorId_LUXTRON, true
	case 477:
		return BACnetVendorId_RAYPAK_INC, true
	case 478:
		return BACnetVendorId_AIR_MONITOR_CORPORATION1, true
	case 479:
		return BACnetVendorId_REGLER_OCH_WEBBTEKNIK_SVERIGEROWS, true
	case 48:
		return BACnetVendorId_WALKER_TECHNOLOGIES_CORPORATION, true
	case 480:
		return BACnetVendorId_INTELLIGENT_LIGHTING_CONTROLS_INC, true
	case 481:
		return BACnetVendorId_SANYO_ELECTRIC_INDUSTRY_CO_LTD, true
	case 482:
		return BACnetVendorId_E_MON_ENERGY_MONITORING_PRODUCTS, true
	case 483:
		return BACnetVendorId_DIGITAL_CONTROL_SYSTEMS, true
	case 484:
		return BACnetVendorId_ATI_AIRTEST_TECHNOLOGIES_INC, true
	case 485:
		return BACnetVendorId_SCSSA, true
	case 486:
		return BACnetVendorId_HMS_INDUSTRIAL_NETWORKSAB, true
	case 487:
		return BACnetVendorId_SHENZHEN_UNIVERSAL_INTELLISYS_CO_LTD, true
	case 488:
		return BACnetVendorId_EK_INTELLISYS_SDN_BHD, true
	case 489:
		return BACnetVendorId_SYS_COM, true
	case 49:
		return BACnetVendorId_HI_SOLUTIONS_INC, true
	case 490:
		return BACnetVendorId_FIRECOM_INC, true
	case 491:
		return BACnetVendorId_ESA_ELEKTROSCHALTANLAGEN_GRIMMA_GMBH, true
	case 492:
		return BACnetVendorId_KUMAHIRA_CO_LTD, true
	case 493:
		return BACnetVendorId_HOTRACO, true
	case 494:
		return BACnetVendorId_SABO_ELEKTRONIK_GMBH, true
	case 495:
		return BACnetVendorId_EQUIP_TRANS, true
	case 496:
		return BACnetVendorId_TEMPERATURE_CONTROL_SPECIALITIES_CO_INCTCS, true
	case 497:
		return BACnetVendorId_FLOW_CON_INTERNATIONALAS, true
	case 498:
		return BACnetVendorId_THYSSEN_KRUPP_ELEVATOR_AMERICAS, true
	case 499:
		return BACnetVendorId_ABATEMENT_TECHNOLOGIES, true
	case 5:
		return BACnetVendorId_JOHNSON_CONTROLS_INC, true
	case 50:
		return BACnetVendorId_MBS_GMBH, true
	case 500:
		return BACnetVendorId_CONTINENTAL_CONTROL_SYSTEMSLLC, true
	case 501:
		return BACnetVendorId_WISAG_AUTOMATISIERUNGSTECHNIK_GMBH_COKG, true
	case 502:
		return BACnetVendorId_EASYIO, true
	case 503:
		return BACnetVendorId_EAP_ELECTRIC_GMBH, true
	case 504:
		return BACnetVendorId_HARDMEIER, true
	case 505:
		return BACnetVendorId_MIRCOM_GROUPOF_COMPANIES, true
	case 506:
		return BACnetVendorId_QUEST_CONTROLS, true
	case 507:
		return BACnetVendorId_MESTEK_INC, true
	case 508:
		return BACnetVendorId_PULSE_ENERGY, true
	case 509:
		return BACnetVendorId_TACHIKAWA_CORPORATION, true
	case 51:
		return BACnetVendorId_SAMSONAG, true
	case 510:
		return BACnetVendorId_UNIVERSITYOF_NEBRASKA_LINCOLN, true
	case 511:
		return BACnetVendorId_REDWOOD_SYSTEMS, true
	case 512:
		return BACnetVendorId_PAS_STEC_INDUSTRIE_ELEKTRONIK_GMBH, true
	case 513:
		return BACnetVendorId_NGEK_INC, true
	case 514:
		return BACnetVendorId_TMAC_TECHNOLOGIES, true
	case 515:
		return BACnetVendorId_JIREH_ENERGY_TECH_CO_LTD, true
	case 516:
		return BACnetVendorId_ENLIGHTED_INC, true
	case 517:
		return BACnetVendorId_EL_PIAST_SP_ZOO, true
	case 518:
		return BACnetVendorId_NETX_AUTOMATION_SOFTWARE_GMBH, true
	case 519:
		return BACnetVendorId_INVERTEK_DRIVES, true
	case 52:
		return BACnetVendorId_BADGER_METER_INC, true
	case 520:
		return BACnetVendorId_DEUTSCHMANN_AUTOMATION_GMBH_COKG, true
	case 521:
		return BACnetVendorId_EMU_ELECTRONICAG, true
	case 522:
		return BACnetVendorId_PHAEDRUS_LIMITED, true
	case 523:
		return BACnetVendorId_SIGMATEK_GMBH_COKG, true
	case 524:
		return BACnetVendorId_MARLIN_CONTROLS, true
	case 525:
		return BACnetVendorId_CIRCUTORSA, true
	case 526:
		return BACnetVendorId_UTC_FIRE_SECURITY, true
	case 527:
		return BACnetVendorId_DENT_INSTRUMENTS_INC, true
	case 528:
		return BACnetVendorId_FHP_MANUFACTURING_COMPANY_BOSCH_GROUP, true
	case 529:
		return BACnetVendorId_GE_INTELLIGENT_PLATFORMS, true
	case 53:
		return BACnetVendorId_DAIKIN_INDUSTRIES_LTD, true
	case 530:
		return BACnetVendorId_INNER_RANGE_PTY_LTD, true
	case 531:
		return BACnetVendorId_GLAS_ENERGY_TECHNOLOGY, true
	case 532:
		return BACnetVendorId_MSR_ELECTRONIC_GMBH, true
	case 533:
		return BACnetVendorId_ENERGY_CONTROL_SYSTEMS_INC, true
	case 534:
		return BACnetVendorId_EMT_CONTROLS, true
	case 535:
		return BACnetVendorId_DAINTREE, true
	case 536:
		return BACnetVendorId_EUROIC_CDOO, true
	case 537:
		return BACnetVendorId_TE_CONNECTIVITY_ENERGY, true
	case 538:
		return BACnetVendorId_GEZE_GMBH, true
	case 539:
		return BACnetVendorId_NEC_CORPORATION, true
	case 54:
		return BACnetVendorId_NARA_CONTROLS_INC, true
	case 540:
		return BACnetVendorId_HO_CHEUNG_INTERNATIONAL_COMPANY_LIMITED, true
	case 541:
		return BACnetVendorId_SHARP_MANUFACTURING_SYSTEMS_CORPORATION, true
	case 542:
		return BACnetVendorId_DOTCONTROL_SAS, true
	case 543:
		return BACnetVendorId_BEACON_MEDS, true
	case 544:
		return BACnetVendorId_MIDEA_COMMERCIAL_AIRCON, true
	case 545:
		return BACnetVendorId_AAON, true
	case 546:
		return BACnetVendorId_KAMSTRUPAS, true
	case 547:
		return BACnetVendorId_CA_COMPUTER_AUTOMATION_GMBH, true
	case 548:
		return BACnetVendorId_LAARS_HEATING_SYSTEMS_COMPANY, true
	case 549:
		return BACnetVendorId_HITACHI_SYSTEMS_LTD, true
	case 55:
		return BACnetVendorId_MAMMOTH_INC, true
	case 550:
		return BACnetVendorId_FUSHANAKE_ELECTRONIC_ENGINEERING_CO_LTD, true
	case 551:
		return BACnetVendorId_TOSHIBA_INTERNATIONAL_CORPORATION, true
	case 552:
		return BACnetVendorId_STARMAN_SYSTEMSLLC, true
	case 553:
		return BACnetVendorId_SAMSUNG_TECHWIN_CO_LTD, true
	case 554:
		return BACnetVendorId_ISAS_INTEGRATED_SWITCHGEARAND_SYSTEMSPL, true
	case 556:
		return BACnetVendorId_OBVIUS, true
	case 557:
		return BACnetVendorId_MAREK_GUZIK, true
	case 558:
		return BACnetVendorId_VORTEK_INSTRUMENTSLLC, true
	case 559:
		return BACnetVendorId_UNIVERSAL_LIGHTING_TECHNOLOGIES, true
	case 56:
		return BACnetVendorId_LIEBERT_CORPORATION, true
	case 560:
		return BACnetVendorId_MYERS_POWER_PRODUCTS_INC, true
	case 561:
		return BACnetVendorId_VECTOR_CONTROLS_GMBH, true
	case 562:
		return BACnetVendorId_CRESTRON_ELECTRONICS_INC, true
	case 563:
		return BACnetVendorId_AE_CONTROLS_LIMITED, true
	case 564:
		return BACnetVendorId_PROJEKTOMONTAZAAD, true
	case 565:
		return BACnetVendorId_FREEAIRE_REFRIGERATION, true
	case 566:
		return BACnetVendorId_AQUA_COOLER_PTY_LIMITED, true
	case 567:
		return BACnetVendorId_BASIC_CONTROLS, true
	case 568:
		return BACnetVendorId_GE_MEASUREMENTAND_CONTROL_SOLUTIONS_ADVANCED_SENSORS, true
	case 569:
		return BACnetVendorId_EQUAL_NETWORKS, true
	case 57:
		return BACnetVendorId_SEMCO_INCORPORATED, true
	case 570:
		return BACnetVendorId_MILLENNIAL_NET, true
	case 571:
		return BACnetVendorId_APLI_LTD, true
	case 572:
		return BACnetVendorId_ELECTRO_INDUSTRIES_GAUGE_TECH, true
	case 573:
		return BACnetVendorId_SANG_MYUNG_UNIVERSITY, true
	case 574:
		return BACnetVendorId_COPPERTREE_ANALYTICS_INC, true
	case 575:
		return BACnetVendorId_CORE_NETIX_GMBH, true
	case 576:
		return BACnetVendorId_ACUTHERM, true
	case 577:
		return BACnetVendorId_DR_RIEDEL_AUTOMATISIERUNGSTECHNIK_GMBH, true
	case 578:
		return BACnetVendorId_SHINA_SYSTEM_CO_LTD, true
	case 579:
		return BACnetVendorId_IQAPERTUS, true
	case 58:
		return BACnetVendorId_AIR_MONITOR_CORPORATION, true
	case 580:
		return BACnetVendorId_PSE_TECHNOLOGY, true
	case 581:
		return BACnetVendorId_BA_SYSTEMS, true
	case 582:
		return BACnetVendorId_BTICINO, true
	case 583:
		return BACnetVendorId_MONICO_INC, true
	case 584:
		return BACnetVendorId_I_CUE, true
	case 585:
		return BACnetVendorId_TEKMAR_CONTROL_SYSTEMS_LTD, true
	case 586:
		return BACnetVendorId_CONTROL_TECHNOLOGY_CORPORATION, true
	case 587:
		return BACnetVendorId_GFAE_GMBH, true
	case 588:
		return BACnetVendorId_BE_KA_SOFTWARE_GMBH, true
	case 589:
		return BACnetVendorId_ISOIL_INDUSTRIA_SPA, true
	case 59:
		return BACnetVendorId_TRIATEKLLC, true
	case 590:
		return BACnetVendorId_HOME_SYSTEMS_CONSULTING_SPA, true
	case 591:
		return BACnetVendorId_SOCOMEC, true
	case 592:
		return BACnetVendorId_EVEREX_COMMUNICATIONS_INC, true
	case 593:
		return BACnetVendorId_CET_ELECTRIC_TECHNOLOGY_INC, true
	case 594:
		return BACnetVendorId_ATRILA_GMBH, true
	case 595:
		return BACnetVendorId_WING_TECHS, true
	case 596:
		return BACnetVendorId_SHENZHEN_MEK_INTELLISYS_PTE_LTD, true
	case 597:
		return BACnetVendorId_NESTFIELD_CO_LTD, true
	case 598:
		return BACnetVendorId_SWISSPHONE_TELECOMAG, true
	case 599:
		return BACnetVendorId_PNTECHJSC, true
	case 6:
		return BACnetVendorId_ABB_FORMERLY_AMERICAN_AUTO_MATRIX, true
	case 60:
		return BACnetVendorId_NEX_LIGHT, true
	case 600:
		return BACnetVendorId_HORNERAPGLLC, true
	case 601:
		return BACnetVendorId_PVI_INDUSTRIESLLC, true
	case 602:
		return BACnetVendorId_ELACOMPIL, true
	case 603:
		return BACnetVendorId_PEGASUS_AUTOMATION_INTERNATIONALLLC, true
	case 604:
		return BACnetVendorId_WIGHT_ELECTRONIC_SERVICES_LTD, true
	case 605:
		return BACnetVendorId_MARCOM, true
	case 606:
		return BACnetVendorId_EXHAUSTOAS, true
	case 607:
		return BACnetVendorId_DWYER_INSTRUMENTS_INC, true
	case 608:
		return BACnetVendorId_LINK_GMBH, true
	case 609:
		return BACnetVendorId_OPPERMANN_REGELGERATE_GMBH, true
	case 61:
		return BACnetVendorId_MULTISTACK, true
	case 610:
		return BACnetVendorId_NU_AIRE_INC, true
	case 611:
		return BACnetVendorId_NORTEC_HUMIDITY_INC, true
	case 612:
		return BACnetVendorId_BIGWOOD_SYSTEMS_INC, true
	case 613:
		return BACnetVendorId_ENBALA_POWER_NETWORKS, true
	case 614:
		return BACnetVendorId_INTER_ENERGY_CO_LTD, true
	case 615:
		return BACnetVendorId_ETC, true
	case 616:
		return BACnetVendorId_COMELECSARL, true
	case 617:
		return BACnetVendorId_PYTHIA_TECHNOLOGIES, true
	case 618:
		return BACnetVendorId_TREND_POINT_SYSTEMS_INC, true
	case 619:
		return BACnetVendorId_AWEX, true
	case 62:
		return BACnetVendorId_TSI_INCORPORATED, true
	case 620:
		return BACnetVendorId_EUREVIA, true
	case 621:
		return BACnetVendorId_KONGSBERGELONAS, true
	case 622:
		return BACnetVendorId_FLAKT_WOODS, true
	case 623:
		return BACnetVendorId_EE_ELEKTRONIKGESMBH, true
	case 624:
		return BACnetVendorId_ARC_INFORMATIQUE, true
	case 625:
		return BACnetVendorId_SKIDATAAG, true
	case 626:
		return BACnetVendorId_WSW_SOLUTIONS, true
	case 627:
		return BACnetVendorId_TREFON_ELECTRONIC_GMBH, true
	case 628:
		return BACnetVendorId_DONGSEO_SYSTEM, true
	case 629:
		return BACnetVendorId_KANONTEC_INTELLIGENCE_TECHNOLOGY_CO_LTD, true
	case 63:
		return BACnetVendorId_WEATHER_RITE_INC, true
	case 630:
		return BACnetVendorId_EVCO_SPA, true
	case 631:
		return BACnetVendorId_ACCUENERGY_CANADA_INC, true
	case 632:
		return BACnetVendorId_SOFTDEL, true
	case 633:
		return BACnetVendorId_ORION_ENERGY_SYSTEMS_INC, true
	case 634:
		return BACnetVendorId_ROBOTICSWARE, true
	case 635:
		return BACnetVendorId_DOMIQ_SPZOO, true
	case 636:
		return BACnetVendorId_SOLIDYNE, true
	case 637:
		return BACnetVendorId_ELECSYS_CORPORATION, true
	case 638:
		return BACnetVendorId_CONDITIONAIRE_INTERNATIONAL_PTY_LIMITED, true
	case 639:
		return BACnetVendorId_QUEBEC_INC, true
	case 64:
		return BACnetVendorId_DUNHAM_BUSH, true
	case 640:
		return BACnetVendorId_HOMERUN_HOLDINGS, true
	case 641:
		return BACnetVendorId_MURATA_AMERICAS, true
	case 642:
		return BACnetVendorId_COMPTEK, true
	case 643:
		return BACnetVendorId_WESTCO_SYSTEMS_INC, true
	case 644:
		return BACnetVendorId_ADVANCIS_SOFTWARE_SERVICES_GMBH, true
	case 645:
		return BACnetVendorId_INTERGRIDLLC, true
	case 646:
		return BACnetVendorId_MARKERR_CONTROLS_INC, true
	case 647:
		return BACnetVendorId_TOSHIBA_ELEVATORAND_BUILDING_SYSTEMS_CORPORATION, true
	case 648:
		return BACnetVendorId_SPECTRUM_CONTROLS_INC, true
	case 649:
		return BACnetVendorId_MKSERVICE, true
	case 65:
		return BACnetVendorId_RELIANCE_ELECTRIC, true
	case 650:
		return BACnetVendorId_FOX_THERMAL_INSTRUMENTS, true
	case 651:
		return BACnetVendorId_SYXTH_SENSE_LTD, true
	case 652:
		return BACnetVendorId_DUHA_SYSTEMSRO, true
	case 653:
		return BACnetVendorId_NIBE, true
	case 654:
		return BACnetVendorId_MELINK_CORPORATION, true
	case 655:
		return BACnetVendorId_FRITZ_HABER_INSTITUT, true
	case 656:
		return BACnetVendorId_MTU_ONSITE_ENERGY_GMBH_GAS_POWER_SYSTEMS, true
	case 657:
		return BACnetVendorId_OMEGA_ENGINEERING_INC, true
	case 658:
		return BACnetVendorId_AVELON, true
	case 659:
		return BACnetVendorId_YWIRE_TECHNOLOGIES_INC, true
	case 66:
		return BACnetVendorId_LCS_INC, true
	case 660:
		return BACnetVendorId_MR_ENGINEERING_CO_LTD, true
	case 661:
		return BACnetVendorId_LOCHINVARLLC, true
	case 662:
		return BACnetVendorId_SONTAY_LIMITED, true
	case 663:
		return BACnetVendorId_GRUPA_SLAWOMIR_CHELMINSKI, true
	case 664:
		return BACnetVendorId_ARCH_METER_CORPORATION, true
	case 665:
		return BACnetVendorId_SENVA_INC, true
	case 667:
		return BACnetVendorId_FM_TEC, true
	case 668:
		return BACnetVendorId_SYSTEMS_SPECIALISTS_INC, true
	case 669:
		return BACnetVendorId_SENSE_AIR, true
	case 67:
		return BACnetVendorId_REGULATOR_AUSTRALIAPTY_LTD, true
	case 670:
		return BACnetVendorId_AB_INDUSTRIE_TECHNIK_SRL, true
	case 671:
		return BACnetVendorId_CORTLAND_RESEARCHLLC, true
	case 672:
		return BACnetVendorId_MEDIA_VIEW, true
	case 673:
		return BACnetVendorId_VDA_ELETTRONICA, true
	case 674:
		return BACnetVendorId_CSS_INC, true
	case 675:
		return BACnetVendorId_TEK_AIR_SYSTEMS_INC, true
	case 676:
		return BACnetVendorId_ICDT, true
	case 677:
		return BACnetVendorId_THE_ARMSTRONG_MONITORING_CORPORATION, true
	case 678:
		return BACnetVendorId_DIXELL_SRL, true
	case 679:
		return BACnetVendorId_LEAD_SYSTEM_INC, true
	case 68:
		return BACnetVendorId_TOUCH_PLATE_LIGHTING_CONTROLS, true
	case 680:
		return BACnetVendorId_ISM_EURO_CENTERSA, true
	case 681:
		return BACnetVendorId_TDIS, true
	case 682:
		return BACnetVendorId_TRADEFIDES, true
	case 683:
		return BACnetVendorId_KNRR_GMBH_EMERSON_NETWORK_POWER, true
	case 684:
		return BACnetVendorId_RESOURCE_DATA_MANAGEMENT, true
	case 685:
		return BACnetVendorId_ABIES_TECHNOLOGY_INC, true
	case 686:
		return BACnetVendorId_UAB_KOMFOVENT, true
	case 687:
		return BACnetVendorId_MIRAE_ELECTRICAL_MFG_CO_LTD, true
	case 688:
		return BACnetVendorId_HUNTER_DOUGLAS_ARCHITECTURAL_PROJECTS_SCANDINAVIA_APS, true
	case 689:
		return BACnetVendorId_RUNPAQ_GROUP_CO_LTD, true
	case 69:
		return BACnetVendorId_AMANN_GMBH, true
	case 690:
		return BACnetVendorId_UNICARDSA, true
	case 691:
		return BACnetVendorId_IE_TECHNOLOGIES, true
	case 692:
		return BACnetVendorId_RUSKIN_MANUFACTURING, true
	case 693:
		return BACnetVendorId_CALON_ASSOCIATES_LIMITED, true
	case 694:
		return BACnetVendorId_CONTEC_CO_LTD, true
	case 695:
		return BACnetVendorId_IT_GMBH, true
	case 696:
		return BACnetVendorId_AUTANI_CORPORATION, true
	case 697:
		return BACnetVendorId_CHRISTIAN_FORTIN, true
	case 698:
		return BACnetVendorId_HDL, true
	case 699:
		return BACnetVendorId_IPID_SPZOO_LIMITED, true
	case 7:
		return BACnetVendorId_SIEMENS_SCHWEIZAG, true
	case 70:
		return BACnetVendorId_RLE_TECHNOLOGIES, true
	case 700:
		return BACnetVendorId_FUJI_ELECTRIC_CO_LTD, true
	case 701:
		return BACnetVendorId_VIEW_INC, true
	case 702:
		return BACnetVendorId_SAMSUNGS1_CORPORATION, true
	case 703:
		return BACnetVendorId_NEW_LIFT, true
	case 704:
		return BACnetVendorId_VRT_SYSTEMS, true
	case 705:
		return BACnetVendorId_MOTION_CONTROL_ENGINEERING_INC, true
	case 706:
		return BACnetVendorId_WEISS_KLIMATECHNIK_GMBH, true
	case 707:
		return BACnetVendorId_ELKON, true
	case 708:
		return BACnetVendorId_ELIWELL_CONTROLS_SRL, true
	case 709:
		return BACnetVendorId_JAPAN_COMPUTER_TECHNOS_CORP, true
	case 71:
		return BACnetVendorId_CARDKEY_SYSTEMS, true
	case 710:
		return BACnetVendorId_RATIONAL_NETWORKEHF, true
	case 711:
		return BACnetVendorId_MAGNUM_ENERGY_SOLUTIONSLLC, true
	case 712:
		return BACnetVendorId_MEL_ROK, true
	case 713:
		return BACnetVendorId_VAE_GROUP, true
	case 714:
		return BACnetVendorId_LGCNS, true
	case 715:
		return BACnetVendorId_BERGHOF_AUTOMATIONSTECHNIK_GMBH, true
	case 716:
		return BACnetVendorId_QUARK_COMMUNICATIONS_INC, true
	case 717:
		return BACnetVendorId_SONTEX, true
	case 718:
		return BACnetVendorId_MIVUNEAG, true
	case 719:
		return BACnetVendorId_PANDUIT, true
	case 72:
		return BACnetVendorId_SECOM_CO_LTD, true
	case 720:
		return BACnetVendorId_SMART_CONTROLSLLC, true
	case 721:
		return BACnetVendorId_COMPU_AIRE_INC, true
	case 722:
		return BACnetVendorId_SIERRA, true
	case 723:
		return BACnetVendorId_PROTO_SENSE_TECHNOLOGIES, true
	case 724:
		return BACnetVendorId_ELTRAC_TECHNOLOGIES_PVT_LTD, true
	case 725:
		return BACnetVendorId_BEKTAS_INVISIBLE_CONTROLS_GMBH, true
	case 726:
		return BACnetVendorId_ENTELEC, true
	case 727:
		return BACnetVendorId_INNEXIV, true
	case 728:
		return BACnetVendorId_COVENANT, true
	case 729:
		return BACnetVendorId_DAVITORAB, true
	case 73:
		return BACnetVendorId_ABB_GEBUDETECHNIKAG_BEREICH_NET_SERV, true
	case 730:
		return BACnetVendorId_TONG_FANG_TECHNOVATOR, true
	case 731:
		return BACnetVendorId_BUILDING_ROBOTICS_INC, true
	case 732:
		return BACnetVendorId_HSSMSRUG, true
	case 733:
		return BACnetVendorId_FRAM_TACKLLC, true
	case 734:
		return BACnetVendorId_BL_ACOUSTICS_LTD, true
	case 735:
		return BACnetVendorId_TRAXXON_ROCK_DRILLS_LTD, true
	case 736:
		return BACnetVendorId_FRANKE, true
	case 737:
		return BACnetVendorId_WURM_GMBH_CO, true
	case 738:
		return BACnetVendorId_ADDENERGIE, true
	case 739:
		return BACnetVendorId_MIRLE_AUTOMATION_CORPORATION, true
	case 74:
		return BACnetVendorId_KNX_ASSOCIATIONCVBA, true
	case 740:
		return BACnetVendorId_IBIS_NETWORKS, true
	case 741:
		return BACnetVendorId_IDKART_ASRO, true
	case 742:
		return BACnetVendorId_ANAREN_INC, true
	case 743:
		return BACnetVendorId_SPAN_INCORPORATED, true
	case 744:
		return BACnetVendorId_BOSCH_THERMOTECHNOLOGY_CORP, true
	case 745:
		return BACnetVendorId_DRC_TECHNOLOGYSA, true
	case 746:
		return BACnetVendorId_SHANGHAI_ENERGY_BUILDING_TECHNOLOGY_CO_LTD, true
	case 747:
		return BACnetVendorId_FRAPORTAG, true
	case 748:
		return BACnetVendorId_FLOWGROUP, true
	case 749:
		return BACnetVendorId_SKYTRON_ENERGY_GMBH, true
	case 75:
		return BACnetVendorId_INSTITUTEOF_ELECTRICAL_INSTALLATION_ENGINEERSOF_JAPANIEIEJ, true
	case 750:
		return BACnetVendorId_ALTEL_WICHA_GOLDA_SPJ, true
	case 751:
		return BACnetVendorId_DRUPAL, true
	case 752:
		return BACnetVendorId_AXIOMATIC_TECHNOLOGY_LTD, true
	case 753:
		return BACnetVendorId_BOHNKE_PARTNER, true
	case 754:
		return BACnetVendorId_FUNCTION1, true
	case 755:
		return BACnetVendorId_OPTERGY_PTY_LTD, true
	case 756:
		return BACnetVendorId_LSI_VIRTICUS, true
	case 757:
		return BACnetVendorId_KONZEPTPARK_GMBH, true
	case 758:
		return BACnetVendorId_NX_LIGHTING_CONTROLS, true
	case 759:
		return BACnetVendorId_E_CURV_INC, true
	case 76:
		return BACnetVendorId_NOHMI_BOSAI_LTD, true
	case 760:
		return BACnetVendorId_AGNOSYS_GMBH, true
	case 761:
		return BACnetVendorId_SHANGHAI_SUNFULL_AUTOMATION_COLTD, true
	case 762:
		return BACnetVendorId_KURZ_INSTRUMENTS_INC, true
	case 763:
		return BACnetVendorId_CIAS_ELETTRONICA_SRL, true
	case 764:
		return BACnetVendorId_MULTIAQUA_INC, true
	case 765:
		return BACnetVendorId_BLUE_BOX, true
	case 766:
		return BACnetVendorId_SENSIDYNE, true
	case 767:
		return BACnetVendorId_VIESSMANN_ELEKTRONIK_GMBH, true
	case 768:
		return BACnetVendorId_AD_FWEBCOMSRL, true
	case 769:
		return BACnetVendorId_GAYLORD_INDUSTRIES, true
	case 77:
		return BACnetVendorId_CAREL_INDUSTRIES_SPA, true
	case 770:
		return BACnetVendorId_MAJUR_LTD, true
	case 771:
		return BACnetVendorId_SHANGHAI_HUILIN_TECHNOLOGY_CO_LTD, true
	case 772:
		return BACnetVendorId_EXOTRONIC, true
	case 773:
		return BACnetVendorId_SAFECONTRO_LSRO, true
	case 774:
		return BACnetVendorId_AMATIS, true
	case 775:
		return BACnetVendorId_UNIVERSAL_ELECTRIC_CORPORATION, true
	case 776:
		return BACnetVendorId_IBA_CNET, true
	case 778:
		return BACnetVendorId_SMARTRISE_ENGINEERING_INC, true
	case 779:
		return BACnetVendorId_MIRATRON_INC, true
	case 78:
		return BACnetVendorId_UTC_FIRE_SECURITY_ESPAASL, true
	case 780:
		return BACnetVendorId_SMART_EDGE, true
	case 781:
		return BACnetVendorId_MITSUBISHI_ELECTRIC_AUSTRALIA_PTY_LTD, true
	case 782:
		return BACnetVendorId_TRIANGLE_RESEARCH_INTERNATIONAL_PTD_LTD, true
	case 783:
		return BACnetVendorId_PRODUAL_OY, true
	case 784:
		return BACnetVendorId_MILESTONE_SYSTEMSAS, true
	case 785:
		return BACnetVendorId_TRUSTBRIDGE, true
	case 786:
		return BACnetVendorId_FEEDBACK_SOLUTIONS, true
	case 787:
		return BACnetVendorId_IES, true
	case 788:
		return BACnetVendorId_ABB_POWER_PROTECTIONSA, true
	case 789:
		return BACnetVendorId_RIPTIDEIO, true
	case 79:
		return BACnetVendorId_HOCHIKI_CORPORATION, true
	case 790:
		return BACnetVendorId_MESSERSCHMITT_SYSTEMSAG, true
	case 791:
		return BACnetVendorId_DEZEM_ENERGY_CONTROLLING, true
	case 792:
		return BACnetVendorId_MECHO_SYSTEMS, true
	case 793:
		return BACnetVendorId_EVON_GMBH, true
	case 794:
		return BACnetVendorId_CS_LAB_GMBH, true
	case 795:
		return BACnetVendorId_N_0_ENTERPRISES_INC, true
	case 796:
		return BACnetVendorId_TOUCHE_CONTROLS, true
	case 797:
		return BACnetVendorId_ONTROL_TEKNIK_MALZEME_SANVE_TICAS, true
	case 798:
		return BACnetVendorId_UNI_CONTROL_SYSTEM_SP_ZOO, true
	case 799:
		return BACnetVendorId_WEIHAI_PLOUMETER_CO_LTD, true
	case 8:
		return BACnetVendorId_DELTA_CONTROLS, true
	case 80:
		return BACnetVendorId_FR_SAUTERAG, true
	case 800:
		return BACnetVendorId_ELCOM_INTERNATIONAL_PVT_LTD, true
	case 801:
		return BACnetVendorId_SIGNIFY, true
	case 802:
		return BACnetVendorId_AUTOMATION_DIRECT, true
	case 803:
		return BACnetVendorId_PARAGON_ROBOTICS, true
	case 804:
		return BACnetVendorId_SMT_SYSTEM_MODULES_TECHNOLOGYAG, true
	case 805:
		return BACnetVendorId_RADIX_IOTLLC, true
	case 806:
		return BACnetVendorId_CMR_CONTROLS_LTD, true
	case 807:
		return BACnetVendorId_INNOVARI_INC, true
	case 808:
		return BACnetVendorId_ABB_CONTROL_PRODUCTS, true
	case 809:
		return BACnetVendorId_GESELLSCHAFTFUR_GEBUDEAUTOMATIONMBH, true
	case 81:
		return BACnetVendorId_MATSUSHITA_ELECTRIC_WORKS_LTD, true
	case 810:
		return BACnetVendorId_RODI_SYSTEMS_CORP, true
	case 811:
		return BACnetVendorId_NEXTEK_POWER_SYSTEMS, true
	case 812:
		return BACnetVendorId_CREATIVE_LIGHTING, true
	case 813:
		return BACnetVendorId_WATER_FURNACE_INTERNATIONAL, true
	case 814:
		return BACnetVendorId_MERCURY_SECURITY, true
	case 815:
		return BACnetVendorId_HISENSE_SHANDONG_AIR_CONDITIONING_CO_LTD, true
	case 816:
		return BACnetVendorId_LAYERED_SOLUTIONS_INC, true
	case 817:
		return BACnetVendorId_LEEGOOD_AUTOMATIC_SYSTEM_INC, true
	case 818:
		return BACnetVendorId_SHANGHAI_RESTAR_TECHNOLOGY_CO_LTD, true
	case 819:
		return BACnetVendorId_REIMANN_INGENIEURBRO, true
	case 82:
		return BACnetVendorId_MITSUBISHI_ELECTRIC_CORPORATION_INAZAWA_WORKS, true
	case 820:
		return BACnetVendorId_LYN_TEC, true
	case 821:
		return BACnetVendorId_HTP, true
	case 822:
		return BACnetVendorId_ELKOR_TECHNOLOGIES_INC, true
	case 823:
		return BACnetVendorId_BENTROL_PTY_LTD, true
	case 824:
		return BACnetVendorId_TEAM_CONTROL_OY, true
	case 825:
		return BACnetVendorId_NEXT_DEVICELLC, true
	case 826:
		return BACnetVendorId_ISMACONTROLLI_SPA, true
	case 827:
		return BACnetVendorId_KINGI_ELECTRONICS_CO_LTD, true
	case 828:
		return BACnetVendorId_SAMDAV, true
	case 829:
		return BACnetVendorId_NEXT_GEN_INDUSTRIES_PVT_LTD, true
	case 83:
		return BACnetVendorId_MITSUBISHI_HEAVY_INDUSTRIES_LTD, true
	case 830:
		return BACnetVendorId_ENTICLLC, true
	case 831:
		return BACnetVendorId_ETAP, true
	case 832:
		return BACnetVendorId_MORALLE_ELECTRONICS_LIMITED, true
	case 833:
		return BACnetVendorId_LEICOMAG, true
	case 834:
		return BACnetVendorId_WATTS_REGULATOR_COMPANY, true
	case 835:
		return BACnetVendorId_SC_ORBTRONICSSRL, true
	case 836:
		return BACnetVendorId_GAUSSAN_TECHNOLOGIES, true
	case 837:
		return BACnetVendorId_WE_BFACTORY_GMBH, true
	case 838:
		return BACnetVendorId_OCEAN_CONTROLS, true
	case 839:
		return BACnetVendorId_MESSANA_AIR_RAY_CONDITIONINGSRL, true
	case 84:
		return BACnetVendorId_XYLEM_INC, true
	case 840:
		return BACnetVendorId_HANGZHOUBATOWN_TECHNOLOGY_CO_LTD, true
	case 841:
		return BACnetVendorId_REASONABLE_CONTROLS, true
	case 842:
		return BACnetVendorId_SERVISYS_INC, true
	case 843:
		return BACnetVendorId_HALSTRUPWALCHER_GMBH, true
	case 844:
		return BACnetVendorId_SWG_AUTOMATION_FUZHOU_LIMITED, true
	case 845:
		return BACnetVendorId_KSB_AKTIENGESELLSCHAFT, true
	case 846:
		return BACnetVendorId_HYBRYD_SPZOO, true
	case 847:
		return BACnetVendorId_HELVATRONAG, true
	case 848:
		return BACnetVendorId_ODERON_SPZOO, true
	case 849:
		return BACnetVendorId_MIKOLAB, true
	case 85:
		return BACnetVendorId_YAMATAKE_BUILDING_SYSTEMS_CO_LTD, true
	case 850:
		return BACnetVendorId_EXODRAFT, true
	case 851:
		return BACnetVendorId_HOCHHUTH_GMBH, true
	case 852:
		return BACnetVendorId_INTEGRATED_SYSTEM_TECHNOLOGIES_LTD, true
	case 853:
		return BACnetVendorId_SHANGHAI_CELLCONS_CONTROLS_CO_LTD, true
	case 854:
		return BACnetVendorId_EMME_CONTROLSLLC, true
	case 855:
		return BACnetVendorId_FIELD_DIAGNOSTIC_SERVICES_INC, true
	case 856:
		return BACnetVendorId_GES_TEKNIKAS, true
	case 857:
		return BACnetVendorId_GLOBAL_POWER_PRODUCTS_INC, true
	case 858:
		return BACnetVendorId_OPTIONNV, true
	case 859:
		return BACnetVendorId_BV_CONTROLAG, true
	case 86:
		return BACnetVendorId_THE_WATT_STOPPER_INC, true
	case 860:
		return BACnetVendorId_SIGREN_ENGINEERINGAG, true
	case 861:
		return BACnetVendorId_SHANGHAI_JALTONE_TECHNOLOGY_CO_LTD, true
	case 862:
		return BACnetVendorId_MAX_LINE_SOLUTIONS_LTD, true
	case 863:
		return BACnetVendorId_KRON_INSTRUMENTOS_ELTRICOS_LTDA, true
	case 864:
		return BACnetVendorId_THERMO_MATRIX, true
	case 865:
		return BACnetVendorId_INFINITE_AUTOMATION_SYSTEMS_INC, true
	case 866:
		return BACnetVendorId_VANTAGE, true
	case 867:
		return BACnetVendorId_ELECON_MEASUREMENTS_PVT_LTD, true
	case 868:
		return BACnetVendorId_TBA, true
	case 869:
		return BACnetVendorId_CARNES_COMPANY, true
	case 87:
		return BACnetVendorId_AICHI_TOKEI_DENKI_CO_LTD, true
	case 870:
		return BACnetVendorId_HARMAN_PROFESSIONAL, true
	case 871:
		return BACnetVendorId_NENUTEC_ASIA_PACIFIC_PTE_LTD, true
	case 872:
		return BACnetVendorId_GIANV, true
	case 873:
		return BACnetVendorId_KEPWARE_TEHNOLOGIES, true
	case 874:
		return BACnetVendorId_TEMPERATURE_ELECTRONICS_LTD, true
	case 875:
		return BACnetVendorId_PACKET_POWER, true
	case 876:
		return BACnetVendorId_PROJECT_HAYSTACK_CORPORATION, true
	case 877:
		return BACnetVendorId_DEOS_CONTROLS_AMERICAS_INC, true
	case 878:
		return BACnetVendorId_SENSEWARE_INC, true
	case 879:
		return BACnetVendorId_MST_SYSTEMTECHNIKAG, true
	case 88:
		return BACnetVendorId_ACTIVATION_TECHNOLOGIESLLC, true
	case 880:
		return BACnetVendorId_LONIX_LTD, true
	case 881:
		return BACnetVendorId_GOSSEN_METRAWATT_GMBH, true
	case 882:
		return BACnetVendorId_AVIOSYS_INTERNATIONAL_INC, true
	case 883:
		return BACnetVendorId_EFFICIENT_BUILDING_AUTOMATION_CORP, true
	case 884:
		return BACnetVendorId_ACCUTRON_INSTRUMENTS_INC, true
	case 885:
		return BACnetVendorId_VERMONT_ENERGY_CONTROL_SYSTEMSLLC, true
	case 886:
		return BACnetVendorId_DCC_DYNAMICS, true
	case 887:
		return BACnetVendorId_BEG_BRCK_ELECTRONIC_GMBH, true
	case 889:
		return BACnetVendorId_NGBS_HUNGARY_LTD, true
	case 89:
		return BACnetVendorId_SAIA_BURGESS_CONTROLS_LTD, true
	case 890:
		return BACnetVendorId_ILLUM_TECHNOLOGYLLC, true
	case 891:
		return BACnetVendorId_DELTA_CONTROLS_GERMANY_LIMITED, true
	case 892:
		return BACnetVendorId_ST_SERVICE_TECHNIQUESA, true
	case 893:
		return BACnetVendorId_SIMPLE_SOFT, true
	case 894:
		return BACnetVendorId_ALTAIR_ENGINEERING, true
	case 895:
		return BACnetVendorId_EZEN_SOLUTION_INC, true
	case 896:
		return BACnetVendorId_FUJITEC_CO_LTD, true
	case 897:
		return BACnetVendorId_TERRALUX, true
	case 898:
		return BACnetVendorId_ANNICOM, true
	case 899:
		return BACnetVendorId_BIHL_WIEDEMANN_GMBH, true
	case 9:
		return BACnetVendorId_SIEMENS_SCHWEIZAG1, true
	case 90:
		return BACnetVendorId_HITACHI_LTD, true
	case 900:
		return BACnetVendorId_DRAPER_INC, true
	case 901:
		return BACnetVendorId_SCHCO_INTERNATIONALKG, true
	case 902:
		return BACnetVendorId_OTIS_ELEVATOR_COMPANY, true
	case 903:
		return BACnetVendorId_FIDELIX_OY, true
	case 904:
		return BACnetVendorId_RAM_GMBH_MESSUND_REGELTECHNIK, true
	case 905:
		return BACnetVendorId_WEMS, true
	case 906:
		return BACnetVendorId_RAVEL_ELECTRONICS_PVT_LTD, true
	case 907:
		return BACnetVendorId_OMNI_MAGNI, true
	case 908:
		return BACnetVendorId_ECHELON, true
	case 909:
		return BACnetVendorId_INTELLIMETER_CANADA_INC, true
	case 91:
		return BACnetVendorId_NOVAR_CORP_TREND_CONTROL_SYSTEMS_LTD, true
	case 910:
		return BACnetVendorId_BITHOUSE_OY, true
	case 912:
		return BACnetVendorId_BUILD_PULSE, true
	case 913:
		return BACnetVendorId_SHENZHEN1000_BUILDING_AUTOMATION_CO_LTD, true
	case 914:
		return BACnetVendorId_AED_ENGINEERING_GMBH, true
	case 915:
		return BACnetVendorId_GNTNER_GMBH_COKG, true
	case 916:
		return BACnetVendorId_KN_XLOGIC, true
	case 917:
		return BACnetVendorId_CIM_ENVIRONMENTAL_GROUP, true
	case 918:
		return BACnetVendorId_FLOW_CONTROL, true
	case 919:
		return BACnetVendorId_LUMEN_CACHE_INC, true
	case 92:
		return BACnetVendorId_MITSUBISHI_ELECTRIC_LIGHTING_CORPORATION, true
	case 920:
		return BACnetVendorId_ECOSYSTEM, true
	case 921:
		return BACnetVendorId_POTTER_ELECTRIC_SIGNAL_COMPANYLLC, true
	case 922:
		return BACnetVendorId_TYCO_FIRE_SECURITY_SPA, true
	case 923:
		return BACnetVendorId_WATANABE_ELECTRIC_INDUSTRY_CO_LTD, true
	case 924:
		return BACnetVendorId_CAUSAM_ENERGY, true
	case 925:
		return BACnetVendorId_WTECAG, true
	case 926:
		return BACnetVendorId_IMI_HYDRONIC_ENGINEERING_INTERNATIONALSA, true
	case 927:
		return BACnetVendorId_ARIGO_SOFTWARE, true
	case 928:
		return BACnetVendorId_MSA_SAFETY1, true
	case 929:
		return BACnetVendorId_SMART_SOLUCOES_LTDAMERCATO, true
	case 93:
		return BACnetVendorId_ARGUS_CONTROL_SYSTEMS_LTD, true
	case 930:
		return BACnetVendorId_PIATRA_ENGINEERING, true
	case 931:
		return BACnetVendorId_ODIN_AUTOMATION_SYSTEMSLLC, true
	case 932:
		return BACnetVendorId_BELPARTSNV, true
	case 933:
		return BACnetVendorId_UABSALDA, true
	case 934:
		return BACnetVendorId_ALREIT_REGELTECHNIK_GMBH, true
	case 935:
		return BACnetVendorId_INGENIEURBROH_LERTES_GMBH_COKG, true
	case 936:
		return BACnetVendorId_BREATHING_BUILDINGS, true
	case 937:
		return BACnetVendorId_EWONSA, true
	case 938:
		return BACnetVendorId_CAV_UFF_GIACOMO_CIMBERIO_SPA, true
	case 939:
		return BACnetVendorId_PKE_ELECTRONICSAG, true
	case 94:
		return BACnetVendorId_KYUKI_CORPORATION, true
	case 940:
		return BACnetVendorId_ALLEN, true
	case 941:
		return BACnetVendorId_KASTLE_SYSTEMS, true
	case 942:
		return BACnetVendorId_LOGICAL_ELECTRO_MECHANICALEM_SYSTEMS_INC, true
	case 943:
		return BACnetVendorId_PP_KINETICS_INSTRUMENTSLLC, true
	case 944:
		return BACnetVendorId_CATHEXIS_TECHNOLOGIES, true
	case 945:
		return BACnetVendorId_SYLOPSP_ZOOSPK, true
	case 946:
		return BACnetVendorId_BRAUNS_CONTROL_GMBH, true
	case 947:
		return BACnetVendorId_OMRONSOCIALSOLUTIONSCOLTD, true
	case 948:
		return BACnetVendorId_WILDEBOER_BAUTEILE_GMBH, true
	case 949:
		return BACnetVendorId_SHANGHAI_BIENS_TECHNOLOGIES_LTD, true
	case 95:
		return BACnetVendorId_RICHARDS_ZETA_BUILDING_INTELLIGENCE_INC, true
	case 950:
		return BACnetVendorId_BEIJINGHZHY_TECHNOLOGY_CO_LTD, true
	case 951:
		return BACnetVendorId_BUILDING_CLOUDS, true
	case 952:
		return BACnetVendorId_THE_UNIVERSITYOF_SHEFFIELD_DEPARTMENTOF_ELECTRONICAND_ELECTRICAL_ENGINEERING, true
	case 953:
		return BACnetVendorId_FABTRONICS_AUSTRALIA_PTY_LTD, true
	case 954:
		return BACnetVendorId_SLAT, true
	case 955:
		return BACnetVendorId_SOFTWARE_MOTOR_CORPORATION, true
	case 956:
		return BACnetVendorId_ARMSTRONG_INTERNATIONAL_INC, true
	case 957:
		return BACnetVendorId_STERIL_AIRE_INC, true
	case 958:
		return BACnetVendorId_INFINIQUE, true
	case 959:
		return BACnetVendorId_ARCOM, true
	case 96:
		return BACnetVendorId_SCIENTECHRD_INC, true
	case 960:
		return BACnetVendorId_ARGO_PERFORMANCE_LTD, true
	case 961:
		return BACnetVendorId_DIALIGHT, true
	case 962:
		return BACnetVendorId_IDEAL_TECHNICAL_SOLUTIONS, true
	case 963:
		return BACnetVendorId_NEUROBATAG, true
	case 964:
		return BACnetVendorId_NEYER_SOFTWARE_CONSULTINGLLC, true
	case 965:
		return BACnetVendorId_SCADA_TECHNOLOGY_DEVELOPMENT_CO_LTD, true
	case 966:
		return BACnetVendorId_DEMAND_LOGIC_LIMITED, true
	case 967:
		return BACnetVendorId_GWA_GROUP_LIMITED, true
	case 968:
		return BACnetVendorId_OCCITALINE, true
	case 969:
		return BACnetVendorId_NAO_DIGITAL_CO_LTD, true
	case 97:
		return BACnetVendorId_VCI_CONTROLS_INC, true
	case 970:
		return BACnetVendorId_SHENZHEN_CHANSLINK_NETWORK_TECHNOLOGY_CO_LTD, true
	case 971:
		return BACnetVendorId_SAMSUNG_ELECTRONICS_CO_LTD, true
	case 972:
		return BACnetVendorId_MESA_LABORATORIES_INC, true
	case 973:
		return BACnetVendorId_FISCHER, true
	case 974:
		return BACnetVendorId_OP_SYS_SOLUTIONS_LTD, true
	case 975:
		return BACnetVendorId_ADVANCED_DEVICES_LIMITED, true
	case 976:
		return BACnetVendorId_CONDAIR, true
	case 977:
		return BACnetVendorId_INELCOM_INGENIERIA_ELECTRONICA_COMERCIALSA, true
	case 978:
		return BACnetVendorId_GRID_POINT_INC, true
	case 979:
		return BACnetVendorId_ADF_TECHNOLOGIES_SDN_BHD, true
	case 98:
		return BACnetVendorId_TOSHIBA_CORPORATION, true
	case 980:
		return BACnetVendorId_EPM_INC, true
	case 981:
		return BACnetVendorId_LIGHTING_CONTROLS_LTD, true
	case 982:
		return BACnetVendorId_PERIX_CONTROLS_LTD, true
	case 983:
		return BACnetVendorId_AERCO_INTERNATIONAL_INC, true
	case 984:
		return BACnetVendorId_KONE_INC, true
	case 985:
		return BACnetVendorId_ZIEHL_ABEGGSE, true
	case 986:
		return BACnetVendorId_ROBOTSA, true
	case 987:
		return BACnetVendorId_OPTIGO_NETWORKS_INC, true
	case 988:
		return BACnetVendorId_OPENMOTICSBVBA, true
	case 989:
		return BACnetVendorId_METROPOLITAN_INDUSTRIES_INC, true
	case 99:
		return BACnetVendorId_MITSUBISHI_ELECTRIC_CORPORATION_AIR_CONDITIONING_REFRIGERATION_SYSTEMS_WORKS, true
	case 990:
		return BACnetVendorId_HUAWEI_TECHNOLOGIES_CO_LTD, true
	case 991:
		return BACnetVendorId_DIGITAL_LUMENS_INC, true
	case 992:
		return BACnetVendorId_VANTI, true
	case 993:
		return BACnetVendorId_CREE_LIGHTING, true
	case 994:
		return BACnetVendorId_RICHMOND_HEIGHTSSDNBHD, true
	case 995:
		return BACnetVendorId_PAYNE_SPARKMAN_LIGHTING_MANGEMENT, true
	case 996:
		return BACnetVendorId_ASHCROFT, true
	case 997:
		return BACnetVendorId_JET_CONTROLS_CORP, true
	case 998:
		return BACnetVendorId_ZUMTOBEL_LIGHTING_GMBH, true
	}
	return 0, false
}

func BACnetVendorIdByName(value string) (enum BACnetVendorId, ok bool) {
	switch value {
	case "ASHRAE":
		return BACnetVendorId_ASHRAE, true
	case "UNKNOWN_VENDOR":
		return BACnetVendorId_UNKNOWN_VENDOR, true
	case "NIST":
		return BACnetVendorId_NIST, true
	case "SCHNEIDER_ELECTRIC":
		return BACnetVendorId_SCHNEIDER_ELECTRIC, true
	case "CUSTOM_MECHANICAL_EQUIPMENTLLC":
		return BACnetVendorId_CUSTOM_MECHANICAL_EQUIPMENTLLC, true
	case "EKON_GMBH":
		return BACnetVendorId_EKON_GMBH, true
	case "MOLEX":
		return BACnetVendorId_MOLEX, true
	case "MACO_LIGHTING_PTY_LTD":
		return BACnetVendorId_MACO_LIGHTING_PTY_LTD, true
	case "AXECON_CORP":
		return BACnetVendorId_AXECON_CORP, true
	case "TENSORPLC":
		return BACnetVendorId_TENSORPLC, true
	case "KASEMAN_ENVIRONMENTAL_CONTROL_EQUIPMENT_SHANGHAI_LIMITED":
		return BACnetVendorId_KASEMAN_ENVIRONMENTAL_CONTROL_EQUIPMENT_SHANGHAI_LIMITED, true
	case "AB_AXIS_INDUSTRIES":
		return BACnetVendorId_AB_AXIS_INDUSTRIES, true
	case "NETIX_CONTROLS":
		return BACnetVendorId_NETIX_CONTROLS, true
	case "ELDRIDGE_PRODUCTS_INC":
		return BACnetVendorId_ELDRIDGE_PRODUCTS_INC, true
	case "MICRONICS":
		return BACnetVendorId_MICRONICS, true
	case "CLIMATE_MASTER":
		return BACnetVendorId_CLIMATE_MASTER, true
	case "FORTECHO_SOLUTIONS_LTD":
		return BACnetVendorId_FORTECHO_SOLUTIONS_LTD, true
	case "SELLERS_MANUFACTURING_COMPANY":
		return BACnetVendorId_SELLERS_MANUFACTURING_COMPANY, true
	case "RITE_HITE_DOORS_INC":
		return BACnetVendorId_RITE_HITE_DOORS_INC, true
	case "VIOLET_DEFENSELLC":
		return BACnetVendorId_VIOLET_DEFENSELLC, true
	case "SIMNA":
		return BACnetVendorId_SIMNA, true
	case "MULTINERGIE_BEST_INC":
		return BACnetVendorId_MULTINERGIE_BEST_INC, true
	case "MEGA_SYSTEM_TECHNOLOGIES_INC":
		return BACnetVendorId_MEGA_SYSTEM_TECHNOLOGIES_INC, true
	case "RHEEM":
		return BACnetVendorId_RHEEM, true
	case "ING_PUNZENBERGERCOPADATA_GMBH":
		return BACnetVendorId_ING_PUNZENBERGERCOPADATA_GMBH, true
	case "MEC_ELECTRONICS_GMBH":
		return BACnetVendorId_MEC_ELECTRONICS_GMBH, true
	case "ICP_PANEL_TEC_INC":
		return BACnetVendorId_ICP_PANEL_TEC_INC, true
	case "TACO_COMFORT_SOLUTIONS":
		return BACnetVendorId_TACO_COMFORT_SOLUTIONS, true
	case "ALEXANDER_MAIER_GMBH":
		return BACnetVendorId_ALEXANDER_MAIER_GMBH, true
	case "ECORITHM_INC":
		return BACnetVendorId_ECORITHM_INC, true
	case "ACCURRO_LTD":
		return BACnetVendorId_ACCURRO_LTD, true
	case "ROMTECK_AUSTRALIA_PTY_LTD":
		return BACnetVendorId_ROMTECK_AUSTRALIA_PTY_LTD, true
	case "SPLASH_MONITORING_LIMITED":
		return BACnetVendorId_SPLASH_MONITORING_LIMITED, true
	case "LIGHT_APPLICATION":
		return BACnetVendorId_LIGHT_APPLICATION, true
	case "LOGICAL_BUILDING_AUTOMATION":
		return BACnetVendorId_LOGICAL_BUILDING_AUTOMATION, true
	case "EXILIGHT_OY":
		return BACnetVendorId_EXILIGHT_OY, true
	case "HAGER_ELECTROSAS":
		return BACnetVendorId_HAGER_ELECTROSAS, true
	case "D_TEK_CONTROLS":
		return BACnetVendorId_D_TEK_CONTROLS, true
	case "KLIF_COLTD":
		return BACnetVendorId_KLIF_COLTD, true
	case "HYGRO_MATIK":
		return BACnetVendorId_HYGRO_MATIK, true
	case "DANIEL_MOUSSEAU_PROGRAMMATION_ELECTRONIQUE":
		return BACnetVendorId_DANIEL_MOUSSEAU_PROGRAMMATION_ELECTRONIQUE, true
	case "AERIONICS_INC":
		return BACnetVendorId_AERIONICS_INC, true
	case "MS_ELECTRONIQUE_LTEE":
		return BACnetVendorId_MS_ELECTRONIQUE_LTEE, true
	case "AUTOMATION_COMPONENTS_INC":
		return BACnetVendorId_AUTOMATION_COMPONENTS_INC, true
	case "NIOBRARA_RESEARCH_DEVELOPMENT_CORPORATION":
		return BACnetVendorId_NIOBRARA_RESEARCH_DEVELOPMENT_CORPORATION, true
	case "NETCOM_SICHERHEITSTECHNIK_GMBH":
		return BACnetVendorId_NETCOM_SICHERHEITSTECHNIK_GMBH, true
	case "LUMELSA":
		return BACnetVendorId_LUMELSA, true
	case "GREAT_PLAINS_INDUSTRIES_INC":
		return BACnetVendorId_GREAT_PLAINS_INDUSTRIES_INC, true
	case "NEC_ENGINEERING_LTD":
		return BACnetVendorId_NEC_ENGINEERING_LTD, true
	case "DOMOTICA_LABSSRL":
		return BACnetVendorId_DOMOTICA_LABSSRL, true
	case "ENERGY_CLOUD_INC":
		return BACnetVendorId_ENERGY_CLOUD_INC, true
	case "VOMATEC":
		return BACnetVendorId_VOMATEC, true
	case "DEMMA_COMPANIES":
		return BACnetVendorId_DEMMA_COMPANIES, true
	case "VALSENA":
		return BACnetVendorId_VALSENA, true
	case "COMSYS_BRTSCHAG":
		return BACnetVendorId_COMSYS_BRTSCHAG, true
	case "B_GRID":
		return BACnetVendorId_B_GRID, true
	case "MDJ_SOFTWARE_PTY_LTD":
		return BACnetVendorId_MDJ_SOFTWARE_PTY_LTD, true
	case "DIMONOFF_INC":
		return BACnetVendorId_DIMONOFF_INC, true
	case "EDOMO_SYSTEMS_GMBH":
		return BACnetVendorId_EDOMO_SYSTEMS_GMBH, true
	case "PRIVABV":
		return BACnetVendorId_PRIVABV, true
	case "EFFEKTIVLLC":
		return BACnetVendorId_EFFEKTIVLLC, true
	case "STEAMO_VAP":
		return BACnetVendorId_STEAMO_VAP, true
	case "GRANDCENTRIX_GMBH":
		return BACnetVendorId_GRANDCENTRIX_GMBH, true
	case "WEINTEK_LABS_INC":
		return BACnetVendorId_WEINTEK_LABS_INC, true
	case "INTEFOX_GMBH":
		return BACnetVendorId_INTEFOX_GMBH, true
	case "RADIUS_AUTOMATION_COMPANY":
		return BACnetVendorId_RADIUS_AUTOMATION_COMPANY, true
	case "RINGDALE_INC":
		return BACnetVendorId_RINGDALE_INC, true
	case "IWAKI_AMERICA":
		return BACnetVendorId_IWAKI_AMERICA, true
	case "BRACTLET":
		return BACnetVendorId_BRACTLET, true
	case "STULZ_AIR_TECHNOLOGY_SYSTEMS_INC":
		return BACnetVendorId_STULZ_AIR_TECHNOLOGY_SYSTEMS_INC, true
	case "MEIDENSHA_CORPORATION":
		return BACnetVendorId_MEIDENSHA_CORPORATION, true
	case "CLIMATE_READY_ENGINEERING_PTY_LTD":
		return BACnetVendorId_CLIMATE_READY_ENGINEERING_PTY_LTD, true
	case "GENEA_ENERGY_PARTNERS":
		return BACnetVendorId_GENEA_ENERGY_PARTNERS, true
	case "IO_TALL_CHILE":
		return BACnetVendorId_IO_TALL_CHILE, true
	case "IKS_CO_LTD":
		return BACnetVendorId_IKS_CO_LTD, true
	case "YODIWOAB":
		return BACnetVendorId_YODIWOAB, true
	case "TITA_NELECTRONIC_GMBH":
		return BACnetVendorId_TITA_NELECTRONIC_GMBH, true
	case "IDEC_CORPORATION":
		return BACnetVendorId_IDEC_CORPORATION, true
	case "SIFRISL":
		return BACnetVendorId_SIFRISL, true
	case "THERMAL_GAS_SYSTEMS_INC":
		return BACnetVendorId_THERMAL_GAS_SYSTEMS_INC, true
	case "BUILDING_AUTOMATION_PRODUCTS_INC":
		return BACnetVendorId_BUILDING_AUTOMATION_PRODUCTS_INC, true
	case "JCI_SYSTEMS_INTEGRATION_SERVICES":
		return BACnetVendorId_JCI_SYSTEMS_INTEGRATION_SERVICES, true
	case "ASSET_MAPPING":
		return BACnetVendorId_ASSET_MAPPING, true
	case "SMARTEH_COMPANY":
		return BACnetVendorId_SMARTEH_COMPANY, true
	case "DATAPOD_AUSTRALIA_PTY_LTD":
		return BACnetVendorId_DATAPOD_AUSTRALIA_PTY_LTD, true
	case "BUILDINGS_ALIVE_PTY_LTD":
		return BACnetVendorId_BUILDINGS_ALIVE_PTY_LTD, true
	case "DIGITAL_ELEKTRONIK":
		return BACnetVendorId_DIGITAL_ELEKTRONIK, true
	case "TALENT_AUTOMAOE_TECNOLOGIA_LTDA":
		return BACnetVendorId_TALENT_AUTOMAOE_TECNOLOGIA_LTDA, true
	case "NORPOSH_LIMITED":
		return BACnetVendorId_NORPOSH_LIMITED, true
	case "MERKUR_FUNKSYSTEMEAG":
		return BACnetVendorId_MERKUR_FUNKSYSTEMEAG, true
	case "FASTERC_ZSPOL_SRO":
		return BACnetVendorId_FASTERC_ZSPOL_SRO, true
	case "ECO_ADAPT":
		return BACnetVendorId_ECO_ADAPT, true
	case "FREEDOM_CORPORATION":
		return BACnetVendorId_FREEDOM_CORPORATION, true
	case "ENERGOCENTRUM_PLUSSRO":
		return BACnetVendorId_ENERGOCENTRUM_PLUSSRO, true
	case "AMBXUK_LTD":
		return BACnetVendorId_AMBXUK_LTD, true
	case "WESTERN_RESERVE_CONTROLS_INC":
		return BACnetVendorId_WESTERN_RESERVE_CONTROLS_INC, true
	case "LAYER_ZERO_POWER_SYSTEMS_INC":
		return BACnetVendorId_LAYER_ZERO_POWER_SYSTEMS_INC, true
	case "CIC_JAN_HEBECSRO":
		return BACnetVendorId_CIC_JAN_HEBECSRO, true
	case "SIGROVBV":
		return BACnetVendorId_SIGROVBV, true
	case "ISYS_INTELLIGENT_SYSTEMS":
		return BACnetVendorId_ISYS_INTELLIGENT_SYSTEMS, true
	case "GAS_DETECTION_AUSTRALIA_PTY_LTD":
		return BACnetVendorId_GAS_DETECTION_AUSTRALIA_PTY_LTD, true
	case "KINCO_AUTOMATION_SHANGHAI_LTD":
		return BACnetVendorId_KINCO_AUTOMATION_SHANGHAI_LTD, true
	case "LARS_ENERGYLLC":
		return BACnetVendorId_LARS_ENERGYLLC, true
	case "NEUBERGER_GEBUDEAUTOMATION_GMBH":
		return BACnetVendorId_NEUBERGER_GEBUDEAUTOMATION_GMBH, true
	case "FLAMEFASTUK_LTD":
		return BACnetVendorId_FLAMEFASTUK_LTD, true
	case "ROYAL_SERVICE_AIR_CONDITIONING":
		return BACnetVendorId_ROYAL_SERVICE_AIR_CONDITIONING, true
	case "AMPIO_SP_ZOO":
		return BACnetVendorId_AMPIO_SP_ZOO, true
	case "INOVONICS_WIRELESS_CORPORATION":
		return BACnetVendorId_INOVONICS_WIRELESS_CORPORATION, true
	case "NVENT_THERMAL_MANAGEMENT":
		return BACnetVendorId_NVENT_THERMAL_MANAGEMENT, true
	case "SINOWELL_CONTROL_SYSTEM_LTD":
		return BACnetVendorId_SINOWELL_CONTROL_SYSTEM_LTD, true
	case "MOXA_INC":
		return BACnetVendorId_MOXA_INC, true
	case "MATRIXI_CONTROLSDNBHD":
		return BACnetVendorId_MATRIXI_CONTROLSDNBHD, true
	case "PURPLE_SWIFT":
		return BACnetVendorId_PURPLE_SWIFT, true
	case "OTIM_TECHNOLOGIES":
		return BACnetVendorId_OTIM_TECHNOLOGIES, true
	case "TAC":
		return BACnetVendorId_TAC, true
	case "E_ZI_CONTROLS":
		return BACnetVendorId_E_ZI_CONTROLS, true
	case "FLOW_MATE_LIMITED":
		return BACnetVendorId_FLOW_MATE_LIMITED, true
	case "DEGREE_CONTROLS_INC":
		return BACnetVendorId_DEGREE_CONTROLS_INC, true
	case "FEI_XING_SHANGHAI_SOFTWARE_TECHNOLOGIES_CO_LTD":
		return BACnetVendorId_FEI_XING_SHANGHAI_SOFTWARE_TECHNOLOGIES_CO_LTD, true
	case "BERG_GMBH":
		return BACnetVendorId_BERG_GMBH, true
	case "ARENZIT":
		return BACnetVendorId_ARENZIT, true
	case "EDELSTROM_ELECTRONIC_DEVICES_DESIGNINGLLC":
		return BACnetVendorId_EDELSTROM_ELECTRONIC_DEVICES_DESIGNINGLLC, true
	case "DRIVE_CONNECTLLC":
		return BACnetVendorId_DRIVE_CONNECTLLC, true
	case "DEVELOP_NOW":
		return BACnetVendorId_DEVELOP_NOW, true
	case "POORT":
		return BACnetVendorId_POORT, true
	case "VMEIL_INFORMATION_SHANGHAI_LTD":
		return BACnetVendorId_VMEIL_INFORMATION_SHANGHAI_LTD, true
	case "LEVITON_MANUFACTURING":
		return BACnetVendorId_LEVITON_MANUFACTURING, true
	case "RAYLEIGH_INSTRUMENTS":
		return BACnetVendorId_RAYLEIGH_INSTRUMENTS, true
	case "CODESYS_DEVELOPMENT":
		return BACnetVendorId_CODESYS_DEVELOPMENT, true
	case "SMARTWARE_TECHNOLOGIES_GROUPLLC":
		return BACnetVendorId_SMARTWARE_TECHNOLOGIES_GROUPLLC, true
	case "POLAR_BEAR_SOLUTIONS":
		return BACnetVendorId_POLAR_BEAR_SOLUTIONS, true
	case "CODRA":
		return BACnetVendorId_CODRA, true
	case "PHAROS_ARCHITECTURAL_CONTROLS_LTD":
		return BACnetVendorId_PHAROS_ARCHITECTURAL_CONTROLS_LTD, true
	case "ENGI_NEAR_LTD":
		return BACnetVendorId_ENGI_NEAR_LTD, true
	case "AD_HOC_ELECTRONICS":
		return BACnetVendorId_AD_HOC_ELECTRONICS, true
	case "UNIFIED_MICROSYSTEMS":
		return BACnetVendorId_UNIFIED_MICROSYSTEMS, true
	case "FUJITSU_LIMITED":
		return BACnetVendorId_FUJITSU_LIMITED, true
	case "INDUSTRIEELEKTRONIK_BRANDENBURG_GMBH":
		return BACnetVendorId_INDUSTRIEELEKTRONIK_BRANDENBURG_GMBH, true
	case "HARTMANN_GMBH":
		return BACnetVendorId_HARTMANN_GMBH, true
	case "PISCADA":
		return BACnetVendorId_PISCADA, true
	case "KM_BSYSTEMSSRO":
		return BACnetVendorId_KM_BSYSTEMSSRO, true
	case "POWER_TECH_ENGINEERINGAS":
		return BACnetVendorId_POWER_TECH_ENGINEERINGAS, true
	case "TELEFONBAU_ARTHUR_SCHWABE_GMBH_COKG":
		return BACnetVendorId_TELEFONBAU_ARTHUR_SCHWABE_GMBH_COKG, true
	case "WUXI_FISTWELOVE_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_WUXI_FISTWELOVE_TECHNOLOGY_CO_LTD, true
	case "PRYSM":
		return BACnetVendorId_PRYSM, true
	case "STEINEL_GMBH":
		return BACnetVendorId_STEINEL_GMBH, true
	case "GEORG_FISCHERJRGAG":
		return BACnetVendorId_GEORG_FISCHERJRGAG, true
	case "VERTIV_FORMERLY_EMERSON_NETWORK_POWER":
		return BACnetVendorId_VERTIV_FORMERLY_EMERSON_NETWORK_POWER, true
	case "MAKE_DEVELOPSL":
		return BACnetVendorId_MAKE_DEVELOPSL, true
	case "MONNIT_CORPORATION":
		return BACnetVendorId_MONNIT_CORPORATION, true
	case "MIRROR_LIFE_CORPORATION":
		return BACnetVendorId_MIRROR_LIFE_CORPORATION, true
	case "SECURE_METERS_LIMITED":
		return BACnetVendorId_SECURE_METERS_LIMITED, true
	case "PECO":
		return BACnetVendorId_PECO, true
	case "CCTECH_INC":
		return BACnetVendorId_CCTECH_INC, true
	case "LIGHT_FI_LIMITED":
		return BACnetVendorId_LIGHT_FI_LIMITED, true
	case "NICE_SPA":
		return BACnetVendorId_NICE_SPA, true
	case "FIBER_SEN_SYS_INC":
		return BACnetVendorId_FIBER_SEN_SYS_INC, true
	case "BD_BUCHTAUND_DEGEORGI":
		return BACnetVendorId_BD_BUCHTAUND_DEGEORGI, true
	case "SA_ARMSTRONG_LTD":
		return BACnetVendorId_SA_ARMSTRONG_LTD, true
	case "VENTACITY_SYSTEMS_INC":
		return BACnetVendorId_VENTACITY_SYSTEMS_INC, true
	case "HITACHI_JOHNSON_CONTROLS_AIR_CONDITIONING_INC":
		return BACnetVendorId_HITACHI_JOHNSON_CONTROLS_AIR_CONDITIONING_INC, true
	case "SAGE_METERING_INC":
		return BACnetVendorId_SAGE_METERING_INC, true
	case "ANDEL_LIMITED":
		return BACnetVendorId_ANDEL_LIMITED, true
	case "ECO_SMART_TECHNOLOGIES":
		return BACnetVendorId_ECO_SMART_TECHNOLOGIES, true
	case "SET":
		return BACnetVendorId_SET, true
	case "PROTEC_FIRE_DETECTION_SPAINSL":
		return BACnetVendorId_PROTEC_FIRE_DETECTION_SPAINSL, true
	case "AGRAMERUG":
		return BACnetVendorId_AGRAMERUG, true
	case "ANYLINK_ELECTRONIC_GMBH":
		return BACnetVendorId_ANYLINK_ELECTRONIC_GMBH, true
	case "SCHINDLER_LTD":
		return BACnetVendorId_SCHINDLER_LTD, true
	case "VISONETAG":
		return BACnetVendorId_VISONETAG, true
	case "JIBREEL_ABDEEN_EST":
		return BACnetVendorId_JIBREEL_ABDEEN_EST, true
	case "FLUIDYNE_CONTROL_SYSTEMS_PVT_LTD":
		return BACnetVendorId_FLUIDYNE_CONTROL_SYSTEMS_PVT_LTD, true
	case "PRISM_SYSTEMS_INC":
		return BACnetVendorId_PRISM_SYSTEMS_INC, true
	case "ENERTIV":
		return BACnetVendorId_ENERTIV, true
	case "MIRASOFT_GMBH_COKG":
		return BACnetVendorId_MIRASOFT_GMBH_COKG, true
	case "DUALTECHIT":
		return BACnetVendorId_DUALTECHIT, true
	case "COUNTLOGICLLC":
		return BACnetVendorId_COUNTLOGICLLC, true
	case "KOHLER":
		return BACnetVendorId_KOHLER, true
	case "CHEN_SEN_CONTROLS_CO_LTD":
		return BACnetVendorId_CHEN_SEN_CONTROLS_CO_LTD, true
	case "GREENHECK":
		return BACnetVendorId_GREENHECK, true
	case "MM_SYSTEMS_INC":
		return BACnetVendorId_MM_SYSTEMS_INC, true
	case "INTWINE_CONNECTLLC":
		return BACnetVendorId_INTWINE_CONNECTLLC, true
	case "KARLBORGS_ELKONTROLL":
		return BACnetVendorId_KARLBORGS_ELKONTROLL, true
	case "DATAKOM":
		return BACnetVendorId_DATAKOM, true
	case "HOGA_CONTROLAS":
		return BACnetVendorId_HOGA_CONTROLAS, true
	case "COOL_AUTOMATION":
		return BACnetVendorId_COOL_AUTOMATION, true
	case "INTER_SEARCH_CO_LTD":
		return BACnetVendorId_INTER_SEARCH_CO_LTD, true
	case "DABBEL_AUTOMATION_INTELLIGENCE_GMBH":
		return BACnetVendorId_DABBEL_AUTOMATION_INTELLIGENCE_GMBH, true
	case "GADGEON_ENGINEERING_SMARTNESS":
		return BACnetVendorId_GADGEON_ENGINEERING_SMARTNESS, true
	case "COSTER_GROUP_SRL":
		return BACnetVendorId_COSTER_GROUP_SRL, true
	case "WALTER_MLLERAG":
		return BACnetVendorId_WALTER_MLLERAG, true
	case "CUSTOM_SOFTWARE_ENGINEERING":
		return BACnetVendorId_CUSTOM_SOFTWARE_ENGINEERING, true
	case "FLUKE":
		return BACnetVendorId_FLUKE, true
	case "QUINTEX_SYSTEMS_LTD":
		return BACnetVendorId_QUINTEX_SYSTEMS_LTD, true
	case "SENFFICIENTSDNBHD":
		return BACnetVendorId_SENFFICIENTSDNBHD, true
	case "NUBEIO_OPERATIONS_PTY_LTD":
		return BACnetVendorId_NUBEIO_OPERATIONS_PTY_LTD, true
	case "DAS_INTEGRATOR_PTE_LTD":
		return BACnetVendorId_DAS_INTEGRATOR_PTE_LTD, true
	case "CREVIS_CO_LTD":
		return BACnetVendorId_CREVIS_CO_LTD, true
	case "I_SQUAREDSOFTWAREINC":
		return BACnetVendorId_I_SQUAREDSOFTWAREINC, true
	case "KTG_GMBH":
		return BACnetVendorId_KTG_GMBH, true
	case "POK_GROUP_OY":
		return BACnetVendorId_POK_GROUP_OY, true
	case "ADISCOM":
		return BACnetVendorId_ADISCOM, true
	case "NITTAN_COMPANY_LIMITED":
		return BACnetVendorId_NITTAN_COMPANY_LIMITED, true
	case "INCUSENSE":
		return BACnetVendorId_INCUSENSE, true
	case "F":
		return BACnetVendorId_F, true
	case "ANORD_MARDIX_INC":
		return BACnetVendorId_ANORD_MARDIX_INC, true
	case "HOSCH_GEBUDEAUTOMATION_NEUE_PRODUKTE_GMBH":
		return BACnetVendorId_HOSCH_GEBUDEAUTOMATION_NEUE_PRODUKTE_GMBH, true
	case "BOSCHIO_GMBH":
		return BACnetVendorId_BOSCHIO_GMBH, true
	case "ROYAL_BOON_EDAM_INTERNATIONALBV":
		return BACnetVendorId_ROYAL_BOON_EDAM_INTERNATIONALBV, true
	case "CLACK_CORPORATION":
		return BACnetVendorId_CLACK_CORPORATION, true
	case "UNITEX_CONTROLSLLC":
		return BACnetVendorId_UNITEX_CONTROLSLLC, true
	case "KTC_GTEBORGAB":
		return BACnetVendorId_KTC_GTEBORGAB, true
	case "INTERZONAB":
		return BACnetVendorId_INTERZONAB, true
	case "ELUTIONS_INC_WIZCON_SYSTEMSSAS":
		return BACnetVendorId_ELUTIONS_INC_WIZCON_SYSTEMSSAS, true
	case "ISDEINGSL":
		return BACnetVendorId_ISDEINGSL, true
	case "AB_MAUTOMATIONBUILDINGMESSAGING_GMBH":
		return BACnetVendorId_AB_MAUTOMATIONBUILDINGMESSAGING_GMBH, true
	case "KENTEC_ELECTRONICS_LTD":
		return BACnetVendorId_KENTEC_ELECTRONICS_LTD, true
	case "COPELANDLP":
		return BACnetVendorId_COPELANDLP, true
	case "POWERSIDE":
		return BACnetVendorId_POWERSIDE, true
	case "SMC_GROUP":
		return BACnetVendorId_SMC_GROUP, true
	case "EOS_WEATHER_INSTRUMENTS":
		return BACnetVendorId_EOS_WEATHER_INSTRUMENTS, true
	case "ZONEX_SYSTEMS":
		return BACnetVendorId_ZONEX_SYSTEMS, true
	case "GENEREX_SYSTEMS_COMPUTERVERTRIEBSGESELLSCHAFTMBH":
		return BACnetVendorId_GENEREX_SYSTEMS_COMPUTERVERTRIEBSGESELLSCHAFTMBH, true
	case "ENERGY_WALLLLC":
		return BACnetVendorId_ENERGY_WALLLLC, true
	case "ORION_ANALYSIS_CORPORATION":
		return BACnetVendorId_ORION_ANALYSIS_CORPORATION, true
	case "PACOM_SYSTEMS_PTY_LTD":
		return BACnetVendorId_PACOM_SYSTEMS_PTY_LTD, true
	case "THERMOFIN":
		return BACnetVendorId_THERMOFIN, true
	case "SDATAWAYSA":
		return BACnetVendorId_SDATAWAYSA, true
	case "BIDDLE_AIR_SYSTEMS_LIMITED":
		return BACnetVendorId_BIDDLE_AIR_SYSTEMS_LIMITED, true
	case "KESSLER_ELLIS_PRODUCTS":
		return BACnetVendorId_KESSLER_ELLIS_PRODUCTS, true
	case "THERMOSCREENS":
		return BACnetVendorId_THERMOSCREENS, true
	case "MODIO":
		return BACnetVendorId_MODIO, true
	case "NEWRON_SOLUTIONS":
		return BACnetVendorId_NEWRON_SOLUTIONS, true
	case "UNITRONICS":
		return BACnetVendorId_UNITRONICS, true
	case "TRILUX_GMBH_COKG":
		return BACnetVendorId_TRILUX_GMBH_COKG, true
	case "KOLLMORGEN_STEUERUNGSTECHNIK_GMBH":
		return BACnetVendorId_KOLLMORGEN_STEUERUNGSTECHNIK_GMBH, true
	case "UNICO_INC":
		return BACnetVendorId_UNICO_INC, true
	case "BOSCH_REXROTHAG":
		return BACnetVendorId_BOSCH_REXROTHAG, true
	case "ALARKO_CARRIER":
		return BACnetVendorId_ALARKO_CARRIER, true
	case "VERDIGRIS_TECHNOLOGIES":
		return BACnetVendorId_VERDIGRIS_TECHNOLOGIES, true
	case "SHANGHAISIIC_LONGCHUANG_SMARTECH_SO_LTD":
		return BACnetVendorId_SHANGHAISIIC_LONGCHUANG_SMARTECH_SO_LTD, true
	case "QUINDA_CO":
		return BACnetVendorId_QUINDA_CO, true
	case "GRUNERAG":
		return BACnetVendorId_GRUNERAG, true
	case "BACMOVE":
		return BACnetVendorId_BACMOVE, true
	case "PSIDACAB":
		return BACnetVendorId_PSIDACAB, true
	case "ISICON_CONTROL_AUTOMATION":
		return BACnetVendorId_ISICON_CONTROL_AUTOMATION, true
	case "BIG_ASS_FANS":
		return BACnetVendorId_BIG_ASS_FANS, true
	case "EBTRON_INC":
		return BACnetVendorId_EBTRON_INC, true
	case "DIN_DIETMAR_NOCKER_FACILITY_MANAGEMENT_GMBH":
		return BACnetVendorId_DIN_DIETMAR_NOCKER_FACILITY_MANAGEMENT_GMBH, true
	case "TELDIO":
		return BACnetVendorId_TELDIO, true
	case "MIKROKLIM_ASRO":
		return BACnetVendorId_MIKROKLIM_ASRO, true
	case "DENSITY":
		return BACnetVendorId_DENSITY, true
	case "ICONAG_LEITTECHNIK_GMBH":
		return BACnetVendorId_ICONAG_LEITTECHNIK_GMBH, true
	case "AWAIR":
		return BACnetVendorId_AWAIR, true
	case "TD_ENGINEERING_LTD":
		return BACnetVendorId_TD_ENGINEERING_LTD, true
	case "SISTEMAS_DIGITALES":
		return BACnetVendorId_SISTEMAS_DIGITALES, true
	case "LOXONE_ELECTRONICS_GMBH":
		return BACnetVendorId_LOXONE_ELECTRONICS_GMBH, true
	case "ACTRON_AIR":
		return BACnetVendorId_ACTRON_AIR, true
	case "SCADA_ENGINE":
		return BACnetVendorId_SCADA_ENGINE, true
	case "INDUCTIVE_AUTOMATION":
		return BACnetVendorId_INDUCTIVE_AUTOMATION, true
	case "THOR_ENGINEERING_GMBH":
		return BACnetVendorId_THOR_ENGINEERING_GMBH, true
	case "BERNER_INTERNATIONALLLC":
		return BACnetVendorId_BERNER_INTERNATIONALLLC, true
	case "POTSDAM_SENSORSLLC":
		return BACnetVendorId_POTSDAM_SENSORSLLC, true
	case "KOHLER_MIRA_LTD":
		return BACnetVendorId_KOHLER_MIRA_LTD, true
	case "TECOMON_GMBH":
		return BACnetVendorId_TECOMON_GMBH, true
	case "TWO_DIMENSIONAL_INSTRUMENTSLLC":
		return BACnetVendorId_TWO_DIMENSIONAL_INSTRUMENTSLLC, true
	case "LEFA_TECHNOLOGIES_PTE_LTD":
		return BACnetVendorId_LEFA_TECHNOLOGIES_PTE_LTD, true
	case "EATONCEAG_NOTLICHTSYSTEME_GMBH":
		return BACnetVendorId_EATONCEAG_NOTLICHTSYSTEME_GMBH, true
	case "COMMBOX_TECNOLOGIA":
		return BACnetVendorId_COMMBOX_TECNOLOGIA, true
	case "LENZE_AMERICAS_FORMERLYAC_TECHNOLOGY_CORPORATION":
		return BACnetVendorId_LENZE_AMERICAS_FORMERLYAC_TECHNOLOGY_CORPORATION, true
	case "IP_VIDEO_CORPORATION":
		return BACnetVendorId_IP_VIDEO_CORPORATION, true
	case "BENDER_GMBH_COKG":
		return BACnetVendorId_BENDER_GMBH_COKG, true
	case "RHYMEBUS_CORPORATION":
		return BACnetVendorId_RHYMEBUS_CORPORATION, true
	case "AXON_SYSTEMS_LTD":
		return BACnetVendorId_AXON_SYSTEMS_LTD, true
	case "ENGINEERED_AIR":
		return BACnetVendorId_ENGINEERED_AIR, true
	case "ELIPSE_SOFTWARE_LTDA":
		return BACnetVendorId_ELIPSE_SOFTWARE_LTDA, true
	case "SIMATIX_BUILDING_TECHNOLOGIES_PVT_LTD":
		return BACnetVendorId_SIMATIX_BUILDING_TECHNOLOGIES_PVT_LTD, true
	case "WA_BENJAMIN_ELECTRIC_CO":
		return BACnetVendorId_WA_BENJAMIN_ELECTRIC_CO, true
	case "TROX_AIR_CONDITIONING_COMPONENTS_SUZHOU_CO_LTD":
		return BACnetVendorId_TROX_AIR_CONDITIONING_COMPONENTS_SUZHOU_CO_LTD, true
	case "SC_MEDICAL_PTY_LTD":
		return BACnetVendorId_SC_MEDICAL_PTY_LTD, true
	case "EAGLE_TECHNOLOGY":
		return BACnetVendorId_EAGLE_TECHNOLOGY, true
	case "ELCANICAS":
		return BACnetVendorId_ELCANICAS, true
	case "OBEOAS":
		return BACnetVendorId_OBEOAS, true
	case "TAPA_INC":
		return BACnetVendorId_TAPA_INC, true
	case "ASE_SMART_ENERGY_INC":
		return BACnetVendorId_ASE_SMART_ENERGY_INC, true
	case "PERFORMANCE_SERVICES_INC":
		return BACnetVendorId_PERFORMANCE_SERVICES_INC, true
	case "VERIDIFY_SECURITY":
		return BACnetVendorId_VERIDIFY_SECURITY, true
	case "CD_INNOVATIONLTD":
		return BACnetVendorId_CD_INNOVATIONLTD, true
	case "BEN_PEOPLES_INDUSTRIESLLC":
		return BACnetVendorId_BEN_PEOPLES_INDUSTRIESLLC, true
	case "UNICOMM_SPZOO":
		return BACnetVendorId_UNICOMM_SPZOO, true
	case "THING_TECHNOLOGIES_GMBH":
		return BACnetVendorId_THING_TECHNOLOGIES_GMBH, true
	case "DATA_AIRE_INC":
		return BACnetVendorId_DATA_AIRE_INC, true
	case "BEIJING_HAILIN_CONTROL_TECHNOLOGY_INC":
		return BACnetVendorId_BEIJING_HAILIN_CONTROL_TECHNOLOGY_INC, true
	case "DIGITAL_REALTY":
		return BACnetVendorId_DIGITAL_REALTY, true
	case "AGROWTEK_INC":
		return BACnetVendorId_AGROWTEK_INC, true
	case "DSP_INNOVATIONBV":
		return BACnetVendorId_DSP_INNOVATIONBV, true
	case "STV_ELECTRONIC_GMBH":
		return BACnetVendorId_STV_ELECTRONIC_GMBH, true
	case "ELMEASURE_INDIA_PVT_LTD":
		return BACnetVendorId_ELMEASURE_INDIA_PVT_LTD, true
	case "PINESHORE_ENERGYLLC":
		return BACnetVendorId_PINESHORE_ENERGYLLC, true
	case "BRASCH_ENVIRONMENTAL_TECHNOLOGIESLLC":
		return BACnetVendorId_BRASCH_ENVIRONMENTAL_TECHNOLOGIESLLC, true
	case "SHEN_ZHEN_ZHI_XING_BUILDING_TECH_CO_LTD":
		return BACnetVendorId_SHEN_ZHEN_ZHI_XING_BUILDING_TECH_CO_LTD, true
	case "SINUX":
		return BACnetVendorId_SINUX, true
	case "ABB_INC":
		return BACnetVendorId_ABB_INC, true
	case "AVNET_INC":
		return BACnetVendorId_AVNET_INC, true
	case "SOMFY_ACTIVITESSA":
		return BACnetVendorId_SOMFY_ACTIVITESSA, true
	case "AMICO":
		return BACnetVendorId_AMICO, true
	case "SAGE_GLASS":
		return BACnetVendorId_SAGE_GLASS, true
	case "AU_VERTE":
		return BACnetVendorId_AU_VERTE, true
	case "AGILE_CONNECTS_PVT_LTD":
		return BACnetVendorId_AGILE_CONNECTS_PVT_LTD, true
	case "LOCIMATION_PTY_LTD":
		return BACnetVendorId_LOCIMATION_PTY_LTD, true
	case "ENVIO_SYSTEMS_GMBH":
		return BACnetVendorId_ENVIO_SYSTEMS_GMBH, true
	case "VOYTECH_SYSTEMS_LIMITED":
		return BACnetVendorId_VOYTECH_SYSTEMS_LIMITED, true
	case "DAVIDSMEYERUND_PAUL_GMBH":
		return BACnetVendorId_DAVIDSMEYERUND_PAUL_GMBH, true
	case "TRANSBIT_SPZOO":
		return BACnetVendorId_TRANSBIT_SPZOO, true
	case "LUSHER_ENGINEERING_SERVICES":
		return BACnetVendorId_LUSHER_ENGINEERING_SERVICES, true
	case "CHNT_NANJING_TECHSEL_INTELLIGENT_COMPANYLTD":
		return BACnetVendorId_CHNT_NANJING_TECHSEL_INTELLIGENT_COMPANYLTD, true
	case "THREETRONICS_PTY_LTD":
		return BACnetVendorId_THREETRONICS_PTY_LTD, true
	case "SKY_FOUNDRYLLC":
		return BACnetVendorId_SKY_FOUNDRYLLC, true
	case "HANIL_PRO_TECH":
		return BACnetVendorId_HANIL_PRO_TECH, true
	case "SENSORSCALL":
		return BACnetVendorId_SENSORSCALL, true
	case "SHANGHAI_JINGPU_INFORMATION_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_SHANGHAI_JINGPU_INFORMATION_TECHNOLOGY_CO_LTD, true
	case "LICHTMANUFAKTUR_BERLIN_GMBH":
		return BACnetVendorId_LICHTMANUFAKTUR_BERLIN_GMBH, true
	case "ECO_PARKING_TECHNOLOGIES":
		return BACnetVendorId_ECO_PARKING_TECHNOLOGIES, true
	case "ENVISION_DIGITAL_INTERNATIONAL_PTE_LTD":
		return BACnetVendorId_ENVISION_DIGITAL_INTERNATIONAL_PTE_LTD, true
	case "CARRIER_JAPAN_CORPORATION":
		return BACnetVendorId_CARRIER_JAPAN_CORPORATION, true
	case "ANTONY_DEVELOPPEMENT_ELECTRONIQUE":
		return BACnetVendorId_ANTONY_DEVELOPPEMENT_ELECTRONIQUE, true
	case "ISYSTEMS":
		return BACnetVendorId_ISYSTEMS, true
	case "THUREON_INTERNATIONAL_LIMITED":
		return BACnetVendorId_THUREON_INTERNATIONAL_LIMITED, true
	case "PULSAFEEDER":
		return BACnetVendorId_PULSAFEEDER, true
	case "MEGA_CHIPS_CORPORATION":
		return BACnetVendorId_MEGA_CHIPS_CORPORATION, true
	case "TES_CONTROLS":
		return BACnetVendorId_TES_CONTROLS, true
	case "CERMATE":
		return BACnetVendorId_CERMATE, true
	case "GRAND_VALLEY_STATE_UNIVERSITY":
		return BACnetVendorId_GRAND_VALLEY_STATE_UNIVERSITY, true
	case "SYMCON_GMBH":
		return BACnetVendorId_SYMCON_GMBH, true
	case "THE_CHICAGO_FAUCET_COMPANY":
		return BACnetVendorId_THE_CHICAGO_FAUCET_COMPANY, true
	case "TELETROL_SYSTEMS_INC":
		return BACnetVendorId_TELETROL_SYSTEMS_INC, true
	case "SHENZHEN_JUNZHI_HI_TECH_CO_LTD":
		return BACnetVendorId_SHENZHEN_JUNZHI_HI_TECH_CO_LTD, true
	case "GEBERITAG":
		return BACnetVendorId_GEBERITAG, true
	case "REX_CONTROLS":
		return BACnetVendorId_REX_CONTROLS, true
	case "IVMS_GMBH":
		return BACnetVendorId_IVMS_GMBH, true
	case "MNPP_SATURN_LTD":
		return BACnetVendorId_MNPP_SATURN_LTD, true
	case "REGAL_BELOIT":
		return BACnetVendorId_REGAL_BELOIT, true
	case "ACS_AIR_CONDITIONING_SOLUTIONS":
		return BACnetVendorId_ACS_AIR_CONDITIONING_SOLUTIONS, true
	case "GBX_TECHNOLOGYLLC":
		return BACnetVendorId_GBX_TECHNOLOGYLLC, true
	case "KAITERRA":
		return BACnetVendorId_KAITERRA, true
	case "THIN_KUANLOT_TECHNOLOGY_SHANGHAI_CO_LTD":
		return BACnetVendorId_THIN_KUANLOT_TECHNOLOGY_SHANGHAI_CO_LTD, true
	case "HO_CO_STOBV":
		return BACnetVendorId_HO_CO_STOBV, true
	case "TOKAI_SOFT":
		return BACnetVendorId_TOKAI_SOFT, true
	case "SHENZHENASAI_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_SHENZHENASAI_TECHNOLOGY_CO_LTD, true
	case "RPS_SPA":
		return BACnetVendorId_RPS_SPA, true
	case "ESMSOLUTIONS":
		return BACnetVendorId_ESMSOLUTIONS, true
	case "IO_TECH_SYSTEMS_LIMITED":
		return BACnetVendorId_IO_TECH_SYSTEMS_LIMITED, true
	case "I_AUTO_LOGIC_CO_LTD":
		return BACnetVendorId_I_AUTO_LOGIC_CO_LTD, true
	case "NEW_AGE_MICROLLC":
		return BACnetVendorId_NEW_AGE_MICROLLC, true
	case "GUARDIAN_GLASS":
		return BACnetVendorId_GUARDIAN_GLASS, true
	case "GUANGZHOU_ZHAOYU_INFORMATION_TECHNOLOGY":
		return BACnetVendorId_GUANGZHOU_ZHAOYU_INFORMATION_TECHNOLOGY, true
	case "ACE_IOT_SOLUTIONSLLC":
		return BACnetVendorId_ACE_IOT_SOLUTIONSLLC, true
	case "PORIS_ELECTRONICS_CO_LTD":
		return BACnetVendorId_PORIS_ELECTRONICS_CO_LTD, true
	case "BLUE_RIDGE_TECHNOLOGIES":
		return BACnetVendorId_BLUE_RIDGE_TECHNOLOGIES, true
	case "TERMINUS_TECHNOLOGIES_GROUP":
		return BACnetVendorId_TERMINUS_TECHNOLOGIES_GROUP, true
	case "INTECH1_INC":
		return BACnetVendorId_INTECH1_INC, true
	case "ACCURATE_ELECTRONICS":
		return BACnetVendorId_ACCURATE_ELECTRONICS, true
	case "FLUENCE_BIOENGINEERING":
		return BACnetVendorId_FLUENCE_BIOENGINEERING, true
	case "MUN_HEAN_SINGAPORE_PTE_LTD":
		return BACnetVendorId_MUN_HEAN_SINGAPORE_PTE_LTD, true
	case "KATRONICAG_COKG":
		return BACnetVendorId_KATRONICAG_COKG, true
	case "SUZHOU_XIN_AO_INFORMATION_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_SUZHOU_XIN_AO_INFORMATION_TECHNOLOGY_CO_LTD, true
	case "LINKTEKK_TECHNOLOGYJSC":
		return BACnetVendorId_LINKTEKK_TECHNOLOGYJSC, true
	case "STIRLING_ULTRACOLD":
		return BACnetVendorId_STIRLING_ULTRACOLD, true
	case "UV_PARTNERS_INC":
		return BACnetVendorId_UV_PARTNERS_INC, true
	case "VERIS_INDUSTRIES":
		return BACnetVendorId_VERIS_INDUSTRIES, true
	case "PRO_MINENT_GMBH":
		return BACnetVendorId_PRO_MINENT_GMBH, true
	case "MULTI_TECH_SYSTEMS_INC":
		return BACnetVendorId_MULTI_TECH_SYSTEMS_INC, true
	case "JUMO_GMBH_COKG":
		return BACnetVendorId_JUMO_GMBH_COKG, true
	case "QINGDAO_HUARUI_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_QINGDAO_HUARUI_TECHNOLOGY_CO_LTD, true
	case "CAIRN_SYSTEMES":
		return BACnetVendorId_CAIRN_SYSTEMES, true
	case "NEURO_LOGIC_RESEARCH_CORP":
		return BACnetVendorId_NEURO_LOGIC_RESEARCH_CORP, true
	case "TRANSITION_TECHNOLOGIES_ADVANCED_SOLUTIONS_SPZOO":
		return BACnetVendorId_TRANSITION_TECHNOLOGIES_ADVANCED_SOLUTIONS_SPZOO, true
	case "XXTERBV":
		return BACnetVendorId_XXTERBV, true
	case "PASSIVE_LOGIC":
		return BACnetVendorId_PASSIVE_LOGIC, true
	case "EN_SMART_CONTROLS":
		return BACnetVendorId_EN_SMART_CONTROLS, true
	case "CENTAURUS_PRIME":
		return BACnetVendorId_CENTAURUS_PRIME, true
	case "WATTS_HEATINGAND_HOT_WATER_SOLUTIONSDBA_LYNC":
		return BACnetVendorId_WATTS_HEATINGAND_HOT_WATER_SOLUTIONSDBA_LYNC, true
	case "TROPOSPHAIRA_TECHNOLOGIESLLP":
		return BACnetVendorId_TROPOSPHAIRA_TECHNOLOGIESLLP, true
	case "NETWORK_THERMOSTAT":
		return BACnetVendorId_NETWORK_THERMOSTAT, true
	case "TITANIUM_INTELLIGENT_SOLUTIONSLLC":
		return BACnetVendorId_TITANIUM_INTELLIGENT_SOLUTIONSLLC, true
	case "NUMA_PRODUCTSLLC":
		return BACnetVendorId_NUMA_PRODUCTSLLC, true
	case "WAREMA_RENKHOFFSE":
		return BACnetVendorId_WAREMA_RENKHOFFSE, true
	case "FRESEAS":
		return BACnetVendorId_FRESEAS, true
	case "MAPPED":
		return BACnetVendorId_MAPPED, true
	case "ELEKTRODESIG_NVENTILATORYSRO":
		return BACnetVendorId_ELEKTRODESIG_NVENTILATORYSRO, true
	case "AIR_CARE_AUTOMATION_INC":
		return BACnetVendorId_AIR_CARE_AUTOMATION_INC, true
	case "SAND_NETWORK_SYSTEMS":
		return BACnetVendorId_SAND_NETWORK_SYSTEMS, true
	case "ANTRUM":
		return BACnetVendorId_ANTRUM, true
	case "BAO_LINH_CONNECT_TECHNOLOGY":
		return BACnetVendorId_BAO_LINH_CONNECT_TECHNOLOGY, true
	case "VIRGINIA_CONTROLSLLC":
		return BACnetVendorId_VIRGINIA_CONTROLSLLC, true
	case "DUOSYSSDNBHD":
		return BACnetVendorId_DUOSYSSDNBHD, true
	case "ONSENSAS":
		return BACnetVendorId_ONSENSAS, true
	case "VAUGHN_THERMAL_CORPORATION":
		return BACnetVendorId_VAUGHN_THERMAL_CORPORATION, true
	case "THERMOPLASTIC_ENGINEERING_LTDTPE":
		return BACnetVendorId_THERMOPLASTIC_ENGINEERING_LTDTPE, true
	case "WIRTH_RESEARCH_LTD":
		return BACnetVendorId_WIRTH_RESEARCH_LTD, true
	case "SST_AUTOMATION":
		return BACnetVendorId_SST_AUTOMATION, true
	case "SHANGHAI_BENCOL_ELECTRONIC_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_SHANGHAI_BENCOL_ELECTRONIC_TECHNOLOGY_CO_LTD, true
	case "REGULVAR_INC":
		return BACnetVendorId_REGULVAR_INC, true
	case "AIWAA_SYSTEMS_PRIVATE_LIMITED":
		return BACnetVendorId_AIWAA_SYSTEMS_PRIVATE_LIMITED, true
	case "ENLESS_WIRELESS":
		return BACnetVendorId_ENLESS_WIRELESS, true
	case "OZUNO_ENGINEERING_PTY_LTD":
		return BACnetVendorId_OZUNO_ENGINEERING_PTY_LTD, true
	case "HUBBELL_THE_ELECTRIC_HEATER_COMPANY":
		return BACnetVendorId_HUBBELL_THE_ELECTRIC_HEATER_COMPANY, true
	case "INDUSTRIAL_TURNAROUND_CORPORATIONITAC":
		return BACnetVendorId_INDUSTRIAL_TURNAROUND_CORPORATIONITAC, true
	case "WADSWORTH_CONTROL_SYSTEMS":
		return BACnetVendorId_WADSWORTH_CONTROL_SYSTEMS, true
	case "SERVICES_HILO_INC":
		return BACnetVendorId_SERVICES_HILO_INC, true
	case "IDM_ENERGIESYSTEME_GMBH":
		return BACnetVendorId_IDM_ENERGIESYSTEME_GMBH, true
	case "BE_NEXTBV":
		return BACnetVendorId_BE_NEXTBV, true
	case "CLEAN_AIRAI_CORPORATION":
		return BACnetVendorId_CLEAN_AIRAI_CORPORATION, true
	case "AF_DTEK_DIVISIONOF_FASTEK_INTERNATIONAL_INC":
		return BACnetVendorId_AF_DTEK_DIVISIONOF_FASTEK_INTERNATIONAL_INC, true
	case "REVOLUTION_MICROELECTRONICS_AMERICA_INC":
		return BACnetVendorId_REVOLUTION_MICROELECTRONICS_AMERICA_INC, true
	case "REAL_TIME_SYSTEMS_GMBH":
		return BACnetVendorId_REAL_TIME_SYSTEMS_GMBH, true
	case "ZED_BEE_TECHNOLOGIES_PVT_LTD":
		return BACnetVendorId_ZED_BEE_TECHNOLOGIES_PVT_LTD, true
	case "WIMATE_TECHNOLOGY_SOLUTIONS_PVT_LTD":
		return BACnetVendorId_WIMATE_TECHNOLOGY_SOLUTIONS_PVT_LTD, true
	case "SENTICON_LTD":
		return BACnetVendorId_SENTICON_LTD, true
	case "ROSSAKERAB":
		return BACnetVendorId_ROSSAKERAB, true
	case "OPIT_SOLUTIONS_LTD":
		return BACnetVendorId_OPIT_SOLUTIONS_LTD, true
	case "HOTOWELL_INTERNATIONAL_CO_LIMITED":
		return BACnetVendorId_HOTOWELL_INTERNATIONAL_CO_LIMITED, true
	case "INIM_ELECTRONICSSRL_UNIPERSONALE":
		return BACnetVendorId_INIM_ELECTRONICSSRL_UNIPERSONALE, true
	case "AIRTHINGSASA":
		return BACnetVendorId_AIRTHINGSASA, true
	case "POWER_COLD_COMFORT_AIR_SOLUTIONS_INC":
		return BACnetVendorId_POWER_COLD_COMFORT_AIR_SOLUTIONS_INC, true
	case "ANALOG_DEVICES_INC":
		return BACnetVendorId_ANALOG_DEVICES_INC, true
	case "AI_DIRECTIONSDMCC":
		return BACnetVendorId_AI_DIRECTIONSDMCC, true
	case "PRIMA_ELECTRO_SPA":
		return BACnetVendorId_PRIMA_ELECTRO_SPA, true
	case "KLT_CONTROL_SYSTEM_LTD":
		return BACnetVendorId_KLT_CONTROL_SYSTEM_LTD, true
	case "EVOLUTION_CONTROLS_INC":
		return BACnetVendorId_EVOLUTION_CONTROLS_INC, true
	case "BEVER_INNOVATIONS":
		return BACnetVendorId_BEVER_INNOVATIONS, true
	case "PELICAN_WIRELESS_SYSTEMS":
		return BACnetVendorId_PELICAN_WIRELESS_SYSTEMS, true
	case "CONTROL_CONCEPTS_INC":
		return BACnetVendorId_CONTROL_CONCEPTS_INC, true
	case "AUGMATIC_TECHNOLOGIES_PVT_LTD":
		return BACnetVendorId_AUGMATIC_TECHNOLOGIES_PVT_LTD, true
	case "XIAMEN_MILESIGHTLOT_CO_LTD":
		return BACnetVendorId_XIAMEN_MILESIGHTLOT_CO_LTD, true
	case "I_CONTROLS":
		return BACnetVendorId_I_CONTROLS, true
	case "TIANJIN_ANJIELOT_SCHIENCEAND_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_TIANJIN_ANJIELOT_SCHIENCEAND_TECHNOLOGY_CO_LTD, true
	case "GUANGZHOUS_ENERGY_ELECTRONICS_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_GUANGZHOUS_ENERGY_ELECTRONICS_TECHNOLOGY_CO_LTD, true
	case "AKVO_ATMOSPHERIC_WATER_SYSTEMS_PVT_LTD":
		return BACnetVendorId_AKVO_ATMOSPHERIC_WATER_SYSTEMS_PVT_LTD, true
	case "EM_FIRST_CO_LTD":
		return BACnetVendorId_EM_FIRST_CO_LTD, true
	case "IION_SYSTEMS_APS":
		return BACnetVendorId_IION_SYSTEMS_APS, true
	case "SAF_TEHNIKAJSC":
		return BACnetVendorId_SAF_TEHNIKAJSC, true
	case "KOMFORTIQ_INC":
		return BACnetVendorId_KOMFORTIQ_INC, true
	case "COOL_TERA_LIMITED":
		return BACnetVendorId_COOL_TERA_LIMITED, true
	case "HADRON_SOLUTIONS_SRLS":
		return BACnetVendorId_HADRON_SOLUTIONS_SRLS, true
	case "CIMETRICS_TECHNOLOGY":
		return BACnetVendorId_CIMETRICS_TECHNOLOGY, true
	case "VICONICS_ELECTRONICS_INC":
		return BACnetVendorId_VICONICS_ELECTRONICS_INC, true
	case "BITPOOL":
		return BACnetVendorId_BITPOOL, true
	case "SONICULLC":
		return BACnetVendorId_SONICULLC, true
	case "RISHABH_INSTRUMENTS_LIMITED":
		return BACnetVendorId_RISHABH_INSTRUMENTS_LIMITED, true
	case "THING_WAREHOUSELLC":
		return BACnetVendorId_THING_WAREHOUSELLC, true
	case "INNOFRIENDS_GMBH":
		return BACnetVendorId_INNOFRIENDS_GMBH, true
	case "METRONICAKP_SPJ":
		return BACnetVendorId_METRONICAKP_SPJ, true
	case "TECHKNAVE":
		return BACnetVendorId_TECHKNAVE, true
	case "ELSNER_ELEKTRONIK":
		return BACnetVendorId_ELSNER_ELEKTRONIK, true
	case "LEFOO_INDUSTRIAL_HANGZHOU_CO_LTD":
		return BACnetVendorId_LEFOO_INDUSTRIAL_HANGZHOU_CO_LTD, true
	case "YASKAWA_AMERICA_INC":
		return BACnetVendorId_YASKAWA_AMERICA_INC, true
	case "CALIBRATION_TECHNOLOGIES_INC":
		return BACnetVendorId_CALIBRATION_TECHNOLOGIES_INC, true
	case "ALLORADO":
		return BACnetVendorId_ALLORADO, true
	case "VERKADA":
		return BACnetVendorId_VERKADA, true
	case "WATTSENSE":
		return BACnetVendorId_WATTSENSE, true
	case "EMERSON_AUTOMATION_SOLUTIONS":
		return BACnetVendorId_EMERSON_AUTOMATION_SOLUTIONS, true
	case "GROWLINK":
		return BACnetVendorId_GROWLINK, true
	case "OLYMPIA_ELECTRONICS":
		return BACnetVendorId_OLYMPIA_ELECTRONICS, true
	case "NORMAL_SOFTWARE_INC":
		return BACnetVendorId_NORMAL_SOFTWARE_INC, true
	case "ST_ENGINEERING_SOLUTIONJSC":
		return BACnetVendorId_ST_ENGINEERING_SOLUTIONJSC, true
	case "INDUSTRIAL_FLOW_SOLUTIONS":
		return BACnetVendorId_INDUSTRIAL_FLOW_SOLUTIONS, true
	case "DEO_SCONTROLSYSTEMS_GMBH":
		return BACnetVendorId_DEO_SCONTROLSYSTEMS_GMBH, true
	case "UBIQISENSE_APS":
		return BACnetVendorId_UBIQISENSE_APS, true
	case "TIGER_SOFT":
		return BACnetVendorId_TIGER_SOFT, true
	case "ECODOM_SRL":
		return BACnetVendorId_ECODOM_SRL, true
	case "BILGIPRO_IOT_SYSTEMS":
		return BACnetVendorId_BILGIPRO_IOT_SYSTEMS, true
	case "PLANSPURNETDESIGN_GMBH":
		return BACnetVendorId_PLANSPURNETDESIGN_GMBH, true
	case "DOLPHIN_SOLUTIONS_LTD":
		return BACnetVendorId_DOLPHIN_SOLUTIONS_LTD, true
	case "MITSUBISHI_ELECTRIC_CORPORATION_KOBE_WORKS":
		return BACnetVendorId_MITSUBISHI_ELECTRIC_CORPORATION_KOBE_WORKS, true
	case "ECOVENA":
		return BACnetVendorId_ECOVENA, true
	case "GREE_ELECTRIC_APPLIANCES_INCOF_ZHUHAI":
		return BACnetVendorId_GREE_ELECTRIC_APPLIANCES_INCOF_ZHUHAI, true
	case "CONSPEC_CONTROLS":
		return BACnetVendorId_CONSPEC_CONTROLS, true
	case "DIGITALE_MESSUND_STEUERSYSTEMEAG":
		return BACnetVendorId_DIGITALE_MESSUND_STEUERSYSTEMEAG, true
	case "HANGZHOU_HIKVISION_DIGITAL_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_HANGZHOU_HIKVISION_DIGITAL_TECHNOLOGY_CO_LTD, true
	case "CRYSTAL_PEAK_SECURITY":
		return BACnetVendorId_CRYSTAL_PEAK_SECURITY, true
	case "PERM_ALERT":
		return BACnetVendorId_PERM_ALERT, true
	case "ZHEJIANG_MISILIN_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_ZHEJIANG_MISILIN_TECHNOLOGY_CO_LTD, true
	case "DEKKER_VACUUM_TECHNOLOGIES":
		return BACnetVendorId_DEKKER_VACUUM_TECHNOLOGIES, true
	case "EDWARDS_LIMITED":
		return BACnetVendorId_EDWARDS_LIMITED, true
	case "LEYBOLD_GMBH":
		return BACnetVendorId_LEYBOLD_GMBH, true
	case "INTERNATIONAL_GAS_DETECTORS":
		return BACnetVendorId_INTERNATIONAL_GAS_DETECTORS, true
	case "ATLAS_COPCO_AIRPOWERNV":
		return BACnetVendorId_ATLAS_COPCO_AIRPOWERNV, true
	case "AIR_SENTRY_LIMITED":
		return BACnetVendorId_AIR_SENTRY_LIMITED, true
	case "FUJITSU_GENERAL_LIMITED":
		return BACnetVendorId_FUJITSU_GENERAL_LIMITED, true
	case "AELSYS":
		return BACnetVendorId_AELSYS, true
	case "GRANBY_CONSULTINGLLC":
		return BACnetVendorId_GRANBY_CONSULTINGLLC, true
	case "CLEVER_RELAY":
		return BACnetVendorId_CLEVER_RELAY, true
	case "MONICO_MONITORING_INC":
		return BACnetVendorId_MONICO_MONITORING_INC, true
	case "OQDO":
		return BACnetVendorId_OQDO, true
	case "MATRIX_COMSEC_PRIVATE_LIMITED":
		return BACnetVendorId_MATRIX_COMSEC_PRIVATE_LIMITED, true
	case "RESOURCE_SOLUTIONS":
		return BACnetVendorId_RESOURCE_SOLUTIONS, true
	case "AMERICAN_GAS_SAFETYLLC":
		return BACnetVendorId_AMERICAN_GAS_SAFETYLLC, true
	case "SS_NORTHERN_LTD":
		return BACnetVendorId_SS_NORTHERN_LTD, true
	case "ULBIOS_TECHSENS":
		return BACnetVendorId_ULBIOS_TECHSENS, true
	case "PROJECT_ENGINEERING_SRL":
		return BACnetVendorId_PROJECT_ENGINEERING_SRL, true
	case "BOWERY_FARMING_INC":
		return BACnetVendorId_BOWERY_FARMING_INC, true
	case "RYOBI_LIMITED":
		return BACnetVendorId_RYOBI_LIMITED, true
	case "EKKO_SENSE_LTD":
		return BACnetVendorId_EKKO_SENSE_LTD, true
	case "CLIMA_COOL":
		return BACnetVendorId_CLIMA_COOL, true
	case "GRID_CONNECT_INC":
		return BACnetVendorId_GRID_CONNECT_INC, true
	case "ZIEGLER_INSTRUMENTATIONUK_LTD":
		return BACnetVendorId_ZIEGLER_INSTRUMENTATIONUK_LTD, true
	case "CONTROL_TECLLC":
		return BACnetVendorId_CONTROL_TECLLC, true
	case "AETERLINK_CORPORATION":
		return BACnetVendorId_AETERLINK_CORPORATION, true
	case "ALPHA_EPSILON_AUTOMATION":
		return BACnetVendorId_ALPHA_EPSILON_AUTOMATION, true
	case "ASTRALITE_INC":
		return BACnetVendorId_ASTRALITE_INC, true
	case "SANYO_ELECTRIC_CO_LTD":
		return BACnetVendorId_SANYO_ELECTRIC_CO_LTD, true
	case "DELTA_FIRE_LTDA":
		return BACnetVendorId_DELTA_FIRE_LTDA, true
	case "BOCK_WATER_HEATERS_INC":
		return BACnetVendorId_BOCK_WATER_HEATERS_INC, true
	case "CLEAVER_BROOKS":
		return BACnetVendorId_CLEAVER_BROOKS, true
	case "SCANALYTICS_INC":
		return BACnetVendorId_SCANALYTICS_INC, true
	case "WILABS":
		return BACnetVendorId_WILABS, true
	case "ACT_SYSTEM_CO_LTD":
		return BACnetVendorId_ACT_SYSTEM_CO_LTD, true
	case "VERGE_SENSE":
		return BACnetVendorId_VERGE_SENSE, true
	case "SYSTEMAIR_MFG_INC":
		return BACnetVendorId_SYSTEMAIR_MFG_INC, true
	case "SEELEY_INTERNATIONAL":
		return BACnetVendorId_SEELEY_INTERNATIONAL, true
	case "CRANE_BUILDING_SERVICES_UTILITIES":
		return BACnetVendorId_CRANE_BUILDING_SERVICES_UTILITIES, true
	case "INTEGRATED_INFORMATION_SYSTEMS_INC":
		return BACnetVendorId_INTEGRATED_INFORMATION_SYSTEMS_INC, true
	case "BRADY_CORPORATION":
		return BACnetVendorId_BRADY_CORPORATION, true
	case "QINGDAO_HISENSE_HITACHI_AIR_CONDITIONING_SYSTEMS_CO_LTD":
		return BACnetVendorId_QINGDAO_HISENSE_HITACHI_AIR_CONDITIONING_SYSTEMS_CO_LTD, true
	case "GOLDEN_QUALITY_CO_LTD":
		return BACnetVendorId_GOLDEN_QUALITY_CO_LTD, true
	case "ELVACOAB":
		return BACnetVendorId_ELVACOAB, true
	case "STRONG_TECHNOLOGYLLC":
		return BACnetVendorId_STRONG_TECHNOLOGYLLC, true
	case "REC_ENVIRONMENTAL_TECHNOLOGY_GUANGZHOU_COMPANY_LIMITED":
		return BACnetVendorId_REC_ENVIRONMENTAL_TECHNOLOGY_GUANGZHOU_COMPANY_LIMITED, true
	case "DISRUPTIVE_TECHNOLOGIES_RESEARCHAS":
		return BACnetVendorId_DISRUPTIVE_TECHNOLOGIES_RESEARCHAS, true
	case "NICO_CONSULTANCY_LIMITED":
		return BACnetVendorId_NICO_CONSULTANCY_LIMITED, true
	case "HORTENLOT_JIANGSU_CO_LTD":
		return BACnetVendorId_HORTENLOT_JIANGSU_CO_LTD, true
	case "PAXTON_CONTROLS_CORP":
		return BACnetVendorId_PAXTON_CONTROLS_CORP, true
	case "TEMCO_CONTROLS_LTD":
		return BACnetVendorId_TEMCO_CONTROLS_LTD, true
	case "FELL_TECHNOLOGYAS":
		return BACnetVendorId_FELL_TECHNOLOGYAS, true
	case "SHLOK_INFORMATION_SYSTEMS_INDIA_PRIVATE_LIMITED":
		return BACnetVendorId_SHLOK_INFORMATION_SYSTEMS_INDIA_PRIVATE_LIMITED, true
	case "MICROGROPLC_LTD":
		return BACnetVendorId_MICROGROPLC_LTD, true
	case "CLOUDER_OY":
		return BACnetVendorId_CLOUDER_OY, true
	case "GEBUDE_AUTOMATISIERUNG_GMBH":
		return BACnetVendorId_GEBUDE_AUTOMATISIERUNG_GMBH, true
	case "SOLVIMUS_GMBH":
		return BACnetVendorId_SOLVIMUS_GMBH, true
	case "GUANG_ZHOU_WANGKONG_LTD":
		return BACnetVendorId_GUANG_ZHOU_WANGKONG_LTD, true
	case "SAFE_SQUARE_GMBH":
		return BACnetVendorId_SAFE_SQUARE_GMBH, true
	case "HEKLATECHAB":
		return BACnetVendorId_HEKLATECHAB, true
	case "SILVAIR":
		return BACnetVendorId_SILVAIR, true
	case "AIRTEK_INTERNATIONAL_INC":
		return BACnetVendorId_AIRTEK_INTERNATIONAL_INC, true
	case "ADVECO":
		return BACnetVendorId_ADVECO, true
	case "EURA_DRIVES_ELECTRIC_CO_LTD":
		return BACnetVendorId_EURA_DRIVES_ELECTRIC_CO_LTD, true
	case "CALEB_CONTROLS":
		return BACnetVendorId_CALEB_CONTROLS, true
	case "IN_BIOT_MONITORINGSL":
		return BACnetVendorId_IN_BIOT_MONITORINGSL, true
	case "QINGDAO_HAIER_AIR_CONDITIONER_ELECTRIC_CO_LTD":
		return BACnetVendorId_QINGDAO_HAIER_AIR_CONDITIONER_ELECTRIC_CO_LTD, true
	case "HANGZHOU_WEIYL_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_HANGZHOU_WEIYL_TECHNOLOGY_CO_LTD, true
	case "YORDSRL":
		return BACnetVendorId_YORDSRL, true
	case "INFINITUM_ELECTRIC":
		return BACnetVendorId_INFINITUM_ELECTRIC, true
	case "RED_BEAN_SYSTEMS_LIMITED":
		return BACnetVendorId_RED_BEAN_SYSTEMS_LIMITED, true
	case "BLUE_TIME_CONCEPTSA":
		return BACnetVendorId_BLUE_TIME_CONCEPTSA, true
	case "CORNELL_UNIVERSITY":
		return BACnetVendorId_CORNELL_UNIVERSITY, true
	case "ADVANTECH_CORPORATION":
		return BACnetVendorId_ADVANTECH_CORPORATION, true
	case "SHENZHENINVT_ELECTRIC_CO_LTD":
		return BACnetVendorId_SHENZHENINVT_ELECTRIC_CO_LTD, true
	case "MESSUNG_SYSTEMS_PVT_LTD":
		return BACnetVendorId_MESSUNG_SYSTEMS_PVT_LTD, true
	case "ABB_ELECTRIFICATION_CANADA_INC":
		return BACnetVendorId_ABB_ELECTRIFICATION_CANADA_INC, true
	case "CORE_CONTROLS":
		return BACnetVendorId_CORE_CONTROLS, true
	case "NOORD_TECHDOO":
		return BACnetVendorId_NOORD_TECHDOO, true
	case "VARIBITSAS":
		return BACnetVendorId_VARIBITSAS, true
	case "ROGER_SPZOOSPK":
		return BACnetVendorId_ROGER_SPZOOSPK, true
	case "VIEGA_GMBH_COKG":
		return BACnetVendorId_VIEGA_GMBH_COKG, true
	case "ASTERSOFT":
		return BACnetVendorId_ASTERSOFT, true
	case "BIGEU":
		return BACnetVendorId_BIGEU, true
	case "TITAN_PRODUCTS_LTD":
		return BACnetVendorId_TITAN_PRODUCTS_LTD, true
	case "INFERRIX_LIMITED":
		return BACnetVendorId_INFERRIX_LIMITED, true
	case "RICHARDS_ELECTRIC_MOTOR_CO":
		return BACnetVendorId_RICHARDS_ELECTRIC_MOTOR_CO, true
	case "DAPP_CONTROLS":
		return BACnetVendorId_DAPP_CONTROLS, true
	case "ENTOUCH_CONTROLS":
		return BACnetVendorId_ENTOUCH_CONTROLS, true
	case "MAVILI_ELEKTRONIK_TICARETVE_SANAYI_ANONIM_SIRKETI":
		return BACnetVendorId_MAVILI_ELEKTRONIK_TICARETVE_SANAYI_ANONIM_SIRKETI, true
	case "BUBBLY_NET":
		return BACnetVendorId_BUBBLY_NET, true
	case "AL_MAYSSAN_TECHNICAL_SERVICES_CO_LTD":
		return BACnetVendorId_AL_MAYSSAN_TECHNICAL_SERVICES_CO_LTD, true
	case "VIRIDI_PARENTE_INC":
		return BACnetVendorId_VIRIDI_PARENTE_INC, true
	case "NOVEL_APPS_CORP":
		return BACnetVendorId_NOVEL_APPS_CORP, true
	case "OVENTROP_CHINAHVAC_SYSTEM_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_OVENTROP_CHINAHVAC_SYSTEM_TECHNOLOGY_CO_LTD, true
	case "REGEL_PARTNERS":
		return BACnetVendorId_REGEL_PARTNERS, true
	case "LACROIX_SOFREL":
		return BACnetVendorId_LACROIX_SOFREL, true
	case "MACHINE_SENSLOT_TRADING_COLLC":
		return BACnetVendorId_MACHINE_SENSLOT_TRADING_COLLC, true
	case "ELMEC_INC":
		return BACnetVendorId_ELMEC_INC, true
	case "BEIJING_HAISHI_SOFTWARE_CO_LTD":
		return BACnetVendorId_BEIJING_HAISHI_SOFTWARE_CO_LTD, true
	case "RADIX_ELECTROSYSTEMS_PVT_LTD":
		return BACnetVendorId_RADIX_ELECTROSYSTEMS_PVT_LTD, true
	case "VRMEBARONENAB":
		return BACnetVendorId_VRMEBARONENAB, true
	case "TREAU_INCDBA_GRADIENT":
		return BACnetVendorId_TREAU_INCDBA_GRADIENT, true
	case "WEST_SOLUTIONAG":
		return BACnetVendorId_WEST_SOLUTIONAG, true
	case "TRUEWAY_CONTROLS_HONGKONG_LIMITED":
		return BACnetVendorId_TRUEWAY_CONTROLS_HONGKONG_LIMITED, true
	case "NATIONAL_ENVIRONMENTAL_PRODUCT":
		return BACnetVendorId_NATIONAL_ENVIRONMENTAL_PRODUCT, true
	case "BUILDING_LOGIX":
		return BACnetVendorId_BUILDING_LOGIX, true
	case "IFESCA_GMBH":
		return BACnetVendorId_IFESCA_GMBH, true
	case "FELLOWES_INC":
		return BACnetVendorId_FELLOWES_INC, true
	case "CALEFFI_SPA":
		return BACnetVendorId_CALEFFI_SPA, true
	case "JDRF_ELECTROMAG":
		return BACnetVendorId_JDRF_ELECTROMAG, true
	case "REDWIRE_LABS":
		return BACnetVendorId_REDWIRE_LABS, true
	case "WECON_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_WECON_TECHNOLOGY_CO_LTD, true
	case "ACACIA_GREEN_TECHNOLOGIES_LTD":
		return BACnetVendorId_ACACIA_GREEN_TECHNOLOGIES_LTD, true
	case "DEGREE_ANALYTICS":
		return BACnetVendorId_DEGREE_ANALYTICS, true
	case "ROLTEK_TEKNOLOJIAS":
		return BACnetVendorId_ROLTEK_TEKNOLOJIAS, true
	case "UNITEC_CORPORATION":
		return BACnetVendorId_UNITEC_CORPORATION, true
	case "DIGITAL_CONTROL_TECHNOLOGY_LIMITED":
		return BACnetVendorId_DIGITAL_CONTROL_TECHNOLOGY_LIMITED, true
	case "KENTIMAAB":
		return BACnetVendorId_KENTIMAAB, true
	case "PERGAMON_PERCEPTIVE_TECHNOLOGIES":
		return BACnetVendorId_PERGAMON_PERCEPTIVE_TECHNOLOGIES, true
	case "PREFECT_CONTROLS_LTD":
		return BACnetVendorId_PREFECT_CONTROLS_LTD, true
	case "SEN_TECH_CORPORATION":
		return BACnetVendorId_SEN_TECH_CORPORATION, true
	case "SS_REGELTECHNIK_GMBH":
		return BACnetVendorId_SS_REGELTECHNIK_GMBH, true
	case "AIR_BOX_INC":
		return BACnetVendorId_AIR_BOX_INC, true
	case "RVE":
		return BACnetVendorId_RVE, true
	case "MOTOROLA_SOLUTIONS":
		return BACnetVendorId_MOTOROLA_SOLUTIONS, true
	case "BACSYS_INNOVATIONS_PRIVATE_LIMITED":
		return BACnetVendorId_BACSYS_INNOVATIONS_PRIVATE_LIMITED, true
	case "KANDEN_ENGINEERING_COMPANY":
		return BACnetVendorId_KANDEN_ENGINEERING_COMPANY, true
	case "EWATTCH":
		return BACnetVendorId_EWATTCH, true
	case "BUILTLAYERLLC":
		return BACnetVendorId_BUILTLAYERLLC, true
	case "AG_DOMOTIXSRL":
		return BACnetVendorId_AG_DOMOTIXSRL, true
	case "HYTRONIK_INDUSTRIAL_LIMITED":
		return BACnetVendorId_HYTRONIK_INDUSTRIAL_LIMITED, true
	case "WHO_REINRAUMTECHNIK":
		return BACnetVendorId_WHO_REINRAUMTECHNIK, true
	case "TRICO_LIMITED":
		return BACnetVendorId_TRICO_LIMITED, true
	case "SLK_AUTOMATIONSRL":
		return BACnetVendorId_SLK_AUTOMATIONSRL, true
	case "ZAPHIREAS":
		return BACnetVendorId_ZAPHIREAS, true
	case "AJ_MANUFACTURING":
		return BACnetVendorId_AJ_MANUFACTURING, true
	case "FUTURE_MOTORS_LTD":
		return BACnetVendorId_FUTURE_MOTORS_LTD, true
	case "MESSNER_GEBUDETECHNIK_GMBH":
		return BACnetVendorId_MESSNER_GEBUDETECHNIK_GMBH, true
	case "HIMEL_HONG_KONG_LIMITED":
		return BACnetVendorId_HIMEL_HONG_KONG_LIMITED, true
	case "SHENZHEN_SUNRICHER_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_SHENZHEN_SUNRICHER_TECHNOLOGY_CO_LTD, true
	case "ACTILITYSA":
		return BACnetVendorId_ACTILITYSA, true
	case "OY_HALTON_GROUP_LTD":
		return BACnetVendorId_OY_HALTON_GROUP_LTD, true
	case "AVTECH_SOFTWARE_INC":
		return BACnetVendorId_AVTECH_SOFTWARE_INC, true
	case "IN_CONTROL_ENGINEERINGLLC":
		return BACnetVendorId_IN_CONTROL_ENGINEERINGLLC, true
	case "SOUND_WATER_TECHNOLOGIESLLC":
		return BACnetVendorId_SOUND_WATER_TECHNOLOGIESLLC, true
	case "INTEGRATEDCH":
		return BACnetVendorId_INTEGRATEDCH, true
	case "PRICE_INDUSTRIES":
		return BACnetVendorId_PRICE_INDUSTRIES, true
	case "SE_ELEKTRONIC_GMBH":
		return BACnetVendorId_SE_ELEKTRONIC_GMBH, true
	case "UNITED_TECHNOLOGIES_CARRIER":
		return BACnetVendorId_UNITED_TECHNOLOGIES_CARRIER, true
	case "ROCKWELL_AUTOMATION":
		return BACnetVendorId_ROCKWELL_AUTOMATION, true
	case "ENFLEX_CORP":
		return BACnetVendorId_ENFLEX_CORP, true
	case "ASI_CONTROLS":
		return BACnetVendorId_ASI_CONTROLS, true
	case "SYS_MIK_GMBH_DRESDEN":
		return BACnetVendorId_SYS_MIK_GMBH_DRESDEN, true
	case "HSC_REGELUNGSTECHNIK_GMBH":
		return BACnetVendorId_HSC_REGELUNGSTECHNIK_GMBH, true
	case "SMART_TEMP_AUSTRALIA_PTY_LTD":
		return BACnetVendorId_SMART_TEMP_AUSTRALIA_PTY_LTD, true
	case "COOPER_CONTROLS":
		return BACnetVendorId_COOPER_CONTROLS, true
	case "DUKSAN_MECASYS_CO_LTD":
		return BACnetVendorId_DUKSAN_MECASYS_CO_LTD, true
	case "FUJIIT_CO_LTD":
		return BACnetVendorId_FUJIIT_CO_LTD, true
	case "VACON_PLC":
		return BACnetVendorId_VACON_PLC, true
	case "HONEYWELL_INC":
		return BACnetVendorId_HONEYWELL_INC, true
	case "LEADER_CONTROLS":
		return BACnetVendorId_LEADER_CONTROLS, true
	case "ABB_FORMERLY_CYLON_CONTROLS_LTD":
		return BACnetVendorId_ABB_FORMERLY_CYLON_CONTROLS_LTD, true
	case "COMPAS":
		return BACnetVendorId_COMPAS, true
	case "MITSUBISHI_ELECTRIC_BUILDING_TECHNO_SERVICE_CO_LTD":
		return BACnetVendorId_MITSUBISHI_ELECTRIC_BUILDING_TECHNO_SERVICE_CO_LTD, true
	case "BUILDING_CONTROL_INTEGRATORS":
		return BACnetVendorId_BUILDING_CONTROL_INTEGRATORS, true
	case "ITG_WORLDWIDEM_SDN_BHD":
		return BACnetVendorId_ITG_WORLDWIDEM_SDN_BHD, true
	case "LUTRON_ELECTRONICS_CO_INC":
		return BACnetVendorId_LUTRON_ELECTRONICS_CO_INC, true
	case "COOPER_ATKINS_CORPORATION":
		return BACnetVendorId_COOPER_ATKINS_CORPORATION, true
	case "LOYTEC_ELECTRONICS_GMBH":
		return BACnetVendorId_LOYTEC_ELECTRONICS_GMBH, true
	case "PRO_LON":
		return BACnetVendorId_PRO_LON, true
	case "ALERTON_HONEYWELL":
		return BACnetVendorId_ALERTON_HONEYWELL, true
	case "MEGA_CONTROLS_LIMITED":
		return BACnetVendorId_MEGA_CONTROLS_LIMITED, true
	case "MICRO_CONTROL_SYSTEMS_INC":
		return BACnetVendorId_MICRO_CONTROL_SYSTEMS_INC, true
	case "KIYON_INC":
		return BACnetVendorId_KIYON_INC, true
	case "DUST_NETWORKS":
		return BACnetVendorId_DUST_NETWORKS, true
	case "ADVANCED_BUILDING_AUTOMATION_SYSTEMS":
		return BACnetVendorId_ADVANCED_BUILDING_AUTOMATION_SYSTEMS, true
	case "HERMOSAG":
		return BACnetVendorId_HERMOSAG, true
	case "CEZIM":
		return BACnetVendorId_CEZIM, true
	case "SOFTING":
		return BACnetVendorId_SOFTING, true
	case "LYNXSPRING_INC":
		return BACnetVendorId_LYNXSPRING_INC, true
	case "SCHNEIDER_TOSHIBA_INVERTER_EUROPE":
		return BACnetVendorId_SCHNEIDER_TOSHIBA_INVERTER_EUROPE, true
	case "TACAB":
		return BACnetVendorId_TACAB, true
	case "DANFOSS_DRIVESAS":
		return BACnetVendorId_DANFOSS_DRIVESAS, true
	case "EATON_CORPORATION":
		return BACnetVendorId_EATON_CORPORATION, true
	case "MATYCASA":
		return BACnetVendorId_MATYCASA, true
	case "BOTECHAB":
		return BACnetVendorId_BOTECHAB, true
	case "NOVEO_INC":
		return BACnetVendorId_NOVEO_INC, true
	case "AMEV":
		return BACnetVendorId_AMEV, true
	case "YOKOGAWA_ELECTRIC_CORPORATION":
		return BACnetVendorId_YOKOGAWA_ELECTRIC_CORPORATION, true
	case "BOSCH_BUILDING_AUTOMATION_GMBH":
		return BACnetVendorId_BOSCH_BUILDING_AUTOMATION_GMBH, true
	case "EXACT_LOGIC":
		return BACnetVendorId_EXACT_LOGIC, true
	case "MASS_ELECTRONICS_PTY_LTDDBA_INNOTECH_CONTROL_SYSTEMS_AUSTRALIA":
		return BACnetVendorId_MASS_ELECTRONICS_PTY_LTDDBA_INNOTECH_CONTROL_SYSTEMS_AUSTRALIA, true
	case "THE_TRANE_COMPANY":
		return BACnetVendorId_THE_TRANE_COMPANY, true
	case "HEWLETT_PACKARD_COMPANY":
		return BACnetVendorId_HEWLETT_PACKARD_COMPANY, true
	case "KANDENKO_CO_LTD":
		return BACnetVendorId_KANDENKO_CO_LTD, true
	case "DTF_DATEN_TECHNIK_FRIES":
		return BACnetVendorId_DTF_DATEN_TECHNIK_FRIES, true
	case "KLIMASOFT_LTD":
		return BACnetVendorId_KLIMASOFT_LTD, true
	case "TOSHIBA_SCHNEIDER_INVERTER_CORPORATION":
		return BACnetVendorId_TOSHIBA_SCHNEIDER_INVERTER_CORPORATION, true
	case "CONTROL_APPLICATIONS_LTD":
		return BACnetVendorId_CONTROL_APPLICATIONS_LTD, true
	case "CIMONCO_LTD":
		return BACnetVendorId_CIMONCO_LTD, true
	case "ONICON_INCORPORATED":
		return BACnetVendorId_ONICON_INCORPORATED, true
	case "AUTOMATION_DISPLAYS_INC":
		return BACnetVendorId_AUTOMATION_DISPLAYS_INC, true
	case "CONTROL_SOLUTIONS_INC":
		return BACnetVendorId_CONTROL_SOLUTIONS_INC, true
	case "REMSDAQ_LIMITED":
		return BACnetVendorId_REMSDAQ_LIMITED, true
	case "DORSETTES_INC":
		return BACnetVendorId_DORSETTES_INC, true
	case "NTT_FACILITIES_INC":
		return BACnetVendorId_NTT_FACILITIES_INC, true
	case "VIPA_GMBH":
		return BACnetVendorId_VIPA_GMBH, true
	case "TSC1_ASSOCIATIONOF_JAPAN":
		return BACnetVendorId_TSC1_ASSOCIATIONOF_JAPAN, true
	case "STRATO_AUTOMATION":
		return BACnetVendorId_STRATO_AUTOMATION, true
	case "HRW_LIMITED":
		return BACnetVendorId_HRW_LIMITED, true
	case "LIGHTING_CONTROL_DESIGN_INC":
		return BACnetVendorId_LIGHTING_CONTROL_DESIGN_INC, true
	case "MERCY_ELECTRONICAND_ELECTRICAL_INDUSTRIES":
		return BACnetVendorId_MERCY_ELECTRONICAND_ELECTRICAL_INDUSTRIES, true
	case "SAMSUNGSDS_CO_LTD":
		return BACnetVendorId_SAMSUNGSDS_CO_LTD, true
	case "IMPACT_FACILITY_SOLUTIONS_INC":
		return BACnetVendorId_IMPACT_FACILITY_SOLUTIONS_INC, true
	case "AIRCUITY":
		return BACnetVendorId_AIRCUITY, true
	case "SIEMENS_SCHWEIZAG2":
		return BACnetVendorId_SIEMENS_SCHWEIZAG2, true
	case "CONTROL_TECHNIQUES_LTD":
		return BACnetVendorId_CONTROL_TECHNIQUES_LTD, true
	case "OPEN_GENERAL_PTY_LTD":
		return BACnetVendorId_OPEN_GENERAL_PTY_LTD, true
	case "WAGO_KONTAKTTECHNIK_GMBH_COKG":
		return BACnetVendorId_WAGO_KONTAKTTECHNIK_GMBH_COKG, true
	case "FRANKLIN_ELECTRIC":
		return BACnetVendorId_FRANKLIN_ELECTRIC, true
	case "CHLORIDE_POWER_PROTECTION_COMPANY":
		return BACnetVendorId_CHLORIDE_POWER_PROTECTION_COMPANY, true
	case "COMPUTROLS_INC":
		return BACnetVendorId_COMPUTROLS_INC, true
	case "PHOENIX_CONTACT_GMBH_COKG":
		return BACnetVendorId_PHOENIX_CONTACT_GMBH_COKG, true
	case "GRUNDFOS_MANAGEMENTAS":
		return BACnetVendorId_GRUNDFOS_MANAGEMENTAS, true
	case "RIDDER_DRIVE_SYSTEMS":
		return BACnetVendorId_RIDDER_DRIVE_SYSTEMS, true
	case "SOFT_DEVICESDNBHD":
		return BACnetVendorId_SOFT_DEVICESDNBHD, true
	case "YORK_CONTROLS_GROUP":
		return BACnetVendorId_YORK_CONTROLS_GROUP, true
	case "INTEGRATED_CONTROL_TECHNOLOGY_LIMITED":
		return BACnetVendorId_INTEGRATED_CONTROL_TECHNOLOGY_LIMITED, true
	case "AI_RXPERT_SYSTEMS_INC":
		return BACnetVendorId_AI_RXPERT_SYSTEMS_INC, true
	case "MICROTROL_LIMITED":
		return BACnetVendorId_MICROTROL_LIMITED, true
	case "RED_LION_CONTROLS":
		return BACnetVendorId_RED_LION_CONTROLS, true
	case "DIGITAL_ELECTRONICS_CORPORATION":
		return BACnetVendorId_DIGITAL_ELECTRONICS_CORPORATION, true
	case "ENNOVATIS_GMBH":
		return BACnetVendorId_ENNOVATIS_GMBH, true
	case "SEROTONIN_SOFTWARE_TECHNOLOGIES_INC":
		return BACnetVendorId_SEROTONIN_SOFTWARE_TECHNOLOGIES_INC, true
	case "LS_INDUSTRIAL_SYSTEMS_CO_LTD":
		return BACnetVendorId_LS_INDUSTRIAL_SYSTEMS_CO_LTD, true
	case "SQUARED_COMPANY":
		return BACnetVendorId_SQUARED_COMPANY, true
	case "S_SQUARED_INNOVATIONS_INC":
		return BACnetVendorId_S_SQUARED_INNOVATIONS_INC, true
	case "AUTOMATED_LOGIC_CORPORATION":
		return BACnetVendorId_AUTOMATED_LOGIC_CORPORATION, true
	case "ARICENT_LTD":
		return BACnetVendorId_ARICENT_LTD, true
	case "ETHER_METRICSLLC":
		return BACnetVendorId_ETHER_METRICSLLC, true
	case "INDUSTRIAL_CONTROL_COMMUNICATIONS_INC":
		return BACnetVendorId_INDUSTRIAL_CONTROL_COMMUNICATIONS_INC, true
	case "PARAGON_CONTROLS_INC":
		return BACnetVendorId_PARAGON_CONTROLS_INC, true
	case "AO_SMITH_CORPORATION":
		return BACnetVendorId_AO_SMITH_CORPORATION, true
	case "CONTEMPORARY_CONTROL_SYSTEMS_INC":
		return BACnetVendorId_CONTEMPORARY_CONTROL_SYSTEMS_INC, true
	case "HMS_INDUSTRIAL_NETWORKSSLU":
		return BACnetVendorId_HMS_INDUSTRIAL_NETWORKSSLU, true
	case "INGENIEURGESELLSCHAFTN_HARTLEBMBH":
		return BACnetVendorId_INGENIEURGESELLSCHAFTN_HARTLEBMBH, true
	case "HEAT_TIMER_CORPORATION":
		return BACnetVendorId_HEAT_TIMER_CORPORATION, true
	case "INGRASYS_TECHNOLOGY_INC":
		return BACnetVendorId_INGRASYS_TECHNOLOGY_INC, true
	case "CSI_CONTROL_SYSTEMS_INTERNATIONAL":
		return BACnetVendorId_CSI_CONTROL_SYSTEMS_INTERNATIONAL, true
	case "COSTERM_BUILDING_AUTOMATION":
		return BACnetVendorId_COSTERM_BUILDING_AUTOMATION, true
	case "WILOSE":
		return BACnetVendorId_WILOSE, true
	case "EMBEDIA_TECHNOLOGIES_CORP":
		return BACnetVendorId_EMBEDIA_TECHNOLOGIES_CORP, true
	case "TECHNILOG":
		return BACnetVendorId_TECHNILOG, true
	case "HR_CONTROLS_LTD_COKG":
		return BACnetVendorId_HR_CONTROLS_LTD_COKG, true
	case "LENNOX_INTERNATIONAL_INC":
		return BACnetVendorId_LENNOX_INTERNATIONAL_INC, true
	case "RK_TEC_RAUCHKLAPPEN_STEUERUNGSSYSTEME_GMBH_COKG":
		return BACnetVendorId_RK_TEC_RAUCHKLAPPEN_STEUERUNGSSYSTEME_GMBH_COKG, true
	case "THERMOMAX_LTD":
		return BACnetVendorId_THERMOMAX_LTD, true
	case "ELCON_ELECTRONIC_CONTROL_LTD":
		return BACnetVendorId_ELCON_ELECTRONIC_CONTROL_LTD, true
	case "LARMIA_CONTROLAB":
		return BACnetVendorId_LARMIA_CONTROLAB, true
	case "PHOENIX_CONTROLS_CORPORATION":
		return BACnetVendorId_PHOENIX_CONTROLS_CORPORATION, true
	case "BA_CNET_STACKAT_SOURCE_FORGE":
		return BACnetVendorId_BA_CNET_STACKAT_SOURCE_FORGE, true
	case "GS_SECURITY_SERVICESAS":
		return BACnetVendorId_GS_SECURITY_SERVICESAS, true
	case "EXOR_INTERNATIONAL_SPA":
		return BACnetVendorId_EXOR_INTERNATIONAL_SPA, true
	case "CRISTAL_CONTROLES":
		return BACnetVendorId_CRISTAL_CONTROLES, true
	case "REGINAB":
		return BACnetVendorId_REGINAB, true
	case "DIMENSION_SOFTWARE_INC":
		return BACnetVendorId_DIMENSION_SOFTWARE_INC, true
	case "SYNAP_SENSE_CORPORATION":
		return BACnetVendorId_SYNAP_SENSE_CORPORATION, true
	case "BEIJING_NANTREE_ELECTRONIC_CO_LTD":
		return BACnetVendorId_BEIJING_NANTREE_ELECTRONIC_CO_LTD, true
	case "CAMUS_HYDRONICS_LTD":
		return BACnetVendorId_CAMUS_HYDRONICS_LTD, true
	case "KAWASAKI_HEAVY_INDUSTRIES_LTD":
		return BACnetVendorId_KAWASAKI_HEAVY_INDUSTRIES_LTD, true
	case "INNOVEX_TECHNOLOGIES_INC":
		return BACnetVendorId_INNOVEX_TECHNOLOGIES_INC, true
	case "CRITICAL_ENVIRONMENT_TECHNOLOGIES":
		return BACnetVendorId_CRITICAL_ENVIRONMENT_TECHNOLOGIES, true
	case "ILSHINIBS_CO_LTD":
		return BACnetVendorId_ILSHINIBS_CO_LTD, true
	case "ELESTA_ENERGY_CONTROLAG":
		return BACnetVendorId_ELESTA_ENERGY_CONTROLAG, true
	case "KROPMAN_INSTALLATIETECHNIEK":
		return BACnetVendorId_KROPMAN_INSTALLATIETECHNIEK, true
	case "BALDOR_ELECTRIC_COMPANY":
		return BACnetVendorId_BALDOR_ELECTRIC_COMPANY, true
	case "ING_AMBH":
		return BACnetVendorId_ING_AMBH, true
	case "GE_CONSUMER_INDUSTRIAL":
		return BACnetVendorId_GE_CONSUMER_INDUSTRIAL, true
	case "FUNCTIONAL_DEVICES_INC":
		return BACnetVendorId_FUNCTIONAL_DEVICES_INC, true
	case "STUDIOSC":
		return BACnetVendorId_STUDIOSC, true
	case "MGCOLTD":
		return BACnetVendorId_MGCOLTD, true
	case "KMC_CONTROLS_INC":
		return BACnetVendorId_KMC_CONTROLS_INC, true
	case "YOKOTA_CO_LTD":
		return BACnetVendorId_YOKOTA_CO_LTD, true
	case "HITRANSE_TECHNOLOGY_COLTD":
		return BACnetVendorId_HITRANSE_TECHNOLOGY_COLTD, true
	case "VIGILENT_CORPORATION":
		return BACnetVendorId_VIGILENT_CORPORATION, true
	case "KELE_INC":
		return BACnetVendorId_KELE_INC, true
	case "BELIMO_AUTOMATIONAG":
		return BACnetVendorId_BELIMO_AUTOMATIONAG, true
	case "GENTEC":
		return BACnetVendorId_GENTEC, true
	case "EMBEDDED_SCIENCE_LABSLLC":
		return BACnetVendorId_EMBEDDED_SCIENCE_LABSLLC, true
	case "PARKER_HANNIFIN_CORPORATION":
		return BACnetVendorId_PARKER_HANNIFIN_CORPORATION, true
	case "MA_CAPS_INTERNATIONAL_LIMITED":
		return BACnetVendorId_MA_CAPS_INTERNATIONAL_LIMITED, true
	case "LINK_CORPORATION":
		return BACnetVendorId_LINK_CORPORATION, true
	case "XN_TECHNOLOGIES_INC":
		return BACnetVendorId_XN_TECHNOLOGIES_INC, true
	case "ROMUTEC_STEUERU_REGELSYSTEME_GMBH":
		return BACnetVendorId_ROMUTEC_STEUERU_REGELSYSTEME_GMBH, true
	case "PRIBUSIN_INC":
		return BACnetVendorId_PRIBUSIN_INC, true
	case "ADVANTAGE_CONTROLS":
		return BACnetVendorId_ADVANTAGE_CONTROLS, true
	case "CRITICAL_ROOM_CONTROL":
		return BACnetVendorId_CRITICAL_ROOM_CONTROL, true
	case "LEGRAND":
		return BACnetVendorId_LEGRAND, true
	case "TONGDY_CONTROL_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_TONGDY_CONTROL_TECHNOLOGY_CO_LTD, true
	case "ISSARO_INTEGRIERTE_SYSTEMTECHNIK":
		return BACnetVendorId_ISSARO_INTEGRIERTE_SYSTEMTECHNIK, true
	case "PRO_DEV_INDUSTRIES":
		return BACnetVendorId_PRO_DEV_INDUSTRIES, true
	case "DRISTEEM":
		return BACnetVendorId_DRISTEEM, true
	case "CREATIVE_ELECTRONIC_GMBH":
		return BACnetVendorId_CREATIVE_ELECTRONIC_GMBH, true
	case "DAIKIN_APPLIED_AMERICAS":
		return BACnetVendorId_DAIKIN_APPLIED_AMERICAS, true
	case "HYUNDAI_INFORMATION_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_HYUNDAI_INFORMATION_TECHNOLOGY_CO_LTD, true
	case "SWEGONAB":
		return BACnetVendorId_SWEGONAB, true
	case "FIRVEN_ASRO":
		return BACnetVendorId_FIRVEN_ASRO, true
	case "HITACHI_APPLIANCES_INC":
		return BACnetVendorId_HITACHI_APPLIANCES_INC, true
	case "REAL_TIME_AUTOMATION_INC":
		return BACnetVendorId_REAL_TIME_AUTOMATION_INC, true
	case "ITEC_HANKYU_HANSHIN_CO":
		return BACnetVendorId_ITEC_HANKYU_HANSHIN_CO, true
	case "CYRUSEM_ENGINEERING_CO_LTD":
		return BACnetVendorId_CYRUSEM_ENGINEERING_CO_LTD, true
	case "BADGER_METER":
		return BACnetVendorId_BADGER_METER, true
	case "CIRRASCALE_CORPORATION":
		return BACnetVendorId_CIRRASCALE_CORPORATION, true
	case "ELESTA_GMBH_BUILDING_AUTOMATION":
		return BACnetVendorId_ELESTA_GMBH_BUILDING_AUTOMATION, true
	case "SECURITON":
		return BACnetVendorId_SECURITON, true
	case "TOKIMEC_INC":
		return BACnetVendorId_TOKIMEC_INC, true
	case "O_SLSOFT_INC":
		return BACnetVendorId_O_SLSOFT_INC, true
	case "HANAZEDER_ELECTRONIC_GMBH":
		return BACnetVendorId_HANAZEDER_ELECTRONIC_GMBH, true
	case "HONEYWELL_SECURITY_DEUTSCHLAND_NOVAR_GMBH":
		return BACnetVendorId_HONEYWELL_SECURITY_DEUTSCHLAND_NOVAR_GMBH, true
	case "SIEMENS_INDUSTRY_INC":
		return BACnetVendorId_SIEMENS_INDUSTRY_INC, true
	case "ETM_PROFESSIONAL_CONTROL_GMBH":
		return BACnetVendorId_ETM_PROFESSIONAL_CONTROL_GMBH, true
	case "MEITAVTEC_LTD":
		return BACnetVendorId_MEITAVTEC_LTD, true
	case "JANITZA_ELECTRONICS_GMBH":
		return BACnetVendorId_JANITZA_ELECTRONICS_GMBH, true
	case "MKS_NORDHAUSEN":
		return BACnetVendorId_MKS_NORDHAUSEN, true
	case "DE_GIER_DRIVE_SYSTEMSBV":
		return BACnetVendorId_DE_GIER_DRIVE_SYSTEMSBV, true
	case "CYPRESS_ENVIROSYSTEMS":
		return BACnetVendorId_CYPRESS_ENVIROSYSTEMS, true
	case "SIMPLEX":
		return BACnetVendorId_SIMPLEX, true
	case "SMAR_TRONSRO":
		return BACnetVendorId_SMAR_TRONSRO, true
	case "VERARI_SYSTEMS_INC":
		return BACnetVendorId_VERARI_SYSTEMS_INC, true
	case "KW_ELECTRONIC_SERVICE_INC":
		return BACnetVendorId_KW_ELECTRONIC_SERVICE_INC, true
	case "ALFASMART_ENERGY_MANAGEMENT":
		return BACnetVendorId_ALFASMART_ENERGY_MANAGEMENT, true
	case "TELKONET_INC":
		return BACnetVendorId_TELKONET_INC, true
	case "SECURITON_GMBH":
		return BACnetVendorId_SECURITON_GMBH, true
	case "CEMTREX_INC":
		return BACnetVendorId_CEMTREX_INC, true
	case "PERFORMANCE_TECHNOLOGIES_INC":
		return BACnetVendorId_PERFORMANCE_TECHNOLOGIES_INC, true
	case "XTRALIS_AUST_PTY_LTD":
		return BACnetVendorId_XTRALIS_AUST_PTY_LTD, true
	case "TROX_GMBH":
		return BACnetVendorId_TROX_GMBH, true
	case "NORTH_BUILDING_TECHNOLOGIES_LIMITED":
		return BACnetVendorId_NORTH_BUILDING_TECHNOLOGIES_LIMITED, true
	case "BEIJING_HYSINE_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_BEIJING_HYSINE_TECHNOLOGY_CO_LTD, true
	case "RCK_CONTROLS_INC":
		return BACnetVendorId_RCK_CONTROLS_INC, true
	case "DISTECH_CONTROLSSAS":
		return BACnetVendorId_DISTECH_CONTROLSSAS, true
	case "NOVAR_HONEYWELL":
		return BACnetVendorId_NOVAR_HONEYWELL, true
	case "S_INTEGRATION_SOLUTIONS":
		return BACnetVendorId_S_INTEGRATION_SOLUTIONS, true
	case "SCHNEIDER_ELECTRIC1":
		return BACnetVendorId_SCHNEIDER_ELECTRIC1, true
	case "LHA_SYSTEMS":
		return BACnetVendorId_LHA_SYSTEMS, true
	case "GH_MENGINEERING_GROUP_INC":
		return BACnetVendorId_GH_MENGINEERING_GROUP_INC, true
	case "CLLIMALUXSA":
		return BACnetVendorId_CLLIMALUXSA, true
	case "VAISALA_OYJ":
		return BACnetVendorId_VAISALA_OYJ, true
	case "NOTIFIER":
		return BACnetVendorId_NOTIFIER, true
	case "COMPLEX_BEIJING_TECHNOLOGY_COLTD":
		return BACnetVendorId_COMPLEX_BEIJING_TECHNOLOGY_COLTD, true
	case "SCAD_AMETRICS":
		return BACnetVendorId_SCAD_AMETRICS, true
	case "POWERPEGNSI_LIMITED":
		return BACnetVendorId_POWERPEGNSI_LIMITED, true
	case "BA_CNET_INTEROPERABILITY_TESTING_SERVICES_INC":
		return BACnetVendorId_BA_CNET_INTEROPERABILITY_TESTING_SERVICES_INC, true
	case "TECOAS":
		return BACnetVendorId_TECOAS, true
	case "PLEXUS_TECHNOLOGY_INC":
		return BACnetVendorId_PLEXUS_TECHNOLOGY_INC, true
	case "ENERGY_FOCUS_INC":
		return BACnetVendorId_ENERGY_FOCUS_INC, true
	case "POWERSMITHS_INTERNATIONAL_CORP":
		return BACnetVendorId_POWERSMITHS_INTERNATIONAL_CORP, true
	case "NICHIBEI_CO_LTD":
		return BACnetVendorId_NICHIBEI_CO_LTD, true
	case "HKC_TECHNOLOGY_LTD":
		return BACnetVendorId_HKC_TECHNOLOGY_LTD, true
	case "RELIABLE_CONTROLS_CORPORATION":
		return BACnetVendorId_RELIABLE_CONTROLS_CORPORATION, true
	case "OVATION_NETWORKS_INC":
		return BACnetVendorId_OVATION_NETWORKS_INC, true
	case "SETRA_SYSTEMS":
		return BACnetVendorId_SETRA_SYSTEMS, true
	case "AVG_AUTOMATION":
		return BACnetVendorId_AVG_AUTOMATION, true
	case "ZXC_LTD":
		return BACnetVendorId_ZXC_LTD, true
	case "BYTE_SPHERE":
		return BACnetVendorId_BYTE_SPHERE, true
	case "GENERITON_CO_LTD":
		return BACnetVendorId_GENERITON_CO_LTD, true
	case "HOLTER_REGELARMATUREN_GMBH_COKG":
		return BACnetVendorId_HOLTER_REGELARMATUREN_GMBH_COKG, true
	case "BEDFORD_INSTRUMENTSLLC":
		return BACnetVendorId_BEDFORD_INSTRUMENTSLLC, true
	case "STANDAIR_INC":
		return BACnetVendorId_STANDAIR_INC, true
	case "WEG_AUTOMATIONRD":
		return BACnetVendorId_WEG_AUTOMATIONRD, true
	case "TRIDIUM_INC":
		return BACnetVendorId_TRIDIUM_INC, true
	case "PROLON_CONTROL_SYSTEMS_APS":
		return BACnetVendorId_PROLON_CONTROL_SYSTEMS_APS, true
	case "INNEASOFT":
		return BACnetVendorId_INNEASOFT, true
	case "CONNEX_SOFT_GMBH":
		return BACnetVendorId_CONNEX_SOFT_GMBH, true
	case "CEAG_NOTLICHTSYSTEME_GMBH":
		return BACnetVendorId_CEAG_NOTLICHTSYSTEME_GMBH, true
	case "DISTECH_CONTROLS_INC":
		return BACnetVendorId_DISTECH_CONTROLS_INC, true
	case "INDUSTRIAL_TECHNOLOGY_RESEARCH_INSTITUTE":
		return BACnetVendorId_INDUSTRIAL_TECHNOLOGY_RESEARCH_INSTITUTE, true
	case "MITSUBISHI_ELECTRIC_ICONICS_DIGITAL_SOLUTIONS":
		return BACnetVendorId_MITSUBISHI_ELECTRIC_ICONICS_DIGITAL_SOLUTIONS, true
	case "IQ_CONTROLSSC":
		return BACnetVendorId_IQ_CONTROLSSC, true
	case "OJ_ELECTRONICSAS":
		return BACnetVendorId_OJ_ELECTRONICSAS, true
	case "ROLBIT_LTD":
		return BACnetVendorId_ROLBIT_LTD, true
	case "MSA_SAFETY":
		return BACnetVendorId_MSA_SAFETY, true
	case "SYNAPSYS_SOLUTIONS_LTD":
		return BACnetVendorId_SYNAPSYS_SOLUTIONS_LTD, true
	case "ACME_ENGINEERING_PROD_LTD":
		return BACnetVendorId_ACME_ENGINEERING_PROD_LTD, true
	case "ZENER_ELECTRIC_PTY_LTD":
		return BACnetVendorId_ZENER_ELECTRIC_PTY_LTD, true
	case "SELECTRONIX_INC":
		return BACnetVendorId_SELECTRONIX_INC, true
	case "GORBET_BANERJEELLC":
		return BACnetVendorId_GORBET_BANERJEELLC, true
	case "IME":
		return BACnetVendorId_IME, true
	case "STEPHENH_DAWSON_COMPUTER_SERVICE":
		return BACnetVendorId_STEPHENH_DAWSON_COMPUTER_SERVICE, true
	case "ACCUTROLLLC":
		return BACnetVendorId_ACCUTROLLLC, true
	case "SCHNEIDER_ELEKTRONIK_GMBH":
		return BACnetVendorId_SCHNEIDER_ELEKTRONIK_GMBH, true
	case "ALPHA_INNO_TEC_GMBH":
		return BACnetVendorId_ALPHA_INNO_TEC_GMBH, true
	case "SILICON_ENERGY":
		return BACnetVendorId_SILICON_ENERGY, true
	case "ADM_MICRO_INC":
		return BACnetVendorId_ADM_MICRO_INC, true
	case "GREYSTONE_ENERGY_SYSTEMS_INC":
		return BACnetVendorId_GREYSTONE_ENERGY_SYSTEMS_INC, true
	case "CAP_TECHNOLOGIE":
		return BACnetVendorId_CAP_TECHNOLOGIE, true
	case "KE_RO_SYSTEMS":
		return BACnetVendorId_KE_RO_SYSTEMS, true
	case "DOMAT_CONTROL_SYSTEMSRO":
		return BACnetVendorId_DOMAT_CONTROL_SYSTEMSRO, true
	case "EFEKTRONICS_PTY_LTD":
		return BACnetVendorId_EFEKTRONICS_PTY_LTD, true
	case "HEKATRON_VERTRIEBS_GMBH":
		return BACnetVendorId_HEKATRON_VERTRIEBS_GMBH, true
	case "SECURITONAG":
		return BACnetVendorId_SECURITONAG, true
	case "CARLO_GAVAZZI_CONTROLS_SPA":
		return BACnetVendorId_CARLO_GAVAZZI_CONTROLS_SPA, true
	case "CHIPKIN_AUTOMATION_SYSTEMS":
		return BACnetVendorId_CHIPKIN_AUTOMATION_SYSTEMS, true
	case "KIEBACK_PETER_GMBH_COKG":
		return BACnetVendorId_KIEBACK_PETER_GMBH_COKG, true
	case "SAVANT_SYSTEMSLLC":
		return BACnetVendorId_SAVANT_SYSTEMSLLC, true
	case "SIMMTRONIC_LIGHTING_CONTROLS":
		return BACnetVendorId_SIMMTRONIC_LIGHTING_CONTROLS, true
	case "ABELKO_INNOVATIONAB":
		return BACnetVendorId_ABELKO_INNOVATIONAB, true
	case "SERESCO_TECHNOLOGIES_INC":
		return BACnetVendorId_SERESCO_TECHNOLOGIES_INC, true
	case "IT_WATCHDOGS":
		return BACnetVendorId_IT_WATCHDOGS, true
	case "AUTOMATION_ASSIST_JAPAN_CORP":
		return BACnetVendorId_AUTOMATION_ASSIST_JAPAN_CORP, true
	case "THERMOKON_SENSORTECHNIK_GMBH":
		return BACnetVendorId_THERMOKON_SENSORTECHNIK_GMBH, true
	case "E_GAUGE_SYSTEMSLLC":
		return BACnetVendorId_E_GAUGE_SYSTEMSLLC, true
	case "QUANTUM_AUTOMATIONASIAPTE_LTD":
		return BACnetVendorId_QUANTUM_AUTOMATIONASIAPTE_LTD, true
	case "TOSHIBA_LIGHTING_TECHNOLOGY_CORP":
		return BACnetVendorId_TOSHIBA_LIGHTING_TECHNOLOGY_CORP, true
	case "POLAR_SOFT":
		return BACnetVendorId_POLAR_SOFT, true
	case "ANACON_SYSTEMS_INC":
		return BACnetVendorId_ANACON_SYSTEMS_INC, true
	case "SPIN_ENGENHARIADE_AUTOMAO_LTDA":
		return BACnetVendorId_SPIN_ENGENHARIADE_AUTOMAO_LTDA, true
	case "LOGISTICS_SYSTEMS_SOFTWARE_SERVICES_INDIAPVT_LTD":
		return BACnetVendorId_LOGISTICS_SYSTEMS_SOFTWARE_SERVICES_INDIAPVT_LTD, true
	case "DELTA_CONTROLS_INTEGRATION_PRODUCTS":
		return BACnetVendorId_DELTA_CONTROLS_INTEGRATION_PRODUCTS, true
	case "FOCUS_MEDIA":
		return BACnetVendorId_FOCUS_MEDIA, true
	case "LUM_ENERGI_INC":
		return BACnetVendorId_LUM_ENERGI_INC, true
	case "KARA_SYSTEMS":
		return BACnetVendorId_KARA_SYSTEMS, true
	case "RF_CODE_INC":
		return BACnetVendorId_RF_CODE_INC, true
	case "FATEK_AUTOMATION_CORP":
		return BACnetVendorId_FATEK_AUTOMATION_CORP, true
	case "JANDA_SOFTWARE_COMPANYLLC":
		return BACnetVendorId_JANDA_SOFTWARE_COMPANYLLC, true
	case "OPEN_SYSTEM_SOLUTIONS_LIMITED":
		return BACnetVendorId_OPEN_SYSTEM_SOLUTIONS_LIMITED, true
	case "SYSTEMS_CONTROLS_INSTRUMENTSLLC":
		return BACnetVendorId_SYSTEMS_CONTROLS_INSTRUMENTSLLC, true
	case "INTELEC_SYSTEMSPTY_LTD":
		return BACnetVendorId_INTELEC_SYSTEMSPTY_LTD, true
	case "ECOLODGIXLLC":
		return BACnetVendorId_ECOLODGIXLLC, true
	case "DOUGLAS_LIGHTING_CONTROLS":
		return BACnetVendorId_DOUGLAS_LIGHTING_CONTROLS, true
	case "IS_ATECH_GMBH":
		return BACnetVendorId_IS_ATECH_GMBH, true
	case "AREAL":
		return BACnetVendorId_AREAL, true
	case "BECKHOFF_AUTOMATION":
		return BACnetVendorId_BECKHOFF_AUTOMATION, true
	case "IPAS_GMBH":
		return BACnetVendorId_IPAS_GMBH, true
	case "KE_THERM_SOLUTIONS":
		return BACnetVendorId_KE_THERM_SOLUTIONS, true
	case "BASE_PRODUCTS":
		return BACnetVendorId_BASE_PRODUCTS, true
	case "DTL_CONTROLSLLC":
		return BACnetVendorId_DTL_CONTROLSLLC, true
	case "ACUITY_BRANDS_LIGHTING_INC":
		return BACnetVendorId_ACUITY_BRANDS_LIGHTING_INC, true
	case "INNCOM_INTERNATIONAL_INC":
		return BACnetVendorId_INNCOM_INTERNATIONAL_INC, true
	case "METZCONNECT_GMBH":
		return BACnetVendorId_METZCONNECT_GMBH, true
	case "GREENTROL_AUTOMATION_INC":
		return BACnetVendorId_GREENTROL_AUTOMATION_INC, true
	case "BELIMO_AUTOMATIONAG1":
		return BACnetVendorId_BELIMO_AUTOMATIONAG1, true
	case "SAMSUNG_HEAVY_INDUSTRIES_CO_LTD":
		return BACnetVendorId_SAMSUNG_HEAVY_INDUSTRIES_CO_LTD, true
	case "TRIACTA_POWER_TECHNOLOGIES_INC":
		return BACnetVendorId_TRIACTA_POWER_TECHNOLOGIES_INC, true
	case "GLOBESTAR_SYSTEMS":
		return BACnetVendorId_GLOBESTAR_SYSTEMS, true
	case "MLB_ADVANCED_MEDIALP":
		return BACnetVendorId_MLB_ADVANCED_MEDIALP, true
	case "SWG_STUCKMANN_WIRTSCHAFTLICHE_GEBUDESYSTEME_GMBH":
		return BACnetVendorId_SWG_STUCKMANN_WIRTSCHAFTLICHE_GEBUDESYSTEME_GMBH, true
	case "SENSOR_SWITCH":
		return BACnetVendorId_SENSOR_SWITCH, true
	case "MICROPOWER_MANUFACTURING":
		return BACnetVendorId_MICROPOWER_MANUFACTURING, true
	case "MULTITEK_POWER_LIMITED":
		return BACnetVendorId_MULTITEK_POWER_LIMITED, true
	case "INTEGRA_METERINGAG":
		return BACnetVendorId_INTEGRA_METERINGAG, true
	case "LG_ELECTRONICS_INC":
		return BACnetVendorId_LG_ELECTRONICS_INC, true
	case "ELECTRONIC_THEATRE_CONTROLS_INC":
		return BACnetVendorId_ELECTRONIC_THEATRE_CONTROLS_INC, true
	case "MITSUBISHI_ELECTRIC_CORPORATION_NAGOYA_WORKS":
		return BACnetVendorId_MITSUBISHI_ELECTRIC_CORPORATION_NAGOYA_WORKS, true
	case "DELTA_ELECTRONICS_INC":
		return BACnetVendorId_DELTA_ELECTRONICS_INC, true
	case "ELMA_KURTALJ_LTD":
		return BACnetVendorId_ELMA_KURTALJ_LTD, true
	case "TYCO_FIRE_SECURITY_GMBH":
		return BACnetVendorId_TYCO_FIRE_SECURITY_GMBH, true
	case "NEDAP_SECURITY_MANAGEMENT":
		return BACnetVendorId_NEDAP_SECURITY_MANAGEMENT, true
	case "ESC_AUTOMATION_INC":
		return BACnetVendorId_ESC_AUTOMATION_INC, true
	case "MATRIX_CONTROLS":
		return BACnetVendorId_MATRIX_CONTROLS, true
	case "DSPYOU_LTD":
		return BACnetVendorId_DSPYOU_LTD, true
	case "GE_SENSINGAND_INSPECTION_TECHNOLOGIES":
		return BACnetVendorId_GE_SENSINGAND_INSPECTION_TECHNOLOGIES, true
	case "EMBEDDED_SYSTEMSSIA":
		return BACnetVendorId_EMBEDDED_SYSTEMSSIA, true
	case "BEFEGA_GMBH":
		return BACnetVendorId_BEFEGA_GMBH, true
	case "BASELINE_INC":
		return BACnetVendorId_BASELINE_INC, true
	case "KEY_ACT":
		return BACnetVendorId_KEY_ACT, true
	case "OEM_CTRL":
		return BACnetVendorId_OEM_CTRL, true
	case "CLARKSON_CONTROLS_LIMITED":
		return BACnetVendorId_CLARKSON_CONTROLS_LIMITED, true
	case "ROGERWELL_CONTROL_SYSTEM_LIMITED":
		return BACnetVendorId_ROGERWELL_CONTROL_SYSTEM_LIMITED, true
	case "SCL_ELEMENTS":
		return BACnetVendorId_SCL_ELEMENTS, true
	case "METALAIRE":
		return BACnetVendorId_METALAIRE, true
	case "HITACHI_LTD1":
		return BACnetVendorId_HITACHI_LTD1, true
	case "NEWRON_SYSTEMSA":
		return BACnetVendorId_NEWRON_SYSTEMSA, true
	case "BEVECO_GEBOUWAUTOMATISERINGBV":
		return BACnetVendorId_BEVECO_GEBOUWAUTOMATISERINGBV, true
	case "STREAMSIDE_SOLUTIONS":
		return BACnetVendorId_STREAMSIDE_SOLUTIONS, true
	case "YELLOWSTONE_SOFT":
		return BACnetVendorId_YELLOWSTONE_SOFT, true
	case "OZTECH_INTELLIGENT_SYSTEMS_PTY_LTD":
		return BACnetVendorId_OZTECH_INTELLIGENT_SYSTEMS_PTY_LTD, true
	case "NOVELAN_GMBH":
		return BACnetVendorId_NOVELAN_GMBH, true
	case "FLEXIM_AMERICAS_CORPORATION":
		return BACnetVendorId_FLEXIM_AMERICAS_CORPORATION, true
	case "ICPDAS_CO_LTD":
		return BACnetVendorId_ICPDAS_CO_LTD, true
	case "CARMA_INDUSTRIES_INC":
		return BACnetVendorId_CARMA_INDUSTRIES_INC, true
	case "ESS_ENGINEERING":
		return BACnetVendorId_ESS_ENGINEERING, true
	case "LOG_ONE_LTD":
		return BACnetVendorId_LOG_ONE_LTD, true
	case "TECO_ELECTRIC_MACHINERY_CO_LTD":
		return BACnetVendorId_TECO_ELECTRIC_MACHINERY_CO_LTD, true
	case "CONNECT_EX_INC":
		return BACnetVendorId_CONNECT_EX_INC, true
	case "TURBODDC_SDWEST":
		return BACnetVendorId_TURBODDC_SDWEST, true
	case "QUATROSENSE_ENVIRONMENTAL_LTD":
		return BACnetVendorId_QUATROSENSE_ENVIRONMENTAL_LTD, true
	case "FIFTH_LIGHT_TECHNOLOGY_LTD":
		return BACnetVendorId_FIFTH_LIGHT_TECHNOLOGY_LTD, true
	case "SCIENTIFIC_SOLUTIONS_LTD":
		return BACnetVendorId_SCIENTIFIC_SOLUTIONS_LTD, true
	case "CONTROLLER_AREA_NETWORK_SOLUTIONSM_SDN_BHD":
		return BACnetVendorId_CONTROLLER_AREA_NETWORK_SOLUTIONSM_SDN_BHD, true
	case "RESOL_ELEKTRONISCHE_REGELUNGEN_GMBH":
		return BACnetVendorId_RESOL_ELEKTRONISCHE_REGELUNGEN_GMBH, true
	case "RPBUSLLC":
		return BACnetVendorId_RPBUSLLC, true
	case "SPHERE_SYSTEMS_PTY_LTD":
		return BACnetVendorId_SPHERE_SYSTEMS_PTY_LTD, true
	case "BRS_SISTEMAS_ELETRONICOS":
		return BACnetVendorId_BRS_SISTEMAS_ELETRONICOS, true
	case "WINDOW_MASTERAS":
		return BACnetVendorId_WINDOW_MASTERAS, true
	case "SUNLUX_TECHNOLOGIES_LTD":
		return BACnetVendorId_SUNLUX_TECHNOLOGIES_LTD, true
	case "MEASURLOGIC":
		return BACnetVendorId_MEASURLOGIC, true
	case "FRIMAT_GMBH":
		return BACnetVendorId_FRIMAT_GMBH, true
	case "SPIRAX_SARCO":
		return BACnetVendorId_SPIRAX_SARCO, true
	case "LUXTRON":
		return BACnetVendorId_LUXTRON, true
	case "RAYPAK_INC":
		return BACnetVendorId_RAYPAK_INC, true
	case "AIR_MONITOR_CORPORATION1":
		return BACnetVendorId_AIR_MONITOR_CORPORATION1, true
	case "REGLER_OCH_WEBBTEKNIK_SVERIGEROWS":
		return BACnetVendorId_REGLER_OCH_WEBBTEKNIK_SVERIGEROWS, true
	case "WALKER_TECHNOLOGIES_CORPORATION":
		return BACnetVendorId_WALKER_TECHNOLOGIES_CORPORATION, true
	case "INTELLIGENT_LIGHTING_CONTROLS_INC":
		return BACnetVendorId_INTELLIGENT_LIGHTING_CONTROLS_INC, true
	case "SANYO_ELECTRIC_INDUSTRY_CO_LTD":
		return BACnetVendorId_SANYO_ELECTRIC_INDUSTRY_CO_LTD, true
	case "E_MON_ENERGY_MONITORING_PRODUCTS":
		return BACnetVendorId_E_MON_ENERGY_MONITORING_PRODUCTS, true
	case "DIGITAL_CONTROL_SYSTEMS":
		return BACnetVendorId_DIGITAL_CONTROL_SYSTEMS, true
	case "ATI_AIRTEST_TECHNOLOGIES_INC":
		return BACnetVendorId_ATI_AIRTEST_TECHNOLOGIES_INC, true
	case "SCSSA":
		return BACnetVendorId_SCSSA, true
	case "HMS_INDUSTRIAL_NETWORKSAB":
		return BACnetVendorId_HMS_INDUSTRIAL_NETWORKSAB, true
	case "SHENZHEN_UNIVERSAL_INTELLISYS_CO_LTD":
		return BACnetVendorId_SHENZHEN_UNIVERSAL_INTELLISYS_CO_LTD, true
	case "EK_INTELLISYS_SDN_BHD":
		return BACnetVendorId_EK_INTELLISYS_SDN_BHD, true
	case "SYS_COM":
		return BACnetVendorId_SYS_COM, true
	case "HI_SOLUTIONS_INC":
		return BACnetVendorId_HI_SOLUTIONS_INC, true
	case "FIRECOM_INC":
		return BACnetVendorId_FIRECOM_INC, true
	case "ESA_ELEKTROSCHALTANLAGEN_GRIMMA_GMBH":
		return BACnetVendorId_ESA_ELEKTROSCHALTANLAGEN_GRIMMA_GMBH, true
	case "KUMAHIRA_CO_LTD":
		return BACnetVendorId_KUMAHIRA_CO_LTD, true
	case "HOTRACO":
		return BACnetVendorId_HOTRACO, true
	case "SABO_ELEKTRONIK_GMBH":
		return BACnetVendorId_SABO_ELEKTRONIK_GMBH, true
	case "EQUIP_TRANS":
		return BACnetVendorId_EQUIP_TRANS, true
	case "TEMPERATURE_CONTROL_SPECIALITIES_CO_INCTCS":
		return BACnetVendorId_TEMPERATURE_CONTROL_SPECIALITIES_CO_INCTCS, true
	case "FLOW_CON_INTERNATIONALAS":
		return BACnetVendorId_FLOW_CON_INTERNATIONALAS, true
	case "THYSSEN_KRUPP_ELEVATOR_AMERICAS":
		return BACnetVendorId_THYSSEN_KRUPP_ELEVATOR_AMERICAS, true
	case "ABATEMENT_TECHNOLOGIES":
		return BACnetVendorId_ABATEMENT_TECHNOLOGIES, true
	case "JOHNSON_CONTROLS_INC":
		return BACnetVendorId_JOHNSON_CONTROLS_INC, true
	case "MBS_GMBH":
		return BACnetVendorId_MBS_GMBH, true
	case "CONTINENTAL_CONTROL_SYSTEMSLLC":
		return BACnetVendorId_CONTINENTAL_CONTROL_SYSTEMSLLC, true
	case "WISAG_AUTOMATISIERUNGSTECHNIK_GMBH_COKG":
		return BACnetVendorId_WISAG_AUTOMATISIERUNGSTECHNIK_GMBH_COKG, true
	case "EASYIO":
		return BACnetVendorId_EASYIO, true
	case "EAP_ELECTRIC_GMBH":
		return BACnetVendorId_EAP_ELECTRIC_GMBH, true
	case "HARDMEIER":
		return BACnetVendorId_HARDMEIER, true
	case "MIRCOM_GROUPOF_COMPANIES":
		return BACnetVendorId_MIRCOM_GROUPOF_COMPANIES, true
	case "QUEST_CONTROLS":
		return BACnetVendorId_QUEST_CONTROLS, true
	case "MESTEK_INC":
		return BACnetVendorId_MESTEK_INC, true
	case "PULSE_ENERGY":
		return BACnetVendorId_PULSE_ENERGY, true
	case "TACHIKAWA_CORPORATION":
		return BACnetVendorId_TACHIKAWA_CORPORATION, true
	case "SAMSONAG":
		return BACnetVendorId_SAMSONAG, true
	case "UNIVERSITYOF_NEBRASKA_LINCOLN":
		return BACnetVendorId_UNIVERSITYOF_NEBRASKA_LINCOLN, true
	case "REDWOOD_SYSTEMS":
		return BACnetVendorId_REDWOOD_SYSTEMS, true
	case "PAS_STEC_INDUSTRIE_ELEKTRONIK_GMBH":
		return BACnetVendorId_PAS_STEC_INDUSTRIE_ELEKTRONIK_GMBH, true
	case "NGEK_INC":
		return BACnetVendorId_NGEK_INC, true
	case "TMAC_TECHNOLOGIES":
		return BACnetVendorId_TMAC_TECHNOLOGIES, true
	case "JIREH_ENERGY_TECH_CO_LTD":
		return BACnetVendorId_JIREH_ENERGY_TECH_CO_LTD, true
	case "ENLIGHTED_INC":
		return BACnetVendorId_ENLIGHTED_INC, true
	case "EL_PIAST_SP_ZOO":
		return BACnetVendorId_EL_PIAST_SP_ZOO, true
	case "NETX_AUTOMATION_SOFTWARE_GMBH":
		return BACnetVendorId_NETX_AUTOMATION_SOFTWARE_GMBH, true
	case "INVERTEK_DRIVES":
		return BACnetVendorId_INVERTEK_DRIVES, true
	case "BADGER_METER_INC":
		return BACnetVendorId_BADGER_METER_INC, true
	case "DEUTSCHMANN_AUTOMATION_GMBH_COKG":
		return BACnetVendorId_DEUTSCHMANN_AUTOMATION_GMBH_COKG, true
	case "EMU_ELECTRONICAG":
		return BACnetVendorId_EMU_ELECTRONICAG, true
	case "PHAEDRUS_LIMITED":
		return BACnetVendorId_PHAEDRUS_LIMITED, true
	case "SIGMATEK_GMBH_COKG":
		return BACnetVendorId_SIGMATEK_GMBH_COKG, true
	case "MARLIN_CONTROLS":
		return BACnetVendorId_MARLIN_CONTROLS, true
	case "CIRCUTORSA":
		return BACnetVendorId_CIRCUTORSA, true
	case "UTC_FIRE_SECURITY":
		return BACnetVendorId_UTC_FIRE_SECURITY, true
	case "DENT_INSTRUMENTS_INC":
		return BACnetVendorId_DENT_INSTRUMENTS_INC, true
	case "FHP_MANUFACTURING_COMPANY_BOSCH_GROUP":
		return BACnetVendorId_FHP_MANUFACTURING_COMPANY_BOSCH_GROUP, true
	case "GE_INTELLIGENT_PLATFORMS":
		return BACnetVendorId_GE_INTELLIGENT_PLATFORMS, true
	case "DAIKIN_INDUSTRIES_LTD":
		return BACnetVendorId_DAIKIN_INDUSTRIES_LTD, true
	case "INNER_RANGE_PTY_LTD":
		return BACnetVendorId_INNER_RANGE_PTY_LTD, true
	case "GLAS_ENERGY_TECHNOLOGY":
		return BACnetVendorId_GLAS_ENERGY_TECHNOLOGY, true
	case "MSR_ELECTRONIC_GMBH":
		return BACnetVendorId_MSR_ELECTRONIC_GMBH, true
	case "ENERGY_CONTROL_SYSTEMS_INC":
		return BACnetVendorId_ENERGY_CONTROL_SYSTEMS_INC, true
	case "EMT_CONTROLS":
		return BACnetVendorId_EMT_CONTROLS, true
	case "DAINTREE":
		return BACnetVendorId_DAINTREE, true
	case "EUROIC_CDOO":
		return BACnetVendorId_EUROIC_CDOO, true
	case "TE_CONNECTIVITY_ENERGY":
		return BACnetVendorId_TE_CONNECTIVITY_ENERGY, true
	case "GEZE_GMBH":
		return BACnetVendorId_GEZE_GMBH, true
	case "NEC_CORPORATION":
		return BACnetVendorId_NEC_CORPORATION, true
	case "NARA_CONTROLS_INC":
		return BACnetVendorId_NARA_CONTROLS_INC, true
	case "HO_CHEUNG_INTERNATIONAL_COMPANY_LIMITED":
		return BACnetVendorId_HO_CHEUNG_INTERNATIONAL_COMPANY_LIMITED, true
	case "SHARP_MANUFACTURING_SYSTEMS_CORPORATION":
		return BACnetVendorId_SHARP_MANUFACTURING_SYSTEMS_CORPORATION, true
	case "DOTCONTROL_SAS":
		return BACnetVendorId_DOTCONTROL_SAS, true
	case "BEACON_MEDS":
		return BACnetVendorId_BEACON_MEDS, true
	case "MIDEA_COMMERCIAL_AIRCON":
		return BACnetVendorId_MIDEA_COMMERCIAL_AIRCON, true
	case "AAON":
		return BACnetVendorId_AAON, true
	case "KAMSTRUPAS":
		return BACnetVendorId_KAMSTRUPAS, true
	case "CA_COMPUTER_AUTOMATION_GMBH":
		return BACnetVendorId_CA_COMPUTER_AUTOMATION_GMBH, true
	case "LAARS_HEATING_SYSTEMS_COMPANY":
		return BACnetVendorId_LAARS_HEATING_SYSTEMS_COMPANY, true
	case "HITACHI_SYSTEMS_LTD":
		return BACnetVendorId_HITACHI_SYSTEMS_LTD, true
	case "MAMMOTH_INC":
		return BACnetVendorId_MAMMOTH_INC, true
	case "FUSHANAKE_ELECTRONIC_ENGINEERING_CO_LTD":
		return BACnetVendorId_FUSHANAKE_ELECTRONIC_ENGINEERING_CO_LTD, true
	case "TOSHIBA_INTERNATIONAL_CORPORATION":
		return BACnetVendorId_TOSHIBA_INTERNATIONAL_CORPORATION, true
	case "STARMAN_SYSTEMSLLC":
		return BACnetVendorId_STARMAN_SYSTEMSLLC, true
	case "SAMSUNG_TECHWIN_CO_LTD":
		return BACnetVendorId_SAMSUNG_TECHWIN_CO_LTD, true
	case "ISAS_INTEGRATED_SWITCHGEARAND_SYSTEMSPL":
		return BACnetVendorId_ISAS_INTEGRATED_SWITCHGEARAND_SYSTEMSPL, true
	case "OBVIUS":
		return BACnetVendorId_OBVIUS, true
	case "MAREK_GUZIK":
		return BACnetVendorId_MAREK_GUZIK, true
	case "VORTEK_INSTRUMENTSLLC":
		return BACnetVendorId_VORTEK_INSTRUMENTSLLC, true
	case "UNIVERSAL_LIGHTING_TECHNOLOGIES":
		return BACnetVendorId_UNIVERSAL_LIGHTING_TECHNOLOGIES, true
	case "LIEBERT_CORPORATION":
		return BACnetVendorId_LIEBERT_CORPORATION, true
	case "MYERS_POWER_PRODUCTS_INC":
		return BACnetVendorId_MYERS_POWER_PRODUCTS_INC, true
	case "VECTOR_CONTROLS_GMBH":
		return BACnetVendorId_VECTOR_CONTROLS_GMBH, true
	case "CRESTRON_ELECTRONICS_INC":
		return BACnetVendorId_CRESTRON_ELECTRONICS_INC, true
	case "AE_CONTROLS_LIMITED":
		return BACnetVendorId_AE_CONTROLS_LIMITED, true
	case "PROJEKTOMONTAZAAD":
		return BACnetVendorId_PROJEKTOMONTAZAAD, true
	case "FREEAIRE_REFRIGERATION":
		return BACnetVendorId_FREEAIRE_REFRIGERATION, true
	case "AQUA_COOLER_PTY_LIMITED":
		return BACnetVendorId_AQUA_COOLER_PTY_LIMITED, true
	case "BASIC_CONTROLS":
		return BACnetVendorId_BASIC_CONTROLS, true
	case "GE_MEASUREMENTAND_CONTROL_SOLUTIONS_ADVANCED_SENSORS":
		return BACnetVendorId_GE_MEASUREMENTAND_CONTROL_SOLUTIONS_ADVANCED_SENSORS, true
	case "EQUAL_NETWORKS":
		return BACnetVendorId_EQUAL_NETWORKS, true
	case "SEMCO_INCORPORATED":
		return BACnetVendorId_SEMCO_INCORPORATED, true
	case "MILLENNIAL_NET":
		return BACnetVendorId_MILLENNIAL_NET, true
	case "APLI_LTD":
		return BACnetVendorId_APLI_LTD, true
	case "ELECTRO_INDUSTRIES_GAUGE_TECH":
		return BACnetVendorId_ELECTRO_INDUSTRIES_GAUGE_TECH, true
	case "SANG_MYUNG_UNIVERSITY":
		return BACnetVendorId_SANG_MYUNG_UNIVERSITY, true
	case "COPPERTREE_ANALYTICS_INC":
		return BACnetVendorId_COPPERTREE_ANALYTICS_INC, true
	case "CORE_NETIX_GMBH":
		return BACnetVendorId_CORE_NETIX_GMBH, true
	case "ACUTHERM":
		return BACnetVendorId_ACUTHERM, true
	case "DR_RIEDEL_AUTOMATISIERUNGSTECHNIK_GMBH":
		return BACnetVendorId_DR_RIEDEL_AUTOMATISIERUNGSTECHNIK_GMBH, true
	case "SHINA_SYSTEM_CO_LTD":
		return BACnetVendorId_SHINA_SYSTEM_CO_LTD, true
	case "IQAPERTUS":
		return BACnetVendorId_IQAPERTUS, true
	case "AIR_MONITOR_CORPORATION":
		return BACnetVendorId_AIR_MONITOR_CORPORATION, true
	case "PSE_TECHNOLOGY":
		return BACnetVendorId_PSE_TECHNOLOGY, true
	case "BA_SYSTEMS":
		return BACnetVendorId_BA_SYSTEMS, true
	case "BTICINO":
		return BACnetVendorId_BTICINO, true
	case "MONICO_INC":
		return BACnetVendorId_MONICO_INC, true
	case "I_CUE":
		return BACnetVendorId_I_CUE, true
	case "TEKMAR_CONTROL_SYSTEMS_LTD":
		return BACnetVendorId_TEKMAR_CONTROL_SYSTEMS_LTD, true
	case "CONTROL_TECHNOLOGY_CORPORATION":
		return BACnetVendorId_CONTROL_TECHNOLOGY_CORPORATION, true
	case "GFAE_GMBH":
		return BACnetVendorId_GFAE_GMBH, true
	case "BE_KA_SOFTWARE_GMBH":
		return BACnetVendorId_BE_KA_SOFTWARE_GMBH, true
	case "ISOIL_INDUSTRIA_SPA":
		return BACnetVendorId_ISOIL_INDUSTRIA_SPA, true
	case "TRIATEKLLC":
		return BACnetVendorId_TRIATEKLLC, true
	case "HOME_SYSTEMS_CONSULTING_SPA":
		return BACnetVendorId_HOME_SYSTEMS_CONSULTING_SPA, true
	case "SOCOMEC":
		return BACnetVendorId_SOCOMEC, true
	case "EVEREX_COMMUNICATIONS_INC":
		return BACnetVendorId_EVEREX_COMMUNICATIONS_INC, true
	case "CET_ELECTRIC_TECHNOLOGY_INC":
		return BACnetVendorId_CET_ELECTRIC_TECHNOLOGY_INC, true
	case "ATRILA_GMBH":
		return BACnetVendorId_ATRILA_GMBH, true
	case "WING_TECHS":
		return BACnetVendorId_WING_TECHS, true
	case "SHENZHEN_MEK_INTELLISYS_PTE_LTD":
		return BACnetVendorId_SHENZHEN_MEK_INTELLISYS_PTE_LTD, true
	case "NESTFIELD_CO_LTD":
		return BACnetVendorId_NESTFIELD_CO_LTD, true
	case "SWISSPHONE_TELECOMAG":
		return BACnetVendorId_SWISSPHONE_TELECOMAG, true
	case "PNTECHJSC":
		return BACnetVendorId_PNTECHJSC, true
	case "ABB_FORMERLY_AMERICAN_AUTO_MATRIX":
		return BACnetVendorId_ABB_FORMERLY_AMERICAN_AUTO_MATRIX, true
	case "NEX_LIGHT":
		return BACnetVendorId_NEX_LIGHT, true
	case "HORNERAPGLLC":
		return BACnetVendorId_HORNERAPGLLC, true
	case "PVI_INDUSTRIESLLC":
		return BACnetVendorId_PVI_INDUSTRIESLLC, true
	case "ELACOMPIL":
		return BACnetVendorId_ELACOMPIL, true
	case "PEGASUS_AUTOMATION_INTERNATIONALLLC":
		return BACnetVendorId_PEGASUS_AUTOMATION_INTERNATIONALLLC, true
	case "WIGHT_ELECTRONIC_SERVICES_LTD":
		return BACnetVendorId_WIGHT_ELECTRONIC_SERVICES_LTD, true
	case "MARCOM":
		return BACnetVendorId_MARCOM, true
	case "EXHAUSTOAS":
		return BACnetVendorId_EXHAUSTOAS, true
	case "DWYER_INSTRUMENTS_INC":
		return BACnetVendorId_DWYER_INSTRUMENTS_INC, true
	case "LINK_GMBH":
		return BACnetVendorId_LINK_GMBH, true
	case "OPPERMANN_REGELGERATE_GMBH":
		return BACnetVendorId_OPPERMANN_REGELGERATE_GMBH, true
	case "MULTISTACK":
		return BACnetVendorId_MULTISTACK, true
	case "NU_AIRE_INC":
		return BACnetVendorId_NU_AIRE_INC, true
	case "NORTEC_HUMIDITY_INC":
		return BACnetVendorId_NORTEC_HUMIDITY_INC, true
	case "BIGWOOD_SYSTEMS_INC":
		return BACnetVendorId_BIGWOOD_SYSTEMS_INC, true
	case "ENBALA_POWER_NETWORKS":
		return BACnetVendorId_ENBALA_POWER_NETWORKS, true
	case "INTER_ENERGY_CO_LTD":
		return BACnetVendorId_INTER_ENERGY_CO_LTD, true
	case "ETC":
		return BACnetVendorId_ETC, true
	case "COMELECSARL":
		return BACnetVendorId_COMELECSARL, true
	case "PYTHIA_TECHNOLOGIES":
		return BACnetVendorId_PYTHIA_TECHNOLOGIES, true
	case "TREND_POINT_SYSTEMS_INC":
		return BACnetVendorId_TREND_POINT_SYSTEMS_INC, true
	case "AWEX":
		return BACnetVendorId_AWEX, true
	case "TSI_INCORPORATED":
		return BACnetVendorId_TSI_INCORPORATED, true
	case "EUREVIA":
		return BACnetVendorId_EUREVIA, true
	case "KONGSBERGELONAS":
		return BACnetVendorId_KONGSBERGELONAS, true
	case "FLAKT_WOODS":
		return BACnetVendorId_FLAKT_WOODS, true
	case "EE_ELEKTRONIKGESMBH":
		return BACnetVendorId_EE_ELEKTRONIKGESMBH, true
	case "ARC_INFORMATIQUE":
		return BACnetVendorId_ARC_INFORMATIQUE, true
	case "SKIDATAAG":
		return BACnetVendorId_SKIDATAAG, true
	case "WSW_SOLUTIONS":
		return BACnetVendorId_WSW_SOLUTIONS, true
	case "TREFON_ELECTRONIC_GMBH":
		return BACnetVendorId_TREFON_ELECTRONIC_GMBH, true
	case "DONGSEO_SYSTEM":
		return BACnetVendorId_DONGSEO_SYSTEM, true
	case "KANONTEC_INTELLIGENCE_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_KANONTEC_INTELLIGENCE_TECHNOLOGY_CO_LTD, true
	case "WEATHER_RITE_INC":
		return BACnetVendorId_WEATHER_RITE_INC, true
	case "EVCO_SPA":
		return BACnetVendorId_EVCO_SPA, true
	case "ACCUENERGY_CANADA_INC":
		return BACnetVendorId_ACCUENERGY_CANADA_INC, true
	case "SOFTDEL":
		return BACnetVendorId_SOFTDEL, true
	case "ORION_ENERGY_SYSTEMS_INC":
		return BACnetVendorId_ORION_ENERGY_SYSTEMS_INC, true
	case "ROBOTICSWARE":
		return BACnetVendorId_ROBOTICSWARE, true
	case "DOMIQ_SPZOO":
		return BACnetVendorId_DOMIQ_SPZOO, true
	case "SOLIDYNE":
		return BACnetVendorId_SOLIDYNE, true
	case "ELECSYS_CORPORATION":
		return BACnetVendorId_ELECSYS_CORPORATION, true
	case "CONDITIONAIRE_INTERNATIONAL_PTY_LIMITED":
		return BACnetVendorId_CONDITIONAIRE_INTERNATIONAL_PTY_LIMITED, true
	case "QUEBEC_INC":
		return BACnetVendorId_QUEBEC_INC, true
	case "DUNHAM_BUSH":
		return BACnetVendorId_DUNHAM_BUSH, true
	case "HOMERUN_HOLDINGS":
		return BACnetVendorId_HOMERUN_HOLDINGS, true
	case "MURATA_AMERICAS":
		return BACnetVendorId_MURATA_AMERICAS, true
	case "COMPTEK":
		return BACnetVendorId_COMPTEK, true
	case "WESTCO_SYSTEMS_INC":
		return BACnetVendorId_WESTCO_SYSTEMS_INC, true
	case "ADVANCIS_SOFTWARE_SERVICES_GMBH":
		return BACnetVendorId_ADVANCIS_SOFTWARE_SERVICES_GMBH, true
	case "INTERGRIDLLC":
		return BACnetVendorId_INTERGRIDLLC, true
	case "MARKERR_CONTROLS_INC":
		return BACnetVendorId_MARKERR_CONTROLS_INC, true
	case "TOSHIBA_ELEVATORAND_BUILDING_SYSTEMS_CORPORATION":
		return BACnetVendorId_TOSHIBA_ELEVATORAND_BUILDING_SYSTEMS_CORPORATION, true
	case "SPECTRUM_CONTROLS_INC":
		return BACnetVendorId_SPECTRUM_CONTROLS_INC, true
	case "MKSERVICE":
		return BACnetVendorId_MKSERVICE, true
	case "RELIANCE_ELECTRIC":
		return BACnetVendorId_RELIANCE_ELECTRIC, true
	case "FOX_THERMAL_INSTRUMENTS":
		return BACnetVendorId_FOX_THERMAL_INSTRUMENTS, true
	case "SYXTH_SENSE_LTD":
		return BACnetVendorId_SYXTH_SENSE_LTD, true
	case "DUHA_SYSTEMSRO":
		return BACnetVendorId_DUHA_SYSTEMSRO, true
	case "NIBE":
		return BACnetVendorId_NIBE, true
	case "MELINK_CORPORATION":
		return BACnetVendorId_MELINK_CORPORATION, true
	case "FRITZ_HABER_INSTITUT":
		return BACnetVendorId_FRITZ_HABER_INSTITUT, true
	case "MTU_ONSITE_ENERGY_GMBH_GAS_POWER_SYSTEMS":
		return BACnetVendorId_MTU_ONSITE_ENERGY_GMBH_GAS_POWER_SYSTEMS, true
	case "OMEGA_ENGINEERING_INC":
		return BACnetVendorId_OMEGA_ENGINEERING_INC, true
	case "AVELON":
		return BACnetVendorId_AVELON, true
	case "YWIRE_TECHNOLOGIES_INC":
		return BACnetVendorId_YWIRE_TECHNOLOGIES_INC, true
	case "LCS_INC":
		return BACnetVendorId_LCS_INC, true
	case "MR_ENGINEERING_CO_LTD":
		return BACnetVendorId_MR_ENGINEERING_CO_LTD, true
	case "LOCHINVARLLC":
		return BACnetVendorId_LOCHINVARLLC, true
	case "SONTAY_LIMITED":
		return BACnetVendorId_SONTAY_LIMITED, true
	case "GRUPA_SLAWOMIR_CHELMINSKI":
		return BACnetVendorId_GRUPA_SLAWOMIR_CHELMINSKI, true
	case "ARCH_METER_CORPORATION":
		return BACnetVendorId_ARCH_METER_CORPORATION, true
	case "SENVA_INC":
		return BACnetVendorId_SENVA_INC, true
	case "FM_TEC":
		return BACnetVendorId_FM_TEC, true
	case "SYSTEMS_SPECIALISTS_INC":
		return BACnetVendorId_SYSTEMS_SPECIALISTS_INC, true
	case "SENSE_AIR":
		return BACnetVendorId_SENSE_AIR, true
	case "REGULATOR_AUSTRALIAPTY_LTD":
		return BACnetVendorId_REGULATOR_AUSTRALIAPTY_LTD, true
	case "AB_INDUSTRIE_TECHNIK_SRL":
		return BACnetVendorId_AB_INDUSTRIE_TECHNIK_SRL, true
	case "CORTLAND_RESEARCHLLC":
		return BACnetVendorId_CORTLAND_RESEARCHLLC, true
	case "MEDIA_VIEW":
		return BACnetVendorId_MEDIA_VIEW, true
	case "VDA_ELETTRONICA":
		return BACnetVendorId_VDA_ELETTRONICA, true
	case "CSS_INC":
		return BACnetVendorId_CSS_INC, true
	case "TEK_AIR_SYSTEMS_INC":
		return BACnetVendorId_TEK_AIR_SYSTEMS_INC, true
	case "ICDT":
		return BACnetVendorId_ICDT, true
	case "THE_ARMSTRONG_MONITORING_CORPORATION":
		return BACnetVendorId_THE_ARMSTRONG_MONITORING_CORPORATION, true
	case "DIXELL_SRL":
		return BACnetVendorId_DIXELL_SRL, true
	case "LEAD_SYSTEM_INC":
		return BACnetVendorId_LEAD_SYSTEM_INC, true
	case "TOUCH_PLATE_LIGHTING_CONTROLS":
		return BACnetVendorId_TOUCH_PLATE_LIGHTING_CONTROLS, true
	case "ISM_EURO_CENTERSA":
		return BACnetVendorId_ISM_EURO_CENTERSA, true
	case "TDIS":
		return BACnetVendorId_TDIS, true
	case "TRADEFIDES":
		return BACnetVendorId_TRADEFIDES, true
	case "KNRR_GMBH_EMERSON_NETWORK_POWER":
		return BACnetVendorId_KNRR_GMBH_EMERSON_NETWORK_POWER, true
	case "RESOURCE_DATA_MANAGEMENT":
		return BACnetVendorId_RESOURCE_DATA_MANAGEMENT, true
	case "ABIES_TECHNOLOGY_INC":
		return BACnetVendorId_ABIES_TECHNOLOGY_INC, true
	case "UAB_KOMFOVENT":
		return BACnetVendorId_UAB_KOMFOVENT, true
	case "MIRAE_ELECTRICAL_MFG_CO_LTD":
		return BACnetVendorId_MIRAE_ELECTRICAL_MFG_CO_LTD, true
	case "HUNTER_DOUGLAS_ARCHITECTURAL_PROJECTS_SCANDINAVIA_APS":
		return BACnetVendorId_HUNTER_DOUGLAS_ARCHITECTURAL_PROJECTS_SCANDINAVIA_APS, true
	case "RUNPAQ_GROUP_CO_LTD":
		return BACnetVendorId_RUNPAQ_GROUP_CO_LTD, true
	case "AMANN_GMBH":
		return BACnetVendorId_AMANN_GMBH, true
	case "UNICARDSA":
		return BACnetVendorId_UNICARDSA, true
	case "IE_TECHNOLOGIES":
		return BACnetVendorId_IE_TECHNOLOGIES, true
	case "RUSKIN_MANUFACTURING":
		return BACnetVendorId_RUSKIN_MANUFACTURING, true
	case "CALON_ASSOCIATES_LIMITED":
		return BACnetVendorId_CALON_ASSOCIATES_LIMITED, true
	case "CONTEC_CO_LTD":
		return BACnetVendorId_CONTEC_CO_LTD, true
	case "IT_GMBH":
		return BACnetVendorId_IT_GMBH, true
	case "AUTANI_CORPORATION":
		return BACnetVendorId_AUTANI_CORPORATION, true
	case "CHRISTIAN_FORTIN":
		return BACnetVendorId_CHRISTIAN_FORTIN, true
	case "HDL":
		return BACnetVendorId_HDL, true
	case "IPID_SPZOO_LIMITED":
		return BACnetVendorId_IPID_SPZOO_LIMITED, true
	case "SIEMENS_SCHWEIZAG":
		return BACnetVendorId_SIEMENS_SCHWEIZAG, true
	case "RLE_TECHNOLOGIES":
		return BACnetVendorId_RLE_TECHNOLOGIES, true
	case "FUJI_ELECTRIC_CO_LTD":
		return BACnetVendorId_FUJI_ELECTRIC_CO_LTD, true
	case "VIEW_INC":
		return BACnetVendorId_VIEW_INC, true
	case "SAMSUNGS1_CORPORATION":
		return BACnetVendorId_SAMSUNGS1_CORPORATION, true
	case "NEW_LIFT":
		return BACnetVendorId_NEW_LIFT, true
	case "VRT_SYSTEMS":
		return BACnetVendorId_VRT_SYSTEMS, true
	case "MOTION_CONTROL_ENGINEERING_INC":
		return BACnetVendorId_MOTION_CONTROL_ENGINEERING_INC, true
	case "WEISS_KLIMATECHNIK_GMBH":
		return BACnetVendorId_WEISS_KLIMATECHNIK_GMBH, true
	case "ELKON":
		return BACnetVendorId_ELKON, true
	case "ELIWELL_CONTROLS_SRL":
		return BACnetVendorId_ELIWELL_CONTROLS_SRL, true
	case "JAPAN_COMPUTER_TECHNOS_CORP":
		return BACnetVendorId_JAPAN_COMPUTER_TECHNOS_CORP, true
	case "CARDKEY_SYSTEMS":
		return BACnetVendorId_CARDKEY_SYSTEMS, true
	case "RATIONAL_NETWORKEHF":
		return BACnetVendorId_RATIONAL_NETWORKEHF, true
	case "MAGNUM_ENERGY_SOLUTIONSLLC":
		return BACnetVendorId_MAGNUM_ENERGY_SOLUTIONSLLC, true
	case "MEL_ROK":
		return BACnetVendorId_MEL_ROK, true
	case "VAE_GROUP":
		return BACnetVendorId_VAE_GROUP, true
	case "LGCNS":
		return BACnetVendorId_LGCNS, true
	case "BERGHOF_AUTOMATIONSTECHNIK_GMBH":
		return BACnetVendorId_BERGHOF_AUTOMATIONSTECHNIK_GMBH, true
	case "QUARK_COMMUNICATIONS_INC":
		return BACnetVendorId_QUARK_COMMUNICATIONS_INC, true
	case "SONTEX":
		return BACnetVendorId_SONTEX, true
	case "MIVUNEAG":
		return BACnetVendorId_MIVUNEAG, true
	case "PANDUIT":
		return BACnetVendorId_PANDUIT, true
	case "SECOM_CO_LTD":
		return BACnetVendorId_SECOM_CO_LTD, true
	case "SMART_CONTROLSLLC":
		return BACnetVendorId_SMART_CONTROLSLLC, true
	case "COMPU_AIRE_INC":
		return BACnetVendorId_COMPU_AIRE_INC, true
	case "SIERRA":
		return BACnetVendorId_SIERRA, true
	case "PROTO_SENSE_TECHNOLOGIES":
		return BACnetVendorId_PROTO_SENSE_TECHNOLOGIES, true
	case "ELTRAC_TECHNOLOGIES_PVT_LTD":
		return BACnetVendorId_ELTRAC_TECHNOLOGIES_PVT_LTD, true
	case "BEKTAS_INVISIBLE_CONTROLS_GMBH":
		return BACnetVendorId_BEKTAS_INVISIBLE_CONTROLS_GMBH, true
	case "ENTELEC":
		return BACnetVendorId_ENTELEC, true
	case "INNEXIV":
		return BACnetVendorId_INNEXIV, true
	case "COVENANT":
		return BACnetVendorId_COVENANT, true
	case "DAVITORAB":
		return BACnetVendorId_DAVITORAB, true
	case "ABB_GEBUDETECHNIKAG_BEREICH_NET_SERV":
		return BACnetVendorId_ABB_GEBUDETECHNIKAG_BEREICH_NET_SERV, true
	case "TONG_FANG_TECHNOVATOR":
		return BACnetVendorId_TONG_FANG_TECHNOVATOR, true
	case "BUILDING_ROBOTICS_INC":
		return BACnetVendorId_BUILDING_ROBOTICS_INC, true
	case "HSSMSRUG":
		return BACnetVendorId_HSSMSRUG, true
	case "FRAM_TACKLLC":
		return BACnetVendorId_FRAM_TACKLLC, true
	case "BL_ACOUSTICS_LTD":
		return BACnetVendorId_BL_ACOUSTICS_LTD, true
	case "TRAXXON_ROCK_DRILLS_LTD":
		return BACnetVendorId_TRAXXON_ROCK_DRILLS_LTD, true
	case "FRANKE":
		return BACnetVendorId_FRANKE, true
	case "WURM_GMBH_CO":
		return BACnetVendorId_WURM_GMBH_CO, true
	case "ADDENERGIE":
		return BACnetVendorId_ADDENERGIE, true
	case "MIRLE_AUTOMATION_CORPORATION":
		return BACnetVendorId_MIRLE_AUTOMATION_CORPORATION, true
	case "KNX_ASSOCIATIONCVBA":
		return BACnetVendorId_KNX_ASSOCIATIONCVBA, true
	case "IBIS_NETWORKS":
		return BACnetVendorId_IBIS_NETWORKS, true
	case "IDKART_ASRO":
		return BACnetVendorId_IDKART_ASRO, true
	case "ANAREN_INC":
		return BACnetVendorId_ANAREN_INC, true
	case "SPAN_INCORPORATED":
		return BACnetVendorId_SPAN_INCORPORATED, true
	case "BOSCH_THERMOTECHNOLOGY_CORP":
		return BACnetVendorId_BOSCH_THERMOTECHNOLOGY_CORP, true
	case "DRC_TECHNOLOGYSA":
		return BACnetVendorId_DRC_TECHNOLOGYSA, true
	case "SHANGHAI_ENERGY_BUILDING_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_SHANGHAI_ENERGY_BUILDING_TECHNOLOGY_CO_LTD, true
	case "FRAPORTAG":
		return BACnetVendorId_FRAPORTAG, true
	case "FLOWGROUP":
		return BACnetVendorId_FLOWGROUP, true
	case "SKYTRON_ENERGY_GMBH":
		return BACnetVendorId_SKYTRON_ENERGY_GMBH, true
	case "INSTITUTEOF_ELECTRICAL_INSTALLATION_ENGINEERSOF_JAPANIEIEJ":
		return BACnetVendorId_INSTITUTEOF_ELECTRICAL_INSTALLATION_ENGINEERSOF_JAPANIEIEJ, true
	case "ALTEL_WICHA_GOLDA_SPJ":
		return BACnetVendorId_ALTEL_WICHA_GOLDA_SPJ, true
	case "DRUPAL":
		return BACnetVendorId_DRUPAL, true
	case "AXIOMATIC_TECHNOLOGY_LTD":
		return BACnetVendorId_AXIOMATIC_TECHNOLOGY_LTD, true
	case "BOHNKE_PARTNER":
		return BACnetVendorId_BOHNKE_PARTNER, true
	case "FUNCTION1":
		return BACnetVendorId_FUNCTION1, true
	case "OPTERGY_PTY_LTD":
		return BACnetVendorId_OPTERGY_PTY_LTD, true
	case "LSI_VIRTICUS":
		return BACnetVendorId_LSI_VIRTICUS, true
	case "KONZEPTPARK_GMBH":
		return BACnetVendorId_KONZEPTPARK_GMBH, true
	case "NX_LIGHTING_CONTROLS":
		return BACnetVendorId_NX_LIGHTING_CONTROLS, true
	case "E_CURV_INC":
		return BACnetVendorId_E_CURV_INC, true
	case "NOHMI_BOSAI_LTD":
		return BACnetVendorId_NOHMI_BOSAI_LTD, true
	case "AGNOSYS_GMBH":
		return BACnetVendorId_AGNOSYS_GMBH, true
	case "SHANGHAI_SUNFULL_AUTOMATION_COLTD":
		return BACnetVendorId_SHANGHAI_SUNFULL_AUTOMATION_COLTD, true
	case "KURZ_INSTRUMENTS_INC":
		return BACnetVendorId_KURZ_INSTRUMENTS_INC, true
	case "CIAS_ELETTRONICA_SRL":
		return BACnetVendorId_CIAS_ELETTRONICA_SRL, true
	case "MULTIAQUA_INC":
		return BACnetVendorId_MULTIAQUA_INC, true
	case "BLUE_BOX":
		return BACnetVendorId_BLUE_BOX, true
	case "SENSIDYNE":
		return BACnetVendorId_SENSIDYNE, true
	case "VIESSMANN_ELEKTRONIK_GMBH":
		return BACnetVendorId_VIESSMANN_ELEKTRONIK_GMBH, true
	case "AD_FWEBCOMSRL":
		return BACnetVendorId_AD_FWEBCOMSRL, true
	case "GAYLORD_INDUSTRIES":
		return BACnetVendorId_GAYLORD_INDUSTRIES, true
	case "CAREL_INDUSTRIES_SPA":
		return BACnetVendorId_CAREL_INDUSTRIES_SPA, true
	case "MAJUR_LTD":
		return BACnetVendorId_MAJUR_LTD, true
	case "SHANGHAI_HUILIN_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_SHANGHAI_HUILIN_TECHNOLOGY_CO_LTD, true
	case "EXOTRONIC":
		return BACnetVendorId_EXOTRONIC, true
	case "SAFECONTRO_LSRO":
		return BACnetVendorId_SAFECONTRO_LSRO, true
	case "AMATIS":
		return BACnetVendorId_AMATIS, true
	case "UNIVERSAL_ELECTRIC_CORPORATION":
		return BACnetVendorId_UNIVERSAL_ELECTRIC_CORPORATION, true
	case "IBA_CNET":
		return BACnetVendorId_IBA_CNET, true
	case "SMARTRISE_ENGINEERING_INC":
		return BACnetVendorId_SMARTRISE_ENGINEERING_INC, true
	case "MIRATRON_INC":
		return BACnetVendorId_MIRATRON_INC, true
	case "UTC_FIRE_SECURITY_ESPAASL":
		return BACnetVendorId_UTC_FIRE_SECURITY_ESPAASL, true
	case "SMART_EDGE":
		return BACnetVendorId_SMART_EDGE, true
	case "MITSUBISHI_ELECTRIC_AUSTRALIA_PTY_LTD":
		return BACnetVendorId_MITSUBISHI_ELECTRIC_AUSTRALIA_PTY_LTD, true
	case "TRIANGLE_RESEARCH_INTERNATIONAL_PTD_LTD":
		return BACnetVendorId_TRIANGLE_RESEARCH_INTERNATIONAL_PTD_LTD, true
	case "PRODUAL_OY":
		return BACnetVendorId_PRODUAL_OY, true
	case "MILESTONE_SYSTEMSAS":
		return BACnetVendorId_MILESTONE_SYSTEMSAS, true
	case "TRUSTBRIDGE":
		return BACnetVendorId_TRUSTBRIDGE, true
	case "FEEDBACK_SOLUTIONS":
		return BACnetVendorId_FEEDBACK_SOLUTIONS, true
	case "IES":
		return BACnetVendorId_IES, true
	case "ABB_POWER_PROTECTIONSA":
		return BACnetVendorId_ABB_POWER_PROTECTIONSA, true
	case "RIPTIDEIO":
		return BACnetVendorId_RIPTIDEIO, true
	case "HOCHIKI_CORPORATION":
		return BACnetVendorId_HOCHIKI_CORPORATION, true
	case "MESSERSCHMITT_SYSTEMSAG":
		return BACnetVendorId_MESSERSCHMITT_SYSTEMSAG, true
	case "DEZEM_ENERGY_CONTROLLING":
		return BACnetVendorId_DEZEM_ENERGY_CONTROLLING, true
	case "MECHO_SYSTEMS":
		return BACnetVendorId_MECHO_SYSTEMS, true
	case "EVON_GMBH":
		return BACnetVendorId_EVON_GMBH, true
	case "CS_LAB_GMBH":
		return BACnetVendorId_CS_LAB_GMBH, true
	case "N_0_ENTERPRISES_INC":
		return BACnetVendorId_N_0_ENTERPRISES_INC, true
	case "TOUCHE_CONTROLS":
		return BACnetVendorId_TOUCHE_CONTROLS, true
	case "ONTROL_TEKNIK_MALZEME_SANVE_TICAS":
		return BACnetVendorId_ONTROL_TEKNIK_MALZEME_SANVE_TICAS, true
	case "UNI_CONTROL_SYSTEM_SP_ZOO":
		return BACnetVendorId_UNI_CONTROL_SYSTEM_SP_ZOO, true
	case "WEIHAI_PLOUMETER_CO_LTD":
		return BACnetVendorId_WEIHAI_PLOUMETER_CO_LTD, true
	case "DELTA_CONTROLS":
		return BACnetVendorId_DELTA_CONTROLS, true
	case "FR_SAUTERAG":
		return BACnetVendorId_FR_SAUTERAG, true
	case "ELCOM_INTERNATIONAL_PVT_LTD":
		return BACnetVendorId_ELCOM_INTERNATIONAL_PVT_LTD, true
	case "SIGNIFY":
		return BACnetVendorId_SIGNIFY, true
	case "AUTOMATION_DIRECT":
		return BACnetVendorId_AUTOMATION_DIRECT, true
	case "PARAGON_ROBOTICS":
		return BACnetVendorId_PARAGON_ROBOTICS, true
	case "SMT_SYSTEM_MODULES_TECHNOLOGYAG":
		return BACnetVendorId_SMT_SYSTEM_MODULES_TECHNOLOGYAG, true
	case "RADIX_IOTLLC":
		return BACnetVendorId_RADIX_IOTLLC, true
	case "CMR_CONTROLS_LTD":
		return BACnetVendorId_CMR_CONTROLS_LTD, true
	case "INNOVARI_INC":
		return BACnetVendorId_INNOVARI_INC, true
	case "ABB_CONTROL_PRODUCTS":
		return BACnetVendorId_ABB_CONTROL_PRODUCTS, true
	case "GESELLSCHAFTFUR_GEBUDEAUTOMATIONMBH":
		return BACnetVendorId_GESELLSCHAFTFUR_GEBUDEAUTOMATIONMBH, true
	case "MATSUSHITA_ELECTRIC_WORKS_LTD":
		return BACnetVendorId_MATSUSHITA_ELECTRIC_WORKS_LTD, true
	case "RODI_SYSTEMS_CORP":
		return BACnetVendorId_RODI_SYSTEMS_CORP, true
	case "NEXTEK_POWER_SYSTEMS":
		return BACnetVendorId_NEXTEK_POWER_SYSTEMS, true
	case "CREATIVE_LIGHTING":
		return BACnetVendorId_CREATIVE_LIGHTING, true
	case "WATER_FURNACE_INTERNATIONAL":
		return BACnetVendorId_WATER_FURNACE_INTERNATIONAL, true
	case "MERCURY_SECURITY":
		return BACnetVendorId_MERCURY_SECURITY, true
	case "HISENSE_SHANDONG_AIR_CONDITIONING_CO_LTD":
		return BACnetVendorId_HISENSE_SHANDONG_AIR_CONDITIONING_CO_LTD, true
	case "LAYERED_SOLUTIONS_INC":
		return BACnetVendorId_LAYERED_SOLUTIONS_INC, true
	case "LEEGOOD_AUTOMATIC_SYSTEM_INC":
		return BACnetVendorId_LEEGOOD_AUTOMATIC_SYSTEM_INC, true
	case "SHANGHAI_RESTAR_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_SHANGHAI_RESTAR_TECHNOLOGY_CO_LTD, true
	case "REIMANN_INGENIEURBRO":
		return BACnetVendorId_REIMANN_INGENIEURBRO, true
	case "MITSUBISHI_ELECTRIC_CORPORATION_INAZAWA_WORKS":
		return BACnetVendorId_MITSUBISHI_ELECTRIC_CORPORATION_INAZAWA_WORKS, true
	case "LYN_TEC":
		return BACnetVendorId_LYN_TEC, true
	case "HTP":
		return BACnetVendorId_HTP, true
	case "ELKOR_TECHNOLOGIES_INC":
		return BACnetVendorId_ELKOR_TECHNOLOGIES_INC, true
	case "BENTROL_PTY_LTD":
		return BACnetVendorId_BENTROL_PTY_LTD, true
	case "TEAM_CONTROL_OY":
		return BACnetVendorId_TEAM_CONTROL_OY, true
	case "NEXT_DEVICELLC":
		return BACnetVendorId_NEXT_DEVICELLC, true
	case "ISMACONTROLLI_SPA":
		return BACnetVendorId_ISMACONTROLLI_SPA, true
	case "KINGI_ELECTRONICS_CO_LTD":
		return BACnetVendorId_KINGI_ELECTRONICS_CO_LTD, true
	case "SAMDAV":
		return BACnetVendorId_SAMDAV, true
	case "NEXT_GEN_INDUSTRIES_PVT_LTD":
		return BACnetVendorId_NEXT_GEN_INDUSTRIES_PVT_LTD, true
	case "MITSUBISHI_HEAVY_INDUSTRIES_LTD":
		return BACnetVendorId_MITSUBISHI_HEAVY_INDUSTRIES_LTD, true
	case "ENTICLLC":
		return BACnetVendorId_ENTICLLC, true
	case "ETAP":
		return BACnetVendorId_ETAP, true
	case "MORALLE_ELECTRONICS_LIMITED":
		return BACnetVendorId_MORALLE_ELECTRONICS_LIMITED, true
	case "LEICOMAG":
		return BACnetVendorId_LEICOMAG, true
	case "WATTS_REGULATOR_COMPANY":
		return BACnetVendorId_WATTS_REGULATOR_COMPANY, true
	case "SC_ORBTRONICSSRL":
		return BACnetVendorId_SC_ORBTRONICSSRL, true
	case "GAUSSAN_TECHNOLOGIES":
		return BACnetVendorId_GAUSSAN_TECHNOLOGIES, true
	case "WE_BFACTORY_GMBH":
		return BACnetVendorId_WE_BFACTORY_GMBH, true
	case "OCEAN_CONTROLS":
		return BACnetVendorId_OCEAN_CONTROLS, true
	case "MESSANA_AIR_RAY_CONDITIONINGSRL":
		return BACnetVendorId_MESSANA_AIR_RAY_CONDITIONINGSRL, true
	case "XYLEM_INC":
		return BACnetVendorId_XYLEM_INC, true
	case "HANGZHOUBATOWN_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_HANGZHOUBATOWN_TECHNOLOGY_CO_LTD, true
	case "REASONABLE_CONTROLS":
		return BACnetVendorId_REASONABLE_CONTROLS, true
	case "SERVISYS_INC":
		return BACnetVendorId_SERVISYS_INC, true
	case "HALSTRUPWALCHER_GMBH":
		return BACnetVendorId_HALSTRUPWALCHER_GMBH, true
	case "SWG_AUTOMATION_FUZHOU_LIMITED":
		return BACnetVendorId_SWG_AUTOMATION_FUZHOU_LIMITED, true
	case "KSB_AKTIENGESELLSCHAFT":
		return BACnetVendorId_KSB_AKTIENGESELLSCHAFT, true
	case "HYBRYD_SPZOO":
		return BACnetVendorId_HYBRYD_SPZOO, true
	case "HELVATRONAG":
		return BACnetVendorId_HELVATRONAG, true
	case "ODERON_SPZOO":
		return BACnetVendorId_ODERON_SPZOO, true
	case "MIKOLAB":
		return BACnetVendorId_MIKOLAB, true
	case "YAMATAKE_BUILDING_SYSTEMS_CO_LTD":
		return BACnetVendorId_YAMATAKE_BUILDING_SYSTEMS_CO_LTD, true
	case "EXODRAFT":
		return BACnetVendorId_EXODRAFT, true
	case "HOCHHUTH_GMBH":
		return BACnetVendorId_HOCHHUTH_GMBH, true
	case "INTEGRATED_SYSTEM_TECHNOLOGIES_LTD":
		return BACnetVendorId_INTEGRATED_SYSTEM_TECHNOLOGIES_LTD, true
	case "SHANGHAI_CELLCONS_CONTROLS_CO_LTD":
		return BACnetVendorId_SHANGHAI_CELLCONS_CONTROLS_CO_LTD, true
	case "EMME_CONTROLSLLC":
		return BACnetVendorId_EMME_CONTROLSLLC, true
	case "FIELD_DIAGNOSTIC_SERVICES_INC":
		return BACnetVendorId_FIELD_DIAGNOSTIC_SERVICES_INC, true
	case "GES_TEKNIKAS":
		return BACnetVendorId_GES_TEKNIKAS, true
	case "GLOBAL_POWER_PRODUCTS_INC":
		return BACnetVendorId_GLOBAL_POWER_PRODUCTS_INC, true
	case "OPTIONNV":
		return BACnetVendorId_OPTIONNV, true
	case "BV_CONTROLAG":
		return BACnetVendorId_BV_CONTROLAG, true
	case "THE_WATT_STOPPER_INC":
		return BACnetVendorId_THE_WATT_STOPPER_INC, true
	case "SIGREN_ENGINEERINGAG":
		return BACnetVendorId_SIGREN_ENGINEERINGAG, true
	case "SHANGHAI_JALTONE_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_SHANGHAI_JALTONE_TECHNOLOGY_CO_LTD, true
	case "MAX_LINE_SOLUTIONS_LTD":
		return BACnetVendorId_MAX_LINE_SOLUTIONS_LTD, true
	case "KRON_INSTRUMENTOS_ELTRICOS_LTDA":
		return BACnetVendorId_KRON_INSTRUMENTOS_ELTRICOS_LTDA, true
	case "THERMO_MATRIX":
		return BACnetVendorId_THERMO_MATRIX, true
	case "INFINITE_AUTOMATION_SYSTEMS_INC":
		return BACnetVendorId_INFINITE_AUTOMATION_SYSTEMS_INC, true
	case "VANTAGE":
		return BACnetVendorId_VANTAGE, true
	case "ELECON_MEASUREMENTS_PVT_LTD":
		return BACnetVendorId_ELECON_MEASUREMENTS_PVT_LTD, true
	case "TBA":
		return BACnetVendorId_TBA, true
	case "CARNES_COMPANY":
		return BACnetVendorId_CARNES_COMPANY, true
	case "AICHI_TOKEI_DENKI_CO_LTD":
		return BACnetVendorId_AICHI_TOKEI_DENKI_CO_LTD, true
	case "HARMAN_PROFESSIONAL":
		return BACnetVendorId_HARMAN_PROFESSIONAL, true
	case "NENUTEC_ASIA_PACIFIC_PTE_LTD":
		return BACnetVendorId_NENUTEC_ASIA_PACIFIC_PTE_LTD, true
	case "GIANV":
		return BACnetVendorId_GIANV, true
	case "KEPWARE_TEHNOLOGIES":
		return BACnetVendorId_KEPWARE_TEHNOLOGIES, true
	case "TEMPERATURE_ELECTRONICS_LTD":
		return BACnetVendorId_TEMPERATURE_ELECTRONICS_LTD, true
	case "PACKET_POWER":
		return BACnetVendorId_PACKET_POWER, true
	case "PROJECT_HAYSTACK_CORPORATION":
		return BACnetVendorId_PROJECT_HAYSTACK_CORPORATION, true
	case "DEOS_CONTROLS_AMERICAS_INC":
		return BACnetVendorId_DEOS_CONTROLS_AMERICAS_INC, true
	case "SENSEWARE_INC":
		return BACnetVendorId_SENSEWARE_INC, true
	case "MST_SYSTEMTECHNIKAG":
		return BACnetVendorId_MST_SYSTEMTECHNIKAG, true
	case "ACTIVATION_TECHNOLOGIESLLC":
		return BACnetVendorId_ACTIVATION_TECHNOLOGIESLLC, true
	case "LONIX_LTD":
		return BACnetVendorId_LONIX_LTD, true
	case "GOSSEN_METRAWATT_GMBH":
		return BACnetVendorId_GOSSEN_METRAWATT_GMBH, true
	case "AVIOSYS_INTERNATIONAL_INC":
		return BACnetVendorId_AVIOSYS_INTERNATIONAL_INC, true
	case "EFFICIENT_BUILDING_AUTOMATION_CORP":
		return BACnetVendorId_EFFICIENT_BUILDING_AUTOMATION_CORP, true
	case "ACCUTRON_INSTRUMENTS_INC":
		return BACnetVendorId_ACCUTRON_INSTRUMENTS_INC, true
	case "VERMONT_ENERGY_CONTROL_SYSTEMSLLC":
		return BACnetVendorId_VERMONT_ENERGY_CONTROL_SYSTEMSLLC, true
	case "DCC_DYNAMICS":
		return BACnetVendorId_DCC_DYNAMICS, true
	case "BEG_BRCK_ELECTRONIC_GMBH":
		return BACnetVendorId_BEG_BRCK_ELECTRONIC_GMBH, true
	case "NGBS_HUNGARY_LTD":
		return BACnetVendorId_NGBS_HUNGARY_LTD, true
	case "SAIA_BURGESS_CONTROLS_LTD":
		return BACnetVendorId_SAIA_BURGESS_CONTROLS_LTD, true
	case "ILLUM_TECHNOLOGYLLC":
		return BACnetVendorId_ILLUM_TECHNOLOGYLLC, true
	case "DELTA_CONTROLS_GERMANY_LIMITED":
		return BACnetVendorId_DELTA_CONTROLS_GERMANY_LIMITED, true
	case "ST_SERVICE_TECHNIQUESA":
		return BACnetVendorId_ST_SERVICE_TECHNIQUESA, true
	case "SIMPLE_SOFT":
		return BACnetVendorId_SIMPLE_SOFT, true
	case "ALTAIR_ENGINEERING":
		return BACnetVendorId_ALTAIR_ENGINEERING, true
	case "EZEN_SOLUTION_INC":
		return BACnetVendorId_EZEN_SOLUTION_INC, true
	case "FUJITEC_CO_LTD":
		return BACnetVendorId_FUJITEC_CO_LTD, true
	case "TERRALUX":
		return BACnetVendorId_TERRALUX, true
	case "ANNICOM":
		return BACnetVendorId_ANNICOM, true
	case "BIHL_WIEDEMANN_GMBH":
		return BACnetVendorId_BIHL_WIEDEMANN_GMBH, true
	case "SIEMENS_SCHWEIZAG1":
		return BACnetVendorId_SIEMENS_SCHWEIZAG1, true
	case "HITACHI_LTD":
		return BACnetVendorId_HITACHI_LTD, true
	case "DRAPER_INC":
		return BACnetVendorId_DRAPER_INC, true
	case "SCHCO_INTERNATIONALKG":
		return BACnetVendorId_SCHCO_INTERNATIONALKG, true
	case "OTIS_ELEVATOR_COMPANY":
		return BACnetVendorId_OTIS_ELEVATOR_COMPANY, true
	case "FIDELIX_OY":
		return BACnetVendorId_FIDELIX_OY, true
	case "RAM_GMBH_MESSUND_REGELTECHNIK":
		return BACnetVendorId_RAM_GMBH_MESSUND_REGELTECHNIK, true
	case "WEMS":
		return BACnetVendorId_WEMS, true
	case "RAVEL_ELECTRONICS_PVT_LTD":
		return BACnetVendorId_RAVEL_ELECTRONICS_PVT_LTD, true
	case "OMNI_MAGNI":
		return BACnetVendorId_OMNI_MAGNI, true
	case "ECHELON":
		return BACnetVendorId_ECHELON, true
	case "INTELLIMETER_CANADA_INC":
		return BACnetVendorId_INTELLIMETER_CANADA_INC, true
	case "NOVAR_CORP_TREND_CONTROL_SYSTEMS_LTD":
		return BACnetVendorId_NOVAR_CORP_TREND_CONTROL_SYSTEMS_LTD, true
	case "BITHOUSE_OY":
		return BACnetVendorId_BITHOUSE_OY, true
	case "BUILD_PULSE":
		return BACnetVendorId_BUILD_PULSE, true
	case "SHENZHEN1000_BUILDING_AUTOMATION_CO_LTD":
		return BACnetVendorId_SHENZHEN1000_BUILDING_AUTOMATION_CO_LTD, true
	case "AED_ENGINEERING_GMBH":
		return BACnetVendorId_AED_ENGINEERING_GMBH, true
	case "GNTNER_GMBH_COKG":
		return BACnetVendorId_GNTNER_GMBH_COKG, true
	case "KN_XLOGIC":
		return BACnetVendorId_KN_XLOGIC, true
	case "CIM_ENVIRONMENTAL_GROUP":
		return BACnetVendorId_CIM_ENVIRONMENTAL_GROUP, true
	case "FLOW_CONTROL":
		return BACnetVendorId_FLOW_CONTROL, true
	case "LUMEN_CACHE_INC":
		return BACnetVendorId_LUMEN_CACHE_INC, true
	case "MITSUBISHI_ELECTRIC_LIGHTING_CORPORATION":
		return BACnetVendorId_MITSUBISHI_ELECTRIC_LIGHTING_CORPORATION, true
	case "ECOSYSTEM":
		return BACnetVendorId_ECOSYSTEM, true
	case "POTTER_ELECTRIC_SIGNAL_COMPANYLLC":
		return BACnetVendorId_POTTER_ELECTRIC_SIGNAL_COMPANYLLC, true
	case "TYCO_FIRE_SECURITY_SPA":
		return BACnetVendorId_TYCO_FIRE_SECURITY_SPA, true
	case "WATANABE_ELECTRIC_INDUSTRY_CO_LTD":
		return BACnetVendorId_WATANABE_ELECTRIC_INDUSTRY_CO_LTD, true
	case "CAUSAM_ENERGY":
		return BACnetVendorId_CAUSAM_ENERGY, true
	case "WTECAG":
		return BACnetVendorId_WTECAG, true
	case "IMI_HYDRONIC_ENGINEERING_INTERNATIONALSA":
		return BACnetVendorId_IMI_HYDRONIC_ENGINEERING_INTERNATIONALSA, true
	case "ARIGO_SOFTWARE":
		return BACnetVendorId_ARIGO_SOFTWARE, true
	case "MSA_SAFETY1":
		return BACnetVendorId_MSA_SAFETY1, true
	case "SMART_SOLUCOES_LTDAMERCATO":
		return BACnetVendorId_SMART_SOLUCOES_LTDAMERCATO, true
	case "ARGUS_CONTROL_SYSTEMS_LTD":
		return BACnetVendorId_ARGUS_CONTROL_SYSTEMS_LTD, true
	case "PIATRA_ENGINEERING":
		return BACnetVendorId_PIATRA_ENGINEERING, true
	case "ODIN_AUTOMATION_SYSTEMSLLC":
		return BACnetVendorId_ODIN_AUTOMATION_SYSTEMSLLC, true
	case "BELPARTSNV":
		return BACnetVendorId_BELPARTSNV, true
	case "UABSALDA":
		return BACnetVendorId_UABSALDA, true
	case "ALREIT_REGELTECHNIK_GMBH":
		return BACnetVendorId_ALREIT_REGELTECHNIK_GMBH, true
	case "INGENIEURBROH_LERTES_GMBH_COKG":
		return BACnetVendorId_INGENIEURBROH_LERTES_GMBH_COKG, true
	case "BREATHING_BUILDINGS":
		return BACnetVendorId_BREATHING_BUILDINGS, true
	case "EWONSA":
		return BACnetVendorId_EWONSA, true
	case "CAV_UFF_GIACOMO_CIMBERIO_SPA":
		return BACnetVendorId_CAV_UFF_GIACOMO_CIMBERIO_SPA, true
	case "PKE_ELECTRONICSAG":
		return BACnetVendorId_PKE_ELECTRONICSAG, true
	case "KYUKI_CORPORATION":
		return BACnetVendorId_KYUKI_CORPORATION, true
	case "ALLEN":
		return BACnetVendorId_ALLEN, true
	case "KASTLE_SYSTEMS":
		return BACnetVendorId_KASTLE_SYSTEMS, true
	case "LOGICAL_ELECTRO_MECHANICALEM_SYSTEMS_INC":
		return BACnetVendorId_LOGICAL_ELECTRO_MECHANICALEM_SYSTEMS_INC, true
	case "PP_KINETICS_INSTRUMENTSLLC":
		return BACnetVendorId_PP_KINETICS_INSTRUMENTSLLC, true
	case "CATHEXIS_TECHNOLOGIES":
		return BACnetVendorId_CATHEXIS_TECHNOLOGIES, true
	case "SYLOPSP_ZOOSPK":
		return BACnetVendorId_SYLOPSP_ZOOSPK, true
	case "BRAUNS_CONTROL_GMBH":
		return BACnetVendorId_BRAUNS_CONTROL_GMBH, true
	case "OMRONSOCIALSOLUTIONSCOLTD":
		return BACnetVendorId_OMRONSOCIALSOLUTIONSCOLTD, true
	case "WILDEBOER_BAUTEILE_GMBH":
		return BACnetVendorId_WILDEBOER_BAUTEILE_GMBH, true
	case "SHANGHAI_BIENS_TECHNOLOGIES_LTD":
		return BACnetVendorId_SHANGHAI_BIENS_TECHNOLOGIES_LTD, true
	case "RICHARDS_ZETA_BUILDING_INTELLIGENCE_INC":
		return BACnetVendorId_RICHARDS_ZETA_BUILDING_INTELLIGENCE_INC, true
	case "BEIJINGHZHY_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_BEIJINGHZHY_TECHNOLOGY_CO_LTD, true
	case "BUILDING_CLOUDS":
		return BACnetVendorId_BUILDING_CLOUDS, true
	case "THE_UNIVERSITYOF_SHEFFIELD_DEPARTMENTOF_ELECTRONICAND_ELECTRICAL_ENGINEERING":
		return BACnetVendorId_THE_UNIVERSITYOF_SHEFFIELD_DEPARTMENTOF_ELECTRONICAND_ELECTRICAL_ENGINEERING, true
	case "FABTRONICS_AUSTRALIA_PTY_LTD":
		return BACnetVendorId_FABTRONICS_AUSTRALIA_PTY_LTD, true
	case "SLAT":
		return BACnetVendorId_SLAT, true
	case "SOFTWARE_MOTOR_CORPORATION":
		return BACnetVendorId_SOFTWARE_MOTOR_CORPORATION, true
	case "ARMSTRONG_INTERNATIONAL_INC":
		return BACnetVendorId_ARMSTRONG_INTERNATIONAL_INC, true
	case "STERIL_AIRE_INC":
		return BACnetVendorId_STERIL_AIRE_INC, true
	case "INFINIQUE":
		return BACnetVendorId_INFINIQUE, true
	case "ARCOM":
		return BACnetVendorId_ARCOM, true
	case "SCIENTECHRD_INC":
		return BACnetVendorId_SCIENTECHRD_INC, true
	case "ARGO_PERFORMANCE_LTD":
		return BACnetVendorId_ARGO_PERFORMANCE_LTD, true
	case "DIALIGHT":
		return BACnetVendorId_DIALIGHT, true
	case "IDEAL_TECHNICAL_SOLUTIONS":
		return BACnetVendorId_IDEAL_TECHNICAL_SOLUTIONS, true
	case "NEUROBATAG":
		return BACnetVendorId_NEUROBATAG, true
	case "NEYER_SOFTWARE_CONSULTINGLLC":
		return BACnetVendorId_NEYER_SOFTWARE_CONSULTINGLLC, true
	case "SCADA_TECHNOLOGY_DEVELOPMENT_CO_LTD":
		return BACnetVendorId_SCADA_TECHNOLOGY_DEVELOPMENT_CO_LTD, true
	case "DEMAND_LOGIC_LIMITED":
		return BACnetVendorId_DEMAND_LOGIC_LIMITED, true
	case "GWA_GROUP_LIMITED":
		return BACnetVendorId_GWA_GROUP_LIMITED, true
	case "OCCITALINE":
		return BACnetVendorId_OCCITALINE, true
	case "NAO_DIGITAL_CO_LTD":
		return BACnetVendorId_NAO_DIGITAL_CO_LTD, true
	case "VCI_CONTROLS_INC":
		return BACnetVendorId_VCI_CONTROLS_INC, true
	case "SHENZHEN_CHANSLINK_NETWORK_TECHNOLOGY_CO_LTD":
		return BACnetVendorId_SHENZHEN_CHANSLINK_NETWORK_TECHNOLOGY_CO_LTD, true
	case "SAMSUNG_ELECTRONICS_CO_LTD":
		return BACnetVendorId_SAMSUNG_ELECTRONICS_CO_LTD, true
	case "MESA_LABORATORIES_INC":
		return BACnetVendorId_MESA_LABORATORIES_INC, true
	case "FISCHER":
		return BACnetVendorId_FISCHER, true
	case "OP_SYS_SOLUTIONS_LTD":
		return BACnetVendorId_OP_SYS_SOLUTIONS_LTD, true
	case "ADVANCED_DEVICES_LIMITED":
		return BACnetVendorId_ADVANCED_DEVICES_LIMITED, true
	case "CONDAIR":
		return BACnetVendorId_CONDAIR, true
	case "INELCOM_INGENIERIA_ELECTRONICA_COMERCIALSA":
		return BACnetVendorId_INELCOM_INGENIERIA_ELECTRONICA_COMERCIALSA, true
	case "GRID_POINT_INC":
		return BACnetVendorId_GRID_POINT_INC, true
	case "ADF_TECHNOLOGIES_SDN_BHD":
		return BACnetVendorId_ADF_TECHNOLOGIES_SDN_BHD, true
	case "TOSHIBA_CORPORATION":
		return BACnetVendorId_TOSHIBA_CORPORATION, true
	case "EPM_INC":
		return BACnetVendorId_EPM_INC, true
	case "LIGHTING_CONTROLS_LTD":
		return BACnetVendorId_LIGHTING_CONTROLS_LTD, true
	case "PERIX_CONTROLS_LTD":
		return BACnetVendorId_PERIX_CONTROLS_LTD, true
	case "AERCO_INTERNATIONAL_INC":
		return BACnetVendorId_AERCO_INTERNATIONAL_INC, true
	case "KONE_INC":
		return BACnetVendorId_KONE_INC, true
	case "ZIEHL_ABEGGSE":
		return BACnetVendorId_ZIEHL_ABEGGSE, true
	case "ROBOTSA":
		return BACnetVendorId_ROBOTSA, true
	case "OPTIGO_NETWORKS_INC":
		return BACnetVendorId_OPTIGO_NETWORKS_INC, true
	case "OPENMOTICSBVBA":
		return BACnetVendorId_OPENMOTICSBVBA, true
	case "METROPOLITAN_INDUSTRIES_INC":
		return BACnetVendorId_METROPOLITAN_INDUSTRIES_INC, true
	case "MITSUBISHI_ELECTRIC_CORPORATION_AIR_CONDITIONING_REFRIGERATION_SYSTEMS_WORKS":
		return BACnetVendorId_MITSUBISHI_ELECTRIC_CORPORATION_AIR_CONDITIONING_REFRIGERATION_SYSTEMS_WORKS, true
	case "HUAWEI_TECHNOLOGIES_CO_LTD":
		return BACnetVendorId_HUAWEI_TECHNOLOGIES_CO_LTD, true
	case "DIGITAL_LUMENS_INC":
		return BACnetVendorId_DIGITAL_LUMENS_INC, true
	case "VANTI":
		return BACnetVendorId_VANTI, true
	case "CREE_LIGHTING":
		return BACnetVendorId_CREE_LIGHTING, true
	case "RICHMOND_HEIGHTSSDNBHD":
		return BACnetVendorId_RICHMOND_HEIGHTSSDNBHD, true
	case "PAYNE_SPARKMAN_LIGHTING_MANGEMENT":
		return BACnetVendorId_PAYNE_SPARKMAN_LIGHTING_MANGEMENT, true
	case "ASHCROFT":
		return BACnetVendorId_ASHCROFT, true
	case "JET_CONTROLS_CORP":
		return BACnetVendorId_JET_CONTROLS_CORP, true
	case "ZUMTOBEL_LIGHTING_GMBH":
		return BACnetVendorId_ZUMTOBEL_LIGHTING_GMBH, true
	}
	return 0, false
}

func BACnetVendorIdKnows(value uint16) bool {
	for _, typeValue := range BACnetVendorIdValues {
		if uint16(typeValue) == value {
			return true
		}
	}
	return false
}

func CastBACnetVendorId(structType any) BACnetVendorId {
	castFunc := func(typ any) BACnetVendorId {
		if sBACnetVendorId, ok := typ.(BACnetVendorId); ok {
			return sBACnetVendorId
		}
		return 0
	}
	return castFunc(structType)
}

func (m BACnetVendorId) GetLengthInBits(ctx context.Context) uint16 {
	return 16
}

func (m BACnetVendorId) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetVendorIdParse(ctx context.Context, theBytes []byte) (BACnetVendorId, error) {
	return BACnetVendorIdParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetVendorIdParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetVendorId, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("BACnetVendorId", 16)
	if err != nil {
		return 0, errors.Wrap(err, "error reading BACnetVendorId")
	}
	if enum, ok := BACnetVendorIdByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for BACnetVendorId")
		return BACnetVendorId(val), nil
	} else {
		return enum, nil
	}
}

func (e BACnetVendorId) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e BACnetVendorId) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteUint16("BACnetVendorId", 16, uint16(uint16(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e BACnetVendorId) GetValue() uint16 {
	return uint16(e)
}

func (e BACnetVendorId) GetVendorId() uint16 {
	return e.VendorId()
}
func (e BACnetVendorId) GetVendorName() string {
	return e.VendorName()
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e BACnetVendorId) PLC4XEnumName() string {
	switch e {
	case BACnetVendorId_ASHRAE:
		return "ASHRAE"
	case BACnetVendorId_UNKNOWN_VENDOR:
		return "UNKNOWN_VENDOR"
	case BACnetVendorId_NIST:
		return "NIST"
	case BACnetVendorId_SCHNEIDER_ELECTRIC:
		return "SCHNEIDER_ELECTRIC"
	case BACnetVendorId_CUSTOM_MECHANICAL_EQUIPMENTLLC:
		return "CUSTOM_MECHANICAL_EQUIPMENTLLC"
	case BACnetVendorId_EKON_GMBH:
		return "EKON_GMBH"
	case BACnetVendorId_MOLEX:
		return "MOLEX"
	case BACnetVendorId_MACO_LIGHTING_PTY_LTD:
		return "MACO_LIGHTING_PTY_LTD"
	case BACnetVendorId_AXECON_CORP:
		return "AXECON_CORP"
	case BACnetVendorId_TENSORPLC:
		return "TENSORPLC"
	case BACnetVendorId_KASEMAN_ENVIRONMENTAL_CONTROL_EQUIPMENT_SHANGHAI_LIMITED:
		return "KASEMAN_ENVIRONMENTAL_CONTROL_EQUIPMENT_SHANGHAI_LIMITED"
	case BACnetVendorId_AB_AXIS_INDUSTRIES:
		return "AB_AXIS_INDUSTRIES"
	case BACnetVendorId_NETIX_CONTROLS:
		return "NETIX_CONTROLS"
	case BACnetVendorId_ELDRIDGE_PRODUCTS_INC:
		return "ELDRIDGE_PRODUCTS_INC"
	case BACnetVendorId_MICRONICS:
		return "MICRONICS"
	case BACnetVendorId_CLIMATE_MASTER:
		return "CLIMATE_MASTER"
	case BACnetVendorId_FORTECHO_SOLUTIONS_LTD:
		return "FORTECHO_SOLUTIONS_LTD"
	case BACnetVendorId_SELLERS_MANUFACTURING_COMPANY:
		return "SELLERS_MANUFACTURING_COMPANY"
	case BACnetVendorId_RITE_HITE_DOORS_INC:
		return "RITE_HITE_DOORS_INC"
	case BACnetVendorId_VIOLET_DEFENSELLC:
		return "VIOLET_DEFENSELLC"
	case BACnetVendorId_SIMNA:
		return "SIMNA"
	case BACnetVendorId_MULTINERGIE_BEST_INC:
		return "MULTINERGIE_BEST_INC"
	case BACnetVendorId_MEGA_SYSTEM_TECHNOLOGIES_INC:
		return "MEGA_SYSTEM_TECHNOLOGIES_INC"
	case BACnetVendorId_RHEEM:
		return "RHEEM"
	case BACnetVendorId_ING_PUNZENBERGERCOPADATA_GMBH:
		return "ING_PUNZENBERGERCOPADATA_GMBH"
	case BACnetVendorId_MEC_ELECTRONICS_GMBH:
		return "MEC_ELECTRONICS_GMBH"
	case BACnetVendorId_ICP_PANEL_TEC_INC:
		return "ICP_PANEL_TEC_INC"
	case BACnetVendorId_TACO_COMFORT_SOLUTIONS:
		return "TACO_COMFORT_SOLUTIONS"
	case BACnetVendorId_ALEXANDER_MAIER_GMBH:
		return "ALEXANDER_MAIER_GMBH"
	case BACnetVendorId_ECORITHM_INC:
		return "ECORITHM_INC"
	case BACnetVendorId_ACCURRO_LTD:
		return "ACCURRO_LTD"
	case BACnetVendorId_ROMTECK_AUSTRALIA_PTY_LTD:
		return "ROMTECK_AUSTRALIA_PTY_LTD"
	case BACnetVendorId_SPLASH_MONITORING_LIMITED:
		return "SPLASH_MONITORING_LIMITED"
	case BACnetVendorId_LIGHT_APPLICATION:
		return "LIGHT_APPLICATION"
	case BACnetVendorId_LOGICAL_BUILDING_AUTOMATION:
		return "LOGICAL_BUILDING_AUTOMATION"
	case BACnetVendorId_EXILIGHT_OY:
		return "EXILIGHT_OY"
	case BACnetVendorId_HAGER_ELECTROSAS:
		return "HAGER_ELECTROSAS"
	case BACnetVendorId_D_TEK_CONTROLS:
		return "D_TEK_CONTROLS"
	case BACnetVendorId_KLIF_COLTD:
		return "KLIF_COLTD"
	case BACnetVendorId_HYGRO_MATIK:
		return "HYGRO_MATIK"
	case BACnetVendorId_DANIEL_MOUSSEAU_PROGRAMMATION_ELECTRONIQUE:
		return "DANIEL_MOUSSEAU_PROGRAMMATION_ELECTRONIQUE"
	case BACnetVendorId_AERIONICS_INC:
		return "AERIONICS_INC"
	case BACnetVendorId_MS_ELECTRONIQUE_LTEE:
		return "MS_ELECTRONIQUE_LTEE"
	case BACnetVendorId_AUTOMATION_COMPONENTS_INC:
		return "AUTOMATION_COMPONENTS_INC"
	case BACnetVendorId_NIOBRARA_RESEARCH_DEVELOPMENT_CORPORATION:
		return "NIOBRARA_RESEARCH_DEVELOPMENT_CORPORATION"
	case BACnetVendorId_NETCOM_SICHERHEITSTECHNIK_GMBH:
		return "NETCOM_SICHERHEITSTECHNIK_GMBH"
	case BACnetVendorId_LUMELSA:
		return "LUMELSA"
	case BACnetVendorId_GREAT_PLAINS_INDUSTRIES_INC:
		return "GREAT_PLAINS_INDUSTRIES_INC"
	case BACnetVendorId_NEC_ENGINEERING_LTD:
		return "NEC_ENGINEERING_LTD"
	case BACnetVendorId_DOMOTICA_LABSSRL:
		return "DOMOTICA_LABSSRL"
	case BACnetVendorId_ENERGY_CLOUD_INC:
		return "ENERGY_CLOUD_INC"
	case BACnetVendorId_VOMATEC:
		return "VOMATEC"
	case BACnetVendorId_DEMMA_COMPANIES:
		return "DEMMA_COMPANIES"
	case BACnetVendorId_VALSENA:
		return "VALSENA"
	case BACnetVendorId_COMSYS_BRTSCHAG:
		return "COMSYS_BRTSCHAG"
	case BACnetVendorId_B_GRID:
		return "B_GRID"
	case BACnetVendorId_MDJ_SOFTWARE_PTY_LTD:
		return "MDJ_SOFTWARE_PTY_LTD"
	case BACnetVendorId_DIMONOFF_INC:
		return "DIMONOFF_INC"
	case BACnetVendorId_EDOMO_SYSTEMS_GMBH:
		return "EDOMO_SYSTEMS_GMBH"
	case BACnetVendorId_PRIVABV:
		return "PRIVABV"
	case BACnetVendorId_EFFEKTIVLLC:
		return "EFFEKTIVLLC"
	case BACnetVendorId_STEAMO_VAP:
		return "STEAMO_VAP"
	case BACnetVendorId_GRANDCENTRIX_GMBH:
		return "GRANDCENTRIX_GMBH"
	case BACnetVendorId_WEINTEK_LABS_INC:
		return "WEINTEK_LABS_INC"
	case BACnetVendorId_INTEFOX_GMBH:
		return "INTEFOX_GMBH"
	case BACnetVendorId_RADIUS_AUTOMATION_COMPANY:
		return "RADIUS_AUTOMATION_COMPANY"
	case BACnetVendorId_RINGDALE_INC:
		return "RINGDALE_INC"
	case BACnetVendorId_IWAKI_AMERICA:
		return "IWAKI_AMERICA"
	case BACnetVendorId_BRACTLET:
		return "BRACTLET"
	case BACnetVendorId_STULZ_AIR_TECHNOLOGY_SYSTEMS_INC:
		return "STULZ_AIR_TECHNOLOGY_SYSTEMS_INC"
	case BACnetVendorId_MEIDENSHA_CORPORATION:
		return "MEIDENSHA_CORPORATION"
	case BACnetVendorId_CLIMATE_READY_ENGINEERING_PTY_LTD:
		return "CLIMATE_READY_ENGINEERING_PTY_LTD"
	case BACnetVendorId_GENEA_ENERGY_PARTNERS:
		return "GENEA_ENERGY_PARTNERS"
	case BACnetVendorId_IO_TALL_CHILE:
		return "IO_TALL_CHILE"
	case BACnetVendorId_IKS_CO_LTD:
		return "IKS_CO_LTD"
	case BACnetVendorId_YODIWOAB:
		return "YODIWOAB"
	case BACnetVendorId_TITA_NELECTRONIC_GMBH:
		return "TITA_NELECTRONIC_GMBH"
	case BACnetVendorId_IDEC_CORPORATION:
		return "IDEC_CORPORATION"
	case BACnetVendorId_SIFRISL:
		return "SIFRISL"
	case BACnetVendorId_THERMAL_GAS_SYSTEMS_INC:
		return "THERMAL_GAS_SYSTEMS_INC"
	case BACnetVendorId_BUILDING_AUTOMATION_PRODUCTS_INC:
		return "BUILDING_AUTOMATION_PRODUCTS_INC"
	case BACnetVendorId_JCI_SYSTEMS_INTEGRATION_SERVICES:
		return "JCI_SYSTEMS_INTEGRATION_SERVICES"
	case BACnetVendorId_ASSET_MAPPING:
		return "ASSET_MAPPING"
	case BACnetVendorId_SMARTEH_COMPANY:
		return "SMARTEH_COMPANY"
	case BACnetVendorId_DATAPOD_AUSTRALIA_PTY_LTD:
		return "DATAPOD_AUSTRALIA_PTY_LTD"
	case BACnetVendorId_BUILDINGS_ALIVE_PTY_LTD:
		return "BUILDINGS_ALIVE_PTY_LTD"
	case BACnetVendorId_DIGITAL_ELEKTRONIK:
		return "DIGITAL_ELEKTRONIK"
	case BACnetVendorId_TALENT_AUTOMAOE_TECNOLOGIA_LTDA:
		return "TALENT_AUTOMAOE_TECNOLOGIA_LTDA"
	case BACnetVendorId_NORPOSH_LIMITED:
		return "NORPOSH_LIMITED"
	case BACnetVendorId_MERKUR_FUNKSYSTEMEAG:
		return "MERKUR_FUNKSYSTEMEAG"
	case BACnetVendorId_FASTERC_ZSPOL_SRO:
		return "FASTERC_ZSPOL_SRO"
	case BACnetVendorId_ECO_ADAPT:
		return "ECO_ADAPT"
	case BACnetVendorId_FREEDOM_CORPORATION:
		return "FREEDOM_CORPORATION"
	case BACnetVendorId_ENERGOCENTRUM_PLUSSRO:
		return "ENERGOCENTRUM_PLUSSRO"
	case BACnetVendorId_AMBXUK_LTD:
		return "AMBXUK_LTD"
	case BACnetVendorId_WESTERN_RESERVE_CONTROLS_INC:
		return "WESTERN_RESERVE_CONTROLS_INC"
	case BACnetVendorId_LAYER_ZERO_POWER_SYSTEMS_INC:
		return "LAYER_ZERO_POWER_SYSTEMS_INC"
	case BACnetVendorId_CIC_JAN_HEBECSRO:
		return "CIC_JAN_HEBECSRO"
	case BACnetVendorId_SIGROVBV:
		return "SIGROVBV"
	case BACnetVendorId_ISYS_INTELLIGENT_SYSTEMS:
		return "ISYS_INTELLIGENT_SYSTEMS"
	case BACnetVendorId_GAS_DETECTION_AUSTRALIA_PTY_LTD:
		return "GAS_DETECTION_AUSTRALIA_PTY_LTD"
	case BACnetVendorId_KINCO_AUTOMATION_SHANGHAI_LTD:
		return "KINCO_AUTOMATION_SHANGHAI_LTD"
	case BACnetVendorId_LARS_ENERGYLLC:
		return "LARS_ENERGYLLC"
	case BACnetVendorId_NEUBERGER_GEBUDEAUTOMATION_GMBH:
		return "NEUBERGER_GEBUDEAUTOMATION_GMBH"
	case BACnetVendorId_FLAMEFASTUK_LTD:
		return "FLAMEFASTUK_LTD"
	case BACnetVendorId_ROYAL_SERVICE_AIR_CONDITIONING:
		return "ROYAL_SERVICE_AIR_CONDITIONING"
	case BACnetVendorId_AMPIO_SP_ZOO:
		return "AMPIO_SP_ZOO"
	case BACnetVendorId_INOVONICS_WIRELESS_CORPORATION:
		return "INOVONICS_WIRELESS_CORPORATION"
	case BACnetVendorId_NVENT_THERMAL_MANAGEMENT:
		return "NVENT_THERMAL_MANAGEMENT"
	case BACnetVendorId_SINOWELL_CONTROL_SYSTEM_LTD:
		return "SINOWELL_CONTROL_SYSTEM_LTD"
	case BACnetVendorId_MOXA_INC:
		return "MOXA_INC"
	case BACnetVendorId_MATRIXI_CONTROLSDNBHD:
		return "MATRIXI_CONTROLSDNBHD"
	case BACnetVendorId_PURPLE_SWIFT:
		return "PURPLE_SWIFT"
	case BACnetVendorId_OTIM_TECHNOLOGIES:
		return "OTIM_TECHNOLOGIES"
	case BACnetVendorId_TAC:
		return "TAC"
	case BACnetVendorId_E_ZI_CONTROLS:
		return "E_ZI_CONTROLS"
	case BACnetVendorId_FLOW_MATE_LIMITED:
		return "FLOW_MATE_LIMITED"
	case BACnetVendorId_DEGREE_CONTROLS_INC:
		return "DEGREE_CONTROLS_INC"
	case BACnetVendorId_FEI_XING_SHANGHAI_SOFTWARE_TECHNOLOGIES_CO_LTD:
		return "FEI_XING_SHANGHAI_SOFTWARE_TECHNOLOGIES_CO_LTD"
	case BACnetVendorId_BERG_GMBH:
		return "BERG_GMBH"
	case BACnetVendorId_ARENZIT:
		return "ARENZIT"
	case BACnetVendorId_EDELSTROM_ELECTRONIC_DEVICES_DESIGNINGLLC:
		return "EDELSTROM_ELECTRONIC_DEVICES_DESIGNINGLLC"
	case BACnetVendorId_DRIVE_CONNECTLLC:
		return "DRIVE_CONNECTLLC"
	case BACnetVendorId_DEVELOP_NOW:
		return "DEVELOP_NOW"
	case BACnetVendorId_POORT:
		return "POORT"
	case BACnetVendorId_VMEIL_INFORMATION_SHANGHAI_LTD:
		return "VMEIL_INFORMATION_SHANGHAI_LTD"
	case BACnetVendorId_LEVITON_MANUFACTURING:
		return "LEVITON_MANUFACTURING"
	case BACnetVendorId_RAYLEIGH_INSTRUMENTS:
		return "RAYLEIGH_INSTRUMENTS"
	case BACnetVendorId_CODESYS_DEVELOPMENT:
		return "CODESYS_DEVELOPMENT"
	case BACnetVendorId_SMARTWARE_TECHNOLOGIES_GROUPLLC:
		return "SMARTWARE_TECHNOLOGIES_GROUPLLC"
	case BACnetVendorId_POLAR_BEAR_SOLUTIONS:
		return "POLAR_BEAR_SOLUTIONS"
	case BACnetVendorId_CODRA:
		return "CODRA"
	case BACnetVendorId_PHAROS_ARCHITECTURAL_CONTROLS_LTD:
		return "PHAROS_ARCHITECTURAL_CONTROLS_LTD"
	case BACnetVendorId_ENGI_NEAR_LTD:
		return "ENGI_NEAR_LTD"
	case BACnetVendorId_AD_HOC_ELECTRONICS:
		return "AD_HOC_ELECTRONICS"
	case BACnetVendorId_UNIFIED_MICROSYSTEMS:
		return "UNIFIED_MICROSYSTEMS"
	case BACnetVendorId_FUJITSU_LIMITED:
		return "FUJITSU_LIMITED"
	case BACnetVendorId_INDUSTRIEELEKTRONIK_BRANDENBURG_GMBH:
		return "INDUSTRIEELEKTRONIK_BRANDENBURG_GMBH"
	case BACnetVendorId_HARTMANN_GMBH:
		return "HARTMANN_GMBH"
	case BACnetVendorId_PISCADA:
		return "PISCADA"
	case BACnetVendorId_KM_BSYSTEMSSRO:
		return "KM_BSYSTEMSSRO"
	case BACnetVendorId_POWER_TECH_ENGINEERINGAS:
		return "POWER_TECH_ENGINEERINGAS"
	case BACnetVendorId_TELEFONBAU_ARTHUR_SCHWABE_GMBH_COKG:
		return "TELEFONBAU_ARTHUR_SCHWABE_GMBH_COKG"
	case BACnetVendorId_WUXI_FISTWELOVE_TECHNOLOGY_CO_LTD:
		return "WUXI_FISTWELOVE_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_PRYSM:
		return "PRYSM"
	case BACnetVendorId_STEINEL_GMBH:
		return "STEINEL_GMBH"
	case BACnetVendorId_GEORG_FISCHERJRGAG:
		return "GEORG_FISCHERJRGAG"
	case BACnetVendorId_VERTIV_FORMERLY_EMERSON_NETWORK_POWER:
		return "VERTIV_FORMERLY_EMERSON_NETWORK_POWER"
	case BACnetVendorId_MAKE_DEVELOPSL:
		return "MAKE_DEVELOPSL"
	case BACnetVendorId_MONNIT_CORPORATION:
		return "MONNIT_CORPORATION"
	case BACnetVendorId_MIRROR_LIFE_CORPORATION:
		return "MIRROR_LIFE_CORPORATION"
	case BACnetVendorId_SECURE_METERS_LIMITED:
		return "SECURE_METERS_LIMITED"
	case BACnetVendorId_PECO:
		return "PECO"
	case BACnetVendorId_CCTECH_INC:
		return "CCTECH_INC"
	case BACnetVendorId_LIGHT_FI_LIMITED:
		return "LIGHT_FI_LIMITED"
	case BACnetVendorId_NICE_SPA:
		return "NICE_SPA"
	case BACnetVendorId_FIBER_SEN_SYS_INC:
		return "FIBER_SEN_SYS_INC"
	case BACnetVendorId_BD_BUCHTAUND_DEGEORGI:
		return "BD_BUCHTAUND_DEGEORGI"
	case BACnetVendorId_SA_ARMSTRONG_LTD:
		return "SA_ARMSTRONG_LTD"
	case BACnetVendorId_VENTACITY_SYSTEMS_INC:
		return "VENTACITY_SYSTEMS_INC"
	case BACnetVendorId_HITACHI_JOHNSON_CONTROLS_AIR_CONDITIONING_INC:
		return "HITACHI_JOHNSON_CONTROLS_AIR_CONDITIONING_INC"
	case BACnetVendorId_SAGE_METERING_INC:
		return "SAGE_METERING_INC"
	case BACnetVendorId_ANDEL_LIMITED:
		return "ANDEL_LIMITED"
	case BACnetVendorId_ECO_SMART_TECHNOLOGIES:
		return "ECO_SMART_TECHNOLOGIES"
	case BACnetVendorId_SET:
		return "SET"
	case BACnetVendorId_PROTEC_FIRE_DETECTION_SPAINSL:
		return "PROTEC_FIRE_DETECTION_SPAINSL"
	case BACnetVendorId_AGRAMERUG:
		return "AGRAMERUG"
	case BACnetVendorId_ANYLINK_ELECTRONIC_GMBH:
		return "ANYLINK_ELECTRONIC_GMBH"
	case BACnetVendorId_SCHINDLER_LTD:
		return "SCHINDLER_LTD"
	case BACnetVendorId_VISONETAG:
		return "VISONETAG"
	case BACnetVendorId_JIBREEL_ABDEEN_EST:
		return "JIBREEL_ABDEEN_EST"
	case BACnetVendorId_FLUIDYNE_CONTROL_SYSTEMS_PVT_LTD:
		return "FLUIDYNE_CONTROL_SYSTEMS_PVT_LTD"
	case BACnetVendorId_PRISM_SYSTEMS_INC:
		return "PRISM_SYSTEMS_INC"
	case BACnetVendorId_ENERTIV:
		return "ENERTIV"
	case BACnetVendorId_MIRASOFT_GMBH_COKG:
		return "MIRASOFT_GMBH_COKG"
	case BACnetVendorId_DUALTECHIT:
		return "DUALTECHIT"
	case BACnetVendorId_COUNTLOGICLLC:
		return "COUNTLOGICLLC"
	case BACnetVendorId_KOHLER:
		return "KOHLER"
	case BACnetVendorId_CHEN_SEN_CONTROLS_CO_LTD:
		return "CHEN_SEN_CONTROLS_CO_LTD"
	case BACnetVendorId_GREENHECK:
		return "GREENHECK"
	case BACnetVendorId_MM_SYSTEMS_INC:
		return "MM_SYSTEMS_INC"
	case BACnetVendorId_INTWINE_CONNECTLLC:
		return "INTWINE_CONNECTLLC"
	case BACnetVendorId_KARLBORGS_ELKONTROLL:
		return "KARLBORGS_ELKONTROLL"
	case BACnetVendorId_DATAKOM:
		return "DATAKOM"
	case BACnetVendorId_HOGA_CONTROLAS:
		return "HOGA_CONTROLAS"
	case BACnetVendorId_COOL_AUTOMATION:
		return "COOL_AUTOMATION"
	case BACnetVendorId_INTER_SEARCH_CO_LTD:
		return "INTER_SEARCH_CO_LTD"
	case BACnetVendorId_DABBEL_AUTOMATION_INTELLIGENCE_GMBH:
		return "DABBEL_AUTOMATION_INTELLIGENCE_GMBH"
	case BACnetVendorId_GADGEON_ENGINEERING_SMARTNESS:
		return "GADGEON_ENGINEERING_SMARTNESS"
	case BACnetVendorId_COSTER_GROUP_SRL:
		return "COSTER_GROUP_SRL"
	case BACnetVendorId_WALTER_MLLERAG:
		return "WALTER_MLLERAG"
	case BACnetVendorId_CUSTOM_SOFTWARE_ENGINEERING:
		return "CUSTOM_SOFTWARE_ENGINEERING"
	case BACnetVendorId_FLUKE:
		return "FLUKE"
	case BACnetVendorId_QUINTEX_SYSTEMS_LTD:
		return "QUINTEX_SYSTEMS_LTD"
	case BACnetVendorId_SENFFICIENTSDNBHD:
		return "SENFFICIENTSDNBHD"
	case BACnetVendorId_NUBEIO_OPERATIONS_PTY_LTD:
		return "NUBEIO_OPERATIONS_PTY_LTD"
	case BACnetVendorId_DAS_INTEGRATOR_PTE_LTD:
		return "DAS_INTEGRATOR_PTE_LTD"
	case BACnetVendorId_CREVIS_CO_LTD:
		return "CREVIS_CO_LTD"
	case BACnetVendorId_I_SQUAREDSOFTWAREINC:
		return "I_SQUAREDSOFTWAREINC"
	case BACnetVendorId_KTG_GMBH:
		return "KTG_GMBH"
	case BACnetVendorId_POK_GROUP_OY:
		return "POK_GROUP_OY"
	case BACnetVendorId_ADISCOM:
		return "ADISCOM"
	case BACnetVendorId_NITTAN_COMPANY_LIMITED:
		return "NITTAN_COMPANY_LIMITED"
	case BACnetVendorId_INCUSENSE:
		return "INCUSENSE"
	case BACnetVendorId_F:
		return "F"
	case BACnetVendorId_ANORD_MARDIX_INC:
		return "ANORD_MARDIX_INC"
	case BACnetVendorId_HOSCH_GEBUDEAUTOMATION_NEUE_PRODUKTE_GMBH:
		return "HOSCH_GEBUDEAUTOMATION_NEUE_PRODUKTE_GMBH"
	case BACnetVendorId_BOSCHIO_GMBH:
		return "BOSCHIO_GMBH"
	case BACnetVendorId_ROYAL_BOON_EDAM_INTERNATIONALBV:
		return "ROYAL_BOON_EDAM_INTERNATIONALBV"
	case BACnetVendorId_CLACK_CORPORATION:
		return "CLACK_CORPORATION"
	case BACnetVendorId_UNITEX_CONTROLSLLC:
		return "UNITEX_CONTROLSLLC"
	case BACnetVendorId_KTC_GTEBORGAB:
		return "KTC_GTEBORGAB"
	case BACnetVendorId_INTERZONAB:
		return "INTERZONAB"
	case BACnetVendorId_ELUTIONS_INC_WIZCON_SYSTEMSSAS:
		return "ELUTIONS_INC_WIZCON_SYSTEMSSAS"
	case BACnetVendorId_ISDEINGSL:
		return "ISDEINGSL"
	case BACnetVendorId_AB_MAUTOMATIONBUILDINGMESSAGING_GMBH:
		return "AB_MAUTOMATIONBUILDINGMESSAGING_GMBH"
	case BACnetVendorId_KENTEC_ELECTRONICS_LTD:
		return "KENTEC_ELECTRONICS_LTD"
	case BACnetVendorId_COPELANDLP:
		return "COPELANDLP"
	case BACnetVendorId_POWERSIDE:
		return "POWERSIDE"
	case BACnetVendorId_SMC_GROUP:
		return "SMC_GROUP"
	case BACnetVendorId_EOS_WEATHER_INSTRUMENTS:
		return "EOS_WEATHER_INSTRUMENTS"
	case BACnetVendorId_ZONEX_SYSTEMS:
		return "ZONEX_SYSTEMS"
	case BACnetVendorId_GENEREX_SYSTEMS_COMPUTERVERTRIEBSGESELLSCHAFTMBH:
		return "GENEREX_SYSTEMS_COMPUTERVERTRIEBSGESELLSCHAFTMBH"
	case BACnetVendorId_ENERGY_WALLLLC:
		return "ENERGY_WALLLLC"
	case BACnetVendorId_ORION_ANALYSIS_CORPORATION:
		return "ORION_ANALYSIS_CORPORATION"
	case BACnetVendorId_PACOM_SYSTEMS_PTY_LTD:
		return "PACOM_SYSTEMS_PTY_LTD"
	case BACnetVendorId_THERMOFIN:
		return "THERMOFIN"
	case BACnetVendorId_SDATAWAYSA:
		return "SDATAWAYSA"
	case BACnetVendorId_BIDDLE_AIR_SYSTEMS_LIMITED:
		return "BIDDLE_AIR_SYSTEMS_LIMITED"
	case BACnetVendorId_KESSLER_ELLIS_PRODUCTS:
		return "KESSLER_ELLIS_PRODUCTS"
	case BACnetVendorId_THERMOSCREENS:
		return "THERMOSCREENS"
	case BACnetVendorId_MODIO:
		return "MODIO"
	case BACnetVendorId_NEWRON_SOLUTIONS:
		return "NEWRON_SOLUTIONS"
	case BACnetVendorId_UNITRONICS:
		return "UNITRONICS"
	case BACnetVendorId_TRILUX_GMBH_COKG:
		return "TRILUX_GMBH_COKG"
	case BACnetVendorId_KOLLMORGEN_STEUERUNGSTECHNIK_GMBH:
		return "KOLLMORGEN_STEUERUNGSTECHNIK_GMBH"
	case BACnetVendorId_UNICO_INC:
		return "UNICO_INC"
	case BACnetVendorId_BOSCH_REXROTHAG:
		return "BOSCH_REXROTHAG"
	case BACnetVendorId_ALARKO_CARRIER:
		return "ALARKO_CARRIER"
	case BACnetVendorId_VERDIGRIS_TECHNOLOGIES:
		return "VERDIGRIS_TECHNOLOGIES"
	case BACnetVendorId_SHANGHAISIIC_LONGCHUANG_SMARTECH_SO_LTD:
		return "SHANGHAISIIC_LONGCHUANG_SMARTECH_SO_LTD"
	case BACnetVendorId_QUINDA_CO:
		return "QUINDA_CO"
	case BACnetVendorId_GRUNERAG:
		return "GRUNERAG"
	case BACnetVendorId_BACMOVE:
		return "BACMOVE"
	case BACnetVendorId_PSIDACAB:
		return "PSIDACAB"
	case BACnetVendorId_ISICON_CONTROL_AUTOMATION:
		return "ISICON_CONTROL_AUTOMATION"
	case BACnetVendorId_BIG_ASS_FANS:
		return "BIG_ASS_FANS"
	case BACnetVendorId_EBTRON_INC:
		return "EBTRON_INC"
	case BACnetVendorId_DIN_DIETMAR_NOCKER_FACILITY_MANAGEMENT_GMBH:
		return "DIN_DIETMAR_NOCKER_FACILITY_MANAGEMENT_GMBH"
	case BACnetVendorId_TELDIO:
		return "TELDIO"
	case BACnetVendorId_MIKROKLIM_ASRO:
		return "MIKROKLIM_ASRO"
	case BACnetVendorId_DENSITY:
		return "DENSITY"
	case BACnetVendorId_ICONAG_LEITTECHNIK_GMBH:
		return "ICONAG_LEITTECHNIK_GMBH"
	case BACnetVendorId_AWAIR:
		return "AWAIR"
	case BACnetVendorId_TD_ENGINEERING_LTD:
		return "TD_ENGINEERING_LTD"
	case BACnetVendorId_SISTEMAS_DIGITALES:
		return "SISTEMAS_DIGITALES"
	case BACnetVendorId_LOXONE_ELECTRONICS_GMBH:
		return "LOXONE_ELECTRONICS_GMBH"
	case BACnetVendorId_ACTRON_AIR:
		return "ACTRON_AIR"
	case BACnetVendorId_SCADA_ENGINE:
		return "SCADA_ENGINE"
	case BACnetVendorId_INDUCTIVE_AUTOMATION:
		return "INDUCTIVE_AUTOMATION"
	case BACnetVendorId_THOR_ENGINEERING_GMBH:
		return "THOR_ENGINEERING_GMBH"
	case BACnetVendorId_BERNER_INTERNATIONALLLC:
		return "BERNER_INTERNATIONALLLC"
	case BACnetVendorId_POTSDAM_SENSORSLLC:
		return "POTSDAM_SENSORSLLC"
	case BACnetVendorId_KOHLER_MIRA_LTD:
		return "KOHLER_MIRA_LTD"
	case BACnetVendorId_TECOMON_GMBH:
		return "TECOMON_GMBH"
	case BACnetVendorId_TWO_DIMENSIONAL_INSTRUMENTSLLC:
		return "TWO_DIMENSIONAL_INSTRUMENTSLLC"
	case BACnetVendorId_LEFA_TECHNOLOGIES_PTE_LTD:
		return "LEFA_TECHNOLOGIES_PTE_LTD"
	case BACnetVendorId_EATONCEAG_NOTLICHTSYSTEME_GMBH:
		return "EATONCEAG_NOTLICHTSYSTEME_GMBH"
	case BACnetVendorId_COMMBOX_TECNOLOGIA:
		return "COMMBOX_TECNOLOGIA"
	case BACnetVendorId_LENZE_AMERICAS_FORMERLYAC_TECHNOLOGY_CORPORATION:
		return "LENZE_AMERICAS_FORMERLYAC_TECHNOLOGY_CORPORATION"
	case BACnetVendorId_IP_VIDEO_CORPORATION:
		return "IP_VIDEO_CORPORATION"
	case BACnetVendorId_BENDER_GMBH_COKG:
		return "BENDER_GMBH_COKG"
	case BACnetVendorId_RHYMEBUS_CORPORATION:
		return "RHYMEBUS_CORPORATION"
	case BACnetVendorId_AXON_SYSTEMS_LTD:
		return "AXON_SYSTEMS_LTD"
	case BACnetVendorId_ENGINEERED_AIR:
		return "ENGINEERED_AIR"
	case BACnetVendorId_ELIPSE_SOFTWARE_LTDA:
		return "ELIPSE_SOFTWARE_LTDA"
	case BACnetVendorId_SIMATIX_BUILDING_TECHNOLOGIES_PVT_LTD:
		return "SIMATIX_BUILDING_TECHNOLOGIES_PVT_LTD"
	case BACnetVendorId_WA_BENJAMIN_ELECTRIC_CO:
		return "WA_BENJAMIN_ELECTRIC_CO"
	case BACnetVendorId_TROX_AIR_CONDITIONING_COMPONENTS_SUZHOU_CO_LTD:
		return "TROX_AIR_CONDITIONING_COMPONENTS_SUZHOU_CO_LTD"
	case BACnetVendorId_SC_MEDICAL_PTY_LTD:
		return "SC_MEDICAL_PTY_LTD"
	case BACnetVendorId_EAGLE_TECHNOLOGY:
		return "EAGLE_TECHNOLOGY"
	case BACnetVendorId_ELCANICAS:
		return "ELCANICAS"
	case BACnetVendorId_OBEOAS:
		return "OBEOAS"
	case BACnetVendorId_TAPA_INC:
		return "TAPA_INC"
	case BACnetVendorId_ASE_SMART_ENERGY_INC:
		return "ASE_SMART_ENERGY_INC"
	case BACnetVendorId_PERFORMANCE_SERVICES_INC:
		return "PERFORMANCE_SERVICES_INC"
	case BACnetVendorId_VERIDIFY_SECURITY:
		return "VERIDIFY_SECURITY"
	case BACnetVendorId_CD_INNOVATIONLTD:
		return "CD_INNOVATIONLTD"
	case BACnetVendorId_BEN_PEOPLES_INDUSTRIESLLC:
		return "BEN_PEOPLES_INDUSTRIESLLC"
	case BACnetVendorId_UNICOMM_SPZOO:
		return "UNICOMM_SPZOO"
	case BACnetVendorId_THING_TECHNOLOGIES_GMBH:
		return "THING_TECHNOLOGIES_GMBH"
	case BACnetVendorId_DATA_AIRE_INC:
		return "DATA_AIRE_INC"
	case BACnetVendorId_BEIJING_HAILIN_CONTROL_TECHNOLOGY_INC:
		return "BEIJING_HAILIN_CONTROL_TECHNOLOGY_INC"
	case BACnetVendorId_DIGITAL_REALTY:
		return "DIGITAL_REALTY"
	case BACnetVendorId_AGROWTEK_INC:
		return "AGROWTEK_INC"
	case BACnetVendorId_DSP_INNOVATIONBV:
		return "DSP_INNOVATIONBV"
	case BACnetVendorId_STV_ELECTRONIC_GMBH:
		return "STV_ELECTRONIC_GMBH"
	case BACnetVendorId_ELMEASURE_INDIA_PVT_LTD:
		return "ELMEASURE_INDIA_PVT_LTD"
	case BACnetVendorId_PINESHORE_ENERGYLLC:
		return "PINESHORE_ENERGYLLC"
	case BACnetVendorId_BRASCH_ENVIRONMENTAL_TECHNOLOGIESLLC:
		return "BRASCH_ENVIRONMENTAL_TECHNOLOGIESLLC"
	case BACnetVendorId_SHEN_ZHEN_ZHI_XING_BUILDING_TECH_CO_LTD:
		return "SHEN_ZHEN_ZHI_XING_BUILDING_TECH_CO_LTD"
	case BACnetVendorId_SINUX:
		return "SINUX"
	case BACnetVendorId_ABB_INC:
		return "ABB_INC"
	case BACnetVendorId_AVNET_INC:
		return "AVNET_INC"
	case BACnetVendorId_SOMFY_ACTIVITESSA:
		return "SOMFY_ACTIVITESSA"
	case BACnetVendorId_AMICO:
		return "AMICO"
	case BACnetVendorId_SAGE_GLASS:
		return "SAGE_GLASS"
	case BACnetVendorId_AU_VERTE:
		return "AU_VERTE"
	case BACnetVendorId_AGILE_CONNECTS_PVT_LTD:
		return "AGILE_CONNECTS_PVT_LTD"
	case BACnetVendorId_LOCIMATION_PTY_LTD:
		return "LOCIMATION_PTY_LTD"
	case BACnetVendorId_ENVIO_SYSTEMS_GMBH:
		return "ENVIO_SYSTEMS_GMBH"
	case BACnetVendorId_VOYTECH_SYSTEMS_LIMITED:
		return "VOYTECH_SYSTEMS_LIMITED"
	case BACnetVendorId_DAVIDSMEYERUND_PAUL_GMBH:
		return "DAVIDSMEYERUND_PAUL_GMBH"
	case BACnetVendorId_TRANSBIT_SPZOO:
		return "TRANSBIT_SPZOO"
	case BACnetVendorId_LUSHER_ENGINEERING_SERVICES:
		return "LUSHER_ENGINEERING_SERVICES"
	case BACnetVendorId_CHNT_NANJING_TECHSEL_INTELLIGENT_COMPANYLTD:
		return "CHNT_NANJING_TECHSEL_INTELLIGENT_COMPANYLTD"
	case BACnetVendorId_THREETRONICS_PTY_LTD:
		return "THREETRONICS_PTY_LTD"
	case BACnetVendorId_SKY_FOUNDRYLLC:
		return "SKY_FOUNDRYLLC"
	case BACnetVendorId_HANIL_PRO_TECH:
		return "HANIL_PRO_TECH"
	case BACnetVendorId_SENSORSCALL:
		return "SENSORSCALL"
	case BACnetVendorId_SHANGHAI_JINGPU_INFORMATION_TECHNOLOGY_CO_LTD:
		return "SHANGHAI_JINGPU_INFORMATION_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_LICHTMANUFAKTUR_BERLIN_GMBH:
		return "LICHTMANUFAKTUR_BERLIN_GMBH"
	case BACnetVendorId_ECO_PARKING_TECHNOLOGIES:
		return "ECO_PARKING_TECHNOLOGIES"
	case BACnetVendorId_ENVISION_DIGITAL_INTERNATIONAL_PTE_LTD:
		return "ENVISION_DIGITAL_INTERNATIONAL_PTE_LTD"
	case BACnetVendorId_CARRIER_JAPAN_CORPORATION:
		return "CARRIER_JAPAN_CORPORATION"
	case BACnetVendorId_ANTONY_DEVELOPPEMENT_ELECTRONIQUE:
		return "ANTONY_DEVELOPPEMENT_ELECTRONIQUE"
	case BACnetVendorId_ISYSTEMS:
		return "ISYSTEMS"
	case BACnetVendorId_THUREON_INTERNATIONAL_LIMITED:
		return "THUREON_INTERNATIONAL_LIMITED"
	case BACnetVendorId_PULSAFEEDER:
		return "PULSAFEEDER"
	case BACnetVendorId_MEGA_CHIPS_CORPORATION:
		return "MEGA_CHIPS_CORPORATION"
	case BACnetVendorId_TES_CONTROLS:
		return "TES_CONTROLS"
	case BACnetVendorId_CERMATE:
		return "CERMATE"
	case BACnetVendorId_GRAND_VALLEY_STATE_UNIVERSITY:
		return "GRAND_VALLEY_STATE_UNIVERSITY"
	case BACnetVendorId_SYMCON_GMBH:
		return "SYMCON_GMBH"
	case BACnetVendorId_THE_CHICAGO_FAUCET_COMPANY:
		return "THE_CHICAGO_FAUCET_COMPANY"
	case BACnetVendorId_TELETROL_SYSTEMS_INC:
		return "TELETROL_SYSTEMS_INC"
	case BACnetVendorId_SHENZHEN_JUNZHI_HI_TECH_CO_LTD:
		return "SHENZHEN_JUNZHI_HI_TECH_CO_LTD"
	case BACnetVendorId_GEBERITAG:
		return "GEBERITAG"
	case BACnetVendorId_REX_CONTROLS:
		return "REX_CONTROLS"
	case BACnetVendorId_IVMS_GMBH:
		return "IVMS_GMBH"
	case BACnetVendorId_MNPP_SATURN_LTD:
		return "MNPP_SATURN_LTD"
	case BACnetVendorId_REGAL_BELOIT:
		return "REGAL_BELOIT"
	case BACnetVendorId_ACS_AIR_CONDITIONING_SOLUTIONS:
		return "ACS_AIR_CONDITIONING_SOLUTIONS"
	case BACnetVendorId_GBX_TECHNOLOGYLLC:
		return "GBX_TECHNOLOGYLLC"
	case BACnetVendorId_KAITERRA:
		return "KAITERRA"
	case BACnetVendorId_THIN_KUANLOT_TECHNOLOGY_SHANGHAI_CO_LTD:
		return "THIN_KUANLOT_TECHNOLOGY_SHANGHAI_CO_LTD"
	case BACnetVendorId_HO_CO_STOBV:
		return "HO_CO_STOBV"
	case BACnetVendorId_TOKAI_SOFT:
		return "TOKAI_SOFT"
	case BACnetVendorId_SHENZHENASAI_TECHNOLOGY_CO_LTD:
		return "SHENZHENASAI_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_RPS_SPA:
		return "RPS_SPA"
	case BACnetVendorId_ESMSOLUTIONS:
		return "ESMSOLUTIONS"
	case BACnetVendorId_IO_TECH_SYSTEMS_LIMITED:
		return "IO_TECH_SYSTEMS_LIMITED"
	case BACnetVendorId_I_AUTO_LOGIC_CO_LTD:
		return "I_AUTO_LOGIC_CO_LTD"
	case BACnetVendorId_NEW_AGE_MICROLLC:
		return "NEW_AGE_MICROLLC"
	case BACnetVendorId_GUARDIAN_GLASS:
		return "GUARDIAN_GLASS"
	case BACnetVendorId_GUANGZHOU_ZHAOYU_INFORMATION_TECHNOLOGY:
		return "GUANGZHOU_ZHAOYU_INFORMATION_TECHNOLOGY"
	case BACnetVendorId_ACE_IOT_SOLUTIONSLLC:
		return "ACE_IOT_SOLUTIONSLLC"
	case BACnetVendorId_PORIS_ELECTRONICS_CO_LTD:
		return "PORIS_ELECTRONICS_CO_LTD"
	case BACnetVendorId_BLUE_RIDGE_TECHNOLOGIES:
		return "BLUE_RIDGE_TECHNOLOGIES"
	case BACnetVendorId_TERMINUS_TECHNOLOGIES_GROUP:
		return "TERMINUS_TECHNOLOGIES_GROUP"
	case BACnetVendorId_INTECH1_INC:
		return "INTECH1_INC"
	case BACnetVendorId_ACCURATE_ELECTRONICS:
		return "ACCURATE_ELECTRONICS"
	case BACnetVendorId_FLUENCE_BIOENGINEERING:
		return "FLUENCE_BIOENGINEERING"
	case BACnetVendorId_MUN_HEAN_SINGAPORE_PTE_LTD:
		return "MUN_HEAN_SINGAPORE_PTE_LTD"
	case BACnetVendorId_KATRONICAG_COKG:
		return "KATRONICAG_COKG"
	case BACnetVendorId_SUZHOU_XIN_AO_INFORMATION_TECHNOLOGY_CO_LTD:
		return "SUZHOU_XIN_AO_INFORMATION_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_LINKTEKK_TECHNOLOGYJSC:
		return "LINKTEKK_TECHNOLOGYJSC"
	case BACnetVendorId_STIRLING_ULTRACOLD:
		return "STIRLING_ULTRACOLD"
	case BACnetVendorId_UV_PARTNERS_INC:
		return "UV_PARTNERS_INC"
	case BACnetVendorId_VERIS_INDUSTRIES:
		return "VERIS_INDUSTRIES"
	case BACnetVendorId_PRO_MINENT_GMBH:
		return "PRO_MINENT_GMBH"
	case BACnetVendorId_MULTI_TECH_SYSTEMS_INC:
		return "MULTI_TECH_SYSTEMS_INC"
	case BACnetVendorId_JUMO_GMBH_COKG:
		return "JUMO_GMBH_COKG"
	case BACnetVendorId_QINGDAO_HUARUI_TECHNOLOGY_CO_LTD:
		return "QINGDAO_HUARUI_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_CAIRN_SYSTEMES:
		return "CAIRN_SYSTEMES"
	case BACnetVendorId_NEURO_LOGIC_RESEARCH_CORP:
		return "NEURO_LOGIC_RESEARCH_CORP"
	case BACnetVendorId_TRANSITION_TECHNOLOGIES_ADVANCED_SOLUTIONS_SPZOO:
		return "TRANSITION_TECHNOLOGIES_ADVANCED_SOLUTIONS_SPZOO"
	case BACnetVendorId_XXTERBV:
		return "XXTERBV"
	case BACnetVendorId_PASSIVE_LOGIC:
		return "PASSIVE_LOGIC"
	case BACnetVendorId_EN_SMART_CONTROLS:
		return "EN_SMART_CONTROLS"
	case BACnetVendorId_CENTAURUS_PRIME:
		return "CENTAURUS_PRIME"
	case BACnetVendorId_WATTS_HEATINGAND_HOT_WATER_SOLUTIONSDBA_LYNC:
		return "WATTS_HEATINGAND_HOT_WATER_SOLUTIONSDBA_LYNC"
	case BACnetVendorId_TROPOSPHAIRA_TECHNOLOGIESLLP:
		return "TROPOSPHAIRA_TECHNOLOGIESLLP"
	case BACnetVendorId_NETWORK_THERMOSTAT:
		return "NETWORK_THERMOSTAT"
	case BACnetVendorId_TITANIUM_INTELLIGENT_SOLUTIONSLLC:
		return "TITANIUM_INTELLIGENT_SOLUTIONSLLC"
	case BACnetVendorId_NUMA_PRODUCTSLLC:
		return "NUMA_PRODUCTSLLC"
	case BACnetVendorId_WAREMA_RENKHOFFSE:
		return "WAREMA_RENKHOFFSE"
	case BACnetVendorId_FRESEAS:
		return "FRESEAS"
	case BACnetVendorId_MAPPED:
		return "MAPPED"
	case BACnetVendorId_ELEKTRODESIG_NVENTILATORYSRO:
		return "ELEKTRODESIG_NVENTILATORYSRO"
	case BACnetVendorId_AIR_CARE_AUTOMATION_INC:
		return "AIR_CARE_AUTOMATION_INC"
	case BACnetVendorId_SAND_NETWORK_SYSTEMS:
		return "SAND_NETWORK_SYSTEMS"
	case BACnetVendorId_ANTRUM:
		return "ANTRUM"
	case BACnetVendorId_BAO_LINH_CONNECT_TECHNOLOGY:
		return "BAO_LINH_CONNECT_TECHNOLOGY"
	case BACnetVendorId_VIRGINIA_CONTROLSLLC:
		return "VIRGINIA_CONTROLSLLC"
	case BACnetVendorId_DUOSYSSDNBHD:
		return "DUOSYSSDNBHD"
	case BACnetVendorId_ONSENSAS:
		return "ONSENSAS"
	case BACnetVendorId_VAUGHN_THERMAL_CORPORATION:
		return "VAUGHN_THERMAL_CORPORATION"
	case BACnetVendorId_THERMOPLASTIC_ENGINEERING_LTDTPE:
		return "THERMOPLASTIC_ENGINEERING_LTDTPE"
	case BACnetVendorId_WIRTH_RESEARCH_LTD:
		return "WIRTH_RESEARCH_LTD"
	case BACnetVendorId_SST_AUTOMATION:
		return "SST_AUTOMATION"
	case BACnetVendorId_SHANGHAI_BENCOL_ELECTRONIC_TECHNOLOGY_CO_LTD:
		return "SHANGHAI_BENCOL_ELECTRONIC_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_REGULVAR_INC:
		return "REGULVAR_INC"
	case BACnetVendorId_AIWAA_SYSTEMS_PRIVATE_LIMITED:
		return "AIWAA_SYSTEMS_PRIVATE_LIMITED"
	case BACnetVendorId_ENLESS_WIRELESS:
		return "ENLESS_WIRELESS"
	case BACnetVendorId_OZUNO_ENGINEERING_PTY_LTD:
		return "OZUNO_ENGINEERING_PTY_LTD"
	case BACnetVendorId_HUBBELL_THE_ELECTRIC_HEATER_COMPANY:
		return "HUBBELL_THE_ELECTRIC_HEATER_COMPANY"
	case BACnetVendorId_INDUSTRIAL_TURNAROUND_CORPORATIONITAC:
		return "INDUSTRIAL_TURNAROUND_CORPORATIONITAC"
	case BACnetVendorId_WADSWORTH_CONTROL_SYSTEMS:
		return "WADSWORTH_CONTROL_SYSTEMS"
	case BACnetVendorId_SERVICES_HILO_INC:
		return "SERVICES_HILO_INC"
	case BACnetVendorId_IDM_ENERGIESYSTEME_GMBH:
		return "IDM_ENERGIESYSTEME_GMBH"
	case BACnetVendorId_BE_NEXTBV:
		return "BE_NEXTBV"
	case BACnetVendorId_CLEAN_AIRAI_CORPORATION:
		return "CLEAN_AIRAI_CORPORATION"
	case BACnetVendorId_AF_DTEK_DIVISIONOF_FASTEK_INTERNATIONAL_INC:
		return "AF_DTEK_DIVISIONOF_FASTEK_INTERNATIONAL_INC"
	case BACnetVendorId_REVOLUTION_MICROELECTRONICS_AMERICA_INC:
		return "REVOLUTION_MICROELECTRONICS_AMERICA_INC"
	case BACnetVendorId_REAL_TIME_SYSTEMS_GMBH:
		return "REAL_TIME_SYSTEMS_GMBH"
	case BACnetVendorId_ZED_BEE_TECHNOLOGIES_PVT_LTD:
		return "ZED_BEE_TECHNOLOGIES_PVT_LTD"
	case BACnetVendorId_WIMATE_TECHNOLOGY_SOLUTIONS_PVT_LTD:
		return "WIMATE_TECHNOLOGY_SOLUTIONS_PVT_LTD"
	case BACnetVendorId_SENTICON_LTD:
		return "SENTICON_LTD"
	case BACnetVendorId_ROSSAKERAB:
		return "ROSSAKERAB"
	case BACnetVendorId_OPIT_SOLUTIONS_LTD:
		return "OPIT_SOLUTIONS_LTD"
	case BACnetVendorId_HOTOWELL_INTERNATIONAL_CO_LIMITED:
		return "HOTOWELL_INTERNATIONAL_CO_LIMITED"
	case BACnetVendorId_INIM_ELECTRONICSSRL_UNIPERSONALE:
		return "INIM_ELECTRONICSSRL_UNIPERSONALE"
	case BACnetVendorId_AIRTHINGSASA:
		return "AIRTHINGSASA"
	case BACnetVendorId_POWER_COLD_COMFORT_AIR_SOLUTIONS_INC:
		return "POWER_COLD_COMFORT_AIR_SOLUTIONS_INC"
	case BACnetVendorId_ANALOG_DEVICES_INC:
		return "ANALOG_DEVICES_INC"
	case BACnetVendorId_AI_DIRECTIONSDMCC:
		return "AI_DIRECTIONSDMCC"
	case BACnetVendorId_PRIMA_ELECTRO_SPA:
		return "PRIMA_ELECTRO_SPA"
	case BACnetVendorId_KLT_CONTROL_SYSTEM_LTD:
		return "KLT_CONTROL_SYSTEM_LTD"
	case BACnetVendorId_EVOLUTION_CONTROLS_INC:
		return "EVOLUTION_CONTROLS_INC"
	case BACnetVendorId_BEVER_INNOVATIONS:
		return "BEVER_INNOVATIONS"
	case BACnetVendorId_PELICAN_WIRELESS_SYSTEMS:
		return "PELICAN_WIRELESS_SYSTEMS"
	case BACnetVendorId_CONTROL_CONCEPTS_INC:
		return "CONTROL_CONCEPTS_INC"
	case BACnetVendorId_AUGMATIC_TECHNOLOGIES_PVT_LTD:
		return "AUGMATIC_TECHNOLOGIES_PVT_LTD"
	case BACnetVendorId_XIAMEN_MILESIGHTLOT_CO_LTD:
		return "XIAMEN_MILESIGHTLOT_CO_LTD"
	case BACnetVendorId_I_CONTROLS:
		return "I_CONTROLS"
	case BACnetVendorId_TIANJIN_ANJIELOT_SCHIENCEAND_TECHNOLOGY_CO_LTD:
		return "TIANJIN_ANJIELOT_SCHIENCEAND_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_GUANGZHOUS_ENERGY_ELECTRONICS_TECHNOLOGY_CO_LTD:
		return "GUANGZHOUS_ENERGY_ELECTRONICS_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_AKVO_ATMOSPHERIC_WATER_SYSTEMS_PVT_LTD:
		return "AKVO_ATMOSPHERIC_WATER_SYSTEMS_PVT_LTD"
	case BACnetVendorId_EM_FIRST_CO_LTD:
		return "EM_FIRST_CO_LTD"
	case BACnetVendorId_IION_SYSTEMS_APS:
		return "IION_SYSTEMS_APS"
	case BACnetVendorId_SAF_TEHNIKAJSC:
		return "SAF_TEHNIKAJSC"
	case BACnetVendorId_KOMFORTIQ_INC:
		return "KOMFORTIQ_INC"
	case BACnetVendorId_COOL_TERA_LIMITED:
		return "COOL_TERA_LIMITED"
	case BACnetVendorId_HADRON_SOLUTIONS_SRLS:
		return "HADRON_SOLUTIONS_SRLS"
	case BACnetVendorId_CIMETRICS_TECHNOLOGY:
		return "CIMETRICS_TECHNOLOGY"
	case BACnetVendorId_VICONICS_ELECTRONICS_INC:
		return "VICONICS_ELECTRONICS_INC"
	case BACnetVendorId_BITPOOL:
		return "BITPOOL"
	case BACnetVendorId_SONICULLC:
		return "SONICULLC"
	case BACnetVendorId_RISHABH_INSTRUMENTS_LIMITED:
		return "RISHABH_INSTRUMENTS_LIMITED"
	case BACnetVendorId_THING_WAREHOUSELLC:
		return "THING_WAREHOUSELLC"
	case BACnetVendorId_INNOFRIENDS_GMBH:
		return "INNOFRIENDS_GMBH"
	case BACnetVendorId_METRONICAKP_SPJ:
		return "METRONICAKP_SPJ"
	case BACnetVendorId_TECHKNAVE:
		return "TECHKNAVE"
	case BACnetVendorId_ELSNER_ELEKTRONIK:
		return "ELSNER_ELEKTRONIK"
	case BACnetVendorId_LEFOO_INDUSTRIAL_HANGZHOU_CO_LTD:
		return "LEFOO_INDUSTRIAL_HANGZHOU_CO_LTD"
	case BACnetVendorId_YASKAWA_AMERICA_INC:
		return "YASKAWA_AMERICA_INC"
	case BACnetVendorId_CALIBRATION_TECHNOLOGIES_INC:
		return "CALIBRATION_TECHNOLOGIES_INC"
	case BACnetVendorId_ALLORADO:
		return "ALLORADO"
	case BACnetVendorId_VERKADA:
		return "VERKADA"
	case BACnetVendorId_WATTSENSE:
		return "WATTSENSE"
	case BACnetVendorId_EMERSON_AUTOMATION_SOLUTIONS:
		return "EMERSON_AUTOMATION_SOLUTIONS"
	case BACnetVendorId_GROWLINK:
		return "GROWLINK"
	case BACnetVendorId_OLYMPIA_ELECTRONICS:
		return "OLYMPIA_ELECTRONICS"
	case BACnetVendorId_NORMAL_SOFTWARE_INC:
		return "NORMAL_SOFTWARE_INC"
	case BACnetVendorId_ST_ENGINEERING_SOLUTIONJSC:
		return "ST_ENGINEERING_SOLUTIONJSC"
	case BACnetVendorId_INDUSTRIAL_FLOW_SOLUTIONS:
		return "INDUSTRIAL_FLOW_SOLUTIONS"
	case BACnetVendorId_DEO_SCONTROLSYSTEMS_GMBH:
		return "DEO_SCONTROLSYSTEMS_GMBH"
	case BACnetVendorId_UBIQISENSE_APS:
		return "UBIQISENSE_APS"
	case BACnetVendorId_TIGER_SOFT:
		return "TIGER_SOFT"
	case BACnetVendorId_ECODOM_SRL:
		return "ECODOM_SRL"
	case BACnetVendorId_BILGIPRO_IOT_SYSTEMS:
		return "BILGIPRO_IOT_SYSTEMS"
	case BACnetVendorId_PLANSPURNETDESIGN_GMBH:
		return "PLANSPURNETDESIGN_GMBH"
	case BACnetVendorId_DOLPHIN_SOLUTIONS_LTD:
		return "DOLPHIN_SOLUTIONS_LTD"
	case BACnetVendorId_MITSUBISHI_ELECTRIC_CORPORATION_KOBE_WORKS:
		return "MITSUBISHI_ELECTRIC_CORPORATION_KOBE_WORKS"
	case BACnetVendorId_ECOVENA:
		return "ECOVENA"
	case BACnetVendorId_GREE_ELECTRIC_APPLIANCES_INCOF_ZHUHAI:
		return "GREE_ELECTRIC_APPLIANCES_INCOF_ZHUHAI"
	case BACnetVendorId_CONSPEC_CONTROLS:
		return "CONSPEC_CONTROLS"
	case BACnetVendorId_DIGITALE_MESSUND_STEUERSYSTEMEAG:
		return "DIGITALE_MESSUND_STEUERSYSTEMEAG"
	case BACnetVendorId_HANGZHOU_HIKVISION_DIGITAL_TECHNOLOGY_CO_LTD:
		return "HANGZHOU_HIKVISION_DIGITAL_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_CRYSTAL_PEAK_SECURITY:
		return "CRYSTAL_PEAK_SECURITY"
	case BACnetVendorId_PERM_ALERT:
		return "PERM_ALERT"
	case BACnetVendorId_ZHEJIANG_MISILIN_TECHNOLOGY_CO_LTD:
		return "ZHEJIANG_MISILIN_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_DEKKER_VACUUM_TECHNOLOGIES:
		return "DEKKER_VACUUM_TECHNOLOGIES"
	case BACnetVendorId_EDWARDS_LIMITED:
		return "EDWARDS_LIMITED"
	case BACnetVendorId_LEYBOLD_GMBH:
		return "LEYBOLD_GMBH"
	case BACnetVendorId_INTERNATIONAL_GAS_DETECTORS:
		return "INTERNATIONAL_GAS_DETECTORS"
	case BACnetVendorId_ATLAS_COPCO_AIRPOWERNV:
		return "ATLAS_COPCO_AIRPOWERNV"
	case BACnetVendorId_AIR_SENTRY_LIMITED:
		return "AIR_SENTRY_LIMITED"
	case BACnetVendorId_FUJITSU_GENERAL_LIMITED:
		return "FUJITSU_GENERAL_LIMITED"
	case BACnetVendorId_AELSYS:
		return "AELSYS"
	case BACnetVendorId_GRANBY_CONSULTINGLLC:
		return "GRANBY_CONSULTINGLLC"
	case BACnetVendorId_CLEVER_RELAY:
		return "CLEVER_RELAY"
	case BACnetVendorId_MONICO_MONITORING_INC:
		return "MONICO_MONITORING_INC"
	case BACnetVendorId_OQDO:
		return "OQDO"
	case BACnetVendorId_MATRIX_COMSEC_PRIVATE_LIMITED:
		return "MATRIX_COMSEC_PRIVATE_LIMITED"
	case BACnetVendorId_RESOURCE_SOLUTIONS:
		return "RESOURCE_SOLUTIONS"
	case BACnetVendorId_AMERICAN_GAS_SAFETYLLC:
		return "AMERICAN_GAS_SAFETYLLC"
	case BACnetVendorId_SS_NORTHERN_LTD:
		return "SS_NORTHERN_LTD"
	case BACnetVendorId_ULBIOS_TECHSENS:
		return "ULBIOS_TECHSENS"
	case BACnetVendorId_PROJECT_ENGINEERING_SRL:
		return "PROJECT_ENGINEERING_SRL"
	case BACnetVendorId_BOWERY_FARMING_INC:
		return "BOWERY_FARMING_INC"
	case BACnetVendorId_RYOBI_LIMITED:
		return "RYOBI_LIMITED"
	case BACnetVendorId_EKKO_SENSE_LTD:
		return "EKKO_SENSE_LTD"
	case BACnetVendorId_CLIMA_COOL:
		return "CLIMA_COOL"
	case BACnetVendorId_GRID_CONNECT_INC:
		return "GRID_CONNECT_INC"
	case BACnetVendorId_ZIEGLER_INSTRUMENTATIONUK_LTD:
		return "ZIEGLER_INSTRUMENTATIONUK_LTD"
	case BACnetVendorId_CONTROL_TECLLC:
		return "CONTROL_TECLLC"
	case BACnetVendorId_AETERLINK_CORPORATION:
		return "AETERLINK_CORPORATION"
	case BACnetVendorId_ALPHA_EPSILON_AUTOMATION:
		return "ALPHA_EPSILON_AUTOMATION"
	case BACnetVendorId_ASTRALITE_INC:
		return "ASTRALITE_INC"
	case BACnetVendorId_SANYO_ELECTRIC_CO_LTD:
		return "SANYO_ELECTRIC_CO_LTD"
	case BACnetVendorId_DELTA_FIRE_LTDA:
		return "DELTA_FIRE_LTDA"
	case BACnetVendorId_BOCK_WATER_HEATERS_INC:
		return "BOCK_WATER_HEATERS_INC"
	case BACnetVendorId_CLEAVER_BROOKS:
		return "CLEAVER_BROOKS"
	case BACnetVendorId_SCANALYTICS_INC:
		return "SCANALYTICS_INC"
	case BACnetVendorId_WILABS:
		return "WILABS"
	case BACnetVendorId_ACT_SYSTEM_CO_LTD:
		return "ACT_SYSTEM_CO_LTD"
	case BACnetVendorId_VERGE_SENSE:
		return "VERGE_SENSE"
	case BACnetVendorId_SYSTEMAIR_MFG_INC:
		return "SYSTEMAIR_MFG_INC"
	case BACnetVendorId_SEELEY_INTERNATIONAL:
		return "SEELEY_INTERNATIONAL"
	case BACnetVendorId_CRANE_BUILDING_SERVICES_UTILITIES:
		return "CRANE_BUILDING_SERVICES_UTILITIES"
	case BACnetVendorId_INTEGRATED_INFORMATION_SYSTEMS_INC:
		return "INTEGRATED_INFORMATION_SYSTEMS_INC"
	case BACnetVendorId_BRADY_CORPORATION:
		return "BRADY_CORPORATION"
	case BACnetVendorId_QINGDAO_HISENSE_HITACHI_AIR_CONDITIONING_SYSTEMS_CO_LTD:
		return "QINGDAO_HISENSE_HITACHI_AIR_CONDITIONING_SYSTEMS_CO_LTD"
	case BACnetVendorId_GOLDEN_QUALITY_CO_LTD:
		return "GOLDEN_QUALITY_CO_LTD"
	case BACnetVendorId_ELVACOAB:
		return "ELVACOAB"
	case BACnetVendorId_STRONG_TECHNOLOGYLLC:
		return "STRONG_TECHNOLOGYLLC"
	case BACnetVendorId_REC_ENVIRONMENTAL_TECHNOLOGY_GUANGZHOU_COMPANY_LIMITED:
		return "REC_ENVIRONMENTAL_TECHNOLOGY_GUANGZHOU_COMPANY_LIMITED"
	case BACnetVendorId_DISRUPTIVE_TECHNOLOGIES_RESEARCHAS:
		return "DISRUPTIVE_TECHNOLOGIES_RESEARCHAS"
	case BACnetVendorId_NICO_CONSULTANCY_LIMITED:
		return "NICO_CONSULTANCY_LIMITED"
	case BACnetVendorId_HORTENLOT_JIANGSU_CO_LTD:
		return "HORTENLOT_JIANGSU_CO_LTD"
	case BACnetVendorId_PAXTON_CONTROLS_CORP:
		return "PAXTON_CONTROLS_CORP"
	case BACnetVendorId_TEMCO_CONTROLS_LTD:
		return "TEMCO_CONTROLS_LTD"
	case BACnetVendorId_FELL_TECHNOLOGYAS:
		return "FELL_TECHNOLOGYAS"
	case BACnetVendorId_SHLOK_INFORMATION_SYSTEMS_INDIA_PRIVATE_LIMITED:
		return "SHLOK_INFORMATION_SYSTEMS_INDIA_PRIVATE_LIMITED"
	case BACnetVendorId_MICROGROPLC_LTD:
		return "MICROGROPLC_LTD"
	case BACnetVendorId_CLOUDER_OY:
		return "CLOUDER_OY"
	case BACnetVendorId_GEBUDE_AUTOMATISIERUNG_GMBH:
		return "GEBUDE_AUTOMATISIERUNG_GMBH"
	case BACnetVendorId_SOLVIMUS_GMBH:
		return "SOLVIMUS_GMBH"
	case BACnetVendorId_GUANG_ZHOU_WANGKONG_LTD:
		return "GUANG_ZHOU_WANGKONG_LTD"
	case BACnetVendorId_SAFE_SQUARE_GMBH:
		return "SAFE_SQUARE_GMBH"
	case BACnetVendorId_HEKLATECHAB:
		return "HEKLATECHAB"
	case BACnetVendorId_SILVAIR:
		return "SILVAIR"
	case BACnetVendorId_AIRTEK_INTERNATIONAL_INC:
		return "AIRTEK_INTERNATIONAL_INC"
	case BACnetVendorId_ADVECO:
		return "ADVECO"
	case BACnetVendorId_EURA_DRIVES_ELECTRIC_CO_LTD:
		return "EURA_DRIVES_ELECTRIC_CO_LTD"
	case BACnetVendorId_CALEB_CONTROLS:
		return "CALEB_CONTROLS"
	case BACnetVendorId_IN_BIOT_MONITORINGSL:
		return "IN_BIOT_MONITORINGSL"
	case BACnetVendorId_QINGDAO_HAIER_AIR_CONDITIONER_ELECTRIC_CO_LTD:
		return "QINGDAO_HAIER_AIR_CONDITIONER_ELECTRIC_CO_LTD"
	case BACnetVendorId_HANGZHOU_WEIYL_TECHNOLOGY_CO_LTD:
		return "HANGZHOU_WEIYL_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_YORDSRL:
		return "YORDSRL"
	case BACnetVendorId_INFINITUM_ELECTRIC:
		return "INFINITUM_ELECTRIC"
	case BACnetVendorId_RED_BEAN_SYSTEMS_LIMITED:
		return "RED_BEAN_SYSTEMS_LIMITED"
	case BACnetVendorId_BLUE_TIME_CONCEPTSA:
		return "BLUE_TIME_CONCEPTSA"
	case BACnetVendorId_CORNELL_UNIVERSITY:
		return "CORNELL_UNIVERSITY"
	case BACnetVendorId_ADVANTECH_CORPORATION:
		return "ADVANTECH_CORPORATION"
	case BACnetVendorId_SHENZHENINVT_ELECTRIC_CO_LTD:
		return "SHENZHENINVT_ELECTRIC_CO_LTD"
	case BACnetVendorId_MESSUNG_SYSTEMS_PVT_LTD:
		return "MESSUNG_SYSTEMS_PVT_LTD"
	case BACnetVendorId_ABB_ELECTRIFICATION_CANADA_INC:
		return "ABB_ELECTRIFICATION_CANADA_INC"
	case BACnetVendorId_CORE_CONTROLS:
		return "CORE_CONTROLS"
	case BACnetVendorId_NOORD_TECHDOO:
		return "NOORD_TECHDOO"
	case BACnetVendorId_VARIBITSAS:
		return "VARIBITSAS"
	case BACnetVendorId_ROGER_SPZOOSPK:
		return "ROGER_SPZOOSPK"
	case BACnetVendorId_VIEGA_GMBH_COKG:
		return "VIEGA_GMBH_COKG"
	case BACnetVendorId_ASTERSOFT:
		return "ASTERSOFT"
	case BACnetVendorId_BIGEU:
		return "BIGEU"
	case BACnetVendorId_TITAN_PRODUCTS_LTD:
		return "TITAN_PRODUCTS_LTD"
	case BACnetVendorId_INFERRIX_LIMITED:
		return "INFERRIX_LIMITED"
	case BACnetVendorId_RICHARDS_ELECTRIC_MOTOR_CO:
		return "RICHARDS_ELECTRIC_MOTOR_CO"
	case BACnetVendorId_DAPP_CONTROLS:
		return "DAPP_CONTROLS"
	case BACnetVendorId_ENTOUCH_CONTROLS:
		return "ENTOUCH_CONTROLS"
	case BACnetVendorId_MAVILI_ELEKTRONIK_TICARETVE_SANAYI_ANONIM_SIRKETI:
		return "MAVILI_ELEKTRONIK_TICARETVE_SANAYI_ANONIM_SIRKETI"
	case BACnetVendorId_BUBBLY_NET:
		return "BUBBLY_NET"
	case BACnetVendorId_AL_MAYSSAN_TECHNICAL_SERVICES_CO_LTD:
		return "AL_MAYSSAN_TECHNICAL_SERVICES_CO_LTD"
	case BACnetVendorId_VIRIDI_PARENTE_INC:
		return "VIRIDI_PARENTE_INC"
	case BACnetVendorId_NOVEL_APPS_CORP:
		return "NOVEL_APPS_CORP"
	case BACnetVendorId_OVENTROP_CHINAHVAC_SYSTEM_TECHNOLOGY_CO_LTD:
		return "OVENTROP_CHINAHVAC_SYSTEM_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_REGEL_PARTNERS:
		return "REGEL_PARTNERS"
	case BACnetVendorId_LACROIX_SOFREL:
		return "LACROIX_SOFREL"
	case BACnetVendorId_MACHINE_SENSLOT_TRADING_COLLC:
		return "MACHINE_SENSLOT_TRADING_COLLC"
	case BACnetVendorId_ELMEC_INC:
		return "ELMEC_INC"
	case BACnetVendorId_BEIJING_HAISHI_SOFTWARE_CO_LTD:
		return "BEIJING_HAISHI_SOFTWARE_CO_LTD"
	case BACnetVendorId_RADIX_ELECTROSYSTEMS_PVT_LTD:
		return "RADIX_ELECTROSYSTEMS_PVT_LTD"
	case BACnetVendorId_VRMEBARONENAB:
		return "VRMEBARONENAB"
	case BACnetVendorId_TREAU_INCDBA_GRADIENT:
		return "TREAU_INCDBA_GRADIENT"
	case BACnetVendorId_WEST_SOLUTIONAG:
		return "WEST_SOLUTIONAG"
	case BACnetVendorId_TRUEWAY_CONTROLS_HONGKONG_LIMITED:
		return "TRUEWAY_CONTROLS_HONGKONG_LIMITED"
	case BACnetVendorId_NATIONAL_ENVIRONMENTAL_PRODUCT:
		return "NATIONAL_ENVIRONMENTAL_PRODUCT"
	case BACnetVendorId_BUILDING_LOGIX:
		return "BUILDING_LOGIX"
	case BACnetVendorId_IFESCA_GMBH:
		return "IFESCA_GMBH"
	case BACnetVendorId_FELLOWES_INC:
		return "FELLOWES_INC"
	case BACnetVendorId_CALEFFI_SPA:
		return "CALEFFI_SPA"
	case BACnetVendorId_JDRF_ELECTROMAG:
		return "JDRF_ELECTROMAG"
	case BACnetVendorId_REDWIRE_LABS:
		return "REDWIRE_LABS"
	case BACnetVendorId_WECON_TECHNOLOGY_CO_LTD:
		return "WECON_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_ACACIA_GREEN_TECHNOLOGIES_LTD:
		return "ACACIA_GREEN_TECHNOLOGIES_LTD"
	case BACnetVendorId_DEGREE_ANALYTICS:
		return "DEGREE_ANALYTICS"
	case BACnetVendorId_ROLTEK_TEKNOLOJIAS:
		return "ROLTEK_TEKNOLOJIAS"
	case BACnetVendorId_UNITEC_CORPORATION:
		return "UNITEC_CORPORATION"
	case BACnetVendorId_DIGITAL_CONTROL_TECHNOLOGY_LIMITED:
		return "DIGITAL_CONTROL_TECHNOLOGY_LIMITED"
	case BACnetVendorId_KENTIMAAB:
		return "KENTIMAAB"
	case BACnetVendorId_PERGAMON_PERCEPTIVE_TECHNOLOGIES:
		return "PERGAMON_PERCEPTIVE_TECHNOLOGIES"
	case BACnetVendorId_PREFECT_CONTROLS_LTD:
		return "PREFECT_CONTROLS_LTD"
	case BACnetVendorId_SEN_TECH_CORPORATION:
		return "SEN_TECH_CORPORATION"
	case BACnetVendorId_SS_REGELTECHNIK_GMBH:
		return "SS_REGELTECHNIK_GMBH"
	case BACnetVendorId_AIR_BOX_INC:
		return "AIR_BOX_INC"
	case BACnetVendorId_RVE:
		return "RVE"
	case BACnetVendorId_MOTOROLA_SOLUTIONS:
		return "MOTOROLA_SOLUTIONS"
	case BACnetVendorId_BACSYS_INNOVATIONS_PRIVATE_LIMITED:
		return "BACSYS_INNOVATIONS_PRIVATE_LIMITED"
	case BACnetVendorId_KANDEN_ENGINEERING_COMPANY:
		return "KANDEN_ENGINEERING_COMPANY"
	case BACnetVendorId_EWATTCH:
		return "EWATTCH"
	case BACnetVendorId_BUILTLAYERLLC:
		return "BUILTLAYERLLC"
	case BACnetVendorId_AG_DOMOTIXSRL:
		return "AG_DOMOTIXSRL"
	case BACnetVendorId_HYTRONIK_INDUSTRIAL_LIMITED:
		return "HYTRONIK_INDUSTRIAL_LIMITED"
	case BACnetVendorId_WHO_REINRAUMTECHNIK:
		return "WHO_REINRAUMTECHNIK"
	case BACnetVendorId_TRICO_LIMITED:
		return "TRICO_LIMITED"
	case BACnetVendorId_SLK_AUTOMATIONSRL:
		return "SLK_AUTOMATIONSRL"
	case BACnetVendorId_ZAPHIREAS:
		return "ZAPHIREAS"
	case BACnetVendorId_AJ_MANUFACTURING:
		return "AJ_MANUFACTURING"
	case BACnetVendorId_FUTURE_MOTORS_LTD:
		return "FUTURE_MOTORS_LTD"
	case BACnetVendorId_MESSNER_GEBUDETECHNIK_GMBH:
		return "MESSNER_GEBUDETECHNIK_GMBH"
	case BACnetVendorId_HIMEL_HONG_KONG_LIMITED:
		return "HIMEL_HONG_KONG_LIMITED"
	case BACnetVendorId_SHENZHEN_SUNRICHER_TECHNOLOGY_CO_LTD:
		return "SHENZHEN_SUNRICHER_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_ACTILITYSA:
		return "ACTILITYSA"
	case BACnetVendorId_OY_HALTON_GROUP_LTD:
		return "OY_HALTON_GROUP_LTD"
	case BACnetVendorId_AVTECH_SOFTWARE_INC:
		return "AVTECH_SOFTWARE_INC"
	case BACnetVendorId_IN_CONTROL_ENGINEERINGLLC:
		return "IN_CONTROL_ENGINEERINGLLC"
	case BACnetVendorId_SOUND_WATER_TECHNOLOGIESLLC:
		return "SOUND_WATER_TECHNOLOGIESLLC"
	case BACnetVendorId_INTEGRATEDCH:
		return "INTEGRATEDCH"
	case BACnetVendorId_PRICE_INDUSTRIES:
		return "PRICE_INDUSTRIES"
	case BACnetVendorId_SE_ELEKTRONIC_GMBH:
		return "SE_ELEKTRONIC_GMBH"
	case BACnetVendorId_UNITED_TECHNOLOGIES_CARRIER:
		return "UNITED_TECHNOLOGIES_CARRIER"
	case BACnetVendorId_ROCKWELL_AUTOMATION:
		return "ROCKWELL_AUTOMATION"
	case BACnetVendorId_ENFLEX_CORP:
		return "ENFLEX_CORP"
	case BACnetVendorId_ASI_CONTROLS:
		return "ASI_CONTROLS"
	case BACnetVendorId_SYS_MIK_GMBH_DRESDEN:
		return "SYS_MIK_GMBH_DRESDEN"
	case BACnetVendorId_HSC_REGELUNGSTECHNIK_GMBH:
		return "HSC_REGELUNGSTECHNIK_GMBH"
	case BACnetVendorId_SMART_TEMP_AUSTRALIA_PTY_LTD:
		return "SMART_TEMP_AUSTRALIA_PTY_LTD"
	case BACnetVendorId_COOPER_CONTROLS:
		return "COOPER_CONTROLS"
	case BACnetVendorId_DUKSAN_MECASYS_CO_LTD:
		return "DUKSAN_MECASYS_CO_LTD"
	case BACnetVendorId_FUJIIT_CO_LTD:
		return "FUJIIT_CO_LTD"
	case BACnetVendorId_VACON_PLC:
		return "VACON_PLC"
	case BACnetVendorId_HONEYWELL_INC:
		return "HONEYWELL_INC"
	case BACnetVendorId_LEADER_CONTROLS:
		return "LEADER_CONTROLS"
	case BACnetVendorId_ABB_FORMERLY_CYLON_CONTROLS_LTD:
		return "ABB_FORMERLY_CYLON_CONTROLS_LTD"
	case BACnetVendorId_COMPAS:
		return "COMPAS"
	case BACnetVendorId_MITSUBISHI_ELECTRIC_BUILDING_TECHNO_SERVICE_CO_LTD:
		return "MITSUBISHI_ELECTRIC_BUILDING_TECHNO_SERVICE_CO_LTD"
	case BACnetVendorId_BUILDING_CONTROL_INTEGRATORS:
		return "BUILDING_CONTROL_INTEGRATORS"
	case BACnetVendorId_ITG_WORLDWIDEM_SDN_BHD:
		return "ITG_WORLDWIDEM_SDN_BHD"
	case BACnetVendorId_LUTRON_ELECTRONICS_CO_INC:
		return "LUTRON_ELECTRONICS_CO_INC"
	case BACnetVendorId_COOPER_ATKINS_CORPORATION:
		return "COOPER_ATKINS_CORPORATION"
	case BACnetVendorId_LOYTEC_ELECTRONICS_GMBH:
		return "LOYTEC_ELECTRONICS_GMBH"
	case BACnetVendorId_PRO_LON:
		return "PRO_LON"
	case BACnetVendorId_ALERTON_HONEYWELL:
		return "ALERTON_HONEYWELL"
	case BACnetVendorId_MEGA_CONTROLS_LIMITED:
		return "MEGA_CONTROLS_LIMITED"
	case BACnetVendorId_MICRO_CONTROL_SYSTEMS_INC:
		return "MICRO_CONTROL_SYSTEMS_INC"
	case BACnetVendorId_KIYON_INC:
		return "KIYON_INC"
	case BACnetVendorId_DUST_NETWORKS:
		return "DUST_NETWORKS"
	case BACnetVendorId_ADVANCED_BUILDING_AUTOMATION_SYSTEMS:
		return "ADVANCED_BUILDING_AUTOMATION_SYSTEMS"
	case BACnetVendorId_HERMOSAG:
		return "HERMOSAG"
	case BACnetVendorId_CEZIM:
		return "CEZIM"
	case BACnetVendorId_SOFTING:
		return "SOFTING"
	case BACnetVendorId_LYNXSPRING_INC:
		return "LYNXSPRING_INC"
	case BACnetVendorId_SCHNEIDER_TOSHIBA_INVERTER_EUROPE:
		return "SCHNEIDER_TOSHIBA_INVERTER_EUROPE"
	case BACnetVendorId_TACAB:
		return "TACAB"
	case BACnetVendorId_DANFOSS_DRIVESAS:
		return "DANFOSS_DRIVESAS"
	case BACnetVendorId_EATON_CORPORATION:
		return "EATON_CORPORATION"
	case BACnetVendorId_MATYCASA:
		return "MATYCASA"
	case BACnetVendorId_BOTECHAB:
		return "BOTECHAB"
	case BACnetVendorId_NOVEO_INC:
		return "NOVEO_INC"
	case BACnetVendorId_AMEV:
		return "AMEV"
	case BACnetVendorId_YOKOGAWA_ELECTRIC_CORPORATION:
		return "YOKOGAWA_ELECTRIC_CORPORATION"
	case BACnetVendorId_BOSCH_BUILDING_AUTOMATION_GMBH:
		return "BOSCH_BUILDING_AUTOMATION_GMBH"
	case BACnetVendorId_EXACT_LOGIC:
		return "EXACT_LOGIC"
	case BACnetVendorId_MASS_ELECTRONICS_PTY_LTDDBA_INNOTECH_CONTROL_SYSTEMS_AUSTRALIA:
		return "MASS_ELECTRONICS_PTY_LTDDBA_INNOTECH_CONTROL_SYSTEMS_AUSTRALIA"
	case BACnetVendorId_THE_TRANE_COMPANY:
		return "THE_TRANE_COMPANY"
	case BACnetVendorId_HEWLETT_PACKARD_COMPANY:
		return "HEWLETT_PACKARD_COMPANY"
	case BACnetVendorId_KANDENKO_CO_LTD:
		return "KANDENKO_CO_LTD"
	case BACnetVendorId_DTF_DATEN_TECHNIK_FRIES:
		return "DTF_DATEN_TECHNIK_FRIES"
	case BACnetVendorId_KLIMASOFT_LTD:
		return "KLIMASOFT_LTD"
	case BACnetVendorId_TOSHIBA_SCHNEIDER_INVERTER_CORPORATION:
		return "TOSHIBA_SCHNEIDER_INVERTER_CORPORATION"
	case BACnetVendorId_CONTROL_APPLICATIONS_LTD:
		return "CONTROL_APPLICATIONS_LTD"
	case BACnetVendorId_CIMONCO_LTD:
		return "CIMONCO_LTD"
	case BACnetVendorId_ONICON_INCORPORATED:
		return "ONICON_INCORPORATED"
	case BACnetVendorId_AUTOMATION_DISPLAYS_INC:
		return "AUTOMATION_DISPLAYS_INC"
	case BACnetVendorId_CONTROL_SOLUTIONS_INC:
		return "CONTROL_SOLUTIONS_INC"
	case BACnetVendorId_REMSDAQ_LIMITED:
		return "REMSDAQ_LIMITED"
	case BACnetVendorId_DORSETTES_INC:
		return "DORSETTES_INC"
	case BACnetVendorId_NTT_FACILITIES_INC:
		return "NTT_FACILITIES_INC"
	case BACnetVendorId_VIPA_GMBH:
		return "VIPA_GMBH"
	case BACnetVendorId_TSC1_ASSOCIATIONOF_JAPAN:
		return "TSC1_ASSOCIATIONOF_JAPAN"
	case BACnetVendorId_STRATO_AUTOMATION:
		return "STRATO_AUTOMATION"
	case BACnetVendorId_HRW_LIMITED:
		return "HRW_LIMITED"
	case BACnetVendorId_LIGHTING_CONTROL_DESIGN_INC:
		return "LIGHTING_CONTROL_DESIGN_INC"
	case BACnetVendorId_MERCY_ELECTRONICAND_ELECTRICAL_INDUSTRIES:
		return "MERCY_ELECTRONICAND_ELECTRICAL_INDUSTRIES"
	case BACnetVendorId_SAMSUNGSDS_CO_LTD:
		return "SAMSUNGSDS_CO_LTD"
	case BACnetVendorId_IMPACT_FACILITY_SOLUTIONS_INC:
		return "IMPACT_FACILITY_SOLUTIONS_INC"
	case BACnetVendorId_AIRCUITY:
		return "AIRCUITY"
	case BACnetVendorId_SIEMENS_SCHWEIZAG2:
		return "SIEMENS_SCHWEIZAG2"
	case BACnetVendorId_CONTROL_TECHNIQUES_LTD:
		return "CONTROL_TECHNIQUES_LTD"
	case BACnetVendorId_OPEN_GENERAL_PTY_LTD:
		return "OPEN_GENERAL_PTY_LTD"
	case BACnetVendorId_WAGO_KONTAKTTECHNIK_GMBH_COKG:
		return "WAGO_KONTAKTTECHNIK_GMBH_COKG"
	case BACnetVendorId_FRANKLIN_ELECTRIC:
		return "FRANKLIN_ELECTRIC"
	case BACnetVendorId_CHLORIDE_POWER_PROTECTION_COMPANY:
		return "CHLORIDE_POWER_PROTECTION_COMPANY"
	case BACnetVendorId_COMPUTROLS_INC:
		return "COMPUTROLS_INC"
	case BACnetVendorId_PHOENIX_CONTACT_GMBH_COKG:
		return "PHOENIX_CONTACT_GMBH_COKG"
	case BACnetVendorId_GRUNDFOS_MANAGEMENTAS:
		return "GRUNDFOS_MANAGEMENTAS"
	case BACnetVendorId_RIDDER_DRIVE_SYSTEMS:
		return "RIDDER_DRIVE_SYSTEMS"
	case BACnetVendorId_SOFT_DEVICESDNBHD:
		return "SOFT_DEVICESDNBHD"
	case BACnetVendorId_YORK_CONTROLS_GROUP:
		return "YORK_CONTROLS_GROUP"
	case BACnetVendorId_INTEGRATED_CONTROL_TECHNOLOGY_LIMITED:
		return "INTEGRATED_CONTROL_TECHNOLOGY_LIMITED"
	case BACnetVendorId_AI_RXPERT_SYSTEMS_INC:
		return "AI_RXPERT_SYSTEMS_INC"
	case BACnetVendorId_MICROTROL_LIMITED:
		return "MICROTROL_LIMITED"
	case BACnetVendorId_RED_LION_CONTROLS:
		return "RED_LION_CONTROLS"
	case BACnetVendorId_DIGITAL_ELECTRONICS_CORPORATION:
		return "DIGITAL_ELECTRONICS_CORPORATION"
	case BACnetVendorId_ENNOVATIS_GMBH:
		return "ENNOVATIS_GMBH"
	case BACnetVendorId_SEROTONIN_SOFTWARE_TECHNOLOGIES_INC:
		return "SEROTONIN_SOFTWARE_TECHNOLOGIES_INC"
	case BACnetVendorId_LS_INDUSTRIAL_SYSTEMS_CO_LTD:
		return "LS_INDUSTRIAL_SYSTEMS_CO_LTD"
	case BACnetVendorId_SQUARED_COMPANY:
		return "SQUARED_COMPANY"
	case BACnetVendorId_S_SQUARED_INNOVATIONS_INC:
		return "S_SQUARED_INNOVATIONS_INC"
	case BACnetVendorId_AUTOMATED_LOGIC_CORPORATION:
		return "AUTOMATED_LOGIC_CORPORATION"
	case BACnetVendorId_ARICENT_LTD:
		return "ARICENT_LTD"
	case BACnetVendorId_ETHER_METRICSLLC:
		return "ETHER_METRICSLLC"
	case BACnetVendorId_INDUSTRIAL_CONTROL_COMMUNICATIONS_INC:
		return "INDUSTRIAL_CONTROL_COMMUNICATIONS_INC"
	case BACnetVendorId_PARAGON_CONTROLS_INC:
		return "PARAGON_CONTROLS_INC"
	case BACnetVendorId_AO_SMITH_CORPORATION:
		return "AO_SMITH_CORPORATION"
	case BACnetVendorId_CONTEMPORARY_CONTROL_SYSTEMS_INC:
		return "CONTEMPORARY_CONTROL_SYSTEMS_INC"
	case BACnetVendorId_HMS_INDUSTRIAL_NETWORKSSLU:
		return "HMS_INDUSTRIAL_NETWORKSSLU"
	case BACnetVendorId_INGENIEURGESELLSCHAFTN_HARTLEBMBH:
		return "INGENIEURGESELLSCHAFTN_HARTLEBMBH"
	case BACnetVendorId_HEAT_TIMER_CORPORATION:
		return "HEAT_TIMER_CORPORATION"
	case BACnetVendorId_INGRASYS_TECHNOLOGY_INC:
		return "INGRASYS_TECHNOLOGY_INC"
	case BACnetVendorId_CSI_CONTROL_SYSTEMS_INTERNATIONAL:
		return "CSI_CONTROL_SYSTEMS_INTERNATIONAL"
	case BACnetVendorId_COSTERM_BUILDING_AUTOMATION:
		return "COSTERM_BUILDING_AUTOMATION"
	case BACnetVendorId_WILOSE:
		return "WILOSE"
	case BACnetVendorId_EMBEDIA_TECHNOLOGIES_CORP:
		return "EMBEDIA_TECHNOLOGIES_CORP"
	case BACnetVendorId_TECHNILOG:
		return "TECHNILOG"
	case BACnetVendorId_HR_CONTROLS_LTD_COKG:
		return "HR_CONTROLS_LTD_COKG"
	case BACnetVendorId_LENNOX_INTERNATIONAL_INC:
		return "LENNOX_INTERNATIONAL_INC"
	case BACnetVendorId_RK_TEC_RAUCHKLAPPEN_STEUERUNGSSYSTEME_GMBH_COKG:
		return "RK_TEC_RAUCHKLAPPEN_STEUERUNGSSYSTEME_GMBH_COKG"
	case BACnetVendorId_THERMOMAX_LTD:
		return "THERMOMAX_LTD"
	case BACnetVendorId_ELCON_ELECTRONIC_CONTROL_LTD:
		return "ELCON_ELECTRONIC_CONTROL_LTD"
	case BACnetVendorId_LARMIA_CONTROLAB:
		return "LARMIA_CONTROLAB"
	case BACnetVendorId_PHOENIX_CONTROLS_CORPORATION:
		return "PHOENIX_CONTROLS_CORPORATION"
	case BACnetVendorId_BA_CNET_STACKAT_SOURCE_FORGE:
		return "BA_CNET_STACKAT_SOURCE_FORGE"
	case BACnetVendorId_GS_SECURITY_SERVICESAS:
		return "GS_SECURITY_SERVICESAS"
	case BACnetVendorId_EXOR_INTERNATIONAL_SPA:
		return "EXOR_INTERNATIONAL_SPA"
	case BACnetVendorId_CRISTAL_CONTROLES:
		return "CRISTAL_CONTROLES"
	case BACnetVendorId_REGINAB:
		return "REGINAB"
	case BACnetVendorId_DIMENSION_SOFTWARE_INC:
		return "DIMENSION_SOFTWARE_INC"
	case BACnetVendorId_SYNAP_SENSE_CORPORATION:
		return "SYNAP_SENSE_CORPORATION"
	case BACnetVendorId_BEIJING_NANTREE_ELECTRONIC_CO_LTD:
		return "BEIJING_NANTREE_ELECTRONIC_CO_LTD"
	case BACnetVendorId_CAMUS_HYDRONICS_LTD:
		return "CAMUS_HYDRONICS_LTD"
	case BACnetVendorId_KAWASAKI_HEAVY_INDUSTRIES_LTD:
		return "KAWASAKI_HEAVY_INDUSTRIES_LTD"
	case BACnetVendorId_INNOVEX_TECHNOLOGIES_INC:
		return "INNOVEX_TECHNOLOGIES_INC"
	case BACnetVendorId_CRITICAL_ENVIRONMENT_TECHNOLOGIES:
		return "CRITICAL_ENVIRONMENT_TECHNOLOGIES"
	case BACnetVendorId_ILSHINIBS_CO_LTD:
		return "ILSHINIBS_CO_LTD"
	case BACnetVendorId_ELESTA_ENERGY_CONTROLAG:
		return "ELESTA_ENERGY_CONTROLAG"
	case BACnetVendorId_KROPMAN_INSTALLATIETECHNIEK:
		return "KROPMAN_INSTALLATIETECHNIEK"
	case BACnetVendorId_BALDOR_ELECTRIC_COMPANY:
		return "BALDOR_ELECTRIC_COMPANY"
	case BACnetVendorId_ING_AMBH:
		return "ING_AMBH"
	case BACnetVendorId_GE_CONSUMER_INDUSTRIAL:
		return "GE_CONSUMER_INDUSTRIAL"
	case BACnetVendorId_FUNCTIONAL_DEVICES_INC:
		return "FUNCTIONAL_DEVICES_INC"
	case BACnetVendorId_STUDIOSC:
		return "STUDIOSC"
	case BACnetVendorId_MGCOLTD:
		return "MGCOLTD"
	case BACnetVendorId_KMC_CONTROLS_INC:
		return "KMC_CONTROLS_INC"
	case BACnetVendorId_YOKOTA_CO_LTD:
		return "YOKOTA_CO_LTD"
	case BACnetVendorId_HITRANSE_TECHNOLOGY_COLTD:
		return "HITRANSE_TECHNOLOGY_COLTD"
	case BACnetVendorId_VIGILENT_CORPORATION:
		return "VIGILENT_CORPORATION"
	case BACnetVendorId_KELE_INC:
		return "KELE_INC"
	case BACnetVendorId_BELIMO_AUTOMATIONAG:
		return "BELIMO_AUTOMATIONAG"
	case BACnetVendorId_GENTEC:
		return "GENTEC"
	case BACnetVendorId_EMBEDDED_SCIENCE_LABSLLC:
		return "EMBEDDED_SCIENCE_LABSLLC"
	case BACnetVendorId_PARKER_HANNIFIN_CORPORATION:
		return "PARKER_HANNIFIN_CORPORATION"
	case BACnetVendorId_MA_CAPS_INTERNATIONAL_LIMITED:
		return "MA_CAPS_INTERNATIONAL_LIMITED"
	case BACnetVendorId_LINK_CORPORATION:
		return "LINK_CORPORATION"
	case BACnetVendorId_XN_TECHNOLOGIES_INC:
		return "XN_TECHNOLOGIES_INC"
	case BACnetVendorId_ROMUTEC_STEUERU_REGELSYSTEME_GMBH:
		return "ROMUTEC_STEUERU_REGELSYSTEME_GMBH"
	case BACnetVendorId_PRIBUSIN_INC:
		return "PRIBUSIN_INC"
	case BACnetVendorId_ADVANTAGE_CONTROLS:
		return "ADVANTAGE_CONTROLS"
	case BACnetVendorId_CRITICAL_ROOM_CONTROL:
		return "CRITICAL_ROOM_CONTROL"
	case BACnetVendorId_LEGRAND:
		return "LEGRAND"
	case BACnetVendorId_TONGDY_CONTROL_TECHNOLOGY_CO_LTD:
		return "TONGDY_CONTROL_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_ISSARO_INTEGRIERTE_SYSTEMTECHNIK:
		return "ISSARO_INTEGRIERTE_SYSTEMTECHNIK"
	case BACnetVendorId_PRO_DEV_INDUSTRIES:
		return "PRO_DEV_INDUSTRIES"
	case BACnetVendorId_DRISTEEM:
		return "DRISTEEM"
	case BACnetVendorId_CREATIVE_ELECTRONIC_GMBH:
		return "CREATIVE_ELECTRONIC_GMBH"
	case BACnetVendorId_DAIKIN_APPLIED_AMERICAS:
		return "DAIKIN_APPLIED_AMERICAS"
	case BACnetVendorId_HYUNDAI_INFORMATION_TECHNOLOGY_CO_LTD:
		return "HYUNDAI_INFORMATION_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_SWEGONAB:
		return "SWEGONAB"
	case BACnetVendorId_FIRVEN_ASRO:
		return "FIRVEN_ASRO"
	case BACnetVendorId_HITACHI_APPLIANCES_INC:
		return "HITACHI_APPLIANCES_INC"
	case BACnetVendorId_REAL_TIME_AUTOMATION_INC:
		return "REAL_TIME_AUTOMATION_INC"
	case BACnetVendorId_ITEC_HANKYU_HANSHIN_CO:
		return "ITEC_HANKYU_HANSHIN_CO"
	case BACnetVendorId_CYRUSEM_ENGINEERING_CO_LTD:
		return "CYRUSEM_ENGINEERING_CO_LTD"
	case BACnetVendorId_BADGER_METER:
		return "BADGER_METER"
	case BACnetVendorId_CIRRASCALE_CORPORATION:
		return "CIRRASCALE_CORPORATION"
	case BACnetVendorId_ELESTA_GMBH_BUILDING_AUTOMATION:
		return "ELESTA_GMBH_BUILDING_AUTOMATION"
	case BACnetVendorId_SECURITON:
		return "SECURITON"
	case BACnetVendorId_TOKIMEC_INC:
		return "TOKIMEC_INC"
	case BACnetVendorId_O_SLSOFT_INC:
		return "O_SLSOFT_INC"
	case BACnetVendorId_HANAZEDER_ELECTRONIC_GMBH:
		return "HANAZEDER_ELECTRONIC_GMBH"
	case BACnetVendorId_HONEYWELL_SECURITY_DEUTSCHLAND_NOVAR_GMBH:
		return "HONEYWELL_SECURITY_DEUTSCHLAND_NOVAR_GMBH"
	case BACnetVendorId_SIEMENS_INDUSTRY_INC:
		return "SIEMENS_INDUSTRY_INC"
	case BACnetVendorId_ETM_PROFESSIONAL_CONTROL_GMBH:
		return "ETM_PROFESSIONAL_CONTROL_GMBH"
	case BACnetVendorId_MEITAVTEC_LTD:
		return "MEITAVTEC_LTD"
	case BACnetVendorId_JANITZA_ELECTRONICS_GMBH:
		return "JANITZA_ELECTRONICS_GMBH"
	case BACnetVendorId_MKS_NORDHAUSEN:
		return "MKS_NORDHAUSEN"
	case BACnetVendorId_DE_GIER_DRIVE_SYSTEMSBV:
		return "DE_GIER_DRIVE_SYSTEMSBV"
	case BACnetVendorId_CYPRESS_ENVIROSYSTEMS:
		return "CYPRESS_ENVIROSYSTEMS"
	case BACnetVendorId_SIMPLEX:
		return "SIMPLEX"
	case BACnetVendorId_SMAR_TRONSRO:
		return "SMAR_TRONSRO"
	case BACnetVendorId_VERARI_SYSTEMS_INC:
		return "VERARI_SYSTEMS_INC"
	case BACnetVendorId_KW_ELECTRONIC_SERVICE_INC:
		return "KW_ELECTRONIC_SERVICE_INC"
	case BACnetVendorId_ALFASMART_ENERGY_MANAGEMENT:
		return "ALFASMART_ENERGY_MANAGEMENT"
	case BACnetVendorId_TELKONET_INC:
		return "TELKONET_INC"
	case BACnetVendorId_SECURITON_GMBH:
		return "SECURITON_GMBH"
	case BACnetVendorId_CEMTREX_INC:
		return "CEMTREX_INC"
	case BACnetVendorId_PERFORMANCE_TECHNOLOGIES_INC:
		return "PERFORMANCE_TECHNOLOGIES_INC"
	case BACnetVendorId_XTRALIS_AUST_PTY_LTD:
		return "XTRALIS_AUST_PTY_LTD"
	case BACnetVendorId_TROX_GMBH:
		return "TROX_GMBH"
	case BACnetVendorId_NORTH_BUILDING_TECHNOLOGIES_LIMITED:
		return "NORTH_BUILDING_TECHNOLOGIES_LIMITED"
	case BACnetVendorId_BEIJING_HYSINE_TECHNOLOGY_CO_LTD:
		return "BEIJING_HYSINE_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_RCK_CONTROLS_INC:
		return "RCK_CONTROLS_INC"
	case BACnetVendorId_DISTECH_CONTROLSSAS:
		return "DISTECH_CONTROLSSAS"
	case BACnetVendorId_NOVAR_HONEYWELL:
		return "NOVAR_HONEYWELL"
	case BACnetVendorId_S_INTEGRATION_SOLUTIONS:
		return "S_INTEGRATION_SOLUTIONS"
	case BACnetVendorId_SCHNEIDER_ELECTRIC1:
		return "SCHNEIDER_ELECTRIC1"
	case BACnetVendorId_LHA_SYSTEMS:
		return "LHA_SYSTEMS"
	case BACnetVendorId_GH_MENGINEERING_GROUP_INC:
		return "GH_MENGINEERING_GROUP_INC"
	case BACnetVendorId_CLLIMALUXSA:
		return "CLLIMALUXSA"
	case BACnetVendorId_VAISALA_OYJ:
		return "VAISALA_OYJ"
	case BACnetVendorId_NOTIFIER:
		return "NOTIFIER"
	case BACnetVendorId_COMPLEX_BEIJING_TECHNOLOGY_COLTD:
		return "COMPLEX_BEIJING_TECHNOLOGY_COLTD"
	case BACnetVendorId_SCAD_AMETRICS:
		return "SCAD_AMETRICS"
	case BACnetVendorId_POWERPEGNSI_LIMITED:
		return "POWERPEGNSI_LIMITED"
	case BACnetVendorId_BA_CNET_INTEROPERABILITY_TESTING_SERVICES_INC:
		return "BA_CNET_INTEROPERABILITY_TESTING_SERVICES_INC"
	case BACnetVendorId_TECOAS:
		return "TECOAS"
	case BACnetVendorId_PLEXUS_TECHNOLOGY_INC:
		return "PLEXUS_TECHNOLOGY_INC"
	case BACnetVendorId_ENERGY_FOCUS_INC:
		return "ENERGY_FOCUS_INC"
	case BACnetVendorId_POWERSMITHS_INTERNATIONAL_CORP:
		return "POWERSMITHS_INTERNATIONAL_CORP"
	case BACnetVendorId_NICHIBEI_CO_LTD:
		return "NICHIBEI_CO_LTD"
	case BACnetVendorId_HKC_TECHNOLOGY_LTD:
		return "HKC_TECHNOLOGY_LTD"
	case BACnetVendorId_RELIABLE_CONTROLS_CORPORATION:
		return "RELIABLE_CONTROLS_CORPORATION"
	case BACnetVendorId_OVATION_NETWORKS_INC:
		return "OVATION_NETWORKS_INC"
	case BACnetVendorId_SETRA_SYSTEMS:
		return "SETRA_SYSTEMS"
	case BACnetVendorId_AVG_AUTOMATION:
		return "AVG_AUTOMATION"
	case BACnetVendorId_ZXC_LTD:
		return "ZXC_LTD"
	case BACnetVendorId_BYTE_SPHERE:
		return "BYTE_SPHERE"
	case BACnetVendorId_GENERITON_CO_LTD:
		return "GENERITON_CO_LTD"
	case BACnetVendorId_HOLTER_REGELARMATUREN_GMBH_COKG:
		return "HOLTER_REGELARMATUREN_GMBH_COKG"
	case BACnetVendorId_BEDFORD_INSTRUMENTSLLC:
		return "BEDFORD_INSTRUMENTSLLC"
	case BACnetVendorId_STANDAIR_INC:
		return "STANDAIR_INC"
	case BACnetVendorId_WEG_AUTOMATIONRD:
		return "WEG_AUTOMATIONRD"
	case BACnetVendorId_TRIDIUM_INC:
		return "TRIDIUM_INC"
	case BACnetVendorId_PROLON_CONTROL_SYSTEMS_APS:
		return "PROLON_CONTROL_SYSTEMS_APS"
	case BACnetVendorId_INNEASOFT:
		return "INNEASOFT"
	case BACnetVendorId_CONNEX_SOFT_GMBH:
		return "CONNEX_SOFT_GMBH"
	case BACnetVendorId_CEAG_NOTLICHTSYSTEME_GMBH:
		return "CEAG_NOTLICHTSYSTEME_GMBH"
	case BACnetVendorId_DISTECH_CONTROLS_INC:
		return "DISTECH_CONTROLS_INC"
	case BACnetVendorId_INDUSTRIAL_TECHNOLOGY_RESEARCH_INSTITUTE:
		return "INDUSTRIAL_TECHNOLOGY_RESEARCH_INSTITUTE"
	case BACnetVendorId_MITSUBISHI_ELECTRIC_ICONICS_DIGITAL_SOLUTIONS:
		return "MITSUBISHI_ELECTRIC_ICONICS_DIGITAL_SOLUTIONS"
	case BACnetVendorId_IQ_CONTROLSSC:
		return "IQ_CONTROLSSC"
	case BACnetVendorId_OJ_ELECTRONICSAS:
		return "OJ_ELECTRONICSAS"
	case BACnetVendorId_ROLBIT_LTD:
		return "ROLBIT_LTD"
	case BACnetVendorId_MSA_SAFETY:
		return "MSA_SAFETY"
	case BACnetVendorId_SYNAPSYS_SOLUTIONS_LTD:
		return "SYNAPSYS_SOLUTIONS_LTD"
	case BACnetVendorId_ACME_ENGINEERING_PROD_LTD:
		return "ACME_ENGINEERING_PROD_LTD"
	case BACnetVendorId_ZENER_ELECTRIC_PTY_LTD:
		return "ZENER_ELECTRIC_PTY_LTD"
	case BACnetVendorId_SELECTRONIX_INC:
		return "SELECTRONIX_INC"
	case BACnetVendorId_GORBET_BANERJEELLC:
		return "GORBET_BANERJEELLC"
	case BACnetVendorId_IME:
		return "IME"
	case BACnetVendorId_STEPHENH_DAWSON_COMPUTER_SERVICE:
		return "STEPHENH_DAWSON_COMPUTER_SERVICE"
	case BACnetVendorId_ACCUTROLLLC:
		return "ACCUTROLLLC"
	case BACnetVendorId_SCHNEIDER_ELEKTRONIK_GMBH:
		return "SCHNEIDER_ELEKTRONIK_GMBH"
	case BACnetVendorId_ALPHA_INNO_TEC_GMBH:
		return "ALPHA_INNO_TEC_GMBH"
	case BACnetVendorId_SILICON_ENERGY:
		return "SILICON_ENERGY"
	case BACnetVendorId_ADM_MICRO_INC:
		return "ADM_MICRO_INC"
	case BACnetVendorId_GREYSTONE_ENERGY_SYSTEMS_INC:
		return "GREYSTONE_ENERGY_SYSTEMS_INC"
	case BACnetVendorId_CAP_TECHNOLOGIE:
		return "CAP_TECHNOLOGIE"
	case BACnetVendorId_KE_RO_SYSTEMS:
		return "KE_RO_SYSTEMS"
	case BACnetVendorId_DOMAT_CONTROL_SYSTEMSRO:
		return "DOMAT_CONTROL_SYSTEMSRO"
	case BACnetVendorId_EFEKTRONICS_PTY_LTD:
		return "EFEKTRONICS_PTY_LTD"
	case BACnetVendorId_HEKATRON_VERTRIEBS_GMBH:
		return "HEKATRON_VERTRIEBS_GMBH"
	case BACnetVendorId_SECURITONAG:
		return "SECURITONAG"
	case BACnetVendorId_CARLO_GAVAZZI_CONTROLS_SPA:
		return "CARLO_GAVAZZI_CONTROLS_SPA"
	case BACnetVendorId_CHIPKIN_AUTOMATION_SYSTEMS:
		return "CHIPKIN_AUTOMATION_SYSTEMS"
	case BACnetVendorId_KIEBACK_PETER_GMBH_COKG:
		return "KIEBACK_PETER_GMBH_COKG"
	case BACnetVendorId_SAVANT_SYSTEMSLLC:
		return "SAVANT_SYSTEMSLLC"
	case BACnetVendorId_SIMMTRONIC_LIGHTING_CONTROLS:
		return "SIMMTRONIC_LIGHTING_CONTROLS"
	case BACnetVendorId_ABELKO_INNOVATIONAB:
		return "ABELKO_INNOVATIONAB"
	case BACnetVendorId_SERESCO_TECHNOLOGIES_INC:
		return "SERESCO_TECHNOLOGIES_INC"
	case BACnetVendorId_IT_WATCHDOGS:
		return "IT_WATCHDOGS"
	case BACnetVendorId_AUTOMATION_ASSIST_JAPAN_CORP:
		return "AUTOMATION_ASSIST_JAPAN_CORP"
	case BACnetVendorId_THERMOKON_SENSORTECHNIK_GMBH:
		return "THERMOKON_SENSORTECHNIK_GMBH"
	case BACnetVendorId_E_GAUGE_SYSTEMSLLC:
		return "E_GAUGE_SYSTEMSLLC"
	case BACnetVendorId_QUANTUM_AUTOMATIONASIAPTE_LTD:
		return "QUANTUM_AUTOMATIONASIAPTE_LTD"
	case BACnetVendorId_TOSHIBA_LIGHTING_TECHNOLOGY_CORP:
		return "TOSHIBA_LIGHTING_TECHNOLOGY_CORP"
	case BACnetVendorId_POLAR_SOFT:
		return "POLAR_SOFT"
	case BACnetVendorId_ANACON_SYSTEMS_INC:
		return "ANACON_SYSTEMS_INC"
	case BACnetVendorId_SPIN_ENGENHARIADE_AUTOMAO_LTDA:
		return "SPIN_ENGENHARIADE_AUTOMAO_LTDA"
	case BACnetVendorId_LOGISTICS_SYSTEMS_SOFTWARE_SERVICES_INDIAPVT_LTD:
		return "LOGISTICS_SYSTEMS_SOFTWARE_SERVICES_INDIAPVT_LTD"
	case BACnetVendorId_DELTA_CONTROLS_INTEGRATION_PRODUCTS:
		return "DELTA_CONTROLS_INTEGRATION_PRODUCTS"
	case BACnetVendorId_FOCUS_MEDIA:
		return "FOCUS_MEDIA"
	case BACnetVendorId_LUM_ENERGI_INC:
		return "LUM_ENERGI_INC"
	case BACnetVendorId_KARA_SYSTEMS:
		return "KARA_SYSTEMS"
	case BACnetVendorId_RF_CODE_INC:
		return "RF_CODE_INC"
	case BACnetVendorId_FATEK_AUTOMATION_CORP:
		return "FATEK_AUTOMATION_CORP"
	case BACnetVendorId_JANDA_SOFTWARE_COMPANYLLC:
		return "JANDA_SOFTWARE_COMPANYLLC"
	case BACnetVendorId_OPEN_SYSTEM_SOLUTIONS_LIMITED:
		return "OPEN_SYSTEM_SOLUTIONS_LIMITED"
	case BACnetVendorId_SYSTEMS_CONTROLS_INSTRUMENTSLLC:
		return "SYSTEMS_CONTROLS_INSTRUMENTSLLC"
	case BACnetVendorId_INTELEC_SYSTEMSPTY_LTD:
		return "INTELEC_SYSTEMSPTY_LTD"
	case BACnetVendorId_ECOLODGIXLLC:
		return "ECOLODGIXLLC"
	case BACnetVendorId_DOUGLAS_LIGHTING_CONTROLS:
		return "DOUGLAS_LIGHTING_CONTROLS"
	case BACnetVendorId_IS_ATECH_GMBH:
		return "IS_ATECH_GMBH"
	case BACnetVendorId_AREAL:
		return "AREAL"
	case BACnetVendorId_BECKHOFF_AUTOMATION:
		return "BECKHOFF_AUTOMATION"
	case BACnetVendorId_IPAS_GMBH:
		return "IPAS_GMBH"
	case BACnetVendorId_KE_THERM_SOLUTIONS:
		return "KE_THERM_SOLUTIONS"
	case BACnetVendorId_BASE_PRODUCTS:
		return "BASE_PRODUCTS"
	case BACnetVendorId_DTL_CONTROLSLLC:
		return "DTL_CONTROLSLLC"
	case BACnetVendorId_ACUITY_BRANDS_LIGHTING_INC:
		return "ACUITY_BRANDS_LIGHTING_INC"
	case BACnetVendorId_INNCOM_INTERNATIONAL_INC:
		return "INNCOM_INTERNATIONAL_INC"
	case BACnetVendorId_METZCONNECT_GMBH:
		return "METZCONNECT_GMBH"
	case BACnetVendorId_GREENTROL_AUTOMATION_INC:
		return "GREENTROL_AUTOMATION_INC"
	case BACnetVendorId_BELIMO_AUTOMATIONAG1:
		return "BELIMO_AUTOMATIONAG1"
	case BACnetVendorId_SAMSUNG_HEAVY_INDUSTRIES_CO_LTD:
		return "SAMSUNG_HEAVY_INDUSTRIES_CO_LTD"
	case BACnetVendorId_TRIACTA_POWER_TECHNOLOGIES_INC:
		return "TRIACTA_POWER_TECHNOLOGIES_INC"
	case BACnetVendorId_GLOBESTAR_SYSTEMS:
		return "GLOBESTAR_SYSTEMS"
	case BACnetVendorId_MLB_ADVANCED_MEDIALP:
		return "MLB_ADVANCED_MEDIALP"
	case BACnetVendorId_SWG_STUCKMANN_WIRTSCHAFTLICHE_GEBUDESYSTEME_GMBH:
		return "SWG_STUCKMANN_WIRTSCHAFTLICHE_GEBUDESYSTEME_GMBH"
	case BACnetVendorId_SENSOR_SWITCH:
		return "SENSOR_SWITCH"
	case BACnetVendorId_MICROPOWER_MANUFACTURING:
		return "MICROPOWER_MANUFACTURING"
	case BACnetVendorId_MULTITEK_POWER_LIMITED:
		return "MULTITEK_POWER_LIMITED"
	case BACnetVendorId_INTEGRA_METERINGAG:
		return "INTEGRA_METERINGAG"
	case BACnetVendorId_LG_ELECTRONICS_INC:
		return "LG_ELECTRONICS_INC"
	case BACnetVendorId_ELECTRONIC_THEATRE_CONTROLS_INC:
		return "ELECTRONIC_THEATRE_CONTROLS_INC"
	case BACnetVendorId_MITSUBISHI_ELECTRIC_CORPORATION_NAGOYA_WORKS:
		return "MITSUBISHI_ELECTRIC_CORPORATION_NAGOYA_WORKS"
	case BACnetVendorId_DELTA_ELECTRONICS_INC:
		return "DELTA_ELECTRONICS_INC"
	case BACnetVendorId_ELMA_KURTALJ_LTD:
		return "ELMA_KURTALJ_LTD"
	case BACnetVendorId_TYCO_FIRE_SECURITY_GMBH:
		return "TYCO_FIRE_SECURITY_GMBH"
	case BACnetVendorId_NEDAP_SECURITY_MANAGEMENT:
		return "NEDAP_SECURITY_MANAGEMENT"
	case BACnetVendorId_ESC_AUTOMATION_INC:
		return "ESC_AUTOMATION_INC"
	case BACnetVendorId_MATRIX_CONTROLS:
		return "MATRIX_CONTROLS"
	case BACnetVendorId_DSPYOU_LTD:
		return "DSPYOU_LTD"
	case BACnetVendorId_GE_SENSINGAND_INSPECTION_TECHNOLOGIES:
		return "GE_SENSINGAND_INSPECTION_TECHNOLOGIES"
	case BACnetVendorId_EMBEDDED_SYSTEMSSIA:
		return "EMBEDDED_SYSTEMSSIA"
	case BACnetVendorId_BEFEGA_GMBH:
		return "BEFEGA_GMBH"
	case BACnetVendorId_BASELINE_INC:
		return "BASELINE_INC"
	case BACnetVendorId_KEY_ACT:
		return "KEY_ACT"
	case BACnetVendorId_OEM_CTRL:
		return "OEM_CTRL"
	case BACnetVendorId_CLARKSON_CONTROLS_LIMITED:
		return "CLARKSON_CONTROLS_LIMITED"
	case BACnetVendorId_ROGERWELL_CONTROL_SYSTEM_LIMITED:
		return "ROGERWELL_CONTROL_SYSTEM_LIMITED"
	case BACnetVendorId_SCL_ELEMENTS:
		return "SCL_ELEMENTS"
	case BACnetVendorId_METALAIRE:
		return "METALAIRE"
	case BACnetVendorId_HITACHI_LTD1:
		return "HITACHI_LTD1"
	case BACnetVendorId_NEWRON_SYSTEMSA:
		return "NEWRON_SYSTEMSA"
	case BACnetVendorId_BEVECO_GEBOUWAUTOMATISERINGBV:
		return "BEVECO_GEBOUWAUTOMATISERINGBV"
	case BACnetVendorId_STREAMSIDE_SOLUTIONS:
		return "STREAMSIDE_SOLUTIONS"
	case BACnetVendorId_YELLOWSTONE_SOFT:
		return "YELLOWSTONE_SOFT"
	case BACnetVendorId_OZTECH_INTELLIGENT_SYSTEMS_PTY_LTD:
		return "OZTECH_INTELLIGENT_SYSTEMS_PTY_LTD"
	case BACnetVendorId_NOVELAN_GMBH:
		return "NOVELAN_GMBH"
	case BACnetVendorId_FLEXIM_AMERICAS_CORPORATION:
		return "FLEXIM_AMERICAS_CORPORATION"
	case BACnetVendorId_ICPDAS_CO_LTD:
		return "ICPDAS_CO_LTD"
	case BACnetVendorId_CARMA_INDUSTRIES_INC:
		return "CARMA_INDUSTRIES_INC"
	case BACnetVendorId_ESS_ENGINEERING:
		return "ESS_ENGINEERING"
	case BACnetVendorId_LOG_ONE_LTD:
		return "LOG_ONE_LTD"
	case BACnetVendorId_TECO_ELECTRIC_MACHINERY_CO_LTD:
		return "TECO_ELECTRIC_MACHINERY_CO_LTD"
	case BACnetVendorId_CONNECT_EX_INC:
		return "CONNECT_EX_INC"
	case BACnetVendorId_TURBODDC_SDWEST:
		return "TURBODDC_SDWEST"
	case BACnetVendorId_QUATROSENSE_ENVIRONMENTAL_LTD:
		return "QUATROSENSE_ENVIRONMENTAL_LTD"
	case BACnetVendorId_FIFTH_LIGHT_TECHNOLOGY_LTD:
		return "FIFTH_LIGHT_TECHNOLOGY_LTD"
	case BACnetVendorId_SCIENTIFIC_SOLUTIONS_LTD:
		return "SCIENTIFIC_SOLUTIONS_LTD"
	case BACnetVendorId_CONTROLLER_AREA_NETWORK_SOLUTIONSM_SDN_BHD:
		return "CONTROLLER_AREA_NETWORK_SOLUTIONSM_SDN_BHD"
	case BACnetVendorId_RESOL_ELEKTRONISCHE_REGELUNGEN_GMBH:
		return "RESOL_ELEKTRONISCHE_REGELUNGEN_GMBH"
	case BACnetVendorId_RPBUSLLC:
		return "RPBUSLLC"
	case BACnetVendorId_SPHERE_SYSTEMS_PTY_LTD:
		return "SPHERE_SYSTEMS_PTY_LTD"
	case BACnetVendorId_BRS_SISTEMAS_ELETRONICOS:
		return "BRS_SISTEMAS_ELETRONICOS"
	case BACnetVendorId_WINDOW_MASTERAS:
		return "WINDOW_MASTERAS"
	case BACnetVendorId_SUNLUX_TECHNOLOGIES_LTD:
		return "SUNLUX_TECHNOLOGIES_LTD"
	case BACnetVendorId_MEASURLOGIC:
		return "MEASURLOGIC"
	case BACnetVendorId_FRIMAT_GMBH:
		return "FRIMAT_GMBH"
	case BACnetVendorId_SPIRAX_SARCO:
		return "SPIRAX_SARCO"
	case BACnetVendorId_LUXTRON:
		return "LUXTRON"
	case BACnetVendorId_RAYPAK_INC:
		return "RAYPAK_INC"
	case BACnetVendorId_AIR_MONITOR_CORPORATION1:
		return "AIR_MONITOR_CORPORATION1"
	case BACnetVendorId_REGLER_OCH_WEBBTEKNIK_SVERIGEROWS:
		return "REGLER_OCH_WEBBTEKNIK_SVERIGEROWS"
	case BACnetVendorId_WALKER_TECHNOLOGIES_CORPORATION:
		return "WALKER_TECHNOLOGIES_CORPORATION"
	case BACnetVendorId_INTELLIGENT_LIGHTING_CONTROLS_INC:
		return "INTELLIGENT_LIGHTING_CONTROLS_INC"
	case BACnetVendorId_SANYO_ELECTRIC_INDUSTRY_CO_LTD:
		return "SANYO_ELECTRIC_INDUSTRY_CO_LTD"
	case BACnetVendorId_E_MON_ENERGY_MONITORING_PRODUCTS:
		return "E_MON_ENERGY_MONITORING_PRODUCTS"
	case BACnetVendorId_DIGITAL_CONTROL_SYSTEMS:
		return "DIGITAL_CONTROL_SYSTEMS"
	case BACnetVendorId_ATI_AIRTEST_TECHNOLOGIES_INC:
		return "ATI_AIRTEST_TECHNOLOGIES_INC"
	case BACnetVendorId_SCSSA:
		return "SCSSA"
	case BACnetVendorId_HMS_INDUSTRIAL_NETWORKSAB:
		return "HMS_INDUSTRIAL_NETWORKSAB"
	case BACnetVendorId_SHENZHEN_UNIVERSAL_INTELLISYS_CO_LTD:
		return "SHENZHEN_UNIVERSAL_INTELLISYS_CO_LTD"
	case BACnetVendorId_EK_INTELLISYS_SDN_BHD:
		return "EK_INTELLISYS_SDN_BHD"
	case BACnetVendorId_SYS_COM:
		return "SYS_COM"
	case BACnetVendorId_HI_SOLUTIONS_INC:
		return "HI_SOLUTIONS_INC"
	case BACnetVendorId_FIRECOM_INC:
		return "FIRECOM_INC"
	case BACnetVendorId_ESA_ELEKTROSCHALTANLAGEN_GRIMMA_GMBH:
		return "ESA_ELEKTROSCHALTANLAGEN_GRIMMA_GMBH"
	case BACnetVendorId_KUMAHIRA_CO_LTD:
		return "KUMAHIRA_CO_LTD"
	case BACnetVendorId_HOTRACO:
		return "HOTRACO"
	case BACnetVendorId_SABO_ELEKTRONIK_GMBH:
		return "SABO_ELEKTRONIK_GMBH"
	case BACnetVendorId_EQUIP_TRANS:
		return "EQUIP_TRANS"
	case BACnetVendorId_TEMPERATURE_CONTROL_SPECIALITIES_CO_INCTCS:
		return "TEMPERATURE_CONTROL_SPECIALITIES_CO_INCTCS"
	case BACnetVendorId_FLOW_CON_INTERNATIONALAS:
		return "FLOW_CON_INTERNATIONALAS"
	case BACnetVendorId_THYSSEN_KRUPP_ELEVATOR_AMERICAS:
		return "THYSSEN_KRUPP_ELEVATOR_AMERICAS"
	case BACnetVendorId_ABATEMENT_TECHNOLOGIES:
		return "ABATEMENT_TECHNOLOGIES"
	case BACnetVendorId_JOHNSON_CONTROLS_INC:
		return "JOHNSON_CONTROLS_INC"
	case BACnetVendorId_MBS_GMBH:
		return "MBS_GMBH"
	case BACnetVendorId_CONTINENTAL_CONTROL_SYSTEMSLLC:
		return "CONTINENTAL_CONTROL_SYSTEMSLLC"
	case BACnetVendorId_WISAG_AUTOMATISIERUNGSTECHNIK_GMBH_COKG:
		return "WISAG_AUTOMATISIERUNGSTECHNIK_GMBH_COKG"
	case BACnetVendorId_EASYIO:
		return "EASYIO"
	case BACnetVendorId_EAP_ELECTRIC_GMBH:
		return "EAP_ELECTRIC_GMBH"
	case BACnetVendorId_HARDMEIER:
		return "HARDMEIER"
	case BACnetVendorId_MIRCOM_GROUPOF_COMPANIES:
		return "MIRCOM_GROUPOF_COMPANIES"
	case BACnetVendorId_QUEST_CONTROLS:
		return "QUEST_CONTROLS"
	case BACnetVendorId_MESTEK_INC:
		return "MESTEK_INC"
	case BACnetVendorId_PULSE_ENERGY:
		return "PULSE_ENERGY"
	case BACnetVendorId_TACHIKAWA_CORPORATION:
		return "TACHIKAWA_CORPORATION"
	case BACnetVendorId_SAMSONAG:
		return "SAMSONAG"
	case BACnetVendorId_UNIVERSITYOF_NEBRASKA_LINCOLN:
		return "UNIVERSITYOF_NEBRASKA_LINCOLN"
	case BACnetVendorId_REDWOOD_SYSTEMS:
		return "REDWOOD_SYSTEMS"
	case BACnetVendorId_PAS_STEC_INDUSTRIE_ELEKTRONIK_GMBH:
		return "PAS_STEC_INDUSTRIE_ELEKTRONIK_GMBH"
	case BACnetVendorId_NGEK_INC:
		return "NGEK_INC"
	case BACnetVendorId_TMAC_TECHNOLOGIES:
		return "TMAC_TECHNOLOGIES"
	case BACnetVendorId_JIREH_ENERGY_TECH_CO_LTD:
		return "JIREH_ENERGY_TECH_CO_LTD"
	case BACnetVendorId_ENLIGHTED_INC:
		return "ENLIGHTED_INC"
	case BACnetVendorId_EL_PIAST_SP_ZOO:
		return "EL_PIAST_SP_ZOO"
	case BACnetVendorId_NETX_AUTOMATION_SOFTWARE_GMBH:
		return "NETX_AUTOMATION_SOFTWARE_GMBH"
	case BACnetVendorId_INVERTEK_DRIVES:
		return "INVERTEK_DRIVES"
	case BACnetVendorId_BADGER_METER_INC:
		return "BADGER_METER_INC"
	case BACnetVendorId_DEUTSCHMANN_AUTOMATION_GMBH_COKG:
		return "DEUTSCHMANN_AUTOMATION_GMBH_COKG"
	case BACnetVendorId_EMU_ELECTRONICAG:
		return "EMU_ELECTRONICAG"
	case BACnetVendorId_PHAEDRUS_LIMITED:
		return "PHAEDRUS_LIMITED"
	case BACnetVendorId_SIGMATEK_GMBH_COKG:
		return "SIGMATEK_GMBH_COKG"
	case BACnetVendorId_MARLIN_CONTROLS:
		return "MARLIN_CONTROLS"
	case BACnetVendorId_CIRCUTORSA:
		return "CIRCUTORSA"
	case BACnetVendorId_UTC_FIRE_SECURITY:
		return "UTC_FIRE_SECURITY"
	case BACnetVendorId_DENT_INSTRUMENTS_INC:
		return "DENT_INSTRUMENTS_INC"
	case BACnetVendorId_FHP_MANUFACTURING_COMPANY_BOSCH_GROUP:
		return "FHP_MANUFACTURING_COMPANY_BOSCH_GROUP"
	case BACnetVendorId_GE_INTELLIGENT_PLATFORMS:
		return "GE_INTELLIGENT_PLATFORMS"
	case BACnetVendorId_DAIKIN_INDUSTRIES_LTD:
		return "DAIKIN_INDUSTRIES_LTD"
	case BACnetVendorId_INNER_RANGE_PTY_LTD:
		return "INNER_RANGE_PTY_LTD"
	case BACnetVendorId_GLAS_ENERGY_TECHNOLOGY:
		return "GLAS_ENERGY_TECHNOLOGY"
	case BACnetVendorId_MSR_ELECTRONIC_GMBH:
		return "MSR_ELECTRONIC_GMBH"
	case BACnetVendorId_ENERGY_CONTROL_SYSTEMS_INC:
		return "ENERGY_CONTROL_SYSTEMS_INC"
	case BACnetVendorId_EMT_CONTROLS:
		return "EMT_CONTROLS"
	case BACnetVendorId_DAINTREE:
		return "DAINTREE"
	case BACnetVendorId_EUROIC_CDOO:
		return "EUROIC_CDOO"
	case BACnetVendorId_TE_CONNECTIVITY_ENERGY:
		return "TE_CONNECTIVITY_ENERGY"
	case BACnetVendorId_GEZE_GMBH:
		return "GEZE_GMBH"
	case BACnetVendorId_NEC_CORPORATION:
		return "NEC_CORPORATION"
	case BACnetVendorId_NARA_CONTROLS_INC:
		return "NARA_CONTROLS_INC"
	case BACnetVendorId_HO_CHEUNG_INTERNATIONAL_COMPANY_LIMITED:
		return "HO_CHEUNG_INTERNATIONAL_COMPANY_LIMITED"
	case BACnetVendorId_SHARP_MANUFACTURING_SYSTEMS_CORPORATION:
		return "SHARP_MANUFACTURING_SYSTEMS_CORPORATION"
	case BACnetVendorId_DOTCONTROL_SAS:
		return "DOTCONTROL_SAS"
	case BACnetVendorId_BEACON_MEDS:
		return "BEACON_MEDS"
	case BACnetVendorId_MIDEA_COMMERCIAL_AIRCON:
		return "MIDEA_COMMERCIAL_AIRCON"
	case BACnetVendorId_AAON:
		return "AAON"
	case BACnetVendorId_KAMSTRUPAS:
		return "KAMSTRUPAS"
	case BACnetVendorId_CA_COMPUTER_AUTOMATION_GMBH:
		return "CA_COMPUTER_AUTOMATION_GMBH"
	case BACnetVendorId_LAARS_HEATING_SYSTEMS_COMPANY:
		return "LAARS_HEATING_SYSTEMS_COMPANY"
	case BACnetVendorId_HITACHI_SYSTEMS_LTD:
		return "HITACHI_SYSTEMS_LTD"
	case BACnetVendorId_MAMMOTH_INC:
		return "MAMMOTH_INC"
	case BACnetVendorId_FUSHANAKE_ELECTRONIC_ENGINEERING_CO_LTD:
		return "FUSHANAKE_ELECTRONIC_ENGINEERING_CO_LTD"
	case BACnetVendorId_TOSHIBA_INTERNATIONAL_CORPORATION:
		return "TOSHIBA_INTERNATIONAL_CORPORATION"
	case BACnetVendorId_STARMAN_SYSTEMSLLC:
		return "STARMAN_SYSTEMSLLC"
	case BACnetVendorId_SAMSUNG_TECHWIN_CO_LTD:
		return "SAMSUNG_TECHWIN_CO_LTD"
	case BACnetVendorId_ISAS_INTEGRATED_SWITCHGEARAND_SYSTEMSPL:
		return "ISAS_INTEGRATED_SWITCHGEARAND_SYSTEMSPL"
	case BACnetVendorId_OBVIUS:
		return "OBVIUS"
	case BACnetVendorId_MAREK_GUZIK:
		return "MAREK_GUZIK"
	case BACnetVendorId_VORTEK_INSTRUMENTSLLC:
		return "VORTEK_INSTRUMENTSLLC"
	case BACnetVendorId_UNIVERSAL_LIGHTING_TECHNOLOGIES:
		return "UNIVERSAL_LIGHTING_TECHNOLOGIES"
	case BACnetVendorId_LIEBERT_CORPORATION:
		return "LIEBERT_CORPORATION"
	case BACnetVendorId_MYERS_POWER_PRODUCTS_INC:
		return "MYERS_POWER_PRODUCTS_INC"
	case BACnetVendorId_VECTOR_CONTROLS_GMBH:
		return "VECTOR_CONTROLS_GMBH"
	case BACnetVendorId_CRESTRON_ELECTRONICS_INC:
		return "CRESTRON_ELECTRONICS_INC"
	case BACnetVendorId_AE_CONTROLS_LIMITED:
		return "AE_CONTROLS_LIMITED"
	case BACnetVendorId_PROJEKTOMONTAZAAD:
		return "PROJEKTOMONTAZAAD"
	case BACnetVendorId_FREEAIRE_REFRIGERATION:
		return "FREEAIRE_REFRIGERATION"
	case BACnetVendorId_AQUA_COOLER_PTY_LIMITED:
		return "AQUA_COOLER_PTY_LIMITED"
	case BACnetVendorId_BASIC_CONTROLS:
		return "BASIC_CONTROLS"
	case BACnetVendorId_GE_MEASUREMENTAND_CONTROL_SOLUTIONS_ADVANCED_SENSORS:
		return "GE_MEASUREMENTAND_CONTROL_SOLUTIONS_ADVANCED_SENSORS"
	case BACnetVendorId_EQUAL_NETWORKS:
		return "EQUAL_NETWORKS"
	case BACnetVendorId_SEMCO_INCORPORATED:
		return "SEMCO_INCORPORATED"
	case BACnetVendorId_MILLENNIAL_NET:
		return "MILLENNIAL_NET"
	case BACnetVendorId_APLI_LTD:
		return "APLI_LTD"
	case BACnetVendorId_ELECTRO_INDUSTRIES_GAUGE_TECH:
		return "ELECTRO_INDUSTRIES_GAUGE_TECH"
	case BACnetVendorId_SANG_MYUNG_UNIVERSITY:
		return "SANG_MYUNG_UNIVERSITY"
	case BACnetVendorId_COPPERTREE_ANALYTICS_INC:
		return "COPPERTREE_ANALYTICS_INC"
	case BACnetVendorId_CORE_NETIX_GMBH:
		return "CORE_NETIX_GMBH"
	case BACnetVendorId_ACUTHERM:
		return "ACUTHERM"
	case BACnetVendorId_DR_RIEDEL_AUTOMATISIERUNGSTECHNIK_GMBH:
		return "DR_RIEDEL_AUTOMATISIERUNGSTECHNIK_GMBH"
	case BACnetVendorId_SHINA_SYSTEM_CO_LTD:
		return "SHINA_SYSTEM_CO_LTD"
	case BACnetVendorId_IQAPERTUS:
		return "IQAPERTUS"
	case BACnetVendorId_AIR_MONITOR_CORPORATION:
		return "AIR_MONITOR_CORPORATION"
	case BACnetVendorId_PSE_TECHNOLOGY:
		return "PSE_TECHNOLOGY"
	case BACnetVendorId_BA_SYSTEMS:
		return "BA_SYSTEMS"
	case BACnetVendorId_BTICINO:
		return "BTICINO"
	case BACnetVendorId_MONICO_INC:
		return "MONICO_INC"
	case BACnetVendorId_I_CUE:
		return "I_CUE"
	case BACnetVendorId_TEKMAR_CONTROL_SYSTEMS_LTD:
		return "TEKMAR_CONTROL_SYSTEMS_LTD"
	case BACnetVendorId_CONTROL_TECHNOLOGY_CORPORATION:
		return "CONTROL_TECHNOLOGY_CORPORATION"
	case BACnetVendorId_GFAE_GMBH:
		return "GFAE_GMBH"
	case BACnetVendorId_BE_KA_SOFTWARE_GMBH:
		return "BE_KA_SOFTWARE_GMBH"
	case BACnetVendorId_ISOIL_INDUSTRIA_SPA:
		return "ISOIL_INDUSTRIA_SPA"
	case BACnetVendorId_TRIATEKLLC:
		return "TRIATEKLLC"
	case BACnetVendorId_HOME_SYSTEMS_CONSULTING_SPA:
		return "HOME_SYSTEMS_CONSULTING_SPA"
	case BACnetVendorId_SOCOMEC:
		return "SOCOMEC"
	case BACnetVendorId_EVEREX_COMMUNICATIONS_INC:
		return "EVEREX_COMMUNICATIONS_INC"
	case BACnetVendorId_CET_ELECTRIC_TECHNOLOGY_INC:
		return "CET_ELECTRIC_TECHNOLOGY_INC"
	case BACnetVendorId_ATRILA_GMBH:
		return "ATRILA_GMBH"
	case BACnetVendorId_WING_TECHS:
		return "WING_TECHS"
	case BACnetVendorId_SHENZHEN_MEK_INTELLISYS_PTE_LTD:
		return "SHENZHEN_MEK_INTELLISYS_PTE_LTD"
	case BACnetVendorId_NESTFIELD_CO_LTD:
		return "NESTFIELD_CO_LTD"
	case BACnetVendorId_SWISSPHONE_TELECOMAG:
		return "SWISSPHONE_TELECOMAG"
	case BACnetVendorId_PNTECHJSC:
		return "PNTECHJSC"
	case BACnetVendorId_ABB_FORMERLY_AMERICAN_AUTO_MATRIX:
		return "ABB_FORMERLY_AMERICAN_AUTO_MATRIX"
	case BACnetVendorId_NEX_LIGHT:
		return "NEX_LIGHT"
	case BACnetVendorId_HORNERAPGLLC:
		return "HORNERAPGLLC"
	case BACnetVendorId_PVI_INDUSTRIESLLC:
		return "PVI_INDUSTRIESLLC"
	case BACnetVendorId_ELACOMPIL:
		return "ELACOMPIL"
	case BACnetVendorId_PEGASUS_AUTOMATION_INTERNATIONALLLC:
		return "PEGASUS_AUTOMATION_INTERNATIONALLLC"
	case BACnetVendorId_WIGHT_ELECTRONIC_SERVICES_LTD:
		return "WIGHT_ELECTRONIC_SERVICES_LTD"
	case BACnetVendorId_MARCOM:
		return "MARCOM"
	case BACnetVendorId_EXHAUSTOAS:
		return "EXHAUSTOAS"
	case BACnetVendorId_DWYER_INSTRUMENTS_INC:
		return "DWYER_INSTRUMENTS_INC"
	case BACnetVendorId_LINK_GMBH:
		return "LINK_GMBH"
	case BACnetVendorId_OPPERMANN_REGELGERATE_GMBH:
		return "OPPERMANN_REGELGERATE_GMBH"
	case BACnetVendorId_MULTISTACK:
		return "MULTISTACK"
	case BACnetVendorId_NU_AIRE_INC:
		return "NU_AIRE_INC"
	case BACnetVendorId_NORTEC_HUMIDITY_INC:
		return "NORTEC_HUMIDITY_INC"
	case BACnetVendorId_BIGWOOD_SYSTEMS_INC:
		return "BIGWOOD_SYSTEMS_INC"
	case BACnetVendorId_ENBALA_POWER_NETWORKS:
		return "ENBALA_POWER_NETWORKS"
	case BACnetVendorId_INTER_ENERGY_CO_LTD:
		return "INTER_ENERGY_CO_LTD"
	case BACnetVendorId_ETC:
		return "ETC"
	case BACnetVendorId_COMELECSARL:
		return "COMELECSARL"
	case BACnetVendorId_PYTHIA_TECHNOLOGIES:
		return "PYTHIA_TECHNOLOGIES"
	case BACnetVendorId_TREND_POINT_SYSTEMS_INC:
		return "TREND_POINT_SYSTEMS_INC"
	case BACnetVendorId_AWEX:
		return "AWEX"
	case BACnetVendorId_TSI_INCORPORATED:
		return "TSI_INCORPORATED"
	case BACnetVendorId_EUREVIA:
		return "EUREVIA"
	case BACnetVendorId_KONGSBERGELONAS:
		return "KONGSBERGELONAS"
	case BACnetVendorId_FLAKT_WOODS:
		return "FLAKT_WOODS"
	case BACnetVendorId_EE_ELEKTRONIKGESMBH:
		return "EE_ELEKTRONIKGESMBH"
	case BACnetVendorId_ARC_INFORMATIQUE:
		return "ARC_INFORMATIQUE"
	case BACnetVendorId_SKIDATAAG:
		return "SKIDATAAG"
	case BACnetVendorId_WSW_SOLUTIONS:
		return "WSW_SOLUTIONS"
	case BACnetVendorId_TREFON_ELECTRONIC_GMBH:
		return "TREFON_ELECTRONIC_GMBH"
	case BACnetVendorId_DONGSEO_SYSTEM:
		return "DONGSEO_SYSTEM"
	case BACnetVendorId_KANONTEC_INTELLIGENCE_TECHNOLOGY_CO_LTD:
		return "KANONTEC_INTELLIGENCE_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_WEATHER_RITE_INC:
		return "WEATHER_RITE_INC"
	case BACnetVendorId_EVCO_SPA:
		return "EVCO_SPA"
	case BACnetVendorId_ACCUENERGY_CANADA_INC:
		return "ACCUENERGY_CANADA_INC"
	case BACnetVendorId_SOFTDEL:
		return "SOFTDEL"
	case BACnetVendorId_ORION_ENERGY_SYSTEMS_INC:
		return "ORION_ENERGY_SYSTEMS_INC"
	case BACnetVendorId_ROBOTICSWARE:
		return "ROBOTICSWARE"
	case BACnetVendorId_DOMIQ_SPZOO:
		return "DOMIQ_SPZOO"
	case BACnetVendorId_SOLIDYNE:
		return "SOLIDYNE"
	case BACnetVendorId_ELECSYS_CORPORATION:
		return "ELECSYS_CORPORATION"
	case BACnetVendorId_CONDITIONAIRE_INTERNATIONAL_PTY_LIMITED:
		return "CONDITIONAIRE_INTERNATIONAL_PTY_LIMITED"
	case BACnetVendorId_QUEBEC_INC:
		return "QUEBEC_INC"
	case BACnetVendorId_DUNHAM_BUSH:
		return "DUNHAM_BUSH"
	case BACnetVendorId_HOMERUN_HOLDINGS:
		return "HOMERUN_HOLDINGS"
	case BACnetVendorId_MURATA_AMERICAS:
		return "MURATA_AMERICAS"
	case BACnetVendorId_COMPTEK:
		return "COMPTEK"
	case BACnetVendorId_WESTCO_SYSTEMS_INC:
		return "WESTCO_SYSTEMS_INC"
	case BACnetVendorId_ADVANCIS_SOFTWARE_SERVICES_GMBH:
		return "ADVANCIS_SOFTWARE_SERVICES_GMBH"
	case BACnetVendorId_INTERGRIDLLC:
		return "INTERGRIDLLC"
	case BACnetVendorId_MARKERR_CONTROLS_INC:
		return "MARKERR_CONTROLS_INC"
	case BACnetVendorId_TOSHIBA_ELEVATORAND_BUILDING_SYSTEMS_CORPORATION:
		return "TOSHIBA_ELEVATORAND_BUILDING_SYSTEMS_CORPORATION"
	case BACnetVendorId_SPECTRUM_CONTROLS_INC:
		return "SPECTRUM_CONTROLS_INC"
	case BACnetVendorId_MKSERVICE:
		return "MKSERVICE"
	case BACnetVendorId_RELIANCE_ELECTRIC:
		return "RELIANCE_ELECTRIC"
	case BACnetVendorId_FOX_THERMAL_INSTRUMENTS:
		return "FOX_THERMAL_INSTRUMENTS"
	case BACnetVendorId_SYXTH_SENSE_LTD:
		return "SYXTH_SENSE_LTD"
	case BACnetVendorId_DUHA_SYSTEMSRO:
		return "DUHA_SYSTEMSRO"
	case BACnetVendorId_NIBE:
		return "NIBE"
	case BACnetVendorId_MELINK_CORPORATION:
		return "MELINK_CORPORATION"
	case BACnetVendorId_FRITZ_HABER_INSTITUT:
		return "FRITZ_HABER_INSTITUT"
	case BACnetVendorId_MTU_ONSITE_ENERGY_GMBH_GAS_POWER_SYSTEMS:
		return "MTU_ONSITE_ENERGY_GMBH_GAS_POWER_SYSTEMS"
	case BACnetVendorId_OMEGA_ENGINEERING_INC:
		return "OMEGA_ENGINEERING_INC"
	case BACnetVendorId_AVELON:
		return "AVELON"
	case BACnetVendorId_YWIRE_TECHNOLOGIES_INC:
		return "YWIRE_TECHNOLOGIES_INC"
	case BACnetVendorId_LCS_INC:
		return "LCS_INC"
	case BACnetVendorId_MR_ENGINEERING_CO_LTD:
		return "MR_ENGINEERING_CO_LTD"
	case BACnetVendorId_LOCHINVARLLC:
		return "LOCHINVARLLC"
	case BACnetVendorId_SONTAY_LIMITED:
		return "SONTAY_LIMITED"
	case BACnetVendorId_GRUPA_SLAWOMIR_CHELMINSKI:
		return "GRUPA_SLAWOMIR_CHELMINSKI"
	case BACnetVendorId_ARCH_METER_CORPORATION:
		return "ARCH_METER_CORPORATION"
	case BACnetVendorId_SENVA_INC:
		return "SENVA_INC"
	case BACnetVendorId_FM_TEC:
		return "FM_TEC"
	case BACnetVendorId_SYSTEMS_SPECIALISTS_INC:
		return "SYSTEMS_SPECIALISTS_INC"
	case BACnetVendorId_SENSE_AIR:
		return "SENSE_AIR"
	case BACnetVendorId_REGULATOR_AUSTRALIAPTY_LTD:
		return "REGULATOR_AUSTRALIAPTY_LTD"
	case BACnetVendorId_AB_INDUSTRIE_TECHNIK_SRL:
		return "AB_INDUSTRIE_TECHNIK_SRL"
	case BACnetVendorId_CORTLAND_RESEARCHLLC:
		return "CORTLAND_RESEARCHLLC"
	case BACnetVendorId_MEDIA_VIEW:
		return "MEDIA_VIEW"
	case BACnetVendorId_VDA_ELETTRONICA:
		return "VDA_ELETTRONICA"
	case BACnetVendorId_CSS_INC:
		return "CSS_INC"
	case BACnetVendorId_TEK_AIR_SYSTEMS_INC:
		return "TEK_AIR_SYSTEMS_INC"
	case BACnetVendorId_ICDT:
		return "ICDT"
	case BACnetVendorId_THE_ARMSTRONG_MONITORING_CORPORATION:
		return "THE_ARMSTRONG_MONITORING_CORPORATION"
	case BACnetVendorId_DIXELL_SRL:
		return "DIXELL_SRL"
	case BACnetVendorId_LEAD_SYSTEM_INC:
		return "LEAD_SYSTEM_INC"
	case BACnetVendorId_TOUCH_PLATE_LIGHTING_CONTROLS:
		return "TOUCH_PLATE_LIGHTING_CONTROLS"
	case BACnetVendorId_ISM_EURO_CENTERSA:
		return "ISM_EURO_CENTERSA"
	case BACnetVendorId_TDIS:
		return "TDIS"
	case BACnetVendorId_TRADEFIDES:
		return "TRADEFIDES"
	case BACnetVendorId_KNRR_GMBH_EMERSON_NETWORK_POWER:
		return "KNRR_GMBH_EMERSON_NETWORK_POWER"
	case BACnetVendorId_RESOURCE_DATA_MANAGEMENT:
		return "RESOURCE_DATA_MANAGEMENT"
	case BACnetVendorId_ABIES_TECHNOLOGY_INC:
		return "ABIES_TECHNOLOGY_INC"
	case BACnetVendorId_UAB_KOMFOVENT:
		return "UAB_KOMFOVENT"
	case BACnetVendorId_MIRAE_ELECTRICAL_MFG_CO_LTD:
		return "MIRAE_ELECTRICAL_MFG_CO_LTD"
	case BACnetVendorId_HUNTER_DOUGLAS_ARCHITECTURAL_PROJECTS_SCANDINAVIA_APS:
		return "HUNTER_DOUGLAS_ARCHITECTURAL_PROJECTS_SCANDINAVIA_APS"
	case BACnetVendorId_RUNPAQ_GROUP_CO_LTD:
		return "RUNPAQ_GROUP_CO_LTD"
	case BACnetVendorId_AMANN_GMBH:
		return "AMANN_GMBH"
	case BACnetVendorId_UNICARDSA:
		return "UNICARDSA"
	case BACnetVendorId_IE_TECHNOLOGIES:
		return "IE_TECHNOLOGIES"
	case BACnetVendorId_RUSKIN_MANUFACTURING:
		return "RUSKIN_MANUFACTURING"
	case BACnetVendorId_CALON_ASSOCIATES_LIMITED:
		return "CALON_ASSOCIATES_LIMITED"
	case BACnetVendorId_CONTEC_CO_LTD:
		return "CONTEC_CO_LTD"
	case BACnetVendorId_IT_GMBH:
		return "IT_GMBH"
	case BACnetVendorId_AUTANI_CORPORATION:
		return "AUTANI_CORPORATION"
	case BACnetVendorId_CHRISTIAN_FORTIN:
		return "CHRISTIAN_FORTIN"
	case BACnetVendorId_HDL:
		return "HDL"
	case BACnetVendorId_IPID_SPZOO_LIMITED:
		return "IPID_SPZOO_LIMITED"
	case BACnetVendorId_SIEMENS_SCHWEIZAG:
		return "SIEMENS_SCHWEIZAG"
	case BACnetVendorId_RLE_TECHNOLOGIES:
		return "RLE_TECHNOLOGIES"
	case BACnetVendorId_FUJI_ELECTRIC_CO_LTD:
		return "FUJI_ELECTRIC_CO_LTD"
	case BACnetVendorId_VIEW_INC:
		return "VIEW_INC"
	case BACnetVendorId_SAMSUNGS1_CORPORATION:
		return "SAMSUNGS1_CORPORATION"
	case BACnetVendorId_NEW_LIFT:
		return "NEW_LIFT"
	case BACnetVendorId_VRT_SYSTEMS:
		return "VRT_SYSTEMS"
	case BACnetVendorId_MOTION_CONTROL_ENGINEERING_INC:
		return "MOTION_CONTROL_ENGINEERING_INC"
	case BACnetVendorId_WEISS_KLIMATECHNIK_GMBH:
		return "WEISS_KLIMATECHNIK_GMBH"
	case BACnetVendorId_ELKON:
		return "ELKON"
	case BACnetVendorId_ELIWELL_CONTROLS_SRL:
		return "ELIWELL_CONTROLS_SRL"
	case BACnetVendorId_JAPAN_COMPUTER_TECHNOS_CORP:
		return "JAPAN_COMPUTER_TECHNOS_CORP"
	case BACnetVendorId_CARDKEY_SYSTEMS:
		return "CARDKEY_SYSTEMS"
	case BACnetVendorId_RATIONAL_NETWORKEHF:
		return "RATIONAL_NETWORKEHF"
	case BACnetVendorId_MAGNUM_ENERGY_SOLUTIONSLLC:
		return "MAGNUM_ENERGY_SOLUTIONSLLC"
	case BACnetVendorId_MEL_ROK:
		return "MEL_ROK"
	case BACnetVendorId_VAE_GROUP:
		return "VAE_GROUP"
	case BACnetVendorId_LGCNS:
		return "LGCNS"
	case BACnetVendorId_BERGHOF_AUTOMATIONSTECHNIK_GMBH:
		return "BERGHOF_AUTOMATIONSTECHNIK_GMBH"
	case BACnetVendorId_QUARK_COMMUNICATIONS_INC:
		return "QUARK_COMMUNICATIONS_INC"
	case BACnetVendorId_SONTEX:
		return "SONTEX"
	case BACnetVendorId_MIVUNEAG:
		return "MIVUNEAG"
	case BACnetVendorId_PANDUIT:
		return "PANDUIT"
	case BACnetVendorId_SECOM_CO_LTD:
		return "SECOM_CO_LTD"
	case BACnetVendorId_SMART_CONTROLSLLC:
		return "SMART_CONTROLSLLC"
	case BACnetVendorId_COMPU_AIRE_INC:
		return "COMPU_AIRE_INC"
	case BACnetVendorId_SIERRA:
		return "SIERRA"
	case BACnetVendorId_PROTO_SENSE_TECHNOLOGIES:
		return "PROTO_SENSE_TECHNOLOGIES"
	case BACnetVendorId_ELTRAC_TECHNOLOGIES_PVT_LTD:
		return "ELTRAC_TECHNOLOGIES_PVT_LTD"
	case BACnetVendorId_BEKTAS_INVISIBLE_CONTROLS_GMBH:
		return "BEKTAS_INVISIBLE_CONTROLS_GMBH"
	case BACnetVendorId_ENTELEC:
		return "ENTELEC"
	case BACnetVendorId_INNEXIV:
		return "INNEXIV"
	case BACnetVendorId_COVENANT:
		return "COVENANT"
	case BACnetVendorId_DAVITORAB:
		return "DAVITORAB"
	case BACnetVendorId_ABB_GEBUDETECHNIKAG_BEREICH_NET_SERV:
		return "ABB_GEBUDETECHNIKAG_BEREICH_NET_SERV"
	case BACnetVendorId_TONG_FANG_TECHNOVATOR:
		return "TONG_FANG_TECHNOVATOR"
	case BACnetVendorId_BUILDING_ROBOTICS_INC:
		return "BUILDING_ROBOTICS_INC"
	case BACnetVendorId_HSSMSRUG:
		return "HSSMSRUG"
	case BACnetVendorId_FRAM_TACKLLC:
		return "FRAM_TACKLLC"
	case BACnetVendorId_BL_ACOUSTICS_LTD:
		return "BL_ACOUSTICS_LTD"
	case BACnetVendorId_TRAXXON_ROCK_DRILLS_LTD:
		return "TRAXXON_ROCK_DRILLS_LTD"
	case BACnetVendorId_FRANKE:
		return "FRANKE"
	case BACnetVendorId_WURM_GMBH_CO:
		return "WURM_GMBH_CO"
	case BACnetVendorId_ADDENERGIE:
		return "ADDENERGIE"
	case BACnetVendorId_MIRLE_AUTOMATION_CORPORATION:
		return "MIRLE_AUTOMATION_CORPORATION"
	case BACnetVendorId_KNX_ASSOCIATIONCVBA:
		return "KNX_ASSOCIATIONCVBA"
	case BACnetVendorId_IBIS_NETWORKS:
		return "IBIS_NETWORKS"
	case BACnetVendorId_IDKART_ASRO:
		return "IDKART_ASRO"
	case BACnetVendorId_ANAREN_INC:
		return "ANAREN_INC"
	case BACnetVendorId_SPAN_INCORPORATED:
		return "SPAN_INCORPORATED"
	case BACnetVendorId_BOSCH_THERMOTECHNOLOGY_CORP:
		return "BOSCH_THERMOTECHNOLOGY_CORP"
	case BACnetVendorId_DRC_TECHNOLOGYSA:
		return "DRC_TECHNOLOGYSA"
	case BACnetVendorId_SHANGHAI_ENERGY_BUILDING_TECHNOLOGY_CO_LTD:
		return "SHANGHAI_ENERGY_BUILDING_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_FRAPORTAG:
		return "FRAPORTAG"
	case BACnetVendorId_FLOWGROUP:
		return "FLOWGROUP"
	case BACnetVendorId_SKYTRON_ENERGY_GMBH:
		return "SKYTRON_ENERGY_GMBH"
	case BACnetVendorId_INSTITUTEOF_ELECTRICAL_INSTALLATION_ENGINEERSOF_JAPANIEIEJ:
		return "INSTITUTEOF_ELECTRICAL_INSTALLATION_ENGINEERSOF_JAPANIEIEJ"
	case BACnetVendorId_ALTEL_WICHA_GOLDA_SPJ:
		return "ALTEL_WICHA_GOLDA_SPJ"
	case BACnetVendorId_DRUPAL:
		return "DRUPAL"
	case BACnetVendorId_AXIOMATIC_TECHNOLOGY_LTD:
		return "AXIOMATIC_TECHNOLOGY_LTD"
	case BACnetVendorId_BOHNKE_PARTNER:
		return "BOHNKE_PARTNER"
	case BACnetVendorId_FUNCTION1:
		return "FUNCTION1"
	case BACnetVendorId_OPTERGY_PTY_LTD:
		return "OPTERGY_PTY_LTD"
	case BACnetVendorId_LSI_VIRTICUS:
		return "LSI_VIRTICUS"
	case BACnetVendorId_KONZEPTPARK_GMBH:
		return "KONZEPTPARK_GMBH"
	case BACnetVendorId_NX_LIGHTING_CONTROLS:
		return "NX_LIGHTING_CONTROLS"
	case BACnetVendorId_E_CURV_INC:
		return "E_CURV_INC"
	case BACnetVendorId_NOHMI_BOSAI_LTD:
		return "NOHMI_BOSAI_LTD"
	case BACnetVendorId_AGNOSYS_GMBH:
		return "AGNOSYS_GMBH"
	case BACnetVendorId_SHANGHAI_SUNFULL_AUTOMATION_COLTD:
		return "SHANGHAI_SUNFULL_AUTOMATION_COLTD"
	case BACnetVendorId_KURZ_INSTRUMENTS_INC:
		return "KURZ_INSTRUMENTS_INC"
	case BACnetVendorId_CIAS_ELETTRONICA_SRL:
		return "CIAS_ELETTRONICA_SRL"
	case BACnetVendorId_MULTIAQUA_INC:
		return "MULTIAQUA_INC"
	case BACnetVendorId_BLUE_BOX:
		return "BLUE_BOX"
	case BACnetVendorId_SENSIDYNE:
		return "SENSIDYNE"
	case BACnetVendorId_VIESSMANN_ELEKTRONIK_GMBH:
		return "VIESSMANN_ELEKTRONIK_GMBH"
	case BACnetVendorId_AD_FWEBCOMSRL:
		return "AD_FWEBCOMSRL"
	case BACnetVendorId_GAYLORD_INDUSTRIES:
		return "GAYLORD_INDUSTRIES"
	case BACnetVendorId_CAREL_INDUSTRIES_SPA:
		return "CAREL_INDUSTRIES_SPA"
	case BACnetVendorId_MAJUR_LTD:
		return "MAJUR_LTD"
	case BACnetVendorId_SHANGHAI_HUILIN_TECHNOLOGY_CO_LTD:
		return "SHANGHAI_HUILIN_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_EXOTRONIC:
		return "EXOTRONIC"
	case BACnetVendorId_SAFECONTRO_LSRO:
		return "SAFECONTRO_LSRO"
	case BACnetVendorId_AMATIS:
		return "AMATIS"
	case BACnetVendorId_UNIVERSAL_ELECTRIC_CORPORATION:
		return "UNIVERSAL_ELECTRIC_CORPORATION"
	case BACnetVendorId_IBA_CNET:
		return "IBA_CNET"
	case BACnetVendorId_SMARTRISE_ENGINEERING_INC:
		return "SMARTRISE_ENGINEERING_INC"
	case BACnetVendorId_MIRATRON_INC:
		return "MIRATRON_INC"
	case BACnetVendorId_UTC_FIRE_SECURITY_ESPAASL:
		return "UTC_FIRE_SECURITY_ESPAASL"
	case BACnetVendorId_SMART_EDGE:
		return "SMART_EDGE"
	case BACnetVendorId_MITSUBISHI_ELECTRIC_AUSTRALIA_PTY_LTD:
		return "MITSUBISHI_ELECTRIC_AUSTRALIA_PTY_LTD"
	case BACnetVendorId_TRIANGLE_RESEARCH_INTERNATIONAL_PTD_LTD:
		return "TRIANGLE_RESEARCH_INTERNATIONAL_PTD_LTD"
	case BACnetVendorId_PRODUAL_OY:
		return "PRODUAL_OY"
	case BACnetVendorId_MILESTONE_SYSTEMSAS:
		return "MILESTONE_SYSTEMSAS"
	case BACnetVendorId_TRUSTBRIDGE:
		return "TRUSTBRIDGE"
	case BACnetVendorId_FEEDBACK_SOLUTIONS:
		return "FEEDBACK_SOLUTIONS"
	case BACnetVendorId_IES:
		return "IES"
	case BACnetVendorId_ABB_POWER_PROTECTIONSA:
		return "ABB_POWER_PROTECTIONSA"
	case BACnetVendorId_RIPTIDEIO:
		return "RIPTIDEIO"
	case BACnetVendorId_HOCHIKI_CORPORATION:
		return "HOCHIKI_CORPORATION"
	case BACnetVendorId_MESSERSCHMITT_SYSTEMSAG:
		return "MESSERSCHMITT_SYSTEMSAG"
	case BACnetVendorId_DEZEM_ENERGY_CONTROLLING:
		return "DEZEM_ENERGY_CONTROLLING"
	case BACnetVendorId_MECHO_SYSTEMS:
		return "MECHO_SYSTEMS"
	case BACnetVendorId_EVON_GMBH:
		return "EVON_GMBH"
	case BACnetVendorId_CS_LAB_GMBH:
		return "CS_LAB_GMBH"
	case BACnetVendorId_N_0_ENTERPRISES_INC:
		return "N_0_ENTERPRISES_INC"
	case BACnetVendorId_TOUCHE_CONTROLS:
		return "TOUCHE_CONTROLS"
	case BACnetVendorId_ONTROL_TEKNIK_MALZEME_SANVE_TICAS:
		return "ONTROL_TEKNIK_MALZEME_SANVE_TICAS"
	case BACnetVendorId_UNI_CONTROL_SYSTEM_SP_ZOO:
		return "UNI_CONTROL_SYSTEM_SP_ZOO"
	case BACnetVendorId_WEIHAI_PLOUMETER_CO_LTD:
		return "WEIHAI_PLOUMETER_CO_LTD"
	case BACnetVendorId_DELTA_CONTROLS:
		return "DELTA_CONTROLS"
	case BACnetVendorId_FR_SAUTERAG:
		return "FR_SAUTERAG"
	case BACnetVendorId_ELCOM_INTERNATIONAL_PVT_LTD:
		return "ELCOM_INTERNATIONAL_PVT_LTD"
	case BACnetVendorId_SIGNIFY:
		return "SIGNIFY"
	case BACnetVendorId_AUTOMATION_DIRECT:
		return "AUTOMATION_DIRECT"
	case BACnetVendorId_PARAGON_ROBOTICS:
		return "PARAGON_ROBOTICS"
	case BACnetVendorId_SMT_SYSTEM_MODULES_TECHNOLOGYAG:
		return "SMT_SYSTEM_MODULES_TECHNOLOGYAG"
	case BACnetVendorId_RADIX_IOTLLC:
		return "RADIX_IOTLLC"
	case BACnetVendorId_CMR_CONTROLS_LTD:
		return "CMR_CONTROLS_LTD"
	case BACnetVendorId_INNOVARI_INC:
		return "INNOVARI_INC"
	case BACnetVendorId_ABB_CONTROL_PRODUCTS:
		return "ABB_CONTROL_PRODUCTS"
	case BACnetVendorId_GESELLSCHAFTFUR_GEBUDEAUTOMATIONMBH:
		return "GESELLSCHAFTFUR_GEBUDEAUTOMATIONMBH"
	case BACnetVendorId_MATSUSHITA_ELECTRIC_WORKS_LTD:
		return "MATSUSHITA_ELECTRIC_WORKS_LTD"
	case BACnetVendorId_RODI_SYSTEMS_CORP:
		return "RODI_SYSTEMS_CORP"
	case BACnetVendorId_NEXTEK_POWER_SYSTEMS:
		return "NEXTEK_POWER_SYSTEMS"
	case BACnetVendorId_CREATIVE_LIGHTING:
		return "CREATIVE_LIGHTING"
	case BACnetVendorId_WATER_FURNACE_INTERNATIONAL:
		return "WATER_FURNACE_INTERNATIONAL"
	case BACnetVendorId_MERCURY_SECURITY:
		return "MERCURY_SECURITY"
	case BACnetVendorId_HISENSE_SHANDONG_AIR_CONDITIONING_CO_LTD:
		return "HISENSE_SHANDONG_AIR_CONDITIONING_CO_LTD"
	case BACnetVendorId_LAYERED_SOLUTIONS_INC:
		return "LAYERED_SOLUTIONS_INC"
	case BACnetVendorId_LEEGOOD_AUTOMATIC_SYSTEM_INC:
		return "LEEGOOD_AUTOMATIC_SYSTEM_INC"
	case BACnetVendorId_SHANGHAI_RESTAR_TECHNOLOGY_CO_LTD:
		return "SHANGHAI_RESTAR_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_REIMANN_INGENIEURBRO:
		return "REIMANN_INGENIEURBRO"
	case BACnetVendorId_MITSUBISHI_ELECTRIC_CORPORATION_INAZAWA_WORKS:
		return "MITSUBISHI_ELECTRIC_CORPORATION_INAZAWA_WORKS"
	case BACnetVendorId_LYN_TEC:
		return "LYN_TEC"
	case BACnetVendorId_HTP:
		return "HTP"
	case BACnetVendorId_ELKOR_TECHNOLOGIES_INC:
		return "ELKOR_TECHNOLOGIES_INC"
	case BACnetVendorId_BENTROL_PTY_LTD:
		return "BENTROL_PTY_LTD"
	case BACnetVendorId_TEAM_CONTROL_OY:
		return "TEAM_CONTROL_OY"
	case BACnetVendorId_NEXT_DEVICELLC:
		return "NEXT_DEVICELLC"
	case BACnetVendorId_ISMACONTROLLI_SPA:
		return "ISMACONTROLLI_SPA"
	case BACnetVendorId_KINGI_ELECTRONICS_CO_LTD:
		return "KINGI_ELECTRONICS_CO_LTD"
	case BACnetVendorId_SAMDAV:
		return "SAMDAV"
	case BACnetVendorId_NEXT_GEN_INDUSTRIES_PVT_LTD:
		return "NEXT_GEN_INDUSTRIES_PVT_LTD"
	case BACnetVendorId_MITSUBISHI_HEAVY_INDUSTRIES_LTD:
		return "MITSUBISHI_HEAVY_INDUSTRIES_LTD"
	case BACnetVendorId_ENTICLLC:
		return "ENTICLLC"
	case BACnetVendorId_ETAP:
		return "ETAP"
	case BACnetVendorId_MORALLE_ELECTRONICS_LIMITED:
		return "MORALLE_ELECTRONICS_LIMITED"
	case BACnetVendorId_LEICOMAG:
		return "LEICOMAG"
	case BACnetVendorId_WATTS_REGULATOR_COMPANY:
		return "WATTS_REGULATOR_COMPANY"
	case BACnetVendorId_SC_ORBTRONICSSRL:
		return "SC_ORBTRONICSSRL"
	case BACnetVendorId_GAUSSAN_TECHNOLOGIES:
		return "GAUSSAN_TECHNOLOGIES"
	case BACnetVendorId_WE_BFACTORY_GMBH:
		return "WE_BFACTORY_GMBH"
	case BACnetVendorId_OCEAN_CONTROLS:
		return "OCEAN_CONTROLS"
	case BACnetVendorId_MESSANA_AIR_RAY_CONDITIONINGSRL:
		return "MESSANA_AIR_RAY_CONDITIONINGSRL"
	case BACnetVendorId_XYLEM_INC:
		return "XYLEM_INC"
	case BACnetVendorId_HANGZHOUBATOWN_TECHNOLOGY_CO_LTD:
		return "HANGZHOUBATOWN_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_REASONABLE_CONTROLS:
		return "REASONABLE_CONTROLS"
	case BACnetVendorId_SERVISYS_INC:
		return "SERVISYS_INC"
	case BACnetVendorId_HALSTRUPWALCHER_GMBH:
		return "HALSTRUPWALCHER_GMBH"
	case BACnetVendorId_SWG_AUTOMATION_FUZHOU_LIMITED:
		return "SWG_AUTOMATION_FUZHOU_LIMITED"
	case BACnetVendorId_KSB_AKTIENGESELLSCHAFT:
		return "KSB_AKTIENGESELLSCHAFT"
	case BACnetVendorId_HYBRYD_SPZOO:
		return "HYBRYD_SPZOO"
	case BACnetVendorId_HELVATRONAG:
		return "HELVATRONAG"
	case BACnetVendorId_ODERON_SPZOO:
		return "ODERON_SPZOO"
	case BACnetVendorId_MIKOLAB:
		return "MIKOLAB"
	case BACnetVendorId_YAMATAKE_BUILDING_SYSTEMS_CO_LTD:
		return "YAMATAKE_BUILDING_SYSTEMS_CO_LTD"
	case BACnetVendorId_EXODRAFT:
		return "EXODRAFT"
	case BACnetVendorId_HOCHHUTH_GMBH:
		return "HOCHHUTH_GMBH"
	case BACnetVendorId_INTEGRATED_SYSTEM_TECHNOLOGIES_LTD:
		return "INTEGRATED_SYSTEM_TECHNOLOGIES_LTD"
	case BACnetVendorId_SHANGHAI_CELLCONS_CONTROLS_CO_LTD:
		return "SHANGHAI_CELLCONS_CONTROLS_CO_LTD"
	case BACnetVendorId_EMME_CONTROLSLLC:
		return "EMME_CONTROLSLLC"
	case BACnetVendorId_FIELD_DIAGNOSTIC_SERVICES_INC:
		return "FIELD_DIAGNOSTIC_SERVICES_INC"
	case BACnetVendorId_GES_TEKNIKAS:
		return "GES_TEKNIKAS"
	case BACnetVendorId_GLOBAL_POWER_PRODUCTS_INC:
		return "GLOBAL_POWER_PRODUCTS_INC"
	case BACnetVendorId_OPTIONNV:
		return "OPTIONNV"
	case BACnetVendorId_BV_CONTROLAG:
		return "BV_CONTROLAG"
	case BACnetVendorId_THE_WATT_STOPPER_INC:
		return "THE_WATT_STOPPER_INC"
	case BACnetVendorId_SIGREN_ENGINEERINGAG:
		return "SIGREN_ENGINEERINGAG"
	case BACnetVendorId_SHANGHAI_JALTONE_TECHNOLOGY_CO_LTD:
		return "SHANGHAI_JALTONE_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_MAX_LINE_SOLUTIONS_LTD:
		return "MAX_LINE_SOLUTIONS_LTD"
	case BACnetVendorId_KRON_INSTRUMENTOS_ELTRICOS_LTDA:
		return "KRON_INSTRUMENTOS_ELTRICOS_LTDA"
	case BACnetVendorId_THERMO_MATRIX:
		return "THERMO_MATRIX"
	case BACnetVendorId_INFINITE_AUTOMATION_SYSTEMS_INC:
		return "INFINITE_AUTOMATION_SYSTEMS_INC"
	case BACnetVendorId_VANTAGE:
		return "VANTAGE"
	case BACnetVendorId_ELECON_MEASUREMENTS_PVT_LTD:
		return "ELECON_MEASUREMENTS_PVT_LTD"
	case BACnetVendorId_TBA:
		return "TBA"
	case BACnetVendorId_CARNES_COMPANY:
		return "CARNES_COMPANY"
	case BACnetVendorId_AICHI_TOKEI_DENKI_CO_LTD:
		return "AICHI_TOKEI_DENKI_CO_LTD"
	case BACnetVendorId_HARMAN_PROFESSIONAL:
		return "HARMAN_PROFESSIONAL"
	case BACnetVendorId_NENUTEC_ASIA_PACIFIC_PTE_LTD:
		return "NENUTEC_ASIA_PACIFIC_PTE_LTD"
	case BACnetVendorId_GIANV:
		return "GIANV"
	case BACnetVendorId_KEPWARE_TEHNOLOGIES:
		return "KEPWARE_TEHNOLOGIES"
	case BACnetVendorId_TEMPERATURE_ELECTRONICS_LTD:
		return "TEMPERATURE_ELECTRONICS_LTD"
	case BACnetVendorId_PACKET_POWER:
		return "PACKET_POWER"
	case BACnetVendorId_PROJECT_HAYSTACK_CORPORATION:
		return "PROJECT_HAYSTACK_CORPORATION"
	case BACnetVendorId_DEOS_CONTROLS_AMERICAS_INC:
		return "DEOS_CONTROLS_AMERICAS_INC"
	case BACnetVendorId_SENSEWARE_INC:
		return "SENSEWARE_INC"
	case BACnetVendorId_MST_SYSTEMTECHNIKAG:
		return "MST_SYSTEMTECHNIKAG"
	case BACnetVendorId_ACTIVATION_TECHNOLOGIESLLC:
		return "ACTIVATION_TECHNOLOGIESLLC"
	case BACnetVendorId_LONIX_LTD:
		return "LONIX_LTD"
	case BACnetVendorId_GOSSEN_METRAWATT_GMBH:
		return "GOSSEN_METRAWATT_GMBH"
	case BACnetVendorId_AVIOSYS_INTERNATIONAL_INC:
		return "AVIOSYS_INTERNATIONAL_INC"
	case BACnetVendorId_EFFICIENT_BUILDING_AUTOMATION_CORP:
		return "EFFICIENT_BUILDING_AUTOMATION_CORP"
	case BACnetVendorId_ACCUTRON_INSTRUMENTS_INC:
		return "ACCUTRON_INSTRUMENTS_INC"
	case BACnetVendorId_VERMONT_ENERGY_CONTROL_SYSTEMSLLC:
		return "VERMONT_ENERGY_CONTROL_SYSTEMSLLC"
	case BACnetVendorId_DCC_DYNAMICS:
		return "DCC_DYNAMICS"
	case BACnetVendorId_BEG_BRCK_ELECTRONIC_GMBH:
		return "BEG_BRCK_ELECTRONIC_GMBH"
	case BACnetVendorId_NGBS_HUNGARY_LTD:
		return "NGBS_HUNGARY_LTD"
	case BACnetVendorId_SAIA_BURGESS_CONTROLS_LTD:
		return "SAIA_BURGESS_CONTROLS_LTD"
	case BACnetVendorId_ILLUM_TECHNOLOGYLLC:
		return "ILLUM_TECHNOLOGYLLC"
	case BACnetVendorId_DELTA_CONTROLS_GERMANY_LIMITED:
		return "DELTA_CONTROLS_GERMANY_LIMITED"
	case BACnetVendorId_ST_SERVICE_TECHNIQUESA:
		return "ST_SERVICE_TECHNIQUESA"
	case BACnetVendorId_SIMPLE_SOFT:
		return "SIMPLE_SOFT"
	case BACnetVendorId_ALTAIR_ENGINEERING:
		return "ALTAIR_ENGINEERING"
	case BACnetVendorId_EZEN_SOLUTION_INC:
		return "EZEN_SOLUTION_INC"
	case BACnetVendorId_FUJITEC_CO_LTD:
		return "FUJITEC_CO_LTD"
	case BACnetVendorId_TERRALUX:
		return "TERRALUX"
	case BACnetVendorId_ANNICOM:
		return "ANNICOM"
	case BACnetVendorId_BIHL_WIEDEMANN_GMBH:
		return "BIHL_WIEDEMANN_GMBH"
	case BACnetVendorId_SIEMENS_SCHWEIZAG1:
		return "SIEMENS_SCHWEIZAG1"
	case BACnetVendorId_HITACHI_LTD:
		return "HITACHI_LTD"
	case BACnetVendorId_DRAPER_INC:
		return "DRAPER_INC"
	case BACnetVendorId_SCHCO_INTERNATIONALKG:
		return "SCHCO_INTERNATIONALKG"
	case BACnetVendorId_OTIS_ELEVATOR_COMPANY:
		return "OTIS_ELEVATOR_COMPANY"
	case BACnetVendorId_FIDELIX_OY:
		return "FIDELIX_OY"
	case BACnetVendorId_RAM_GMBH_MESSUND_REGELTECHNIK:
		return "RAM_GMBH_MESSUND_REGELTECHNIK"
	case BACnetVendorId_WEMS:
		return "WEMS"
	case BACnetVendorId_RAVEL_ELECTRONICS_PVT_LTD:
		return "RAVEL_ELECTRONICS_PVT_LTD"
	case BACnetVendorId_OMNI_MAGNI:
		return "OMNI_MAGNI"
	case BACnetVendorId_ECHELON:
		return "ECHELON"
	case BACnetVendorId_INTELLIMETER_CANADA_INC:
		return "INTELLIMETER_CANADA_INC"
	case BACnetVendorId_NOVAR_CORP_TREND_CONTROL_SYSTEMS_LTD:
		return "NOVAR_CORP_TREND_CONTROL_SYSTEMS_LTD"
	case BACnetVendorId_BITHOUSE_OY:
		return "BITHOUSE_OY"
	case BACnetVendorId_BUILD_PULSE:
		return "BUILD_PULSE"
	case BACnetVendorId_SHENZHEN1000_BUILDING_AUTOMATION_CO_LTD:
		return "SHENZHEN1000_BUILDING_AUTOMATION_CO_LTD"
	case BACnetVendorId_AED_ENGINEERING_GMBH:
		return "AED_ENGINEERING_GMBH"
	case BACnetVendorId_GNTNER_GMBH_COKG:
		return "GNTNER_GMBH_COKG"
	case BACnetVendorId_KN_XLOGIC:
		return "KN_XLOGIC"
	case BACnetVendorId_CIM_ENVIRONMENTAL_GROUP:
		return "CIM_ENVIRONMENTAL_GROUP"
	case BACnetVendorId_FLOW_CONTROL:
		return "FLOW_CONTROL"
	case BACnetVendorId_LUMEN_CACHE_INC:
		return "LUMEN_CACHE_INC"
	case BACnetVendorId_MITSUBISHI_ELECTRIC_LIGHTING_CORPORATION:
		return "MITSUBISHI_ELECTRIC_LIGHTING_CORPORATION"
	case BACnetVendorId_ECOSYSTEM:
		return "ECOSYSTEM"
	case BACnetVendorId_POTTER_ELECTRIC_SIGNAL_COMPANYLLC:
		return "POTTER_ELECTRIC_SIGNAL_COMPANYLLC"
	case BACnetVendorId_TYCO_FIRE_SECURITY_SPA:
		return "TYCO_FIRE_SECURITY_SPA"
	case BACnetVendorId_WATANABE_ELECTRIC_INDUSTRY_CO_LTD:
		return "WATANABE_ELECTRIC_INDUSTRY_CO_LTD"
	case BACnetVendorId_CAUSAM_ENERGY:
		return "CAUSAM_ENERGY"
	case BACnetVendorId_WTECAG:
		return "WTECAG"
	case BACnetVendorId_IMI_HYDRONIC_ENGINEERING_INTERNATIONALSA:
		return "IMI_HYDRONIC_ENGINEERING_INTERNATIONALSA"
	case BACnetVendorId_ARIGO_SOFTWARE:
		return "ARIGO_SOFTWARE"
	case BACnetVendorId_MSA_SAFETY1:
		return "MSA_SAFETY1"
	case BACnetVendorId_SMART_SOLUCOES_LTDAMERCATO:
		return "SMART_SOLUCOES_LTDAMERCATO"
	case BACnetVendorId_ARGUS_CONTROL_SYSTEMS_LTD:
		return "ARGUS_CONTROL_SYSTEMS_LTD"
	case BACnetVendorId_PIATRA_ENGINEERING:
		return "PIATRA_ENGINEERING"
	case BACnetVendorId_ODIN_AUTOMATION_SYSTEMSLLC:
		return "ODIN_AUTOMATION_SYSTEMSLLC"
	case BACnetVendorId_BELPARTSNV:
		return "BELPARTSNV"
	case BACnetVendorId_UABSALDA:
		return "UABSALDA"
	case BACnetVendorId_ALREIT_REGELTECHNIK_GMBH:
		return "ALREIT_REGELTECHNIK_GMBH"
	case BACnetVendorId_INGENIEURBROH_LERTES_GMBH_COKG:
		return "INGENIEURBROH_LERTES_GMBH_COKG"
	case BACnetVendorId_BREATHING_BUILDINGS:
		return "BREATHING_BUILDINGS"
	case BACnetVendorId_EWONSA:
		return "EWONSA"
	case BACnetVendorId_CAV_UFF_GIACOMO_CIMBERIO_SPA:
		return "CAV_UFF_GIACOMO_CIMBERIO_SPA"
	case BACnetVendorId_PKE_ELECTRONICSAG:
		return "PKE_ELECTRONICSAG"
	case BACnetVendorId_KYUKI_CORPORATION:
		return "KYUKI_CORPORATION"
	case BACnetVendorId_ALLEN:
		return "ALLEN"
	case BACnetVendorId_KASTLE_SYSTEMS:
		return "KASTLE_SYSTEMS"
	case BACnetVendorId_LOGICAL_ELECTRO_MECHANICALEM_SYSTEMS_INC:
		return "LOGICAL_ELECTRO_MECHANICALEM_SYSTEMS_INC"
	case BACnetVendorId_PP_KINETICS_INSTRUMENTSLLC:
		return "PP_KINETICS_INSTRUMENTSLLC"
	case BACnetVendorId_CATHEXIS_TECHNOLOGIES:
		return "CATHEXIS_TECHNOLOGIES"
	case BACnetVendorId_SYLOPSP_ZOOSPK:
		return "SYLOPSP_ZOOSPK"
	case BACnetVendorId_BRAUNS_CONTROL_GMBH:
		return "BRAUNS_CONTROL_GMBH"
	case BACnetVendorId_OMRONSOCIALSOLUTIONSCOLTD:
		return "OMRONSOCIALSOLUTIONSCOLTD"
	case BACnetVendorId_WILDEBOER_BAUTEILE_GMBH:
		return "WILDEBOER_BAUTEILE_GMBH"
	case BACnetVendorId_SHANGHAI_BIENS_TECHNOLOGIES_LTD:
		return "SHANGHAI_BIENS_TECHNOLOGIES_LTD"
	case BACnetVendorId_RICHARDS_ZETA_BUILDING_INTELLIGENCE_INC:
		return "RICHARDS_ZETA_BUILDING_INTELLIGENCE_INC"
	case BACnetVendorId_BEIJINGHZHY_TECHNOLOGY_CO_LTD:
		return "BEIJINGHZHY_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_BUILDING_CLOUDS:
		return "BUILDING_CLOUDS"
	case BACnetVendorId_THE_UNIVERSITYOF_SHEFFIELD_DEPARTMENTOF_ELECTRONICAND_ELECTRICAL_ENGINEERING:
		return "THE_UNIVERSITYOF_SHEFFIELD_DEPARTMENTOF_ELECTRONICAND_ELECTRICAL_ENGINEERING"
	case BACnetVendorId_FABTRONICS_AUSTRALIA_PTY_LTD:
		return "FABTRONICS_AUSTRALIA_PTY_LTD"
	case BACnetVendorId_SLAT:
		return "SLAT"
	case BACnetVendorId_SOFTWARE_MOTOR_CORPORATION:
		return "SOFTWARE_MOTOR_CORPORATION"
	case BACnetVendorId_ARMSTRONG_INTERNATIONAL_INC:
		return "ARMSTRONG_INTERNATIONAL_INC"
	case BACnetVendorId_STERIL_AIRE_INC:
		return "STERIL_AIRE_INC"
	case BACnetVendorId_INFINIQUE:
		return "INFINIQUE"
	case BACnetVendorId_ARCOM:
		return "ARCOM"
	case BACnetVendorId_SCIENTECHRD_INC:
		return "SCIENTECHRD_INC"
	case BACnetVendorId_ARGO_PERFORMANCE_LTD:
		return "ARGO_PERFORMANCE_LTD"
	case BACnetVendorId_DIALIGHT:
		return "DIALIGHT"
	case BACnetVendorId_IDEAL_TECHNICAL_SOLUTIONS:
		return "IDEAL_TECHNICAL_SOLUTIONS"
	case BACnetVendorId_NEUROBATAG:
		return "NEUROBATAG"
	case BACnetVendorId_NEYER_SOFTWARE_CONSULTINGLLC:
		return "NEYER_SOFTWARE_CONSULTINGLLC"
	case BACnetVendorId_SCADA_TECHNOLOGY_DEVELOPMENT_CO_LTD:
		return "SCADA_TECHNOLOGY_DEVELOPMENT_CO_LTD"
	case BACnetVendorId_DEMAND_LOGIC_LIMITED:
		return "DEMAND_LOGIC_LIMITED"
	case BACnetVendorId_GWA_GROUP_LIMITED:
		return "GWA_GROUP_LIMITED"
	case BACnetVendorId_OCCITALINE:
		return "OCCITALINE"
	case BACnetVendorId_NAO_DIGITAL_CO_LTD:
		return "NAO_DIGITAL_CO_LTD"
	case BACnetVendorId_VCI_CONTROLS_INC:
		return "VCI_CONTROLS_INC"
	case BACnetVendorId_SHENZHEN_CHANSLINK_NETWORK_TECHNOLOGY_CO_LTD:
		return "SHENZHEN_CHANSLINK_NETWORK_TECHNOLOGY_CO_LTD"
	case BACnetVendorId_SAMSUNG_ELECTRONICS_CO_LTD:
		return "SAMSUNG_ELECTRONICS_CO_LTD"
	case BACnetVendorId_MESA_LABORATORIES_INC:
		return "MESA_LABORATORIES_INC"
	case BACnetVendorId_FISCHER:
		return "FISCHER"
	case BACnetVendorId_OP_SYS_SOLUTIONS_LTD:
		return "OP_SYS_SOLUTIONS_LTD"
	case BACnetVendorId_ADVANCED_DEVICES_LIMITED:
		return "ADVANCED_DEVICES_LIMITED"
	case BACnetVendorId_CONDAIR:
		return "CONDAIR"
	case BACnetVendorId_INELCOM_INGENIERIA_ELECTRONICA_COMERCIALSA:
		return "INELCOM_INGENIERIA_ELECTRONICA_COMERCIALSA"
	case BACnetVendorId_GRID_POINT_INC:
		return "GRID_POINT_INC"
	case BACnetVendorId_ADF_TECHNOLOGIES_SDN_BHD:
		return "ADF_TECHNOLOGIES_SDN_BHD"
	case BACnetVendorId_TOSHIBA_CORPORATION:
		return "TOSHIBA_CORPORATION"
	case BACnetVendorId_EPM_INC:
		return "EPM_INC"
	case BACnetVendorId_LIGHTING_CONTROLS_LTD:
		return "LIGHTING_CONTROLS_LTD"
	case BACnetVendorId_PERIX_CONTROLS_LTD:
		return "PERIX_CONTROLS_LTD"
	case BACnetVendorId_AERCO_INTERNATIONAL_INC:
		return "AERCO_INTERNATIONAL_INC"
	case BACnetVendorId_KONE_INC:
		return "KONE_INC"
	case BACnetVendorId_ZIEHL_ABEGGSE:
		return "ZIEHL_ABEGGSE"
	case BACnetVendorId_ROBOTSA:
		return "ROBOTSA"
	case BACnetVendorId_OPTIGO_NETWORKS_INC:
		return "OPTIGO_NETWORKS_INC"
	case BACnetVendorId_OPENMOTICSBVBA:
		return "OPENMOTICSBVBA"
	case BACnetVendorId_METROPOLITAN_INDUSTRIES_INC:
		return "METROPOLITAN_INDUSTRIES_INC"
	case BACnetVendorId_MITSUBISHI_ELECTRIC_CORPORATION_AIR_CONDITIONING_REFRIGERATION_SYSTEMS_WORKS:
		return "MITSUBISHI_ELECTRIC_CORPORATION_AIR_CONDITIONING_REFRIGERATION_SYSTEMS_WORKS"
	case BACnetVendorId_HUAWEI_TECHNOLOGIES_CO_LTD:
		return "HUAWEI_TECHNOLOGIES_CO_LTD"
	case BACnetVendorId_DIGITAL_LUMENS_INC:
		return "DIGITAL_LUMENS_INC"
	case BACnetVendorId_VANTI:
		return "VANTI"
	case BACnetVendorId_CREE_LIGHTING:
		return "CREE_LIGHTING"
	case BACnetVendorId_RICHMOND_HEIGHTSSDNBHD:
		return "RICHMOND_HEIGHTSSDNBHD"
	case BACnetVendorId_PAYNE_SPARKMAN_LIGHTING_MANGEMENT:
		return "PAYNE_SPARKMAN_LIGHTING_MANGEMENT"
	case BACnetVendorId_ASHCROFT:
		return "ASHCROFT"
	case BACnetVendorId_JET_CONTROLS_CORP:
		return "JET_CONTROLS_CORP"
	case BACnetVendorId_ZUMTOBEL_LIGHTING_GMBH:
		return "ZUMTOBEL_LIGHTING_GMBH"
	}
	return fmt.Sprintf("Unknown(%v)", uint16(e))
}

func (e BACnetVendorId) String() string {
	return e.PLC4XEnumName()
}
