/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetLandingCallStatusCommandDestination is the corresponding interface of BACnetLandingCallStatusCommandDestination
type BACnetLandingCallStatusCommandDestination interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetLandingCallStatusCommand
	// GetDestination returns Destination (property field)
	GetDestination() BACnetContextTagUnsignedInteger
	// IsBACnetLandingCallStatusCommandDestination is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetLandingCallStatusCommandDestination()
	// CreateBuilder creates a BACnetLandingCallStatusCommandDestinationBuilder
	CreateBACnetLandingCallStatusCommandDestinationBuilder() BACnetLandingCallStatusCommandDestinationBuilder
}

// _BACnetLandingCallStatusCommandDestination is the data-structure of this message
type _BACnetLandingCallStatusCommandDestination struct {
	BACnetLandingCallStatusCommandContract
	Destination BACnetContextTagUnsignedInteger
}

var _ BACnetLandingCallStatusCommandDestination = (*_BACnetLandingCallStatusCommandDestination)(nil)
var _ BACnetLandingCallStatusCommandRequirements = (*_BACnetLandingCallStatusCommandDestination)(nil)

// NewBACnetLandingCallStatusCommandDestination factory function for _BACnetLandingCallStatusCommandDestination
func NewBACnetLandingCallStatusCommandDestination(peekedTagHeader BACnetTagHeader, destination BACnetContextTagUnsignedInteger) *_BACnetLandingCallStatusCommandDestination {
	if destination == nil {
		panic("destination of type BACnetContextTagUnsignedInteger for BACnetLandingCallStatusCommandDestination must not be nil")
	}
	_result := &_BACnetLandingCallStatusCommandDestination{
		BACnetLandingCallStatusCommandContract: NewBACnetLandingCallStatusCommand(peekedTagHeader),
		Destination:                            destination,
	}
	_result.BACnetLandingCallStatusCommandContract.(*_BACnetLandingCallStatusCommand)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetLandingCallStatusCommandDestinationBuilder is a builder for BACnetLandingCallStatusCommandDestination
type BACnetLandingCallStatusCommandDestinationBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(destination BACnetContextTagUnsignedInteger) BACnetLandingCallStatusCommandDestinationBuilder
	// WithDestination adds Destination (property field)
	WithDestination(BACnetContextTagUnsignedInteger) BACnetLandingCallStatusCommandDestinationBuilder
	// WithDestinationBuilder adds Destination (property field) which is build by the builder
	WithDestinationBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetLandingCallStatusCommandDestinationBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetLandingCallStatusCommandBuilder
	// Build builds the BACnetLandingCallStatusCommandDestination or returns an error if something is wrong
	Build() (BACnetLandingCallStatusCommandDestination, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetLandingCallStatusCommandDestination
}

// NewBACnetLandingCallStatusCommandDestinationBuilder() creates a BACnetLandingCallStatusCommandDestinationBuilder
func NewBACnetLandingCallStatusCommandDestinationBuilder() BACnetLandingCallStatusCommandDestinationBuilder {
	return &_BACnetLandingCallStatusCommandDestinationBuilder{_BACnetLandingCallStatusCommandDestination: new(_BACnetLandingCallStatusCommandDestination)}
}

type _BACnetLandingCallStatusCommandDestinationBuilder struct {
	*_BACnetLandingCallStatusCommandDestination

	parentBuilder *_BACnetLandingCallStatusCommandBuilder

	collectedErr []error
}

var _ (BACnetLandingCallStatusCommandDestinationBuilder) = (*_BACnetLandingCallStatusCommandDestinationBuilder)(nil)

func (b *_BACnetLandingCallStatusCommandDestinationBuilder) setParent(contract BACnetLandingCallStatusCommandContract) {
	b.BACnetLandingCallStatusCommandContract = contract
	contract.(*_BACnetLandingCallStatusCommand)._SubType = b._BACnetLandingCallStatusCommandDestination
}

func (b *_BACnetLandingCallStatusCommandDestinationBuilder) WithMandatoryFields(destination BACnetContextTagUnsignedInteger) BACnetLandingCallStatusCommandDestinationBuilder {
	return b.WithDestination(destination)
}

func (b *_BACnetLandingCallStatusCommandDestinationBuilder) WithDestination(destination BACnetContextTagUnsignedInteger) BACnetLandingCallStatusCommandDestinationBuilder {
	b.Destination = destination
	return b
}

func (b *_BACnetLandingCallStatusCommandDestinationBuilder) WithDestinationBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetLandingCallStatusCommandDestinationBuilder {
	builder := builderSupplier(b.Destination.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.Destination, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetLandingCallStatusCommandDestinationBuilder) Build() (BACnetLandingCallStatusCommandDestination, error) {
	if b.Destination == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'destination' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetLandingCallStatusCommandDestination.deepCopy(), nil
}

func (b *_BACnetLandingCallStatusCommandDestinationBuilder) MustBuild() BACnetLandingCallStatusCommandDestination {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetLandingCallStatusCommandDestinationBuilder) Done() BACnetLandingCallStatusCommandBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetLandingCallStatusCommandBuilder().(*_BACnetLandingCallStatusCommandBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetLandingCallStatusCommandDestinationBuilder) buildForBACnetLandingCallStatusCommand() (BACnetLandingCallStatusCommand, error) {
	return b.Build()
}

func (b *_BACnetLandingCallStatusCommandDestinationBuilder) DeepCopy() any {
	_copy := b.CreateBACnetLandingCallStatusCommandDestinationBuilder().(*_BACnetLandingCallStatusCommandDestinationBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetLandingCallStatusCommandDestinationBuilder creates a BACnetLandingCallStatusCommandDestinationBuilder
func (b *_BACnetLandingCallStatusCommandDestination) CreateBACnetLandingCallStatusCommandDestinationBuilder() BACnetLandingCallStatusCommandDestinationBuilder {
	if b == nil {
		return NewBACnetLandingCallStatusCommandDestinationBuilder()
	}
	return &_BACnetLandingCallStatusCommandDestinationBuilder{_BACnetLandingCallStatusCommandDestination: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetLandingCallStatusCommandDestination) GetParent() BACnetLandingCallStatusCommandContract {
	return m.BACnetLandingCallStatusCommandContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetLandingCallStatusCommandDestination) GetDestination() BACnetContextTagUnsignedInteger {
	return m.Destination
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetLandingCallStatusCommandDestination(structType any) BACnetLandingCallStatusCommandDestination {
	if casted, ok := structType.(BACnetLandingCallStatusCommandDestination); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetLandingCallStatusCommandDestination); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetLandingCallStatusCommandDestination) GetTypeName() string {
	return "BACnetLandingCallStatusCommandDestination"
}

func (m *_BACnetLandingCallStatusCommandDestination) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetLandingCallStatusCommandContract.(*_BACnetLandingCallStatusCommand).getLengthInBits(ctx))

	// Simple field (destination)
	lengthInBits += m.Destination.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetLandingCallStatusCommandDestination) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetLandingCallStatusCommandDestination) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetLandingCallStatusCommand) (__bACnetLandingCallStatusCommandDestination BACnetLandingCallStatusCommandDestination, err error) {
	m.BACnetLandingCallStatusCommandContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetLandingCallStatusCommandDestination"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetLandingCallStatusCommandDestination")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	destination, err := ReadSimpleField[BACnetContextTagUnsignedInteger](ctx, "destination", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(2)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'destination' field"))
	}
	m.Destination = destination

	if closeErr := readBuffer.CloseContext("BACnetLandingCallStatusCommandDestination"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetLandingCallStatusCommandDestination")
	}

	return m, nil
}

func (m *_BACnetLandingCallStatusCommandDestination) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetLandingCallStatusCommandDestination) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetLandingCallStatusCommandDestination"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetLandingCallStatusCommandDestination")
		}

		if err := WriteSimpleField[BACnetContextTagUnsignedInteger](ctx, "destination", m.GetDestination(), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'destination' field")
		}

		if popErr := writeBuffer.PopContext("BACnetLandingCallStatusCommandDestination"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetLandingCallStatusCommandDestination")
		}
		return nil
	}
	return m.BACnetLandingCallStatusCommandContract.(*_BACnetLandingCallStatusCommand).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetLandingCallStatusCommandDestination) IsBACnetLandingCallStatusCommandDestination() {}

func (m *_BACnetLandingCallStatusCommandDestination) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetLandingCallStatusCommandDestination) deepCopy() *_BACnetLandingCallStatusCommandDestination {
	if m == nil {
		return nil
	}
	_BACnetLandingCallStatusCommandDestinationCopy := &_BACnetLandingCallStatusCommandDestination{
		m.BACnetLandingCallStatusCommandContract.(*_BACnetLandingCallStatusCommand).deepCopy(),
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.Destination),
	}
	_BACnetLandingCallStatusCommandDestinationCopy.BACnetLandingCallStatusCommandContract.(*_BACnetLandingCallStatusCommand)._SubType = m
	return _BACnetLandingCallStatusCommandDestinationCopy
}

func (m *_BACnetLandingCallStatusCommandDestination) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
