/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataLimitMonitoringInterval is the corresponding interface of BACnetConstructedDataLimitMonitoringInterval
type BACnetConstructedDataLimitMonitoringInterval interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetLimitMonitoringInterval returns LimitMonitoringInterval (property field)
	GetLimitMonitoringInterval() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataLimitMonitoringInterval is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataLimitMonitoringInterval()
	// CreateBuilder creates a BACnetConstructedDataLimitMonitoringIntervalBuilder
	CreateBACnetConstructedDataLimitMonitoringIntervalBuilder() BACnetConstructedDataLimitMonitoringIntervalBuilder
}

// _BACnetConstructedDataLimitMonitoringInterval is the data-structure of this message
type _BACnetConstructedDataLimitMonitoringInterval struct {
	BACnetConstructedDataContract
	LimitMonitoringInterval BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataLimitMonitoringInterval = (*_BACnetConstructedDataLimitMonitoringInterval)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataLimitMonitoringInterval)(nil)

// NewBACnetConstructedDataLimitMonitoringInterval factory function for _BACnetConstructedDataLimitMonitoringInterval
func NewBACnetConstructedDataLimitMonitoringInterval(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, limitMonitoringInterval BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataLimitMonitoringInterval {
	if limitMonitoringInterval == nil {
		panic("limitMonitoringInterval of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataLimitMonitoringInterval must not be nil")
	}
	_result := &_BACnetConstructedDataLimitMonitoringInterval{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		LimitMonitoringInterval:       limitMonitoringInterval,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataLimitMonitoringIntervalBuilder is a builder for BACnetConstructedDataLimitMonitoringInterval
type BACnetConstructedDataLimitMonitoringIntervalBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(limitMonitoringInterval BACnetApplicationTagUnsignedInteger) BACnetConstructedDataLimitMonitoringIntervalBuilder
	// WithLimitMonitoringInterval adds LimitMonitoringInterval (property field)
	WithLimitMonitoringInterval(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataLimitMonitoringIntervalBuilder
	// WithLimitMonitoringIntervalBuilder adds LimitMonitoringInterval (property field) which is build by the builder
	WithLimitMonitoringIntervalBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataLimitMonitoringIntervalBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataLimitMonitoringInterval or returns an error if something is wrong
	Build() (BACnetConstructedDataLimitMonitoringInterval, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataLimitMonitoringInterval
}

// NewBACnetConstructedDataLimitMonitoringIntervalBuilder() creates a BACnetConstructedDataLimitMonitoringIntervalBuilder
func NewBACnetConstructedDataLimitMonitoringIntervalBuilder() BACnetConstructedDataLimitMonitoringIntervalBuilder {
	return &_BACnetConstructedDataLimitMonitoringIntervalBuilder{_BACnetConstructedDataLimitMonitoringInterval: new(_BACnetConstructedDataLimitMonitoringInterval)}
}

type _BACnetConstructedDataLimitMonitoringIntervalBuilder struct {
	*_BACnetConstructedDataLimitMonitoringInterval

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataLimitMonitoringIntervalBuilder) = (*_BACnetConstructedDataLimitMonitoringIntervalBuilder)(nil)

func (b *_BACnetConstructedDataLimitMonitoringIntervalBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataLimitMonitoringInterval
}

func (b *_BACnetConstructedDataLimitMonitoringIntervalBuilder) WithMandatoryFields(limitMonitoringInterval BACnetApplicationTagUnsignedInteger) BACnetConstructedDataLimitMonitoringIntervalBuilder {
	return b.WithLimitMonitoringInterval(limitMonitoringInterval)
}

func (b *_BACnetConstructedDataLimitMonitoringIntervalBuilder) WithLimitMonitoringInterval(limitMonitoringInterval BACnetApplicationTagUnsignedInteger) BACnetConstructedDataLimitMonitoringIntervalBuilder {
	b.LimitMonitoringInterval = limitMonitoringInterval
	return b
}

func (b *_BACnetConstructedDataLimitMonitoringIntervalBuilder) WithLimitMonitoringIntervalBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataLimitMonitoringIntervalBuilder {
	builder := builderSupplier(b.LimitMonitoringInterval.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.LimitMonitoringInterval, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataLimitMonitoringIntervalBuilder) Build() (BACnetConstructedDataLimitMonitoringInterval, error) {
	if b.LimitMonitoringInterval == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'limitMonitoringInterval' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataLimitMonitoringInterval.deepCopy(), nil
}

func (b *_BACnetConstructedDataLimitMonitoringIntervalBuilder) MustBuild() BACnetConstructedDataLimitMonitoringInterval {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataLimitMonitoringIntervalBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataLimitMonitoringIntervalBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataLimitMonitoringIntervalBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataLimitMonitoringIntervalBuilder().(*_BACnetConstructedDataLimitMonitoringIntervalBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataLimitMonitoringIntervalBuilder creates a BACnetConstructedDataLimitMonitoringIntervalBuilder
func (b *_BACnetConstructedDataLimitMonitoringInterval) CreateBACnetConstructedDataLimitMonitoringIntervalBuilder() BACnetConstructedDataLimitMonitoringIntervalBuilder {
	if b == nil {
		return NewBACnetConstructedDataLimitMonitoringIntervalBuilder()
	}
	return &_BACnetConstructedDataLimitMonitoringIntervalBuilder{_BACnetConstructedDataLimitMonitoringInterval: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataLimitMonitoringInterval) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataLimitMonitoringInterval) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_LIMIT_MONITORING_INTERVAL
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataLimitMonitoringInterval) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataLimitMonitoringInterval) GetLimitMonitoringInterval() BACnetApplicationTagUnsignedInteger {
	return m.LimitMonitoringInterval
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataLimitMonitoringInterval) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetLimitMonitoringInterval())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataLimitMonitoringInterval(structType any) BACnetConstructedDataLimitMonitoringInterval {
	if casted, ok := structType.(BACnetConstructedDataLimitMonitoringInterval); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataLimitMonitoringInterval); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataLimitMonitoringInterval) GetTypeName() string {
	return "BACnetConstructedDataLimitMonitoringInterval"
}

func (m *_BACnetConstructedDataLimitMonitoringInterval) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (limitMonitoringInterval)
	lengthInBits += m.LimitMonitoringInterval.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataLimitMonitoringInterval) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataLimitMonitoringInterval) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataLimitMonitoringInterval BACnetConstructedDataLimitMonitoringInterval, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataLimitMonitoringInterval"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataLimitMonitoringInterval")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	limitMonitoringInterval, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "limitMonitoringInterval", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'limitMonitoringInterval' field"))
	}
	m.LimitMonitoringInterval = limitMonitoringInterval

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), limitMonitoringInterval)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataLimitMonitoringInterval"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataLimitMonitoringInterval")
	}

	return m, nil
}

func (m *_BACnetConstructedDataLimitMonitoringInterval) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataLimitMonitoringInterval) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataLimitMonitoringInterval"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataLimitMonitoringInterval")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "limitMonitoringInterval", m.GetLimitMonitoringInterval(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'limitMonitoringInterval' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataLimitMonitoringInterval"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataLimitMonitoringInterval")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataLimitMonitoringInterval) IsBACnetConstructedDataLimitMonitoringInterval() {
}

func (m *_BACnetConstructedDataLimitMonitoringInterval) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataLimitMonitoringInterval) deepCopy() *_BACnetConstructedDataLimitMonitoringInterval {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataLimitMonitoringIntervalCopy := &_BACnetConstructedDataLimitMonitoringInterval{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.LimitMonitoringInterval),
	}
	_BACnetConstructedDataLimitMonitoringIntervalCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataLimitMonitoringIntervalCopy
}

func (m *_BACnetConstructedDataLimitMonitoringInterval) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
