/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataLandingCallControl is the corresponding interface of BACnetConstructedDataLandingCallControl
type BACnetConstructedDataLandingCallControl interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetLandingCallControl returns LandingCallControl (property field)
	GetLandingCallControl() BACnetLandingCallStatus
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetLandingCallStatus
	// IsBACnetConstructedDataLandingCallControl is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataLandingCallControl()
	// CreateBuilder creates a BACnetConstructedDataLandingCallControlBuilder
	CreateBACnetConstructedDataLandingCallControlBuilder() BACnetConstructedDataLandingCallControlBuilder
}

// _BACnetConstructedDataLandingCallControl is the data-structure of this message
type _BACnetConstructedDataLandingCallControl struct {
	BACnetConstructedDataContract
	LandingCallControl BACnetLandingCallStatus
}

var _ BACnetConstructedDataLandingCallControl = (*_BACnetConstructedDataLandingCallControl)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataLandingCallControl)(nil)

// NewBACnetConstructedDataLandingCallControl factory function for _BACnetConstructedDataLandingCallControl
func NewBACnetConstructedDataLandingCallControl(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, landingCallControl BACnetLandingCallStatus, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataLandingCallControl {
	if landingCallControl == nil {
		panic("landingCallControl of type BACnetLandingCallStatus for BACnetConstructedDataLandingCallControl must not be nil")
	}
	_result := &_BACnetConstructedDataLandingCallControl{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		LandingCallControl:            landingCallControl,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataLandingCallControlBuilder is a builder for BACnetConstructedDataLandingCallControl
type BACnetConstructedDataLandingCallControlBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(landingCallControl BACnetLandingCallStatus) BACnetConstructedDataLandingCallControlBuilder
	// WithLandingCallControl adds LandingCallControl (property field)
	WithLandingCallControl(BACnetLandingCallStatus) BACnetConstructedDataLandingCallControlBuilder
	// WithLandingCallControlBuilder adds LandingCallControl (property field) which is build by the builder
	WithLandingCallControlBuilder(func(BACnetLandingCallStatusBuilder) BACnetLandingCallStatusBuilder) BACnetConstructedDataLandingCallControlBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataLandingCallControl or returns an error if something is wrong
	Build() (BACnetConstructedDataLandingCallControl, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataLandingCallControl
}

// NewBACnetConstructedDataLandingCallControlBuilder() creates a BACnetConstructedDataLandingCallControlBuilder
func NewBACnetConstructedDataLandingCallControlBuilder() BACnetConstructedDataLandingCallControlBuilder {
	return &_BACnetConstructedDataLandingCallControlBuilder{_BACnetConstructedDataLandingCallControl: new(_BACnetConstructedDataLandingCallControl)}
}

type _BACnetConstructedDataLandingCallControlBuilder struct {
	*_BACnetConstructedDataLandingCallControl

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataLandingCallControlBuilder) = (*_BACnetConstructedDataLandingCallControlBuilder)(nil)

func (b *_BACnetConstructedDataLandingCallControlBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataLandingCallControl
}

func (b *_BACnetConstructedDataLandingCallControlBuilder) WithMandatoryFields(landingCallControl BACnetLandingCallStatus) BACnetConstructedDataLandingCallControlBuilder {
	return b.WithLandingCallControl(landingCallControl)
}

func (b *_BACnetConstructedDataLandingCallControlBuilder) WithLandingCallControl(landingCallControl BACnetLandingCallStatus) BACnetConstructedDataLandingCallControlBuilder {
	b.LandingCallControl = landingCallControl
	return b
}

func (b *_BACnetConstructedDataLandingCallControlBuilder) WithLandingCallControlBuilder(builderSupplier func(BACnetLandingCallStatusBuilder) BACnetLandingCallStatusBuilder) BACnetConstructedDataLandingCallControlBuilder {
	builder := builderSupplier(b.LandingCallControl.CreateBACnetLandingCallStatusBuilder())
	var err error
	b.LandingCallControl, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetLandingCallStatusBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataLandingCallControlBuilder) Build() (BACnetConstructedDataLandingCallControl, error) {
	if b.LandingCallControl == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'landingCallControl' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataLandingCallControl.deepCopy(), nil
}

func (b *_BACnetConstructedDataLandingCallControlBuilder) MustBuild() BACnetConstructedDataLandingCallControl {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataLandingCallControlBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataLandingCallControlBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataLandingCallControlBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataLandingCallControlBuilder().(*_BACnetConstructedDataLandingCallControlBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataLandingCallControlBuilder creates a BACnetConstructedDataLandingCallControlBuilder
func (b *_BACnetConstructedDataLandingCallControl) CreateBACnetConstructedDataLandingCallControlBuilder() BACnetConstructedDataLandingCallControlBuilder {
	if b == nil {
		return NewBACnetConstructedDataLandingCallControlBuilder()
	}
	return &_BACnetConstructedDataLandingCallControlBuilder{_BACnetConstructedDataLandingCallControl: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataLandingCallControl) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataLandingCallControl) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_LANDING_CALL_CONTROL
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataLandingCallControl) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataLandingCallControl) GetLandingCallControl() BACnetLandingCallStatus {
	return m.LandingCallControl
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataLandingCallControl) GetActualValue() BACnetLandingCallStatus {
	ctx := context.Background()
	_ = ctx
	return CastBACnetLandingCallStatus(m.GetLandingCallControl())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataLandingCallControl(structType any) BACnetConstructedDataLandingCallControl {
	if casted, ok := structType.(BACnetConstructedDataLandingCallControl); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataLandingCallControl); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataLandingCallControl) GetTypeName() string {
	return "BACnetConstructedDataLandingCallControl"
}

func (m *_BACnetConstructedDataLandingCallControl) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (landingCallControl)
	lengthInBits += m.LandingCallControl.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataLandingCallControl) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataLandingCallControl) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataLandingCallControl BACnetConstructedDataLandingCallControl, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataLandingCallControl"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataLandingCallControl")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	landingCallControl, err := ReadSimpleField[BACnetLandingCallStatus](ctx, "landingCallControl", ReadComplex[BACnetLandingCallStatus](BACnetLandingCallStatusParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'landingCallControl' field"))
	}
	m.LandingCallControl = landingCallControl

	actualValue, err := ReadVirtualField[BACnetLandingCallStatus](ctx, "actualValue", (*BACnetLandingCallStatus)(nil), landingCallControl)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataLandingCallControl"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataLandingCallControl")
	}

	return m, nil
}

func (m *_BACnetConstructedDataLandingCallControl) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataLandingCallControl) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataLandingCallControl"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataLandingCallControl")
		}

		if err := WriteSimpleField[BACnetLandingCallStatus](ctx, "landingCallControl", m.GetLandingCallControl(), WriteComplex[BACnetLandingCallStatus](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'landingCallControl' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataLandingCallControl"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataLandingCallControl")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataLandingCallControl) IsBACnetConstructedDataLandingCallControl() {}

func (m *_BACnetConstructedDataLandingCallControl) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataLandingCallControl) deepCopy() *_BACnetConstructedDataLandingCallControl {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataLandingCallControlCopy := &_BACnetConstructedDataLandingCallControl{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetLandingCallStatus](m.LandingCallControl),
	}
	_BACnetConstructedDataLandingCallControlCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataLandingCallControlCopy
}

func (m *_BACnetConstructedDataLandingCallControl) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
