/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetAddressBinding is the corresponding interface of BACnetAddressBinding
type BACnetAddressBinding interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetDeviceIdentifier returns DeviceIdentifier (property field)
	GetDeviceIdentifier() BACnetApplicationTagObjectIdentifier
	// GetDeviceAddress returns DeviceAddress (property field)
	GetDeviceAddress() BACnetAddress
	// IsBACnetAddressBinding is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetAddressBinding()
	// CreateBuilder creates a BACnetAddressBindingBuilder
	CreateBACnetAddressBindingBuilder() BACnetAddressBindingBuilder
}

// _BACnetAddressBinding is the data-structure of this message
type _BACnetAddressBinding struct {
	DeviceIdentifier BACnetApplicationTagObjectIdentifier
	DeviceAddress    BACnetAddress
}

var _ BACnetAddressBinding = (*_BACnetAddressBinding)(nil)

// NewBACnetAddressBinding factory function for _BACnetAddressBinding
func NewBACnetAddressBinding(deviceIdentifier BACnetApplicationTagObjectIdentifier, deviceAddress BACnetAddress) *_BACnetAddressBinding {
	if deviceIdentifier == nil {
		panic("deviceIdentifier of type BACnetApplicationTagObjectIdentifier for BACnetAddressBinding must not be nil")
	}
	if deviceAddress == nil {
		panic("deviceAddress of type BACnetAddress for BACnetAddressBinding must not be nil")
	}
	return &_BACnetAddressBinding{DeviceIdentifier: deviceIdentifier, DeviceAddress: deviceAddress}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetAddressBindingBuilder is a builder for BACnetAddressBinding
type BACnetAddressBindingBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(deviceIdentifier BACnetApplicationTagObjectIdentifier, deviceAddress BACnetAddress) BACnetAddressBindingBuilder
	// WithDeviceIdentifier adds DeviceIdentifier (property field)
	WithDeviceIdentifier(BACnetApplicationTagObjectIdentifier) BACnetAddressBindingBuilder
	// WithDeviceIdentifierBuilder adds DeviceIdentifier (property field) which is build by the builder
	WithDeviceIdentifierBuilder(func(BACnetApplicationTagObjectIdentifierBuilder) BACnetApplicationTagObjectIdentifierBuilder) BACnetAddressBindingBuilder
	// WithDeviceAddress adds DeviceAddress (property field)
	WithDeviceAddress(BACnetAddress) BACnetAddressBindingBuilder
	// WithDeviceAddressBuilder adds DeviceAddress (property field) which is build by the builder
	WithDeviceAddressBuilder(func(BACnetAddressBuilder) BACnetAddressBuilder) BACnetAddressBindingBuilder
	// Build builds the BACnetAddressBinding or returns an error if something is wrong
	Build() (BACnetAddressBinding, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetAddressBinding
}

// NewBACnetAddressBindingBuilder() creates a BACnetAddressBindingBuilder
func NewBACnetAddressBindingBuilder() BACnetAddressBindingBuilder {
	return &_BACnetAddressBindingBuilder{_BACnetAddressBinding: new(_BACnetAddressBinding)}
}

type _BACnetAddressBindingBuilder struct {
	*_BACnetAddressBinding

	collectedErr []error
}

var _ (BACnetAddressBindingBuilder) = (*_BACnetAddressBindingBuilder)(nil)

func (b *_BACnetAddressBindingBuilder) WithMandatoryFields(deviceIdentifier BACnetApplicationTagObjectIdentifier, deviceAddress BACnetAddress) BACnetAddressBindingBuilder {
	return b.WithDeviceIdentifier(deviceIdentifier).WithDeviceAddress(deviceAddress)
}

func (b *_BACnetAddressBindingBuilder) WithDeviceIdentifier(deviceIdentifier BACnetApplicationTagObjectIdentifier) BACnetAddressBindingBuilder {
	b.DeviceIdentifier = deviceIdentifier
	return b
}

func (b *_BACnetAddressBindingBuilder) WithDeviceIdentifierBuilder(builderSupplier func(BACnetApplicationTagObjectIdentifierBuilder) BACnetApplicationTagObjectIdentifierBuilder) BACnetAddressBindingBuilder {
	builder := builderSupplier(b.DeviceIdentifier.CreateBACnetApplicationTagObjectIdentifierBuilder())
	var err error
	b.DeviceIdentifier, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_BACnetAddressBindingBuilder) WithDeviceAddress(deviceAddress BACnetAddress) BACnetAddressBindingBuilder {
	b.DeviceAddress = deviceAddress
	return b
}

func (b *_BACnetAddressBindingBuilder) WithDeviceAddressBuilder(builderSupplier func(BACnetAddressBuilder) BACnetAddressBuilder) BACnetAddressBindingBuilder {
	builder := builderSupplier(b.DeviceAddress.CreateBACnetAddressBuilder())
	var err error
	b.DeviceAddress, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetAddressBuilder failed"))
	}
	return b
}

func (b *_BACnetAddressBindingBuilder) Build() (BACnetAddressBinding, error) {
	if b.DeviceIdentifier == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'deviceIdentifier' not set"))
	}
	if b.DeviceAddress == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'deviceAddress' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetAddressBinding.deepCopy(), nil
}

func (b *_BACnetAddressBindingBuilder) MustBuild() BACnetAddressBinding {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetAddressBindingBuilder) DeepCopy() any {
	_copy := b.CreateBACnetAddressBindingBuilder().(*_BACnetAddressBindingBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetAddressBindingBuilder creates a BACnetAddressBindingBuilder
func (b *_BACnetAddressBinding) CreateBACnetAddressBindingBuilder() BACnetAddressBindingBuilder {
	if b == nil {
		return NewBACnetAddressBindingBuilder()
	}
	return &_BACnetAddressBindingBuilder{_BACnetAddressBinding: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetAddressBinding) GetDeviceIdentifier() BACnetApplicationTagObjectIdentifier {
	return m.DeviceIdentifier
}

func (m *_BACnetAddressBinding) GetDeviceAddress() BACnetAddress {
	return m.DeviceAddress
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetAddressBinding(structType any) BACnetAddressBinding {
	if casted, ok := structType.(BACnetAddressBinding); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetAddressBinding); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetAddressBinding) GetTypeName() string {
	return "BACnetAddressBinding"
}

func (m *_BACnetAddressBinding) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (deviceIdentifier)
	lengthInBits += m.DeviceIdentifier.GetLengthInBits(ctx)

	// Simple field (deviceAddress)
	lengthInBits += m.DeviceAddress.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetAddressBinding) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetAddressBindingParse(ctx context.Context, theBytes []byte) (BACnetAddressBinding, error) {
	return BACnetAddressBindingParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetAddressBindingParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetAddressBinding, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetAddressBinding, error) {
		return BACnetAddressBindingParseWithBuffer(ctx, readBuffer)
	}
}

func BACnetAddressBindingParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetAddressBinding, error) {
	v, err := (&_BACnetAddressBinding{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetAddressBinding) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetAddressBinding BACnetAddressBinding, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetAddressBinding"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetAddressBinding")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	deviceIdentifier, err := ReadSimpleField[BACnetApplicationTagObjectIdentifier](ctx, "deviceIdentifier", ReadComplex[BACnetApplicationTagObjectIdentifier](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagObjectIdentifier](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'deviceIdentifier' field"))
	}
	m.DeviceIdentifier = deviceIdentifier

	deviceAddress, err := ReadSimpleField[BACnetAddress](ctx, "deviceAddress", ReadComplex[BACnetAddress](BACnetAddressParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'deviceAddress' field"))
	}
	m.DeviceAddress = deviceAddress

	if closeErr := readBuffer.CloseContext("BACnetAddressBinding"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetAddressBinding")
	}

	return m, nil
}

func (m *_BACnetAddressBinding) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetAddressBinding) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetAddressBinding"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetAddressBinding")
	}

	if err := WriteSimpleField[BACnetApplicationTagObjectIdentifier](ctx, "deviceIdentifier", m.GetDeviceIdentifier(), WriteComplex[BACnetApplicationTagObjectIdentifier](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'deviceIdentifier' field")
	}

	if err := WriteSimpleField[BACnetAddress](ctx, "deviceAddress", m.GetDeviceAddress(), WriteComplex[BACnetAddress](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'deviceAddress' field")
	}

	if popErr := writeBuffer.PopContext("BACnetAddressBinding"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetAddressBinding")
	}
	return nil
}

func (m *_BACnetAddressBinding) IsBACnetAddressBinding() {}

func (m *_BACnetAddressBinding) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetAddressBinding) deepCopy() *_BACnetAddressBinding {
	if m == nil {
		return nil
	}
	_BACnetAddressBindingCopy := &_BACnetAddressBinding{
		utils.DeepCopy[BACnetApplicationTagObjectIdentifier](m.DeviceIdentifier),
		utils.DeepCopy[BACnetAddress](m.DeviceAddress),
	}
	return _BACnetAddressBindingCopy
}

func (m *_BACnetAddressBinding) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
