/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import * as React from 'react';
import SvgIcon, { SvgIconProps } from '@material-ui/core/SvgIcon';

export default (props: SvgIconProps) => (
  <SvgIcon style={{ width: 24, height: 24, verticalAlign: 'middle' }} viewBox="0 0 100 100" fill="none" {...props}>
    <path d="M50,4.8C75,4.8,95.3,25,95.3,50C95.3,75,75,95.3,50,95.3C25,95.3,4.8,75,4.8,50C4.8,25,25,4.8,50,4.8 M50,0
      C22.4,0,0,22.4,0,50s22.4,50,50,50s50-22.4,50-50S77.6,0,50,0L50,0z"
    />
    <path d="M31.5,33.9c-0.2,1.7,0.1,3.5-0.1,5.2c-0.1,1.7-0.3,3.4-0.7,5.2c-0.5,2.4-2,4.3-4.1,5.8c4.1,2.7,4.5,6.8,4.8,10.9
      c0.1,2.3,0.1,4.5,0.3,6.8c0.2,1.7,0.8,2.2,2.6,2.2c0.7,0,1.5,0,2.3,0v5.3c-5.3,0.9-9.7-0.6-10.7-5.1c-0.3-1.6-0.6-3.3-0.7-5
      c-0.1-1.8,0.1-3.6-0.1-5.4c-0.4-4.9-1-6.6-5.7-6.8V47c0.3-0.1,0.7-0.1,1-0.2c2.6-0.1,3.7-0.9,4.2-3.5c0.3-1.4,0.4-2.9,0.5-4.3
      c0.2-2.8,0.1-5.6,0.6-8.4c0.7-4,3.1-5.9,7.2-6.1c1.2-0.1,2.3,0,3.7,0V30c-0.6,0-1,0.1-1.5,0.1C31.9,29.9,31.8,31.1,31.5,33.9z
      M37.9,46.5L37.9,46.5c-2-0.1-3.7,1.4-3.8,3.3c-0.1,1.9,1.4,3.6,3.3,3.7h0.2c1.9,0.1,3.5-1.3,3.7-3.3v-0.2
      C41.4,48.1,39.9,46.6,37.9,46.5z M50,46.5c-1.9-0.1-3.4,1.4-3.5,3.3c0,0.1,0,0.2,0,0.3c0,2.1,1.4,3.4,3.6,3.4
      c2.1,0,3.4-1.4,3.4-3.6C53.5,47.9,52.1,46.5,50,46.5z M62.3,46.5c-2,0-3.6,1.5-3.7,3.5c0,2,1.6,3.5,3.5,3.5h0
      c1.8,0.3,3.6-1.4,3.7-3.5C66,48.2,64.3,46.5,62.3,46.5z M79.3,46.8c-2.2-0.1-3.3-0.8-3.9-3c-0.3-1.3-0.6-2.8-0.6-4.1
      c-0.2-2.6-0.1-5.2-0.3-7.8c-0.4-6.1-4.8-8.3-11.3-7.2v5.3c1,0,1.8,0,2.6,0c1.4,0,2.4,0.5,2.5,2.1c0.1,1.4,0.1,2.8,0.3,4.2
      c0.3,2.8,0.4,5.6,0.9,8.4c0.4,2.3,2,4,3.9,5.3c-3.4,2.3-4.4,5.6-4.6,9.2c-0.1,2.5-0.2,5.1-0.3,7.6c-0.1,2.3-0.9,3.1-3.3,3.1
      c-0.7,0-1.3,0.1-2,0.1v5.4c1.4,0,2.6,0.1,3.9,0c3.9-0.2,6.2-2.1,7-5.9c0.3-2.1,0.5-4.2,0.6-6.3c0.1-1.9,0.1-3.9,0.3-5.8
      c0.3-3,1.7-4.2,4.6-4.4c0.3,0,0.6-0.1,0.8-0.2v-6.1C80,46.9,79.6,46.8,79.3,46.8z"
    />
  </SvgIcon>
);
