/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import * as React from 'react';
import SvgIcon, { SvgIconProps } from '@material-ui/core/SvgIcon';

export default (props: SvgIconProps) => (
  <SvgIcon style={{ width: 24, height: 24, verticalAlign: 'middle' }} viewBox="0 0 512 512" fill="none" {...props}>
    <g>
      <path d="m63.623 367.312h-62.815v144.688h148.689v-116.926h-68.752zm55.971 114.786h-88.884v-84.883h16.222l17.123 27.761h55.539z" />
      <path d="m244.47 367.312h-62.815v144.688h148.689v-116.926h-68.751zm55.972 114.786h-88.884v-84.883h16.222l17.123 27.761h55.539z" />
      <path d="m442.44 395.074-17.122-27.761h-62.815v144.687h148.689v-116.926zm38.85 87.024h-88.884v-84.883h16.222l17.122 27.761h55.54z" />
      <path d="m90.104 292.958h150.945v42.267h29.902v-42.267h150.945v42.267h29.902v-72.169h-180.847v-64.555h80.049c31.767 0 57.612-25.926 57.612-57.793 0-26.955-18.608-49.646-43.653-55.903-4.476-22.152-24.093-38.882-47.545-38.882-1.967 0-3.917.116-5.842.347-4.829-26.287-27.911-46.27-55.572-46.27s-50.744 19.983-55.572 46.269c-1.925-.23-3.876-.347-5.843-.347-23.452 0-43.069 16.73-47.544 38.882-25.044 6.256-43.653 28.948-43.653 55.903 0 31.867 25.844 57.793 57.612 57.793h80.049v64.555h-180.848v72.169h29.902v-42.266zm70.896-124.36c-15.279 0-27.709-12.511-27.709-27.891 0-15.279 12.43-27.71 27.709-27.71h15.971c-1.22-3.119-1.897-6.511-1.897-10.063 0-15.266 12.375-27.641 27.641-27.641 12.773 0 23.517 8.666 26.687 20.438v-39.232c0-14.665 11.932-26.596 26.597-26.596s26.597 11.931 26.597 26.596v39.233c3.17-11.772 13.914-20.438 26.687-20.438 15.266 0 27.642 12.375 27.642 27.641 0 3.552-.677 6.943-1.897 10.063h15.972c15.279 0 27.709 12.431 27.709 27.71 0 15.379-12.43 27.891-27.709 27.891h-190z" />
    </g>
  </SvgIcon>
);
