/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFUnixTimeStampLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFUnixTimeStampString;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.io.LongWritable;

@Description(name="to_unix_timestamp", value="_FUNC_(date[, pattern]) - Returns the UNIX timestamp", extended="Converts the specified time to number of seconds since 1970-01-01.")
@VectorizedExpressions(value={VectorUDFUnixTimeStampLong.class, VectorUDFUnixTimeStampString.class})
public class GenericUDFToUnixTimeStamp
extends GenericUDF {
    private transient DateObjectInspector inputDateOI;
    private transient TimestampObjectInspector inputTimestampOI;
    private transient ObjectInspectorConverters.Converter inputTextConverter;
    private transient ObjectInspectorConverters.Converter patternConverter;
    private transient String lasPattern = "yyyy-MM-dd HH:mm:ss";
    private final transient SimpleDateFormat formatter = new SimpleDateFormat(this.lasPattern);
    protected final transient LongWritable retValue = new LongWritable();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.initializeInput(arguments);
        return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
    }

    protected void initializeInput(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 1) {
            throw new UDFArgumentLengthException("The function " + this.getName().toUpperCase() + "requires at least one argument");
        }
        for (ObjectInspector argument : arguments) {
            if (arguments[0].getCategory() == ObjectInspector.Category.PRIMITIVE) continue;
            throw new UDFArgumentException(this.getName().toUpperCase() + " only takes string/date/timestamp types, got " + argument.getTypeName());
        }
        PrimitiveObjectInspector arg1OI = (PrimitiveObjectInspector)arguments[0];
        switch (arg1OI.getPrimitiveCategory()) {
            case CHAR: 
            case VARCHAR: 
            case STRING: {
                this.inputTextConverter = ObjectInspectorConverters.getConverter((ObjectInspector)arg1OI, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
                if (arguments.length <= 1) break;
                PrimitiveObjectInspector arg2OI = (PrimitiveObjectInspector)arguments[1];
                if (PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)arg2OI.getPrimitiveCategory()) != PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP) {
                    throw new UDFArgumentException("The time pattern for " + this.getName().toUpperCase() + " should be string type");
                }
                this.patternConverter = ObjectInspectorConverters.getConverter((ObjectInspector)arg2OI, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
                break;
            }
            case DATE: {
                this.inputDateOI = (DateObjectInspector)arguments[0];
                break;
            }
            case TIMESTAMP: {
                this.inputTimestampOI = (TimestampObjectInspector)arguments[0];
                break;
            }
            default: {
                throw new UDFArgumentException("The function " + this.getName().toUpperCase() + " takes only string/date/timestamp types");
            }
        }
    }

    protected String getName() {
        return "to_unix_timestamp";
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments[0].get() == null) {
            return null;
        }
        if (this.inputTextConverter != null) {
            String textVal = (String)this.inputTextConverter.convert(arguments[0].get());
            if (textVal == null) {
                return null;
            }
            if (this.patternConverter != null) {
                if (arguments[1].get() == null) {
                    return null;
                }
                String patternVal = (String)this.patternConverter.convert(arguments[1].get());
                if (patternVal == null) {
                    return null;
                }
                if (!patternVal.equals(this.lasPattern)) {
                    this.formatter.applyPattern(patternVal);
                    this.lasPattern = patternVal;
                }
            }
            try {
                this.retValue.set(this.formatter.parse(textVal).getTime() / 1000L);
                return this.retValue;
            }
            catch (ParseException e) {
                return null;
            }
        }
        if (this.inputDateOI != null) {
            this.retValue.set(this.inputDateOI.getPrimitiveWritableObject(arguments[0].get()).getTimeInSeconds());
            return this.retValue;
        }
        Timestamp timestamp = this.inputTimestampOI.getPrimitiveJavaObject(arguments[0].get());
        this.retValue.set(timestamp.getTime() / 1000L);
        return this.retValue;
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder(32);
        sb.append(this.getName());
        sb.append('(');
        sb.append(StringUtils.join((Object[])children, (char)','));
        sb.append(')');
        return sb.toString();
    }
}

