/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.LeadLagInfo;
import org.apache.hadoop.hive.ql.parse.WindowingExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.PTFExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PTFInputDef;
import org.apache.hadoop.hive.ql.plan.ptf.PTFQueryInputDef;
import org.apache.hadoop.hive.ql.plan.ptf.PartitionedTableFunctionDef;
import org.apache.hadoop.hive.ql.plan.ptf.ShapeDetails;
import org.apache.hadoop.hive.ql.plan.ptf.ValueBoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFunctionDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowTableFunctionDef;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLeadLag;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionEvaluator;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionResolver;
import org.apache.hadoop.hive.ql.udf.ptf.WindowingTableFunction;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.util.ReflectionUtils;

public class PTFDeserializer {
    PTFDesc ptfDesc;
    StructObjectInspector inputOI;
    Configuration hConf;
    LeadLagInfo llInfo;

    public PTFDeserializer(PTFDesc ptfDesc, StructObjectInspector inputOI, Configuration hConf) {
        this.ptfDesc = ptfDesc;
        ptfDesc.setCfg(hConf);
        this.inputOI = inputOI;
        this.hConf = hConf;
        this.llInfo = new LeadLagInfo();
        ptfDesc.setLlInfo(this.llInfo);
    }

    public void initializePTFChain(PartitionedTableFunctionDef tblFnDef) throws HiveException {
        PTFInputDef currentDef;
        ArrayDeque<PartitionedTableFunctionDef> ptfChain = new ArrayDeque<PartitionedTableFunctionDef>();
        for (currentDef = tblFnDef; currentDef != null; currentDef = ((PTFInputDef)currentDef).getInput()) {
            ptfChain.push((PartitionedTableFunctionDef)currentDef);
        }
        while (!ptfChain.isEmpty()) {
            currentDef = (PTFInputDef)ptfChain.pop();
            if (currentDef instanceof PTFQueryInputDef) {
                this.initialize((PTFQueryInputDef)currentDef, this.inputOI);
                continue;
            }
            if (currentDef instanceof WindowTableFunctionDef) {
                this.initializeWindowing((WindowTableFunctionDef)currentDef);
                continue;
            }
            this.initialize((PartitionedTableFunctionDef)currentDef);
        }
        PTFDeserializer.alterOutputOIForStreaming(this.ptfDesc);
    }

    public void initializeWindowing(WindowTableFunctionDef def) throws HiveException {
        ShapeDetails inpShape = def.getInput().getOutputShape();
        TableFunctionEvaluator tEval = def.getTFunction();
        WindowingTableFunction.WindowingTableFunctionResolver tResolver = (WindowingTableFunction.WindowingTableFunctionResolver)this.constructResolver(def.getResolverClassName());
        tResolver.initialize(this.ptfDesc, def, tEval);
        for (WindowFunctionDef wFnDef : def.getWindowFunctions()) {
            if (wFnDef.getArgs() != null) {
                for (PTFExpressionDef arg : wFnDef.getArgs()) {
                    this.initialize(arg, inpShape);
                }
            }
            if (wFnDef.getWindowFrame() != null) {
                WindowFrameDef wFrmDef = wFnDef.getWindowFrame();
                this.initialize(wFrmDef.getStart(), inpShape);
                this.initialize(wFrmDef.getEnd(), inpShape);
            }
            PTFDeserializer.setupWdwFnEvaluator(wFnDef);
        }
        ArrayList<String> aliases = new ArrayList<String>();
        ArrayList<ObjectInspector> fieldOIs = new ArrayList<ObjectInspector>();
        for (WindowFunctionDef wFnDef : def.getWindowFunctions()) {
            aliases.add(wFnDef.getAlias());
            if (wFnDef.isPivotResult()) {
                fieldOIs.add(((ListObjectInspector)wFnDef.getOI()).getListElementObjectInspector());
                continue;
            }
            fieldOIs.add(wFnDef.getOI());
        }
        PTFDeserializer.addInputColumnsToList(inpShape, aliases, fieldOIs);
        StandardStructObjectInspector wdwOutOI = ObjectInspectorFactory.getStandardStructObjectInspector(aliases, fieldOIs);
        tResolver.setWdwProcessingOutputOI((StructObjectInspector)wdwOutOI);
        this.initialize(def.getOutputShape(), (StructObjectInspector)wdwOutOI);
        tResolver.initializeOutputOI();
    }

    protected void initialize(PTFQueryInputDef def, StructObjectInspector OI) throws HiveException {
        ShapeDetails outShape = def.getOutputShape();
        this.initialize(outShape, OI);
    }

    protected void initialize(PartitionedTableFunctionDef def) throws HiveException {
        ShapeDetails inpShape = def.getInput().getOutputShape();
        if (def.getArgs() != null) {
            for (PTFExpressionDef arg : def.getArgs()) {
                this.initialize(arg, inpShape);
            }
        }
        TableFunctionEvaluator tEval = def.getTFunction();
        TableFunctionResolver tResolver = this.constructResolver(def.getResolverClassName());
        tResolver.initialize(this.ptfDesc, def, tEval);
        if (tEval.isTransformsRawInput()) {
            tResolver.initializeRawInputOI();
            this.initialize(def.getRawInputShape(), tEval.getRawInputOI());
        } else {
            def.setRawInputShape(inpShape);
        }
        inpShape = def.getRawInputShape();
        tResolver.initializeOutputOI();
        this.initialize(def.getOutputShape(), tEval.getOutputOI());
    }

    static void setupWdwFnEvaluator(WindowFunctionDef def) throws HiveException {
        List<PTFExpressionDef> args = def.getArgs();
        ArrayList<ObjectInspector> argOIs = new ArrayList<ObjectInspector>();
        ObjectInspector[] funcArgOIs = null;
        if (args != null) {
            for (PTFExpressionDef arg : args) {
                argOIs.add(arg.getOI());
            }
            funcArgOIs = new ObjectInspector[args.size()];
            funcArgOIs = argOIs.toArray(funcArgOIs);
        }
        GenericUDAFEvaluator wFnEval = def.getWFnEval();
        ObjectInspector OI = wFnEval.init(GenericUDAFEvaluator.Mode.COMPLETE, funcArgOIs);
        def.setWFnEval(wFnEval);
        def.setOI(OI);
    }

    protected void initialize(BoundaryDef def, ShapeDetails inpShape) throws HiveException {
        if (def instanceof ValueBoundaryDef) {
            ValueBoundaryDef vDef = (ValueBoundaryDef)def;
            this.initialize(vDef.getExpressionDef(), inpShape);
        }
    }

    protected void initialize(PTFExpressionDef eDef, ShapeDetails inpShape) throws HiveException {
        ExprNodeDesc exprNode = eDef.getExprNode();
        ExprNodeEvaluator exprEval = WindowingExprNodeEvaluatorFactory.get(this.llInfo, exprNode);
        ObjectInspector oi = this.initExprNodeEvaluator(exprEval, exprNode, inpShape);
        eDef.setExprEvaluator(exprEval);
        eDef.setOI(oi);
    }

    private ObjectInspector initExprNodeEvaluator(ExprNodeEvaluator exprEval, ExprNodeDesc exprNode, ShapeDetails inpShape) throws HiveException {
        ObjectInspector outOI = exprEval.initialize((ObjectInspector)inpShape.getOI());
        List<ExprNodeGenericFuncDesc> llFuncExprs = this.llInfo.getLLFuncExprsInTopExpr(exprNode);
        if (llFuncExprs != null) {
            for (ExprNodeGenericFuncDesc llFuncExpr : llFuncExprs) {
                ExprNodeDesc firstArg = llFuncExpr.getChildren().get(0);
                ExprNodeEvaluator dupExprEval = WindowingExprNodeEvaluatorFactory.get(this.llInfo, firstArg);
                dupExprEval.initialize((ObjectInspector)inpShape.getOI());
                GenericUDFLeadLag llFn = (GenericUDFLeadLag)llFuncExpr.getGenericUDF();
                llFn.setExprEvaluator(dupExprEval);
            }
        }
        return outOI;
    }

    protected void initialize(ShapeDetails shp, StructObjectInspector OI) throws HiveException {
        String serdeClassName = shp.getSerdeClassName();
        Properties serDeProps = new Properties();
        LinkedHashMap<String, String> serdePropsMap = new LinkedHashMap<String, String>();
        PTFDeserializer.addOIPropertiestoSerDePropsMap(OI, serdePropsMap);
        for (String serdeName : serdePropsMap.keySet()) {
            serDeProps.setProperty(serdeName, (String)serdePropsMap.get(serdeName));
        }
        try {
            SerDe serDe = (SerDe)ReflectionUtils.newInstance(this.hConf.getClassByName(serdeClassName).asSubclass(SerDe.class), (Configuration)this.hConf);
            SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)this.hConf, (Properties)serDeProps, null);
            shp.setSerde(serDe);
            StructObjectInspector outOI = PTFPartition.setupPartitionOutputOI(serDe, OI);
            shp.setOI(outOI);
        }
        catch (Exception se) {
            throw new HiveException(se);
        }
    }

    private static void addInputColumnsToList(ShapeDetails shape, ArrayList<String> fieldNames, ArrayList<ObjectInspector> fieldOIs) {
        StructObjectInspector OI = shape.getOI();
        for (StructField f : OI.getAllStructFieldRefs()) {
            fieldNames.add(f.getFieldName());
            fieldOIs.add(f.getFieldObjectInspector());
        }
    }

    private TableFunctionResolver constructResolver(String className) throws HiveException {
        try {
            Class rCls = JavaUtils.loadClass((String)className);
            return (TableFunctionResolver)ReflectionUtils.newInstance((Class)rCls, null);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public static void addOIPropertiestoSerDePropsMap(StructObjectInspector OI, Map<String, String> serdePropsMap) {
        if (serdePropsMap == null) {
            return;
        }
        ArrayList<? extends Object>[] tInfo = PTFDeserializer.getTypeMap(OI);
        ArrayList<? extends Object> columnNames = tInfo[0];
        ArrayList<? extends Object> fields = tInfo[1];
        StringBuilder cNames = new StringBuilder();
        StringBuilder cTypes = new StringBuilder();
        for (int i = 0; i < fields.size(); ++i) {
            cNames.append(i > 0 ? "," : "");
            cTypes.append(i > 0 ? "," : "");
            cNames.append((String)columnNames.get(i));
            cTypes.append(((TypeInfo)fields.get(i)).getTypeName());
        }
        serdePropsMap.put("columns", cNames.toString());
        serdePropsMap.put("columns.types", cTypes.toString());
    }

    private static ArrayList<? extends Object>[] getTypeMap(StructObjectInspector oi) {
        StructTypeInfo t = (StructTypeInfo)TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)oi);
        ArrayList fnames = t.getAllStructFieldNames();
        ArrayList fields = t.getAllStructFieldTypeInfos();
        return new ArrayList[]{fnames, fields};
    }

    public static void alterOutputOIForStreaming(PTFDesc ptfDesc) {
        PartitionedTableFunctionDef tDef = ptfDesc.getFuncDef();
        TableFunctionEvaluator tEval = tDef.getTFunction();
        if (tEval.canIterateOutput()) {
            tDef.getOutputShape().setOI(tEval.getOutputOI());
        }
    }
}

