/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.spark;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.spark.GenSparkProcContext;
import org.apache.hadoop.hive.ql.parse.spark.GenSparkUtils;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.SparkEdgeProperty;
import org.apache.hadoop.hive.ql.plan.SparkWork;

public class GenSparkWork
implements NodeProcessor {
    private static final Log LOG = LogFactory.getLog((String)GenSparkWork.class.getName());
    private GenSparkUtils utils = null;

    public GenSparkWork(GenSparkUtils utils) {
        this.utils = utils;
    }

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procContext, Object ... nodeOutputs) throws SemanticException {
        BaseWork work;
        GenSparkProcContext context = (GenSparkProcContext)procContext;
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"AssertionError: expected context to be not null");
        Preconditions.checkArgument((context.currentTask != null ? 1 : 0) != 0, (Object)"AssertionError: expected context.currentTask to be not null");
        Preconditions.checkArgument((context.currentRootOperator != null ? 1 : 0) != 0, (Object)"AssertionError: expected context.currentRootOperator to be not null");
        Operator operator = (Operator)nd;
        Operator<? extends OperatorDesc> root = context.currentRootOperator;
        LOG.debug((Object)("Root operator: " + root));
        LOG.debug((Object)("Leaf operator: " + operator));
        if (context.clonedReduceSinks.contains(operator)) {
            return null;
        }
        SparkWork sparkWork = (SparkWork)context.currentTask.getWork();
        SMBMapJoinOperator smbOp = GenSparkUtils.getChildOperator(root, SMBMapJoinOperator.class);
        if (context.rootToWorkMap.containsKey(root)) {
            work = context.rootToWorkMap.get(root);
        } else {
            if (context.preceedingWork == null) {
                if (smbOp == null) {
                    work = this.utils.createMapWork(context, root, sparkWork, null);
                } else {
                    work = this.utils.createMapWork(context, root, sparkWork, null, true);
                    context.smbMapJoinCtxMap.get((Object)smbOp).mapWork = (MapWork)work;
                }
            } else {
                work = this.utils.createReduceWork(context, root, sparkWork);
            }
            context.rootToWorkMap.put(root, work);
        }
        if (!context.childToWorkMap.containsKey(operator)) {
            LinkedList<BaseWork> workItems = new LinkedList<BaseWork>();
            workItems.add(work);
            context.childToWorkMap.put(operator, workItems);
        } else {
            context.childToWorkMap.get(operator).add(work);
        }
        if (!context.currentMapJoinOperators.isEmpty()) {
            for (MapJoinOperator mj : context.currentMapJoinOperators) {
                Map<BaseWork, SparkEdgeProperty> linkWorkMap;
                LOG.debug((Object)("Processing map join: " + mj));
                if (!context.mapJoinWorkMap.containsKey(mj)) {
                    LinkedList<BaseWork> workItems = new LinkedList<BaseWork>();
                    workItems.add(work);
                    context.mapJoinWorkMap.put(mj, workItems);
                } else {
                    context.mapJoinWorkMap.get(mj).add(work);
                }
                if (!context.linkOpWithWorkMap.containsKey(mj) || (linkWorkMap = context.linkOpWithWorkMap.get(mj)) == null) continue;
                if (context.linkChildOpWithDummyOp.containsKey(mj)) {
                    for (Operator operator2 : context.linkChildOpWithDummyOp.get(mj)) {
                        work.addDummyOp((HashTableDummyOperator)operator2);
                    }
                }
                for (Map.Entry entry : linkWorkMap.entrySet()) {
                    BaseWork parentWork = (BaseWork)entry.getKey();
                    LOG.debug((Object)("connecting " + parentWork.getName() + " with " + work.getName()));
                    SparkEdgeProperty edgeProp = (SparkEdgeProperty)entry.getValue();
                    sparkWork.connect(parentWork, work, edgeProp);
                    for (ReduceSinkOperator r : context.linkWorkWithReduceSinkMap.get(parentWork)) {
                        if (((ReduceSinkDesc)r.getConf()).getOutputName() != null) {
                            LOG.debug((Object)"Cloning reduce sink for multi-child broadcast edge");
                            r = (ReduceSinkOperator)OperatorFactory.getAndMakeChild((ReduceSinkDesc)((ReduceSinkDesc)r.getConf()).clone(), r.getParentOperators());
                            context.clonedReduceSinks.add(r);
                        }
                        ((ReduceSinkDesc)r.getConf()).setOutputName(work.getName());
                    }
                }
            }
            context.currentMapJoinOperators.clear();
        }
        if (root.getNumParent() > 0) {
            Preconditions.checkArgument((boolean)(work instanceof ReduceWork), (Object)("AssertionError: expected work to be a ReduceWork, but was " + work.getClass().getName()));
            ReduceWork reduceWork = (ReduceWork)work;
            for (Operator<OperatorDesc> parent : new ArrayList<Operator<OperatorDesc>>(root.getParentOperators())) {
                Preconditions.checkArgument((boolean)(parent instanceof ReduceSinkOperator), (Object)("AssertionError: expected operator to be a ReduceSinkOperator, but was " + parent.getClass().getName()));
                ReduceSinkOperator rsOp = (ReduceSinkOperator)parent;
                SparkEdgeProperty sparkEdgeProperty = GenSparkUtils.getEdgeProperty(rsOp, reduceWork);
                ((ReduceSinkDesc)rsOp.getConf()).setOutputName(reduceWork.getName());
                GenMapRedUtils.setKeyAndValueDesc(reduceWork, rsOp);
                context.leafOpToFollowingWorkInfo.put(rsOp, (ObjectPair<SparkEdgeProperty, ReduceWork>)ObjectPair.create((Object)sparkEdgeProperty, (Object)reduceWork));
                LOG.debug((Object)("Removing " + parent + " as parent from " + root));
                root.removeParent(parent);
            }
        }
        if (!context.currentUnionOperators.isEmpty()) {
            context.currentUnionOperators.clear();
            context.workWithUnionOperators.add(work);
        }
        if (context.leafOpToFollowingWorkInfo.containsKey(operator)) {
            ObjectPair<SparkEdgeProperty, ReduceWork> childWorkInfo = context.leafOpToFollowingWorkInfo.get(operator);
            SparkEdgeProperty edgeProp = (SparkEdgeProperty)childWorkInfo.getFirst();
            ReduceWork childWork = (ReduceWork)childWorkInfo.getSecond();
            LOG.debug((Object)("Second pass. Leaf operator: " + operator + " has common downstream work:" + childWork));
            if (sparkWork.getEdgeProperty(work, childWork) == null) {
                sparkWork.connect(work, childWork, edgeProp);
            } else {
                LOG.debug((Object)("work " + work.getName() + " is already connected to " + childWork.getName() + " before"));
            }
        } else {
            LOG.debug((Object)("First pass. Leaf operator: " + operator));
        }
        if (!operator.getChildOperators().isEmpty()) {
            Preconditions.checkArgument((operator.getChildOperators().size() == 1 ? 1 : 0) != 0, (Object)("AssertionError: expected operator.getChildOperators().size() to be 1, but was " + operator.getChildOperators().size()));
            context.parentOfRoot = operator;
            context.currentRootOperator = operator.getChildOperators().get(0);
            context.preceedingWork = work;
        }
        return null;
    }
}

