/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableDeserializeRead;

public class VectorMapJoinFastLongHashUtil {
    public static long hashKey(long key) {
        key = (key ^ 0xFFFFFFFFFFFFFFFFL) + (key << 21);
        key ^= key >>> 24;
        key = key + (key << 3) + (key << 8);
        key ^= key >>> 14;
        key = key + (key << 2) + (key << 4);
        key ^= key >>> 28;
        key += key << 31;
        return key;
    }

    public static long deserializeLongKey(BinarySortableDeserializeRead keyBinarySortableDeserializeRead, VectorMapJoinDesc.HashTableKeyType hashTableKeyType) throws IOException {
        long key = 0L;
        switch (hashTableKeyType) {
            case BOOLEAN: {
                key = keyBinarySortableDeserializeRead.readBoolean() ? 1 : 0;
                break;
            }
            case BYTE: {
                key = keyBinarySortableDeserializeRead.readByte();
                break;
            }
            case SHORT: {
                key = keyBinarySortableDeserializeRead.readShort();
                break;
            }
            case INT: {
                key = keyBinarySortableDeserializeRead.readInt();
                break;
            }
            case LONG: {
                key = keyBinarySortableDeserializeRead.readLong();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected hash table key type " + hashTableKeyType.name());
            }
        }
        return key;
    }
}

