/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.HashTableLoaderFactory;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.HashTableLoader;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.ObjectCache;
import org.apache.hadoop.hive.ql.exec.ObjectCacheFactory;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.persistence.BytesBytesMultiHashMap;
import org.apache.hadoop.hive.ql.exec.persistence.HybridHashTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.KeyValueContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinBytesTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerSerDe;
import org.apache.hadoop.hive.ql.exec.persistence.ObjectContainer;
import org.apache.hadoop.hive.ql.exec.persistence.UnwrapRowContainer;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hive.common.util.ReflectionUtil;

public class MapJoinOperator
extends AbstractMapJoinOperator<MapJoinDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)MapJoinOperator.class.getName());
    private static final String CLASS_NAME = MapJoinOperator.class.getName();
    private final PerfLogger perfLogger = PerfLogger.getPerfLogger();
    private transient String cacheKey;
    private transient ObjectCache cache;
    protected HashTableLoader loader;
    private boolean loadCalled;
    protected transient MapJoinTableContainer[] mapJoinTables;
    private transient MapJoinTableContainerSerDe[] mapJoinTableSerdes;
    private transient boolean hashTblInitedOnce;
    protected transient MapJoinTableContainer.ReusableGetAdaptor[] hashMapRowGetters;
    private UnwrapRowContainer[] unwrapContainer;
    private transient Configuration hconf;
    private transient boolean hybridMapJoinLeftover;
    protected transient MapJoinBytesTableContainer[] spilledMapJoinTables;
    protected HybridHashTableContainer firstSmallTable;

    public MapJoinOperator() {
    }

    public MapJoinOperator(AbstractMapJoinOperator<? extends MapJoinDesc> mjop) {
        super(mjop);
    }

    @Override
    public void endGroup() throws HiveException {
        this.defaultEndGroup();
    }

    @Override
    public void startGroup() throws HiveException {
        this.defaultStartGroup();
    }

    protected HashTableLoader getHashTableLoader(Configuration hconf) {
        return HashTableLoaderFactory.getLoader(hconf);
    }

    @Override
    protected Collection<Future<?>> initializeOp(Configuration hconf) throws HiveException {
        this.hconf = hconf;
        this.unwrapContainer = new UnwrapRowContainer[((MapJoinDesc)this.conf).getTagLength()];
        Collection<Future<?>> result = super.initializeOp(hconf);
        if (result == null) {
            result = new HashSet();
        }
        int tagLen = ((MapJoinDesc)this.conf).getTagLength();
        this.cacheKey = HiveConf.getVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEQUERYID) + "__HASH_MAP_" + this.getOperatorId() + "_container";
        this.cache = ObjectCacheFactory.getCache(hconf);
        this.loader = this.getHashTableLoader(hconf);
        this.hashMapRowGetters = null;
        this.mapJoinTables = new MapJoinTableContainer[tagLen];
        this.mapJoinTableSerdes = new MapJoinTableContainerSerDe[tagLen];
        this.hashTblInitedOnce = false;
        this.generateMapMetaData();
        final ExecMapperContext mapContext = this.getExecContext();
        final MapredContext mrContext = MapredContext.get();
        if (!((MapJoinDesc)this.conf).isBucketMapJoin()) {
            if (this.isLogInfoEnabled) {
                LOG.info((Object)"This is not bucket map join, so cache");
            }
            Future<Pair<MapJoinTableContainer[], MapJoinTableContainerSerDe[]>> future = this.cache.retrieveAsync(this.cacheKey, new Callable<Pair<MapJoinTableContainer[], MapJoinTableContainerSerDe[]>>(){

                @Override
                public Pair<MapJoinTableContainer[], MapJoinTableContainerSerDe[]> call() throws HiveException {
                    return MapJoinOperator.this.loadHashTable(mapContext, mrContext);
                }
            });
            result.add(future);
        } else if (mapContext == null || mapContext.getLocalWork() == null || !mapContext.getLocalWork().getInputFileChangeSensitive()) {
            this.loadHashTable(mapContext, mrContext);
            this.hashTblInitedOnce = true;
        }
        return result;
    }

    @Override
    protected final void completeInitializationOp(Object[] os) throws HiveException {
        if (os.length != 0) {
            Pair pair = (Pair)os[0];
            boolean spilled = false;
            for (MapJoinTableContainer container : (MapJoinTableContainer[])pair.getLeft()) {
                if (container == null) continue;
                spilled = spilled || container.hasSpill();
            }
            if (!this.loadCalled && spilled) {
                this.loadHashTable(this.getExecContext(), MapredContext.get());
            } else {
                this.mapJoinTables = (MapJoinTableContainer[])pair.getLeft();
                this.mapJoinTableSerdes = (MapJoinTableContainerSerDe[])pair.getRight();
            }
            this.hashTblInitedOnce = true;
        }
        if (this.getExecContext() != null) {
            this.getExecContext().setLastInputPath(null);
            this.getExecContext().setCurrentInputPath(null);
        }
    }

    @Override
    protected List<ObjectInspector> getValueObjectInspectors(byte alias, List<ObjectInspector>[] aliasToObjectInspectors) {
        int[] valueIndex = ((MapJoinDesc)this.conf).getValueIndex(alias);
        if (valueIndex == null) {
            return super.getValueObjectInspectors(alias, aliasToObjectInspectors);
        }
        this.unwrapContainer[alias] = new UnwrapRowContainer(alias, valueIndex, this.hasFilter(alias));
        List<ObjectInspector> inspectors = aliasToObjectInspectors[alias];
        int bigPos = ((MapJoinDesc)this.conf).getPosBigTable();
        ArrayList<ObjectInspector> valueOI = new ArrayList<ObjectInspector>();
        for (int i = 0; i < valueIndex.length; ++i) {
            if (valueIndex[i] >= 0 && !this.joinKeysObjectInspectors[bigPos].isEmpty()) {
                valueOI.add((ObjectInspector)this.joinKeysObjectInspectors[bigPos].get(valueIndex[i]));
                continue;
            }
            valueOI.add(inspectors.get(i));
        }
        return valueOI;
    }

    public void generateMapMetaData() throws HiveException {
        try {
            TableDesc keyTableDesc = ((MapJoinDesc)this.conf).getKeyTblDesc();
            SerDe keySerializer = (SerDe)ReflectionUtil.newInstance(keyTableDesc.getDeserializerClass(), null);
            SerDeUtils.initializeSerDe((Deserializer)keySerializer, null, (Properties)keyTableDesc.getProperties(), null);
            MapJoinObjectSerDeContext keyContext = new MapJoinObjectSerDeContext(keySerializer, false);
            for (int pos = 0; pos < this.order.length; ++pos) {
                if (pos == this.posBigTable) continue;
                TableDesc valueTableDesc = ((MapJoinDesc)this.conf).getNoOuterJoin() ? ((MapJoinDesc)this.conf).getValueTblDescs().get(pos) : ((MapJoinDesc)this.conf).getValueFilteredTblDescs().get(pos);
                SerDe valueSerDe = (SerDe)ReflectionUtil.newInstance(valueTableDesc.getDeserializerClass(), null);
                SerDeUtils.initializeSerDe((Deserializer)valueSerDe, null, (Properties)valueTableDesc.getProperties(), null);
                MapJoinObjectSerDeContext valueContext = new MapJoinObjectSerDeContext(valueSerDe, this.hasFilter(pos));
                this.mapJoinTableSerdes[pos] = new MapJoinTableContainerSerDe(keyContext, valueContext);
            }
        }
        catch (SerDeException e) {
            throw new HiveException(e);
        }
    }

    protected Pair<MapJoinTableContainer[], MapJoinTableContainerSerDe[]> loadHashTable(ExecMapperContext mapContext, MapredContext mrContext) throws HiveException {
        this.loadCalled = true;
        if (this.hashTblInitedOnce && (mapContext == null || mapContext.getLocalWork() == null || !mapContext.getLocalWork().getInputFileChangeSensitive())) {
            return new ImmutablePair((Object)this.mapJoinTables, (Object)this.mapJoinTableSerdes);
        }
        this.perfLogger.PerfLogBegin(CLASS_NAME, "LoadHashtable");
        this.loader.init(mapContext, mrContext, this.hconf, this);
        try {
            this.loader.load(this.mapJoinTables, this.mapJoinTableSerdes);
        }
        catch (HiveException e) {
            if (this.isLogInfoEnabled) {
                LOG.info((Object)"Exception loading hash tables. Clearing partially loaded hash table containers.");
            }
            this.clearAllTableContainers();
            throw e;
        }
        this.hashTblInitedOnce = true;
        ImmutablePair pair = new ImmutablePair((Object)this.mapJoinTables, (Object)this.mapJoinTableSerdes);
        this.perfLogger.PerfLogEnd(CLASS_NAME, "LoadHashtable");
        return pair;
    }

    @Override
    public void cleanUpInputFileChangedOp() throws HiveException {
        this.loadHashTable(this.getExecContext(), MapredContext.get());
    }

    protected JoinUtil.JoinResult setMapJoinKey(MapJoinTableContainer.ReusableGetAdaptor dest, Object row, byte alias) throws HiveException {
        return dest.setFromRow(row, this.joinKeys[alias], this.joinKeysObjectInspectors[alias]);
    }

    protected MapJoinKey getRefKey(byte alias) {
        for (int pos = 0; pos < this.order.length; pos = (int)((byte)(pos + 1))) {
            MapJoinKey refKey;
            if (pos == alias || (refKey = this.mapJoinTables[pos].getAnyKey()) == null) continue;
            return refKey;
        }
        return null;
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            int pos;
            int pos2;
            MapJoinKey refKey;
            this.alias = (byte)tag;
            if (this.hashMapRowGetters == null) {
                this.hashMapRowGetters = new MapJoinTableContainer.ReusableGetAdaptor[this.mapJoinTables.length];
                refKey = this.getRefKey(this.alias);
                for (pos2 = 0; pos2 < this.order.length; pos2 = (int)((byte)(pos2 + 1))) {
                    if (pos2 == this.alias) continue;
                    this.hashMapRowGetters[pos2] = this.mapJoinTables[pos2].createGetter(refKey);
                }
            }
            if (this.hybridMapJoinLeftover) {
                refKey = this.getRefKey(this.alias);
                for (pos2 = 0; pos2 < this.order.length; pos2 = (int)((byte)(pos2 + 1))) {
                    if (pos2 == this.alias || this.spilledMapJoinTables[pos2] == null) continue;
                    this.hashMapRowGetters[pos2] = this.spilledMapJoinTables[pos2].createGetter(refKey);
                }
            }
            MapJoinTableContainer.ReusableGetAdaptor firstSetKey = null;
            int fieldCount = this.joinKeys[this.alias].size();
            boolean joinNeeded = false;
            boolean bigTableRowSpilled = false;
            for (pos = 0; pos < this.order.length; pos = (int)((byte)(pos + 1))) {
                JoinUtil.JoinResult joinResult;
                MapJoinTableContainer.ReusableGetAdaptor adaptor;
                if (pos == this.alias) continue;
                if (firstSetKey == null) {
                    adaptor = firstSetKey = this.hashMapRowGetters[pos];
                    joinResult = this.setMapJoinKey(firstSetKey, row, this.alias);
                } else {
                    adaptor = this.hashMapRowGetters[pos];
                    joinResult = adaptor.setFromOther(firstSetKey);
                }
                MapJoinRowContainer rowContainer = adaptor.getCurrentRows();
                if (rowContainer != null && this.unwrapContainer[pos] != null) {
                    Object[] currentKey = firstSetKey.getCurrentKey();
                    rowContainer = this.unwrapContainer[pos].setInternal(rowContainer, currentKey);
                }
                if (rowContainer == null || firstSetKey.hasAnyNulls(fieldCount, this.nullsafes)) {
                    if (!this.noOuterJoin) {
                        if (!((MapJoinDesc)this.conf).isHybridHashJoin() || this.hybridMapJoinLeftover || !this.hybridMapJoinLeftover && joinResult != JoinUtil.JoinResult.SPILL) {
                            joinNeeded = true;
                            this.storage[pos] = this.dummyObjVectors[pos];
                        }
                    } else {
                        this.storage[pos] = this.emptyList;
                    }
                } else {
                    joinNeeded = true;
                    this.storage[pos] = rowContainer.copy();
                    this.aliasFilterTags[pos] = rowContainer.getAliasFilter();
                }
                if (joinResult != JoinUtil.JoinResult.SPILL || bigTableRowSpilled) continue;
                this.spillBigTableRow(this.mapJoinTables[pos], row);
                bigTableRowSpilled = true;
            }
            if (joinNeeded) {
                List<Object> value = this.getFilteredValue(this.alias, row);
                this.storage[this.alias].addRow(value);
                this.checkAndGenObject();
            }
            this.storage[tag].clearRows();
            for (pos = 0; pos < this.order.length; pos = (int)((byte)(pos + 1))) {
                if (pos == tag) continue;
                this.storage[pos] = null;
            }
        }
        catch (Exception e) {
            String msg = "Unexpected exception: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new HiveException(msg, e);
        }
    }

    protected void spillBigTableRow(MapJoinTableContainer hybridHtContainer, Object row) throws HiveException {
        HybridHashTableContainer ht = (HybridHashTableContainer)hybridHtContainer;
        int partitionId = ht.getToSpillPartitionId();
        HybridHashTableContainer.HashPartition hp = ht.getHashPartitions()[partitionId];
        ObjectContainer bigTable = hp.getMatchfileObjContainer();
        bigTable.add(row);
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        boolean spilled = false;
        for (MapJoinTableContainer container : this.mapJoinTables) {
            if (container == null) continue;
            spilled = spilled || container.hasSpill();
            container.dumpMetrics();
        }
        if (spilled) {
            if (!abort) {
                int pos;
                if (this.hashMapRowGetters == null) {
                    this.hashMapRowGetters = new MapJoinTableContainer.ReusableGetAdaptor[this.mapJoinTables.length];
                }
                int numPartitions = 0;
                for (pos = 0; pos < this.mapJoinTables.length; pos = (int)((byte)(pos + 1))) {
                    if (pos == ((MapJoinDesc)this.conf).getPosBigTable()) continue;
                    this.firstSmallTable = (HybridHashTableContainer)this.mapJoinTables[pos];
                    numPartitions = this.firstSmallTable.getHashPartitions().length;
                    break;
                }
                assert (numPartitions != 0) : "Number of partitions must be greater than 0!";
                if (this.firstSmallTable.hasSpill()) {
                    this.spilledMapJoinTables = new MapJoinBytesTableContainer[this.mapJoinTables.length];
                    this.hybridMapJoinLeftover = true;
                    for (pos = 0; pos < this.mapJoinTables.length; pos = (int)((byte)(pos + 1))) {
                        MapJoinTableContainer tableContainer = this.mapJoinTables[pos];
                        if (tableContainer == null || !(tableContainer instanceof HybridHashTableContainer)) continue;
                        HybridHashTableContainer hybridHtContainer = (HybridHashTableContainer)tableContainer;
                        hybridHtContainer.dumpStats();
                        HybridHashTableContainer.HashPartition[] hashPartitions = hybridHtContainer.getHashPartitions();
                        for (int i = 0; i < hashPartitions.length; ++i) {
                            if (hashPartitions[i].isHashMapOnDisk()) continue;
                            hybridHtContainer.setTotalInMemRowCount(hybridHtContainer.getTotalInMemRowCount() - hashPartitions[i].getHashMapFromMemory().getNumValues());
                            hashPartitions[i].getHashMapFromMemory().clear();
                        }
                        assert (hybridHtContainer.getTotalInMemRowCount() == 0);
                    }
                    for (int i = 0; i < numPartitions; ++i) {
                        HybridHashTableContainer.HashPartition[] hashPartitions = this.firstSmallTable.getHashPartitions();
                        if (!hashPartitions[i].isHashMapOnDisk()) continue;
                        try {
                            this.continueProcess(i);
                        }
                        catch (Exception e) {
                            throw new HiveException(e);
                        }
                        for (int pos2 = 0; pos2 < this.order.length; pos2 = (int)((byte)(pos2 + 1))) {
                            if (pos2 == ((MapJoinDesc)this.conf).getPosBigTable()) continue;
                            this.spilledMapJoinTables[pos2] = null;
                        }
                    }
                }
            }
            if (this.isLogInfoEnabled) {
                LOG.info((Object)("spilled: " + spilled + " abort: " + abort + ". Clearing spilled partitions."));
            }
            this.clearAllTableContainers();
            this.cache.remove(this.cacheKey);
        }
        if (this.getExecContext() != null && this.getExecContext().getLocalWork() != null && this.getExecContext().getLocalWork().getInputFileChangeSensitive()) {
            if (this.isLogInfoEnabled) {
                LOG.info((Object)"MR: Clearing all map join table containers.");
            }
            this.clearAllTableContainers();
        }
        this.loader = null;
        super.closeOp(abort);
    }

    private void clearAllTableContainers() {
        if (this.mapJoinTables != null) {
            for (MapJoinTableContainer tableContainer : this.mapJoinTables) {
                if (tableContainer == null) continue;
                tableContainer.clear();
            }
        }
    }

    private void continueProcess(int partitionId) throws HiveException, IOException, SerDeException, ClassNotFoundException {
        for (byte pos = 0; pos < this.mapJoinTables.length; pos = (byte)(pos + 1)) {
            if (pos == ((MapJoinDesc)this.conf).getPosBigTable()) continue;
            this.reloadHashTable(pos, partitionId);
        }
        this.reProcessBigTable(partitionId);
    }

    protected void reloadHashTable(byte pos, int partitionId) throws IOException, HiveException, SerDeException, ClassNotFoundException {
        HybridHashTableContainer container = (HybridHashTableContainer)this.mapJoinTables[pos];
        HybridHashTableContainer.HashPartition partition = container.getHashPartitions()[partitionId];
        KeyValueContainer kvContainer = partition.getSidefileKVContainer();
        int rowCount = kvContainer.size();
        LOG.info((Object)("Hybrid Grace Hash Join: Number of rows restored from KeyValueContainer: " + kvContainer.size()));
        BytesBytesMultiHashMap restoredHashMap = partition.getHashMapFromDisk(rowCount);
        LOG.info((Object)"Hybrid Grace Hash Join: Deserializing spilled hash partition...");
        LOG.info((Object)("Hybrid Grace Hash Join: Number of rows in hashmap: " + (rowCount += restoredHashMap.getNumValues())));
        if ((long)rowCount * container.getTableRowSize() >= container.getMemoryThreshold() / 2L) {
            LOG.warn((Object)"Hybrid Grace Hash Join: Hash table cannot be reloaded since it will be greater than memory limit. Recursive spilling is currently not supported");
        }
        MapJoinBytesTableContainer.KeyValueHelper writeHelper = container.getWriteHelper();
        while (kvContainer.hasNext()) {
            ObjectPair<HiveKey, BytesWritable> pair = kvContainer.next();
            Writable key = (Writable)pair.getFirst();
            Writable val = (Writable)pair.getSecond();
            writeHelper.setKeyValue(key, val);
            restoredHashMap.put(writeHelper, -1);
        }
        container.setTotalInMemRowCount(container.getTotalInMemRowCount() + restoredHashMap.getNumValues() + kvContainer.size());
        kvContainer.clear();
        this.spilledMapJoinTables[pos] = new MapJoinBytesTableContainer(restoredHashMap);
        this.spilledMapJoinTables[pos].setInternalValueOi(container.getInternalValueOi());
        this.spilledMapJoinTables[pos].setSortableSortOrders(container.getSortableSortOrders());
    }

    protected void reProcessBigTable(int partitionId) throws HiveException {
        HybridHashTableContainer.HashPartition partition = this.firstSmallTable.getHashPartitions()[partitionId];
        ObjectContainer bigTable = partition.getMatchfileObjContainer();
        while (bigTable.hasNext()) {
            Object row = bigTable.next();
            this.process(row, ((MapJoinDesc)this.conf).getPosBigTable());
        }
        bigTable.clear();
    }

    @Override
    public String getName() {
        return MapJoinOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "MAPJOIN";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.MAPJOIN;
    }
}

