/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client.rpc;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.tez.client.FrameworkClient;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.dag.api.DAGNotRunningException;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.DagStatusSource;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolBlockingPB;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolRPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DAGClientRPCImpl
extends DAGClient {
    private static final Logger LOG = LoggerFactory.getLogger(DAGClientRPCImpl.class);
    private static final String DAG_NOT_RUNNING_CLASS_NAME = DAGNotRunningException.class.getCanonicalName();
    private final ApplicationId appId;
    private final String dagId;
    private final TezConfiguration conf;
    @VisibleForTesting
    ApplicationReport appReport;
    private final FrameworkClient frameworkClient;
    @VisibleForTesting
    DAGClientAMProtocolBlockingPB proxy = null;

    public DAGClientRPCImpl(ApplicationId appId, String dagId, TezConfiguration conf, @Nullable FrameworkClient frameworkClient) {
        this.appId = appId;
        this.dagId = dagId;
        this.conf = conf;
        this.frameworkClient = frameworkClient;
        this.appReport = null;
    }

    @Override
    public String getExecutionContext() {
        return "Executing on YARN cluster with App id " + this.appId;
    }

    @Override
    public DAGStatus getDAGStatus(Set<StatusGetOpts> statusOptions) throws IOException, TezException {
        return this.getDAGStatus(statusOptions, 0L);
    }

    @Override
    public DAGStatus getDAGStatus(@Nullable Set<StatusGetOpts> statusOptions, long timeout) throws IOException, TezException {
        if (this.createAMProxyIfNeeded()) {
            try {
                DAGStatus dagStatus = this.getDAGStatusViaAM(statusOptions, timeout);
                return dagStatus;
            }
            catch (TezException e) {
                this.resetProxy(e);
                throw e;
            }
        }
        return null;
    }

    @Override
    public VertexStatus getVertexStatus(String vertexName, Set<StatusGetOpts> statusOptions) throws IOException, TezException {
        if (this.createAMProxyIfNeeded()) {
            try {
                return this.getVertexStatusViaAM(vertexName, statusOptions);
            }
            catch (TezException e) {
                this.resetProxy(e);
                throw e;
            }
        }
        return null;
    }

    @Override
    public void tryKillDAG() throws TezException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("TryKill for app: " + this.appId + " dag:" + this.dagId);
        }
        if (this.createAMProxyIfNeeded()) {
            DAGClientAMProtocolRPC.TryKillDAGRequestProto requestProto = DAGClientAMProtocolRPC.TryKillDAGRequestProto.newBuilder().setDagId(this.dagId).build();
            try {
                this.proxy.tryKillDAG(null, requestProto);
            }
            catch (ServiceException e) {
                this.resetProxy((Exception)((Object)e));
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.proxy != null) {
            RPC.stopProxy((Object)this.proxy);
        }
    }

    @Override
    protected ApplicationReport getApplicationReportInternal() {
        return this.appReport;
    }

    void resetProxy(Exception e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resetting AM proxy for app: " + this.appId + " dag:" + this.dagId + " due to exception :", (Throwable)e);
        }
        this.proxy = null;
    }

    DAGStatus getDAGStatusViaAM(Set<StatusGetOpts> statusOptions, long timeout) throws IOException, TezException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("GetDAGStatus via AM for app: " + this.appId + " dag:" + this.dagId);
        }
        DAGClientAMProtocolRPC.GetDAGStatusRequestProto.Builder requestProtoBuilder = DAGClientAMProtocolRPC.GetDAGStatusRequestProto.newBuilder().setDagId(this.dagId).setTimeout(timeout);
        if (statusOptions != null) {
            requestProtoBuilder.addAllStatusOptions(DagTypeConverters.convertStatusGetOptsToProto(statusOptions));
        }
        try {
            return new DAGStatus(this.proxy.getDAGStatus(null, requestProtoBuilder.build()).getDagStatus(), DagStatusSource.AM);
        }
        catch (ServiceException e) {
            RemoteException remoteException;
            Throwable cause = e.getCause();
            if (cause instanceof RemoteException && DAG_NOT_RUNNING_CLASS_NAME.equals((remoteException = (RemoteException)cause).getClassName())) {
                throw new DAGNotRunningException(remoteException.getMessage());
            }
            throw new TezException(e);
        }
    }

    VertexStatus getVertexStatusViaAM(String vertexName, Set<StatusGetOpts> statusOptions) throws TezException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("GetVertexStatus via AM for app: " + this.appId + " dag: " + this.dagId + " vertex: " + vertexName);
        }
        DAGClientAMProtocolRPC.GetVertexStatusRequestProto.Builder requestProtoBuilder = DAGClientAMProtocolRPC.GetVertexStatusRequestProto.newBuilder().setDagId(this.dagId).setVertexName(vertexName);
        if (statusOptions != null) {
            requestProtoBuilder.addAllStatusOptions(DagTypeConverters.convertStatusGetOptsToProto(statusOptions));
        }
        try {
            return new VertexStatus(this.proxy.getVertexStatus(null, requestProtoBuilder.build()).getVertexStatus());
        }
        catch (ServiceException e) {
            throw new TezException(e);
        }
    }

    ApplicationReport getAppReport() throws IOException, TezException {
        try {
            ApplicationReport appReport = this.frameworkClient.getApplicationReport(this.appId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("App: " + this.appId + " in state: " + appReport.getYarnApplicationState());
            }
            return appReport;
        }
        catch (YarnException e) {
            throw new TezException(e);
        }
    }

    boolean createAMProxyIfNeeded() throws IOException, TezException {
        if (this.proxy != null) {
            return true;
        }
        this.appReport = null;
        this.appReport = this.getAppReport();
        if (this.appReport == null) {
            return false;
        }
        YarnApplicationState appState = this.appReport.getYarnApplicationState();
        if (appState != YarnApplicationState.RUNNING) {
            return false;
        }
        if (this.appReport.getHost() == null || this.appReport.getHost().equals("N/A") || this.appReport.getRpcPort() == 0) {
            return false;
        }
        this.proxy = TezClientUtils.getAMProxy(this.conf, this.appReport.getHost(), this.appReport.getRpcPort(), this.appReport.getClientToAMToken());
        return true;
    }

    @Override
    public DAGStatus waitForCompletion() throws IOException, TezException, InterruptedException {
        throw new TezException("not supported");
    }

    @Override
    public DAGStatus waitForCompletionWithStatusUpdates(@Nullable Set<StatusGetOpts> statusGetOpts) throws IOException, TezException, InterruptedException {
        throw new TezException("not supported");
    }
}

