/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.monitor;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.server.monitor.DedupedLogEvent;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.net.SocketNode;
import org.apache.log4j.spi.LoggingEvent;

public class LogService
extends AppenderSkeleton {
    private static final Logger log = Logger.getLogger(LogService.class);
    private static LogService instance = null;
    private static final int MAX_LOGS = 50;
    private LinkedHashMap<String, DedupedLogEvent> events = new LinkedHashMap<String, DedupedLogEvent>(51, 0.75f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 50;
        }
    };

    static void startLogListener(AccumuloConfiguration conf) {
        try {
            new Daemon((Runnable)new SocketServer(conf.getPort(Property.MONITOR_LOG4J_PORT))).start();
        }
        catch (Throwable t) {
            log.info((Object)"Unable to listen to cluster-wide ports", t);
        }
    }

    public static synchronized LogService getInstance() {
        if (instance == null) {
            return new LogService();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogService() {
        Class<LogService> clazz = LogService.class;
        synchronized (LogService.class) {
            instance = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected synchronized void append(LoggingEvent ev) {
        Object application = ev.getMDC("application");
        if (application == null || application.toString().isEmpty()) {
            return;
        }
        DedupedLogEvent dev = new DedupedLogEvent(ev);
        if (this.events.containsKey(dev.toString())) {
            DedupedLogEvent oldDev = (DedupedLogEvent)this.events.remove(dev.toString());
            dev.setCount(oldDev.getCount() + 1);
        }
        this.events.put(dev.toString(), dev);
    }

    public void close() {
        this.events = null;
    }

    public synchronized void doAppend(LoggingEvent event) {
        super.doAppend(event);
    }

    public boolean requiresLayout() {
        return false;
    }

    public synchronized List<DedupedLogEvent> getEvents() {
        return new ArrayList<DedupedLogEvent>(this.events.values());
    }

    public synchronized void clear() {
        this.events.clear();
    }

    static class SocketServer
    implements Runnable {
        private ServerSocket server = null;

        public SocketServer(int port) {
            try {
                this.server = new ServerSocket(port);
            }
            catch (IOException io) {
                throw new RuntimeException(io);
            }
        }

        @Override
        public void run() {
            try {
                while (true) {
                    log.debug((Object)"Waiting for log message senders");
                    Socket socket = this.server.accept();
                    log.debug((Object)"Got a new connection");
                    Daemon t = new Daemon((Runnable)new SocketNode(socket, LogManager.getLoggerRepository()));
                    t.start();
                }
            }
            catch (IOException io) {
                log.error((Object)io, (Throwable)io);
                return;
            }
        }
    }
}

