/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.file.FileUtil;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.master.tableOps.PopulateMetadata;
import org.apache.accumulo.server.master.tableOps.TableInfo;
import org.apache.accumulo.server.trace.TraceFileSystem;
import org.apache.accumulo.server.util.TabletOperations;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

class CreateDir
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private TableInfo tableInfo;

    CreateDir(TableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master environment) throws Exception {
        FileSystem fs = TraceFileSystem.wrap(FileUtil.getFileSystem((Configuration)CachedConfiguration.getInstance(), (AccumuloConfiguration)ServerConfiguration.getSiteConfiguration()));
        String dir = ServerConstants.getTablesDir() + "/" + this.tableInfo.tableId;
        TabletOperations.createTabletDirectory(fs, dir, null);
        return new PopulateMetadata(this.tableInfo);
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
        FileSystem fs = TraceFileSystem.wrap(FileUtil.getFileSystem((Configuration)CachedConfiguration.getInstance(), (AccumuloConfiguration)ServerConfiguration.getSiteConfiguration()));
        String dir = ServerConstants.getTablesDir() + "/" + this.tableInfo.tableId;
        fs.delete(new Path(dir), true);
    }
}

