/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.ThriftTransportPool;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.thrift.TKeyExtent;
import org.apache.accumulo.core.file.FileUtil;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterGoalState;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.master.thrift.MasterState;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletLoadState;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.master.thrift.TabletSplit;
import org.apache.accumulo.core.security.SecurityUtil;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.core.util.AddressUtil;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.AgeOffStore;
import org.apache.accumulo.fate.Fate;
import org.apache.accumulo.fate.TStore;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.Accumulo;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.master.EventCoordinator;
import org.apache.accumulo.server.master.LiveTServerSet;
import org.apache.accumulo.server.master.balancer.DefaultLoadBalancer;
import org.apache.accumulo.server.master.balancer.TabletBalancer;
import org.apache.accumulo.server.master.recovery.RecoveryManager;
import org.apache.accumulo.server.master.state.Assignment;
import org.apache.accumulo.server.master.state.CurrentState;
import org.apache.accumulo.server.master.state.DeadServerList;
import org.apache.accumulo.server.master.state.DistributedStoreException;
import org.apache.accumulo.server.master.state.MergeInfo;
import org.apache.accumulo.server.master.state.MergeState;
import org.apache.accumulo.server.master.state.MergeStats;
import org.apache.accumulo.server.master.state.MetaDataStateStore;
import org.apache.accumulo.server.master.state.RootTabletStateStore;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TableCounts;
import org.apache.accumulo.server.master.state.TableStats;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.master.state.TabletMigration;
import org.apache.accumulo.server.master.state.TabletServerState;
import org.apache.accumulo.server.master.state.TabletState;
import org.apache.accumulo.server.master.state.TabletStateStore;
import org.apache.accumulo.server.master.state.ZooStore;
import org.apache.accumulo.server.master.state.ZooTabletStateStore;
import org.apache.accumulo.server.master.state.tables.TableManager;
import org.apache.accumulo.server.master.state.tables.TableObserver;
import org.apache.accumulo.server.master.tableOps.BulkImport;
import org.apache.accumulo.server.master.tableOps.CancelCompactions;
import org.apache.accumulo.server.master.tableOps.ChangeTableState;
import org.apache.accumulo.server.master.tableOps.CloneTable;
import org.apache.accumulo.server.master.tableOps.CompactRange;
import org.apache.accumulo.server.master.tableOps.CreateTable;
import org.apache.accumulo.server.master.tableOps.DeleteTable;
import org.apache.accumulo.server.master.tableOps.ExportTable;
import org.apache.accumulo.server.master.tableOps.ImportTable;
import org.apache.accumulo.server.master.tableOps.RenameTable;
import org.apache.accumulo.server.master.tableOps.TableRangeOp;
import org.apache.accumulo.server.master.tableOps.TraceRepo;
import org.apache.accumulo.server.master.tserverOps.ShutdownTServer;
import org.apache.accumulo.server.monitor.Monitor;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.security.SecurityConstants;
import org.apache.accumulo.server.security.SecurityOperation;
import org.apache.accumulo.server.tabletserver.TabletTime;
import org.apache.accumulo.server.trace.TraceFileSystem;
import org.apache.accumulo.server.util.DefaultMap;
import org.apache.accumulo.server.util.Halt;
import org.apache.accumulo.server.util.MetadataTable;
import org.apache.accumulo.server.util.SystemPropUtil;
import org.apache.accumulo.server.util.TServerUtils;
import org.apache.accumulo.server.util.TablePropUtil;
import org.apache.accumulo.server.util.TabletIterator;
import org.apache.accumulo.server.util.time.SimpleTimer;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.accumulo.trace.instrument.thrift.TraceWrap;
import org.apache.accumulo.trace.thrift.TInfo;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TTransportException;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;

public class Master
implements LiveTServerSet.Listener,
TableObserver,
CurrentState {
    private static final Logger log = Logger.getLogger(Master.class);
    private static final int ONE_SECOND = 1000;
    private static final Text METADATA_TABLE_ID = new Text("!0");
    private static final long TIME_TO_WAIT_BETWEEN_SCANS = 60000L;
    private static final long TIME_BETWEEN_MIGRATION_CLEANUPS = 300000L;
    private static final long WAIT_BETWEEN_ERRORS = 1000L;
    private static final long DEFAULT_WAIT_FOR_WATCHER = 10000L;
    private static final int MAX_CLEANUP_WAIT_TIME = 1000;
    private static final int TIME_TO_WAIT_BETWEEN_LOCK_CHECKS = 1000;
    private static final int MAX_TSERVER_WORK_CHUNK = 5000;
    private static final int MAX_BAD_STATUS_COUNT = 3;
    private final FileSystem fs;
    private final Instance instance;
    private final String hostname;
    private final LiveTServerSet tserverSet;
    private final List<TabletGroupWatcher> watchers = new ArrayList<TabletGroupWatcher>();
    private final SecurityOperation security;
    private final Map<TServerInstance, AtomicInteger> badServers = Collections.synchronizedMap(new DefaultMap(new AtomicInteger()));
    private final Set<TServerInstance> serversToShutdown = Collections.synchronizedSet(new HashSet());
    private final SortedMap<KeyExtent, TServerInstance> migrations = Collections.synchronizedSortedMap(new TreeMap());
    private final EventCoordinator nextEvent = new EventCoordinator();
    private final Object mergeLock = new Object();
    private RecoveryManager recoveryManager = null;
    private ZooLock masterLock = null;
    private TServer clientService = null;
    private TabletBalancer tabletBalancer;
    private MasterState state = MasterState.INITIAL;
    private Fate<Master> fate;
    private volatile SortedMap<TServerInstance, TabletServerStatus> tserverStatus = Collections.unmodifiableSortedMap(new TreeMap());
    private final Set<String> recoveriesInProgress = Collections.synchronizedSet(new HashSet());
    static final boolean X = true;
    static final boolean _ = false;
    static final boolean[][] transitionOK = new boolean[][]{{true, true, false, false, false, false, true}, {false, true, true, true, false, false, true}, {false, false, true, true, true, false, true}, {false, false, true, true, true, false, true}, {false, false, true, true, true, true, true}, {false, false, false, true, false, true, true}, {false, false, false, false, false, false, true}};
    private final AtomicBoolean upgradeMetadataRunning = new AtomicBoolean(false);
    private final ServerConfiguration serverConfig;
    static final String I_DONT_KNOW_WHY = "unexpected failure";

    private synchronized MasterState getMasterState() {
        return this.state;
    }

    public boolean stillMaster() {
        return this.getMasterState() != MasterState.STOP;
    }

    private synchronized void setMasterState(MasterState newState) {
        if (this.state.equals((Object)newState)) {
            return;
        }
        if (!transitionOK[this.state.ordinal()][newState.ordinal()]) {
            log.error((Object)("Programmer error: master should not transition from " + this.state + " to " + newState));
        }
        MasterState oldState = this.state;
        this.state = newState;
        this.nextEvent.event("State changed from %s to %s", oldState, newState);
        if (newState == MasterState.STOP) {
            SimpleTimer.getInstance().schedule(new Runnable(){

                @Override
                public void run() {
                    Master.this.clientService.stop();
                    Master.this.nextEvent.event("stopped event loop", new Object[0]);
                }
            }, 100L, 1000L);
        }
        if (oldState != newState && newState == MasterState.HAVE_LOCK) {
            this.upgradeZookeeper();
        }
        if (oldState != newState && newState == MasterState.NORMAL) {
            this.upgradeMetadata();
        }
    }

    private void upgradeZookeeper() {
        if (Accumulo.getAccumuloPersistentVersion(this.fs) == 4) {
            try {
                log.info((Object)"Upgrading zookeeper");
                ZooReaderWriter zoo = ZooReaderWriter.getInstance();
                zoo.recursiveDelete(ZooUtil.getRoot((Instance)this.instance) + "/loggers", ZooUtil.NodeMissingPolicy.SKIP);
                zoo.recursiveDelete(ZooUtil.getRoot((Instance)this.instance) + "/dead/loggers", ZooUtil.NodeMissingPolicy.SKIP);
                zoo.putPersistentData(ZooUtil.getRoot((Instance)this.instance) + "/recovery", new byte[]{48}, ZooUtil.NodeExistsPolicy.SKIP);
                for (String id : Tables.getIdToNameMap((Instance)this.instance).keySet()) {
                    zoo.putPersistentData(ZooUtil.getRoot((Instance)this.instance) + "/tables" + "/" + id + "/compact-cancel-id", "0".getBytes(), ZooUtil.NodeExistsPolicy.SKIP);
                }
            }
            catch (Exception ex) {
                log.fatal((Object)"Error performing upgrade", (Throwable)ex);
                System.exit(1);
            }
        }
    }

    private void upgradeMetadata() {
        if (Accumulo.getAccumuloPersistentVersion(this.fs) == 4 && this.upgradeMetadataRunning.compareAndSet(false, true)) {
            Runnable upgradeTask = new Runnable(){

                @Override
                public void run() {
                    try {
                        MetadataTable.moveMetaDeleteMarkers(Master.this.instance, SecurityConstants.getSystemCredentials());
                        Accumulo.updateAccumuloVersion(Master.this.fs);
                        log.info((Object)"Upgrade complete");
                    }
                    catch (Exception ex) {
                        log.fatal((Object)"Error performing upgrade", (Throwable)ex);
                        System.exit(1);
                    }
                }
            };
            new Thread(upgradeTask).start();
        }
    }

    private int assignedOrHosted(Text tableId) {
        int result = 0;
        for (TabletGroupWatcher watcher : this.watchers) {
            TableCounts count = watcher.getStats(tableId);
            result += count.hosted() + count.assigned();
        }
        return result;
    }

    private int totalAssignedOrHosted() {
        int result = 0;
        for (TabletGroupWatcher watcher : this.watchers) {
            for (TableCounts counts : watcher.getStats().values()) {
                result += counts.assigned() + counts.hosted();
            }
        }
        return result;
    }

    private int nonMetaDataTabletsAssignedOrHosted() {
        return this.totalAssignedOrHosted() - this.assignedOrHosted(new Text("!0"));
    }

    private int notHosted() {
        int result = 0;
        for (TabletGroupWatcher watcher : this.watchers) {
            for (TableCounts counts : watcher.getStats().values()) {
                result += counts.assigned() + counts.assignedToDeadServers();
            }
        }
        return result;
    }

    private int displayUnassigned() {
        int result = 0;
        Text meta = new Text("!0");
        switch (this.getMasterState()) {
            case NORMAL: {
                for (TabletGroupWatcher watcher : this.watchers) {
                    TableManager manager = TableManager.getInstance();
                    for (Map.Entry<Text, TableCounts> entry : watcher.getStats().entrySet()) {
                        Text tableId = entry.getKey();
                        TableCounts counts = entry.getValue();
                        TableState tableState = manager.getTableState(tableId.toString());
                        if (tableState == null || !tableState.equals((Object)TableState.ONLINE)) continue;
                        result += counts.unassigned() + counts.assignedToDeadServers() + counts.assigned();
                    }
                }
                break;
            }
            case SAFE_MODE: {
                for (TabletGroupWatcher watcher : this.watchers) {
                    result += watcher.getStats(meta).unassigned();
                }
                break;
            }
            case UNLOAD_METADATA_TABLETS: 
            case UNLOAD_ROOT_TABLET: {
                for (TabletGroupWatcher watcher : this.watchers) {
                    result += watcher.getStats(meta).unassigned();
                }
                break;
            }
        }
        return result;
    }

    private void checkNotMetadataTable(String tableName, TableOperation operation) throws ThriftTableOperationException {
        if (tableName.compareTo("!METADATA") == 0) {
            String why = "Table names cannot be == !METADATA";
            log.warn((Object)why);
            throw new ThriftTableOperationException(null, tableName, operation, TableOperationExceptionType.OTHER, why);
        }
    }

    private void checkTableName(String tableName, TableOperation operation) throws ThriftTableOperationException {
        if (!tableName.matches("^\\w+$")) {
            String why = "Table names must only contain word characters (letters, digits, and underscores): " + tableName;
            log.warn((Object)why);
            throw new ThriftTableOperationException(null, tableName, operation, TableOperationExceptionType.OTHER, why);
        }
        if (Tables.getNameToIdMap((Instance)HdfsZooInstance.getInstance()).containsKey(tableName)) {
            String why = "Table name already exists: " + tableName;
            throw new ThriftTableOperationException(null, tableName, operation, TableOperationExceptionType.EXISTS, why);
        }
    }

    public void mustBeOnline(String tableId) throws ThriftTableOperationException {
        Tables.clearCache((Instance)this.instance);
        if (!Tables.getTableState((Instance)this.instance, (String)tableId).equals((Object)TableState.ONLINE)) {
            throw new ThriftTableOperationException(tableId, null, TableOperation.MERGE, TableOperationExceptionType.OFFLINE, "table is not online");
        }
    }

    public Connector getConnector() throws AccumuloException, AccumuloSecurityException {
        return this.instance.getConnector("!SYSTEM", SecurityConstants.getSystemToken());
    }

    private void waitAround(EventCoordinator.Listener listener) {
        listener.waitForEvents(1000L);
    }

    public static <T> T createInstanceFromPropertyName(AccumuloConfiguration conf, Property property, Class<T> base, T defaultInstance) {
        String clazzName = conf.get(property);
        T instance = null;
        try {
            Class clazz = AccumuloVFSClassLoader.loadClass((String)clazzName, base);
            instance = clazz.newInstance();
            log.info((Object)("Loaded class : " + clazzName));
        }
        catch (Exception e) {
            log.warn((Object)"Failed to load class ", (Throwable)e);
        }
        if (instance == null) {
            log.info((Object)("Using " + defaultInstance.getClass().getName()));
            instance = defaultInstance;
        }
        return instance;
    }

    public Master(ServerConfiguration config, FileSystem fs, String hostname) throws IOException {
        this.serverConfig = config;
        this.instance = config.getInstance();
        this.fs = TraceFileSystem.wrap(fs);
        this.hostname = hostname;
        AccumuloConfiguration aconf = this.serverConfig.getConfiguration();
        log.info((Object)"Version 1.5.0");
        log.info((Object)("Instance " + this.instance.getInstanceID()));
        ThriftTransportPool.getInstance().setIdleTime(aconf.getTimeInMillis(Property.GENERAL_RPC_TIMEOUT));
        this.security = AuditedSecurityOperation.getInstance();
        this.tserverSet = new LiveTServerSet(this.instance, config.getConfiguration(), this);
        this.tabletBalancer = Master.createInstanceFromPropertyName(aconf, Property.MASTER_TABLET_BALANCER, TabletBalancer.class, new DefaultLoadBalancer());
        this.tabletBalancer.init(this.serverConfig);
    }

    public LiveTServerSet.TServerConnection getConnection(TServerInstance server) {
        try {
            return this.tserverSet.getConnection(server);
        }
        catch (TException ex) {
            return null;
        }
    }

    public MergeInfo getMergeInfo(KeyExtent tablet) {
        if (tablet.isRootTablet()) {
            return new MergeInfo();
        }
        return this.getMergeInfo(tablet.getTableId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MergeInfo getMergeInfo(Text tableId) {
        Object object = this.mergeLock;
        synchronized (object) {
            try {
                String path = ZooUtil.getRoot((String)this.instance.getInstanceID()) + "/tables" + "/" + tableId.toString() + "/merge";
                if (!ZooReaderWriter.getInstance().exists(path)) {
                    return new MergeInfo();
                }
                byte[] data = ZooReaderWriter.getInstance().getData(path, new Stat());
                DataInputBuffer in = new DataInputBuffer();
                in.reset(data, data.length);
                MergeInfo info = new MergeInfo();
                info.readFields((DataInput)in);
                return info;
            }
            catch (KeeperException.NoNodeException ex) {
                log.info((Object)"Error reading merge state, it probably just finished");
                return new MergeInfo();
            }
            catch (Exception ex) {
                log.warn((Object)"Unexpected error reading merge state", (Throwable)ex);
                return new MergeInfo();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMergeState(MergeInfo info, MergeState state) throws IOException, KeeperException, InterruptedException {
        Object object = this.mergeLock;
        synchronized (object) {
            String path = ZooUtil.getRoot((String)this.instance.getInstanceID()) + "/tables" + "/" + info.getRange().getTableId().toString() + "/merge";
            info.setState(state);
            if (state.equals((Object)MergeState.NONE)) {
                ZooReaderWriter.getInstance().recursiveDelete(path, ZooUtil.NodeMissingPolicy.SKIP);
            } else {
                DataOutputBuffer out = new DataOutputBuffer();
                try {
                    info.write((DataOutput)out);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Unlikely", ex);
                }
                ZooReaderWriter.getInstance().putPersistentData(path, out.getData(), state.equals((Object)MergeState.STARTED) ? ZooUtil.NodeExistsPolicy.FAIL : ZooUtil.NodeExistsPolicy.OVERWRITE);
            }
            this.mergeLock.notifyAll();
        }
        this.nextEvent.event("Merge state of %s set to %s", new Object[]{info.getRange(), state});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMergeState(Text tableId) throws IOException, KeeperException, InterruptedException {
        Object object = this.mergeLock;
        synchronized (object) {
            String path = ZooUtil.getRoot((String)this.instance.getInstanceID()) + "/tables" + "/" + tableId.toString() + "/merge";
            ZooReaderWriter.getInstance().recursiveDelete(path, ZooUtil.NodeMissingPolicy.SKIP);
            this.mergeLock.notifyAll();
        }
        this.nextEvent.event("Merge state of %s cleared", tableId);
    }

    private void setMasterGoalState(MasterGoalState state) {
        try {
            ZooReaderWriter.getInstance().putPersistentData(ZooUtil.getRoot((Instance)this.instance) + "/masters/goal_state", state.name().getBytes(), ZooUtil.NodeExistsPolicy.OVERWRITE);
        }
        catch (Exception ex) {
            log.error((Object)"Unable to set master goal state in zookeeper");
        }
    }

    MasterGoalState getMasterGoalState() {
        while (true) {
            try {
                byte[] data = ZooReaderWriter.getInstance().getData(ZooUtil.getRoot((Instance)this.instance) + "/masters/goal_state", null);
                return MasterGoalState.valueOf((String)new String(data));
            }
            catch (Exception e) {
                log.error((Object)("Problem getting real goal state: " + e));
                UtilWaitThread.sleep((long)1000L);
                continue;
            }
            break;
        }
    }

    private void shutdown(boolean stopTabletServers) {
        if (stopTabletServers) {
            this.setMasterGoalState(MasterGoalState.CLEAN_STOP);
            EventCoordinator.Listener eventListener = this.nextEvent.getListener();
            do {
                this.waitAround(eventListener);
            } while (this.tserverSet.size() > 0);
        }
        this.setMasterState(MasterState.STOP);
    }

    public boolean hasCycled(long time) {
        for (TabletGroupWatcher watcher : this.watchers) {
            if (watcher.stats.lastScanFinished() >= time) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMigrations(String tableId) {
        SortedMap<KeyExtent, TServerInstance> sortedMap = this.migrations;
        synchronized (sortedMap) {
            Iterator<KeyExtent> iterator = this.migrations.keySet().iterator();
            while (iterator.hasNext()) {
                KeyExtent extent = iterator.next();
                if (!extent.getTableId().toString().equals(tableId)) continue;
                iterator.remove();
            }
        }
    }

    TabletGoalState getSystemGoalState(TabletLocationState tls) {
        switch (this.getMasterState()) {
            case NORMAL: {
                return TabletGoalState.HOSTED;
            }
            case SAFE_MODE: 
            case HAVE_LOCK: 
            case INITIAL: {
                if (tls.extent.isMeta()) {
                    return TabletGoalState.HOSTED;
                }
                return TabletGoalState.UNASSIGNED;
            }
            case UNLOAD_METADATA_TABLETS: {
                if (tls.extent.isRootTablet()) {
                    return TabletGoalState.HOSTED;
                }
                return TabletGoalState.UNASSIGNED;
            }
            case UNLOAD_ROOT_TABLET: {
                return TabletGoalState.UNASSIGNED;
            }
            case STOP: {
                return TabletGoalState.UNASSIGNED;
            }
        }
        return TabletGoalState.HOSTED;
    }

    TabletGoalState getTableGoalState(KeyExtent extent) {
        TableState tableState = TableManager.getInstance().getTableState(extent.getTableId().toString());
        if (tableState == null) {
            return TabletGoalState.DELETED;
        }
        switch (tableState) {
            case DELETING: {
                return TabletGoalState.DELETED;
            }
            case OFFLINE: 
            case NEW: {
                return TabletGoalState.UNASSIGNED;
            }
        }
        return TabletGoalState.HOSTED;
    }

    TabletGoalState getGoalState(TabletLocationState tls, MergeInfo mergeInfo) {
        KeyExtent extent = tls.extent;
        TabletGoalState state = this.getSystemGoalState(tls);
        if (state == TabletGoalState.HOSTED) {
            TServerInstance dest;
            if (tls.current != null && this.serversToShutdown.contains(tls.current)) {
                return TabletGoalState.UNASSIGNED;
            }
            if (mergeInfo.getRange() != null) {
                log.debug((Object)("mergeInfo overlaps: " + extent + " " + mergeInfo.overlaps(extent)));
                if (mergeInfo.overlaps(extent)) {
                    switch (mergeInfo.getState()) {
                        case NONE: 
                        case COMPLETE: {
                            break;
                        }
                        case STARTED: 
                        case SPLITTING: {
                            return TabletGoalState.HOSTED;
                        }
                        case WAITING_FOR_CHOPPED: {
                            if (tls.getState(this.onlineTabletServers()).equals((Object)TabletState.HOSTED) ? tls.chopped : tls.chopped && tls.walogs.isEmpty()) {
                                return TabletGoalState.UNASSIGNED;
                            }
                            return TabletGoalState.HOSTED;
                        }
                        case WAITING_FOR_OFFLINE: 
                        case MERGING: {
                            return TabletGoalState.UNASSIGNED;
                        }
                    }
                }
            }
            if ((state = this.getTableGoalState(extent)) == TabletGoalState.HOSTED && (dest = (TServerInstance)this.migrations.get(extent)) != null && tls.current != null && !dest.equals(tls.current)) {
                return TabletGoalState.UNASSIGNED;
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedMap<TServerInstance, TabletServerStatus> gatherTableInformation() {
        long start = System.currentTimeMillis();
        TreeMap<TServerInstance, TabletServerStatus> result = new TreeMap<TServerInstance, TabletServerStatus>();
        Set<TServerInstance> currentServers = this.tserverSet.getCurrentServers();
        for (TServerInstance server : currentServers) {
            try {
                Thread t = Thread.currentThread();
                String oldName = t.getName();
                try {
                    t.setName("Getting status from " + server);
                    LiveTServerSet.TServerConnection connection = this.tserverSet.getConnection(server);
                    if (connection == null) {
                        throw new IOException("No connection to " + server);
                    }
                    TabletServerStatus status = connection.getTableMap(false);
                    result.put(server, status);
                }
                finally {
                    t.setName(oldName);
                }
            }
            catch (Exception ex) {
                log.error((Object)("unable to get tablet server status " + server + " " + ex.toString()));
                log.debug((Object)("unable to get tablet server status " + server), (Throwable)ex);
                if (this.badServers.get(server).incrementAndGet() <= 3) continue;
                log.warn((Object)("attempting to stop " + server));
                try {
                    LiveTServerSet.TServerConnection connection = this.tserverSet.getConnection(server);
                    if (connection != null) {
                        connection.halt(this.masterLock);
                    }
                }
                catch (TTransportException e) {
                }
                catch (Exception e) {
                    log.info((Object)"error talking to troublesome tablet server ", (Throwable)e);
                }
                this.badServers.remove(server);
                this.tserverSet.remove(server);
            }
        }
        Map<TServerInstance, AtomicInteger> map = this.badServers;
        synchronized (map) {
            this.badServers.keySet().retainAll(currentServers);
        }
        log.debug((Object)String.format("Finished gathering information from %d servers in %.2f seconds", result.size(), (double)(System.currentTimeMillis() - start) / 1000.0));
        return result;
    }

    public void run() throws IOException, InterruptedException, KeeperException {
        final String zroot = ZooUtil.getRoot((Instance)this.instance);
        this.getMasterLock(zroot + "/masters/lock");
        this.recoveryManager = new RecoveryManager(this);
        TableManager.getInstance().addObserver(this);
        StatusThread statusThread = new StatusThread();
        statusThread.start();
        MigrationCleanupThread migrationCleanupThread = new MigrationCleanupThread();
        migrationCleanupThread.start();
        this.tserverSet.startListeningForTabletServerChanges();
        try {
            final AgeOffStore store = new AgeOffStore((TStore)new org.apache.accumulo.fate.ZooStore(ZooUtil.getRoot((Instance)this.instance) + "/fate", ZooReaderWriter.getRetryingInstance()), 28800000L);
            int threads = this.getConfiguration().getConfiguration().getCount(Property.MASTER_FATE_THREADPOOL_SIZE);
            this.fate = new Fate((Object)this, (TStore)store, threads);
            SimpleTimer.getInstance().schedule(new Runnable(){

                @Override
                public void run() {
                    store.ageOff();
                }
            }, 63000L, 63000L);
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        ZooReaderWriter.getInstance().getChildren(zroot + "/recovery", new Watcher(){

            public void process(WatchedEvent event) {
                Master.this.nextEvent.event("Noticed recovery changes", event.getType());
                try {
                    ZooReaderWriter.getInstance().getChildren(zroot + "/recovery", this);
                }
                catch (Exception e) {
                    log.error((Object)"Failed to add log recovery watcher back", (Throwable)e);
                }
            }
        });
        TCredentials systemAuths = SecurityConstants.getSystemCredentials();
        TabletStateStore[] stores = new TabletStateStore[]{new ZooTabletStateStore(new ZooStore(zroot)), new RootTabletStateStore(this.instance, systemAuths, this), new MetaDataStateStore(this.instance, systemAuths, this)};
        this.watchers.add(new TabletGroupWatcher(stores[2], null));
        this.watchers.add(new TabletGroupWatcher(stores[1], this.watchers.get(0)));
        this.watchers.add(new TabletGroupWatcher(stores[0], this.watchers.get(1)));
        for (TabletGroupWatcher watcher : this.watchers) {
            watcher.start();
        }
        MasterClientService.Processor processor = new MasterClientService.Processor((MasterClientService.Iface)TraceWrap.service((Object)new MasterClientServiceHandler()));
        this.clientService = TServerUtils.startServer((AccumuloConfiguration)this.getSystemConfiguration(), (Property)Property.MASTER_CLIENTPORT, (TProcessor)processor, (String)"Master", (String)"Master Client Service Handler", null, (Property)Property.MASTER_MINTHREADS, (Property)Property.MASTER_THREADCHECK, (Property)Property.GENERAL_MAX_MESSAGE_SIZE).server;
        while (!this.clientService.isServing()) {
            UtilWaitThread.sleep((long)100L);
        }
        while (this.clientService.isServing()) {
            UtilWaitThread.sleep((long)500L);
        }
        long deadline = System.currentTimeMillis() + 1000L;
        statusThread.join(this.remaining(deadline));
        for (TabletGroupWatcher watcher : this.watchers) {
            watcher.join(this.remaining(deadline));
        }
        log.info((Object)"exiting");
    }

    private long remaining(long deadline) {
        return Math.max(1L, deadline - System.currentTimeMillis());
    }

    public ZooLock getMasterLock() {
        return this.masterLock;
    }

    private void getMasterLock(String zMasterLoc) throws KeeperException, InterruptedException {
        log.info((Object)"trying to get master lock");
        String masterClientAddress = AddressUtil.toString((InetSocketAddress)new InetSocketAddress(this.hostname, this.getSystemConfiguration().getPort(Property.MASTER_CLIENTPORT)));
        while (true) {
            MasterLockWatcher masterLockWatcher = new MasterLockWatcher();
            this.masterLock = new ZooLock(zMasterLoc);
            this.masterLock.lockAsync(masterLockWatcher, masterClientAddress.getBytes());
            masterLockWatcher.waitForChange();
            if (masterLockWatcher.acquiredLock) break;
            if (!masterLockWatcher.failedToAcquireLock) {
                throw new IllegalStateException("master lock in unknown state");
            }
            this.masterLock.tryToCancelAsyncLockOrUnlock();
            UtilWaitThread.sleep((long)1000L);
        }
        this.setMasterState(MasterState.HAVE_LOCK);
    }

    public static void main(String[] args) throws Exception {
        try {
            SecurityUtil.serverLogin();
            FileSystem fs = FileUtil.getFileSystem((Configuration)CachedConfiguration.getInstance(), (AccumuloConfiguration)ServerConfiguration.getSiteConfiguration());
            String hostname = Accumulo.getLocalAddress(args);
            Instance instance = HdfsZooInstance.getInstance();
            ServerConfiguration conf = new ServerConfiguration(instance);
            Accumulo.init(fs, conf, "master");
            Master master = new Master(conf, fs, hostname);
            Accumulo.enableTracing(hostname, "master");
            master.run();
        }
        catch (Exception ex) {
            log.error((Object)"Unexpected exception, exiting", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(LiveTServerSet current, Set<TServerInstance> deleted, Set<TServerInstance> added) {
        DeadServerList obit = new DeadServerList(ZooUtil.getRoot((Instance)this.instance) + "/dead/tservers");
        if (added.size() > 0) {
            log.info((Object)("New servers: " + added));
            for (TServerInstance up : added) {
                obit.delete(up.hostPort());
            }
        }
        for (TServerInstance dead : deleted) {
            String cause = I_DONT_KNOW_WHY;
            if (this.serversToShutdown.contains(dead)) {
                cause = "clean shutdown";
            }
            if (this.getMasterGoalState().equals((Object)MasterGoalState.CLEAN_STOP)) continue;
            obit.post(dead.hostPort(), cause);
        }
        HashSet<TServerInstance> unexpected = new HashSet<TServerInstance>(deleted);
        unexpected.removeAll(this.serversToShutdown);
        if (unexpected.size() > 0 && this.stillMaster() && !this.getMasterGoalState().equals((Object)MasterGoalState.CLEAN_STOP)) {
            log.warn((Object)("Lost servers " + unexpected));
        }
        this.serversToShutdown.removeAll(deleted);
        this.badServers.keySet().removeAll(deleted);
        SortedMap<KeyExtent, TServerInstance> sortedMap = this.badServers;
        synchronized (sortedMap) {
            Master.cleanListByHostAndPort(this.badServers.keySet(), deleted, added);
        }
        sortedMap = this.serversToShutdown;
        synchronized (sortedMap) {
            Master.cleanListByHostAndPort(this.serversToShutdown, deleted, added);
        }
        sortedMap = this.migrations;
        synchronized (sortedMap) {
            Iterator<Map.Entry<KeyExtent, TServerInstance>> iter = this.migrations.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<KeyExtent, TServerInstance> entry = iter.next();
                if (!deleted.contains(entry.getValue())) continue;
                log.info((Object)("Canceling migration of " + entry.getKey() + " to " + entry.getValue()));
                iter.remove();
            }
        }
        this.nextEvent.event("There are now %d tablet servers", current.size());
    }

    private static void cleanListByHostAndPort(Collection<TServerInstance> badServers, Set<TServerInstance> deleted, Set<TServerInstance> added) {
        Iterator<TServerInstance> badIter = badServers.iterator();
        block0: while (badIter.hasNext()) {
            TServerInstance bad = badIter.next();
            for (TServerInstance add : added) {
                if (!bad.hostPort().equals(add.hostPort())) continue;
                badIter.remove();
                break;
            }
            for (TServerInstance del : deleted) {
                if (!bad.hostPort().equals(del.hostPort())) continue;
                badIter.remove();
                continue block0;
            }
        }
    }

    @Override
    public void stateChanged(String tableId, TableState state) {
        this.nextEvent.event("Table state in zookeeper changed for %s to %s", tableId, state);
    }

    @Override
    public void initialize(Map<String, TableState> tableIdToStateMap) {
    }

    @Override
    public void sessionExpired() {
    }

    @Override
    public Set<String> onlineTables() {
        HashSet<String> result = new HashSet<String>();
        if (this.getMasterState() != MasterState.NORMAL) {
            if (this.getMasterState() != MasterState.UNLOAD_METADATA_TABLETS) {
                result.add("!0");
            }
            return result;
        }
        TableManager manager = TableManager.getInstance();
        for (String tableId : Tables.getIdToNameMap((Instance)this.instance).keySet()) {
            TableState state = manager.getTableState(tableId);
            if (state == null || state != TableState.ONLINE) continue;
            result.add(tableId);
        }
        return result;
    }

    @Override
    public Set<TServerInstance> onlineTabletServers() {
        return this.tserverSet.getCurrentServers();
    }

    @Override
    public Collection<MergeInfo> merges() {
        ArrayList<MergeInfo> result = new ArrayList<MergeInfo>();
        for (String tableId : Tables.getIdToNameMap((Instance)this.instance).keySet()) {
            result.add(this.getMergeInfo(new Text(tableId)));
        }
        return result;
    }

    public void killTServer(TServerInstance server) {
        this.nextEvent.event("Forcing server down %s", server);
        this.serversToShutdown.add(server);
    }

    public void shutdownTServer(TServerInstance server) {
        this.nextEvent.event("Tablet Server shutdown requested for %s", server);
        this.serversToShutdown.add(server);
    }

    public EventCoordinator getEventCoordinator() {
        return this.nextEvent;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public AccumuloConfiguration getSystemConfiguration() {
        return this.serverConfig.getConfiguration();
    }

    public ServerConfiguration getConfiguration() {
        return this.serverConfig;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public void updateRecoveryInProgress(String file) {
        this.recoveriesInProgress.add(file);
    }

    private static class MasterLockWatcher
    implements ZooLock.AsyncLockWatcher {
        boolean acquiredLock = false;
        boolean failedToAcquireLock = false;

        private MasterLockWatcher() {
        }

        public void lostLock(ZooLock.LockLossReason reason) {
            Halt.halt("Master lock in zookeeper lost (reason = " + reason + "), exiting!", -1);
        }

        public void unableToMonitorLockNode(final Throwable e) {
            Halt.halt(-1, new Runnable(){

                @Override
                public void run() {
                    log.fatal((Object)"No longer able to monitor master lock node", e);
                }
            });
        }

        public synchronized void acquiredLock() {
            if (this.acquiredLock || this.failedToAcquireLock) {
                Halt.halt("Zoolock in unexpected state AL " + this.acquiredLock + " " + this.failedToAcquireLock, -1);
            }
            this.acquiredLock = true;
            this.notifyAll();
        }

        public synchronized void failedToAcquireLock(Exception e) {
            log.warn((Object)("Failed to get master lock " + e));
            if (this.acquiredLock) {
                Halt.halt("Zoolock in unexpected state FAL " + this.acquiredLock + " " + this.failedToAcquireLock, -1);
            }
            this.failedToAcquireLock = true;
            this.notifyAll();
        }

        public synchronized void waitForChange() {
            while (!this.acquiredLock && !this.failedToAcquireLock) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class StatusThread
    extends Daemon {
        private StatusThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            this.setName("Status Thread");
            EventCoordinator.Listener eventListener = Master.this.nextEvent.getListener();
            while (Master.this.stillMaster()) {
                int count = 0;
                long wait = 10000L;
                try {
                    switch (Master.this.getMasterGoalState()) {
                        case NORMAL: {
                            Master.this.setMasterState(MasterState.NORMAL);
                            break;
                        }
                        case SAFE_MODE: {
                            if (Master.this.getMasterState() == MasterState.NORMAL) {
                                Master.this.setMasterState(MasterState.SAFE_MODE);
                            }
                            if (Master.this.getMasterState() != MasterState.HAVE_LOCK) break;
                            Master.this.setMasterState(MasterState.SAFE_MODE);
                            break;
                        }
                        case CLEAN_STOP: {
                            switch (Master.this.getMasterState()) {
                                case NORMAL: {
                                    Master.this.setMasterState(MasterState.SAFE_MODE);
                                    break;
                                }
                                case SAFE_MODE: {
                                    count = Master.this.nonMetaDataTabletsAssignedOrHosted();
                                    log.debug((Object)String.format("There are %d non-metadata tablets assigned or hosted", count));
                                    if (count != 0) break;
                                    Master.this.setMasterState(MasterState.UNLOAD_METADATA_TABLETS);
                                    break;
                                }
                                case UNLOAD_METADATA_TABLETS: {
                                    count = Master.this.assignedOrHosted(METADATA_TABLE_ID);
                                    log.debug((Object)String.format("There are %d metadata tablets assigned or hosted", count));
                                    if (count != 1) break;
                                    Master.this.setMasterState(MasterState.UNLOAD_ROOT_TABLET);
                                    break;
                                }
                                case UNLOAD_ROOT_TABLET: {
                                    count = Master.this.assignedOrHosted(METADATA_TABLE_ID);
                                    if (count > 0) {
                                        log.debug((Object)String.format("The root tablet is still assigned or hosted", new Object[0]));
                                    }
                                    if (count != 0) break;
                                    Set<TServerInstance> currentServers = Master.this.tserverSet.getCurrentServers();
                                    log.debug((Object)("stopping " + currentServers.size() + " tablet servers"));
                                    for (TServerInstance server : currentServers) {
                                        try {
                                            Master.this.serversToShutdown.add(server);
                                            Master.this.tserverSet.getConnection(server).fastHalt(Master.this.masterLock);
                                        }
                                        catch (TException e) {}
                                        continue;
                                        finally {
                                            Master.this.tserverSet.remove(server);
                                        }
                                    }
                                    if (currentServers.size() != 0) break;
                                    Master.this.setMasterState(MasterState.STOP);
                                    break;
                                }
                            }
                            break;
                        }
                    }
                    wait = this.updateStatus();
                    eventListener.waitForEvents(wait);
                }
                catch (Throwable t) {
                    log.error((Object)"Error balancing tablets", t);
                    UtilWaitThread.sleep((long)1000L);
                    continue;
                }
                break;
            }
            return;
        }

        private long updateStatus() throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
            Master.this.tserverStatus = Collections.synchronizedSortedMap(Master.this.gatherTableInformation());
            this.checkForHeldServer(Master.this.tserverStatus);
            if (!Master.this.badServers.isEmpty()) {
                log.debug((Object)("not balancing because the balance information is out-of-date " + Master.this.badServers.keySet()));
            } else if (Master.this.notHosted() > 0) {
                log.debug((Object)"not balancing because there are unhosted tablets");
            } else if (Master.this.getMasterGoalState() == MasterGoalState.CLEAN_STOP) {
                log.debug((Object)"not balancing because the master is attempting to stop cleanly");
            } else if (!Master.this.serversToShutdown.isEmpty()) {
                log.debug((Object)("not balancing while shutting down servers " + Master.this.serversToShutdown));
            } else {
                return this.balanceTablets();
            }
            return 10000L;
        }

        private void checkForHeldServer(SortedMap<TServerInstance, TabletServerStatus> tserverStatus) {
            TServerInstance instance = null;
            int crazyHoldTime = 0;
            int someHoldTime = 0;
            long maxWait = Master.this.getSystemConfiguration().getTimeInMillis(Property.TSERV_HOLD_TIME_SUICIDE);
            for (Map.Entry<TServerInstance, TabletServerStatus> entry : tserverStatus.entrySet()) {
                if (entry.getValue().getHoldTime() <= 0L) continue;
                ++someHoldTime;
                if (entry.getValue().getHoldTime() <= maxWait) continue;
                instance = entry.getKey();
                ++crazyHoldTime;
            }
            if (crazyHoldTime == 1 && someHoldTime == 1 && tserverStatus.size() > 1) {
                log.warn((Object)("Tablet server " + instance + " exceeded maximum hold time: attempting to kill it"));
                try {
                    LiveTServerSet.TServerConnection connection = Master.this.tserverSet.getConnection(instance);
                    if (connection != null) {
                        connection.fastHalt(Master.this.masterLock);
                    }
                }
                catch (TException e) {
                    log.error((Object)e, (Throwable)e);
                }
                Master.this.tserverSet.remove(instance);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long balanceTablets() {
            ArrayList<TabletMigration> migrationsOut = new ArrayList<TabletMigration>();
            HashSet migrationsCopy = new HashSet();
            SortedMap sortedMap = Master.this.migrations;
            synchronized (sortedMap) {
                migrationsCopy.addAll(Master.this.migrations.keySet());
            }
            long wait = Master.this.tabletBalancer.balance(Collections.unmodifiableSortedMap(Master.this.tserverStatus), Collections.unmodifiableSet(migrationsCopy), migrationsOut);
            for (TabletMigration m : TabletBalancer.checkMigrationSanity(Master.this.tserverStatus.keySet(), migrationsOut)) {
                if (Master.this.migrations.containsKey(m.tablet)) {
                    log.warn((Object)("balancer requested migration more than once, skipping " + m));
                    continue;
                }
                Master.this.migrations.put(m.tablet, m.newServer);
                log.debug((Object)("migration " + m));
            }
            if (migrationsOut.size() > 0) {
                Master.this.nextEvent.event("Migrating %d more tablets, %d total", migrationsOut.size(), Master.this.migrations.size());
            }
            return wait;
        }
    }

    private class MigrationCleanupThread
    extends Daemon {
        private MigrationCleanupThread() {
        }

        public void run() {
            this.setName("Migration Cleanup Thread");
            while (Master.this.stillMaster()) {
                if (!Master.this.migrations.isEmpty()) {
                    try {
                        this.cleanupMutations();
                    }
                    catch (Exception ex) {
                        log.error((Object)"Error cleaning up migrations", (Throwable)ex);
                    }
                }
                UtilWaitThread.sleep((long)300000L);
            }
        }

        private void cleanupMutations() throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
            Connector connector = Master.this.getConnector();
            Scanner scanner = connector.createScanner("!METADATA", Constants.NO_AUTHS);
            Constants.METADATA_PREV_ROW_COLUMN.fetch((ScannerBase)scanner);
            HashSet<KeyExtent> found = new HashSet<KeyExtent>();
            for (Map.Entry entry : scanner) {
                KeyExtent extent = new KeyExtent(((Key)entry.getKey()).getRow(), (Value)entry.getValue());
                if (!Master.this.migrations.containsKey(extent)) continue;
                found.add(extent);
            }
            Master.this.migrations.keySet().retainAll(found);
        }
    }

    private class TabletGroupWatcher
    extends Daemon {
        final TabletStateStore store;
        final TabletGroupWatcher dependentWatcher;
        final TableStats stats = new TableStats();

        TabletGroupWatcher(TabletStateStore store, TabletGroupWatcher dependentWatcher) {
            this.store = store;
            this.dependentWatcher = dependentWatcher;
        }

        Map<Text, TableCounts> getStats() {
            return this.stats.getLast();
        }

        TableCounts getStats(Text tableId) {
            return this.stats.getLast(tableId);
        }

        public void run() {
            Thread.currentThread().setName("Watching " + this.store.name());
            int[] oldCounts = new int[TabletState.values().length];
            EventCoordinator.Listener eventListener = Master.this.nextEvent.getListener();
            while (Master.this.stillMaster()) {
                int totalUnloaded = 0;
                int unloaded = 0;
                try {
                    HashMap<Text, MergeStats> mergeStatsCache = new HashMap<Text, MergeStats>();
                    TreeMap currentTServers = new TreeMap();
                    for (TServerInstance entry : Master.this.tserverSet.getCurrentServers()) {
                        currentTServers.put(entry, Master.this.tserverStatus.get(entry));
                    }
                    if (currentTServers.size() == 0) {
                        eventListener.waitForEvents(60000L);
                        continue;
                    }
                    TreeMap<TServerInstance, TabletServerStatus> destinations = new TreeMap<TServerInstance, TabletServerStatus>(currentTServers);
                    destinations.keySet().removeAll(Master.this.serversToShutdown);
                    ArrayList<Assignment> assignments = new ArrayList<Assignment>();
                    ArrayList<Assignment> assigned = new ArrayList<Assignment>();
                    ArrayList<TabletLocationState> assignedToDeadServers = new ArrayList<TabletLocationState>();
                    HashMap<KeyExtent, TServerInstance> unassigned = new HashMap<KeyExtent, TServerInstance>();
                    int[] counts = new int[TabletState.values().length];
                    this.stats.begin();
                    for (TabletLocationState tls : this.store) {
                        Text tableId;
                        MergeStats mergeStats;
                        if (tls == null || TableManager.getInstance().getTableState(tls.extent.getTableId().toString()) == null) continue;
                        if (unassigned.size() + unloaded > 5000 * currentTServers.size()) {
                            this.flushChanges(destinations, assignments, assigned, assignedToDeadServers, unassigned);
                            assignments.clear();
                            assigned.clear();
                            assignedToDeadServers.clear();
                            unassigned.clear();
                            unloaded = 0;
                            eventListener.waitForEvents(60000L);
                        }
                        if ((mergeStats = (MergeStats)mergeStatsCache.get(tableId = tls.extent.getTableId())) == null) {
                            mergeStats = new MergeStats(Master.this.getMergeInfo(tls.extent));
                            mergeStatsCache.put(tableId, mergeStats);
                        }
                        TabletGoalState goal = Master.this.getGoalState(tls, mergeStats.getMergeInfo());
                        TServerInstance server = tls.getServer();
                        TabletState state = tls.getState(currentTServers.keySet());
                        this.stats.update(tableId, state);
                        mergeStats.update(tls.extent, state, tls.chopped, !tls.walogs.isEmpty());
                        this.sendChopRequest(mergeStats.getMergeInfo(), state, tls);
                        this.sendSplitRequest(mergeStats.getMergeInfo(), state, tls);
                        if (state == TabletState.ASSIGNED) {
                            goal = TabletGoalState.HOSTED;
                        }
                        if (goal == TabletGoalState.UNASSIGNED && state == TabletState.HOSTED && ((Object)Master.this.serversToShutdown).equals(currentTServers.keySet()) && this.dependentWatcher != null && this.dependentWatcher.assignedOrHosted() > 0) {
                            goal = TabletGoalState.HOSTED;
                        }
                        if (goal == TabletGoalState.HOSTED) {
                            if (state != TabletState.HOSTED && !tls.walogs.isEmpty() && Master.this.recoveryManager.recoverLogs(tls.extent, tls.walogs)) continue;
                            switch (state) {
                                case HOSTED: {
                                    if (!server.equals(Master.this.migrations.get(tls.extent))) break;
                                    Master.this.migrations.remove(tls.extent);
                                    break;
                                }
                                case ASSIGNED_TO_DEAD_SERVER: {
                                    assignedToDeadServers.add(tls);
                                    if (!server.equals(Master.this.migrations.get(tls.extent))) break;
                                    Master.this.migrations.remove(tls.extent);
                                    break;
                                }
                                case UNASSIGNED: {
                                    TServerInstance dest = (TServerInstance)Master.this.migrations.get(tls.extent);
                                    if (dest != null) {
                                        if (destinations.keySet().contains(dest)) {
                                            assignments.add(new Assignment(tls.extent, dest));
                                            break;
                                        }
                                        Master.this.migrations.remove(tls.extent);
                                        unassigned.put(tls.extent, server);
                                        break;
                                    }
                                    unassigned.put(tls.extent, server);
                                    break;
                                }
                                case ASSIGNED: {
                                    assigned.add(new Assignment(tls.extent, tls.future));
                                }
                            }
                        } else {
                            switch (state) {
                                case UNASSIGNED: {
                                    break;
                                }
                                case ASSIGNED_TO_DEAD_SERVER: {
                                    assignedToDeadServers.add(tls);
                                    break;
                                }
                                case HOSTED: {
                                    LiveTServerSet.TServerConnection conn = Master.this.tserverSet.getConnection(server);
                                    if (conn != null) {
                                        conn.unloadTablet(Master.this.masterLock, tls.extent, goal != TabletGoalState.DELETED);
                                        ++unloaded;
                                        ++totalUnloaded;
                                        break;
                                    }
                                    log.warn((Object)("Could not connect to server " + server));
                                    break;
                                }
                            }
                        }
                        int n = state.ordinal();
                        counts[n] = counts[n] + 1;
                    }
                    this.flushChanges(destinations, assignments, assigned, assignedToDeadServers, unassigned);
                    this.stats.end();
                    for (TabletState state : TabletState.values()) {
                        int i = state.ordinal();
                        if (counts[i] <= 0 || counts[i] == oldCounts[i]) continue;
                        Master.this.nextEvent.event("[%s]: %d tablets are %s", this.store.name(), counts[i], state.name());
                    }
                    log.debug((Object)String.format("[%s]: scan time %.2f seconds", this.store.name(), (double)this.stats.getScanTime() / 1000.0));
                    oldCounts = counts;
                    if (totalUnloaded > 0) {
                        Master.this.nextEvent.event("[%s]: %d tablets unloaded", this.store.name(), totalUnloaded);
                    }
                    this.updateMergeState(mergeStatsCache);
                    log.debug((Object)String.format("[%s] sleeping for %.2f seconds", this.store.name(), 60.0));
                    eventListener.waitForEvents(60000L);
                }
                catch (Exception ex) {
                    log.error((Object)("Error processing table state for store " + this.store.name()), (Throwable)ex);
                    UtilWaitThread.sleep((long)1000L);
                }
            }
        }

        private int assignedOrHosted() {
            int result = 0;
            for (TableCounts counts : this.stats.getLast().values()) {
                result += counts.assigned() + counts.hosted();
            }
            return result;
        }

        private void sendSplitRequest(MergeInfo info, TabletState state, TabletLocationState tls) {
            if (!info.getState().equals((Object)MergeState.SPLITTING)) {
                return;
            }
            if (!info.isDelete()) {
                return;
            }
            if (!state.equals((Object)TabletState.HOSTED)) {
                return;
            }
            KeyExtent range = info.getRange();
            if (tls.extent.overlaps(range)) {
                for (Text splitPoint : new Text[]{range.getPrevEndRow(), range.getEndRow()}) {
                    if (splitPoint == null || !tls.extent.contains((BinaryComparable)splitPoint) || splitPoint.equals((Object)tls.extent.getEndRow()) || splitPoint.equals((Object)tls.extent.getPrevEndRow())) continue;
                    try {
                        LiveTServerSet.TServerConnection conn = Master.this.tserverSet.getConnection(tls.current);
                        if (conn != null) {
                            log.info((Object)("Asking " + tls.current + " to split " + tls.extent + " at " + splitPoint));
                            conn.splitTablet(Master.this.masterLock, tls.extent, splitPoint);
                            continue;
                        }
                        log.warn((Object)("Not connected to server " + tls.current));
                    }
                    catch (NotServingTabletException e) {
                        log.debug((Object)("Error asking tablet server to split a tablet: " + (Object)((Object)e)));
                    }
                    catch (Exception e) {
                        log.warn((Object)("Error asking tablet server to split a tablet: " + e));
                    }
                }
            }
        }

        private void sendChopRequest(MergeInfo info, TabletState state, TabletLocationState tls) {
            if (!info.getState().equals((Object)MergeState.WAITING_FOR_CHOPPED)) {
                return;
            }
            if (!state.equals((Object)TabletState.HOSTED)) {
                return;
            }
            if (tls.chopped) {
                return;
            }
            if (info.needsToBeChopped(tls.extent)) {
                try {
                    LiveTServerSet.TServerConnection conn = Master.this.tserverSet.getConnection(tls.current);
                    if (conn != null) {
                        log.info((Object)("Asking " + tls.current + " to chop " + tls.extent));
                        conn.chop(Master.this.masterLock, tls.extent);
                    } else {
                        log.warn((Object)("Could not connect to server " + tls.current));
                    }
                }
                catch (TException e) {
                    log.warn((Object)"Communications error asking tablet server to chop a tablet");
                }
            }
        }

        private void updateMergeState(Map<Text, MergeStats> mergeStatsCache) {
            for (MergeStats stats : mergeStatsCache.values()) {
                try {
                    MergeState update = stats.nextMergeState(Master.this.getConnector(), Master.this);
                    if (update == MergeState.COMPLETE) {
                        update = MergeState.NONE;
                    }
                    if (update != stats.getMergeInfo().getState()) {
                        Master.this.setMergeState(stats.getMergeInfo(), update);
                    }
                    if (update != MergeState.MERGING) continue;
                    try {
                        if (stats.getMergeInfo().isDelete()) {
                            this.deleteTablets(stats.getMergeInfo());
                        } else {
                            this.mergeMetadataRecords(stats.getMergeInfo());
                        }
                        update = MergeState.COMPLETE;
                        Master.this.setMergeState(stats.getMergeInfo(), update);
                    }
                    catch (Exception ex) {
                        log.error((Object)"Unable merge metadata table records", (Throwable)ex);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)("Unable to update merge state for merge " + stats.getMergeInfo().getRange()), (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteTablets(MergeInfo info) throws AccumuloException {
            block16: {
                KeyExtent range = info.getRange();
                log.debug((Object)("Deleting tablets for " + range));
                char timeType = '\u0000';
                KeyExtent followingTablet = null;
                if (range.getEndRow() != null) {
                    Key nextExtent = new Key(range.getEndRow()).followingKey(PartialKey.ROW);
                    followingTablet = this.getHighTablet(new KeyExtent(range.getTableId(), nextExtent.getRow(), range.getEndRow()));
                    log.debug((Object)("Found following tablet " + followingTablet));
                }
                try {
                    Connector conn = Master.this.getConnector();
                    Text start = range.getPrevEndRow();
                    if (start == null) {
                        start = new Text();
                    }
                    log.debug((Object)("Making file deletion entries for " + range));
                    Range deleteRange = new Range(KeyExtent.getMetadataEntry((Text)range.getTableId(), (Text)start), false, KeyExtent.getMetadataEntry((Text)range.getTableId(), (Text)range.getEndRow()), true);
                    Scanner scanner = conn.createScanner("!METADATA", Constants.NO_AUTHS);
                    scanner.setRange(deleteRange);
                    Constants.METADATA_DIRECTORY_COLUMN.fetch((ScannerBase)scanner);
                    Constants.METADATA_TIME_COLUMN.fetch((ScannerBase)scanner);
                    scanner.fetchColumnFamily(Constants.METADATA_DATAFILE_COLUMN_FAMILY);
                    scanner.fetchColumnFamily(Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY);
                    TreeSet<String> datafiles = new TreeSet<String>();
                    for (Map.Entry entry : scanner) {
                        Key key = (Key)entry.getKey();
                        if (key.compareColumnFamily(Constants.METADATA_DATAFILE_COLUMN_FAMILY) == 0) {
                            datafiles.add(key.getColumnQualifier().toString());
                            if (datafiles.size() <= 1000) continue;
                            MetadataTable.addDeleteEntries(range, datafiles, SecurityConstants.getSystemCredentials());
                            datafiles.clear();
                            continue;
                        }
                        if (Constants.METADATA_TIME_COLUMN.hasColumns(key)) {
                            timeType = ((Value)entry.getValue()).toString().charAt(0);
                            continue;
                        }
                        if (key.compareColumnFamily(Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY) == 0) {
                            throw new IllegalStateException("Tablet " + key.getRow() + " is assigned during a merge!");
                        }
                        if (!Constants.METADATA_DIRECTORY_COLUMN.hasColumns(key)) continue;
                        datafiles.add(((Value)entry.getValue()).toString());
                        if (datafiles.size() <= 1000) continue;
                        MetadataTable.addDeleteEntries(range, datafiles, SecurityConstants.getSystemCredentials());
                        datafiles.clear();
                    }
                    MetadataTable.addDeleteEntries(range, datafiles, SecurityConstants.getSystemCredentials());
                    BatchWriter bw = conn.createBatchWriter("!METADATA", new BatchWriterConfig());
                    try {
                        this.deleteTablets(deleteRange, bw, conn);
                    }
                    finally {
                        bw.close();
                    }
                    if (followingTablet != null) {
                        log.debug((Object)("Updating prevRow of " + followingTablet + " to " + range.getPrevEndRow()));
                        bw = conn.createBatchWriter("!METADATA", new BatchWriterConfig());
                        try {
                            Mutation m = new Mutation(followingTablet.getMetadataEntry());
                            Constants.METADATA_PREV_ROW_COLUMN.put(m, KeyExtent.encodePrevEndRow((Text)range.getPrevEndRow()));
                            Constants.METADATA_CHOPPED_COLUMN.putDelete(m);
                            bw.addMutation(m);
                            bw.flush();
                            break block16;
                        }
                        finally {
                            bw.close();
                        }
                    }
                    log.debug((Object)("Recreating the last tablet to point to " + range.getPrevEndRow()));
                    MetadataTable.addTablet(new KeyExtent(range.getTableId(), null, range.getPrevEndRow()), "/default_tablet", SecurityConstants.getSystemCredentials(), timeType, Master.this.masterLock);
                }
                catch (Exception ex) {
                    throw new AccumuloException((Throwable)ex);
                }
            }
        }

        private void mergeMetadataRecords(MergeInfo info) throws AccumuloException {
            KeyExtent range = info.getRange();
            log.debug((Object)("Merging metadata for " + range));
            KeyExtent stop = this.getHighTablet(range);
            log.debug((Object)("Highest tablet is " + stop));
            Value firstPrevRowValue = null;
            Text stopRow = stop.getMetadataEntry();
            Text start = range.getPrevEndRow();
            if (start == null) {
                start = new Text();
            }
            Range scanRange = new Range(KeyExtent.getMetadataEntry((Text)range.getTableId(), (Text)start), false, stopRow, false);
            if (range.isMeta()) {
                scanRange = scanRange.clip(Constants.METADATA_ROOT_TABLET_KEYSPACE);
            }
            BatchWriter bw = null;
            try {
                long fileCount = 0L;
                Connector conn = Master.this.getConnector();
                bw = conn.createBatchWriter("!METADATA", new BatchWriterConfig());
                Scanner scanner = conn.createScanner("!METADATA", Constants.NO_AUTHS);
                scanner.setRange(scanRange);
                Constants.METADATA_PREV_ROW_COLUMN.fetch((ScannerBase)scanner);
                Constants.METADATA_TIME_COLUMN.fetch((ScannerBase)scanner);
                Constants.METADATA_DIRECTORY_COLUMN.fetch((ScannerBase)scanner);
                scanner.fetchColumnFamily(Constants.METADATA_DATAFILE_COLUMN_FAMILY);
                Mutation m = new Mutation(stopRow);
                String maxLogicalTime = null;
                for (Map.Entry entry : scanner) {
                    Key key = (Key)entry.getKey();
                    Value value = (Value)entry.getValue();
                    if (key.getColumnFamily().equals((Object)Constants.METADATA_DATAFILE_COLUMN_FAMILY)) {
                        m.put(key.getColumnFamily(), key.getColumnQualifier(), value);
                        ++fileCount;
                        continue;
                    }
                    if (Constants.METADATA_PREV_ROW_COLUMN.hasColumns(key) && firstPrevRowValue == null) {
                        log.debug((Object)("prevRow entry for lowest tablet is " + value));
                        firstPrevRowValue = new Value(value);
                        continue;
                    }
                    if (Constants.METADATA_TIME_COLUMN.hasColumns(key)) {
                        maxLogicalTime = TabletTime.maxMetadataTime(maxLogicalTime, value.toString());
                        continue;
                    }
                    if (!Constants.METADATA_DIRECTORY_COLUMN.hasColumns(key) || range.isMeta()) continue;
                    bw.addMutation(MetadataTable.createDeleteMutation(range.getTableId().toString(), ((Value)entry.getValue()).toString()));
                }
                scanner = conn.createScanner("!METADATA", Constants.NO_AUTHS);
                Range last = new Range(stopRow);
                if (range.isMeta()) {
                    last = last.clip(Constants.METADATA_ROOT_TABLET_KEYSPACE);
                }
                scanner.setRange(last);
                Constants.METADATA_TIME_COLUMN.fetch((ScannerBase)scanner);
                for (Map.Entry entry : scanner) {
                    if (!Constants.METADATA_TIME_COLUMN.hasColumns((Key)entry.getKey())) continue;
                    maxLogicalTime = TabletTime.maxMetadataTime(maxLogicalTime, ((Value)entry.getValue()).toString());
                }
                if (maxLogicalTime != null) {
                    Constants.METADATA_TIME_COLUMN.put(m, new Value(maxLogicalTime.getBytes()));
                }
                if (!m.getUpdates().isEmpty()) {
                    bw.addMutation(m);
                }
                bw.flush();
                log.debug((Object)("Moved " + fileCount + " files to " + stop));
                if (firstPrevRowValue == null) {
                    log.debug((Object)"tablet already merged");
                    return;
                }
                stop.setPrevEndRow(KeyExtent.decodePrevEndRow((Value)firstPrevRowValue));
                Mutation updatePrevRow = stop.getPrevRowUpdateMutation();
                log.debug((Object)("Setting the prevRow for last tablet: " + stop));
                bw.addMutation(updatePrevRow);
                bw.flush();
                this.deleteTablets(scanRange, bw, conn);
                m = new Mutation(stopRow);
                Constants.METADATA_CHOPPED_COLUMN.putDelete(m);
                bw.addMutation(m);
                bw.flush();
            }
            catch (Exception ex) {
                throw new AccumuloException((Throwable)ex);
            }
            finally {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (Exception ex) {
                        throw new AccumuloException((Throwable)ex);
                    }
                }
            }
        }

        private void deleteTablets(Range scanRange, BatchWriter bw, Connector conn) throws TableNotFoundException, MutationsRejectedException {
            Scanner scanner = conn.createScanner("!METADATA", Constants.NO_AUTHS);
            log.debug((Object)("Deleting range " + scanRange));
            scanner.setRange(scanRange);
            RowIterator rowIter = new RowIterator((Iterable)scanner);
            while (rowIter.hasNext()) {
                Iterator row = rowIter.next();
                Mutation m = null;
                while (row.hasNext()) {
                    Map.Entry entry = (Map.Entry)row.next();
                    Key key = (Key)entry.getKey();
                    if (m == null) {
                        m = new Mutation(key.getRow());
                    }
                    m.putDelete(key.getColumnFamily(), key.getColumnQualifier());
                    log.debug((Object)("deleting entry " + key));
                }
                bw.addMutation(m);
            }
            bw.flush();
        }

        private KeyExtent getHighTablet(KeyExtent range) throws AccumuloException {
            try {
                Connector conn = Master.this.getConnector();
                Scanner scanner = conn.createScanner("!METADATA", Constants.NO_AUTHS);
                Constants.METADATA_PREV_ROW_COLUMN.fetch((ScannerBase)scanner);
                KeyExtent start = new KeyExtent(range.getTableId(), range.getEndRow(), null);
                scanner.setRange(new Range(start.getMetadataEntry(), null));
                Iterator iterator = scanner.iterator();
                if (!iterator.hasNext()) {
                    throw new AccumuloException("No last tablet for a merge " + range);
                }
                Map.Entry entry = (Map.Entry)iterator.next();
                KeyExtent highTablet = new KeyExtent(((Key)entry.getKey()).getRow(), KeyExtent.decodePrevEndRow((Value)((Value)entry.getValue())));
                if (highTablet.getTableId() != range.getTableId()) {
                    throw new AccumuloException("No last tablet for merge " + range + " " + highTablet);
                }
                return highTablet;
            }
            catch (Exception ex) {
                throw new AccumuloException("Unexpected failure finding the last tablet for a merge " + range, (Throwable)ex);
            }
        }

        private void flushChanges(SortedMap<TServerInstance, TabletServerStatus> currentTServers, List<Assignment> assignments, List<Assignment> assigned, List<TabletLocationState> assignedToDeadServers, Map<KeyExtent, TServerInstance> unassigned) throws DistributedStoreException, TException {
            if (!assignedToDeadServers.isEmpty()) {
                int maxServersToShow = Math.min(assignedToDeadServers.size(), 100);
                log.debug((Object)(assignedToDeadServers.size() + " assigned to dead servers: " + assignedToDeadServers.subList(0, maxServersToShow) + "..."));
                this.store.unassign(assignedToDeadServers);
                Master.this.nextEvent.event("Marked %d tablets as unassigned because they don't have current servers", assignedToDeadServers.size());
            }
            if (!currentTServers.isEmpty()) {
                HashMap<KeyExtent, TServerInstance> assignedOut = new HashMap<KeyExtent, TServerInstance>();
                Master.this.tabletBalancer.getAssignments(Collections.unmodifiableSortedMap(currentTServers), Collections.unmodifiableMap(unassigned), assignedOut);
                for (Map.Entry assignment : assignedOut.entrySet()) {
                    if (unassigned.containsKey(assignment.getKey())) {
                        if (assignment.getValue() == null) continue;
                        log.debug((Object)(this.store.name() + " assigning tablet " + assignment));
                        assignments.add(new Assignment((KeyExtent)assignment.getKey(), (TServerInstance)assignment.getValue()));
                        continue;
                    }
                    log.warn((Object)(this.store.name() + " load balancer assigning tablet that was not nominated for assignment " + assignment.getKey()));
                }
                if (!unassigned.isEmpty() && assignedOut.isEmpty()) {
                    log.warn((Object)"Load balancer failed to assign any tablets");
                }
            }
            if (assignments.size() > 0) {
                log.info((Object)String.format("Assigning %d tablets", assignments.size()));
                this.store.setFutureLocations(assignments);
            }
            assignments.addAll(assigned);
            for (Assignment a : assignments) {
                LiveTServerSet.TServerConnection conn = Master.this.tserverSet.getConnection(a.server);
                if (conn != null) {
                    conn.assignTablet(Master.this.masterLock, a.tablet);
                    continue;
                }
                log.warn((Object)("Could not connect to server " + a.server));
            }
        }
    }

    static enum TabletGoalState {
        HOSTED,
        UNASSIGNED,
        DELETED;

    }

    private class MasterClientServiceHandler
    implements MasterClientService.Iface {
        private MasterClientServiceHandler() {
        }

        protected String checkTableId(String tableName, TableOperation operation) throws ThriftTableOperationException {
            String tableId = (String)Tables.getNameToIdMap((Instance)Master.this.getConfiguration().getInstance()).get(tableName);
            if (tableId == null) {
                throw new ThriftTableOperationException(null, tableName, operation, TableOperationExceptionType.NOTFOUND, null);
            }
            return tableId;
        }

        public long initiateFlush(TInfo tinfo, TCredentials c, String tableId) throws ThriftSecurityException, ThriftTableOperationException, TException {
            byte[] fid;
            Master.this.security.canFlush(c, tableId);
            String zTablePath = "/accumulo/" + Master.this.getConfiguration().getInstance().getInstanceID() + "/tables" + "/" + tableId + "/flush-id";
            ZooReaderWriter zoo = ZooReaderWriter.getInstance();
            try {
                fid = zoo.mutate(zTablePath, null, null, new ZooReaderWriter.Mutator(){

                    public byte[] mutate(byte[] currentValue) throws Exception {
                        long flushID = Long.parseLong(new String(currentValue));
                        return ("" + ++flushID).getBytes();
                    }
                });
            }
            catch (KeeperException.NoNodeException nne) {
                throw new ThriftTableOperationException(tableId, null, TableOperation.FLUSH, TableOperationExceptionType.NOTFOUND, null);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
                throw new ThriftTableOperationException(tableId, null, TableOperation.FLUSH, TableOperationExceptionType.OTHER, null);
            }
            return Long.parseLong(new String(fid));
        }

        public void waitForFlush(TInfo tinfo, TCredentials c, String tableId, ByteBuffer startRow, ByteBuffer endRow, long flushID, long maxLoops) throws ThriftSecurityException, ThriftTableOperationException, TException {
            Master.this.security.canFlush(c, tableId);
            if (endRow != null && startRow != null && ByteBufferUtil.toText((ByteBuffer)startRow).compareTo((BinaryComparable)ByteBufferUtil.toText((ByteBuffer)endRow)) >= 0) {
                throw new ThriftTableOperationException(tableId, null, TableOperation.FLUSH, TableOperationExceptionType.BAD_RANGE, "start row must be less than end row");
            }
            HashSet<TServerInstance> serversToFlush = new HashSet<TServerInstance>(Master.this.tserverSet.getCurrentServers());
            for (long l = 0L; l < maxLoops; ++l) {
                for (TServerInstance instance : serversToFlush) {
                    try {
                        LiveTServerSet.TServerConnection server = Master.this.tserverSet.getConnection(instance);
                        if (server == null) continue;
                        server.flush(Master.this.masterLock, tableId, ByteBufferUtil.toBytes((ByteBuffer)startRow), ByteBufferUtil.toBytes((ByteBuffer)endRow));
                    }
                    catch (TException ex) {
                        log.error((Object)ex.toString());
                    }
                }
                if (l == maxLoops - 1L) break;
                UtilWaitThread.sleep((long)50L);
                serversToFlush.clear();
                try {
                    Connector conn = Master.this.getConnector();
                    IsolatedScanner scanner = new IsolatedScanner(conn.createScanner("!METADATA", Constants.NO_AUTHS));
                    Constants.METADATA_FLUSH_COLUMN.fetch((ScannerBase)scanner);
                    Constants.METADATA_DIRECTORY_COLUMN.fetch((ScannerBase)scanner);
                    scanner.fetchColumnFamily(Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY);
                    scanner.fetchColumnFamily(Constants.METADATA_LOG_COLUMN_FAMILY);
                    scanner.setRange(new KeyExtent(new Text(tableId), null, ByteBufferUtil.toText((ByteBuffer)startRow)).toMetadataRange());
                    RowIterator ri = new RowIterator((Iterable)scanner);
                    int tabletsToWaitFor = 0;
                    int tabletCount = 0;
                    Text ert = ByteBufferUtil.toText((ByteBuffer)endRow);
                    while (ri.hasNext()) {
                        Iterator row = ri.next();
                        long tabletFlushID = -1L;
                        int logs = 0;
                        boolean online = false;
                        TServerInstance server = null;
                        Map.Entry entry = null;
                        while (row.hasNext()) {
                            entry = (Map.Entry)row.next();
                            Key key = (Key)entry.getKey();
                            if (Constants.METADATA_FLUSH_COLUMN.equals(key.getColumnFamily(), key.getColumnQualifier())) {
                                tabletFlushID = Long.parseLong(((Value)entry.getValue()).toString());
                            }
                            if (Constants.METADATA_LOG_COLUMN_FAMILY.equals((Object)key.getColumnFamily())) {
                                ++logs;
                            }
                            if (!Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY.equals((Object)key.getColumnFamily())) continue;
                            online = true;
                            server = new TServerInstance((Value)entry.getValue(), key.getColumnQualifier());
                        }
                        if ((online || logs > 0) && tabletFlushID < flushID) {
                            ++tabletsToWaitFor;
                            if (server != null) {
                                serversToFlush.add(server);
                            }
                        }
                        ++tabletCount;
                        Text tabletEndRow = new KeyExtent(((Key)entry.getKey()).getRow(), (Text)null).getEndRow();
                        if (tabletEndRow != null && (ert == null || tabletEndRow.compareTo((BinaryComparable)ert) < 0)) continue;
                        break;
                    }
                    if (tabletsToWaitFor == 0) break;
                    if (tabletCount != 0 || Tables.exists((Instance)Master.this.instance, (String)tableId)) continue;
                    throw new ThriftTableOperationException(tableId, null, TableOperation.FLUSH, TableOperationExceptionType.NOTFOUND, null);
                }
                catch (AccumuloException e) {
                    log.debug((Object)("Failed to scan !METADATA table to wait for flush " + tableId), (Throwable)e);
                    continue;
                }
                catch (TabletIterator.TabletDeletedException tde) {
                    log.debug((Object)("Failed to scan !METADATA table to wait for flush " + tableId), (Throwable)tde);
                    continue;
                }
                catch (AccumuloSecurityException e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                    throw new ThriftSecurityException();
                }
                catch (TableNotFoundException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new ThriftTableOperationException();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MasterMonitorInfo getMasterStats(TInfo info, TCredentials credentials) throws ThriftSecurityException, TException {
            MasterMonitorInfo result = new MasterMonitorInfo();
            result.tServerInfo = new ArrayList();
            result.tableMap = new DefaultMap(new TableInfo());
            for (Map.Entry serverEntry : Master.this.tserverStatus.entrySet()) {
                TabletServerStatus status = (TabletServerStatus)serverEntry.getValue();
                result.tServerInfo.add(status);
                for (Map.Entry entry : status.tableMap.entrySet()) {
                    String table = (String)entry.getKey();
                    TableInfo summary = (TableInfo)result.tableMap.get(table);
                    Monitor.add(summary, (TableInfo)entry.getValue());
                }
            }
            result.badTServers = new HashMap();
            Object i$ = Master.this.badServers;
            synchronized (i$) {
                for (TServerInstance bad : Master.this.badServers.keySet()) {
                    result.badTServers.put(bad.hostPort(), TabletServerState.UNRESPONSIVE.getId());
                }
            }
            result.state = Master.this.getMasterState();
            result.goalState = Master.this.getMasterGoalState();
            result.unassignedTablets = Master.this.displayUnassigned();
            result.serversShuttingDown = new HashSet();
            i$ = Master.this.serversToShutdown;
            synchronized (i$) {
                for (TServerInstance server : Master.this.serversToShutdown) {
                    result.serversShuttingDown.add(server.hostPort());
                }
            }
            DeadServerList obit = new DeadServerList(ZooUtil.getRoot((Instance)Master.this.instance) + "/dead/tservers");
            result.deadTabletServers = obit.getList();
            return result;
        }

        private void alterTableProperty(TCredentials c, String tableName, String property, String value, TableOperation op) throws ThriftSecurityException, ThriftTableOperationException {
            String tableId = this.checkTableId(tableName, op);
            if (!Master.this.security.canAlterTable(c, tableId)) {
                throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
            try {
                if (value == null) {
                    TablePropUtil.removeTableProperty(tableId, property);
                } else if (!TablePropUtil.setTableProperty(tableId, property, value)) {
                    throw new Exception("Invalid table property.");
                }
            }
            catch (KeeperException.NoNodeException e) {
                this.checkTableId(tableName, op);
                log.info((Object)"Error altering table property", (Throwable)e);
                throw new ThriftTableOperationException(tableId, tableName, op, TableOperationExceptionType.OTHER, "Problem altering table property");
            }
            catch (Exception e) {
                log.error((Object)"Problem altering table property", (Throwable)e);
                throw new ThriftTableOperationException(tableId, tableName, op, TableOperationExceptionType.OTHER, "Problem altering table property");
            }
        }

        public void removeTableProperty(TInfo info, TCredentials credentials, String tableName, String property) throws ThriftSecurityException, ThriftTableOperationException, TException {
            this.alterTableProperty(credentials, tableName, property, null, TableOperation.REMOVE_PROPERTY);
        }

        public void setTableProperty(TInfo info, TCredentials credentials, String tableName, String property, String value) throws ThriftSecurityException, ThriftTableOperationException, TException {
            this.alterTableProperty(credentials, tableName, property, value, TableOperation.SET_PROPERTY);
        }

        public void shutdown(TInfo info, TCredentials c, boolean stopTabletServers) throws ThriftSecurityException, TException {
            Master.this.security.canPerformSystemActions(c);
            Master.this.shutdown(stopTabletServers);
        }

        public void shutdownTabletServer(TInfo info, TCredentials c, String tabletServer, boolean force) throws ThriftSecurityException, TException {
            LiveTServerSet.TServerConnection server;
            Master.this.security.canPerformSystemActions(c);
            InetSocketAddress addr = org.apache.accumulo.server.util.AddressUtil.parseAddress(tabletServer, Property.TSERV_CLIENTPORT);
            String addrString = AddressUtil.toString((InetSocketAddress)addr);
            TServerInstance doomed = Master.this.tserverSet.find(addrString);
            if (!force && (server = Master.this.tserverSet.getConnection(doomed)) == null) {
                log.warn((Object)("No server found for name " + tabletServer));
                return;
            }
            long tid = Master.this.fate.startTransaction();
            Master.this.fate.seedTransaction(tid, new TraceRepo<Master>(new ShutdownTServer(doomed, force)), false);
            Master.this.fate.waitForCompletion(tid);
            Master.this.fate.delete(tid);
        }

        public void reportSplitExtent(TInfo info, TCredentials credentials, String serverName, TabletSplit split) throws TException {
            KeyExtent oldTablet = new KeyExtent(split.oldTablet);
            if (Master.this.migrations.remove(oldTablet) != null) {
                log.info((Object)("Canceled migration of " + split.oldTablet));
            }
            for (TServerInstance instance : Master.this.tserverSet.getCurrentServers()) {
                if (!serverName.equals(instance.hostPort())) continue;
                Master.this.nextEvent.event("%s reported split %s, %s", serverName, new KeyExtent((TKeyExtent)split.newTablets.get(0)), new KeyExtent((TKeyExtent)split.newTablets.get(1)));
                return;
            }
            log.warn((Object)("Got a split from a server we don't recognize: " + serverName));
        }

        public void reportTabletStatus(TInfo info, TCredentials credentials, String serverName, TabletLoadState status, TKeyExtent ttablet) throws TException {
            KeyExtent tablet = new KeyExtent(ttablet);
            switch (status) {
                case LOAD_FAILURE: {
                    log.error((Object)(serverName + " reports assignment failed for tablet " + tablet));
                    break;
                }
                case LOADED: {
                    Master.this.nextEvent.event("tablet %s was loaded on %s", tablet, serverName);
                    break;
                }
                case UNLOADED: {
                    Master.this.nextEvent.event("tablet %s was unloaded from %s", tablet, serverName);
                    break;
                }
                case UNLOAD_ERROR: {
                    log.error((Object)(serverName + " reports unload failed for tablet " + tablet));
                    break;
                }
                case UNLOAD_FAILURE_NOT_SERVING: {
                    if (!log.isTraceEnabled()) break;
                    log.trace((Object)(serverName + " reports unload failed: not serving tablet, could be a split: " + tablet));
                    break;
                }
                case CHOPPED: {
                    Master.this.nextEvent.event("tablet %s chopped", tablet);
                }
            }
        }

        public void setMasterGoalState(TInfo info, TCredentials c, MasterGoalState state) throws ThriftSecurityException, TException {
            Master.this.security.canPerformSystemActions(c);
            Master.this.setMasterGoalState(state);
        }

        private void updatePlugins(String property) {
            if (property.equals(Property.MASTER_TABLET_BALANCER.getKey())) {
                TabletBalancer balancer = Master.createInstanceFromPropertyName(Master.this.instance.getConfiguration(), Property.MASTER_TABLET_BALANCER, TabletBalancer.class, new DefaultLoadBalancer());
                balancer.init(Master.this.serverConfig);
                Master.this.tabletBalancer = balancer;
                log.info((Object)("tablet balancer changed to " + Master.this.tabletBalancer.getClass().getName()));
            }
        }

        public void removeSystemProperty(TInfo info, TCredentials c, String property) throws ThriftSecurityException, TException {
            Master.this.security.canPerformSystemActions(c);
            try {
                SystemPropUtil.removeSystemProperty(property);
                this.updatePlugins(property);
            }
            catch (Exception e) {
                log.error((Object)"Problem removing config property in zookeeper", (Throwable)e);
                throw new TException(e.getMessage());
            }
        }

        public void setSystemProperty(TInfo info, TCredentials c, String property, String value) throws ThriftSecurityException, TException {
            Master.this.security.canPerformSystemActions(c);
            try {
                SystemPropUtil.setSystemProperty(property, value);
                this.updatePlugins(property);
            }
            catch (Exception e) {
                log.error((Object)"Problem setting config property in zookeeper", (Throwable)e);
                throw new TException(e.getMessage());
            }
        }

        private void authenticate(TCredentials c) throws ThriftSecurityException {
            if (!Master.this.security.authenticateUser(c, c)) {
                throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.BAD_CREDENTIALS);
            }
        }

        public long beginTableOperation(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
            this.authenticate(credentials);
            return Master.this.fate.startTransaction();
        }

        public void executeTableOperation(TInfo tinfo, TCredentials c, long opid, org.apache.accumulo.core.master.thrift.TableOperation op, List<ByteBuffer> arguments, Map<String, String> options, boolean autoCleanup) throws ThriftSecurityException, ThriftTableOperationException, TException {
            this.authenticate(c);
            switch (op) {
                case CREATE: {
                    String tableName = ByteBufferUtil.toString((ByteBuffer)arguments.get(0));
                    if (!Master.this.security.canCreateTable(c)) {
                        throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                    }
                    Master.this.checkNotMetadataTable(tableName, TableOperation.CREATE);
                    Master.this.checkTableName(tableName, TableOperation.CREATE);
                    TimeType timeType = TimeType.valueOf((String)ByteBufferUtil.toString((ByteBuffer)arguments.get(1)));
                    Master.this.fate.seedTransaction(opid, new TraceRepo<Master>(new CreateTable(c.getPrincipal(), tableName, timeType, options)), autoCleanup);
                    break;
                }
                case RENAME: {
                    String oldTableName = ByteBufferUtil.toString((ByteBuffer)arguments.get(0));
                    String newTableName = ByteBufferUtil.toString((ByteBuffer)arguments.get(1));
                    String tableId = this.checkTableId(oldTableName, TableOperation.RENAME);
                    Master.this.checkNotMetadataTable(oldTableName, TableOperation.RENAME);
                    Master.this.checkNotMetadataTable(newTableName, TableOperation.RENAME);
                    Master.this.checkTableName(newTableName, TableOperation.RENAME);
                    if (!Master.this.security.canRenameTable(c, tableId)) {
                        throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                    }
                    Master.this.fate.seedTransaction(opid, new TraceRepo<Master>(new RenameTable(tableId, oldTableName, newTableName)), autoCleanup);
                    break;
                }
                case CLONE: {
                    String srcTableId = ByteBufferUtil.toString((ByteBuffer)arguments.get(0));
                    String tableName = ByteBufferUtil.toString((ByteBuffer)arguments.get(1));
                    Master.this.checkNotMetadataTable(tableName, TableOperation.CLONE);
                    Master.this.checkTableName(tableName, TableOperation.CLONE);
                    if (!Master.this.security.canCloneTable(c, srcTableId)) {
                        throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                    }
                    HashMap<String, String> propertiesToSet = new HashMap<String, String>();
                    HashSet<String> propertiesToExclude = new HashSet<String>();
                    for (Map.Entry<String, String> entry : options.entrySet()) {
                        if (entry.getValue() == null) {
                            propertiesToExclude.add(entry.getKey());
                            continue;
                        }
                        if (!TablePropUtil.isPropertyValid(entry.getKey(), entry.getValue())) {
                            throw new ThriftTableOperationException(null, tableName, TableOperation.CLONE, TableOperationExceptionType.OTHER, "Property or value not valid " + entry.getKey() + "=" + entry.getValue());
                        }
                        propertiesToSet.put(entry.getKey(), entry.getValue());
                    }
                    Master.this.fate.seedTransaction(opid, new TraceRepo<Master>(new CloneTable(c.getPrincipal(), srcTableId, tableName, propertiesToSet, propertiesToExclude)), autoCleanup);
                    break;
                }
                case DELETE: {
                    String tableName = ByteBufferUtil.toString((ByteBuffer)arguments.get(0));
                    String tableId = this.checkTableId(tableName, TableOperation.DELETE);
                    Master.this.checkNotMetadataTable(tableName, TableOperation.DELETE);
                    if (!Master.this.security.canDeleteTable(c, tableId)) {
                        throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                    }
                    Master.this.fate.seedTransaction(opid, new TraceRepo<Master>(new DeleteTable(tableId)), autoCleanup);
                    break;
                }
                case ONLINE: {
                    String tableName = ByteBufferUtil.toString((ByteBuffer)arguments.get(0));
                    String tableId = this.checkTableId(tableName, TableOperation.ONLINE);
                    Master.this.checkNotMetadataTable(tableName, TableOperation.ONLINE);
                    if (!Master.this.security.canOnlineOfflineTable(c, tableId)) {
                        throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                    }
                    Master.this.fate.seedTransaction(opid, new TraceRepo<Master>(new ChangeTableState(tableId, TableOperation.ONLINE)), autoCleanup);
                    break;
                }
                case OFFLINE: {
                    String tableName = ByteBufferUtil.toString((ByteBuffer)arguments.get(0));
                    String tableId = this.checkTableId(tableName, TableOperation.OFFLINE);
                    Master.this.checkNotMetadataTable(tableName, TableOperation.OFFLINE);
                    if (!Master.this.security.canOnlineOfflineTable(c, tableId)) {
                        throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                    }
                    Master.this.fate.seedTransaction(opid, new TraceRepo<Master>(new ChangeTableState(tableId, TableOperation.OFFLINE)), autoCleanup);
                    break;
                }
                case MERGE: {
                    String tableName = ByteBufferUtil.toString((ByteBuffer)arguments.get(0));
                    Text startRow = ByteBufferUtil.toText((ByteBuffer)arguments.get(1));
                    Text endRow = ByteBufferUtil.toText((ByteBuffer)arguments.get(2));
                    String tableId = this.checkTableId(tableName, TableOperation.MERGE);
                    if (tableName.equals("!METADATA") && startRow.compareTo((BinaryComparable)new Text("0")) < 0) {
                        startRow = new Text("0");
                        if (endRow.getLength() != 0 && endRow.compareTo((BinaryComparable)startRow) < 0) {
                            throw new ThriftTableOperationException(null, tableName, TableOperation.MERGE, TableOperationExceptionType.OTHER, "end-row specification is in the root tablet, which cannot be merged or split");
                        }
                    }
                    log.debug((Object)("Creating merge op: " + tableId + " " + startRow + " " + endRow));
                    if (!Master.this.security.canMerge(c, tableId)) {
                        throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                    }
                    Master.this.fate.seedTransaction(opid, new TraceRepo<Master>(new TableRangeOp(MergeInfo.Operation.MERGE, tableId, startRow, endRow)), autoCleanup);
                    break;
                }
                case DELETE_RANGE: {
                    String tableName = ByteBufferUtil.toString((ByteBuffer)arguments.get(0));
                    Text startRow = ByteBufferUtil.toText((ByteBuffer)arguments.get(1));
                    Text endRow = ByteBufferUtil.toText((ByteBuffer)arguments.get(2));
                    String tableId = this.checkTableId(tableName, TableOperation.DELETE_RANGE);
                    Master.this.checkNotMetadataTable(tableName, TableOperation.DELETE_RANGE);
                    if (!Master.this.security.canDeleteRange(c, tableId)) {
                        throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                    }
                    Master.this.fate.seedTransaction(opid, new TraceRepo<Master>(new TableRangeOp(MergeInfo.Operation.DELETE, tableId, startRow, endRow)), autoCleanup);
                    break;
                }
                case BULK_IMPORT: {
                    String tableName = ByteBufferUtil.toString((ByteBuffer)arguments.get(0));
                    String dir = ByteBufferUtil.toString((ByteBuffer)arguments.get(1));
                    String failDir = ByteBufferUtil.toString((ByteBuffer)arguments.get(2));
                    boolean setTime = Boolean.parseBoolean(ByteBufferUtil.toString((ByteBuffer)arguments.get(3)));
                    String tableId = this.checkTableId(tableName, TableOperation.BULK_IMPORT);
                    Master.this.checkNotMetadataTable(tableName, TableOperation.BULK_IMPORT);
                    if (!Master.this.security.canBulkImport(c, tableId)) {
                        throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                    }
                    Master.this.fate.seedTransaction(opid, new TraceRepo<Master>(new BulkImport(tableId, dir, failDir, setTime)), autoCleanup);
                    break;
                }
                case COMPACT: {
                    String tableId = ByteBufferUtil.toString((ByteBuffer)arguments.get(0));
                    byte[] startRow = ByteBufferUtil.toBytes((ByteBuffer)arguments.get(1));
                    byte[] endRow = ByteBufferUtil.toBytes((ByteBuffer)arguments.get(2));
                    List iterators = IteratorUtil.decodeIteratorSettings((byte[])ByteBufferUtil.toBytes((ByteBuffer)arguments.get(3)));
                    if (!Master.this.security.canCompact(c, tableId)) {
                        throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                    }
                    Master.this.fate.seedTransaction(opid, new TraceRepo<Master>(new CompactRange(tableId, startRow, endRow, iterators)), autoCleanup);
                    break;
                }
                case COMPACT_CANCEL: {
                    String tableId = ByteBufferUtil.toString((ByteBuffer)arguments.get(0));
                    if (!Master.this.security.canCompact(c, tableId)) {
                        throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                    }
                    Master.this.fate.seedTransaction(opid, new TraceRepo<Master>(new CancelCompactions(tableId)), autoCleanup);
                    break;
                }
                case IMPORT: {
                    String tableName = ByteBufferUtil.toString((ByteBuffer)arguments.get(0));
                    String exportDir = ByteBufferUtil.toString((ByteBuffer)arguments.get(1));
                    if (!Master.this.security.canImport(c)) {
                        throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                    }
                    Master.this.checkNotMetadataTable(tableName, TableOperation.CREATE);
                    Master.this.checkTableName(tableName, TableOperation.CREATE);
                    Master.this.fate.seedTransaction(opid, new TraceRepo<Master>(new ImportTable(c.getPrincipal(), tableName, exportDir)), autoCleanup);
                    break;
                }
                case EXPORT: {
                    String tableName = ByteBufferUtil.toString((ByteBuffer)arguments.get(0));
                    String exportDir = ByteBufferUtil.toString((ByteBuffer)arguments.get(1));
                    String tableId = this.checkTableId(tableName, TableOperation.EXPORT);
                    if (!Master.this.security.canExport(c, tableId)) {
                        throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                    }
                    Master.this.checkNotMetadataTable(tableName, TableOperation.EXPORT);
                    Master.this.fate.seedTransaction(opid, new TraceRepo<Master>(new ExportTable(tableName, tableId, exportDir)), autoCleanup);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        public String waitForTableOperation(TInfo tinfo, TCredentials credentials, long opid) throws ThriftSecurityException, ThriftTableOperationException, TException {
            this.authenticate(credentials);
            TStore.TStatus status = Master.this.fate.waitForCompletion(opid);
            if (status == TStore.TStatus.FAILED) {
                Exception e = Master.this.fate.getException(opid);
                if (e instanceof ThriftTableOperationException) {
                    throw (ThriftTableOperationException)e;
                }
                if (e instanceof ThriftSecurityException) {
                    throw (ThriftSecurityException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            String ret = Master.this.fate.getReturn(opid);
            if (ret == null) {
                ret = "";
            }
            return ret;
        }

        public void finishTableOperation(TInfo tinfo, TCredentials credentials, long opid) throws ThriftSecurityException, TException {
            this.authenticate(credentials);
            Master.this.fate.delete(opid);
        }
    }
}

