/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.util.MetricsRegistry;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingRate;
import org.apache.hadoop.util.StringUtils;

@Deprecated
@InterfaceAudience.Private
public class PersistentMetricsTimeVaryingRate
extends MetricsTimeVaryingRate {
    protected static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hbase.metrics");
    protected boolean reset = false;
    protected long lastOper = 0L;
    protected long totalOps = 0L;

    public PersistentMetricsTimeVaryingRate(String nam, MetricsRegistry registry, String description) {
        super(nam, registry, description);
    }

    public PersistentMetricsTimeVaryingRate(String nam, MetricsRegistry registry) {
        this(nam, registry, "NoDescription");
    }

    public synchronized void pushMetric(MetricsRecord mr) {
        super.pushMetric(mr);
        try {
            mr.setMetric(this.getName() + "_num_ops", this.totalOps);
        }
        catch (Exception e) {
            LOG.info((Object)("pushMetric failed for " + this.getName() + "\n" + StringUtils.stringifyException((Throwable)e)));
        }
        if (this.reset) {
            super.inc(this.getPreviousIntervalAverageTime());
            this.reset = false;
        } else {
            this.maintainStats();
        }
    }

    public synchronized void inc(int numOps, long time) {
        super.inc(numOps, time);
        this.totalOps += (long)numOps;
    }

    public synchronized void inc(long time) {
        super.inc(time);
        ++this.totalOps;
    }

    public synchronized void resetMinMaxAvg() {
        this.reset = true;
    }

    protected void maintainStats() {
        int curOps = this.getPreviousIntervalNumOps();
        if (curOps > 0) {
            long curTime = this.getPreviousIntervalAverageTime();
            long totalTime = curTime * (long)curOps;
            if (curTime == 0L || totalTime / curTime == (long)curOps) {
                super.inc(curOps, totalTime);
            } else {
                LOG.info((Object)("Stats for " + this.getName() + " overflowed! resetting"));
            }
        }
    }
}

