/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableRecordReaderImpl;
import org.apache.hadoop.hbase.mapreduce.TableSnapshotInputFormatImpl;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TableSnapshotInputFormat
extends InputFormat<ImmutableBytesWritable, Result> {
    private static final Log LOG = LogFactory.getLog(TableSnapshotInputFormat.class);

    public RecordReader<ImmutableBytesWritable, Result> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
        return new TableSnapshotRegionRecordReader();
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException, InterruptedException {
        ArrayList<InputSplit> results = new ArrayList<InputSplit>();
        for (TableSnapshotInputFormatImpl.InputSplit split : TableSnapshotInputFormatImpl.getSplits(job.getConfiguration())) {
            results.add(new TableSnapshotRegionSplit(split));
        }
        return results;
    }

    public static void setInput(Job job, String snapshotName, Path restoreDir) throws IOException {
        TableSnapshotInputFormatImpl.setInput(job.getConfiguration(), snapshotName, restoreDir);
    }

    @VisibleForTesting
    static class TableSnapshotRegionRecordReader
    extends RecordReader<ImmutableBytesWritable, Result> {
        private TableSnapshotInputFormatImpl.RecordReader delegate = new TableSnapshotInputFormatImpl.RecordReader();
        private TaskAttemptContext context;
        private Method getCounter;

        TableSnapshotRegionRecordReader() {
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            this.context = context;
            this.getCounter = TableRecordReaderImpl.retrieveGetCounterWithStringsParams(context);
            this.delegate.initialize(((TableSnapshotRegionSplit)split).delegate, context.getConfiguration());
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            ScanMetrics scanMetrics;
            boolean result = this.delegate.nextKeyValue();
            if (result && (scanMetrics = this.delegate.getScanner().getScanMetrics()) != null && this.context != null) {
                TableRecordReaderImpl.updateCounters(scanMetrics, 0L, this.getCounter, this.context);
            }
            return result;
        }

        public ImmutableBytesWritable getCurrentKey() throws IOException, InterruptedException {
            return this.delegate.getCurrentKey();
        }

        public Result getCurrentValue() throws IOException, InterruptedException {
            return this.delegate.getCurrentValue();
        }

        public float getProgress() throws IOException, InterruptedException {
            return this.delegate.getProgress();
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }

    public static class TableSnapshotRegionSplit
    extends InputSplit
    implements Writable {
        private TableSnapshotInputFormatImpl.InputSplit delegate;

        public TableSnapshotRegionSplit() {
            this.delegate = new TableSnapshotInputFormatImpl.InputSplit();
        }

        public TableSnapshotRegionSplit(TableSnapshotInputFormatImpl.InputSplit delegate) {
            this.delegate = delegate;
        }

        public TableSnapshotRegionSplit(HTableDescriptor htd, HRegionInfo regionInfo, List<String> locations) {
            this.delegate = new TableSnapshotInputFormatImpl.InputSplit(htd, regionInfo, locations);
        }

        public long getLength() throws IOException, InterruptedException {
            return this.delegate.getLength();
        }

        public String[] getLocations() throws IOException, InterruptedException {
            return this.delegate.getLocations();
        }

        public void write(DataOutput out) throws IOException {
            this.delegate.write(out);
        }

        public void readFields(DataInput in) throws IOException {
            this.delegate.readFields(in);
        }
    }
}

