/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.NoOpDataBlockEncoder;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class HFileDataBlockEncoderImpl
implements HFileDataBlockEncoder {
    private final DataBlockEncoding encoding;

    public HFileDataBlockEncoderImpl(DataBlockEncoding encoding) {
        this.encoding = encoding != null ? encoding : DataBlockEncoding.NONE;
    }

    public static HFileDataBlockEncoder createFromFileInfo(HFile.FileInfo fileInfo) throws IOException {
        DataBlockEncoding encoding = DataBlockEncoding.NONE;
        byte[] dataBlockEncodingType = fileInfo.get(DATA_BLOCK_ENCODING);
        if (dataBlockEncodingType != null) {
            String dataBlockEncodingStr = Bytes.toString((byte[])dataBlockEncodingType);
            try {
                encoding = DataBlockEncoding.valueOf((String)dataBlockEncodingStr);
            }
            catch (IllegalArgumentException ex) {
                throw new IOException("Invalid data block encoding type in file info: " + dataBlockEncodingStr, ex);
            }
        }
        if (encoding == DataBlockEncoding.NONE) {
            return NoOpDataBlockEncoder.INSTANCE;
        }
        return new HFileDataBlockEncoderImpl(encoding);
    }

    @Override
    public void saveMetadata(HFile.Writer writer) throws IOException {
        writer.appendFileInfo(DATA_BLOCK_ENCODING, this.encoding.getNameInBytes());
    }

    @Override
    public DataBlockEncoding getDataBlockEncoding() {
        return this.encoding;
    }

    @Override
    public void beforeWriteToDisk(ByteBuffer in, HFileBlockEncodingContext encodeCtx, BlockType blockType) throws IOException {
        if (this.encoding == DataBlockEncoding.NONE) {
            ((HFileBlockDefaultEncodingContext)encodeCtx).compressAfterEncodingWithBlockType(in.array(), blockType);
            return;
        }
        this.encodeBufferToHFileBlockBuffer(in, this.encoding, encodeCtx);
    }

    @Override
    public boolean useEncodedScanner() {
        return this.encoding != DataBlockEncoding.NONE;
    }

    private void encodeBufferToHFileBlockBuffer(ByteBuffer in, DataBlockEncoding algo, HFileBlockEncodingContext encodeCtx) {
        DataBlockEncoder encoder = algo.getEncoder();
        try {
            encoder.encodeKeyValues(in, encodeCtx);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Bug in data block encoder '%s', it probably requested too much data, exception message: %s.", algo.toString(), e.getMessage()), e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(encoding=" + this.encoding + ")";
    }

    @Override
    public HFileBlockEncodingContext newDataBlockEncodingContext(byte[] dummyHeader, HFileContext fileContext) {
        DataBlockEncoder encoder = this.encoding.getEncoder();
        if (encoder != null) {
            return encoder.newDataBlockEncodingContext(this.encoding, dummyHeader, fileContext);
        }
        return new HFileBlockDefaultEncodingContext(null, dummyHeader, fileContext);
    }

    @Override
    public HFileBlockDecodingContext newDataBlockDecodingContext(HFileContext fileContext) {
        DataBlockEncoder encoder = this.encoding.getEncoder();
        if (encoder != null) {
            return encoder.newDataBlockDecodingContext(fileContext);
        }
        return new HFileBlockDefaultDecodingContext(fileContext);
    }
}

