/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pen.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.newplan.DepthFirstWalker;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.PlanWalker;

public class PreOrderDepthFirstWalker
extends PlanWalker {
    private boolean branchFlag = false;

    public PreOrderDepthFirstWalker(OperatorPlan plan) {
        super(plan);
    }

    public void setBranchFlag() {
        this.branchFlag = true;
    }

    public boolean getBranchFlag() {
        return this.branchFlag;
    }

    @Override
    public void walk(PlanVisitor visitor) throws FrontendException {
        List<Operator> leaves = this.plan.getSinks();
        HashSet<Operator> seen = new HashSet<Operator>();
        this.depthFirst(null, leaves, seen, visitor);
    }

    @Override
    public PlanWalker spawnChildWalker(OperatorPlan plan) {
        return new DepthFirstWalker(plan);
    }

    private void depthFirst(Operator node, Collection<Operator> predecessors, Set<Operator> seen, PlanVisitor visitor) throws FrontendException {
        if (predecessors == null) {
            return;
        }
        boolean thisBranchFlag = this.branchFlag;
        for (Operator pred : predecessors) {
            if (!seen.add(pred)) continue;
            this.branchFlag = thisBranchFlag;
            pred.accept(visitor);
            Collection<Operator> newPredecessors = Utils.mergeCollection(this.plan.getPredecessors(pred), this.plan.getSoftLinkPredecessors(pred));
            this.depthFirst(pred, newPredecessors, seen, visitor);
        }
    }
}

