/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.visitor;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.FuncSpec;
import org.apache.pig.impl.builtin.IdentityColumn;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.UserFuncExpression;
import org.apache.pig.newplan.logical.optimizer.SchemaResetter;
import org.apache.pig.newplan.logical.optimizer.UidResetter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class DuplicateForEachColumnRewriteVisitor
extends LogicalRelationalNodesVisitor {
    public DuplicateForEachColumnRewriteVisitor(OperatorPlan plan) throws FrontendException {
        super(plan, new DependencyOrderWalker(plan));
    }

    @Override
    public void visit(LOForEach foreach) throws FrontendException {
        List<LogicalExpressionPlan> expPlansToInsertIdentity = this.findAllExpPlansToInsertIdentity(foreach);
        if (expPlansToInsertIdentity.isEmpty()) {
            return;
        }
        for (LogicalExpressionPlan expPlan : expPlansToInsertIdentity) {
            LogicalExpression oldRoot = (LogicalExpression)expPlan.getSources().get(0);
            UserFuncExpression userFuncExpression = new UserFuncExpression(expPlan, new FuncSpec(IdentityColumn.class.getName()));
            expPlan.connect(userFuncExpression, oldRoot);
        }
        expPlansToInsertIdentity.clear();
        UidResetter uidResetter = new UidResetter(this.plan);
        uidResetter.visit();
        SchemaResetter schemaResetter = new SchemaResetter(this.plan, true);
        schemaResetter.visit();
    }

    private List<LogicalExpressionPlan> findAllExpPlansToInsertIdentity(LOForEach foreach) throws FrontendException {
        LOGenerate gen = (LOGenerate)foreach.getInnerPlan().getSinks().get(0);
        List<LogicalExpressionPlan> expPlans = gen.getOutputPlans();
        boolean[] flattens = gen.getFlattenFlags();
        ArrayList<LogicalExpressionPlan> expPlansToInsertIdentity = new ArrayList<LogicalExpressionPlan>();
        ArrayList<Long> uidSeen = new ArrayList<Long>();
        block0: for (int i = 0; i < expPlans.size(); ++i) {
            LogicalExpressionPlan expPlan = expPlans.get(i);
            boolean flatten = flattens[i];
            LogicalExpression exp = (LogicalExpression)expPlan.getSources().get(0);
            if (exp.getFieldSchema() == null) continue;
            if (flatten && (exp.getFieldSchema().type == 120 || exp.getFieldSchema().type == 110)) {
                List<LogicalSchema.LogicalFieldSchema> innerFieldSchemas = null;
                if (exp.getFieldSchema().type == 120) {
                    if (exp.getFieldSchema().schema != null) {
                        if (exp.getFieldSchema().type == 120) {
                            if (exp.getFieldSchema().schema.getField((int)0).schema != null) {
                                innerFieldSchemas = exp.getFieldSchema().schema.getField((int)0).schema.getFields();
                            }
                        } else if (exp.getFieldSchema().schema != null) {
                            innerFieldSchemas = exp.getFieldSchema().schema.getFields();
                        }
                    }
                } else if (exp.getFieldSchema().schema != null) {
                    innerFieldSchemas = exp.getFieldSchema().schema.getFields();
                }
                if (innerFieldSchemas == null) continue;
                for (LogicalSchema.LogicalFieldSchema innerFieldSchema : innerFieldSchemas) {
                    long uid = innerFieldSchema.uid;
                    if (!this.checkAndAdd(uid, uidSeen)) continue;
                    expPlansToInsertIdentity.add(expPlan);
                    continue block0;
                }
                continue;
            }
            long uid = exp.getFieldSchema().uid;
            if (!this.checkAndAdd(uid, uidSeen)) continue;
            expPlansToInsertIdentity.add(expPlan);
        }
        return expPlansToInsertIdentity;
    }

    private boolean checkAndAdd(long uid, List<Long> uidSeen) {
        if (uidSeen.contains(uid)) {
            return true;
        }
        uidSeen.add(uid);
        return false;
    }
}

